/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.codeassist;

import de.jcup.eclipse.commons.WhitespaceWordStartDetector;
import de.jcup.eclipse.commons.WordStartDetector;
import de.jcup.eclipse.commons.codeassist.PrefixCalculator;

public class DefaultPrefixCalculator
implements PrefixCalculator {
    private WordStartDetector wordStartDetector;

    public DefaultPrefixCalculator() {
        this(new WhitespaceWordStartDetector());
    }

    public DefaultPrefixCalculator(WordStartDetector wordStartDetector) {
        this.wordStartDetector = wordStartDetector;
    }

    @Override
    public String calculate(String source, int offset) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (offset <= 0) {
            return "";
        }
        int sourceLength = source.length();
        if (offset > sourceLength) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int current = offset - 1;
        boolean ongoing = false;
        while (current >= 0) {
            char c;
            boolean bl = ongoing = !this.wordStartDetector.isWordStart(c = source.charAt(current--));
            if (ongoing) {
                sb.insert(0, c);
            }
            if (ongoing) continue;
        }
        return sb.toString();
    }
}

