/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons;

import de.jcup.eclipse.commons.WhitespaceWordEndDetector;
import de.jcup.eclipse.commons.WordEndDetector;

public class SimpleStringUtils {
    private static final String EMPTY = "";

    public static boolean equals(String text1, String text2) {
        if (text1 == null) {
            return text2 == null;
        }
        if (text2 == null) {
            return false;
        }
        return text2.equals(text1);
    }

    public static String trimRight(String line) {
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return EMPTY;
        }
        char[] chars = line.toCharArray();
        int i = -1;
        int j = chars.length - 1;
        while (j >= 0) {
            if (!Character.isWhitespace(chars[j])) {
                i = j;
                break;
            }
            --j;
        }
        if (i == -1) {
            return EMPTY;
        }
        return line.substring(0, i + 1);
    }

    public static String shortString(String string, int max) {
        if (max == 0) {
            return EMPTY;
        }
        if (string == null) {
            return EMPTY;
        }
        if (string.length() <= max) {
            return string;
        }
        if (max == 1) {
            return ".";
        }
        if (max == 2) {
            return "..";
        }
        if (max == 3) {
            return "...";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(string.substring(0, max - 3));
        sb.append("...");
        return sb.toString();
    }

    public static String nextReducedVariableWord(String string, int offset, WordEndDetector reducedVariableWordDetector) {
        return SimpleStringUtils.nextWord(string, offset, reducedVariableWordDetector);
    }

    public static String nextWord(String string, int offset, WordEndDetector wordEndDetector) {
        if (string == null) {
            return EMPTY;
        }
        if (offset < 0) {
            return EMPTY;
        }
        if (offset >= string.length()) {
            return EMPTY;
        }
        char c2 = string.charAt(offset);
        if (Character.isWhitespace(c2)) {
            return EMPTY;
        }
        if (wordEndDetector == null) {
            wordEndDetector = new WhitespaceWordEndDetector();
        }
        int start = offset;
        while (start > 0) {
            char c = string.charAt(start);
            if (wordEndDetector.isWordEnd(c)) {
                ++start;
                break;
            }
            --start;
        }
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < string.length()) {
            boolean isNotStartOfDocument;
            char c = string.charAt(i);
            boolean bl = isNotStartOfDocument = i != 0;
            if (wordEndDetector.isWordEnd(c)) {
                if (isNotStartOfDocument) {
                    break;
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }
}

