Rust is a **statically-typed** language, which means that every variable must have a specific type. Rust's type system is designed to be safe and to prevent many common errors that occur in other languages. In this challenge, you will learn about some of the basic primitive data types in Rust, such as integers, floating-point numbers, booleans, and characters.

Understanding how to declare and use these basic data types is fundamental to writing effective Rust code. This challenge will guide you through defining variables with specific types and initializing them.

## Your task

1. Define variable `x` with type `u8`
2. Define variable `y` with type `f64`
3. Define variable `z` with type `bool`
4. Define variable `a` with type `char`

Each of these variables **should be annotated** with their respective types and initialized with specific **values of your choice**.

## Requirements

- Every variable **must be annotated** with its type.
- Initialize each variable with any value of your choice of the correct type.

## Explanation of Data Types

- **Integer** `(u8)`: Represents an `8-bit` unsigned integer.
- **Floating-point number** `(f64)`: Represents a `64-bit` **floating-point number**.
- **Boolean** `(bool)`: Represents a `boolean` value, which can be either `true` or `false`.
- **Character** `(char)`: Represents a single Unicode **scalar** value.

## Hints

- Use the `let` keyword to define a variable.
- Annotate the variable's type by specifying `let variable_name: type = `.
