from pathlib import Path

from PIL import Image

from ascii_art import image_to_ascii

einstein = f"""??*??**???**?????????????;?;;;;?*#??**%#####@@###@@@@@@@@@##@#######SS****S###??*?.                 
?**??**??*?????????????;??;;,?*S#?;*%####@@@@@@@@@@@@@@@@@@@@@@######%#SS*S####*?*;.                
***?***???????????????;;??;??*S%??*S%#@@@@@@@@@@@@@@@@@@@@@@@@@@######%##SS%####***.                
********???????????;;;;;;;??***??**S##@@@@@@@@@@@@@@@@@@@@@@@@##@@#######%S%####*?S?:               
********??????????;;,,;?????*??;?**S##@@@@@@@@@@@@@@@@@@@@@@@@@@#########%SS#####*???,.             
******??*????????;;;;;?*****??;?**S##@@@@@@@@@@@@@@@@@@@@@@@@@##@#########%S%#####*?.,,:            
****?**????????;;;;;?*%*??????;?*%%%#@@@@@@@@@@@@@@@@@@@@@@@@@@@###########%######**:. :,           
***??**???????;;;;,;*S?????;?*,?**%S*##@@@@@@@@@@@@@@@@@@@@@@@@@@############@@###**?   :,          
*****?*????????;;;;?*;???*?;**,?*;:.,?*#@@@@@@@@@@@@#****##%##@@@#####@#######@#%*S*?,.  ,,         
******?*??????;;,,;*;,??**;?**:??.,;?S##@@@@@@@@@@@@###*??***S@@@################***?;?,..:.        
#********??????;,;?*;,??*?;?S*.??*S#%##@@@@@@@@@@@@@@@@###@@@@@@######@#####@@@##***?;,;..:,.       
********???????;;;??;;***?;*#*:?S########@@@@@@@@@@@@@@@@@@@@@@@#####@@#####@@@#S****?;,,. ..       
?#*?*?***?????;;;;,;,;***;;?*?:*#@##S%####@@@@@@@@@@@@@@@@@@@@@@#############@###S**?*??;,          
*S***?**????;;;;,,,::;*??;;?*;;S@#%****##**#@@@@@@@@@##%***S#@@@####@@@#####@@@####*??**??,         
#******?????;;;,::..:;*?;;;?*:;%#*?;?**###?*@@@@@@@@###**S#**#@@@#S#@@@@#####@@@@##S******?.        
#**?**?????;;,:......,*;;,;*?.?S*;?##??**#*;#@@@@@###****?**S*#@@#%##########@@@####*****??*,       
*#**??????;;,.... ...;*,;;;S?:?**?*@,.,*#**;#@@@@###SS@#;,.?*%#@############@@@@##**%*?***?;?;      
?***????;;,,:... ...,?*,;;;*;,?*%??*?,?%*%?*#@@@##@#%##%:..S*%###@###############%S********?,.;.    
*#?????;;,,:... ..:;:??.,,,?,;?*????**#%#S;S@@@#####SS*******####@@############*SS********?*?..,    
*#?;;??;;;,:......::.??.:::;:?*?*S***###*,;#@@###########%%#%##%#@@###########S***SS*S*?**??*; ..   
**;;;,,;;;,:.. ,....,?;..::..?*?*SS##SS#*:?#######@@@############@@#####%####SS#*??*SSS**S*;??. .   
**..:,,,,;,... :. .:?:,:... .?***#######;;S#######@@@@@##@##########S##%S###S***#*;??**S**S*;?: ..  
*?   .:,,.:... ....;::,..;...?########@*;*#####S###@@@@@@@@@@#@@####%##SSSSSSS**#%**;?**%S#***?. .  
*?    ..,:.... ..:;:.:...;...*#@####@@%?*######*S#@@@@@@@@@@@@@@@@##%SSSS*?*S**##S**??**###S***,.   
*,      ...... .,,,......,...*#@@#####*?##@@@@#S*S#@@@@@@@@@@@@@@@##SS*S**?**##@@##?S**%####*%%;,.  
,.         .....,:.. ...,,...*#@#####@??#@@@@@@#S%*#@@@@@@@@@@@@@@##***S*??*#@@@@#####?*#@##**#?,.. 
:.           .... ........:..?#####@@%;;#@@@@@###@#S#@@@@@@@@@@@@@##***S****#@@@@##@#@**@@@#**#*;.. 
?,.           ............,..?%%S#@@@?,,?#@@#####@@*#@#@@@@@@@@@@@##**SS****%##@#SS@@#%*@@@#**#*?:, 
?;.               .:...,,;;..?S*S#@@#%*;:?*S%S####%%@@@#@@@@@@@@@###**S*****#@##S###@#SS@@##*?S*;,. 
*;....             .,;;??;,..***#@@#####**####@@@##@@@@##@@@@@@@@@##**S***?#@@##*#####*#@@##??S*;,. 
?,..?S,.:. :.         . ..:..**?######@@@@@@##@@##@@######@@@@@@@@@#**S****#@@*****###%#@##%?*S?:, .
?;   ,,.:. .            ,,,..*S?SS#####@#@@@#@@@@@@@#######@@@#@@@##**S****@##*?******###@S**S?:....
?;          .          .::. .?%?***###@@##@@@@@@#####@@####@@@@@@@#%**S#S?#@##*?;;S**%#*?#S*?,..  ..
,     .?:,. .         .....  ?*******%###@##################@@@@@@#S**##**?S#?:...?****,;*?:   .....
.      ..:.           ...... ,**S#??;?********#***S*S########@@@@@#%**##**,..      .,,. .?, ........
.                    ....... :***##*;,,,????;???***?*?**####@@@@@@#%?##%*?,              ...........
                     .........?S?#@@S?;?***S***S%S**;:,**###@##@@@#**##*?:               ..........;
                   ...........;S**@@#S;*SS##S######*,,*S##S#@##@@@#*##S;.              .  ...... .;?
                   ............?#*#@@#:*###%S%%*##*??*##@#%@###@@@#*##?                  .....  :;??
                  .............:*S*@@#:S@##%%SS*##?***#@@##@##@@@@*##;               . ... .. .,;???
                ................;#*#@#:*####S**S@*?**%@@@@####@@@#S#,                  . ..  .,;????
            .....................*#S@@,?###%S**%#??*S@##@@@@S#@@#**.              .       . .;;???;;
         .:,;,,,:................:#*@@?;#@#SS**#*?*S###@@@@#S@@#?,                        .,??????;;
       .,;?;;;;,:.................?*#@?.*##*#**#?*###@@@@@@##@#?                     .   .,;???????;
     .;???;;;;;;,,..........:::....?*##.;##SS*#*?###@@@@@@#S@#?              .          .,;???;????;
   .;??;;;;;???;;,:........:::,:...:;*#*.*#S%#*?#@@@@@@@@@##%,                       . .;?????;??;;:
 .;????;????????;,,......:::,,:,:...:,*#;,*S#S?#@@@@@@@@@#*?               ..         .;????????;;:.
,;??????????????;;;:....:::,,,,::.....:*#,:???#@@@@@@@@@#?.               ......     :;;???????;,,..
??????????????????;,::::::,,,,,:::.....:**??*#@@@@@@@@#*:         ..    .........   ,;????;????;,...
??????????????????;:.::::,,,,,:::::.....,*###@@#@@@@@*,         .  ..  .........   :;????;;???;;. .,
"""  # noqa: F541,W291


def test_image_to_ascii():
    image = Image.open("examples/images/einstein.jpg")
    params = {
        "width": 100,
        "height": 50,
        "font": str(Path(__file__).parent / "Menlo.ttc"),
        "normalize": True,
        "invert": True,
    }
    ascii = image_to_ascii(image, **params)
    assert ascii == einstein
