// coverage:ignore-file
// GENERATED CODE - DO NOT MODIFY BY HAND
// ignore_for_file: type=lint
// ignore_for_file: invalid_annotation_target
part of openai_realtime_schema;

// ==========================================
// CLASS: Response
// ==========================================

/// The response resource.
@freezed
class Response with _$Response {
  const Response._();

  /// Factory constructor for Response
  const factory Response({
    /// The unique ID of the response.
    required String id,

    /// The object type, must be "realtime.response".
    @Default(ObjectType.realtimeResponse) ObjectType object,

    /// The status of the response.
    required ResponseStatus status,

    /// Additional details about the status.
    /// Any of: [ResponseStatusDetailsCancelled], [ResponseStatusDetailsIncomplete], [ResponseStatusDetailsFailed]
    @JsonKey(name: 'status_details', includeIfNull: false)
    ResponseStatusDetails? statusDetails,

    /// The list of output items generated by the response.
    required List<Item> output,

    /// Usage statistics for the Response, this will correspond to billing. A Realtime API session will
    /// maintain a conversation context and append new Items to the Conversation, thus output from
    /// previous turns (text and audio tokens) will become the input for later turns.
    @JsonKey(includeIfNull: false) Usage? usage,
  }) = _Response;

  /// Object construction from a JSON representation
  factory Response.fromJson(Map<String, dynamic> json) =>
      _$ResponseFromJson(json);

  /// List of all property names of schema
  static const List<String> propertyNames = [
    'id',
    'object',
    'status',
    'status_details',
    'output',
    'usage'
  ];

  /// Perform validations on the schema property values
  String? validateSchema() {
    return null;
  }

  /// Map representation of object (not serialized)
  Map<String, dynamic> toMap() {
    return {
      'id': id,
      'object': object,
      'status': status,
      'status_details': statusDetails,
      'output': output,
      'usage': usage,
    };
  }
}
