# Text embedding models

The Embeddings class is a class designed for interfacing with text embedding
models. There are lots of embedding model providers (OpenAI, Cohere, Hugging
Face, etc) - this class is designed to provide a standard interface for all of
them.

Embeddings create a vector representation of a piece of text. This is useful
because it means we can think about text in the vector space, and do things like
semantic search where we look for pieces of text that are most similar in the
vector space.

The base Embeddings class in LangChain exposes two methods: one for embedding
documents and one for embedding a query. The former takes as input multiple
texts, while the latter takes a single text. The reason for having these as two
separate methods is that some embedding providers have different embedding
methods for documents (to be searched over) vs queries (the search query
itself).

## Get started

### Setup

We are going to be using `OpenAIEmbeddings` for this example.

```dart
final openaiApiKey = Platform.environment['OPENAI_API_KEY'];
final embeddings = OpenAIEmbeddings(apiKey: openaiApiKey);
```

### Embedding documents

```dart
final res = await embeddings.embedDocuments(['Hello world', 'Bye bye']);
```

### Embedding a query

```dart
final res = await embeddings.embedQuery('Hello world');
```
