# MistralAIEmbeddings

Wrapper around [Mistral AI](https://mistral.ai/) Embeddings API.

Mistral AI brings the strongest open generative models to the developers, along with efficient ways to deploy and customise them for production.

> Note: Mistral AI API is currently in closed beta. You can request access [here](https://console.mistral.ai).

## Setup

To use `MistralAIEmbeddings` you need to have a Mistral AI account and an API key. You can get one [here](https://console.mistral.ai/users/).

The following models are available at the moment:
- `mistral-embed`: an embedding model with a 1024 embedding dimensions designed with retrieval capabilities in mind. It achieves a retrieval score of 55.26 on MTEB.

## Usage

```dart
final embeddings = MistralAIEmbeddings(apiKey: 'apiKey');
const text = 'This is a test document.';
final res = await embeddings.embedQuery(text);
final res = await embeddings.embedDocuments([text]);
```
