- [![Code Assist AI](https://img.shields.io/badge/AI-Code%20Assist-EB9FDA)](https://app.commanddash.io/agent?github=https://github.com/davidmigloz/langchain_dart)
- [Get started](README.md)
  - [Installation](/get_started/installation.md)
  - [Quickstart](/get_started/quickstart.md)
  - [Security](/get_started/security.md)
- [LangChain Expression Language](/expression_language/expression_language.md)
  - [Get started](/expression_language/get_started.md)
  - [Runnable interface](/expression_language/interface.md)
  - [Primitives](/expression_language/primitives.md)
    - [Sequence: Chaining runnables](/expression_language/primitives/sequence.md)
    - [Map: Formatting inputs & concurrency](/expression_language/primitives/map.md)
    - [Passthrough: Passing inputs through](/expression_language/primitives/passthrough.md)
    - [Mapper: Mapping inputs](/expression_language/primitives/mapper.md)
    - [Function: Run custom logic](/expression_language/primitives/function.md)
    - [Binding: Configuring runnables](/expression_language/primitives/binding.md)
    - [Router: Routing inputs](/expression_language/primitives/router.md)
    - [Retry: Retrying runnables](/expression_language/primitives/retry.md)
  - [Streaming](/expression_language/streaming.md)
  - [Fallbacks](/expression_language/fallbacks.md)
  - Cookbook
    - [Prompt + LLM](/expression_language/cookbook/prompt_llm_parser.md)
    - [Multiple chains](/expression_language/cookbook/multiple_chains.md)
    - [Adding memory](/expression_language/cookbook/adding_memory.md)
    - [Retrieval](/expression_language/cookbook/retrieval.md)
    - [Using Tools](/expression_language/cookbook/tools.md)
- [Modules](/modules/modules.md)
  - [Model IO](/modules/model_io/model_io.md)
    - [Prompts](/modules/model_io/prompts/prompts.md)
      - [Prompt Templates](/modules/model_io/prompts/prompt_templates/prompt_templates.md)
        - [Connecting to a Feature Store](/modules/model_io/prompts/prompt_templates/connecting_to_a_feature_store.md)
        - [Custom prompt template](/modules/model_io/prompts/prompt_templates/custom_prompt_template.md)
        - [Few-shot prompt templates](/modules/model_io/prompts/prompt_templates/few_shot_examples.md)
        - [Format template output](/modules/model_io/prompts/prompt_templates/format_output.md)
        - [Template formats](/modules/model_io/prompts/prompt_templates/formats.md)
        - [Types of MessagePromptTemplate](/modules/model_io/prompts/prompt_templates/msg_prompt_templates.md)
        - [Partial prompt templates](/modules/model_io/prompts/prompt_templates/partial.md)
        - [Composition](/modules/model_io/prompts/prompt_templates/prompt_composition.md)
        - [Serialization](/modules/model_io/prompts/prompt_templates/prompt_serialization.md)
        - [Validate template](/modules/model_io/prompts/prompt_templates/validate.md)
      - [Example selectors](/modules/model_io/prompts/example_selectors/example_selectors.md)
    - [Language models](/modules/model_io/models/models.md)
      - [LLMs](/modules/model_io/models/llms/llms.md)
        - How-to
          - [Custom LLM](/modules/model_io/models/llms/how_to/custom_llm.md)
          - [Fake LLM](/modules/model_io/models/llms/how_to/fake_llm.md)
          - [Human input LLM](/modules/model_io/models/llms/how_to/human_input_llm.md)
          - [Caching](/modules/model_io/models/llms/how_to/llm_caching.md)
          - [Serialization](/modules/model_io/models/llms/how_to/llm_serialization.md)
          - [Streaming](/modules/model_io/models/llms/how_to/llm_streaming.md)
          - [Tracking token usage](/modules/model_io/models/llms/how_to/token_usage_tracking.md)
        - Integrations
          - [OpenAI](/modules/model_io/models/llms/integrations/openai.md)
          - [GCP Vertex AI](/modules/model_io/models/llms/integrations/gcp_vertex_ai.md)
          - [Ollama](/modules/model_io/models/llms/integrations/ollama.md)
      - [Chat Models](/modules/model_io/models/chat_models/chat_models.md)
        - How-to
          - [Prompts](/modules/model_io/models/chat_models/how_to/prompts.md)
          - [Streaming](/modules/model_io/models/chat_models/how_to/streaming.md)
          - [Tool calling](/modules/model_io/models/chat_models/how_to/tools.md)
          - [LLMChain](/modules/model_io/models/chat_models/how_to/llm_chain.md)
        - Integrations
          - [Anthropic](/modules/model_io/models/chat_models/integrations/anthropic.md) 
          - [OpenAI](/modules/model_io/models/chat_models/integrations/openai.md)
          - [Firebase Vertex AI](/modules/model_io/models/chat_models/integrations/firebase_vertex_ai.md)
          - [GCP Vertex AI](/modules/model_io/models/chat_models/integrations/gcp_vertex_ai.md)
          - [Google AI](/modules/model_io/models/chat_models/integrations/googleai.md)
          - [Ollama](/modules/model_io/models/chat_models/integrations/ollama.md)
          - [Mistral AI](/modules/model_io/models/chat_models/integrations/mistralai.md)
          - [OpenRouter](/modules/model_io/models/chat_models/integrations/open_router.md)
          - [Together AI](/modules/model_io/models/chat_models/integrations/together_ai.md)
          - [Anyscale](/modules/model_io/models/chat_models/integrations/anyscale.md)
          - [Prem App](/modules/model_io/models/chat_models/integrations/prem.md)
    - [Output parsers](/modules/model_io/output_parsers/output_parsers.md)
      - [String output parser](/modules/model_io/output_parsers/string.md)
      - [JSON output parser](/modules/model_io/output_parsers/json.md)
      - [Tools output parser](/modules/model_io/output_parsers/tools.md)
  - [Retrieval](/modules/retrieval/retrieval.md)
    - [Document loaders](/modules/retrieval/document_loaders/document_loaders.md)
      - How-to
        - [Text](/modules/retrieval/document_loaders/how_to/text.md)
        - [JSON](/modules/retrieval/document_loaders/how_to/json.md)
        - [Web page](/modules/retrieval/document_loaders/how_to/web.md)
    - [Document transformers](/modules/retrieval/document_transformers/document_transformers.md)
      - Text splitters
        - [Split by character](/modules/retrieval/document_transformers/text_splitters/character_text_splitter.md)
        - [Recursively split by character](/modules/retrieval/document_transformers/text_splitters/recursive_character_text_splitter.md)
        - [Split code](/modules/retrieval/document_transformers/text_splitters/code_text_splitter.md)
    - [Text embedding models](/modules/retrieval/text_embedding/text_embedding.md)
      - Integrations
        - [OpenAI](/modules/retrieval/text_embedding/integrations/openai.md)
        - [GCP Vertex AI](/modules/retrieval/text_embedding/integrations/gcp_vertex_ai.md)
        - [Google AI](/modules/retrieval/text_embedding/integrations/google_ai.md)
        - [Ollama](/modules/retrieval/text_embedding/integrations/ollama.md)
        - [Mistral AI](/modules/retrieval/text_embedding/integrations/mistralai.md)
        - [Together AI](/modules/retrieval/text_embedding/integrations/together_ai.md)
        - [Anyscale](/modules/retrieval/text_embedding/integrations/anyscale.md)
        - [Prem App](/modules/retrieval/text_embedding/integrations/prem.md)
    - [Vector stores](/modules/retrieval/vector_stores/vector_stores.md)
      - Integrations
        - [Memory](/modules/retrieval/vector_stores/integrations/memory.md)
        - [ObjectBox](/modules/retrieval/vector_stores/integrations/objectbox.md)
        - [Chroma](/modules/retrieval/vector_stores/integrations/chroma.md)
        - [Pinecone](/modules/retrieval/vector_stores/integrations/pinecone.md)
        - [Supabase](/modules/retrieval/vector_stores/integrations/supabase.md)
        - [Vertex AI Vector Search](/modules/retrieval/vector_stores/integrations/vertex_ai.md)
    - [Retrievers](/modules/retrieval/retrievers/retrievers.md)
  - [Chains](/modules/chains/chains.md)
    - How-to
      - [Different call methods](/modules/chains/how_to/call_methods.md)
      - [Custom chain](/modules/chains/how_to/custom_chain.md)
      - [Debugging chains](/modules/chains/how_to/debugging.md)
      - [Loading from LangChainHub](/modules/chains/how_to/from_hub.md)
      - [Adding memory](/modules/chains/how_to/memory.md)
      - [Serialization](/modules/chains/how_to/serialization.md)
    - Foundational
      - [LLM](/modules/chains/foundational/llm.md)
      - [Sequential](/modules/chains/foundational/sequential.md)
    - Documents
      - [Stuff](/modules/chains/documents/stuff.md) 
      - [MapReduce](/modules/chains/documents/map_reduce.md)
    - Popular
      - [Summarize](/modules/chains/popular/summarize.md)
  - [Memory](/modules/memory/memory.md)
  - [Agents](/modules/agents/agents.md)
    - [Agent types](/modules/agents/agent_types/agent_types.md)
      - [Tools Agent](/modules/agents/agent_types/tools_agent.md)
    - [Tools](/modules/agents/tools/tools.md)
      - [Calculator](/modules/agents/tools/calculator.md)
      - [DALL-E Image Generator](/modules/agents/tools/openai_dall_e.md)
    - [Toolkits](/modules/agents/toolkits/toolkits.md)
