<p align="center">
  <a href="https://datadreamer.dev"><img src="https://datadreamer.dev/docs/latest/_static/logo.svg" alt="DataDreamer" style="max-width: 100%;"></a><br />
  <a href="https://datadreamer.dev"><b>https://datadreamer.dev</b></a>
</p>
<p align="center">
   <b>Prompt. Generate Synthetic Data. Train & Align Models.</b><br /><br />
  <a href="https://github.com/datadreamer-dev/DataDreamer/actions/workflows/release.yml"><img src="https://img.shields.io/github/actions/workflow/status/datadreamer-dev/DataDreamer/release.yml?logo=githubactions&logoColor=white&label=Tests%20%26%20Release" alt="Tests & Release" style="max-width: 100%;"></a>
  <a href="https://codecov.io/gh/datadreamer-dev/DataDreamer"><img src="https://codecov.io/gh/datadreamer-dev/DataDreamer/graph/badge.svg?token=KZB00BKWJE"/></a>
  <a href="https://github.com/datadreamer-dev/DataDreamer/actions/workflows/tests.yml"><img src="https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/57b6a8cedd26481516a1a6af510d6b24272d0a76/assets/badge/v2.json" alt="Ruff" style="max-width: 100%;"></a>
  <a href="https://pypi.org/project/datadreamer.dev/"><img src="https://badge.fury.io/py/datadreamer.dev.svg"/></a>
  <a href="https://datadreamer.dev/docs/"><img src="https://img.shields.io/website.svg?down_color=red&down_message=offline&label=Documentation&up_message=online&url=https://datadreamer.dev/docs/"/></a>
  <a href="https://datadreamer.dev/docs/latest/pages/contributing.html"><img src="https://img.shields.io/badge/Contributor-Guide-blue?logo=Github&color=purple"/></a>
  <br />
  <a href="https://github.com/datadreamer-dev/DataDreamer/blob/main/LICENSE.txt"><img src="https://img.shields.io/badge/License-MIT-blue.svg"/></a>
  <a href="https://ajayp.app/"><img src="https://img.shields.io/badge/NLP-NLP?labelColor=011F5b&color=990000&label=University%20of%20Pennsylvania"/></a>
  <a href="https://arxiv.org/abs/2402.10379"><img src="https://img.shields.io/badge/arXiv-2402.10379-b31b1b.svg"/></a>
  <a href="https://discord.gg/dwWW8wuCtK"><img src="https://img.shields.io/badge/Discord-Chat-blue?logo=discord&color=4338ca&labelColor=black"/></a>
</p>

DataDreamer is a powerful open-source Python library for prompting, synthetic data generation, and training workflows. It is designed to be simple, extremely efficient, and research-grade.

<div align="center">
  <table class="docutils align-default">
    <tbody>
        <tr>
          <td colspan="2">
            <p align="center"><b>Installation</b></p> <pre lang="bash">pip3 install datadreamer.dev</pre>
          </td>
        </tr>
    </tbody>
    <tbody>
        <tr>
          <th class="head"><code>demo.py</code></th>
          <th class="head">Result of <code>demo.py</code></th>
        </tr>
    </tbody>
    <tbody>
        <tr>
          <td>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br />
              <a href="https://datadreamer.dev/docs/latest/" title="demo.py"><img src="https://datadreamer.dev/docs/latest/_static/images/demo_code.png" alt="demo.py" /></a>
              <br /><br />
              <p align="center">
                See the <a class="reference external" href="https://datadreamer.dev/docs/latest/" title="demo.py">full demo script</a>
              </p>
              <br />
          </td>
          <td>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br />
            <a href="https://datadreamer.dev/docs/latest/" title="Demo"><img style="height: 400px;" src="https://datadreamer.dev/docs/latest/_static/images/demo.svg#cachebust-2" alt="Demo" /></a>
            <p align="center">
              See the <a class="reference external" href="https://huggingface.co/datasets/datadreamer-dev/abstracts_and_tweets">synthetic dataset</a> and <a class="reference external" href="https://huggingface.co/datadreamer-dev/abstracts_to_tweet_model">the trained model</a>
            </p>
          </td>
        </tr> 
    </tbody>
    <tbody>
        <tr>
          <td colspan="2">
              <p align="center">
                🚀 For more demonstrations and recipes see the <a class="reference external" href="https://datadreamer.dev/docs/latest/pages/get_started/quick_tour/index.html" title="Quick Tour"> Quick Tour</a> page.
              </p>
          </td>
        </tr>
    </tbody>
  </table>
</div>

With DataDreamer you can:

* 💬 **Create Prompting Workflows**: Create and run multi-step, complex, prompting workflows easily with major open source or API-based LLMs.
* 📊 **Generate Synthetic Datasets**: Generate synthetic datasets for novel tasks or augment existing datasets with LLMs.
* ⚙️ **Train Models**: Align models. Fine-tune models. Instruction-tune models. Distill models. Train on existing data or synthetic data.
* ... learn more about what's possible in the [Overview Guide](https://datadreamer.dev/docs/latest/pages/get_started/overview_guide.html)

DataDreamer is:

* 🧩 **Simple**: Simple and approachable to use with sensible defaults, yet powerful with support for bleeding edge techniques.
* 🔬 **Research-Grade**: Built for researchers, by researchers, but accessible to all. A focus on correctness, best practices, and reproducibility.
* 🏎️ **Efficient**: Aggressive caching and resumability built-in. Support for techniques like quantization, parameter-efficient training (LoRA), and more.
* 🔄 **Reproducible**: Workflows built with DataDreamer are easily shareable, reproducible, and extendable.
* 🤝 **Makes Sharing Easy**: Publishing datasets and models is simple. Automatically generate data cards and model cards with metadata. Generate a list of any citations required.
* ... learn more about the [motivation and design principles behind DataDreamer](https://datadreamer.dev/docs/latest/pages/get_started/motivation_and_design.html).

## Citation

Please cite the [DataDreamer paper](https://arxiv.org/abs/2402.10379):

```bibtex
@misc{patel2024datadreamer,
      title={DataDreamer: A Tool for Synthetic Data Generation and Reproducible LLM Workflows}, 
      author={Ajay Patel and Colin Raffel and Chris Callison-Burch},
      year={2024},
      eprint={2402.10379},
      archivePrefix={arXiv},
      primaryClass={cs.CL}
}
```

## Contact

Please reach out to us via [email (ajayp@upenn.edu)](mailto:ajayp@upenn.edu) or on [Discord](https://discord.gg/dwWW8wuCtK) if you have any questions, comments, or feedback.

<br />

------------------------------

Copyright © 2024, [Ajay Patel](https://ajayp.app/). Released under the [MIT License](https://github.com/datadreamer-dev/DataDreamer/blob/main/LICENSE.txt).

Thank you to the maintainers at [Hugging Face](https://github.com/huggingface) and [LiteLLM](https://github.com/BerriAI/litellm) for accepting contributions necessary for DataDreamer and providing upstream support.

------------------------------
#### Funding Acknowledgements

<sub><b>ODNI, IARPA:</b> This research is supported in part by the Office of the Director of National Intelligence (ODNI), Intelligence Advanced Research Projects Activity (IARPA), via the HIATUS Program contract #2022-22072200005. The views and conclusions contained herein are those of the authors and should not be interpreted as necessarily representing the official policies, either expressed or implied, of ODNI, IARPA, or the U.S. Government. The U.S. Government is authorized to reproduce and distribute reprints for governmental purposes notwithstanding any copyright annotation therein.</sup>
