/*
 * Decompiled with CFR 0.152.
 */
package sleep.taint;

import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class PermeableStep
extends Step {
    protected Step wrapped;

    public PermeableStep(Step step) {
        this.wrapped = step;
    }

    public void setInfo(int n) {
        this.wrapped.setInfo(n);
    }

    public int getLineNumber() {
        return this.wrapped.getLineNumber();
    }

    public String toString(String string) {
        return string + "[Taint Wrap]\n" + this.wrapped.toString(string + "   ");
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        String string = scriptEnvironment.hasFrame() ? TaintUtils.checkArguments(scriptEnvironment.getCurrentFrame()) : null;
        return this.callit(scriptEnvironment, string);
    }

    protected Scalar callit(ScriptEnvironment scriptEnvironment, String string) {
        this.wrapped.evaluate(scriptEnvironment);
        if (string != null && scriptEnvironment.hasFrame() && !scriptEnvironment.getCurrentFrame().isEmpty() && !SleepUtils.isEmptyScalar((Scalar)scriptEnvironment.getCurrentFrame().peek()) && ((Scalar)scriptEnvironment.getCurrentFrame().peek()).getActualValue() != null) {
            TaintUtils.taint((Scalar)scriptEnvironment.getCurrentFrame().peek());
            if ((scriptEnvironment.getScriptInstance().getDebugFlags() & 0x80) == 128) {
                scriptEnvironment.getScriptInstance().fireWarning("tainted value: " + SleepUtils.describe((Scalar)scriptEnvironment.getCurrentFrame().peek()) + " from: " + string, this.getLineNumber());
            }
            return (Scalar)scriptEnvironment.getCurrentFrame().peek();
        }
        return null;
    }
}

