/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

public class Token {
    protected String term;
    protected int hint;
    protected int marker;
    protected int tophint;

    public Token(String string, int n) {
        this(string, n, -1);
    }

    public Token(String string, int n, int n2) {
        this.term = string;
        this.hint = n;
        this.marker = n2;
        this.tophint = -1;
    }

    public String toString() {
        return this.term;
    }

    public int getMarkerIndex() {
        return this.marker;
    }

    public Token copy(int n) {
        return new Token(this.term, n);
    }

    public Token copy(String string) {
        return new Token(string, this.getHint());
    }

    public String getMarker() {
        if (this.marker > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.marker - 1; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("^");
            return stringBuffer.toString();
        }
        return null;
    }

    public int getTopHint() {
        if (this.tophint >= 0) {
            return this.tophint;
        }
        this.tophint = this.hint;
        int n = -1;
        while ((n = this.term.indexOf(10, n + 1)) > -1) {
            ++this.tophint;
        }
        return this.tophint;
    }

    public int getHint() {
        return this.hint;
    }
}

