/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class FileSystemBridge
implements Loadable,
Function,
Predicate {
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        hashtable.put("-exists", this);
        hashtable.put("-canread", this);
        hashtable.put("-canwrite", this);
        hashtable.put("-isDir", this);
        hashtable.put("-isFile", this);
        hashtable.put("-isHidden", this);
        hashtable.put("&createNewFile", this);
        hashtable.put("&deleteFile", this);
        hashtable.put("&chdir", this);
        hashtable.put("&cwd", this);
        hashtable.put("&getCurrentDirectory", this);
        hashtable.put("&getFileName", new getFileName());
        hashtable.put("&getFileProper", new getFileProper());
        hashtable.put("&getFileParent", new getFileParent());
        hashtable.put("&lastModified", new lastModified());
        hashtable.put("&lof", new lof());
        hashtable.put("&ls", new listFiles());
        hashtable.put("&listRoots", hashtable.get("&ls"));
        hashtable.put("&mkdir", this);
        hashtable.put("&rename", this);
        hashtable.put("&setLastModified", this);
        hashtable.put("&setReadOnly", this);
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&createNewFile")) {
            try {
                File file = BridgeUtilities.getFile(stack, scriptInstance);
                if (file.createNewFile()) {
                    return SleepUtils.getScalar(1);
                }
            }
            catch (Exception exception) {
                scriptInstance.getScriptEnvironment().flagError(exception);
            }
        } else {
            if (string.equals("&cwd") || string.equals("&getCurrentDirectory")) {
                return SleepUtils.getScalar(scriptInstance.cwd());
            }
            if (string.equals("&chdir")) {
                scriptInstance.chdir(BridgeUtilities.getFile(stack, scriptInstance));
            } else if (string.equals("&deleteFile")) {
                File file = BridgeUtilities.getFile(stack, scriptInstance);
                if (file.delete()) {
                    return SleepUtils.getScalar(1);
                }
            } else if (string.equals("&mkdir")) {
                File file = BridgeUtilities.getFile(stack, scriptInstance);
                if (file.mkdirs()) {
                    return SleepUtils.getScalar(1);
                }
            } else if (string.equals("&rename")) {
                File file;
                File file2 = BridgeUtilities.getFile(stack, scriptInstance);
                if (file2.renameTo(file = BridgeUtilities.getFile(stack, scriptInstance))) {
                    return SleepUtils.getScalar(1);
                }
            } else if (string.equals("&setLastModified")) {
                long l;
                File file = BridgeUtilities.getFile(stack, scriptInstance);
                if (file.setLastModified(l = BridgeUtilities.getLong(stack))) {
                    return SleepUtils.getScalar(1);
                }
            } else if (string.equals("&setReadOnly")) {
                File file = BridgeUtilities.getFile(stack, scriptInstance);
                if (file.setReadOnly()) {
                    return SleepUtils.getScalar(1);
                }
                return SleepUtils.getEmptyScalar();
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        File file = BridgeUtilities.getFile(stack, scriptInstance);
        if (string.equals("-canread")) {
            return file.canRead();
        }
        if (string.equals("-canwrite")) {
            return file.canWrite();
        }
        if (string.equals("-exists")) {
            return file.exists();
        }
        if (string.equals("-isDir")) {
            return file.isDirectory();
        }
        if (string.equals("-isFile")) {
            return file.isFile();
        }
        if (string.equals("-isHidden")) {
            return file.isHidden();
        }
        return false;
    }

    private static class listFiles
    implements Function {
        private listFiles() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Serializable serializable;
            File[] fileArray;
            if (stack.isEmpty() && string.equals("&listRoots")) {
                fileArray = File.listRoots();
            } else {
                serializable = BridgeUtilities.getFile(stack, scriptInstance);
                fileArray = ((File)serializable).listFiles();
            }
            serializable = new LinkedList();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    ((LinkedList)serializable).add(fileArray[i].getAbsolutePath());
                }
            }
            return SleepUtils.getArrayWrapper((Collection)((Object)serializable));
        }
    }

    private static class lof
    implements Function {
        private lof() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            File file = BridgeUtilities.getFile(stack, scriptInstance);
            return SleepUtils.getScalar(file.length());
        }
    }

    private static class lastModified
    implements Function {
        private lastModified() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            File file = BridgeUtilities.getFile(stack, scriptInstance);
            return SleepUtils.getScalar(file.lastModified());
        }
    }

    private static class getFileParent
    implements Function {
        private getFileParent() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            File file = BridgeUtilities.getFile(stack, scriptInstance);
            return SleepUtils.getScalar(file.getParent());
        }
    }

    private static class getFileProper
    implements Function {
        private getFileProper() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            File file = BridgeUtilities.getFile(stack, scriptInstance);
            while (!stack.isEmpty()) {
                file = new File(file, stack.pop().toString());
            }
            return SleepUtils.getScalar(file.getAbsolutePath());
        }
    }

    private static class getFileName
    implements Function {
        private getFileName() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            File file = BridgeUtilities.getFile(stack, scriptInstance);
            return SleepUtils.getScalar(file.getName());
        }
    }
}

