+++
title = "Bookmarks"
+++

A collection of links on the WWW which I use, admire or agree with.

## Software

I've been happily running Linux on my laptop since 2016.

Made possible by the following list of mostly open-source software (not exhaustive).

- [Debian](https://www.debian.org/): the Linux distribution I use as my daily driver.
- [Sway](https://swaywm.org/): tiling window manager.
- [Foot](https://swaywm.org/): terminal.
- [Firefox](https://www.mozilla.org/en-US/firefox/): web browser. I use the ESR edition.
- [Neovim](https://neovim.io/): text editor. [Helix](https://helix-editor.com/)
  is shaping up nicely as well.
- [uBlock Origin](https://ublockorigin.com/): ad-blocker.
- [Bitwarden](https://bitwarden.com/): password manager.
- [Bash](https://www.gnu.org/software/bash/): sh compatibe shell. I like Fish too, but having bash available out of the box pretty much everywhere is what makes me stick with it.
- [Todoist](https://todoist.com), to-do app that runs my life (proprietary).
- [GIMP](https://www.gimp.org/), image editor.
- [Inkscape](https://inkscape.org/), SVG editor.
- [Sublime Text](https://www.sublimetext.com/), text editor.
- [Evolution](https://wiki.gnome.org/Apps/Evolution): Gnome email client that does [plain-text email](https://useplaintext.email/) correctly.


## Web development

- [Nginx](https://nginx.org/), web server software.
- [PostgreSQL](https://www.postgresql.org/), [MariaDB](https://mariadb.org/), or [SQLite](https://www.sqlite.org/index.html). SQL database servers.
- [MDN documentation](https://developer.mozilla.org/en-US/), all the HTML, CSS and JS documentation you need.
- [WordPress](https://wordpress.org/), content management system. Sadly, most themes are bloated.
- [A11Y accessibility checklist](https://www.a11yproject.com/checklist/)
- [Sustainable Web Manifesto](https://www.sustainablewebmanifesto.com/)
- [sourcehut](https://git.sr.ht/), git hosting service.
- [Symfony](https://symfony.com/) or [Django](https://www.djangoproject.com/), PHP and Python web frameworks.
- [Gozer](https://github.com/dannyvankooten/gozer) Static site generator, turns Markdown files into HTML pages.

On the frontend, I strive to not use any CSS frameworks and only use JavaScript sparingly. I have also been intrigued by [#NoBuild](https://world.hey.com/dhh/you-can-t-get-faster-than-no-build-7a44131c) lately, although a build step for [concatenating and compressing files](https://csswizardry.com/2023/10/the-three-c-concatenate-compress-cache/) with a similar lifespan is probably worth it for performance reasons.


## State of the web

- [Performance Inequality Gap 2024](https://infrequently.org/2024/01/performance-inequality-gap-2024/) [2023](https://infrequently.org/2022/12/performance-baseline-2023/)
- [HTTP Archive Web Almanac 2022: Page weight](https://almanac.httparchive.org/en/2022/page-weight)
- [motherfuckingwebsite.com](http://motherfuckingwebsite.com/), [bettermotherfuckingwebsite.com](http://bettermotherfuckingwebsite.com/) and [perfectmotherfuckingwebsite.com](https://perfectmotherfuckingwebsite.com/)
- [The Cost Of JavaScript - Addy Osmani (2023)](https://www.youtube.com/watch?v=ZKH3DLT4BKw)
- [Climate friendly software: don't fight the wrong battle](https://blog.ltgt.net/climate-friendly-software/)
- [Introduction to web sustainability, MDN](https://developer.mozilla.org/en-US/blog/introduction-to-web-sustainability/)
- [Internet obesity crisis](https://idlewords.com/talks/website_obesity.htm)
- [Death to bullshit](https://deathtobullshit.com/)
- [Rez Mason's beliefs](https://www.rezmason.net/beliefs.html)


## Programming

- [The C Programming Language](https://en.wikipedia.org/wiki/The_C_Programming_Language): Learning C helped me understand every other language better.
- [Golang](https://go.dev/): Garbage-collected language with great concurrency support.
- [Rust](https://www.rust-lang.org/): like C++, but without the footguns. Comes at the cost of very slow compile times though.
- [Python](https://www.python.org/): So convenient and widespread.
- [Advent of Code](https://adventofcode.com/): annual event in December hosting fun programming puzzles.
- [Project Euler](https://projecteuler.net/): math based programming puzzles.
- [GNU Make](https://www.gnu.org/software/make/)


## Blogs

Some of the blogs I enjoy reading.

- [Low Tech Magazine](https://solar.lowtechmagazine.com/)
- [Fabien Sanglard](https://fabiensanglard.net/)
- [Dan Luu](https://danluu.com/)
- [Wim van der Bauwhede](https://wimvanderbauwhede.codeberg.page/)
- [Alex Russell](https://infrequently.org/)
- [Drew DeVault](https://drewdevault.com/)
- [Julia Evans](https://jvns.ca/)
- [Permacomputing](https://permacomputing.net/)

## Social

- [Mastodon](https://joinmastodon.org/), decentralized and open-source microblogging network. I'm on [toot.re](https://toot.re/@dvk), which is run by [Marcel](https://marcelbootsman.nl/).
- [Nitter](https://nitter.net/), gateway to Twitter content, but usable.
- [Lobsters](https://lobste.rs/), programming related link aggregation and discussion.
- [Hacker News](https://news.ycombinator.com/), same, but older and very popular.


## Misc

- [Hexagons](https://www.redblobgames.com/grids/hexagons/), resource on hexagonal grids that I keep coming back to during Advent of Code.


## Ecology

- [Land van Ons](https://landvanons.nl/)
- [Permaculture](https://en.wikipedia.org/wiki/Permaculture)
- [Food Forest Ketelbroek](https://www.youtube.com/watch?v=M5B3f5gxHkA), amazing agriculture experiment using mostly perennial plants.
- [Mobilisation for the Environment](https://mobilisation.nl/nl/)
- [Herenboeren](https://www.herenboeren.nl/), community supported agriculture.
- [Partij voor de Dieren](https://www.partijvoordedieren.nl/), Dutch political party that thinks beyond the next election.

