+++
title = "Climate friendly software"
+++

Last week I read [Climate-friendly software, don't fight the wrong
battle](https://blog.ltgt.net/climate-friendly-software/) by Thomas Broyer.

It's a really good read and nicely puts into words my current understanding of
striving for more sustainable software.

## Key takeaways:

- Pick servers in carbon-neutral or low-carbon datacenters first, then optimize your architecture and code.
- Don't be the one that will make your users change their device.
- Optimize for perceived performance and battery life.

Since writing about [CO2 emissions on the
web](https://www.dannyvankooten.com/blog/2020/website-carbon-emissions/) in 2020
or being featured in [Wired's article on sustainable web design](https://www.wired.com/story/sustainable-software-design-climate-change/) a lot has happened.

Many website carbon calculators have come to life that mostly focus on total page weight. While I applaud this effort, my current
belief is that not all bytes are equal. A byte of JavaScript is much more costly than a byte of image.

Instead we should be optimizing for (perceived) performance, making sure your
software runs on renewable energy and that you're using energy at times or locations where it's
highly available.

> Don't be the one that will make your users change their device.

Microsoft Azure wrote about [saving CO2 using location and time shifting in
Azure](https://devblogs.microsoft.com/ise/saving-co2-using-location-and-time-shifting-in-azure/).
I'd love to see more of this sort of stuff. It reminds me of the [solar-powered version of Low Tech Magazine's website](https://solar.lowtechmagazine.com/),
which simply goes offline once it runs out of stored energy coming from a single solar panel.



