/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cofeeapp.Frame;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import cofeeapp.Controller.MainController;
import coffeapp.Helper.Helper;

/**
 *
 * @author M DANI SETIAWAN
 */
public class CoffeeDetails extends javax.swing.JFrame {
    private final MainController controller;
    private String product_id;

    /**
     * Creates new form AlpikasiInventori
     */
    public CoffeeDetails() {
        initComponents();
        MainController mainController = new MainController();
        controller = mainController;
        loadTable();
        clearForm();
       
    }
    
    public void loadTable(){
        String sql = "select * from tbCoffee";
        controller.get(tb_coffeeproduct, sql);
        System.out.println("Worked!");
    }
    
    private void clearForm(){
        tf_nama.setText(null);
        tf_harga.setText(null);
        cb_jenis.setSelectedIndex(0);
        dp_expired.setDate(null);
        btn_update.setEnabled(false);
        btn_delete.setEnabled(false);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollBar1 = new javax.swing.JScrollBar();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        cb_jenis = new javax.swing.JComboBox();
        btn_delete = new javax.swing.JButton();
        btn_update = new javax.swing.JButton();
        btn_submit = new javax.swing.JButton();
        btn_carinama = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tb_coffeeproduct = new javax.swing.JTable();
        dp_expired = new org.jdesktop.swingx.JXDatePicker();
        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jButton6 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel7 = new javax.swing.JLabel();
        btn_cariid = new javax.swing.JButton();
        tf_nama = new javax.swing.JTextField();
        tf_harga = new javax.swing.JTextField();
        tf_search = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBackground(new java.awt.Color(233, 160, 107));
        jPanel1.setPreferredSize(new java.awt.Dimension(740, 430));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel1.setForeground(new java.awt.Color(255, 255, 255));
        jLabel1.setText("Coffee Name");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 120, -1, 20));

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel2.setForeground(new java.awt.Color(255, 255, 255));
        jLabel2.setText("Coffee Type");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 190, -1, 20));

        jLabel4.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel4.setText("Search");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(360, 110, -1, 30));

        jLabel5.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel5.setForeground(new java.awt.Color(255, 255, 255));
        jLabel5.setText("Price");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 270, -1, 20));

        jLabel6.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel6.setForeground(new java.awt.Color(255, 255, 255));
        jLabel6.setText("Expired Coffe");
        jPanel1.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 350, -1, 20));

        cb_jenis.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Indonesian Coffee", "Arabican Coffee", "Italian coffee", " " }));
        cb_jenis.setBorder(null);
        jPanel1.add(cb_jenis, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 220, 300, 40));

        btn_delete.setBackground(new java.awt.Color(255, 0, 0));
        btn_delete.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        btn_delete.setForeground(new java.awt.Color(255, 255, 255));
        btn_delete.setText("Delete");
        btn_delete.setBorder(null);
        btn_delete.setFocusPainted(false);
        btn_delete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_deleteActionPerformed(evt);
            }
        });
        jPanel1.add(btn_delete, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 440, 80, 30));

        btn_update.setBackground(new java.awt.Color(0, 0, 255));
        btn_update.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        btn_update.setForeground(new java.awt.Color(255, 255, 255));
        btn_update.setText("Update");
        btn_update.setFocusPainted(false);
        btn_update.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_updateActionPerformed(evt);
            }
        });
        jPanel1.add(btn_update, new org.netbeans.lib.awtextra.AbsoluteConstraints(240, 440, 80, 30));

        btn_submit.setBackground(new java.awt.Color(0, 255, 0));
        btn_submit.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        btn_submit.setForeground(new java.awt.Color(255, 255, 255));
        btn_submit.setText("Submit");
        btn_submit.setBorder(null);
        btn_submit.setFocusPainted(false);
        btn_submit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_submitActionPerformed(evt);
            }
        });
        jPanel1.add(btn_submit, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 440, 80, 30));

        btn_carinama.setBackground(new java.awt.Color(255, 255, 255));
        btn_carinama.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        btn_carinama.setIcon(new javax.swing.ImageIcon(getClass().getResource("/coffeapp/image/search-2-24.png"))); // NOI18N
        btn_carinama.setText("Name");
        btn_carinama.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(210, 105, 30)));
        btn_carinama.setFocusPainted(false);
        btn_carinama.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_carinamaActionPerformed(evt);
            }
        });
        jPanel1.add(btn_carinama, new org.netbeans.lib.awtextra.AbsoluteConstraints(670, 110, 150, 30));

        tb_coffeeproduct.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        tb_coffeeproduct.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                tb_coffeeproductMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(tb_coffeeproduct);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(350, 150, 650, 350));

        dp_expired.setForeground(new java.awt.Color(0, 0, 0));
        dp_expired.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dp_expiredActionPerformed(evt);
            }
        });
        jPanel1.add(dp_expired, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 380, 300, 40));

        jPanel2.setBackground(new java.awt.Color(210, 105, 30));
        jPanel2.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel3.setFont(new java.awt.Font("Monotype Corsiva", 1, 48)); // NOI18N
        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/coffeapp/image/book-16-64(1).png"))); // NOI18N
        jLabel3.setText("Coffee Details");
        jPanel2.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(30, 20, -1, -1));

        jButton6.setBackground(new java.awt.Color(210, 105, 30));
        jButton6.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jButton6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/coffeapp/image/arrow-91-32.png"))); // NOI18N
        jButton6.setText("Back");
        jButton6.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jButton6.setBorderPainted(false);
        jButton6.setContentAreaFilled(false);
        jButton6.setFocusPainted(false);
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });
        jPanel2.add(jButton6, new org.netbeans.lib.awtextra.AbsoluteConstraints(900, 30, 80, 40));

        jPanel1.add(jPanel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, 1000, 100));

        jPanel3.setBackground(new java.awt.Color(210, 105, 30));
        jPanel3.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel7.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        jLabel7.setText("D.B.F © 2019 Powered By Net Beans");
        jPanel3.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(760, 10, 230, 30));

        jPanel1.add(jPanel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 500, 1000, 50));

        btn_cariid.setBackground(new java.awt.Color(255, 255, 255));
        btn_cariid.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        btn_cariid.setIcon(new javax.swing.ImageIcon(getClass().getResource("/coffeapp/image/search-2-24.png"))); // NOI18N
        btn_cariid.setText("ID");
        btn_cariid.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(210, 105, 30)));
        btn_cariid.setFocusPainted(false);
        btn_cariid.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_cariidActionPerformed(evt);
            }
        });
        jPanel1.add(btn_cariid, new org.netbeans.lib.awtextra.AbsoluteConstraints(830, 110, 160, 30));
        jPanel1.add(tf_nama, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 150, 300, 40));
        jPanel1.add(tf_harga, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 300, 300, 40));
        jPanel1.add(tf_search, new org.netbeans.lib.awtextra.AbsoluteConstraints(410, 110, 250, 30));

        jPanel4.setBackground(new java.awt.Color(120, 59, 16));
        jPanel4.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.add(jPanel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 100, 350, 400));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, 1000, 550));

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void btn_deleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_deleteActionPerformed
        // TODO add your handling code here:
        try{    
            Helper helper = new Helper();
            String expired = helper.parseDatatoDatabase(dp_expired);
            
            String sql = "DELETE FROM tbCoffee WHERE ID_Coffee = ?";
            
            Map<Integer, Object> map = new HashMap<>();
            map.put(1, this.product_id);
            
            if(controller.preparedStatement(map, sql)){
                clearForm();
                loadTable();
                JOptionPane.showMessageDialog(null, "Berhasil Menghapus Data");
            }
            else{
                JOptionPane.showMessageDialog(null, "Gagal Menghapus Data");
            }
        } catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }//GEN-LAST:event_btn_deleteActionPerformed

    private void btn_submitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_submitActionPerformed
         try {
            // TODO add your handling code here:
            String name = tf_nama.getText();
            String price = tf_harga.getText();
            String type = cb_jenis.getSelectedItem().toString();
            
            Helper helper = new Helper();
            String expired = helper.parseDatatoDatabase(dp_expired);
            
            String sql = "INSERT INTO tbCoffee (Name,Coffee_Type, "
                    + "Price, Expired) values (?,?,?,?)";
            
            Map<Integer, Object> map = new HashMap<>();
            map.put(1, name);
            map.put(2, type);
            map.put(3, price);
            map.put(4, expired);
            
            if(!controller.preparedStatement(map, sql)){
                JOptionPane.showMessageDialog(null, "Gagal Menambahkan Data");
            }
            clearForm();
            loadTable();
            JOptionPane.showMessageDialog(null, "Berhasil Menambahkan Data");
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
    }               
    }//GEN-LAST:event_btn_submitActionPerformed

    private void btn_updateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_updateActionPerformed
        try {    
        
            String name = tf_nama.getText();
            String price = tf_harga.getText();
            String type = cb_jenis.getSelectedItem().toString();
            
            Helper helper = new Helper();
            String expired = helper.parseDatatoDatabase(dp_expired);
            
            String sql = "UPDATE tbCoffee SET Name = ?, Coffee_Type = ?, "
                    + " Price = ?, Expired = ? WHERE ID_Coffee = ?";
            
            Map<Integer, Object> map = new HashMap<>();
            map.put(1, name);
            map.put(2, type);
            map.put(3, price);
            map.put(4, expired);
            map.put(5, this.product_id);
            
            if(controller.preparedStatement(map, sql)){
                clearForm();
                loadTable();
                JOptionPane.showMessageDialog(null, "Berhasil Merubah Data");
            }
            else{
                JOptionPane.showMessageDialog(null, "Gagal Merubah Data");
            }
            
        } catch (Exception ex) {
            System.err.println(ex.getMessage());
    }//GEN-LAST:event_btn_updateActionPerformed
    }
    private void btn_carinamaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_carinamaActionPerformed
        // TODO add your handling code here:
        String search = tf_search.getText();
        String sql = "SELECT * FROM tbCoffee WHERE Name LIKE '%"+ search +"%';";
        controller.get(tb_coffeeproduct, sql);
    }//GEN-LAST:event_btn_carinamaActionPerformed

    private void btn_cariidActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_cariidActionPerformed
        // TODO add your handling code here:
        String search = tf_search.getText();
        String sql = "SELECT * FROM tbCoffee WHERE ID_Coffee = ?";
        Map<Integer, Object> map = new HashMap<>();
            map.put(1, search);
            
        controller.getWithParameter(tb_coffeeproduct, map, sql);
    }//GEN-LAST:event_btn_cariidActionPerformed

    private void tb_coffeeproductMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tb_coffeeproductMouseClicked
        try {                                        
            // TODO add your handling code here:
            Helper helper = new Helper();
            String id = helper.getValueRows(tb_coffeeproduct, 0);
            String name = helper.getValueRows(tb_coffeeproduct, 1);
            String type = helper.getValueRows(tb_coffeeproduct, 2);
            String price = helper.getValueRows(tb_coffeeproduct, 3);
            String expired = helper.getValueRows(tb_coffeeproduct, 4);
            
            btn_update.setEnabled(true);
            btn_delete.setEnabled(true);
            
            this.product_id = id;
            tf_nama.setText(name);
            cb_jenis.setSelectedItem(type);
            tf_harga.setText(price);
            dp_expired.setDate(new Date(helper.getParsedDate(expired)));
        } catch (ParseException ex) {
            Logger.getLogger(CoffeeDetails.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_tb_coffeeproductMouseClicked

    private void dp_expiredActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dp_expiredActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_dp_expiredActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        // TODO add your handling code here:
        Menu menu = new Menu();
        menu.setVisible(true);
        this.dispose();
    }//GEN-LAST:event_jButton6ActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(CoffeeDetails.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(CoffeeDetails.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(CoffeeDetails.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(CoffeeDetails.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CoffeeDetails().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btn_cariid;
    private javax.swing.JButton btn_carinama;
    private javax.swing.JButton btn_delete;
    private javax.swing.JButton btn_submit;
    private javax.swing.JButton btn_update;
    private javax.swing.JComboBox cb_jenis;
    private org.jdesktop.swingx.JXDatePicker dp_expired;
    private javax.swing.JButton jButton6;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollBar jScrollBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable tb_coffeeproduct;
    private javax.swing.JTextField tf_harga;
    private javax.swing.JTextField tf_nama;
    private javax.swing.JTextField tf_search;
    // End of variables declaration//GEN-END:variables
}
