/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Morphing2D
implements Shape {
    private double morph;
    private Geometry startGeometry;
    private Geometry endGeometry;

    public Morphing2D(Shape startShape, Shape endShape) {
        this.startGeometry = new Geometry(startShape);
        this.endGeometry = new Geometry(endShape);
        if (this.startGeometry.getWindingRule() != this.endGeometry.getWindingRule()) {
            throw new IllegalPathStateException("shapes must use same winding rule");
        }
        double[] tvals0 = this.startGeometry.getTvals();
        double[] tvals1 = this.endGeometry.getTvals();
        double[] masterTvals = Morphing2D.mergeTvals(tvals0, tvals1);
        this.startGeometry.setTvals(masterTvals);
        this.endGeometry.setTvals(masterTvals);
    }

    public double getMorphing() {
        return this.morph;
    }

    public void setMorphing(double morph) {
        if (morph > 1.0) {
            morph = 1.0;
        } else if (!(morph >= 0.0)) {
            morph = 0.0;
        }
        this.morph = morph;
    }

    private static double interp(double v0, double v1, double t) {
        return v0 + (v1 - v0) * t;
    }

    private static double[] mergeTvals(double[] tvals0, double[] tvals1) {
        int i0 = 0;
        int i1 = 0;
        int numtvals = 0;
        while (i0 < tvals0.length && i1 < tvals1.length) {
            double t0 = tvals0[i0];
            double t1 = tvals1[i1];
            if (t0 <= t1) {
                ++i0;
            }
            if (t1 <= t0) {
                ++i1;
            }
            ++numtvals;
        }
        double[] newtvals = new double[numtvals];
        i0 = 0;
        i1 = 0;
        numtvals = 0;
        while (i0 < tvals0.length && i1 < tvals1.length) {
            double t0 = tvals0[i0];
            double t1 = tvals1[i1];
            if (t0 <= t1) {
                newtvals[numtvals] = t0;
                ++i0;
            }
            if (t1 <= t0) {
                newtvals[numtvals] = t1;
                ++i1;
            }
            ++numtvals;
        }
        return newtvals;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        double ymax;
        double xmax;
        int n = this.startGeometry.getNumCoords();
        double xmin = xmax = Morphing2D.interp(this.startGeometry.getCoord(0), this.endGeometry.getCoord(0), this.morph);
        double ymin = ymax = Morphing2D.interp(this.startGeometry.getCoord(1), this.endGeometry.getCoord(1), this.morph);
        for (int i = 2; i < n; i += 2) {
            double x = Morphing2D.interp(this.startGeometry.getCoord(i), this.endGeometry.getCoord(i), this.morph);
            double y = Morphing2D.interp(this.startGeometry.getCoord(i + 1), this.endGeometry.getCoord(i + 1), this.morph);
            if (xmin > x) {
                xmin = x;
            }
            if (ymin > y) {
                ymin = y;
            }
            if (xmax < x) {
                xmax = x;
            }
            if (!(ymax < y)) continue;
            ymax = y;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public boolean contains(double x, double y) {
        throw new InternalError("unimplemented");
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        throw new InternalError("unimplemented");
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new InternalError("unimplemented");
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(at, this.startGeometry, this.endGeometry, this.morph);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    private static class Geometry {
        static final double THIRD = 0.3333333333333333;
        static final double MIN_LEN = 0.001;
        double[] bezierCoords = new double[20];
        int numCoords;
        int windingrule;
        double[] myTvals;

        public Geometry(Shape s) {
            int i;
            double newy;
            double newx;
            PathIterator pi = s.getPathIterator(null);
            this.windingrule = pi.getWindingRule();
            if (pi.isDone()) {
                this.numCoords = 8;
            }
            double[] coords = new double[6];
            int type = pi.currentSegment(coords);
            pi.next();
            if (type != 0) {
                throw new IllegalPathStateException("missing initial moveto");
            }
            double curx = this.bezierCoords[0] = coords[0];
            double cury = this.bezierCoords[1] = coords[1];
            this.numCoords = 2;
            while (!pi.isDone()) {
                if (this.numCoords + 6 > this.bezierCoords.length) {
                    int newsize = (this.numCoords - 2) * 2 + 2;
                    double[] newCoords = new double[newsize];
                    System.arraycopy(this.bezierCoords, 0, newCoords, 0, this.numCoords);
                    this.bezierCoords = newCoords;
                }
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        throw new InternalError("Cannot handle multiple subpaths");
                    }
                    case 4: {
                        if (curx == this.bezierCoords[0] && cury == this.bezierCoords[1]) break;
                        coords[0] = this.bezierCoords[0];
                        coords[1] = this.bezierCoords[1];
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(curx, newx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(cury, newy, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(newx, curx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(newy, cury, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = curx = newx;
                        this.bezierCoords[this.numCoords++] = cury = newy;
                        break;
                    }
                    case 2: {
                        double ctrlx = coords[0];
                        double ctrly = coords[1];
                        newx = coords[2];
                        newy = coords[3];
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(ctrlx, curx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(ctrly, cury, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(ctrlx, newx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(ctrly, newy, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = curx = newx;
                        this.bezierCoords[this.numCoords++] = cury = newy;
                        break;
                    }
                    case 3: {
                        this.bezierCoords[this.numCoords++] = coords[0];
                        this.bezierCoords[this.numCoords++] = coords[1];
                        this.bezierCoords[this.numCoords++] = coords[2];
                        this.bezierCoords[this.numCoords++] = coords[3];
                        this.bezierCoords[this.numCoords++] = curx = coords[4];
                        this.bezierCoords[this.numCoords++] = cury = coords[5];
                    }
                }
                pi.next();
            }
            if (this.numCoords < 8 || curx != this.bezierCoords[0] || cury != this.bezierCoords[1]) {
                newx = this.bezierCoords[0];
                newy = this.bezierCoords[1];
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(curx, newx, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(cury, newy, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(newx, curx, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(newy, cury, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = newx;
                this.bezierCoords[this.numCoords++] = newy;
            }
            int minPt = 0;
            double minX = this.bezierCoords[0];
            double minY = this.bezierCoords[1];
            for (int ci = 6; ci < this.numCoords; ci += 6) {
                double x = this.bezierCoords[ci];
                double y = this.bezierCoords[ci + 1];
                if (!(y < minY) && (y != minY || !(x < minX))) continue;
                minPt = ci;
                minX = x;
                minY = y;
            }
            if (minPt > 0) {
                double[] newCoords = new double[this.numCoords];
                System.arraycopy(this.bezierCoords, minPt, newCoords, 0, this.numCoords - minPt);
                System.arraycopy(this.bezierCoords, 2, newCoords, this.numCoords - minPt, minPt);
                this.bezierCoords = newCoords;
            }
            double area = 0.0;
            curx = this.bezierCoords[0];
            cury = this.bezierCoords[1];
            for (i = 2; i < this.numCoords; i += 2) {
                newx = this.bezierCoords[i];
                newy = this.bezierCoords[i + 1];
                area += curx * newy - newx * cury;
                curx = newx;
                cury = newy;
            }
            if (area < 0.0) {
                i = 2;
                for (int j = this.numCoords - 4; i < j; i += 2, j -= 2) {
                    curx = this.bezierCoords[i];
                    cury = this.bezierCoords[i + 1];
                    this.bezierCoords[i] = this.bezierCoords[j];
                    this.bezierCoords[i + 1] = this.bezierCoords[j + 1];
                    this.bezierCoords[j] = curx;
                    this.bezierCoords[j + 1] = cury;
                }
            }
        }

        public int getWindingRule() {
            return this.windingrule;
        }

        public int getNumCoords() {
            return this.numCoords;
        }

        public double getCoord(int i) {
            return this.bezierCoords[i];
        }

        public double[] getTvals() {
            if (this.myTvals != null) {
                return this.myTvals;
            }
            double[] tvals = new double[(this.numCoords - 2) / 6 + 1];
            double segx = this.bezierCoords[0];
            double segy = this.bezierCoords[1];
            double tlen = 0.0;
            int ci = 2;
            int ti = 0;
            while (ci < this.numCoords) {
                double prevx = segx;
                double prevy = segy;
                double newx = this.bezierCoords[ci++];
                double newy = this.bezierCoords[ci++];
                double len = Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                prevx = newx;
                prevy = newy;
                newx = this.bezierCoords[ci++];
                newy = this.bezierCoords[ci++];
                len += Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                prevx = newx;
                prevy = newy;
                newx = this.bezierCoords[ci++];
                newy = this.bezierCoords[ci++];
                len += Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                len += Math.sqrt((segx -= newx) * segx + (segy -= newy) * segy);
                if ((len /= 2.0) < 0.001) {
                    len = 0.001;
                }
                tvals[ti++] = tlen += len;
                segx = newx;
                segy = newy;
            }
            double prevt = tvals[0];
            tvals[0] = 0.0;
            for (ti = 1; ti < tvals.length - 1; ++ti) {
                double nextt = tvals[ti];
                tvals[ti] = prevt / tlen;
                prevt = nextt;
            }
            tvals[ti] = 1.0;
            this.myTvals = tvals;
            return tvals;
        }

        public void setTvals(double[] newTvals) {
            double y1;
            double x1;
            double[] oldCoords = this.bezierCoords;
            double[] newCoords = new double[2 + (newTvals.length - 1) * 6];
            double[] oldTvals = this.getTvals();
            int oldci = 0;
            double xc1 = x1 = oldCoords[oldci++];
            double xc0 = x1;
            double x0 = x1;
            double yc1 = y1 = oldCoords[oldci++];
            double yc0 = y1;
            double y0 = y1;
            int newci = 0;
            newCoords[newci++] = x0;
            newCoords[newci++] = y0;
            double t0 = 0.0;
            double t1 = 0.0;
            int oldti = 1;
            int newti = 1;
            while (newti < newTvals.length) {
                if (t0 >= t1) {
                    x0 = x1;
                    y0 = y1;
                    xc0 = oldCoords[oldci++];
                    yc0 = oldCoords[oldci++];
                    xc1 = oldCoords[oldci++];
                    yc1 = oldCoords[oldci++];
                    x1 = oldCoords[oldci++];
                    y1 = oldCoords[oldci++];
                    t1 = oldTvals[oldti++];
                }
                int n = newti++;
                double nt = newTvals[n];
                if (nt < t1) {
                    double relt = (nt - t0) / (t1 - t0);
                    newCoords[newci++] = x0 = Morphing2D.interp(x0, xc0, relt);
                    newCoords[newci++] = y0 = Morphing2D.interp(y0, yc0, relt);
                    xc0 = Morphing2D.interp(xc0, xc1, relt);
                    yc0 = Morphing2D.interp(yc0, yc1, relt);
                    xc1 = Morphing2D.interp(xc1, x1, relt);
                    yc1 = Morphing2D.interp(yc1, y1, relt);
                    newCoords[newci++] = x0 = Morphing2D.interp(x0, xc0, relt);
                    newCoords[newci++] = y0 = Morphing2D.interp(y0, yc0, relt);
                    xc0 = Morphing2D.interp(xc0, xc1, relt);
                    yc0 = Morphing2D.interp(yc0, yc1, relt);
                    newCoords[newci++] = x0 = Morphing2D.interp(x0, xc0, relt);
                    newCoords[newci++] = y0 = Morphing2D.interp(y0, yc0, relt);
                } else {
                    newCoords[newci++] = xc0;
                    newCoords[newci++] = yc0;
                    newCoords[newci++] = xc1;
                    newCoords[newci++] = yc1;
                    newCoords[newci++] = x1;
                    newCoords[newci++] = y1;
                }
                t0 = nt;
            }
            this.bezierCoords = newCoords;
            this.numCoords = newCoords.length;
            this.myTvals = newTvals;
        }
    }

    private static class Iterator
    implements PathIterator {
        AffineTransform at;
        Geometry g0;
        Geometry g1;
        double t;
        int cindex;
        double[] dcoords;

        public Iterator(AffineTransform at, Geometry g0, Geometry g1, double t) {
            this.at = at;
            this.g0 = g0;
            this.g1 = g1;
            this.t = t;
        }

        @Override
        public int getWindingRule() {
            return this.g0.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.cindex > this.g0.getNumCoords();
        }

        @Override
        public void next() {
            this.cindex = this.cindex == 0 ? 2 : (this.cindex += 6);
        }

        @Override
        public int currentSegment(float[] coords) {
            int type;
            if (this.dcoords == null) {
                this.dcoords = new double[6];
            }
            if ((type = this.currentSegment(this.dcoords)) != 4) {
                coords[0] = (float)this.dcoords[0];
                coords[1] = (float)this.dcoords[1];
                if (type != 0) {
                    coords[2] = (float)this.dcoords[2];
                    coords[3] = (float)this.dcoords[3];
                    coords[4] = (float)this.dcoords[4];
                    coords[5] = (float)this.dcoords[5];
                }
            }
            return type;
        }

        @Override
        public int currentSegment(double[] coords) {
            int n;
            int type;
            if (this.cindex == 0) {
                type = 0;
                n = 2;
            } else if (this.cindex >= this.g0.getNumCoords()) {
                type = 4;
                n = 0;
            } else {
                type = 3;
                n = 6;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    coords[i] = Morphing2D.interp(this.g0.getCoord(this.cindex + i), this.g1.getCoord(this.cindex + i), this.t);
                }
                if (this.at != null) {
                    this.at.transform(coords, 0, coords, 0, n / 2);
                }
            }
            return type;
        }
    }
}

