/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSPIAuthentication;
import java.util.logging.Logger;

final class AuthenticationJNI
extends SSPIAuthentication {
    private static final int maximumpointersize = 128;
    private static boolean enabled = false;
    private static Logger authLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.AuthenticationJNI");
    private static int sspiBlobMaxlen = 0;
    private byte[] sniSec = new byte[128];
    private int[] sniSecLen = new int[]{0};
    private final String DNSName;
    private final int port;
    private SQLServerConnection con;
    private static final UnsatisfiedLinkError linkError;

    static int GetMaxSSPIBlobSize() {
        return sspiBlobMaxlen;
    }

    AuthenticationJNI(SQLServerConnection sQLServerConnection, String string, int n) throws SQLServerException {
        if (!enabled) {
            sQLServerConnection.terminate(0, SQLServerException.getErrString("R_notConfiguredForIntegrated"), linkError);
        }
        this.con = sQLServerConnection;
        this.DNSName = AuthenticationJNI.GetDNSName(string);
        this.port = n;
    }

    byte[] GenerateClientContext(byte[] byArray, boolean[] blArray) throws SQLServerException {
        int[] nArray = new int[]{AuthenticationJNI.GetMaxSSPIBlobSize()};
        byte[] byArray2 = new byte[nArray[0]];
        assert (this.DNSName != null);
        int n = AuthenticationJNI.SNISecGenClientContext(this.sniSec, this.sniSecLen, byArray, byArray.length, byArray2, nArray, blArray, this.DNSName, this.port, null, null, authLogger);
        if (n != 0) {
            authLogger.warning(this.toString() + " Authentication failed code : " + n);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), linkError);
        }
        byte[] byArray3 = new byte[nArray[0]];
        System.arraycopy(byArray2, 0, byArray3, 0, nArray[0]);
        return byArray3;
    }

    int ReleaseClientContext() {
        int n = 0;
        if (this.sniSecLen[0] > 0) {
            n = AuthenticationJNI.SNISecReleaseClientContext(this.sniSec, this.sniSecLen[0], authLogger);
            this.sniSecLen[0] = 0;
        }
        return n;
    }

    private static String GetDNSName(String string) {
        String[] stringArray = new String[1];
        if (AuthenticationJNI.GetDNSName(string, stringArray, authLogger) != 0) {
            stringArray[0] = string;
        }
        return stringArray[0];
    }

    private static native int SNISecGenClientContext(byte[] var0, int[] var1, byte[] var2, int var3, byte[] var4, int[] var5, boolean[] var6, String var7, int var8, String var9, String var10, Logger var11);

    private static native int SNISecReleaseClientContext(byte[] var0, int var1, Logger var2);

    private static native int SNISecInitPackage(int[] var0, Logger var1);

    private static native int SNISecTerminatePackage(Logger var0);

    private static native int SNIGetSID(byte[] var0, Logger var1);

    private static native boolean SNIIsEqualToCurrentSID(byte[] var0, Logger var1);

    private static native int GetDNSName(String var0, String[] var1, Logger var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        try {
            String string = "sqljdbc_auth";
            System.loadLibrary(string);
            int[] nArray = new int[]{0};
            if (0 != AuthenticationJNI.SNISecInitPackage(nArray, authLogger)) {
                throw new UnsatisfiedLinkError();
            }
            sspiBlobMaxlen = nArray[0];
            enabled = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
            unsatisfiedLinkError = unsatisfiedLinkError2;
            authLogger.warning("Failed to load the sqljdbc_auth.dll cause : " + unsatisfiedLinkError2.getMessage());
        }
        finally {
            linkError = unsatisfiedLinkError;
        }
    }
}

