## Documentation for danielburger1337/oauth2-dpop

> This documentation tries to explain most concepts of DPoP, but please familiarize yourself with the [Specification](https://datatracker.ietf.org/doc/html/rfc9449) before continuing.

This library provides implementations for authorization servers, resource servers and clients.

The documentation is split into the three different topics:

-   [Authorization Server](authorization_server.md)
-   [Resource Server](resource_server.md)
-   [Client](client.md)

---

Additionally, there are documentations for individual components that are referenced at various points in the documentation:

-   [Nonce Storage](nonce_storage.md)
-   [Nonce-Factory](nonce_factory.md)

-   [Token Encoder](token_encoder.md)
-   [Token Loader](token_loader.md)

-   [Proof Verifier](proof_verifier.md)
-   [Proof Factory](proof_factory.md)

-   [Replay Attack](replay_attack.md)
-   [Access Token](access_token.md)
