{{ @master('layouts.master') }}
{{ @section('title', 'Clean Blog - Contact') }}
{{ @section('meta') }}
<meta property="og:type" content="website" />
<meta property="og:url"
  content="https://stackoverflow.com/questions/8221022/css-not-loading-after-redirect-with-htaccess-rewrite-rule" />
<meta property="og:site_name" content="Stack Overflow" />
<meta property="og:image" itemprop="image primaryImageOfPage"
  content="https://cdn.sstatic.net/Sites/stackoverflow/img/apple-touch-icon@2.png?v=73d79a89bded" />
<meta name="twitter:card" content="summary" />
<meta name="twitter:domain" content="stackoverflow.com" />
<meta name="twitter:title" property="og:title" itemprop="title name"
  content="CSS not loading after redirect with htaccess rewrite rule" />
<meta name="twitter:description" property="og:description" itemprop="description"
  content="I have the following Short-hand for a user profile url" />
{{ @endsection(); }}

{{ @section('content') }}
<!-- Page Header -->
<header class="masthead" style="background-image: url({{ assets('assets/template/img/home-bg.jpg') }})">
  <div class="overlay"></div>
  <div class="container">
    <div class="row">
      <div class="col-lg-8 col-md-10 mx-auto">
        <div class="page-heading">
          <h1>Contact Me</h1>
          <span class="subheading">Have questions? I have answers.</span>
        </div>
      </div>
    </div>
  </div>
</header>

<!-- Main Content -->
<div class="container">
  <div class="row">
    <div class="col-lg-8 col-md-10 mx-auto">
      <p>Want to get in touch? Fill out the form below to send me a message and I will get back to you as soon as
        possible!</p>
      <!-- Contact Form - Enter your email address on line 19 of the mail/contact_me.php file to make this form work. -->
      <!-- WARNING: Some web hosts do not allow emails to be sent through forms to common mail hosts like Gmail or Yahoo. It's recommended that you use a private domain email address! -->
      <!-- To use the contact form, your site must be on a live web host with PHP! The form will not work locally! -->
      <form name="sentMessage" id="contactForm" method="post" action="/contact">
        <div class="control-group">
          <div class="form-group floating-label-form-group controls">
            <label>Name</label>
            <input type="text" class="form-control" placeholder="Name" name="name" id="name" required
              data-validation-required-message="Please enter your name.">
            <p class="help-block text-danger"></p>
          </div>
        </div>
        <div class="control-group">
          <div class="form-group floating-label-form-group controls">
            <label>Email Address</label>
            <input type="email" class="form-control" placeholder="Email Address" name="email" id="email" required
              data-validation-required-message="Please enter your email address.">
            <p class="help-block text-danger"></p>
          </div>
        </div>
        <div class="control-group">
          <div class="form-group col-xs-12 floating-label-form-group controls">
            <label>Phone Number</label>
            <input type="tel" class="form-control" placeholder="Phone Number" name="phone" id="phone" required
              data-validation-required-message="Please enter your phone number.">
            <p class="help-block text-danger"></p>
          </div>
        </div>
        <div class="control-group">
          <div class="form-group floating-label-form-group controls">
            <label>Message</label>
            <textarea rows="5" class="form-control" placeholder="Message" name="message" id="message" required
              data-validation-required-message="Please enter a message."></textarea>
            <p class="help-block text-danger"></p>
          </div>
        </div>
        <br>
        <div id="success"></div>
        <div class="form-group">
          <button type="submit" class="btn btn-primary" id="sendMessageButton">Send</button>
        </div>
      </form>
    </div>
  </div>
</div>

{{ @endsection() }}