# PHPCI Documentation

#### Getting Started
* **[Installing PHPCI](installing-phpci)**
    * [Adding a Virtual Host](add-a-virtual-host)
    * [Run Builds Using a Worker](run-builds-using-a-worker)
    * [Run Builds Using a Daemon](run-builds-using-a-daemon)
    * [Run Builds Using Cron](run-builds-using-cron)
    * **Platform Specific Guides:**
        * [Installing PHPCI on Mac OSX Mavericks](vanilla-mac-mavericks-server-installation-guide)
        * [Installing PHPCI on Mac OSX Yosemite](vanilla-installation-on-os-x-10.10-yosemite-with-os-x-server-4)
* **[Adding PHPCI Support to Your Projects](adding-phpci-support-to-your-projects)**
* [Setting up Logging](logging)
* [Updating PHPCI](updating-phpci)
* [Configuring PHPCI](configuring-phpci)

#### Using PHPCI
* Automatically building commits pushed to
  * [Github](autobuilding-from-github)
  * [Bitbucket](autobuilding-from-bitbucket)
  * [GitLab](autobuilding-from-gitlab)
  * [Git](autobuilding-from-git)
* [Injecting variables into messages](interpolation)
* [Project Status Images and Status Page](project-status-images-and-page)

#### Contributing
* [Contributing to PHPCI](https://github.com/dancryer/PHPCI/blob/master/.github/CONTRIBUTING.md)
* [Maintainers](maintainers)

#### Plugins
* [Atoum](atoum-plugin) - `atoum`
* [Behat](behat-plugin) - `behat`
* [Campfire](campfire-plugin) - `campfire`
* [Clean Build](clean-build-plugin) - `clean_build`
* [Codeception](codeception-plugin) - `codeception`
* [Composer](composer-plugin) - `composer`
* [Copy Build](copy-build-plugin) - `copy_build`
* [Deployer](deployer) - `deployer`
* [Email](email-plugin) - `email`
* [Env](env-plugin) - `env`
* [Grunt](grunt-plugin) - `grunt`
* [Hipchat](hipchat-notify-plugin) - `hipchat_notify`
* [IRC](irc-plugin) - `irc`
* [Lint](lint-plugin) - `lint`
* [MySQL](mysql-plugin) - `mysql`
* [Package Build](package-build-plugin) - `package_build`
* [PDepend](pdepend-plugin) - `pdepend`
* [PostgreSQL](postgresql-plugin) - `pgsql`
* [Phar](phar-plugin) - `phar`
* [Phing](phing-plugin) - `phing`
* [PHP Code Sniffer](php-code-sniffer-plugin) - `php_code_sniffer`
* [PHP Copy/Paste Detector](php-copy-paste-detector-plugin) - `php_cpd`
* [PHP Coding Standards Fixer](php-coding-standards-fixer-plugin) - `php_cs_fixer`
* [PHP Docblock Checker](php-docblock-checker) - `php_docblock_checker`
* [PHP Loc](php-loc-plugin) - `php_loc`
* [PHP Mess Detector](php-mess-detector-plugin) - `php_mess_detector`
* [PHP Parallel Lint](php-parallel-lint-plugin) - `php_parallel_lint`
* [PHP Spec](php-spec-plugin) - `php_spec`
* [PHP Unit](phpunit-plugin) - `php_unit`
* [Shell](shell-plugin) - `shell`
* [Slack](slack-notify-plugin) - `slack_notify`
* [Technical Debt](technical-debt-plugin) - `technical_debt`
* [XMPP](xmpp-notifications-plugin) - `xmpp`

#### 3rd Party and custom plugins
* [Setup 3rd party plugins](custom-plugins-setup)