Contributions to PHPCI are very much encouraged, and we do our best to make it as welcoming and simple as possible.

### Before You Start
Before you start, please make sure that you are aware of, and agree to, the following conditions of contribution:

* By making a contribution to PHPCI, you accept that you are granting copyright ownership for that contribution to Block 8 Limited - the company responsible for PHPCI. In countries where copyright reassignment is not permitted, you grant Block 8 Limited a perpetual, non-exclusive licence to use your contribution in any way and for any purpose.

* By making a contribution to PHPCI, you accept that your code will be released under the open-source [BSD 2-Clause Licence](https://github.com/Block8/PHPCI/blob/master/LICENSE.md).

Block 8 are committed to PHPCI being a truly free and open source project, providing easy to use continuous integration and testing to as many developers as possible. We may, at our sole discretion, provide paid services based upon PHPCI - but PHPCI will always remain free (as in cost, and freedom) and open source.

### The Contribution Process

1. If you are thinking of making a large change or feature addition, [open an issue](/Block8/PHPCI/issues) titled "Intent to implement: <Your Feature>". Describe your idea in detail and discuss it with the community. It might be that someone already has a plan, could help you out, or your idea may simply not be suitable for the project at this time.
2. Fork the PHPCI project on Github
3. Add a feature or fix a bug - We recommend that you do this on a branch within your repository.
4. Create a pull request containing just the one change you want to contribute back to PHPCI. If you have more than one feature or bug fix, please create separate branches within your repository, and then submit a separate pull request for each one. Your pull request should use the template detailed below.
5. We'll then review your pull request and give any necessary feedback, this could be:
    * Suggestions to improve your implementation
    * Questions
    * Issues/bugs related to the change
    * Coding standards pointers
6. Once everyone is happy with the submission, we'll merge it back into PHPCI. Your change will then be included in the next project release.

### Not sure what to start with?
We maintain two labels within our issue tracker that may be of interest to new contributors:

* [The "Easy Fix" List](https://github.com/Block8/PHPCI/labels/flag:easy-fix)
* [The "Priority" List](https://github.com/Block8/PHPCI/labels/flag:priority)

### Coding Standards
We require that all contributions meet at least the following guidelines:

* PSR-1 & PSR-2 compliance for all code
* Doc-blocks for all classes and methods
* All files must contain the standard file-level docblock, including the copyright, license and link tags.

All pull requests will be checked against these standards. If you're modifying a file as part of your change which does not comply with the above, please make the necessary changes to bring it into compliance prior to submitting the pull request.

### Other Requirements
When you're adding new features or functionality, or you're updating existing functionality, please ensure that the relevant documentation is also either created or updated on the Wiki.
