# tech-interview-study

스터디 목차는 <a href="https://github.com/Songwonseok/CS-Study">Songwonseok/CS-Study</a> 와 <a href="https://github.com/gyoogle/tech-interview-for-developer">gyoogle/tech-interview-for-developer</a> 를 참고하여 구성했습니다.  
각 주제에 대한 깊이있는 학습을 지향합니다.

## Part 1. CS 면접 질문/답변 정리

면접 전 예상 질문을 보고 스스로 답변한 후 정답을 확인합니다.

- 컴퓨터 구조
- 자료 구조
- DB
- 네트워크
- 운영체제
- 알고리즘
- <a href='https://github.com/da-in/tech-interview-study/blob/main/Interview%20Cheat%20Sheet/Web.md'>웹</a>
- <a href='https://github.com/da-in/tech-interview-study/blob/main/Interview%20Cheat%20Sheet/Software%20Engineering.md'>소프트웨어 공학</a>

<br/>

## Part 2. CS Deep Dive

충분한 시간이 있을 때 CS를 깊이있게 다루기 위한 파트입니다.

<table>
  <tr>
    <td><a href='#desktop_computer-computer-architecture'>🖥️ Computer Architecture</a></td>
    <td><a href='#open_file_folder-data-structure'>📂 Data Structure</a></td>
    <td><a href='#package-database'>📦 Database</a></td>
    <td><a href='#satellite-network'>📡 Network</a></td>
  </tr>
  <tr>
    <td><a href='#rotating_light-operating-system'>🚨 Operating System</a></td>
    <td><a href='#hatching_chick-algorithm'>🐣 Algorithm</a></td>
    <td><a href='#globe_with_meridians-web'>🌐 Web</a></td>
    <td><a href='#gear-software-engineering'>⚙️ Software Engineering</a></td>
  </tr>
  <tr>
    <td><a href='#art-design-pattern'>🎨 Design Pattern</a></td>
    <td><a href='#speaking_head-language'>🗣️ Language</a></td>
  </tr>
</table>

<br/>

## 😊 Collaborator

#### CS Deep Dive

<div>
  <a href="https://github.com/da-in">
    <img src="https://avatars.githubusercontent.com/u/66757141?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/Lee-DoHa">
    <img src="https://avatars.githubusercontent.com/u/70997596?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/HamInKyou">
    <img src="https://avatars.githubusercontent.com/u/50827930?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/lalabulla">
    <img src="https://avatars.githubusercontent.com/u/102718303?v=4" width="80" style="max-width: 100%;">
  </a>
</div>

#### CS 면접 질문/답변 정리

<div>
  <a href="https://github.com/da-in">
    <img src="https://avatars.githubusercontent.com/u/66757141?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/lalabulla">
    <img src="https://avatars.githubusercontent.com/u/102718303?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/chs98412">
    <img src="https://avatars.githubusercontent.com/u/79582366?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/jaminleee">
    <img src="https://avatars.githubusercontent.com/u/91969458?v=4" width="80" style="max-width: 100%;">
  </a>
  <a href="https://github.com/kimgwon">
    <img src="https://avatars.githubusercontent.com/u/92065911?v=4" width="80" style="max-width: 100%;">
  </a>
</div>

### Contributer

Issue와 PR로 오탈자 및 잘못된 내용을 알려주세요🙂

<a href="https://github.com/da-in/tech-interview-study/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=da-in/tech-interview-study" />
</a>

<br/>

### Rules

매주 `월요일 밤 9시` 온라인 스터디 _(공휴일 제외)_  
스터디에서는 `모의 면접`, `피드백` 및 차주 `주제 선정`  
모의 면접은 참여자 중 면접관 비율이 더 많도록 랜덤으로 당일에 선정  
모의 면접 내용을 면접관 중 1인이 수합하여 문서화

> 🚨 3회 이상 불참시 퇴출.  
> 유고 사유 | 익일 코딩테스트 및 면접, 질병(인증 필요)

<br/>

## 📌 학습 주제

### :desktop_computer: Computer Architecture

- [컴퓨터의 구성](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Computer%20Architecture/컴퓨터의%20구성.md)
- [중앙처리장치(CPU) 작동 원리](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Computer%20Architecture/%EC%A4%91%EC%95%99%EC%B2%98%EB%A6%AC%EC%9E%A5%EC%B9%98(CPU)%20%EC%9E%91%EB%8F%99%20%EC%9B%90%EB%A6%AC.md>)
- [캐시 메모리](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Computer%20Architecture/%EC%BA%90%EC%8B%9C%20%EB%A9%94%EB%AA%A8%EB%A6%AC.md)
- [실수 표현(고정소수점&부동 소수점)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Computer%20Architecture/%EC%8B%A4%EC%88%98%20%ED%91%9C%ED%98%84.md)
- [패리티 비트 & 해밍 코드](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Computer%20Architecture/%ED%8C%A8%EB%A6%AC%ED%8B%B0%20%EB%B9%84%ED%8A%B8&%ED%95%B4%EB%B0%8D%20%EC%BD%94%EB%93%9C.md)
- [ARM 프로세서](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Computer%20Architecture/ARM%20%ED%94%84%EB%A1%9C%EC%84%B8%EC%84%9C.md)

### :open_file_folder: Data Structure

- [Array](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Array.md)
- [Array & List](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Array&List.md)
- [Linked List](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Linked%20List.md)
- [스택(Stack) & 큐(Queue) & 덱(Deque)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Stack&Queue&Deque.md)
- [힙(Heap)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Heap.md)
- [트리(Tree)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/트리(Tree).md>)
- [이진탐색트리(Binary Search Tree)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/이진탐색트리(Binary Search Tree).md>)
- [레드-블랙트리(Red-Black Tree)](<https://github.com/lalabulla/tech-interview-study/edit/main/CS%20Deep%20Dive/Data%20Structure/%EB%A0%88%EB%93%9C-%EB%B8%94%EB%9E%99%ED%8A%B8%EB%A6%AC(Red-Black%20Tree).md>)
- [해시(Hash)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Hash.md)
- [트라이(Trie)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/Trie.md)
- [B-Tree & B+Tree](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Data%20Structure/B-Tree%20%26%20B%2Btree.md)

### :package: Database

- [키(Key) 정리](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/%ED%82%A4(Key)%EC%A0%95%EB%A6%AC.md>)
- [JOIN](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/JOIN.md)
- [SQL Injection](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/SQL%20Injection.md)
- [SQL vs NoSQL](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/SQL%20vs%20NoSQL.md)
- [정규화(Nomalization)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/%EC%A0%95%EA%B7%9C%ED%99%94.md)
- [이상(Anomaly)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/이상_Anomaly.md)
- [인덱스(INDEX)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/%EC%9D%B8%EB%8D%B1%EC%8A%A4(INDEX).md>)
- [트랜잭션(Transaction)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/트랜잭션(Transaction).md)
- [트랜잭션 격리 수준(Transaction Isolation Level)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/트랜잭션%20격리%20수준(Transaction%20Isolation%20Level).md>)
- [저장 프로시저(Stroed Procedure)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/저장%20프로시저.md)
- [레디스(Redis)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/%EB%A0%88%EB%94%94%EC%8A%A4(Redis).md>)

### :satellite: Network

- [OSI 7 계층](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/OSI%207%20%EA%B3%84%EC%B8%B5.md)
- [TCP & UDP](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/TCP%20%26%20UDP.md)
- [TCP 3 way handshake & 4 way handshake](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/TCP%20Handshake.md)
- [TCP/IP 흐름제어 & 혼잡제어](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/TCP%20흐름제어%20%26%20혼잡제어.md)
- [대칭키 & 공개키](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/대칭키%20&%20공개키.md)
- [HTTP & HTTPS](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/HTTP%26HTTPS.md)
- [TLS/SSL handshake](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/TLS%20%26%20SSL%20Handshake.md)
- [로드 밸런싱(Load Balancing)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Network/%EB%A1%9C%EB%93%9C%20%EB%B0%B8%EB%9F%B0%EC%8B%B1(Load%20Balancing).md>)

### :rotating_light: Operating System

- [운영체제란](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/운영체제란.md)
- [프로세스 & 스레드](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/프로세스%20&%20스레드.md)
- [프로세스 주소 공간](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/프로세스%20주소%20공간.md)
- [인터럽트(Interrupt)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/인터럽트(Interrupt).md>)
- [시스템 콜(System Call)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/시스템%20콜(System%20Call).md>)
- [PCB와 Context Switching](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/PCB%20&%20Context%20Switching.md)
- [IPC(Inter Process Communication)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/IPC(Inter%20Process%20Communication).md>)
- [CPU 스케줄링](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/CPU%20%EC%8A%A4%EC%BC%80%EC%A4%84%EB%A7%81.md)
- [데드락(DeadLock)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/데드락(Dead%20Lock).md>)
- [Race Condition](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/Race%20Condition.md)
- [세마포어(Semaphore) & 뮤텍스(Mutex)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/%EC%84%B8%EB%A7%88%ED%8F%AC%EC%96%B4(Semaphore)%20%26%20%EB%AE%A4%ED%85%8D%EC%8A%A4(Mutex).md>)
- [페이징 & 세그먼테이션(PDF)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/페이징%20&%20세그먼테이션(PDF).md>)
- [Blocking, Non-blocking, Synchronous, Asynchronous](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/Blocking,%20Non-blocking,%20Sync,%20Async.md)
- [페이지 교체 알고리즘](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/페이지%20교체%20알고리즘.md)
- [메모리 관리(Memory Management)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/메모리%20관리.md)
- [파일 시스템](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/%ED%8C%8C%EC%9D%BC%20%EC%8B%9C%EC%8A%A4%ED%85%9C.md)

### :hatching_chick: Algorithm

- [시간복잡도와 공간복잡도](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/시간복잡도와%20공간복잡도.md)
- [거품 정렬(Bubble Sort)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/Bubble%20Sort.md)
- [선택 정렬(Selection Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/%EC%84%A0%ED%83%9D%20%EC%A0%95%EB%A0%AC(Selection%20Sort).md>)
- [삽입 정렬(Insertion Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/%EC%82%BD%EC%9E%85%20%EC%A0%95%EB%A0%AC(Insertion%20Sort).md>)
- [퀵 정렬(Quick Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/%ED%80%B5%20%EC%A0%95%EB%A0%AC(Quick%20Sort).md>)
- [병합 정렬(Merge Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/%EB%B3%91%ED%95%A9%20%EC%A0%95%EB%A0%AC(Merge%20Sort).md>)
- [힙 정렬(Heap Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/%ED%9E%99%20%EC%A0%95%EB%A0%AC(Heap%20Sort).md>)
- [기수 정렬(Radix Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/기수%20정렬(Radix%20Sort).md>)
- [계수 정렬(Count Sort)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/계수%20정렬(Count%20Sort).md>)
- [이분 탐색(Binary Search)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/이분%20탐색(Binary%20Search).md>)
- [해시 테이블 구현](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/해시%20테이블%20구현.md)
- [DFS & BFS](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/BFS%26DFS.md)
- [최장 증가 수열(LIS)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/최장%20증가%20수열(LIS).md>)
- [최소 공통 조상(LCA)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/최소%20공통%20조상(LCA).md>)
- [동적 계획법(Dynamic Programming)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/%EB%8F%99%EC%A0%81%20%EA%B3%84%ED%9A%8D%EB%B2%95(Dynamic%20Programming).md>)
- [다익스트라(Dijkstra)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/다익스트라(Dijkstra).md>)
- [비트마스크(BitMask)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Algorithm/비트마스크.md)

### :globe_with_meridians: Web

- [브라우저와 렌더링](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/%EB%B8%8C%EB%9D%BC%EC%9A%B0%EC%A0%80%EC%99%80%20%EB%A0%8C%EB%8D%94%EB%A7%81.md)
- [DOM](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/DOM.md)
- Reflow&Repaint
- [쿠키(Cookie) & 세션(Session)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/Cookie%26Session.md)
- [HTTP Request Methods](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/HTTP%20Request%20Method.md)
- [HTTP Status Code](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/HTTP%20Status%20Code.md)
- [CORS](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/CORS.md)
- [REST](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/REST.md)
- [웹서버와 WAS](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/웹서버와%20WAS.md)
- [OAuth](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/OAuth.md)
- [JWT(JSON Web Token)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/JWT.md)
- [Authentication and Authorization](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/Authentication%26Authorization.md)
- [로그레벨](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/로그레벨.md)
- [UI/UX](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/UI_UX.md)
- [CSR & SSR](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/CSR&SSR.md)
- [Cross Browsing](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/Cross_Browsing.md)
- Vue.js vs React
- 네이티브 앱 & 웹 앱 & 하이브리드 앱
- PWA(Progressive Web App)
- [CSRF & XSS](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/CSRF%26XSS.md)
- 웹 성능 최적화
- CSS Methodology
- [CSS](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Web/CSS.md)
- 클라우드
- 모노레포
- Storybook
- RSC
- Suspense

### :gear: Software Engineering

- 클린코드(리팩토링 & 시큐어코딩)
- [TDD(Test Driven Development)](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Software%20Engineering/TDD.md)
- 애자일(Agile)
- [객체 지향 프로그래밍(Object-Oriented Programming)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Software%20Engineering/%EA%B0%9D%EC%B2%B4%20%EC%A7%80%ED%96%A5%20%ED%94%84%EB%A1%9C%EA%B7%B8%EB%9E%98%EB%B0%8D(Object-Oriented%20Programming).md>)
- 함수형 프로그래밍(Fuctional Programming)
- [데브옵스(DevOps)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Software%20Engineering/%EB%8D%B0%EB%B8%8C%EC%98%B5%EC%8A%A4(DevOps).md>)
- 서드 파티(3rd party)
- [마이크로서비스 아키텍처(MSA)](<https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Software%20Engineering/%EB%A7%88%EC%9D%B4%ED%81%AC%EB%A1%9C%EC%84%9C%EB%B9%84%EC%8A%A4%20%EC%95%84%ED%82%A4%ED%85%8D%EC%B2%98(MSA).md>)

### :art: Design Pattern

- [Design Pattern](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Design%20Pattern.md)
- [SOLID](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/SOLID.md)
- [싱글톤 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/SingleTon.md)
- [팩토리 메소드 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Factory%20Method%20Pattern.md)
- [추상 팩토리 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Abstract%20Factory%20Pattern.md)
- [프로토타입 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Prototype%20Pattern.md)
- [어댑터 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Adapter%20Pattern.md)
- [컴포지트 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Composite%20Pattern.md)
- [옵저버 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/옵저버%20패턴.md)
- [스트레티지 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/스트래티지%20패턴.md)
- [탬플릿 메소드 패턴](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Design%20Pattern/Template%20Method%20Pattern.md)

### :speaking_head: Language

<details>
  <summary>C</summary>
  
  - [C] C언어 컴파일 과정
  - [C] 구조체 메모리 크기 계산
  - [C] 포인터(Pointer)
  - [C] 동적할당
  
</details>
<details>
  <summary>C++</summary>

- [C++] 얕은 복사 vs 깊은 복사
- [C++] 가상 함수(Virtual Function)
- [C++] 입출력 최적화하기
- [C++] Vector Container

</details>
<details>
  <summary>Java</summary>

- [[Java] Java 컴파일 과정](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Language/Java/Java%EC%BB%B4%ED%8C%8C%EC%9D%BC%20%EA%B3%BC%EC%A0%95.md)
- [Java] Call by Value vs Call by Reference
- [Java] String & StringBuffer & StringBuilder
- [Java] 자바 가상 머신(Java Virtual Machine)
- [Java] Casting(업캐스팅 & 다운캐스팅)
- [Java] 오토 박싱 & 오토언박싱
- [Java] Thread 활용
- [Java] 고유 락(Intrinsic Lock)
- [Java] 문자열 클래스
- [Java] Garbage Collection
- [Java] Promotion & Casting
- [Java] Primitive type & Reference type
- [Java] 직렬화(Serialization)
- [Java] Error & Exception
- [Java] Stream API
- [Java] Record
- [Java] Interend String in Java
- [Java] Composition

</details>
<details>
  <summary>Javascript</summary>
  
  - [Javascript] ES2015+ 요약 정리
  - [Javascript] Object Prototype
  - [Javascript] Closure
  - [[Javascript] Hoisting](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Language/Javascript/Hoisting.md)
  
</details>
<details>
  <summary>Python</summary>
  
  - [Python] 매크로 사용법
  
</details>

### :pushpin: Linux

### :pushpin: New Technology

### :pushpin: Seminar

### :pushpin: ETC
