# The Wizards Sorting Hat Project Code of Conduct

## Welcome

Welcome to the **The Wizards Sorting Hat** repository! **The Wizards Sorting Hat** is a fun web-based quiz that determines which Hogwarts House (Gryffindor, Hufflepuff, Ravenclaw, or Slytherin) you belong to based on your personality traits. The website asks a series of questions, and based on the user's answers, it sorts them into a house. Our goal is to create an open, inclusive, and respectful environment where developers can engage and collaborate. We are committed to maintaining a harassment-free experience for everyone involved.

## Our Pledge

We as members, contributors, and leaders pledge to make participation in **The Wizards Sorting Hat** a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

We pledge to act in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community, ensuring that all contributors feel supported and empowered to engage meaningfully in the project.

## Our Standards

To maintain a positive, constructive, and respectful environment in the **The Wizards Sorting Hat** project, all participants are expected to adhere to the following standards:

### Positive Behavior:
- **Respectful Communication**: Engage with others respectfully, ensuring that discussions remain professional and focused on the goals of the project.
- **Constructive Feedback**: Provide feedback that is constructive, helpful, and aimed at improving contributions while being respectful and encouraging.
- **Collaboration**: Work openly and cooperatively with others, sharing knowledge and ideas that contribute to the growth of the platform.
- **Inclusivity**: Use language and actions that welcome and include all participants, regardless of their background or experience level.
- **Recognition**: Acknowledge and appreciate the contributions of all members, whether through code, design, feedback, or discussions.
- **Professionalism**: Maintain professionalism in all interactions, ensuring that the project’s goals and values are prioritized.

### Unacceptable Behavior:
- **Harassment**: Any form of harassment, including unwelcome comments, personal attacks, or inappropriate behavior, is strictly prohibited.
- **Discrimination**: Discriminatory remarks or behavior based on personal identity, beliefs, or background will not be tolerated.
- **Disrespect**: Engaging in trolling, dismissive comments, or inflammatory remarks that disrupt the collaborative nature of the project is unacceptable.
- **Privacy Violations**: Sharing private or sensitive information about others without their explicit consent is not allowed.
- **Unethical Conduct**: Misusing the platform, violating ethical standards, or spreading misinformation is prohibited.
- **Disruption**: Any actions that intentionally disrupt or interfere with the progress of the project or the community’s efforts will not be tolerated.

## Project Goals

The **The Wizards Sorting Hat** project aims to create a social platform that allows developers to engage with the GitHub community through authenticated interactions. The key goals include:
- **Community Engagement**: Providing a space for developers to share thoughts, ideas, and insights with the wider GitHub community.
- **Collaboration**: Encouraging interaction and collaboration among developers through meaningful discussions and updates.
- **GitHub Profile Exploration**: Enabling users to explore the GitHub profiles of fellow developers, facilitating networking and knowledge-sharing.
- **Open Source Contributions**: Promoting open-source development and collaboration, allowing contributors to enhance the platform’s features and capabilities.

## Enforcement Responsibilities

Community leaders and maintainers of the **The Wizards Sorting Hat** project are responsible for enforcing this Code of Conduct. They are expected to:

- Clearly communicate the standards for acceptable behavior and ensure that all participants are aware of them.
- Respond to violations of the Code of Conduct in a timely and fair manner.
- Take appropriate corrective actions, such as removing inappropriate comments, posts, or contributions that do not align with community standards.
- Apply disciplinary measures, including temporary or permanent bans, in cases of repeated or serious violations of the Code of Conduct.

## Scope

This Code of Conduct applies to all spaces managed by **The Wizards Sorting Hat**, including GitHub repositories, issue trackers, discussions, and other communication platforms. It also applies when community members represent the project in public spaces, such as conferences, online events, or forums.

## Reporting Violations

If you experience or witness behavior that violates this Code of Conduct, please report it by contacting the project leaders at **divy777888@gmail.com**. All complaints will be reviewed promptly and confidentially. The community leaders are committed to ensuring a safe and positive environment and will take appropriate action to address any issues.

## Consequences of Unacceptable Behavior

If a community member is found to have violated this Code of Conduct, the community leaders may take the following actions:

1. **Correction**: A private conversation with the individual to address the violation and provide guidance on how to improve their behavior.
2. **Warning**: A formal warning outlining the unacceptable behavior and providing expectations for future conduct.
3. **Temporary Suspension**: A temporary suspension from participating in the project or community spaces, with the possibility of reinstatement after review.
4. **Permanent Ban**: Permanent removal from the project and all community spaces for repeated or severe violations.

## Enforcement Guidelines

Community leaders will follow these guidelines when determining the consequences for violations of this Code of Conduct:

1. **Correction**:
   - **Community Impact**: A minor violation that causes minimal disruption to the project.
   - **Consequence**: A private conversation to clarify the violation and provide guidance on behavior improvement.

2. **Warning**:
   - **Community Impact**: A moderate violation that negatively affects the collaborative environment of the project.
   - **Consequence**: A formal warning with clear expectations for future behavior.

3. **Temporary Suspension**:
   - **Community Impact**: A significant violation that harms the community or disrupts the progress of the project.
   - **Consequence**: Temporary suspension from participating in the project, with the possibility of reinstatement after review.

4. **Permanent Ban**:
   - **Community Impact**: A severe or repeated violation that undermines the project’s goals or the community’s values.
   - **Consequence**: Permanent removal from the project and all related spaces.

## Building a Positive Community

At **The Wizards Sorting Hat**, we are dedicated to creating a welcoming, inclusive, and supportive community where developers can engage, share insights, and collaborate effectively. By working together, we can create a platform that promotes meaningful interaction and knowledge sharing among GitHub users. Let’s work together with respect, integrity, and a shared passion for connecting developers through innovative solutions.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 2.0, available [here](https://www.contributor-covenant.org/version/2/0/code_of_conduct.html).
