# Contributor Covenant Code of Conduct

## Our Pledge

We, the members, contributors, and leaders of this community, commit to creating a harassment-free and inclusive experience for **everyone**. We value and celebrate diversity in all its forms, including but not limited to:

* **Language, Age, Body Size, Visible or Invisible Disability, Ethnicity, Sex Characteristics, Gender Identity and Expression, Level of Experience, Education, Socio-economic Status, Nationality, Personal Appearance, Race, Religion, Sexual Identity, and Orientation.**

We pledge to go beyond simply avoiding harmful behavior; we actively cultivate a welcoming and respectful environment by:

* **Treating each other with kindness, empathy, and respect.**
* **Valuing diverse perspectives, experiences, and contributions.**
* **Communicating thoughtfully and constructively.**
* **Assuming good intentions and approaching disagreements with a willingness to understand.**
* **Taking responsibility for our actions and working to learn and grow together.**

We believe that a diverse and inclusive community is a stronger community. This shared pledge guides our actions and interactions as we build this project together. 

## Our Standards

We are committed to creating an inclusive and respectful environment.  We strive to:

**Positive Interactions:**

* **Treat everyone with respect and consideration**, valuing diverse perspectives, experiences, and backgrounds.
* **Assume good intentions** and avoid making assumptions about others.
* **Be empathetic and understanding** in our communication, recognizing that not everyone expresses themselves in the same way.
* **Use welcoming and inclusive language**, avoiding jargon, slang, or terminology that might be unfamiliar or offensive.
* **Give and receive constructive feedback gracefully**, focusing on the content rather than personal attacks.

**Collaboration and Professionalism:**

* **Focus on what is best for the community as a whole**, even if it means setting aside personal preferences.
* **Be mindful of the time and energy of others**, keeping discussions focused and avoiding unnecessary distractions.
* **Take responsibility for our words and actions**, acknowledging mistakes and working to learn from them.
* **Seek to understand different viewpoints**, even if we disagree, and engage in respectful dialogue.

**Unacceptable Behavior:**

* **Harassment, discrimination, or exclusion** of any kind, including (but not limited to) comments or actions based on:
    * Age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.
* **Sexualized language or imagery**, unwanted sexual attention, or advances of any kind.
* **Trolling, insulting, or derogatory comments**, personal or political attacks, or any form of bullying.
* **Public or private harassment**, including stalking, intimidation, or unwanted attention.
* **Sharing private information** of others without their explicit consent.
* **Disrupting the community** through spamming, intentional misinformation, or harmful behavior.
* **Any conduct that could reasonably be considered unprofessional or inappropriate** in a collaborative setting. 

## Enforcement Responsibilities

Community leaders are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Community leaders have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

## Scope

This Code of Conduct applies to all community spaces, including but not limited to:

* **Code repositories (e.g., GitHub)**: This includes pull requests, issues, discussions, code reviews, and any other interactions within the project's codebase.
* **Communication channels:**  Such as mailing lists, forums, chat platforms (e.g., Slack, Discord), online meetings, and social media groups associated with the project. 
* **Project-related events:** Both online and in-person events such as conferences, meetups, workshops, or hackathons.

Furthermore, this Code of Conduct applies when individuals represent the community in any official capacity. Examples include:

* **Using official project branding:**  Such as email addresses, social media accounts, or websites affiliated with the project.
* **Acting as a designated representative:**  At conferences, workshops, or in interactions with external parties. 
* **Contributing to official project documentation or resources.**

**We expect anyone who interacts with our community to adhere to this Code of Conduct, regardless of their role or level of involvement.** 

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the community leaders responsible for enforcement at
cyb3rhack3r@outlook.com.
All complaints will be reviewed and investigated promptly and fairly.

All community leaders are obligated to respect the privacy and security of the
reporter of any incident.

## Enforcement Guidelines

Community leaders will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**Community Impact**: Use of inappropriate language or other behavior deemed
unprofessional or unwelcome in the community.

**Consequence**: A private, written warning from community leaders, providing
clarity around the nature of the violation and an explanation of why the
behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Community Impact**: A violation through a single incident or series
of actions.

**Consequence**: A warning with consequences for continued behavior. No
interaction with the people involved, including unsolicited interaction with
those enforcing the Code of Conduct, for a specified period of time. This
includes avoiding interactions in community spaces as well as external channels
like social media. Violating these terms may lead to a temporary or
permanent ban.

### 3. Temporary Ban

**Community Impact**: A serious violation of community standards, including
sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community
standards, including sustained inappropriate behavior,  harassment of an
individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within
the community.

## Attribution

This Code of Conduct is based on the [Contributor Covenant][homepage], version 2.0. While we drew inspiration from this widely respected template, we have made modifications to tailor it to the specific needs and values of our community. 

[homepage]: https://www.contributor-covenant.org/version/2/0/code_of_conduct.html

You can find the original Contributor Covenant, along with answers to frequently asked questions and translations, at the link above. 

For answers to common questions about this code of conduct, see the FAQ at
https://www.contributor-covenant.org/faq. Translations are available at
https://www.contributor-covenant.org/translations.
