/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.view;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.KVView;
import com.taobao.arthas.core.view.LadderView;
import com.taobao.arthas.core.view.TableView;
import com.taobao.arthas.core.view.View;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.CodeSource;

public class ClassInfoView
implements View {
    private final Class<?> clazz;
    private final boolean isPrintField;
    private final int width;

    public ClassInfoView(Class<?> clazz, boolean isPrintField, int width) {
        this.clazz = clazz;
        this.isPrintField = isPrintField;
        this.width = width;
    }

    @Override
    public String draw() {
        return this.drawClassInfo();
    }

    private String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return "";
        }
        return cs.getLocation().getFile();
    }

    private String drawClassInfo() {
        CodeSource cs = this.clazz.getProtectionDomain().getCodeSource();
        TableView view = new TableView(new TableView.ColumnDefine[]{new TableView.ColumnDefine("isAnonymousClass".length(), false, TableView.Align.RIGHT), new TableView.ColumnDefine(this.width - "isAnonymousClass".length() - 7, false, TableView.Align.LEFT)}).addRow("class-info", StringUtils.classname(this.clazz)).addRow("code-source", this.getCodeSource(cs)).addRow("name", StringUtils.classname(this.clazz)).addRow("isInterface", this.clazz.isInterface()).addRow("isAnnotation", this.clazz.isAnnotation()).addRow("isEnum", this.clazz.isEnum()).addRow("isAnonymousClass", this.clazz.isAnonymousClass()).addRow("isArray", this.clazz.isArray()).addRow("isLocalClass", this.clazz.isLocalClass()).addRow("isMemberClass", this.clazz.isMemberClass()).addRow("isPrimitive", this.clazz.isPrimitive()).addRow("isSynthetic", this.clazz.isSynthetic()).addRow("simple-name", this.clazz.getSimpleName()).addRow("modifier", StringUtils.modifier(this.clazz.getModifiers(), ',')).addRow("annotation", this.drawAnnotation()).addRow("interfaces", this.drawInterface()).addRow("super-class", this.drawSuperClass()).addRow("class-loader", this.drawClassLoader());
        if (this.isPrintField) {
            view.addRow("fields", this.drawField());
        }
        return view.hasBorder(true).padding(1).draw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String drawField() {
        StringBuilder fieldSB = new StringBuilder();
        Field[] fields = this.clazz.getDeclaredFields();
        if (null != fields && fields.length > 0) {
            for (Field field : fields) {
                KVView kvView = new KVView(new TableView.ColumnDefine(TableView.Align.RIGHT), new TableView.ColumnDefine(50, false, TableView.Align.LEFT)).add("modifier", StringUtils.modifier(field.getModifiers(), ',')).add("type", StringUtils.classname(field.getType())).add("name", field.getName());
                StringBuilder annotationSB = new StringBuilder();
                Annotation[] annotationArray = field.getAnnotations();
                if (null != annotationArray && annotationArray.length > 0) {
                    for (Annotation annotation : annotationArray) {
                        annotationSB.append(StringUtils.classname(annotation.annotationType())).append(",");
                    }
                    if (annotationSB.length() > 0) {
                        annotationSB.deleteCharAt(annotationSB.length() - 1);
                    }
                    kvView.add("annotation", annotationSB);
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    boolean isAccessible = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        kvView.add("value", StringUtils.objectToString(field.get(null)));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    finally {
                        field.setAccessible(isAccessible);
                    }
                }
                fieldSB.append(kvView.draw()).append("\n");
            }
        }
        return fieldSB.toString();
    }

    private String drawAnnotation() {
        StringBuilder annotationSB = new StringBuilder();
        Annotation[] annotationArray = this.clazz.getDeclaredAnnotations();
        if (null != annotationArray && annotationArray.length > 0) {
            for (Annotation annotation : annotationArray) {
                annotationSB.append(StringUtils.classname(annotation.annotationType())).append(",");
            }
            if (annotationSB.length() > 0) {
                annotationSB.deleteCharAt(annotationSB.length() - 1);
            }
        } else {
            annotationSB.append("");
        }
        return annotationSB.toString();
    }

    private String drawInterface() {
        StringBuilder interfaceSB = new StringBuilder();
        Class<?>[] interfaceArray = this.clazz.getInterfaces();
        if (null == interfaceArray || interfaceArray.length == 0) {
            interfaceSB.append("");
        } else {
            for (Class<?> i : interfaceArray) {
                interfaceSB.append(i.getName()).append(",");
            }
            if (interfaceSB.length() > 0) {
                interfaceSB.deleteCharAt(interfaceSB.length() - 1);
            }
        }
        return interfaceSB.toString();
    }

    private String drawSuperClass() {
        LadderView ladderView = new LadderView();
        Class<?> superClass = this.clazz.getSuperclass();
        if (null != superClass) {
            ladderView.addItem(StringUtils.classname(superClass));
            while (null != (superClass = superClass.getSuperclass())) {
                ladderView.addItem(StringUtils.classname(superClass));
            }
        }
        return ladderView.draw();
    }

    private String drawClassLoader() {
        LadderView ladderView = new LadderView();
        ClassLoader loader = this.clazz.getClassLoader();
        if (null != loader) {
            ladderView.addItem(loader.toString());
            while (null != (loader = loader.getParent())) {
                ladderView.addItem(loader.toString());
            }
        }
        return ladderView.draw();
    }
}

