#include "Globals.h"

#include "Palette_1_16.h"
#include "Registries/BlockStates.h"

namespace Palette_1_16
{
	UInt32 From(const BlockState Block)
	{
		using namespace Block;

		switch (Block.ID)
		{
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6442;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6443;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6444;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6445;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 6446;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 6447;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 6448;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 6449;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6450;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6451;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6452;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6453;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 6454;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 6455;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 6456;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 6457;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6458;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6459;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6460;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6461;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 6462;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 6463;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 6464;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 6465;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8930;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8931;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8932;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8933;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8934;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8935;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8936;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8937;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8938;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8939;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8940;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8941;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8942;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8943;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8944;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8945;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8946;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8947;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8948;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8949;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8950;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8951;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8952;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8953;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8954;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8955;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8956;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8957;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8958;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8959;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8960;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8961;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8962;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8963;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8964;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8965;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8966;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8967;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8968;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8969;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8970;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8971;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8972;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8973;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8974;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8975;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8976;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8977;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8978;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8979;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8980;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8981;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8982;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8983;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8984;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8985;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8986;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8987;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8988;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8989;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8990;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8991;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8992;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8993;
			case AcaciaFence::AcaciaFence(true, true, true, true).ID: return 8676;
			case AcaciaFence::AcaciaFence(true, true, true, false).ID: return 8677;
			case AcaciaFence::AcaciaFence(true, true, false, true).ID: return 8680;
			case AcaciaFence::AcaciaFence(true, true, false, false).ID: return 8681;
			case AcaciaFence::AcaciaFence(true, false, true, true).ID: return 8684;
			case AcaciaFence::AcaciaFence(true, false, true, false).ID: return 8685;
			case AcaciaFence::AcaciaFence(true, false, false, true).ID: return 8688;
			case AcaciaFence::AcaciaFence(true, false, false, false).ID: return 8689;
			case AcaciaFence::AcaciaFence(false, true, true, true).ID: return 8692;
			case AcaciaFence::AcaciaFence(false, true, true, false).ID: return 8693;
			case AcaciaFence::AcaciaFence(false, true, false, true).ID: return 8696;
			case AcaciaFence::AcaciaFence(false, true, false, false).ID: return 8697;
			case AcaciaFence::AcaciaFence(false, false, true, true).ID: return 8700;
			case AcaciaFence::AcaciaFence(false, false, true, false).ID: return 8701;
			case AcaciaFence::AcaciaFence(false, false, false, true).ID: return 8704;
			case AcaciaFence::AcaciaFence(false, false, false, false).ID: return 8705;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 8514;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 8515;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 8516;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 8517;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 8518;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 8519;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 8520;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 8521;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 8522;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 8523;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 8524;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 8525;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 8526;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 8527;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 8528;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 8529;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 8530;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 8531;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 8532;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 8533;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 8534;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 8535;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 8536;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 8537;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 8538;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 8539;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 8540;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 8541;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 8542;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 8543;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 8544;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 8545;
			case AcaciaLeaves::AcaciaLeaves(1, true).ID: return 201;
			case AcaciaLeaves::AcaciaLeaves(1, false).ID: return 202;
			case AcaciaLeaves::AcaciaLeaves(2, true).ID: return 203;
			case AcaciaLeaves::AcaciaLeaves(2, false).ID: return 204;
			case AcaciaLeaves::AcaciaLeaves(3, true).ID: return 205;
			case AcaciaLeaves::AcaciaLeaves(3, false).ID: return 206;
			case AcaciaLeaves::AcaciaLeaves(4, true).ID: return 207;
			case AcaciaLeaves::AcaciaLeaves(4, false).ID: return 208;
			case AcaciaLeaves::AcaciaLeaves(5, true).ID: return 209;
			case AcaciaLeaves::AcaciaLeaves(5, false).ID: return 210;
			case AcaciaLeaves::AcaciaLeaves(6, true).ID: return 211;
			case AcaciaLeaves::AcaciaLeaves(6, false).ID: return 212;
			case AcaciaLeaves::AcaciaLeaves(7, true).ID: return 213;
			case AcaciaLeaves::AcaciaLeaves(7, false).ID: return 214;
			case AcaciaLog::AcaciaLog(AcaciaLog::Axis::X).ID: return 85;
			case AcaciaLog::AcaciaLog(AcaciaLog::Axis::Y).ID: return 86;
			case AcaciaLog::AcaciaLog(AcaciaLog::Axis::Z).ID: return 87;
			case AcaciaPlanks::AcaciaPlanks().ID: return 19;
			case AcaciaPressurePlate::AcaciaPressurePlate(true).ID: return 3881;
			case AcaciaPressurePlate::AcaciaPressurePlate(false).ID: return 3882;
			case AcaciaSapling::AcaciaSapling(0).ID: return 29;
			case AcaciaSapling::AcaciaSapling(1).ID: return 30;
			case AcaciaSign::AcaciaSign(0).ID: return 3478;
			case AcaciaSign::AcaciaSign(1).ID: return 3480;
			case AcaciaSign::AcaciaSign(2).ID: return 3482;
			case AcaciaSign::AcaciaSign(3).ID: return 3484;
			case AcaciaSign::AcaciaSign(4).ID: return 3486;
			case AcaciaSign::AcaciaSign(5).ID: return 3488;
			case AcaciaSign::AcaciaSign(6).ID: return 3490;
			case AcaciaSign::AcaciaSign(7).ID: return 3492;
			case AcaciaSign::AcaciaSign(8).ID: return 3494;
			case AcaciaSign::AcaciaSign(9).ID: return 3496;
			case AcaciaSign::AcaciaSign(10).ID: return 3498;
			case AcaciaSign::AcaciaSign(11).ID: return 3500;
			case AcaciaSign::AcaciaSign(12).ID: return 3502;
			case AcaciaSign::AcaciaSign(13).ID: return 3504;
			case AcaciaSign::AcaciaSign(14).ID: return 3506;
			case AcaciaSign::AcaciaSign(15).ID: return 3508;
			case AcaciaSlab::AcaciaSlab(AcaciaSlab::Type::Top).ID: return 8325;
			case AcaciaSlab::AcaciaSlab(AcaciaSlab::Type::Bottom).ID: return 8327;
			case AcaciaSlab::AcaciaSlab(AcaciaSlab::Type::Double).ID: return 8329;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 7376;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 7378;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 7380;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 7382;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 7384;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 7386;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 7388;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 7390;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 7392;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 7394;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 7396;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 7398;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 7400;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 7402;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 7404;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 7406;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 7408;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 7410;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 7412;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 7414;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 7416;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 7418;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 7420;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 7422;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 7424;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 7426;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 7428;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 7430;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 7432;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 7434;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 7436;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 7438;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 7440;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 7442;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 7444;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 7446;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 7448;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 7450;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 7452;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 7454;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, true, true).ID: return 4368;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, true, false).ID: return 4370;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, false, true).ID: return 4372;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, false, false).ID: return 4374;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4376;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4378;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4380;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4382;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, true, true).ID: return 4384;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, true, false).ID: return 4386;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, false, true).ID: return 4388;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, false, false).ID: return 4390;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4392;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4394;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4396;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4398;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, true, true).ID: return 4400;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, true, false).ID: return 4402;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, false, true).ID: return 4404;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, false, false).ID: return 4406;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4408;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4410;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4412;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4414;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, true, true).ID: return 4416;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, true, false).ID: return 4418;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, false, true).ID: return 4420;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, false, false).ID: return 4422;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4424;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4426;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4428;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4430;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3760;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3762;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3764;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3766;
			case AcaciaWood::AcaciaWood(AcaciaWood::Axis::X).ID: return 121;
			case AcaciaWood::AcaciaWood(AcaciaWood::Axis::Y).ID: return 122;
			case AcaciaWood::AcaciaWood(AcaciaWood::Axis::Z).ID: return 123;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::NorthSouth).ID: return 6823;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::EastWest).ID: return 6824;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingEast).ID: return 6825;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingWest).ID: return 6826;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingNorth).ID: return 6827;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingSouth).ID: return 6828;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::NorthSouth).ID: return 6829;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::EastWest).ID: return 6830;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingEast).ID: return 6831;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingWest).ID: return 6832;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingNorth).ID: return 6833;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingSouth).ID: return 6834;
			case Air::Air().ID: return -0;
			case Allium::Allium().ID: return 1415;
			case AncientDebris::AncientDebris().ID: return 15827;
			case Andesite::Andesite().ID: return 6;
			case AndesiteSlab::AndesiteSlab(AndesiteSlab::Type::Top).ID: return 10844;
			case AndesiteSlab::AndesiteSlab(AndesiteSlab::Type::Bottom).ID: return 10846;
			case AndesiteSlab::AndesiteSlab(AndesiteSlab::Type::Double).ID: return 10848;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 10470;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 10472;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 10474;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 10476;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 10478;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 10480;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 10482;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 10484;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 10486;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 10488;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 10490;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 10492;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 10494;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 10496;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 10498;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 10500;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 10502;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 10504;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 10506;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 10508;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 10510;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 10512;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 10514;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 10516;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 10518;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 10520;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 10522;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 10524;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 10526;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 10528;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 10530;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 10532;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 10534;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 10536;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 10538;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 10540;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 10542;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 10544;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 10546;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 10548;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13138;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13139;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13140;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13144;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13145;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13146;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13150;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13151;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13152;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13156;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13157;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13158;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13162;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13163;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13164;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13168;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13169;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13170;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13174;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13175;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13176;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13180;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13181;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13182;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13186;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13187;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13188;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13192;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13193;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13194;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13198;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13199;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13200;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13204;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13205;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13206;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13210;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13211;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13212;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13216;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13217;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13218;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13222;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13223;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13224;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13228;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13229;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13230;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13234;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13235;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13236;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13240;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13241;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13242;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13246;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13247;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13248;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13252;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13253;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13254;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13258;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13259;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13260;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13264;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13265;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13266;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13270;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13271;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13272;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13276;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13277;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13278;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13282;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13283;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13284;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13288;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13289;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13290;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13294;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13295;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13296;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13300;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13301;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13302;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13306;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13307;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13308;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13312;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13313;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13314;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13318;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13319;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13320;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13324;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13325;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13326;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13330;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13331;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13332;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13336;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13337;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13338;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13342;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13343;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13344;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13348;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13349;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13350;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13354;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13355;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13356;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13360;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13361;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13362;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13366;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13367;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13368;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13372;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13373;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13374;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13378;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13379;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13380;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13384;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13385;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::None, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13386;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13390;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13391;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13392;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13396;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13397;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13398;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13402;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13403;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13404;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13408;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13409;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13410;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13414;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13415;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13416;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13420;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13421;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Low, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13422;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 13426;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 13427;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::None, true, AndesiteWall::West::Tall).ID: return 13428;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 13432;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 13433;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::None, false, AndesiteWall::West::Tall).ID: return 13434;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 13438;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 13439;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Low, true, AndesiteWall::West::Tall).ID: return 13440;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 13444;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 13445;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Low, false, AndesiteWall::West::Tall).ID: return 13446;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::None).ID: return 13450;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::Low).ID: return 13451;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Tall, true, AndesiteWall::West::Tall).ID: return 13452;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::None).ID: return 13456;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::Low).ID: return 13457;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Tall, AndesiteWall::North::Tall, AndesiteWall::South::Tall, false, AndesiteWall::West::Tall).ID: return 13458;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_ZM).ID: return 6610;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_ZP).ID: return 6611;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_XM).ID: return 6612;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_XP).ID: return 6613;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_ZM).ID: return 4768;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_ZP).ID: return 4769;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_XM).ID: return 4770;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_XP).ID: return 4771;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_ZM).ID: return 4764;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_ZP).ID: return 4765;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_XM).ID: return 4766;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_XP).ID: return 4767;
			case AzureBluet::AzureBluet().ID: return 1416;
			case Bamboo::Bamboo(0, Bamboo::Leaves::None, 0).ID: return 9652;
			case Bamboo::Bamboo(0, Bamboo::Leaves::None, 1).ID: return 9653;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Small, 0).ID: return 9654;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Small, 1).ID: return 9655;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Large, 0).ID: return 9656;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Large, 1).ID: return 9657;
			case Bamboo::Bamboo(1, Bamboo::Leaves::None, 0).ID: return 9658;
			case Bamboo::Bamboo(1, Bamboo::Leaves::None, 1).ID: return 9659;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Small, 0).ID: return 9660;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Small, 1).ID: return 9661;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Large, 0).ID: return 9662;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Large, 1).ID: return 9663;
			case BambooSapling::BambooSapling().ID: return 9651;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZM, true).ID: return 14791;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZM, false).ID: return 14792;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XP, true).ID: return 14793;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XP, false).ID: return 14794;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZP, true).ID: return 14795;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZP, false).ID: return 14796;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XM, true).ID: return 14797;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XM, false).ID: return 14798;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YP, true).ID: return 14799;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YP, false).ID: return 14800;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YM, true).ID: return 14801;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YM, false).ID: return 14802;
			case Barrier::Barrier().ID: return 7536;
			case Basalt::Basalt(Basalt::Axis::X).ID: return 4002;
			case Basalt::Basalt(Basalt::Axis::Y).ID: return 4003;
			case Basalt::Basalt(Basalt::Axis::Z).ID: return 4004;
			case Beacon::Beacon().ID: return 5656;
			case Bedrock::Bedrock().ID: return 33;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZM, 0).ID: return 15776;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZM, 1).ID: return 15777;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZM, 2).ID: return 15778;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZM, 3).ID: return 15779;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZM, 4).ID: return 15780;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZM, 5).ID: return 15781;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZP, 0).ID: return 15782;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZP, 1).ID: return 15783;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZP, 2).ID: return 15784;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZP, 3).ID: return 15785;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZP, 4).ID: return 15786;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_ZP, 5).ID: return 15787;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XM, 0).ID: return 15788;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XM, 1).ID: return 15789;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XM, 2).ID: return 15790;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XM, 3).ID: return 15791;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XM, 4).ID: return 15792;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XM, 5).ID: return 15793;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XP, 0).ID: return 15794;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XP, 1).ID: return 15795;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XP, 2).ID: return 15796;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XP, 3).ID: return 15797;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XP, 4).ID: return 15798;
			case BeeNest::BeeNest(eBlockFace::BLOCK_FACE_XP, 5).ID: return 15799;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZM, 0).ID: return 15800;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZM, 1).ID: return 15801;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZM, 2).ID: return 15802;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZM, 3).ID: return 15803;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZM, 4).ID: return 15804;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZM, 5).ID: return 15805;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZP, 0).ID: return 15806;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZP, 1).ID: return 15807;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZP, 2).ID: return 15808;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZP, 3).ID: return 15809;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZP, 4).ID: return 15810;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_ZP, 5).ID: return 15811;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XM, 0).ID: return 15812;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XM, 1).ID: return 15813;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XM, 2).ID: return 15814;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XM, 3).ID: return 15815;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XM, 4).ID: return 15816;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XM, 5).ID: return 15817;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XP, 0).ID: return 15818;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XP, 1).ID: return 15819;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XP, 2).ID: return 15820;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XP, 3).ID: return 15821;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XP, 4).ID: return 15822;
			case Beehive::Beehive(eBlockFace::BLOCK_FACE_XP, 5).ID: return 15823;
			case Beetroots::Beetroots(0).ID: return 9219;
			case Beetroots::Beetroots(1).ID: return 9220;
			case Beetroots::Beetroots(2).ID: return 9221;
			case Beetroots::Beetroots(3).ID: return 9222;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 14854;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 14855;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 14856;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 14857;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 14858;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 14859;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 14860;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 14861;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 14862;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 14863;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 14864;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 14865;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 14866;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 14867;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 14868;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 14869;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 14870;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 14871;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 14872;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 14873;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_XM, true).ID: return 14874;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_XM, false).ID: return 14875;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_XP, true).ID: return 14876;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_XP, false).ID: return 14877;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 14878;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 14879;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 14880;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 14881;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_XM, true).ID: return 14882;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_XM, false).ID: return 14883;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_XP, true).ID: return 14884;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_XP, false).ID: return 14885;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6394;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6395;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6396;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6397;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 6398;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 6399;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 6400;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 6401;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6402;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6403;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6404;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6405;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 6406;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 6407;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 6408;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 6409;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6410;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6411;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6412;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6413;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 6414;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 6415;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 6416;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 6417;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8802;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8803;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8804;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8805;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8806;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8807;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8808;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8809;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8810;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8811;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8812;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8813;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8814;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8815;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8816;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8817;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8818;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8819;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8820;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8821;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8822;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8823;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8824;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8825;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8826;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8827;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8828;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8829;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8830;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8831;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8832;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8833;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8834;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8835;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8836;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8837;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8838;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8839;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8840;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8841;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8842;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8843;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8844;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8845;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8846;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8847;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8848;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8849;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8850;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8851;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8852;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8853;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8854;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8855;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8856;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8857;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8858;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8859;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8860;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8861;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8862;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8863;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8864;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8865;
			case BirchFence::BirchFence(true, true, true, true).ID: return 8612;
			case BirchFence::BirchFence(true, true, true, false).ID: return 8613;
			case BirchFence::BirchFence(true, true, false, true).ID: return 8616;
			case BirchFence::BirchFence(true, true, false, false).ID: return 8617;
			case BirchFence::BirchFence(true, false, true, true).ID: return 8620;
			case BirchFence::BirchFence(true, false, true, false).ID: return 8621;
			case BirchFence::BirchFence(true, false, false, true).ID: return 8624;
			case BirchFence::BirchFence(true, false, false, false).ID: return 8625;
			case BirchFence::BirchFence(false, true, true, true).ID: return 8628;
			case BirchFence::BirchFence(false, true, true, false).ID: return 8629;
			case BirchFence::BirchFence(false, true, false, true).ID: return 8632;
			case BirchFence::BirchFence(false, true, false, false).ID: return 8633;
			case BirchFence::BirchFence(false, false, true, true).ID: return 8636;
			case BirchFence::BirchFence(false, false, true, false).ID: return 8637;
			case BirchFence::BirchFence(false, false, false, true).ID: return 8640;
			case BirchFence::BirchFence(false, false, false, false).ID: return 8641;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 8450;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 8451;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 8452;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 8453;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 8454;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 8455;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 8456;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 8457;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 8458;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 8459;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 8460;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 8461;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 8462;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 8463;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 8464;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 8465;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 8466;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 8467;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 8468;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 8469;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 8470;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 8471;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 8472;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 8473;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 8474;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 8475;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 8476;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 8477;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 8478;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 8479;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 8480;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 8481;
			case BirchLeaves::BirchLeaves(1, true).ID: return 173;
			case BirchLeaves::BirchLeaves(1, false).ID: return 174;
			case BirchLeaves::BirchLeaves(2, true).ID: return 175;
			case BirchLeaves::BirchLeaves(2, false).ID: return 176;
			case BirchLeaves::BirchLeaves(3, true).ID: return 177;
			case BirchLeaves::BirchLeaves(3, false).ID: return 178;
			case BirchLeaves::BirchLeaves(4, true).ID: return 179;
			case BirchLeaves::BirchLeaves(4, false).ID: return 180;
			case BirchLeaves::BirchLeaves(5, true).ID: return 181;
			case BirchLeaves::BirchLeaves(5, false).ID: return 182;
			case BirchLeaves::BirchLeaves(6, true).ID: return 183;
			case BirchLeaves::BirchLeaves(6, false).ID: return 184;
			case BirchLeaves::BirchLeaves(7, true).ID: return 185;
			case BirchLeaves::BirchLeaves(7, false).ID: return 186;
			case BirchLog::BirchLog(BirchLog::Axis::X).ID: return 79;
			case BirchLog::BirchLog(BirchLog::Axis::Y).ID: return 80;
			case BirchLog::BirchLog(BirchLog::Axis::Z).ID: return 81;
			case BirchPlanks::BirchPlanks().ID: return 17;
			case BirchPressurePlate::BirchPressurePlate(true).ID: return 3877;
			case BirchPressurePlate::BirchPressurePlate(false).ID: return 3878;
			case BirchSapling::BirchSapling(0).ID: return 25;
			case BirchSapling::BirchSapling(1).ID: return 26;
			case BirchSign::BirchSign(0).ID: return 3446;
			case BirchSign::BirchSign(1).ID: return 3448;
			case BirchSign::BirchSign(2).ID: return 3450;
			case BirchSign::BirchSign(3).ID: return 3452;
			case BirchSign::BirchSign(4).ID: return 3454;
			case BirchSign::BirchSign(5).ID: return 3456;
			case BirchSign::BirchSign(6).ID: return 3458;
			case BirchSign::BirchSign(7).ID: return 3460;
			case BirchSign::BirchSign(8).ID: return 3462;
			case BirchSign::BirchSign(9).ID: return 3464;
			case BirchSign::BirchSign(10).ID: return 3466;
			case BirchSign::BirchSign(11).ID: return 3468;
			case BirchSign::BirchSign(12).ID: return 3470;
			case BirchSign::BirchSign(13).ID: return 3472;
			case BirchSign::BirchSign(14).ID: return 3474;
			case BirchSign::BirchSign(15).ID: return 3476;
			case BirchSlab::BirchSlab(BirchSlab::Type::Top).ID: return 8313;
			case BirchSlab::BirchSlab(BirchSlab::Type::Bottom).ID: return 8315;
			case BirchSlab::BirchSlab(BirchSlab::Type::Double).ID: return 8317;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5485;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5487;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5489;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5491;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5493;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5495;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5497;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5499;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5501;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5503;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5505;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5507;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5509;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5511;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5513;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5515;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5517;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5519;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5521;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5523;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5525;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5527;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5529;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5531;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5533;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5535;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5537;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5539;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5541;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5543;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5545;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5547;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5549;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5551;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5553;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5555;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5557;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5559;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5561;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5563;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, true, true).ID: return 4240;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, true, false).ID: return 4242;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, false, true).ID: return 4244;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, false, false).ID: return 4246;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, true, true).ID: return 4248;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, true, false).ID: return 4250;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, false, true).ID: return 4252;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, false, false).ID: return 4254;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, true, true).ID: return 4256;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, true, false).ID: return 4258;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, false, true).ID: return 4260;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, false, false).ID: return 4262;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, true, true).ID: return 4264;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, true, false).ID: return 4266;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, false, true).ID: return 4268;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, false, false).ID: return 4270;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, true, true).ID: return 4272;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, true, false).ID: return 4274;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, false, true).ID: return 4276;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, false, false).ID: return 4278;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, true, true).ID: return 4280;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, true, false).ID: return 4282;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, false, true).ID: return 4284;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, false, false).ID: return 4286;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, true, true).ID: return 4288;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, true, false).ID: return 4290;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, false, true).ID: return 4292;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, false, false).ID: return 4294;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, true, true).ID: return 4296;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, true, false).ID: return 4298;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, false, true).ID: return 4300;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, false, false).ID: return 4302;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3752;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3754;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3756;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3758;
			case BirchWood::BirchWood(BirchWood::Axis::X).ID: return 115;
			case BirchWood::BirchWood(BirchWood::Axis::Y).ID: return 116;
			case BirchWood::BirchWood(BirchWood::Axis::Z).ID: return 117;
			case BlackBanner::BlackBanner(0).ID: return 8137;
			case BlackBanner::BlackBanner(1).ID: return 8138;
			case BlackBanner::BlackBanner(2).ID: return 8139;
			case BlackBanner::BlackBanner(3).ID: return 8140;
			case BlackBanner::BlackBanner(4).ID: return 8141;
			case BlackBanner::BlackBanner(5).ID: return 8142;
			case BlackBanner::BlackBanner(6).ID: return 8143;
			case BlackBanner::BlackBanner(7).ID: return 8144;
			case BlackBanner::BlackBanner(8).ID: return 8145;
			case BlackBanner::BlackBanner(9).ID: return 8146;
			case BlackBanner::BlackBanner(10).ID: return 8147;
			case BlackBanner::BlackBanner(11).ID: return 8148;
			case BlackBanner::BlackBanner(12).ID: return 8149;
			case BlackBanner::BlackBanner(13).ID: return 8150;
			case BlackBanner::BlackBanner(14).ID: return 8151;
			case BlackBanner::BlackBanner(15).ID: return 8152;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, true, BlackBed::Part::Head).ID: return 1289;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, true, BlackBed::Part::Foot).ID: return 1290;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, false, BlackBed::Part::Head).ID: return 1291;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, false, BlackBed::Part::Foot).ID: return 1292;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, true, BlackBed::Part::Head).ID: return 1293;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, true, BlackBed::Part::Foot).ID: return 1294;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, false, BlackBed::Part::Head).ID: return 1295;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, false, BlackBed::Part::Foot).ID: return 1296;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, true, BlackBed::Part::Head).ID: return 1297;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, true, BlackBed::Part::Foot).ID: return 1298;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, false, BlackBed::Part::Head).ID: return 1299;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, false, BlackBed::Part::Foot).ID: return 1300;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, true, BlackBed::Part::Head).ID: return 1301;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, true, BlackBed::Part::Foot).ID: return 1302;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, false, BlackBed::Part::Head).ID: return 1303;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, false, BlackBed::Part::Foot).ID: return 1304;
			case BlackCarpet::BlackCarpet().ID: return 7881;
			case BlackConcrete::BlackConcrete().ID: return 9453;
			case BlackConcretePowder::BlackConcretePowder().ID: return 9469;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9434;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9435;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9436;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9437;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9368;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9369;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9370;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9371;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9372;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9373;
			case BlackStainedGlass::BlackStainedGlass().ID: return 4110;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, true, true).ID: return 7345;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, true, false).ID: return 7346;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, false, true).ID: return 7349;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, false, false).ID: return 7350;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, true, true).ID: return 7353;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, true, false).ID: return 7354;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, false, true).ID: return 7357;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, false, false).ID: return 7358;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, true, true).ID: return 7361;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, true, false).ID: return 7362;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, false, true).ID: return 7365;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, false, false).ID: return 7366;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, true, true).ID: return 7369;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, true, false).ID: return 7370;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, false, true).ID: return 7373;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, false, false).ID: return 7374;
			case BlackTerracotta::BlackTerracotta().ID: return 6862;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8213;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8214;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8215;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8216;
			case BlackWool::BlackWool().ID: return 1399;
			case Blackstone::Blackstone().ID: return 15839;
			case BlackstoneSlab::BlackstoneSlab(BlackstoneSlab::Type::Top).ID: return 16245;
			case BlackstoneSlab::BlackstoneSlab(BlackstoneSlab::Type::Bottom).ID: return 16247;
			case BlackstoneSlab::BlackstoneSlab(BlackstoneSlab::Type::Double).ID: return 16249;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::Straight).ID: return 15841;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerLeft).ID: return 15843;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerRight).ID: return 15845;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterLeft).ID: return 15847;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterRight).ID: return 15849;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::Straight).ID: return 15851;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerLeft).ID: return 15853;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerRight).ID: return 15855;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterLeft).ID: return 15857;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterRight).ID: return 15859;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::Straight).ID: return 15861;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerLeft).ID: return 15863;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerRight).ID: return 15865;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterLeft).ID: return 15867;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterRight).ID: return 15869;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::Straight).ID: return 15871;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerLeft).ID: return 15873;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerRight).ID: return 15875;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterLeft).ID: return 15877;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterRight).ID: return 15879;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::Straight).ID: return 15881;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerLeft).ID: return 15883;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerRight).ID: return 15885;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterLeft).ID: return 15887;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterRight).ID: return 15889;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::Straight).ID: return 15891;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerLeft).ID: return 15893;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerRight).ID: return 15895;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterLeft).ID: return 15897;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XM, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterRight).ID: return 15899;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::Straight).ID: return 15901;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerLeft).ID: return 15903;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::InnerRight).ID: return 15905;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterLeft).ID: return 15907;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Top, BlackstoneStairs::Shape::OuterRight).ID: return 15909;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::Straight).ID: return 15911;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerLeft).ID: return 15913;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::InnerRight).ID: return 15915;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterLeft).ID: return 15917;
			case BlackstoneStairs::BlackstoneStairs(eBlockFace::BLOCK_FACE_XP, BlackstoneStairs::Half::Bottom, BlackstoneStairs::Shape::OuterRight).ID: return 15919;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 15923;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 15924;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 15925;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 15929;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 15930;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 15931;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 15935;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 15936;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 15937;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 15941;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 15942;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 15943;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 15947;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 15948;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 15949;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 15953;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 15954;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 15955;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 15959;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 15960;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 15961;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 15965;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 15966;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 15967;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 15971;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 15972;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 15973;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 15977;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 15978;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 15979;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 15983;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 15984;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 15985;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 15989;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 15990;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 15991;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 15995;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 15996;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 15997;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16001;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16002;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16003;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16007;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16008;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16009;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16013;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16014;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16015;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16019;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16020;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16021;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16025;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16026;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::None, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16027;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 16031;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 16032;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 16033;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16037;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16038;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16039;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16043;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16044;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16045;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16049;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16050;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16051;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16055;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16056;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16057;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16061;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16062;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16063;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 16067;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 16068;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 16069;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16073;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16074;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16075;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16079;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16080;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16081;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16085;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16086;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16087;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16091;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16092;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16093;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16097;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16098;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16099;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 16103;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 16104;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 16105;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16109;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16110;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16111;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16115;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16116;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16117;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16121;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16122;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16123;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16127;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16128;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16129;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16133;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16134;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Low, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16135;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 16139;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 16140;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 16141;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16145;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16146;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16147;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16151;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16152;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16153;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16157;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16158;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16159;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16163;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16164;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16165;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16169;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16170;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::None, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16171;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 16175;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 16176;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 16177;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16181;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16182;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16183;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16187;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16188;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16189;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16193;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16194;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16195;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16199;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16200;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16201;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16205;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16206;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Low, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16207;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::None).ID: return 16211;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::Low).ID: return 16212;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::None, true, BlackstoneWall::West::Tall).ID: return 16213;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::None).ID: return 16217;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::Low).ID: return 16218;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::None, false, BlackstoneWall::West::Tall).ID: return 16219;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::None).ID: return 16223;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::Low).ID: return 16224;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, true, BlackstoneWall::West::Tall).ID: return 16225;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::None).ID: return 16229;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::Low).ID: return 16230;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Low, false, BlackstoneWall::West::Tall).ID: return 16231;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::None).ID: return 16235;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Low).ID: return 16236;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, true, BlackstoneWall::West::Tall).ID: return 16237;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::None).ID: return 16241;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Low).ID: return 16242;
			case BlackstoneWall::BlackstoneWall(BlackstoneWall::East::Tall, BlackstoneWall::North::Tall, BlackstoneWall::South::Tall, false, BlackstoneWall::West::Tall).ID: return 16243;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZM, true).ID: return 14811;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZM, false).ID: return 14812;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZP, true).ID: return 14813;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZP, false).ID: return 14814;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XM, true).ID: return 14815;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XM, false).ID: return 14816;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XP, true).ID: return 14817;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XP, false).ID: return 14818;
			case BlueBanner::BlueBanner(0).ID: return 8073;
			case BlueBanner::BlueBanner(1).ID: return 8074;
			case BlueBanner::BlueBanner(2).ID: return 8075;
			case BlueBanner::BlueBanner(3).ID: return 8076;
			case BlueBanner::BlueBanner(4).ID: return 8077;
			case BlueBanner::BlueBanner(5).ID: return 8078;
			case BlueBanner::BlueBanner(6).ID: return 8079;
			case BlueBanner::BlueBanner(7).ID: return 8080;
			case BlueBanner::BlueBanner(8).ID: return 8081;
			case BlueBanner::BlueBanner(9).ID: return 8082;
			case BlueBanner::BlueBanner(10).ID: return 8083;
			case BlueBanner::BlueBanner(11).ID: return 8084;
			case BlueBanner::BlueBanner(12).ID: return 8085;
			case BlueBanner::BlueBanner(13).ID: return 8086;
			case BlueBanner::BlueBanner(14).ID: return 8087;
			case BlueBanner::BlueBanner(15).ID: return 8088;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, true, BlueBed::Part::Head).ID: return 1225;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, true, BlueBed::Part::Foot).ID: return 1226;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, false, BlueBed::Part::Head).ID: return 1227;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, false, BlueBed::Part::Foot).ID: return 1228;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, true, BlueBed::Part::Head).ID: return 1229;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, true, BlueBed::Part::Foot).ID: return 1230;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, false, BlueBed::Part::Head).ID: return 1231;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, false, BlueBed::Part::Foot).ID: return 1232;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, true, BlueBed::Part::Head).ID: return 1233;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, true, BlueBed::Part::Foot).ID: return 1234;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, false, BlueBed::Part::Head).ID: return 1235;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, false, BlueBed::Part::Foot).ID: return 1236;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, true, BlueBed::Part::Head).ID: return 1237;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, true, BlueBed::Part::Foot).ID: return 1238;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, false, BlueBed::Part::Head).ID: return 1239;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, false, BlueBed::Part::Foot).ID: return 1240;
			case BlueCarpet::BlueCarpet().ID: return 7877;
			case BlueConcrete::BlueConcrete().ID: return 9449;
			case BlueConcretePowder::BlueConcretePowder().ID: return 9465;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9418;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9419;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9420;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9421;
			case BlueIce::BlueIce().ID: return 9648;
			case BlueOrchid::BlueOrchid().ID: return 1414;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9344;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9345;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9346;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9347;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9348;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9349;
			case BlueStainedGlass::BlueStainedGlass().ID: return 4106;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, true, true).ID: return 7217;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, true, false).ID: return 7218;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, false, true).ID: return 7221;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, false, false).ID: return 7222;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, true, true).ID: return 7225;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, true, false).ID: return 7226;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, false, true).ID: return 7229;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, false, false).ID: return 7230;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, true, true).ID: return 7233;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, true, false).ID: return 7234;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, false, true).ID: return 7237;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, false, false).ID: return 7238;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, true, true).ID: return 7241;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, true, false).ID: return 7242;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, false, true).ID: return 7245;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, false, false).ID: return 7246;
			case BlueTerracotta::BlueTerracotta().ID: return 6858;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8197;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8198;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8199;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8200;
			case BlueWool::BlueWool().ID: return 1395;
			case BoneBlock::BoneBlock(BoneBlock::Axis::X).ID: return 9256;
			case BoneBlock::BoneBlock(BoneBlock::Axis::Y).ID: return 9257;
			case BoneBlock::BoneBlock(BoneBlock::Axis::Z).ID: return 9258;
			case Bookshelf::Bookshelf().ID: return 1432;
			case BrainCoral::BrainCoral().ID: return 9533;
			case BrainCoralBlock::BrainCoralBlock().ID: return 9516;
			case BrainCoralFan::BrainCoralFan().ID: return 9553;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9609;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9611;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9613;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9615;
			case BrewingStand::BrewingStand(true, true, true).ID: return 5133;
			case BrewingStand::BrewingStand(true, true, false).ID: return 5134;
			case BrewingStand::BrewingStand(true, false, true).ID: return 5135;
			case BrewingStand::BrewingStand(true, false, false).ID: return 5136;
			case BrewingStand::BrewingStand(false, true, true).ID: return 5137;
			case BrewingStand::BrewingStand(false, true, false).ID: return 5138;
			case BrewingStand::BrewingStand(false, false, true).ID: return 5139;
			case BrewingStand::BrewingStand(false, false, false).ID: return 5140;
			case BrickSlab::BrickSlab(BrickSlab::Type::Top).ID: return 8373;
			case BrickSlab::BrickSlab(BrickSlab::Type::Bottom).ID: return 8375;
			case BrickSlab::BrickSlab(BrickSlab::Type::Double).ID: return 8377;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4853;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4855;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4857;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4859;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4861;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4863;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4865;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4867;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4869;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4871;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4873;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4875;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4877;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4879;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4881;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4883;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4885;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4887;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4889;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4891;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4893;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4895;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4897;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4899;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4901;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4903;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4905;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4907;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4909;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4911;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4913;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4915;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4917;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4919;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4921;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4923;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4925;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4927;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4929;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4931;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::None).ID: return 10870;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10871;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 10872;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::None).ID: return 10876;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10877;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 10878;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10882;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10883;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 10884;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10888;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10889;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 10890;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 10894;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 10895;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 10896;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 10900;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 10901;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 10902;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::None).ID: return 10906;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10907;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 10908;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::None).ID: return 10912;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10913;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 10914;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10918;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10919;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 10920;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10924;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10925;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 10926;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 10930;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 10931;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 10932;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 10936;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 10937;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 10938;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::None).ID: return 10942;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10943;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 10944;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::None).ID: return 10948;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10949;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 10950;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10954;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10955;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 10956;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10960;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10961;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 10962;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 10966;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 10967;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 10968;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 10972;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 10973;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 10974;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::None).ID: return 10978;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10979;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 10980;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::None).ID: return 10984;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10985;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 10986;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10990;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10991;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 10992;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10996;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10997;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 10998;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 11002;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 11003;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 11004;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 11008;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 11009;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 11010;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::None).ID: return 11014;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Low).ID: return 11015;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 11016;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::None).ID: return 11020;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Low).ID: return 11021;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 11022;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::None).ID: return 11026;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 11027;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 11028;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::None).ID: return 11032;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 11033;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 11034;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 11038;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 11039;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 11040;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 11044;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 11045;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 11046;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::None).ID: return 11050;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::Low).ID: return 11051;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 11052;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::None).ID: return 11056;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::Low).ID: return 11057;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 11058;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::None).ID: return 11062;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 11063;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 11064;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::None).ID: return 11068;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 11069;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 11070;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 11074;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 11075;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 11076;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 11080;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 11081;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 11082;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::None).ID: return 11086;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Low).ID: return 11087;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 11088;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::None).ID: return 11092;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Low).ID: return 11093;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 11094;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::None).ID: return 11098;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 11099;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 11100;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::None).ID: return 11104;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 11105;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 11106;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 11110;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 11111;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 11112;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 11116;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 11117;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::None, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 11118;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::None).ID: return 11122;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Low).ID: return 11123;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 11124;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::None).ID: return 11128;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Low).ID: return 11129;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 11130;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::None).ID: return 11134;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 11135;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 11136;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::None).ID: return 11140;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 11141;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 11142;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 11146;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 11147;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 11148;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 11152;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 11153;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Low, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 11154;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::None).ID: return 11158;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::Low).ID: return 11159;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::None, true, BrickWall::West::Tall).ID: return 11160;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::None).ID: return 11164;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::Low).ID: return 11165;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::None, false, BrickWall::West::Tall).ID: return 11166;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::None).ID: return 11170;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 11171;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Low, true, BrickWall::West::Tall).ID: return 11172;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::None).ID: return 11176;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 11177;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Low, false, BrickWall::West::Tall).ID: return 11178;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::None).ID: return 11182;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::Low).ID: return 11183;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Tall, true, BrickWall::West::Tall).ID: return 11184;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::None).ID: return 11188;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::Low).ID: return 11189;
			case BrickWall::BrickWall(BrickWall::East::Tall, BrickWall::North::Tall, BrickWall::South::Tall, false, BrickWall::West::Tall).ID: return 11190;
			case Bricks::Bricks().ID: return 1429;
			case BrownBanner::BrownBanner(0).ID: return 8089;
			case BrownBanner::BrownBanner(1).ID: return 8090;
			case BrownBanner::BrownBanner(2).ID: return 8091;
			case BrownBanner::BrownBanner(3).ID: return 8092;
			case BrownBanner::BrownBanner(4).ID: return 8093;
			case BrownBanner::BrownBanner(5).ID: return 8094;
			case BrownBanner::BrownBanner(6).ID: return 8095;
			case BrownBanner::BrownBanner(7).ID: return 8096;
			case BrownBanner::BrownBanner(8).ID: return 8097;
			case BrownBanner::BrownBanner(9).ID: return 8098;
			case BrownBanner::BrownBanner(10).ID: return 8099;
			case BrownBanner::BrownBanner(11).ID: return 8100;
			case BrownBanner::BrownBanner(12).ID: return 8101;
			case BrownBanner::BrownBanner(13).ID: return 8102;
			case BrownBanner::BrownBanner(14).ID: return 8103;
			case BrownBanner::BrownBanner(15).ID: return 8104;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, true, BrownBed::Part::Head).ID: return 1241;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, true, BrownBed::Part::Foot).ID: return 1242;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, false, BrownBed::Part::Head).ID: return 1243;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, false, BrownBed::Part::Foot).ID: return 1244;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, true, BrownBed::Part::Head).ID: return 1245;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, true, BrownBed::Part::Foot).ID: return 1246;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, false, BrownBed::Part::Head).ID: return 1247;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, false, BrownBed::Part::Foot).ID: return 1248;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, true, BrownBed::Part::Head).ID: return 1249;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, true, BrownBed::Part::Foot).ID: return 1250;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, false, BrownBed::Part::Head).ID: return 1251;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, false, BrownBed::Part::Foot).ID: return 1252;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, true, BrownBed::Part::Head).ID: return 1253;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, true, BrownBed::Part::Foot).ID: return 1254;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, false, BrownBed::Part::Head).ID: return 1255;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, false, BrownBed::Part::Foot).ID: return 1256;
			case BrownCarpet::BrownCarpet().ID: return 7878;
			case BrownConcrete::BrownConcrete().ID: return 9450;
			case BrownConcretePowder::BrownConcretePowder().ID: return 9466;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9422;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9423;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9424;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9425;
			case BrownMushroom::BrownMushroom().ID: return 1425;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, true, true).ID: return 4505;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, true, false).ID: return 4506;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, false, true).ID: return 4507;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, false, false).ID: return 4508;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, true, true).ID: return 4509;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, true, false).ID: return 4510;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, false, true).ID: return 4511;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, false, false).ID: return 4512;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, true, true).ID: return 4513;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, true, false).ID: return 4514;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, false, true).ID: return 4515;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, false, false).ID: return 4516;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, true, true).ID: return 4517;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, true, false).ID: return 4518;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, false, true).ID: return 4519;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, false, false).ID: return 4520;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, true, true).ID: return 4521;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, true, false).ID: return 4522;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, false, true).ID: return 4523;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, false, false).ID: return 4524;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, true, true).ID: return 4525;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, true, false).ID: return 4526;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, false, true).ID: return 4527;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, false, false).ID: return 4528;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, true, true).ID: return 4529;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, true, false).ID: return 4530;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, false, true).ID: return 4531;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, false, false).ID: return 4532;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, true, true).ID: return 4533;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, true, false).ID: return 4534;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, false, true).ID: return 4535;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, false, false).ID: return 4536;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, true, true).ID: return 4537;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, true, false).ID: return 4538;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, false, true).ID: return 4539;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, false, false).ID: return 4540;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, true, true).ID: return 4541;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, true, false).ID: return 4542;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, false, true).ID: return 4543;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, false, false).ID: return 4544;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, true, true).ID: return 4545;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, true, false).ID: return 4546;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, false, true).ID: return 4547;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, false, false).ID: return 4548;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, true, true).ID: return 4549;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, true, false).ID: return 4550;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, false, true).ID: return 4551;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, false, false).ID: return 4552;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, true, true).ID: return 4553;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, true, false).ID: return 4554;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, false, true).ID: return 4555;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, false, false).ID: return 4556;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, true, true).ID: return 4557;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, true, false).ID: return 4558;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, false, true).ID: return 4559;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, false, false).ID: return 4560;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, true, true).ID: return 4561;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, true, false).ID: return 4562;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, false, true).ID: return 4563;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, false, false).ID: return 4564;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, true, true).ID: return 4565;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, true, false).ID: return 4566;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, false, true).ID: return 4567;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, false, false).ID: return 4568;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9350;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9351;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9352;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9353;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9354;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9355;
			case BrownStainedGlass::BrownStainedGlass().ID: return 4107;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, true, true).ID: return 7249;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, true, false).ID: return 7250;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, false, true).ID: return 7253;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, false, false).ID: return 7254;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, true, true).ID: return 7257;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, true, false).ID: return 7258;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, false, true).ID: return 7261;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, false, false).ID: return 7262;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, true, true).ID: return 7265;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, true, false).ID: return 7266;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, false, true).ID: return 7269;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, false, false).ID: return 7270;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, true, true).ID: return 7273;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, true, false).ID: return 7274;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, false, true).ID: return 7277;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, false, false).ID: return 7278;
			case BrownTerracotta::BrownTerracotta().ID: return 6859;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8201;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8202;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8203;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8204;
			case BrownWool::BrownWool().ID: return 1396;
			case BubbleColumn::BubbleColumn(true).ID: return 9667;
			case BubbleColumn::BubbleColumn(false).ID: return 9668;
			case BubbleCoral::BubbleCoral().ID: return 9535;
			case BubbleCoralBlock::BubbleCoralBlock().ID: return 9517;
			case BubbleCoralFan::BubbleCoralFan().ID: return 9555;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9617;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9619;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9621;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9623;
			case Cactus::Cactus(0).ID: return 3931;
			case Cactus::Cactus(1).ID: return 3932;
			case Cactus::Cactus(2).ID: return 3933;
			case Cactus::Cactus(3).ID: return 3934;
			case Cactus::Cactus(4).ID: return 3935;
			case Cactus::Cactus(5).ID: return 3936;
			case Cactus::Cactus(6).ID: return 3937;
			case Cactus::Cactus(7).ID: return 3938;
			case Cactus::Cactus(8).ID: return 3939;
			case Cactus::Cactus(9).ID: return 3940;
			case Cactus::Cactus(10).ID: return 3941;
			case Cactus::Cactus(11).ID: return 3942;
			case Cactus::Cactus(12).ID: return 3943;
			case Cactus::Cactus(13).ID: return 3944;
			case Cactus::Cactus(14).ID: return 3945;
			case Cactus::Cactus(15).ID: return 3946;
			case Cake::Cake(0).ID: return 4024;
			case Cake::Cake(1).ID: return 4025;
			case Cake::Cake(2).ID: return 4026;
			case Cake::Cake(3).ID: return 4027;
			case Cake::Cake(4).ID: return 4028;
			case Cake::Cake(5).ID: return 4029;
			case Cake::Cake(6).ID: return 4030;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 14891;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 14893;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 14895;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 14897;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 14899;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 14901;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 14903;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 14905;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, true, true).ID: return 14907;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, true, false).ID: return 14909;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, false, true).ID: return 14911;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, false, false).ID: return 14913;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, true, true).ID: return 14915;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, true, false).ID: return 14917;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, false, true).ID: return 14919;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, false, false).ID: return 14921;
			case Carrots::Carrots(0).ID: return 6330;
			case Carrots::Carrots(1).ID: return 6331;
			case Carrots::Carrots(2).ID: return 6332;
			case Carrots::Carrots(3).ID: return 6333;
			case Carrots::Carrots(4).ID: return 6334;
			case Carrots::Carrots(5).ID: return 6335;
			case Carrots::Carrots(6).ID: return 6336;
			case Carrots::Carrots(7).ID: return 6337;
			case CartographyTable::CartographyTable().ID: return 14819;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_ZM).ID: return 4016;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_ZP).ID: return 4017;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_XM).ID: return 4018;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_XP).ID: return 4019;
			case Cauldron::Cauldron(0).ID: return 5141;
			case Cauldron::Cauldron(1).ID: return 5142;
			case Cauldron::Cauldron(2).ID: return 5143;
			case Cauldron::Cauldron(3).ID: return 5144;
			case CaveAir::CaveAir().ID: return 9666;
			case Chain::Chain().ID: return 4730;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_ZM).ID: return 9237;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_XP).ID: return 9238;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_ZP).ID: return 9239;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_XM).ID: return 9240;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_YP).ID: return 9241;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_YM).ID: return 9242;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_ZM).ID: return 9243;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_XP).ID: return 9244;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_ZP).ID: return 9245;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_XM).ID: return 9246;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_YP).ID: return 9247;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_YM).ID: return 9248;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZM, Chest::Type::Single).ID: return 2035;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZM, Chest::Type::Left).ID: return 2037;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZM, Chest::Type::Right).ID: return 2039;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZP, Chest::Type::Single).ID: return 2041;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZP, Chest::Type::Left).ID: return 2043;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZP, Chest::Type::Right).ID: return 2045;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XM, Chest::Type::Single).ID: return 2047;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XM, Chest::Type::Left).ID: return 2049;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XM, Chest::Type::Right).ID: return 2051;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XP, Chest::Type::Single).ID: return 2053;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XP, Chest::Type::Left).ID: return 2055;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XP, Chest::Type::Right).ID: return 2057;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_ZM).ID: return 6614;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_ZP).ID: return 6615;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_XM).ID: return 6616;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_XP).ID: return 6617;
			case ChiseledNetherBricks::ChiseledNetherBricks().ID: return 17101;
			case ChiseledPolishedBlackstone::ChiseledPolishedBlackstone().ID: return 16253;
			case ChiseledQuartzBlock::ChiseledQuartzBlock().ID: return 6739;
			case ChiseledRedSandstone::ChiseledRedSandstone().ID: return 8218;
			case ChiseledSandstone::ChiseledSandstone().ID: return 247;
			case ChiseledStoneBricks::ChiseledStoneBricks().ID: return 4498;
			case ChorusFlower::ChorusFlower(0).ID: return 9128;
			case ChorusFlower::ChorusFlower(1).ID: return 9129;
			case ChorusFlower::ChorusFlower(2).ID: return 9130;
			case ChorusFlower::ChorusFlower(3).ID: return 9131;
			case ChorusFlower::ChorusFlower(4).ID: return 9132;
			case ChorusFlower::ChorusFlower(5).ID: return 9133;
			case ChorusPlant::ChorusPlant(true, true, true, true, true, true).ID: return 9064;
			case ChorusPlant::ChorusPlant(true, true, true, true, true, false).ID: return 9065;
			case ChorusPlant::ChorusPlant(true, true, true, true, false, true).ID: return 9066;
			case ChorusPlant::ChorusPlant(true, true, true, true, false, false).ID: return 9067;
			case ChorusPlant::ChorusPlant(true, true, true, false, true, true).ID: return 9068;
			case ChorusPlant::ChorusPlant(true, true, true, false, true, false).ID: return 9069;
			case ChorusPlant::ChorusPlant(true, true, true, false, false, true).ID: return 9070;
			case ChorusPlant::ChorusPlant(true, true, true, false, false, false).ID: return 9071;
			case ChorusPlant::ChorusPlant(true, true, false, true, true, true).ID: return 9072;
			case ChorusPlant::ChorusPlant(true, true, false, true, true, false).ID: return 9073;
			case ChorusPlant::ChorusPlant(true, true, false, true, false, true).ID: return 9074;
			case ChorusPlant::ChorusPlant(true, true, false, true, false, false).ID: return 9075;
			case ChorusPlant::ChorusPlant(true, true, false, false, true, true).ID: return 9076;
			case ChorusPlant::ChorusPlant(true, true, false, false, true, false).ID: return 9077;
			case ChorusPlant::ChorusPlant(true, true, false, false, false, true).ID: return 9078;
			case ChorusPlant::ChorusPlant(true, true, false, false, false, false).ID: return 9079;
			case ChorusPlant::ChorusPlant(true, false, true, true, true, true).ID: return 9080;
			case ChorusPlant::ChorusPlant(true, false, true, true, true, false).ID: return 9081;
			case ChorusPlant::ChorusPlant(true, false, true, true, false, true).ID: return 9082;
			case ChorusPlant::ChorusPlant(true, false, true, true, false, false).ID: return 9083;
			case ChorusPlant::ChorusPlant(true, false, true, false, true, true).ID: return 9084;
			case ChorusPlant::ChorusPlant(true, false, true, false, true, false).ID: return 9085;
			case ChorusPlant::ChorusPlant(true, false, true, false, false, true).ID: return 9086;
			case ChorusPlant::ChorusPlant(true, false, true, false, false, false).ID: return 9087;
			case ChorusPlant::ChorusPlant(true, false, false, true, true, true).ID: return 9088;
			case ChorusPlant::ChorusPlant(true, false, false, true, true, false).ID: return 9089;
			case ChorusPlant::ChorusPlant(true, false, false, true, false, true).ID: return 9090;
			case ChorusPlant::ChorusPlant(true, false, false, true, false, false).ID: return 9091;
			case ChorusPlant::ChorusPlant(true, false, false, false, true, true).ID: return 9092;
			case ChorusPlant::ChorusPlant(true, false, false, false, true, false).ID: return 9093;
			case ChorusPlant::ChorusPlant(true, false, false, false, false, true).ID: return 9094;
			case ChorusPlant::ChorusPlant(true, false, false, false, false, false).ID: return 9095;
			case ChorusPlant::ChorusPlant(false, true, true, true, true, true).ID: return 9096;
			case ChorusPlant::ChorusPlant(false, true, true, true, true, false).ID: return 9097;
			case ChorusPlant::ChorusPlant(false, true, true, true, false, true).ID: return 9098;
			case ChorusPlant::ChorusPlant(false, true, true, true, false, false).ID: return 9099;
			case ChorusPlant::ChorusPlant(false, true, true, false, true, true).ID: return 9100;
			case ChorusPlant::ChorusPlant(false, true, true, false, true, false).ID: return 9101;
			case ChorusPlant::ChorusPlant(false, true, true, false, false, true).ID: return 9102;
			case ChorusPlant::ChorusPlant(false, true, true, false, false, false).ID: return 9103;
			case ChorusPlant::ChorusPlant(false, true, false, true, true, true).ID: return 9104;
			case ChorusPlant::ChorusPlant(false, true, false, true, true, false).ID: return 9105;
			case ChorusPlant::ChorusPlant(false, true, false, true, false, true).ID: return 9106;
			case ChorusPlant::ChorusPlant(false, true, false, true, false, false).ID: return 9107;
			case ChorusPlant::ChorusPlant(false, true, false, false, true, true).ID: return 9108;
			case ChorusPlant::ChorusPlant(false, true, false, false, true, false).ID: return 9109;
			case ChorusPlant::ChorusPlant(false, true, false, false, false, true).ID: return 9110;
			case ChorusPlant::ChorusPlant(false, true, false, false, false, false).ID: return 9111;
			case ChorusPlant::ChorusPlant(false, false, true, true, true, true).ID: return 9112;
			case ChorusPlant::ChorusPlant(false, false, true, true, true, false).ID: return 9113;
			case ChorusPlant::ChorusPlant(false, false, true, true, false, true).ID: return 9114;
			case ChorusPlant::ChorusPlant(false, false, true, true, false, false).ID: return 9115;
			case ChorusPlant::ChorusPlant(false, false, true, false, true, true).ID: return 9116;
			case ChorusPlant::ChorusPlant(false, false, true, false, true, false).ID: return 9117;
			case ChorusPlant::ChorusPlant(false, false, true, false, false, true).ID: return 9118;
			case ChorusPlant::ChorusPlant(false, false, true, false, false, false).ID: return 9119;
			case ChorusPlant::ChorusPlant(false, false, false, true, true, true).ID: return 9120;
			case ChorusPlant::ChorusPlant(false, false, false, true, true, false).ID: return 9121;
			case ChorusPlant::ChorusPlant(false, false, false, true, false, true).ID: return 9122;
			case ChorusPlant::ChorusPlant(false, false, false, true, false, false).ID: return 9123;
			case ChorusPlant::ChorusPlant(false, false, false, false, true, true).ID: return 9124;
			case ChorusPlant::ChorusPlant(false, false, false, false, true, false).ID: return 9125;
			case ChorusPlant::ChorusPlant(false, false, false, false, false, true).ID: return 9126;
			case ChorusPlant::ChorusPlant(false, false, false, false, false, false).ID: return 9127;
			case Clay::Clay().ID: return 3947;
			case CoalBlock::CoalBlock().ID: return 7883;
			case CoalOre::CoalOre().ID: return 71;
			case CoarseDirt::CoarseDirt().ID: return 11;
			case Cobblestone::Cobblestone().ID: return 14;
			case CobblestoneSlab::CobblestoneSlab(CobblestoneSlab::Type::Top).ID: return 8367;
			case CobblestoneSlab::CobblestoneSlab(CobblestoneSlab::Type::Bottom).ID: return 8369;
			case CobblestoneSlab::CobblestoneSlab(CobblestoneSlab::Type::Double).ID: return 8371;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3656;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3658;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3660;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3662;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3664;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3666;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3668;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3670;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3672;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3674;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3676;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3678;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3680;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3682;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3684;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3686;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3688;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3690;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3692;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3694;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3696;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3698;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3700;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3702;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3704;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3706;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3708;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3710;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3712;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3714;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3716;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3718;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3720;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3722;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3724;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3726;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3728;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3730;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3732;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3734;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5660;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5661;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5662;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5666;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5667;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5668;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5672;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5673;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5674;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5678;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5679;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5680;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5684;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5685;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5686;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5690;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5691;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5692;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5696;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5697;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5698;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5702;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5703;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5704;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5708;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5709;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5710;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5714;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5715;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5716;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5720;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5721;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5722;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5726;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5727;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5728;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5732;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5733;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5734;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5738;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5739;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5740;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5744;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5745;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5746;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5750;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5751;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5752;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5756;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5757;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5758;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5762;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5763;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5764;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5768;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5769;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5770;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5774;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5775;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5776;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5780;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5781;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5782;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5786;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5787;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5788;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5792;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5793;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5794;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5798;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5799;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5800;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5804;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5805;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5806;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5810;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5811;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5812;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5816;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5817;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5818;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5822;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5823;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5824;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5828;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5829;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5830;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5834;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5835;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5836;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5840;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5841;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5842;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5846;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5847;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5848;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5852;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5853;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5854;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5858;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5859;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5860;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5864;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5865;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5866;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5870;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5871;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5872;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5876;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5877;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5878;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5882;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5883;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5884;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5888;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5889;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5890;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5894;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5895;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5896;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5900;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5901;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5902;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5906;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5907;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::None, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5908;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5912;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5913;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5914;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5918;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5919;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5920;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5924;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5925;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5926;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5930;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5931;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5932;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5936;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5937;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5938;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5942;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5943;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Low, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5944;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5948;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5949;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::None, true, CobblestoneWall::West::Tall).ID: return 5950;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5954;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5955;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::None, false, CobblestoneWall::West::Tall).ID: return 5956;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5960;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5961;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, true, CobblestoneWall::West::Tall).ID: return 5962;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5966;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5967;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Low, false, CobblestoneWall::West::Tall).ID: return 5968;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::None).ID: return 5972;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Low).ID: return 5973;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, true, CobblestoneWall::West::Tall).ID: return 5974;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::None).ID: return 5978;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Low).ID: return 5979;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Tall, CobblestoneWall::North::Tall, CobblestoneWall::South::Tall, false, CobblestoneWall::West::Tall).ID: return 5980;
			case Cobweb::Cobweb().ID: return 1341;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_ZM).ID: return 5158;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_ZP).ID: return 5159;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_XM).ID: return 5160;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_XP).ID: return 5161;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_ZM).ID: return 5162;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_ZP).ID: return 5163;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_XM).ID: return 5164;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_XP).ID: return 5165;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_ZM).ID: return 5166;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_ZP).ID: return 5167;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_XM).ID: return 5168;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_XP).ID: return 5169;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_ZM).ID: return 5644;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_XP).ID: return 5645;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_ZP).ID: return 5646;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_XM).ID: return 5647;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_YP).ID: return 5648;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_YM).ID: return 5649;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_ZM).ID: return 5650;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_XP).ID: return 5651;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_ZP).ID: return 5652;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_XM).ID: return 5653;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_YP).ID: return 5654;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_YM).ID: return 5655;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Compare, true).ID: return 6678;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Compare, false).ID: return 6679;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Subtract, true).ID: return 6680;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Subtract, false).ID: return 6681;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Compare, true).ID: return 6682;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Compare, false).ID: return 6683;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Subtract, true).ID: return 6684;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Subtract, false).ID: return 6685;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Compare, true).ID: return 6686;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Compare, false).ID: return 6687;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Subtract, true).ID: return 6688;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Subtract, false).ID: return 6689;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Compare, true).ID: return 6690;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Compare, false).ID: return 6691;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Subtract, true).ID: return 6692;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Subtract, false).ID: return 6693;
			case Composter::Composter(0).ID: return 15751;
			case Composter::Composter(1).ID: return 15752;
			case Composter::Composter(2).ID: return 15753;
			case Composter::Composter(3).ID: return 15754;
			case Composter::Composter(4).ID: return 15755;
			case Composter::Composter(5).ID: return 15756;
			case Composter::Composter(6).ID: return 15757;
			case Composter::Composter(7).ID: return 15758;
			case Composter::Composter(8).ID: return 15759;
			case Conduit::Conduit().ID: return 9650;
			case Cornflower::Cornflower().ID: return 1422;
			case CrackedNetherBricks::CrackedNetherBricks().ID: return 17102;
			case CrackedPolishedBlackstoneBricks::CrackedPolishedBlackstoneBricks().ID: return 16252;
			case CrackedStoneBricks::CrackedStoneBricks().ID: return 4497;
			case CraftingTable::CraftingTable().ID: return 3356;
			case CreeperHead::CreeperHead(0).ID: return 6570;
			case CreeperHead::CreeperHead(1).ID: return 6571;
			case CreeperHead::CreeperHead(2).ID: return 6572;
			case CreeperHead::CreeperHead(3).ID: return 6573;
			case CreeperHead::CreeperHead(4).ID: return 6574;
			case CreeperHead::CreeperHead(5).ID: return 6575;
			case CreeperHead::CreeperHead(6).ID: return 6576;
			case CreeperHead::CreeperHead(7).ID: return 6577;
			case CreeperHead::CreeperHead(8).ID: return 6578;
			case CreeperHead::CreeperHead(9).ID: return 6579;
			case CreeperHead::CreeperHead(10).ID: return 6580;
			case CreeperHead::CreeperHead(11).ID: return 6581;
			case CreeperHead::CreeperHead(12).ID: return 6582;
			case CreeperHead::CreeperHead(13).ID: return 6583;
			case CreeperHead::CreeperHead(14).ID: return 6584;
			case CreeperHead::CreeperHead(15).ID: return 6585;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6586;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6587;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6588;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6589;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 15479;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 15480;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 15481;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 15482;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 15483;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 15484;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 15485;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 15486;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 15487;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 15488;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 15489;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 15490;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 15491;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 15492;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 15493;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 15494;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 15495;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 15496;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 15497;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 15498;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 15499;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 15500;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 15501;
			case CrimsonButton::CrimsonButton(CrimsonButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 15502;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, true).ID: return 15527;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, false).ID: return 15528;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, true).ID: return 15529;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, false).ID: return 15530;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, true).ID: return 15531;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, false).ID: return 15532;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, true).ID: return 15533;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, false).ID: return 15534;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, true).ID: return 15535;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, false).ID: return 15536;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, true).ID: return 15537;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, false).ID: return 15538;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, true).ID: return 15539;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, false).ID: return 15540;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, true).ID: return 15541;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, false).ID: return 15542;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, true).ID: return 15543;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, false).ID: return 15544;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, true).ID: return 15545;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, false).ID: return 15546;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, true).ID: return 15547;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, false).ID: return 15548;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, true).ID: return 15549;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, false).ID: return 15550;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, true).ID: return 15551;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, false).ID: return 15552;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, true).ID: return 15553;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, false).ID: return 15554;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, true).ID: return 15555;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, false).ID: return 15556;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, true).ID: return 15557;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_ZP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, false).ID: return 15558;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, true).ID: return 15559;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, false).ID: return 15560;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, true).ID: return 15561;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, false).ID: return 15562;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, true).ID: return 15563;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, false).ID: return 15564;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, true).ID: return 15565;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, false).ID: return 15566;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, true).ID: return 15567;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, false).ID: return 15568;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, true).ID: return 15569;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, false).ID: return 15570;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, true).ID: return 15571;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, false).ID: return 15572;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, true).ID: return 15573;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XM, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, false).ID: return 15574;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, true).ID: return 15575;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, true, false).ID: return 15576;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, true).ID: return 15577;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Left, false, false).ID: return 15578;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, true).ID: return 15579;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, true, false).ID: return 15580;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, true).ID: return 15581;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Upper, CrimsonDoor::Hinge::Right, false, false).ID: return 15582;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, true).ID: return 15583;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, true, false).ID: return 15584;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, true).ID: return 15585;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Left, false, false).ID: return 15586;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, true).ID: return 15587;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, true, false).ID: return 15588;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, true).ID: return 15589;
			case CrimsonDoor::CrimsonDoor(eBlockFace::BLOCK_FACE_XP, CrimsonDoor::Half::Lower, CrimsonDoor::Hinge::Right, false, false).ID: return 15590;
			case CrimsonFence::CrimsonFence(true, true, true, true).ID: return 15065;
			case CrimsonFence::CrimsonFence(true, true, true, false).ID: return 15066;
			case CrimsonFence::CrimsonFence(true, true, false, true).ID: return 15069;
			case CrimsonFence::CrimsonFence(true, true, false, false).ID: return 15070;
			case CrimsonFence::CrimsonFence(true, false, true, true).ID: return 15073;
			case CrimsonFence::CrimsonFence(true, false, true, false).ID: return 15074;
			case CrimsonFence::CrimsonFence(true, false, false, true).ID: return 15077;
			case CrimsonFence::CrimsonFence(true, false, false, false).ID: return 15078;
			case CrimsonFence::CrimsonFence(false, true, true, true).ID: return 15081;
			case CrimsonFence::CrimsonFence(false, true, true, false).ID: return 15082;
			case CrimsonFence::CrimsonFence(false, true, false, true).ID: return 15085;
			case CrimsonFence::CrimsonFence(false, true, false, false).ID: return 15086;
			case CrimsonFence::CrimsonFence(false, false, true, true).ID: return 15089;
			case CrimsonFence::CrimsonFence(false, false, true, false).ID: return 15090;
			case CrimsonFence::CrimsonFence(false, false, false, true).ID: return 15093;
			case CrimsonFence::CrimsonFence(false, false, false, false).ID: return 15094;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 15255;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 15256;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 15257;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 15258;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 15259;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 15260;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 15261;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 15262;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 15263;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 15264;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 15265;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 15266;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 15267;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 15268;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 15269;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 15270;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 15271;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 15272;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 15273;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 15274;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 15275;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 15276;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 15277;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 15278;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 15279;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 15280;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 15281;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 15282;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 15283;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 15284;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 15285;
			case CrimsonFenceGate::CrimsonFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 15286;
			case CrimsonFungus::CrimsonFungus().ID: return 14988;
			case CrimsonHyphae::CrimsonHyphae(CrimsonHyphae::Axis::X).ID: return 14981;
			case CrimsonHyphae::CrimsonHyphae(CrimsonHyphae::Axis::Y).ID: return 14982;
			case CrimsonHyphae::CrimsonHyphae(CrimsonHyphae::Axis::Z).ID: return 14983;
			case CrimsonNylium::CrimsonNylium().ID: return 14987;
			case CrimsonPlanks::CrimsonPlanks().ID: return 15045;
			case CrimsonPressurePlate::CrimsonPressurePlate(true).ID: return 15059;
			case CrimsonPressurePlate::CrimsonPressurePlate(false).ID: return 15060;
			case CrimsonRoots::CrimsonRoots().ID: return 15044;
			case CrimsonSign::CrimsonSign(0).ID: return 15656;
			case CrimsonSign::CrimsonSign(1).ID: return 15658;
			case CrimsonSign::CrimsonSign(2).ID: return 15660;
			case CrimsonSign::CrimsonSign(3).ID: return 15662;
			case CrimsonSign::CrimsonSign(4).ID: return 15664;
			case CrimsonSign::CrimsonSign(5).ID: return 15666;
			case CrimsonSign::CrimsonSign(6).ID: return 15668;
			case CrimsonSign::CrimsonSign(7).ID: return 15670;
			case CrimsonSign::CrimsonSign(8).ID: return 15672;
			case CrimsonSign::CrimsonSign(9).ID: return 15674;
			case CrimsonSign::CrimsonSign(10).ID: return 15676;
			case CrimsonSign::CrimsonSign(11).ID: return 15678;
			case CrimsonSign::CrimsonSign(12).ID: return 15680;
			case CrimsonSign::CrimsonSign(13).ID: return 15682;
			case CrimsonSign::CrimsonSign(14).ID: return 15684;
			case CrimsonSign::CrimsonSign(15).ID: return 15686;
			case CrimsonSlab::CrimsonSlab(CrimsonSlab::Type::Top).ID: return 15048;
			case CrimsonSlab::CrimsonSlab(CrimsonSlab::Type::Bottom).ID: return 15050;
			case CrimsonSlab::CrimsonSlab(CrimsonSlab::Type::Double).ID: return 15052;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::Straight).ID: return 15320;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerLeft).ID: return 15322;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerRight).ID: return 15324;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterLeft).ID: return 15326;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterRight).ID: return 15328;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::Straight).ID: return 15330;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerLeft).ID: return 15332;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerRight).ID: return 15334;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterLeft).ID: return 15336;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterRight).ID: return 15338;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::Straight).ID: return 15340;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerLeft).ID: return 15342;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerRight).ID: return 15344;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterLeft).ID: return 15346;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterRight).ID: return 15348;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::Straight).ID: return 15350;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerLeft).ID: return 15352;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerRight).ID: return 15354;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterLeft).ID: return 15356;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_ZP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterRight).ID: return 15358;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::Straight).ID: return 15360;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerLeft).ID: return 15362;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerRight).ID: return 15364;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterLeft).ID: return 15366;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterRight).ID: return 15368;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::Straight).ID: return 15370;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerLeft).ID: return 15372;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerRight).ID: return 15374;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterLeft).ID: return 15376;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XM, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterRight).ID: return 15378;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::Straight).ID: return 15380;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerLeft).ID: return 15382;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::InnerRight).ID: return 15384;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterLeft).ID: return 15386;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Top, CrimsonStairs::Shape::OuterRight).ID: return 15388;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::Straight).ID: return 15390;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerLeft).ID: return 15392;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::InnerRight).ID: return 15394;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterLeft).ID: return 15396;
			case CrimsonStairs::CrimsonStairs(eBlockFace::BLOCK_FACE_XP, CrimsonStairs::Half::Bottom, CrimsonStairs::Shape::OuterRight).ID: return 15398;
			case CrimsonStem::CrimsonStem(CrimsonStem::Axis::X).ID: return 14975;
			case CrimsonStem::CrimsonStem(CrimsonStem::Axis::Y).ID: return 14976;
			case CrimsonStem::CrimsonStem(CrimsonStem::Axis::Z).ID: return 14977;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Top, true, true).ID: return 15128;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Top, true, false).ID: return 15130;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Top, false, true).ID: return 15132;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Top, false, false).ID: return 15134;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Bottom, true, true).ID: return 15136;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Bottom, true, false).ID: return 15138;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Bottom, false, true).ID: return 15140;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZM, CrimsonTrapdoor::Half::Bottom, false, false).ID: return 15142;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Top, true, true).ID: return 15144;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Top, true, false).ID: return 15146;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Top, false, true).ID: return 15148;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Top, false, false).ID: return 15150;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Bottom, true, true).ID: return 15152;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Bottom, true, false).ID: return 15154;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Bottom, false, true).ID: return 15156;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_ZP, CrimsonTrapdoor::Half::Bottom, false, false).ID: return 15158;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Top, true, true).ID: return 15160;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Top, true, false).ID: return 15162;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Top, false, true).ID: return 15164;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Top, false, false).ID: return 15166;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Bottom, true, true).ID: return 15168;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Bottom, true, false).ID: return 15170;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Bottom, false, true).ID: return 15172;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XM, CrimsonTrapdoor::Half::Bottom, false, false).ID: return 15174;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Top, true, true).ID: return 15176;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Top, true, false).ID: return 15178;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Top, false, true).ID: return 15180;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Top, false, false).ID: return 15182;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Bottom, true, true).ID: return 15184;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Bottom, true, false).ID: return 15186;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Bottom, false, true).ID: return 15188;
			case CrimsonTrapdoor::CrimsonTrapdoor(eBlockFace::BLOCK_FACE_XP, CrimsonTrapdoor::Half::Bottom, false, false).ID: return 15190;
			case CrimsonWallSign::CrimsonWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 15720;
			case CrimsonWallSign::CrimsonWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 15722;
			case CrimsonWallSign::CrimsonWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 15724;
			case CrimsonWallSign::CrimsonWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 15726;
			case CryingObsidian::CryingObsidian().ID: return 15828;
			case CutRedSandstone::CutRedSandstone().ID: return 8219;
			case CutRedSandstoneSlab::CutRedSandstoneSlab(CutRedSandstoneSlab::Type::Top).ID: return 8403;
			case CutRedSandstoneSlab::CutRedSandstoneSlab(CutRedSandstoneSlab::Type::Bottom).ID: return 8405;
			case CutRedSandstoneSlab::CutRedSandstoneSlab(CutRedSandstoneSlab::Type::Double).ID: return 8407;
			case CutSandstone::CutSandstone().ID: return 248;
			case CutSandstoneSlab::CutSandstoneSlab(CutSandstoneSlab::Type::Top).ID: return 8355;
			case CutSandstoneSlab::CutSandstoneSlab(CutSandstoneSlab::Type::Bottom).ID: return 8357;
			case CutSandstoneSlab::CutSandstoneSlab(CutSandstoneSlab::Type::Double).ID: return 8359;
			case CyanBanner::CyanBanner(0).ID: return 8041;
			case CyanBanner::CyanBanner(1).ID: return 8042;
			case CyanBanner::CyanBanner(2).ID: return 8043;
			case CyanBanner::CyanBanner(3).ID: return 8044;
			case CyanBanner::CyanBanner(4).ID: return 8045;
			case CyanBanner::CyanBanner(5).ID: return 8046;
			case CyanBanner::CyanBanner(6).ID: return 8047;
			case CyanBanner::CyanBanner(7).ID: return 8048;
			case CyanBanner::CyanBanner(8).ID: return 8049;
			case CyanBanner::CyanBanner(9).ID: return 8050;
			case CyanBanner::CyanBanner(10).ID: return 8051;
			case CyanBanner::CyanBanner(11).ID: return 8052;
			case CyanBanner::CyanBanner(12).ID: return 8053;
			case CyanBanner::CyanBanner(13).ID: return 8054;
			case CyanBanner::CyanBanner(14).ID: return 8055;
			case CyanBanner::CyanBanner(15).ID: return 8056;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, true, CyanBed::Part::Head).ID: return 1193;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, true, CyanBed::Part::Foot).ID: return 1194;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, false, CyanBed::Part::Head).ID: return 1195;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, false, CyanBed::Part::Foot).ID: return 1196;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, true, CyanBed::Part::Head).ID: return 1197;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, true, CyanBed::Part::Foot).ID: return 1198;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, false, CyanBed::Part::Head).ID: return 1199;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, false, CyanBed::Part::Foot).ID: return 1200;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, true, CyanBed::Part::Head).ID: return 1201;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, true, CyanBed::Part::Foot).ID: return 1202;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, false, CyanBed::Part::Head).ID: return 1203;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, false, CyanBed::Part::Foot).ID: return 1204;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, true, CyanBed::Part::Head).ID: return 1205;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, true, CyanBed::Part::Foot).ID: return 1206;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, false, CyanBed::Part::Head).ID: return 1207;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, false, CyanBed::Part::Foot).ID: return 1208;
			case CyanCarpet::CyanCarpet().ID: return 7875;
			case CyanConcrete::CyanConcrete().ID: return 9447;
			case CyanConcretePowder::CyanConcretePowder().ID: return 9463;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9410;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9411;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9412;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9413;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9332;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9333;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9334;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9335;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9336;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9337;
			case CyanStainedGlass::CyanStainedGlass().ID: return 4104;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, true, true).ID: return 7153;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, true, false).ID: return 7154;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, false, true).ID: return 7157;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, false, false).ID: return 7158;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, true, true).ID: return 7161;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, true, false).ID: return 7162;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, false, true).ID: return 7165;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, false, false).ID: return 7166;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, true, true).ID: return 7169;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, true, false).ID: return 7170;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, false, true).ID: return 7173;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, false, false).ID: return 7174;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, true, true).ID: return 7177;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, true, false).ID: return 7178;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, false, true).ID: return 7181;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, false, false).ID: return 7182;
			case CyanTerracotta::CyanTerracotta().ID: return 6856;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8189;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8190;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8191;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8192;
			case CyanWool::CyanWool().ID: return 1393;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_ZM).ID: return 6618;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_ZP).ID: return 6619;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_XM).ID: return 6620;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_XP).ID: return 6621;
			case Dandelion::Dandelion().ID: return 1412;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6466;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6467;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6468;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6469;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 6470;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 6471;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 6472;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 6473;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6474;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6475;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6476;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6477;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 6478;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 6479;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 6480;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 6481;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6482;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6483;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6484;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6485;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 6486;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 6487;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 6488;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 6489;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 8994;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 8995;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 8996;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 8997;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 8998;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 8999;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 9000;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 9001;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 9002;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 9003;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 9004;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 9005;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 9006;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 9007;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 9008;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 9009;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 9010;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 9011;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 9012;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 9013;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 9014;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 9015;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 9016;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 9017;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 9018;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 9019;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 9020;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 9021;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 9022;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 9023;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 9024;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 9025;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 9026;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 9027;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 9028;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 9029;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 9030;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 9031;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 9032;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 9033;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 9034;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 9035;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 9036;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 9037;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 9038;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 9039;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 9040;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 9041;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 9042;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 9043;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 9044;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 9045;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 9046;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 9047;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 9048;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 9049;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 9050;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 9051;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 9052;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 9053;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 9054;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 9055;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 9056;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 9057;
			case DarkOakFence::DarkOakFence(true, true, true, true).ID: return 8708;
			case DarkOakFence::DarkOakFence(true, true, true, false).ID: return 8709;
			case DarkOakFence::DarkOakFence(true, true, false, true).ID: return 8712;
			case DarkOakFence::DarkOakFence(true, true, false, false).ID: return 8713;
			case DarkOakFence::DarkOakFence(true, false, true, true).ID: return 8716;
			case DarkOakFence::DarkOakFence(true, false, true, false).ID: return 8717;
			case DarkOakFence::DarkOakFence(true, false, false, true).ID: return 8720;
			case DarkOakFence::DarkOakFence(true, false, false, false).ID: return 8721;
			case DarkOakFence::DarkOakFence(false, true, true, true).ID: return 8724;
			case DarkOakFence::DarkOakFence(false, true, true, false).ID: return 8725;
			case DarkOakFence::DarkOakFence(false, true, false, true).ID: return 8728;
			case DarkOakFence::DarkOakFence(false, true, false, false).ID: return 8729;
			case DarkOakFence::DarkOakFence(false, false, true, true).ID: return 8732;
			case DarkOakFence::DarkOakFence(false, false, true, false).ID: return 8733;
			case DarkOakFence::DarkOakFence(false, false, false, true).ID: return 8736;
			case DarkOakFence::DarkOakFence(false, false, false, false).ID: return 8737;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 8546;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 8547;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 8548;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 8549;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 8550;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 8551;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 8552;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 8553;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 8554;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 8555;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 8556;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 8557;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 8558;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 8559;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 8560;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 8561;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 8562;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 8563;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 8564;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 8565;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 8566;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 8567;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 8568;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 8569;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 8570;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 8571;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 8572;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 8573;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 8574;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 8575;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 8576;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 8577;
			case DarkOakLeaves::DarkOakLeaves(1, true).ID: return 215;
			case DarkOakLeaves::DarkOakLeaves(1, false).ID: return 216;
			case DarkOakLeaves::DarkOakLeaves(2, true).ID: return 217;
			case DarkOakLeaves::DarkOakLeaves(2, false).ID: return 218;
			case DarkOakLeaves::DarkOakLeaves(3, true).ID: return 219;
			case DarkOakLeaves::DarkOakLeaves(3, false).ID: return 220;
			case DarkOakLeaves::DarkOakLeaves(4, true).ID: return 221;
			case DarkOakLeaves::DarkOakLeaves(4, false).ID: return 222;
			case DarkOakLeaves::DarkOakLeaves(5, true).ID: return 223;
			case DarkOakLeaves::DarkOakLeaves(5, false).ID: return 224;
			case DarkOakLeaves::DarkOakLeaves(6, true).ID: return 225;
			case DarkOakLeaves::DarkOakLeaves(6, false).ID: return 226;
			case DarkOakLeaves::DarkOakLeaves(7, true).ID: return 227;
			case DarkOakLeaves::DarkOakLeaves(7, false).ID: return 228;
			case DarkOakLog::DarkOakLog(DarkOakLog::Axis::X).ID: return 88;
			case DarkOakLog::DarkOakLog(DarkOakLog::Axis::Y).ID: return 89;
			case DarkOakLog::DarkOakLog(DarkOakLog::Axis::Z).ID: return 90;
			case DarkOakPlanks::DarkOakPlanks().ID: return 20;
			case DarkOakPressurePlate::DarkOakPressurePlate(true).ID: return 3883;
			case DarkOakPressurePlate::DarkOakPressurePlate(false).ID: return 3884;
			case DarkOakSapling::DarkOakSapling(0).ID: return 31;
			case DarkOakSapling::DarkOakSapling(1).ID: return 32;
			case DarkOakSign::DarkOakSign(0).ID: return 3542;
			case DarkOakSign::DarkOakSign(1).ID: return 3544;
			case DarkOakSign::DarkOakSign(2).ID: return 3546;
			case DarkOakSign::DarkOakSign(3).ID: return 3548;
			case DarkOakSign::DarkOakSign(4).ID: return 3550;
			case DarkOakSign::DarkOakSign(5).ID: return 3552;
			case DarkOakSign::DarkOakSign(6).ID: return 3554;
			case DarkOakSign::DarkOakSign(7).ID: return 3556;
			case DarkOakSign::DarkOakSign(8).ID: return 3558;
			case DarkOakSign::DarkOakSign(9).ID: return 3560;
			case DarkOakSign::DarkOakSign(10).ID: return 3562;
			case DarkOakSign::DarkOakSign(11).ID: return 3564;
			case DarkOakSign::DarkOakSign(12).ID: return 3566;
			case DarkOakSign::DarkOakSign(13).ID: return 3568;
			case DarkOakSign::DarkOakSign(14).ID: return 3570;
			case DarkOakSign::DarkOakSign(15).ID: return 3572;
			case DarkOakSlab::DarkOakSlab(DarkOakSlab::Type::Top).ID: return 8331;
			case DarkOakSlab::DarkOakSlab(DarkOakSlab::Type::Bottom).ID: return 8333;
			case DarkOakSlab::DarkOakSlab(DarkOakSlab::Type::Double).ID: return 8335;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 7456;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 7458;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 7460;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 7462;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 7464;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 7466;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 7468;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 7470;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 7472;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 7474;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 7476;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 7478;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 7480;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 7482;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 7484;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 7486;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 7488;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 7490;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 7492;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 7494;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 7496;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 7498;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 7500;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 7502;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 7504;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 7506;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 7508;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 7510;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 7512;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 7514;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 7516;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 7518;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 7520;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 7522;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 7524;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 7526;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 7528;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 7530;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 7532;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 7534;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, true, true).ID: return 4432;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, true, false).ID: return 4434;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, false, true).ID: return 4436;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, false, false).ID: return 4438;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4440;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4442;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4444;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4446;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, true, true).ID: return 4448;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, true, false).ID: return 4450;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, false, true).ID: return 4452;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, false, false).ID: return 4454;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4456;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4458;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4460;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4462;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, true, true).ID: return 4464;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, true, false).ID: return 4466;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, false, true).ID: return 4468;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, false, false).ID: return 4470;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4472;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4474;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4476;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4478;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, true, true).ID: return 4480;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, true, false).ID: return 4482;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, false, true).ID: return 4484;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, false, false).ID: return 4486;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4488;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4490;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4492;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4494;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3776;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3778;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3780;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3782;
			case DarkOakWood::DarkOakWood(DarkOakWood::Axis::X).ID: return 124;
			case DarkOakWood::DarkOakWood(DarkOakWood::Axis::Y).ID: return 125;
			case DarkOakWood::DarkOakWood(DarkOakWood::Axis::Z).ID: return 126;
			case DarkPrismarine::DarkPrismarine().ID: return 7603;
			case DarkPrismarineSlab::DarkPrismarineSlab(DarkPrismarineSlab::Type::Top).ID: return 7857;
			case DarkPrismarineSlab::DarkPrismarineSlab(DarkPrismarineSlab::Type::Bottom).ID: return 7859;
			case DarkPrismarineSlab::DarkPrismarineSlab(DarkPrismarineSlab::Type::Double).ID: return 7861;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7765;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7767;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7769;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7771;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7773;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7775;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7777;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7779;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7781;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7783;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7785;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7787;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7789;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7791;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7793;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7795;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7797;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7799;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7801;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7803;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7805;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7807;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7809;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7811;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7813;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7815;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7817;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7819;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7821;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7823;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7825;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7827;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7829;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7831;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7833;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7835;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7837;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7839;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7841;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7843;
			case DaylightDetector::DaylightDetector(true, 0).ID: return 6694;
			case DaylightDetector::DaylightDetector(true, 1).ID: return 6695;
			case DaylightDetector::DaylightDetector(true, 2).ID: return 6696;
			case DaylightDetector::DaylightDetector(true, 3).ID: return 6697;
			case DaylightDetector::DaylightDetector(true, 4).ID: return 6698;
			case DaylightDetector::DaylightDetector(true, 5).ID: return 6699;
			case DaylightDetector::DaylightDetector(true, 6).ID: return 6700;
			case DaylightDetector::DaylightDetector(true, 7).ID: return 6701;
			case DaylightDetector::DaylightDetector(true, 8).ID: return 6702;
			case DaylightDetector::DaylightDetector(true, 9).ID: return 6703;
			case DaylightDetector::DaylightDetector(true, 10).ID: return 6704;
			case DaylightDetector::DaylightDetector(true, 11).ID: return 6705;
			case DaylightDetector::DaylightDetector(true, 12).ID: return 6706;
			case DaylightDetector::DaylightDetector(true, 13).ID: return 6707;
			case DaylightDetector::DaylightDetector(true, 14).ID: return 6708;
			case DaylightDetector::DaylightDetector(true, 15).ID: return 6709;
			case DaylightDetector::DaylightDetector(false, 0).ID: return 6710;
			case DaylightDetector::DaylightDetector(false, 1).ID: return 6711;
			case DaylightDetector::DaylightDetector(false, 2).ID: return 6712;
			case DaylightDetector::DaylightDetector(false, 3).ID: return 6713;
			case DaylightDetector::DaylightDetector(false, 4).ID: return 6714;
			case DaylightDetector::DaylightDetector(false, 5).ID: return 6715;
			case DaylightDetector::DaylightDetector(false, 6).ID: return 6716;
			case DaylightDetector::DaylightDetector(false, 7).ID: return 6717;
			case DaylightDetector::DaylightDetector(false, 8).ID: return 6718;
			case DaylightDetector::DaylightDetector(false, 9).ID: return 6719;
			case DaylightDetector::DaylightDetector(false, 10).ID: return 6720;
			case DaylightDetector::DaylightDetector(false, 11).ID: return 6721;
			case DaylightDetector::DaylightDetector(false, 12).ID: return 6722;
			case DaylightDetector::DaylightDetector(false, 13).ID: return 6723;
			case DaylightDetector::DaylightDetector(false, 14).ID: return 6724;
			case DaylightDetector::DaylightDetector(false, 15).ID: return 6725;
			case DeadBrainCoral::DeadBrainCoral().ID: return 9523;
			case DeadBrainCoralBlock::DeadBrainCoralBlock().ID: return 9511;
			case DeadBrainCoralFan::DeadBrainCoralFan().ID: return 9543;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9569;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9571;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9573;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9575;
			case DeadBubbleCoral::DeadBubbleCoral().ID: return 9525;
			case DeadBubbleCoralBlock::DeadBubbleCoralBlock().ID: return 9512;
			case DeadBubbleCoralFan::DeadBubbleCoralFan().ID: return 9545;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9577;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9579;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9581;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9583;
			case DeadBush::DeadBush().ID: return 1344;
			case DeadFireCoral::DeadFireCoral().ID: return 9527;
			case DeadFireCoralBlock::DeadFireCoralBlock().ID: return 9513;
			case DeadFireCoralFan::DeadFireCoralFan().ID: return 9547;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9585;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9587;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9589;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9591;
			case DeadHornCoral::DeadHornCoral().ID: return 9529;
			case DeadHornCoralBlock::DeadHornCoralBlock().ID: return 9514;
			case DeadHornCoralFan::DeadHornCoralFan().ID: return 9549;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9593;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9595;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9597;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9599;
			case DeadTubeCoral::DeadTubeCoral().ID: return 9521;
			case DeadTubeCoralBlock::DeadTubeCoralBlock().ID: return 9510;
			case DeadTubeCoralFan::DeadTubeCoralFan().ID: return 9541;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9561;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9563;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9565;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9567;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::NorthSouth).ID: return 1317;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::EastWest).ID: return 1318;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingEast).ID: return 1319;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingWest).ID: return 1320;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingNorth).ID: return 1321;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingSouth).ID: return 1322;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::NorthSouth).ID: return 1323;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::EastWest).ID: return 1324;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingEast).ID: return 1325;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingWest).ID: return 1326;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingNorth).ID: return 1327;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingSouth).ID: return 1328;
			case DiamondBlock::DiamondBlock().ID: return 3355;
			case DiamondOre::DiamondOre().ID: return 3354;
			case Diorite::Diorite().ID: return 4;
			case DioriteSlab::DioriteSlab(DioriteSlab::Type::Top).ID: return 10862;
			case DioriteSlab::DioriteSlab(DioriteSlab::Type::Bottom).ID: return 10864;
			case DioriteSlab::DioriteSlab(DioriteSlab::Type::Double).ID: return 10866;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10710;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10712;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10714;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10716;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10718;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10720;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10722;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10724;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10726;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10728;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10730;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10732;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10734;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10736;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10738;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10740;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10742;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10744;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10746;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10748;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10750;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10752;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10754;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10756;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10758;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10760;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10762;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10764;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10766;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10768;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10770;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10772;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10774;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10776;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10778;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10780;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10782;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10784;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10786;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10788;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14434;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14435;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14436;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14440;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14441;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14442;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14446;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14447;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14448;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14452;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14453;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14454;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14458;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14459;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14460;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14464;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14465;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14466;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14470;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14471;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14472;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14476;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14477;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14478;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14482;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14483;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14484;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14488;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14489;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14490;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14494;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14495;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14496;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14500;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14501;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14502;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14506;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14507;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14508;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14512;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14513;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14514;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14518;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14519;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14520;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14524;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14525;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14526;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14530;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14531;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14532;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14536;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14537;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14538;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14542;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14543;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14544;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14548;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14549;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14550;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14554;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14555;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14556;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14560;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14561;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14562;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14566;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14567;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14568;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14572;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14573;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14574;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14578;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14579;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14580;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14584;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14585;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14586;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14590;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14591;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14592;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14596;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14597;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14598;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14602;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14603;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14604;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14608;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14609;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14610;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14614;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14615;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14616;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14620;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14621;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14622;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14626;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14627;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14628;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14632;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14633;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14634;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14638;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14639;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14640;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14644;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14645;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14646;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14650;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14651;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14652;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14656;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14657;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14658;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14662;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14663;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14664;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14668;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14669;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14670;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14674;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14675;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14676;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14680;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14681;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::None, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14682;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14686;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14687;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14688;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14692;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14693;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14694;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14698;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14699;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14700;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14704;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14705;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14706;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14710;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14711;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14712;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14716;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14717;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Low, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14718;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 14722;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 14723;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::None, true, DioriteWall::West::Tall).ID: return 14724;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 14728;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 14729;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::None, false, DioriteWall::West::Tall).ID: return 14730;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 14734;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 14735;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Low, true, DioriteWall::West::Tall).ID: return 14736;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 14740;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 14741;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Low, false, DioriteWall::West::Tall).ID: return 14742;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::None).ID: return 14746;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::Low).ID: return 14747;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Tall, true, DioriteWall::West::Tall).ID: return 14748;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::None).ID: return 14752;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::Low).ID: return 14753;
			case DioriteWall::DioriteWall(DioriteWall::East::Tall, DioriteWall::North::Tall, DioriteWall::South::Tall, false, DioriteWall::West::Tall).ID: return 14754;
			case Dirt::Dirt().ID: return 10;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZM, true).ID: return 234;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZM, false).ID: return 235;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XP, true).ID: return 236;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XP, false).ID: return 237;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZP, true).ID: return 238;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZP, false).ID: return 239;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XM, true).ID: return 240;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XM, false).ID: return 241;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YP, true).ID: return 242;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YP, false).ID: return 243;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YM, true).ID: return 244;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YM, false).ID: return 245;
			case DragonEgg::DragonEgg().ID: return 5155;
			case DragonHead::DragonHead(0).ID: return 6590;
			case DragonHead::DragonHead(1).ID: return 6591;
			case DragonHead::DragonHead(2).ID: return 6592;
			case DragonHead::DragonHead(3).ID: return 6593;
			case DragonHead::DragonHead(4).ID: return 6594;
			case DragonHead::DragonHead(5).ID: return 6595;
			case DragonHead::DragonHead(6).ID: return 6596;
			case DragonHead::DragonHead(7).ID: return 6597;
			case DragonHead::DragonHead(8).ID: return 6598;
			case DragonHead::DragonHead(9).ID: return 6599;
			case DragonHead::DragonHead(10).ID: return 6600;
			case DragonHead::DragonHead(11).ID: return 6601;
			case DragonHead::DragonHead(12).ID: return 6602;
			case DragonHead::DragonHead(13).ID: return 6603;
			case DragonHead::DragonHead(14).ID: return 6604;
			case DragonHead::DragonHead(15).ID: return 6605;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6606;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6607;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6608;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6609;
			case DriedKelpBlock::DriedKelpBlock().ID: return 9497;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZM, true).ID: return 6835;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZM, false).ID: return 6836;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XP, true).ID: return 6837;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XP, false).ID: return 6838;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZP, true).ID: return 6839;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZP, false).ID: return 6840;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XM, true).ID: return 6841;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XM, false).ID: return 6842;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YP, true).ID: return 6843;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YP, false).ID: return 6844;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YM, true).ID: return 6845;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YM, false).ID: return 6846;
			case EmeraldBlock::EmeraldBlock().ID: return 5403;
			case EmeraldOre::EmeraldOre().ID: return 5250;
			case EnchantingTable::EnchantingTable().ID: return 5132;
			case EndGateway::EndGateway().ID: return 9224;
			case EndPortal::EndPortal().ID: return 5145;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_ZM).ID: return 5146;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_ZP).ID: return 5147;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_XM).ID: return 5148;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_XP).ID: return 5149;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_ZM).ID: return 5150;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_ZP).ID: return 5151;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_XM).ID: return 5152;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_XP).ID: return 5153;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_ZM).ID: return 9058;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_XP).ID: return 9059;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_ZP).ID: return 9060;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_XM).ID: return 9061;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_YP).ID: return 9062;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_YM).ID: return 9063;
			case EndStone::EndStone().ID: return 5154;
			case EndStoneBrickSlab::EndStoneBrickSlab(EndStoneBrickSlab::Type::Top).ID: return 10820;
			case EndStoneBrickSlab::EndStoneBrickSlab(EndStoneBrickSlab::Type::Bottom).ID: return 10822;
			case EndStoneBrickSlab::EndStoneBrickSlab(EndStoneBrickSlab::Type::Double).ID: return 10824;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 10070;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10072;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 10074;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10076;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 10078;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 10080;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10082;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 10084;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10086;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 10088;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 10090;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10092;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 10094;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10096;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 10098;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 10100;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10102;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 10104;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10106;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 10108;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 10110;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10112;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 10114;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10116;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 10118;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 10120;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10122;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 10124;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10126;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 10128;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 10130;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10132;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 10134;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10136;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 10138;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 10140;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 10142;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 10144;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 10146;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 10148;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14110;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14111;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14112;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14116;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14117;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14118;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14122;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14123;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14124;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14128;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14129;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14130;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14134;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14135;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14136;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14140;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14141;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14142;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14146;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14147;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14148;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14152;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14153;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14154;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14158;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14159;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14160;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14164;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14165;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14166;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14170;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14171;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14172;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14176;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14177;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14178;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14182;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14183;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14184;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14188;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14189;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14190;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14194;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14195;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14196;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14200;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14201;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14202;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14206;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14207;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14208;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14212;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14213;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14214;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14218;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14219;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14220;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14224;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14225;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14226;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14230;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14231;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14232;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14236;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14237;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14238;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14242;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14243;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14244;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14248;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14249;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14250;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14254;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14255;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14256;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14260;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14261;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14262;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14266;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14267;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14268;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14272;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14273;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14274;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14278;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14279;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14280;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14284;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14285;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14286;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14290;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14291;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14292;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14296;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14297;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14298;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14302;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14303;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14304;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14308;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14309;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14310;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14314;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14315;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14316;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14320;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14321;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14322;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14326;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14327;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14328;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14332;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14333;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14334;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14338;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14339;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14340;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14344;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14345;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14346;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14350;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14351;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14352;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14356;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14357;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14358;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14362;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14363;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14364;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14368;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14369;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14370;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14374;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14375;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14376;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14380;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14381;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14382;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14386;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14387;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14388;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14392;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14393;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14394;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 14398;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 14399;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Tall).ID: return 14400;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 14404;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 14405;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Tall).ID: return 14406;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 14410;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 14411;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Tall).ID: return 14412;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 14416;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 14417;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Tall).ID: return 14418;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::None).ID: return 14422;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Low).ID: return 14423;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, true, EndStoneBrickWall::West::Tall).ID: return 14424;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::None).ID: return 14428;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Low).ID: return 14429;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Tall, EndStoneBrickWall::North::Tall, EndStoneBrickWall::South::Tall, false, EndStoneBrickWall::West::Tall).ID: return 14430;
			case EndStoneBricks::EndStoneBricks().ID: return 9218;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_ZM).ID: return 5252;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_ZP).ID: return 5254;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_XM).ID: return 5256;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_XP).ID: return 5258;
			case Farmland::Farmland(0).ID: return 3365;
			case Farmland::Farmland(1).ID: return 3366;
			case Farmland::Farmland(2).ID: return 3367;
			case Farmland::Farmland(3).ID: return 3368;
			case Farmland::Farmland(4).ID: return 3369;
			case Farmland::Farmland(5).ID: return 3370;
			case Farmland::Farmland(6).ID: return 3371;
			case Farmland::Farmland(7).ID: return 3372;
			case Fern::Fern().ID: return 1343;
			case Fire::Fire(0, true, true, true, true, true).ID: return 1440;
			case Fire::Fire(0, true, true, true, true, false).ID: return 1441;
			case Fire::Fire(0, true, true, true, false, true).ID: return 1442;
			case Fire::Fire(0, true, true, true, false, false).ID: return 1443;
			case Fire::Fire(0, true, true, false, true, true).ID: return 1444;
			case Fire::Fire(0, true, true, false, true, false).ID: return 1445;
			case Fire::Fire(0, true, true, false, false, true).ID: return 1446;
			case Fire::Fire(0, true, true, false, false, false).ID: return 1447;
			case Fire::Fire(0, true, false, true, true, true).ID: return 1448;
			case Fire::Fire(0, true, false, true, true, false).ID: return 1449;
			case Fire::Fire(0, true, false, true, false, true).ID: return 1450;
			case Fire::Fire(0, true, false, true, false, false).ID: return 1451;
			case Fire::Fire(0, true, false, false, true, true).ID: return 1452;
			case Fire::Fire(0, true, false, false, true, false).ID: return 1453;
			case Fire::Fire(0, true, false, false, false, true).ID: return 1454;
			case Fire::Fire(0, true, false, false, false, false).ID: return 1455;
			case Fire::Fire(0, false, true, true, true, true).ID: return 1456;
			case Fire::Fire(0, false, true, true, true, false).ID: return 1457;
			case Fire::Fire(0, false, true, true, false, true).ID: return 1458;
			case Fire::Fire(0, false, true, true, false, false).ID: return 1459;
			case Fire::Fire(0, false, true, false, true, true).ID: return 1460;
			case Fire::Fire(0, false, true, false, true, false).ID: return 1461;
			case Fire::Fire(0, false, true, false, false, true).ID: return 1462;
			case Fire::Fire(0, false, true, false, false, false).ID: return 1463;
			case Fire::Fire(0, false, false, true, true, true).ID: return 1464;
			case Fire::Fire(0, false, false, true, true, false).ID: return 1465;
			case Fire::Fire(0, false, false, true, false, true).ID: return 1466;
			case Fire::Fire(0, false, false, true, false, false).ID: return 1467;
			case Fire::Fire(0, false, false, false, true, true).ID: return 1468;
			case Fire::Fire(0, false, false, false, true, false).ID: return 1469;
			case Fire::Fire(0, false, false, false, false, true).ID: return 1470;
			case Fire::Fire(0, false, false, false, false, false).ID: return 1471;
			case Fire::Fire(1, true, true, true, true, true).ID: return 1472;
			case Fire::Fire(1, true, true, true, true, false).ID: return 1473;
			case Fire::Fire(1, true, true, true, false, true).ID: return 1474;
			case Fire::Fire(1, true, true, true, false, false).ID: return 1475;
			case Fire::Fire(1, true, true, false, true, true).ID: return 1476;
			case Fire::Fire(1, true, true, false, true, false).ID: return 1477;
			case Fire::Fire(1, true, true, false, false, true).ID: return 1478;
			case Fire::Fire(1, true, true, false, false, false).ID: return 1479;
			case Fire::Fire(1, true, false, true, true, true).ID: return 1480;
			case Fire::Fire(1, true, false, true, true, false).ID: return 1481;
			case Fire::Fire(1, true, false, true, false, true).ID: return 1482;
			case Fire::Fire(1, true, false, true, false, false).ID: return 1483;
			case Fire::Fire(1, true, false, false, true, true).ID: return 1484;
			case Fire::Fire(1, true, false, false, true, false).ID: return 1485;
			case Fire::Fire(1, true, false, false, false, true).ID: return 1486;
			case Fire::Fire(1, true, false, false, false, false).ID: return 1487;
			case Fire::Fire(1, false, true, true, true, true).ID: return 1488;
			case Fire::Fire(1, false, true, true, true, false).ID: return 1489;
			case Fire::Fire(1, false, true, true, false, true).ID: return 1490;
			case Fire::Fire(1, false, true, true, false, false).ID: return 1491;
			case Fire::Fire(1, false, true, false, true, true).ID: return 1492;
			case Fire::Fire(1, false, true, false, true, false).ID: return 1493;
			case Fire::Fire(1, false, true, false, false, true).ID: return 1494;
			case Fire::Fire(1, false, true, false, false, false).ID: return 1495;
			case Fire::Fire(1, false, false, true, true, true).ID: return 1496;
			case Fire::Fire(1, false, false, true, true, false).ID: return 1497;
			case Fire::Fire(1, false, false, true, false, true).ID: return 1498;
			case Fire::Fire(1, false, false, true, false, false).ID: return 1499;
			case Fire::Fire(1, false, false, false, true, true).ID: return 1500;
			case Fire::Fire(1, false, false, false, true, false).ID: return 1501;
			case Fire::Fire(1, false, false, false, false, true).ID: return 1502;
			case Fire::Fire(1, false, false, false, false, false).ID: return 1503;
			case Fire::Fire(2, true, true, true, true, true).ID: return 1504;
			case Fire::Fire(2, true, true, true, true, false).ID: return 1505;
			case Fire::Fire(2, true, true, true, false, true).ID: return 1506;
			case Fire::Fire(2, true, true, true, false, false).ID: return 1507;
			case Fire::Fire(2, true, true, false, true, true).ID: return 1508;
			case Fire::Fire(2, true, true, false, true, false).ID: return 1509;
			case Fire::Fire(2, true, true, false, false, true).ID: return 1510;
			case Fire::Fire(2, true, true, false, false, false).ID: return 1511;
			case Fire::Fire(2, true, false, true, true, true).ID: return 1512;
			case Fire::Fire(2, true, false, true, true, false).ID: return 1513;
			case Fire::Fire(2, true, false, true, false, true).ID: return 1514;
			case Fire::Fire(2, true, false, true, false, false).ID: return 1515;
			case Fire::Fire(2, true, false, false, true, true).ID: return 1516;
			case Fire::Fire(2, true, false, false, true, false).ID: return 1517;
			case Fire::Fire(2, true, false, false, false, true).ID: return 1518;
			case Fire::Fire(2, true, false, false, false, false).ID: return 1519;
			case Fire::Fire(2, false, true, true, true, true).ID: return 1520;
			case Fire::Fire(2, false, true, true, true, false).ID: return 1521;
			case Fire::Fire(2, false, true, true, false, true).ID: return 1522;
			case Fire::Fire(2, false, true, true, false, false).ID: return 1523;
			case Fire::Fire(2, false, true, false, true, true).ID: return 1524;
			case Fire::Fire(2, false, true, false, true, false).ID: return 1525;
			case Fire::Fire(2, false, true, false, false, true).ID: return 1526;
			case Fire::Fire(2, false, true, false, false, false).ID: return 1527;
			case Fire::Fire(2, false, false, true, true, true).ID: return 1528;
			case Fire::Fire(2, false, false, true, true, false).ID: return 1529;
			case Fire::Fire(2, false, false, true, false, true).ID: return 1530;
			case Fire::Fire(2, false, false, true, false, false).ID: return 1531;
			case Fire::Fire(2, false, false, false, true, true).ID: return 1532;
			case Fire::Fire(2, false, false, false, true, false).ID: return 1533;
			case Fire::Fire(2, false, false, false, false, true).ID: return 1534;
			case Fire::Fire(2, false, false, false, false, false).ID: return 1535;
			case Fire::Fire(3, true, true, true, true, true).ID: return 1536;
			case Fire::Fire(3, true, true, true, true, false).ID: return 1537;
			case Fire::Fire(3, true, true, true, false, true).ID: return 1538;
			case Fire::Fire(3, true, true, true, false, false).ID: return 1539;
			case Fire::Fire(3, true, true, false, true, true).ID: return 1540;
			case Fire::Fire(3, true, true, false, true, false).ID: return 1541;
			case Fire::Fire(3, true, true, false, false, true).ID: return 1542;
			case Fire::Fire(3, true, true, false, false, false).ID: return 1543;
			case Fire::Fire(3, true, false, true, true, true).ID: return 1544;
			case Fire::Fire(3, true, false, true, true, false).ID: return 1545;
			case Fire::Fire(3, true, false, true, false, true).ID: return 1546;
			case Fire::Fire(3, true, false, true, false, false).ID: return 1547;
			case Fire::Fire(3, true, false, false, true, true).ID: return 1548;
			case Fire::Fire(3, true, false, false, true, false).ID: return 1549;
			case Fire::Fire(3, true, false, false, false, true).ID: return 1550;
			case Fire::Fire(3, true, false, false, false, false).ID: return 1551;
			case Fire::Fire(3, false, true, true, true, true).ID: return 1552;
			case Fire::Fire(3, false, true, true, true, false).ID: return 1553;
			case Fire::Fire(3, false, true, true, false, true).ID: return 1554;
			case Fire::Fire(3, false, true, true, false, false).ID: return 1555;
			case Fire::Fire(3, false, true, false, true, true).ID: return 1556;
			case Fire::Fire(3, false, true, false, true, false).ID: return 1557;
			case Fire::Fire(3, false, true, false, false, true).ID: return 1558;
			case Fire::Fire(3, false, true, false, false, false).ID: return 1559;
			case Fire::Fire(3, false, false, true, true, true).ID: return 1560;
			case Fire::Fire(3, false, false, true, true, false).ID: return 1561;
			case Fire::Fire(3, false, false, true, false, true).ID: return 1562;
			case Fire::Fire(3, false, false, true, false, false).ID: return 1563;
			case Fire::Fire(3, false, false, false, true, true).ID: return 1564;
			case Fire::Fire(3, false, false, false, true, false).ID: return 1565;
			case Fire::Fire(3, false, false, false, false, true).ID: return 1566;
			case Fire::Fire(3, false, false, false, false, false).ID: return 1567;
			case Fire::Fire(4, true, true, true, true, true).ID: return 1568;
			case Fire::Fire(4, true, true, true, true, false).ID: return 1569;
			case Fire::Fire(4, true, true, true, false, true).ID: return 1570;
			case Fire::Fire(4, true, true, true, false, false).ID: return 1571;
			case Fire::Fire(4, true, true, false, true, true).ID: return 1572;
			case Fire::Fire(4, true, true, false, true, false).ID: return 1573;
			case Fire::Fire(4, true, true, false, false, true).ID: return 1574;
			case Fire::Fire(4, true, true, false, false, false).ID: return 1575;
			case Fire::Fire(4, true, false, true, true, true).ID: return 1576;
			case Fire::Fire(4, true, false, true, true, false).ID: return 1577;
			case Fire::Fire(4, true, false, true, false, true).ID: return 1578;
			case Fire::Fire(4, true, false, true, false, false).ID: return 1579;
			case Fire::Fire(4, true, false, false, true, true).ID: return 1580;
			case Fire::Fire(4, true, false, false, true, false).ID: return 1581;
			case Fire::Fire(4, true, false, false, false, true).ID: return 1582;
			case Fire::Fire(4, true, false, false, false, false).ID: return 1583;
			case Fire::Fire(4, false, true, true, true, true).ID: return 1584;
			case Fire::Fire(4, false, true, true, true, false).ID: return 1585;
			case Fire::Fire(4, false, true, true, false, true).ID: return 1586;
			case Fire::Fire(4, false, true, true, false, false).ID: return 1587;
			case Fire::Fire(4, false, true, false, true, true).ID: return 1588;
			case Fire::Fire(4, false, true, false, true, false).ID: return 1589;
			case Fire::Fire(4, false, true, false, false, true).ID: return 1590;
			case Fire::Fire(4, false, true, false, false, false).ID: return 1591;
			case Fire::Fire(4, false, false, true, true, true).ID: return 1592;
			case Fire::Fire(4, false, false, true, true, false).ID: return 1593;
			case Fire::Fire(4, false, false, true, false, true).ID: return 1594;
			case Fire::Fire(4, false, false, true, false, false).ID: return 1595;
			case Fire::Fire(4, false, false, false, true, true).ID: return 1596;
			case Fire::Fire(4, false, false, false, true, false).ID: return 1597;
			case Fire::Fire(4, false, false, false, false, true).ID: return 1598;
			case Fire::Fire(4, false, false, false, false, false).ID: return 1599;
			case Fire::Fire(5, true, true, true, true, true).ID: return 1600;
			case Fire::Fire(5, true, true, true, true, false).ID: return 1601;
			case Fire::Fire(5, true, true, true, false, true).ID: return 1602;
			case Fire::Fire(5, true, true, true, false, false).ID: return 1603;
			case Fire::Fire(5, true, true, false, true, true).ID: return 1604;
			case Fire::Fire(5, true, true, false, true, false).ID: return 1605;
			case Fire::Fire(5, true, true, false, false, true).ID: return 1606;
			case Fire::Fire(5, true, true, false, false, false).ID: return 1607;
			case Fire::Fire(5, true, false, true, true, true).ID: return 1608;
			case Fire::Fire(5, true, false, true, true, false).ID: return 1609;
			case Fire::Fire(5, true, false, true, false, true).ID: return 1610;
			case Fire::Fire(5, true, false, true, false, false).ID: return 1611;
			case Fire::Fire(5, true, false, false, true, true).ID: return 1612;
			case Fire::Fire(5, true, false, false, true, false).ID: return 1613;
			case Fire::Fire(5, true, false, false, false, true).ID: return 1614;
			case Fire::Fire(5, true, false, false, false, false).ID: return 1615;
			case Fire::Fire(5, false, true, true, true, true).ID: return 1616;
			case Fire::Fire(5, false, true, true, true, false).ID: return 1617;
			case Fire::Fire(5, false, true, true, false, true).ID: return 1618;
			case Fire::Fire(5, false, true, true, false, false).ID: return 1619;
			case Fire::Fire(5, false, true, false, true, true).ID: return 1620;
			case Fire::Fire(5, false, true, false, true, false).ID: return 1621;
			case Fire::Fire(5, false, true, false, false, true).ID: return 1622;
			case Fire::Fire(5, false, true, false, false, false).ID: return 1623;
			case Fire::Fire(5, false, false, true, true, true).ID: return 1624;
			case Fire::Fire(5, false, false, true, true, false).ID: return 1625;
			case Fire::Fire(5, false, false, true, false, true).ID: return 1626;
			case Fire::Fire(5, false, false, true, false, false).ID: return 1627;
			case Fire::Fire(5, false, false, false, true, true).ID: return 1628;
			case Fire::Fire(5, false, false, false, true, false).ID: return 1629;
			case Fire::Fire(5, false, false, false, false, true).ID: return 1630;
			case Fire::Fire(5, false, false, false, false, false).ID: return 1631;
			case Fire::Fire(6, true, true, true, true, true).ID: return 1632;
			case Fire::Fire(6, true, true, true, true, false).ID: return 1633;
			case Fire::Fire(6, true, true, true, false, true).ID: return 1634;
			case Fire::Fire(6, true, true, true, false, false).ID: return 1635;
			case Fire::Fire(6, true, true, false, true, true).ID: return 1636;
			case Fire::Fire(6, true, true, false, true, false).ID: return 1637;
			case Fire::Fire(6, true, true, false, false, true).ID: return 1638;
			case Fire::Fire(6, true, true, false, false, false).ID: return 1639;
			case Fire::Fire(6, true, false, true, true, true).ID: return 1640;
			case Fire::Fire(6, true, false, true, true, false).ID: return 1641;
			case Fire::Fire(6, true, false, true, false, true).ID: return 1642;
			case Fire::Fire(6, true, false, true, false, false).ID: return 1643;
			case Fire::Fire(6, true, false, false, true, true).ID: return 1644;
			case Fire::Fire(6, true, false, false, true, false).ID: return 1645;
			case Fire::Fire(6, true, false, false, false, true).ID: return 1646;
			case Fire::Fire(6, true, false, false, false, false).ID: return 1647;
			case Fire::Fire(6, false, true, true, true, true).ID: return 1648;
			case Fire::Fire(6, false, true, true, true, false).ID: return 1649;
			case Fire::Fire(6, false, true, true, false, true).ID: return 1650;
			case Fire::Fire(6, false, true, true, false, false).ID: return 1651;
			case Fire::Fire(6, false, true, false, true, true).ID: return 1652;
			case Fire::Fire(6, false, true, false, true, false).ID: return 1653;
			case Fire::Fire(6, false, true, false, false, true).ID: return 1654;
			case Fire::Fire(6, false, true, false, false, false).ID: return 1655;
			case Fire::Fire(6, false, false, true, true, true).ID: return 1656;
			case Fire::Fire(6, false, false, true, true, false).ID: return 1657;
			case Fire::Fire(6, false, false, true, false, true).ID: return 1658;
			case Fire::Fire(6, false, false, true, false, false).ID: return 1659;
			case Fire::Fire(6, false, false, false, true, true).ID: return 1660;
			case Fire::Fire(6, false, false, false, true, false).ID: return 1661;
			case Fire::Fire(6, false, false, false, false, true).ID: return 1662;
			case Fire::Fire(6, false, false, false, false, false).ID: return 1663;
			case Fire::Fire(7, true, true, true, true, true).ID: return 1664;
			case Fire::Fire(7, true, true, true, true, false).ID: return 1665;
			case Fire::Fire(7, true, true, true, false, true).ID: return 1666;
			case Fire::Fire(7, true, true, true, false, false).ID: return 1667;
			case Fire::Fire(7, true, true, false, true, true).ID: return 1668;
			case Fire::Fire(7, true, true, false, true, false).ID: return 1669;
			case Fire::Fire(7, true, true, false, false, true).ID: return 1670;
			case Fire::Fire(7, true, true, false, false, false).ID: return 1671;
			case Fire::Fire(7, true, false, true, true, true).ID: return 1672;
			case Fire::Fire(7, true, false, true, true, false).ID: return 1673;
			case Fire::Fire(7, true, false, true, false, true).ID: return 1674;
			case Fire::Fire(7, true, false, true, false, false).ID: return 1675;
			case Fire::Fire(7, true, false, false, true, true).ID: return 1676;
			case Fire::Fire(7, true, false, false, true, false).ID: return 1677;
			case Fire::Fire(7, true, false, false, false, true).ID: return 1678;
			case Fire::Fire(7, true, false, false, false, false).ID: return 1679;
			case Fire::Fire(7, false, true, true, true, true).ID: return 1680;
			case Fire::Fire(7, false, true, true, true, false).ID: return 1681;
			case Fire::Fire(7, false, true, true, false, true).ID: return 1682;
			case Fire::Fire(7, false, true, true, false, false).ID: return 1683;
			case Fire::Fire(7, false, true, false, true, true).ID: return 1684;
			case Fire::Fire(7, false, true, false, true, false).ID: return 1685;
			case Fire::Fire(7, false, true, false, false, true).ID: return 1686;
			case Fire::Fire(7, false, true, false, false, false).ID: return 1687;
			case Fire::Fire(7, false, false, true, true, true).ID: return 1688;
			case Fire::Fire(7, false, false, true, true, false).ID: return 1689;
			case Fire::Fire(7, false, false, true, false, true).ID: return 1690;
			case Fire::Fire(7, false, false, true, false, false).ID: return 1691;
			case Fire::Fire(7, false, false, false, true, true).ID: return 1692;
			case Fire::Fire(7, false, false, false, true, false).ID: return 1693;
			case Fire::Fire(7, false, false, false, false, true).ID: return 1694;
			case Fire::Fire(7, false, false, false, false, false).ID: return 1695;
			case Fire::Fire(8, true, true, true, true, true).ID: return 1696;
			case Fire::Fire(8, true, true, true, true, false).ID: return 1697;
			case Fire::Fire(8, true, true, true, false, true).ID: return 1698;
			case Fire::Fire(8, true, true, true, false, false).ID: return 1699;
			case Fire::Fire(8, true, true, false, true, true).ID: return 1700;
			case Fire::Fire(8, true, true, false, true, false).ID: return 1701;
			case Fire::Fire(8, true, true, false, false, true).ID: return 1702;
			case Fire::Fire(8, true, true, false, false, false).ID: return 1703;
			case Fire::Fire(8, true, false, true, true, true).ID: return 1704;
			case Fire::Fire(8, true, false, true, true, false).ID: return 1705;
			case Fire::Fire(8, true, false, true, false, true).ID: return 1706;
			case Fire::Fire(8, true, false, true, false, false).ID: return 1707;
			case Fire::Fire(8, true, false, false, true, true).ID: return 1708;
			case Fire::Fire(8, true, false, false, true, false).ID: return 1709;
			case Fire::Fire(8, true, false, false, false, true).ID: return 1710;
			case Fire::Fire(8, true, false, false, false, false).ID: return 1711;
			case Fire::Fire(8, false, true, true, true, true).ID: return 1712;
			case Fire::Fire(8, false, true, true, true, false).ID: return 1713;
			case Fire::Fire(8, false, true, true, false, true).ID: return 1714;
			case Fire::Fire(8, false, true, true, false, false).ID: return 1715;
			case Fire::Fire(8, false, true, false, true, true).ID: return 1716;
			case Fire::Fire(8, false, true, false, true, false).ID: return 1717;
			case Fire::Fire(8, false, true, false, false, true).ID: return 1718;
			case Fire::Fire(8, false, true, false, false, false).ID: return 1719;
			case Fire::Fire(8, false, false, true, true, true).ID: return 1720;
			case Fire::Fire(8, false, false, true, true, false).ID: return 1721;
			case Fire::Fire(8, false, false, true, false, true).ID: return 1722;
			case Fire::Fire(8, false, false, true, false, false).ID: return 1723;
			case Fire::Fire(8, false, false, false, true, true).ID: return 1724;
			case Fire::Fire(8, false, false, false, true, false).ID: return 1725;
			case Fire::Fire(8, false, false, false, false, true).ID: return 1726;
			case Fire::Fire(8, false, false, false, false, false).ID: return 1727;
			case Fire::Fire(9, true, true, true, true, true).ID: return 1728;
			case Fire::Fire(9, true, true, true, true, false).ID: return 1729;
			case Fire::Fire(9, true, true, true, false, true).ID: return 1730;
			case Fire::Fire(9, true, true, true, false, false).ID: return 1731;
			case Fire::Fire(9, true, true, false, true, true).ID: return 1732;
			case Fire::Fire(9, true, true, false, true, false).ID: return 1733;
			case Fire::Fire(9, true, true, false, false, true).ID: return 1734;
			case Fire::Fire(9, true, true, false, false, false).ID: return 1735;
			case Fire::Fire(9, true, false, true, true, true).ID: return 1736;
			case Fire::Fire(9, true, false, true, true, false).ID: return 1737;
			case Fire::Fire(9, true, false, true, false, true).ID: return 1738;
			case Fire::Fire(9, true, false, true, false, false).ID: return 1739;
			case Fire::Fire(9, true, false, false, true, true).ID: return 1740;
			case Fire::Fire(9, true, false, false, true, false).ID: return 1741;
			case Fire::Fire(9, true, false, false, false, true).ID: return 1742;
			case Fire::Fire(9, true, false, false, false, false).ID: return 1743;
			case Fire::Fire(9, false, true, true, true, true).ID: return 1744;
			case Fire::Fire(9, false, true, true, true, false).ID: return 1745;
			case Fire::Fire(9, false, true, true, false, true).ID: return 1746;
			case Fire::Fire(9, false, true, true, false, false).ID: return 1747;
			case Fire::Fire(9, false, true, false, true, true).ID: return 1748;
			case Fire::Fire(9, false, true, false, true, false).ID: return 1749;
			case Fire::Fire(9, false, true, false, false, true).ID: return 1750;
			case Fire::Fire(9, false, true, false, false, false).ID: return 1751;
			case Fire::Fire(9, false, false, true, true, true).ID: return 1752;
			case Fire::Fire(9, false, false, true, true, false).ID: return 1753;
			case Fire::Fire(9, false, false, true, false, true).ID: return 1754;
			case Fire::Fire(9, false, false, true, false, false).ID: return 1755;
			case Fire::Fire(9, false, false, false, true, true).ID: return 1756;
			case Fire::Fire(9, false, false, false, true, false).ID: return 1757;
			case Fire::Fire(9, false, false, false, false, true).ID: return 1758;
			case Fire::Fire(9, false, false, false, false, false).ID: return 1759;
			case Fire::Fire(10, true, true, true, true, true).ID: return 1760;
			case Fire::Fire(10, true, true, true, true, false).ID: return 1761;
			case Fire::Fire(10, true, true, true, false, true).ID: return 1762;
			case Fire::Fire(10, true, true, true, false, false).ID: return 1763;
			case Fire::Fire(10, true, true, false, true, true).ID: return 1764;
			case Fire::Fire(10, true, true, false, true, false).ID: return 1765;
			case Fire::Fire(10, true, true, false, false, true).ID: return 1766;
			case Fire::Fire(10, true, true, false, false, false).ID: return 1767;
			case Fire::Fire(10, true, false, true, true, true).ID: return 1768;
			case Fire::Fire(10, true, false, true, true, false).ID: return 1769;
			case Fire::Fire(10, true, false, true, false, true).ID: return 1770;
			case Fire::Fire(10, true, false, true, false, false).ID: return 1771;
			case Fire::Fire(10, true, false, false, true, true).ID: return 1772;
			case Fire::Fire(10, true, false, false, true, false).ID: return 1773;
			case Fire::Fire(10, true, false, false, false, true).ID: return 1774;
			case Fire::Fire(10, true, false, false, false, false).ID: return 1775;
			case Fire::Fire(10, false, true, true, true, true).ID: return 1776;
			case Fire::Fire(10, false, true, true, true, false).ID: return 1777;
			case Fire::Fire(10, false, true, true, false, true).ID: return 1778;
			case Fire::Fire(10, false, true, true, false, false).ID: return 1779;
			case Fire::Fire(10, false, true, false, true, true).ID: return 1780;
			case Fire::Fire(10, false, true, false, true, false).ID: return 1781;
			case Fire::Fire(10, false, true, false, false, true).ID: return 1782;
			case Fire::Fire(10, false, true, false, false, false).ID: return 1783;
			case Fire::Fire(10, false, false, true, true, true).ID: return 1784;
			case Fire::Fire(10, false, false, true, true, false).ID: return 1785;
			case Fire::Fire(10, false, false, true, false, true).ID: return 1786;
			case Fire::Fire(10, false, false, true, false, false).ID: return 1787;
			case Fire::Fire(10, false, false, false, true, true).ID: return 1788;
			case Fire::Fire(10, false, false, false, true, false).ID: return 1789;
			case Fire::Fire(10, false, false, false, false, true).ID: return 1790;
			case Fire::Fire(10, false, false, false, false, false).ID: return 1791;
			case Fire::Fire(11, true, true, true, true, true).ID: return 1792;
			case Fire::Fire(11, true, true, true, true, false).ID: return 1793;
			case Fire::Fire(11, true, true, true, false, true).ID: return 1794;
			case Fire::Fire(11, true, true, true, false, false).ID: return 1795;
			case Fire::Fire(11, true, true, false, true, true).ID: return 1796;
			case Fire::Fire(11, true, true, false, true, false).ID: return 1797;
			case Fire::Fire(11, true, true, false, false, true).ID: return 1798;
			case Fire::Fire(11, true, true, false, false, false).ID: return 1799;
			case Fire::Fire(11, true, false, true, true, true).ID: return 1800;
			case Fire::Fire(11, true, false, true, true, false).ID: return 1801;
			case Fire::Fire(11, true, false, true, false, true).ID: return 1802;
			case Fire::Fire(11, true, false, true, false, false).ID: return 1803;
			case Fire::Fire(11, true, false, false, true, true).ID: return 1804;
			case Fire::Fire(11, true, false, false, true, false).ID: return 1805;
			case Fire::Fire(11, true, false, false, false, true).ID: return 1806;
			case Fire::Fire(11, true, false, false, false, false).ID: return 1807;
			case Fire::Fire(11, false, true, true, true, true).ID: return 1808;
			case Fire::Fire(11, false, true, true, true, false).ID: return 1809;
			case Fire::Fire(11, false, true, true, false, true).ID: return 1810;
			case Fire::Fire(11, false, true, true, false, false).ID: return 1811;
			case Fire::Fire(11, false, true, false, true, true).ID: return 1812;
			case Fire::Fire(11, false, true, false, true, false).ID: return 1813;
			case Fire::Fire(11, false, true, false, false, true).ID: return 1814;
			case Fire::Fire(11, false, true, false, false, false).ID: return 1815;
			case Fire::Fire(11, false, false, true, true, true).ID: return 1816;
			case Fire::Fire(11, false, false, true, true, false).ID: return 1817;
			case Fire::Fire(11, false, false, true, false, true).ID: return 1818;
			case Fire::Fire(11, false, false, true, false, false).ID: return 1819;
			case Fire::Fire(11, false, false, false, true, true).ID: return 1820;
			case Fire::Fire(11, false, false, false, true, false).ID: return 1821;
			case Fire::Fire(11, false, false, false, false, true).ID: return 1822;
			case Fire::Fire(11, false, false, false, false, false).ID: return 1823;
			case Fire::Fire(12, true, true, true, true, true).ID: return 1824;
			case Fire::Fire(12, true, true, true, true, false).ID: return 1825;
			case Fire::Fire(12, true, true, true, false, true).ID: return 1826;
			case Fire::Fire(12, true, true, true, false, false).ID: return 1827;
			case Fire::Fire(12, true, true, false, true, true).ID: return 1828;
			case Fire::Fire(12, true, true, false, true, false).ID: return 1829;
			case Fire::Fire(12, true, true, false, false, true).ID: return 1830;
			case Fire::Fire(12, true, true, false, false, false).ID: return 1831;
			case Fire::Fire(12, true, false, true, true, true).ID: return 1832;
			case Fire::Fire(12, true, false, true, true, false).ID: return 1833;
			case Fire::Fire(12, true, false, true, false, true).ID: return 1834;
			case Fire::Fire(12, true, false, true, false, false).ID: return 1835;
			case Fire::Fire(12, true, false, false, true, true).ID: return 1836;
			case Fire::Fire(12, true, false, false, true, false).ID: return 1837;
			case Fire::Fire(12, true, false, false, false, true).ID: return 1838;
			case Fire::Fire(12, true, false, false, false, false).ID: return 1839;
			case Fire::Fire(12, false, true, true, true, true).ID: return 1840;
			case Fire::Fire(12, false, true, true, true, false).ID: return 1841;
			case Fire::Fire(12, false, true, true, false, true).ID: return 1842;
			case Fire::Fire(12, false, true, true, false, false).ID: return 1843;
			case Fire::Fire(12, false, true, false, true, true).ID: return 1844;
			case Fire::Fire(12, false, true, false, true, false).ID: return 1845;
			case Fire::Fire(12, false, true, false, false, true).ID: return 1846;
			case Fire::Fire(12, false, true, false, false, false).ID: return 1847;
			case Fire::Fire(12, false, false, true, true, true).ID: return 1848;
			case Fire::Fire(12, false, false, true, true, false).ID: return 1849;
			case Fire::Fire(12, false, false, true, false, true).ID: return 1850;
			case Fire::Fire(12, false, false, true, false, false).ID: return 1851;
			case Fire::Fire(12, false, false, false, true, true).ID: return 1852;
			case Fire::Fire(12, false, false, false, true, false).ID: return 1853;
			case Fire::Fire(12, false, false, false, false, true).ID: return 1854;
			case Fire::Fire(12, false, false, false, false, false).ID: return 1855;
			case Fire::Fire(13, true, true, true, true, true).ID: return 1856;
			case Fire::Fire(13, true, true, true, true, false).ID: return 1857;
			case Fire::Fire(13, true, true, true, false, true).ID: return 1858;
			case Fire::Fire(13, true, true, true, false, false).ID: return 1859;
			case Fire::Fire(13, true, true, false, true, true).ID: return 1860;
			case Fire::Fire(13, true, true, false, true, false).ID: return 1861;
			case Fire::Fire(13, true, true, false, false, true).ID: return 1862;
			case Fire::Fire(13, true, true, false, false, false).ID: return 1863;
			case Fire::Fire(13, true, false, true, true, true).ID: return 1864;
			case Fire::Fire(13, true, false, true, true, false).ID: return 1865;
			case Fire::Fire(13, true, false, true, false, true).ID: return 1866;
			case Fire::Fire(13, true, false, true, false, false).ID: return 1867;
			case Fire::Fire(13, true, false, false, true, true).ID: return 1868;
			case Fire::Fire(13, true, false, false, true, false).ID: return 1869;
			case Fire::Fire(13, true, false, false, false, true).ID: return 1870;
			case Fire::Fire(13, true, false, false, false, false).ID: return 1871;
			case Fire::Fire(13, false, true, true, true, true).ID: return 1872;
			case Fire::Fire(13, false, true, true, true, false).ID: return 1873;
			case Fire::Fire(13, false, true, true, false, true).ID: return 1874;
			case Fire::Fire(13, false, true, true, false, false).ID: return 1875;
			case Fire::Fire(13, false, true, false, true, true).ID: return 1876;
			case Fire::Fire(13, false, true, false, true, false).ID: return 1877;
			case Fire::Fire(13, false, true, false, false, true).ID: return 1878;
			case Fire::Fire(13, false, true, false, false, false).ID: return 1879;
			case Fire::Fire(13, false, false, true, true, true).ID: return 1880;
			case Fire::Fire(13, false, false, true, true, false).ID: return 1881;
			case Fire::Fire(13, false, false, true, false, true).ID: return 1882;
			case Fire::Fire(13, false, false, true, false, false).ID: return 1883;
			case Fire::Fire(13, false, false, false, true, true).ID: return 1884;
			case Fire::Fire(13, false, false, false, true, false).ID: return 1885;
			case Fire::Fire(13, false, false, false, false, true).ID: return 1886;
			case Fire::Fire(13, false, false, false, false, false).ID: return 1887;
			case Fire::Fire(14, true, true, true, true, true).ID: return 1888;
			case Fire::Fire(14, true, true, true, true, false).ID: return 1889;
			case Fire::Fire(14, true, true, true, false, true).ID: return 1890;
			case Fire::Fire(14, true, true, true, false, false).ID: return 1891;
			case Fire::Fire(14, true, true, false, true, true).ID: return 1892;
			case Fire::Fire(14, true, true, false, true, false).ID: return 1893;
			case Fire::Fire(14, true, true, false, false, true).ID: return 1894;
			case Fire::Fire(14, true, true, false, false, false).ID: return 1895;
			case Fire::Fire(14, true, false, true, true, true).ID: return 1896;
			case Fire::Fire(14, true, false, true, true, false).ID: return 1897;
			case Fire::Fire(14, true, false, true, false, true).ID: return 1898;
			case Fire::Fire(14, true, false, true, false, false).ID: return 1899;
			case Fire::Fire(14, true, false, false, true, true).ID: return 1900;
			case Fire::Fire(14, true, false, false, true, false).ID: return 1901;
			case Fire::Fire(14, true, false, false, false, true).ID: return 1902;
			case Fire::Fire(14, true, false, false, false, false).ID: return 1903;
			case Fire::Fire(14, false, true, true, true, true).ID: return 1904;
			case Fire::Fire(14, false, true, true, true, false).ID: return 1905;
			case Fire::Fire(14, false, true, true, false, true).ID: return 1906;
			case Fire::Fire(14, false, true, true, false, false).ID: return 1907;
			case Fire::Fire(14, false, true, false, true, true).ID: return 1908;
			case Fire::Fire(14, false, true, false, true, false).ID: return 1909;
			case Fire::Fire(14, false, true, false, false, true).ID: return 1910;
			case Fire::Fire(14, false, true, false, false, false).ID: return 1911;
			case Fire::Fire(14, false, false, true, true, true).ID: return 1912;
			case Fire::Fire(14, false, false, true, true, false).ID: return 1913;
			case Fire::Fire(14, false, false, true, false, true).ID: return 1914;
			case Fire::Fire(14, false, false, true, false, false).ID: return 1915;
			case Fire::Fire(14, false, false, false, true, true).ID: return 1916;
			case Fire::Fire(14, false, false, false, true, false).ID: return 1917;
			case Fire::Fire(14, false, false, false, false, true).ID: return 1918;
			case Fire::Fire(14, false, false, false, false, false).ID: return 1919;
			case Fire::Fire(15, true, true, true, true, true).ID: return 1920;
			case Fire::Fire(15, true, true, true, true, false).ID: return 1921;
			case Fire::Fire(15, true, true, true, false, true).ID: return 1922;
			case Fire::Fire(15, true, true, true, false, false).ID: return 1923;
			case Fire::Fire(15, true, true, false, true, true).ID: return 1924;
			case Fire::Fire(15, true, true, false, true, false).ID: return 1925;
			case Fire::Fire(15, true, true, false, false, true).ID: return 1926;
			case Fire::Fire(15, true, true, false, false, false).ID: return 1927;
			case Fire::Fire(15, true, false, true, true, true).ID: return 1928;
			case Fire::Fire(15, true, false, true, true, false).ID: return 1929;
			case Fire::Fire(15, true, false, true, false, true).ID: return 1930;
			case Fire::Fire(15, true, false, true, false, false).ID: return 1931;
			case Fire::Fire(15, true, false, false, true, true).ID: return 1932;
			case Fire::Fire(15, true, false, false, true, false).ID: return 1933;
			case Fire::Fire(15, true, false, false, false, true).ID: return 1934;
			case Fire::Fire(15, true, false, false, false, false).ID: return 1935;
			case Fire::Fire(15, false, true, true, true, true).ID: return 1936;
			case Fire::Fire(15, false, true, true, true, false).ID: return 1937;
			case Fire::Fire(15, false, true, true, false, true).ID: return 1938;
			case Fire::Fire(15, false, true, true, false, false).ID: return 1939;
			case Fire::Fire(15, false, true, false, true, true).ID: return 1940;
			case Fire::Fire(15, false, true, false, true, false).ID: return 1941;
			case Fire::Fire(15, false, true, false, false, true).ID: return 1942;
			case Fire::Fire(15, false, true, false, false, false).ID: return 1943;
			case Fire::Fire(15, false, false, true, true, true).ID: return 1944;
			case Fire::Fire(15, false, false, true, true, false).ID: return 1945;
			case Fire::Fire(15, false, false, true, false, true).ID: return 1946;
			case Fire::Fire(15, false, false, true, false, false).ID: return 1947;
			case Fire::Fire(15, false, false, false, true, true).ID: return 1948;
			case Fire::Fire(15, false, false, false, true, false).ID: return 1949;
			case Fire::Fire(15, false, false, false, false, true).ID: return 1950;
			case Fire::Fire(15, false, false, false, false, false).ID: return 1951;
			case FireCoral::FireCoral().ID: return 9537;
			case FireCoralBlock::FireCoralBlock().ID: return 9518;
			case FireCoralFan::FireCoralFan().ID: return 9557;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9625;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9627;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9629;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9631;
			case FletchingTable::FletchingTable().ID: return 14820;
			case FlowerPot::FlowerPot().ID: return 6305;
			case FrostedIce::FrostedIce(0).ID: return 9249;
			case FrostedIce::FrostedIce(1).ID: return 9250;
			case FrostedIce::FrostedIce(2).ID: return 9251;
			case FrostedIce::FrostedIce(3).ID: return 9252;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZM, true).ID: return 3373;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZM, false).ID: return 3374;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZP, true).ID: return 3375;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZP, false).ID: return 3376;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XM, true).ID: return 3377;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XM, false).ID: return 3378;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XP, true).ID: return 3379;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XP, false).ID: return 3380;
			case GildedBlackstone::GildedBlackstone().ID: return 16664;
			case Glass::Glass().ID: return 231;
			case GlassPane::GlassPane(true, true, true, true).ID: return 4733;
			case GlassPane::GlassPane(true, true, true, false).ID: return 4734;
			case GlassPane::GlassPane(true, true, false, true).ID: return 4737;
			case GlassPane::GlassPane(true, true, false, false).ID: return 4738;
			case GlassPane::GlassPane(true, false, true, true).ID: return 4741;
			case GlassPane::GlassPane(true, false, true, false).ID: return 4742;
			case GlassPane::GlassPane(true, false, false, true).ID: return 4745;
			case GlassPane::GlassPane(true, false, false, false).ID: return 4746;
			case GlassPane::GlassPane(false, true, true, true).ID: return 4749;
			case GlassPane::GlassPane(false, true, true, false).ID: return 4750;
			case GlassPane::GlassPane(false, true, false, true).ID: return 4753;
			case GlassPane::GlassPane(false, true, false, false).ID: return 4754;
			case GlassPane::GlassPane(false, false, true, true).ID: return 4757;
			case GlassPane::GlassPane(false, false, true, false).ID: return 4758;
			case GlassPane::GlassPane(false, false, false, true).ID: return 4761;
			case GlassPane::GlassPane(false, false, false, false).ID: return 4762;
			case Glowstone::Glowstone().ID: return 4013;
			case GoldBlock::GoldBlock().ID: return 1427;
			case GoldOre::GoldOre().ID: return 69;
			case Granite::Granite().ID: return 2;
			case GraniteSlab::GraniteSlab(GraniteSlab::Type::Top).ID: return 10838;
			case GraniteSlab::GraniteSlab(GraniteSlab::Type::Bottom).ID: return 10840;
			case GraniteSlab::GraniteSlab(GraniteSlab::Type::Double).ID: return 10842;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 10390;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 10392;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 10394;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 10396;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 10398;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 10400;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 10402;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 10404;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 10406;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 10408;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 10410;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 10412;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 10414;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 10416;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 10418;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 10420;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 10422;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 10424;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 10426;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 10428;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 10430;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 10432;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 10434;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 10436;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 10438;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 10440;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 10442;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 10444;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 10446;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 10448;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 10450;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 10452;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 10454;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 10456;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 10458;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 10460;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 10462;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 10464;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 10466;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 10468;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12166;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12167;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12168;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12172;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12173;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12174;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12178;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12179;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12180;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12184;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12185;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12186;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12190;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12191;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12192;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12196;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12197;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12198;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12202;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12203;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12204;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12208;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12209;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12210;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12214;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12215;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12216;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12220;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12221;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12222;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12226;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12227;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12228;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12232;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12233;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12234;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12238;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12239;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12240;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12244;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12245;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12246;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12250;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12251;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12252;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12256;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12257;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12258;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12262;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12263;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12264;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12268;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12269;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12270;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12274;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12275;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12276;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12280;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12281;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12282;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12286;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12287;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12288;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12292;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12293;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12294;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12298;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12299;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12300;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12304;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12305;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12306;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12310;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12311;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12312;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12316;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12317;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12318;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12322;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12323;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12324;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12328;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12329;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12330;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12334;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12335;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12336;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12340;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12341;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12342;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12346;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12347;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12348;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12352;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12353;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12354;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12358;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12359;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12360;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12364;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12365;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12366;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12370;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12371;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12372;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12376;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12377;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12378;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12382;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12383;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12384;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12388;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12389;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12390;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12394;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12395;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12396;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12400;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12401;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12402;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12406;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12407;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12408;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12412;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12413;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::None, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12414;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12418;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12419;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12420;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12424;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12425;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12426;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12430;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12431;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12432;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12436;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12437;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12438;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12442;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12443;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12444;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12448;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12449;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Low, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12450;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 12454;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 12455;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::None, true, GraniteWall::West::Tall).ID: return 12456;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 12460;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 12461;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::None, false, GraniteWall::West::Tall).ID: return 12462;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 12466;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 12467;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Low, true, GraniteWall::West::Tall).ID: return 12468;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 12472;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 12473;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Low, false, GraniteWall::West::Tall).ID: return 12474;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::None).ID: return 12478;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::Low).ID: return 12479;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Tall, true, GraniteWall::West::Tall).ID: return 12480;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::None).ID: return 12484;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::Low).ID: return 12485;
			case GraniteWall::GraniteWall(GraniteWall::East::Tall, GraniteWall::North::Tall, GraniteWall::South::Tall, false, GraniteWall::West::Tall).ID: return 12486;
			case Grass::Grass().ID: return 1342;
			case GrassBlock::GrassBlock(true).ID: return 8;
			case GrassBlock::GrassBlock(false).ID: return 9;
			case GrassPath::GrassPath().ID: return 9223;
			case Gravel::Gravel().ID: return 68;
			case GrayBanner::GrayBanner(0).ID: return 8009;
			case GrayBanner::GrayBanner(1).ID: return 8010;
			case GrayBanner::GrayBanner(2).ID: return 8011;
			case GrayBanner::GrayBanner(3).ID: return 8012;
			case GrayBanner::GrayBanner(4).ID: return 8013;
			case GrayBanner::GrayBanner(5).ID: return 8014;
			case GrayBanner::GrayBanner(6).ID: return 8015;
			case GrayBanner::GrayBanner(7).ID: return 8016;
			case GrayBanner::GrayBanner(8).ID: return 8017;
			case GrayBanner::GrayBanner(9).ID: return 8018;
			case GrayBanner::GrayBanner(10).ID: return 8019;
			case GrayBanner::GrayBanner(11).ID: return 8020;
			case GrayBanner::GrayBanner(12).ID: return 8021;
			case GrayBanner::GrayBanner(13).ID: return 8022;
			case GrayBanner::GrayBanner(14).ID: return 8023;
			case GrayBanner::GrayBanner(15).ID: return 8024;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, true, GrayBed::Part::Head).ID: return 1161;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, true, GrayBed::Part::Foot).ID: return 1162;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, false, GrayBed::Part::Head).ID: return 1163;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, false, GrayBed::Part::Foot).ID: return 1164;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, true, GrayBed::Part::Head).ID: return 1165;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, true, GrayBed::Part::Foot).ID: return 1166;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, false, GrayBed::Part::Head).ID: return 1167;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, false, GrayBed::Part::Foot).ID: return 1168;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, true, GrayBed::Part::Head).ID: return 1169;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, true, GrayBed::Part::Foot).ID: return 1170;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, false, GrayBed::Part::Head).ID: return 1171;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, false, GrayBed::Part::Foot).ID: return 1172;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, true, GrayBed::Part::Head).ID: return 1173;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, true, GrayBed::Part::Foot).ID: return 1174;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, false, GrayBed::Part::Head).ID: return 1175;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, false, GrayBed::Part::Foot).ID: return 1176;
			case GrayCarpet::GrayCarpet().ID: return 7873;
			case GrayConcrete::GrayConcrete().ID: return 9445;
			case GrayConcretePowder::GrayConcretePowder().ID: return 9461;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9402;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9403;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9404;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9405;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9320;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9321;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9322;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9323;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9324;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9325;
			case GrayStainedGlass::GrayStainedGlass().ID: return 4102;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, true, true).ID: return 7089;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, true, false).ID: return 7090;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, false, true).ID: return 7093;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, false, false).ID: return 7094;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, true, true).ID: return 7097;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, true, false).ID: return 7098;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, false, true).ID: return 7101;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, false, false).ID: return 7102;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, true, true).ID: return 7105;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, true, false).ID: return 7106;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, false, true).ID: return 7109;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, false, false).ID: return 7110;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, true, true).ID: return 7113;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, true, false).ID: return 7114;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, false, true).ID: return 7117;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, false, false).ID: return 7118;
			case GrayTerracotta::GrayTerracotta().ID: return 6854;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8181;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8182;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8183;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8184;
			case GrayWool::GrayWool().ID: return 1391;
			case GreenBanner::GreenBanner(0).ID: return 8105;
			case GreenBanner::GreenBanner(1).ID: return 8106;
			case GreenBanner::GreenBanner(2).ID: return 8107;
			case GreenBanner::GreenBanner(3).ID: return 8108;
			case GreenBanner::GreenBanner(4).ID: return 8109;
			case GreenBanner::GreenBanner(5).ID: return 8110;
			case GreenBanner::GreenBanner(6).ID: return 8111;
			case GreenBanner::GreenBanner(7).ID: return 8112;
			case GreenBanner::GreenBanner(8).ID: return 8113;
			case GreenBanner::GreenBanner(9).ID: return 8114;
			case GreenBanner::GreenBanner(10).ID: return 8115;
			case GreenBanner::GreenBanner(11).ID: return 8116;
			case GreenBanner::GreenBanner(12).ID: return 8117;
			case GreenBanner::GreenBanner(13).ID: return 8118;
			case GreenBanner::GreenBanner(14).ID: return 8119;
			case GreenBanner::GreenBanner(15).ID: return 8120;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, true, GreenBed::Part::Head).ID: return 1257;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, true, GreenBed::Part::Foot).ID: return 1258;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, false, GreenBed::Part::Head).ID: return 1259;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, false, GreenBed::Part::Foot).ID: return 1260;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, true, GreenBed::Part::Head).ID: return 1261;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, true, GreenBed::Part::Foot).ID: return 1262;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, false, GreenBed::Part::Head).ID: return 1263;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, false, GreenBed::Part::Foot).ID: return 1264;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, true, GreenBed::Part::Head).ID: return 1265;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, true, GreenBed::Part::Foot).ID: return 1266;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, false, GreenBed::Part::Head).ID: return 1267;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, false, GreenBed::Part::Foot).ID: return 1268;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, true, GreenBed::Part::Head).ID: return 1269;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, true, GreenBed::Part::Foot).ID: return 1270;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, false, GreenBed::Part::Head).ID: return 1271;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, false, GreenBed::Part::Foot).ID: return 1272;
			case GreenCarpet::GreenCarpet().ID: return 7879;
			case GreenConcrete::GreenConcrete().ID: return 9451;
			case GreenConcretePowder::GreenConcretePowder().ID: return 9467;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9426;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9427;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9428;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9429;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9356;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9357;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9358;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9359;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9360;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9361;
			case GreenStainedGlass::GreenStainedGlass().ID: return 4108;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, true, true).ID: return 7281;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, true, false).ID: return 7282;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, false, true).ID: return 7285;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, false, false).ID: return 7286;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, true, true).ID: return 7289;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, true, false).ID: return 7290;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, false, true).ID: return 7293;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, false, false).ID: return 7294;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, true, true).ID: return 7297;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, true, false).ID: return 7298;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, false, true).ID: return 7301;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, false, false).ID: return 7302;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, true, true).ID: return 7305;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, true, false).ID: return 7306;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, false, true).ID: return 7309;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, false, false).ID: return 7310;
			case GreenTerracotta::GreenTerracotta().ID: return 6860;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8205;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8206;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8207;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8208;
			case GreenWool::GreenWool().ID: return 1397;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_ZM).ID: return 14821;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_ZP).ID: return 14822;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_XM).ID: return 14823;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_XP).ID: return 14824;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_ZM).ID: return 14825;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_ZP).ID: return 14826;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_XM).ID: return 14827;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_XP).ID: return 14828;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM).ID: return 14829;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP).ID: return 14830;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_XM).ID: return 14831;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_XP).ID: return 14832;
			case HayBale::HayBale(HayBale::Axis::X).ID: return 7863;
			case HayBale::HayBale(HayBale::Axis::Y).ID: return 7864;
			case HayBale::HayBale(HayBale::Axis::Z).ID: return 7865;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(0).ID: return 6662;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(1).ID: return 6663;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(2).ID: return 6664;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(3).ID: return 6665;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(4).ID: return 6666;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(5).ID: return 6667;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(6).ID: return 6668;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(7).ID: return 6669;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(8).ID: return 6670;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(9).ID: return 6671;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(10).ID: return 6672;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(11).ID: return 6673;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(12).ID: return 6674;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(13).ID: return 6675;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(14).ID: return 6676;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(15).ID: return 6677;
			case HoneyBlock::HoneyBlock().ID: return 15824;
			case HoneycombBlock::HoneycombBlock().ID: return 15825;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_YM).ID: return 6728;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_ZM).ID: return 6729;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_ZP).ID: return 6730;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_XM).ID: return 6731;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_XP).ID: return 6732;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_YM).ID: return 6733;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_ZM).ID: return 6734;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_ZP).ID: return 6735;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_XM).ID: return 6736;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_XP).ID: return 6737;
			case HornCoral::HornCoral().ID: return 9539;
			case HornCoralBlock::HornCoralBlock().ID: return 9519;
			case HornCoralFan::HornCoralFan().ID: return 9559;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9633;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9635;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9637;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9639;
			case Ice::Ice().ID: return 3929;
			case InfestedChiseledStoneBricks::InfestedChiseledStoneBricks().ID: return 4504;
			case InfestedCobblestone::InfestedCobblestone().ID: return 4500;
			case InfestedCrackedStoneBricks::InfestedCrackedStoneBricks().ID: return 4503;
			case InfestedMossyStoneBricks::InfestedMossyStoneBricks().ID: return 4502;
			case InfestedStone::InfestedStone().ID: return 4499;
			case InfestedStoneBricks::InfestedStoneBricks().ID: return 4501;
			case IronBars::IronBars(true, true, true, true).ID: return 4699;
			case IronBars::IronBars(true, true, true, false).ID: return 4700;
			case IronBars::IronBars(true, true, false, true).ID: return 4703;
			case IronBars::IronBars(true, true, false, false).ID: return 4704;
			case IronBars::IronBars(true, false, true, true).ID: return 4707;
			case IronBars::IronBars(true, false, true, false).ID: return 4708;
			case IronBars::IronBars(true, false, false, true).ID: return 4711;
			case IronBars::IronBars(true, false, false, false).ID: return 4712;
			case IronBars::IronBars(false, true, true, true).ID: return 4715;
			case IronBars::IronBars(false, true, true, false).ID: return 4716;
			case IronBars::IronBars(false, true, false, true).ID: return 4719;
			case IronBars::IronBars(false, true, false, false).ID: return 4720;
			case IronBars::IronBars(false, false, true, true).ID: return 4723;
			case IronBars::IronBars(false, false, true, false).ID: return 4724;
			case IronBars::IronBars(false, false, false, true).ID: return 4727;
			case IronBars::IronBars(false, false, false, false).ID: return 4728;
			case IronBlock::IronBlock().ID: return 1428;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3809;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3810;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3811;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3812;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3813;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3814;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3815;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3816;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3817;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3818;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3819;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3820;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3821;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3822;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3823;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3824;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3825;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3826;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3827;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3828;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3829;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3830;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3831;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3832;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3833;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3834;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3835;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3836;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3837;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3838;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3839;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3840;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3841;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3842;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3843;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3844;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3845;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3846;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3847;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3848;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3849;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3850;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3851;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3852;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3853;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3854;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3855;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3856;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3857;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3858;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3859;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3860;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3861;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3862;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3863;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3864;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3865;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3866;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3867;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3868;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3869;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3870;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3871;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3872;
			case IronOre::IronOre().ID: return 70;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, true, true).ID: return 7538;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, true, false).ID: return 7540;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, false, true).ID: return 7542;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, false, false).ID: return 7544;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, true, true).ID: return 7546;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, true, false).ID: return 7548;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, false, true).ID: return 7550;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, false, false).ID: return 7552;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, true, true).ID: return 7554;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, true, false).ID: return 7556;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, false, true).ID: return 7558;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, false, false).ID: return 7560;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, true, true).ID: return 7562;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, true, false).ID: return 7564;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, false, true).ID: return 7566;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, false, false).ID: return 7568;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, true, true).ID: return 7570;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, true, false).ID: return 7572;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, false, true).ID: return 7574;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, false, false).ID: return 7576;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, true, true).ID: return 7578;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, true, false).ID: return 7580;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, false, true).ID: return 7582;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, false, false).ID: return 7584;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, true, true).ID: return 7586;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, true, false).ID: return 7588;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, false, true).ID: return 7590;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, false, false).ID: return 7592;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, true, true).ID: return 7594;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, true, false).ID: return 7596;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, false, true).ID: return 7598;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, false, false).ID: return 7600;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_ZM).ID: return 4020;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_ZP).ID: return 4021;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_XM).ID: return 4022;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_XP).ID: return 4023;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::DownEast).ID: return 15739;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::DownNorth).ID: return 15740;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::DownSouth).ID: return 15741;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::DownWest).ID: return 15742;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::UpEast).ID: return 15743;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::UpNorth).ID: return 15744;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::UpSouth).ID: return 15745;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::UpWest).ID: return 15746;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::WestUp).ID: return 15747;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::EastUp).ID: return 15748;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::NorthUp).ID: return 15749;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::SouthUp).ID: return 15750;
			case Jukebox::Jukebox(true).ID: return 3964;
			case Jukebox::Jukebox(false).ID: return 3965;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6418;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6419;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6420;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6421;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 6422;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 6423;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 6424;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 6425;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6426;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6427;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6428;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6429;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 6430;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 6431;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 6432;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 6433;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6434;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6435;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6436;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6437;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 6438;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 6439;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 6440;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 6441;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8866;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8867;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8868;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8869;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8870;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8871;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8872;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8873;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8874;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8875;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8876;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8877;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8878;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8879;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8880;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8881;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8882;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8883;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8884;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8885;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8886;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8887;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8888;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8889;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8890;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8891;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8892;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8893;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8894;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8895;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8896;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8897;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8898;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8899;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8900;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8901;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8902;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8903;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8904;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8905;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8906;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8907;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8908;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8909;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8910;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8911;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8912;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8913;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8914;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8915;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8916;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8917;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8918;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8919;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8920;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8921;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8922;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8923;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8924;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8925;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8926;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8927;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8928;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8929;
			case JungleFence::JungleFence(true, true, true, true).ID: return 8644;
			case JungleFence::JungleFence(true, true, true, false).ID: return 8645;
			case JungleFence::JungleFence(true, true, false, true).ID: return 8648;
			case JungleFence::JungleFence(true, true, false, false).ID: return 8649;
			case JungleFence::JungleFence(true, false, true, true).ID: return 8652;
			case JungleFence::JungleFence(true, false, true, false).ID: return 8653;
			case JungleFence::JungleFence(true, false, false, true).ID: return 8656;
			case JungleFence::JungleFence(true, false, false, false).ID: return 8657;
			case JungleFence::JungleFence(false, true, true, true).ID: return 8660;
			case JungleFence::JungleFence(false, true, true, false).ID: return 8661;
			case JungleFence::JungleFence(false, true, false, true).ID: return 8664;
			case JungleFence::JungleFence(false, true, false, false).ID: return 8665;
			case JungleFence::JungleFence(false, false, true, true).ID: return 8668;
			case JungleFence::JungleFence(false, false, true, false).ID: return 8669;
			case JungleFence::JungleFence(false, false, false, true).ID: return 8672;
			case JungleFence::JungleFence(false, false, false, false).ID: return 8673;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 8482;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 8483;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 8484;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 8485;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 8486;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 8487;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 8488;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 8489;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 8490;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 8491;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 8492;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 8493;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 8494;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 8495;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 8496;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 8497;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 8498;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 8499;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 8500;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 8501;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 8502;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 8503;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 8504;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 8505;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 8506;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 8507;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 8508;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 8509;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 8510;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 8511;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 8512;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 8513;
			case JungleLeaves::JungleLeaves(1, true).ID: return 187;
			case JungleLeaves::JungleLeaves(1, false).ID: return 188;
			case JungleLeaves::JungleLeaves(2, true).ID: return 189;
			case JungleLeaves::JungleLeaves(2, false).ID: return 190;
			case JungleLeaves::JungleLeaves(3, true).ID: return 191;
			case JungleLeaves::JungleLeaves(3, false).ID: return 192;
			case JungleLeaves::JungleLeaves(4, true).ID: return 193;
			case JungleLeaves::JungleLeaves(4, false).ID: return 194;
			case JungleLeaves::JungleLeaves(5, true).ID: return 195;
			case JungleLeaves::JungleLeaves(5, false).ID: return 196;
			case JungleLeaves::JungleLeaves(6, true).ID: return 197;
			case JungleLeaves::JungleLeaves(6, false).ID: return 198;
			case JungleLeaves::JungleLeaves(7, true).ID: return 199;
			case JungleLeaves::JungleLeaves(7, false).ID: return 200;
			case JungleLog::JungleLog(JungleLog::Axis::X).ID: return 82;
			case JungleLog::JungleLog(JungleLog::Axis::Y).ID: return 83;
			case JungleLog::JungleLog(JungleLog::Axis::Z).ID: return 84;
			case JunglePlanks::JunglePlanks().ID: return 18;
			case JunglePressurePlate::JunglePressurePlate(true).ID: return 3879;
			case JunglePressurePlate::JunglePressurePlate(false).ID: return 3880;
			case JungleSapling::JungleSapling(0).ID: return 27;
			case JungleSapling::JungleSapling(1).ID: return 28;
			case JungleSign::JungleSign(0).ID: return 3510;
			case JungleSign::JungleSign(1).ID: return 3512;
			case JungleSign::JungleSign(2).ID: return 3514;
			case JungleSign::JungleSign(3).ID: return 3516;
			case JungleSign::JungleSign(4).ID: return 3518;
			case JungleSign::JungleSign(5).ID: return 3520;
			case JungleSign::JungleSign(6).ID: return 3522;
			case JungleSign::JungleSign(7).ID: return 3524;
			case JungleSign::JungleSign(8).ID: return 3526;
			case JungleSign::JungleSign(9).ID: return 3528;
			case JungleSign::JungleSign(10).ID: return 3530;
			case JungleSign::JungleSign(11).ID: return 3532;
			case JungleSign::JungleSign(12).ID: return 3534;
			case JungleSign::JungleSign(13).ID: return 3536;
			case JungleSign::JungleSign(14).ID: return 3538;
			case JungleSign::JungleSign(15).ID: return 3540;
			case JungleSlab::JungleSlab(JungleSlab::Type::Top).ID: return 8319;
			case JungleSlab::JungleSlab(JungleSlab::Type::Bottom).ID: return 8321;
			case JungleSlab::JungleSlab(JungleSlab::Type::Double).ID: return 8323;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5565;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5567;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5569;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5571;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5573;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5575;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5577;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5579;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5581;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5583;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5585;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5587;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5589;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5591;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5593;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5595;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5597;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5599;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5601;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5603;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5605;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5607;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5609;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5611;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5613;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5615;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5617;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5619;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5621;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5623;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5625;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5627;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5629;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5631;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5633;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5635;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5637;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5639;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5641;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5643;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, true, true).ID: return 4304;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, true, false).ID: return 4306;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, false, true).ID: return 4308;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, false, false).ID: return 4310;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, true, true).ID: return 4312;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, true, false).ID: return 4314;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, false, true).ID: return 4316;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, false, false).ID: return 4318;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, true, true).ID: return 4320;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, true, false).ID: return 4322;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, false, true).ID: return 4324;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, false, false).ID: return 4326;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, true, true).ID: return 4328;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, true, false).ID: return 4330;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, false, true).ID: return 4332;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, false, false).ID: return 4334;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, true, true).ID: return 4336;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, true, false).ID: return 4338;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, false, true).ID: return 4340;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, false, false).ID: return 4342;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, true, true).ID: return 4344;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, true, false).ID: return 4346;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, false, true).ID: return 4348;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, false, false).ID: return 4350;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, true, true).ID: return 4352;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, true, false).ID: return 4354;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, false, true).ID: return 4356;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, false, false).ID: return 4358;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, true, true).ID: return 4360;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, true, false).ID: return 4362;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, false, true).ID: return 4364;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, false, false).ID: return 4366;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3768;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3770;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3772;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3774;
			case JungleWood::JungleWood(JungleWood::Axis::X).ID: return 118;
			case JungleWood::JungleWood(JungleWood::Axis::Y).ID: return 119;
			case JungleWood::JungleWood(JungleWood::Axis::Z).ID: return 120;
			case Kelp::Kelp(0).ID: return 9470;
			case Kelp::Kelp(1).ID: return 9471;
			case Kelp::Kelp(2).ID: return 9472;
			case Kelp::Kelp(3).ID: return 9473;
			case Kelp::Kelp(4).ID: return 9474;
			case Kelp::Kelp(5).ID: return 9475;
			case Kelp::Kelp(6).ID: return 9476;
			case Kelp::Kelp(7).ID: return 9477;
			case Kelp::Kelp(8).ID: return 9478;
			case Kelp::Kelp(9).ID: return 9479;
			case Kelp::Kelp(10).ID: return 9480;
			case Kelp::Kelp(11).ID: return 9481;
			case Kelp::Kelp(12).ID: return 9482;
			case Kelp::Kelp(13).ID: return 9483;
			case Kelp::Kelp(14).ID: return 9484;
			case Kelp::Kelp(15).ID: return 9485;
			case Kelp::Kelp(16).ID: return 9486;
			case Kelp::Kelp(17).ID: return 9487;
			case Kelp::Kelp(18).ID: return 9488;
			case Kelp::Kelp(19).ID: return 9489;
			case Kelp::Kelp(20).ID: return 9490;
			case Kelp::Kelp(21).ID: return 9491;
			case Kelp::Kelp(22).ID: return 9492;
			case Kelp::Kelp(23).ID: return 9493;
			case Kelp::Kelp(24).ID: return 9494;
			case Kelp::Kelp(25).ID: return 9495;
			case KelpPlant::KelpPlant().ID: return 9496;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_ZM).ID: return 3638;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_ZP).ID: return 3640;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_XM).ID: return 3642;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_XP).ID: return 3644;
			case Lantern::Lantern(true).ID: return 14886;
			case Lantern::Lantern(false).ID: return 14887;
			case LapisBlock::LapisBlock().ID: return 233;
			case LapisOre::LapisOre().ID: return 232;
			case LargeFern::LargeFern(LargeFern::Half::Upper).ID: return 7895;
			case LargeFern::LargeFern(LargeFern::Half::Lower).ID: return 7896;
			case Lava::Lava(0).ID: return 50;
			case Lava::Lava(1).ID: return 51;
			case Lava::Lava(2).ID: return 52;
			case Lava::Lava(3).ID: return 53;
			case Lava::Lava(4).ID: return 54;
			case Lava::Lava(5).ID: return 55;
			case Lava::Lava(6).ID: return 56;
			case Lava::Lava(7).ID: return 57;
			case Lava::Lava(8).ID: return 58;
			case Lava::Lava(9).ID: return 59;
			case Lava::Lava(10).ID: return 60;
			case Lava::Lava(11).ID: return 61;
			case Lava::Lava(12).ID: return 62;
			case Lava::Lava(13).ID: return 63;
			case Lava::Lava(14).ID: return 64;
			case Lava::Lava(15).ID: return 65;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 14833;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 14834;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 14835;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 14836;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 14837;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 14838;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 14839;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 14840;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, true, true).ID: return 14841;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, true, false).ID: return 14842;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, false, true).ID: return 14843;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, false, false).ID: return 14844;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, true, true).ID: return 14845;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, true, false).ID: return 14846;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, false, true).ID: return 14847;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, false, false).ID: return 14848;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3783;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3784;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3785;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3786;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 3787;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 3788;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 3789;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 3790;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3791;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3792;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3793;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3794;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 3795;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 3796;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 3797;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 3798;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3799;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3800;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3801;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3802;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 3803;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 3804;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 3805;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 3806;
			case LightBlueBanner::LightBlueBanner(0).ID: return 7945;
			case LightBlueBanner::LightBlueBanner(1).ID: return 7946;
			case LightBlueBanner::LightBlueBanner(2).ID: return 7947;
			case LightBlueBanner::LightBlueBanner(3).ID: return 7948;
			case LightBlueBanner::LightBlueBanner(4).ID: return 7949;
			case LightBlueBanner::LightBlueBanner(5).ID: return 7950;
			case LightBlueBanner::LightBlueBanner(6).ID: return 7951;
			case LightBlueBanner::LightBlueBanner(7).ID: return 7952;
			case LightBlueBanner::LightBlueBanner(8).ID: return 7953;
			case LightBlueBanner::LightBlueBanner(9).ID: return 7954;
			case LightBlueBanner::LightBlueBanner(10).ID: return 7955;
			case LightBlueBanner::LightBlueBanner(11).ID: return 7956;
			case LightBlueBanner::LightBlueBanner(12).ID: return 7957;
			case LightBlueBanner::LightBlueBanner(13).ID: return 7958;
			case LightBlueBanner::LightBlueBanner(14).ID: return 7959;
			case LightBlueBanner::LightBlueBanner(15).ID: return 7960;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, true, LightBlueBed::Part::Head).ID: return 1097;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, true, LightBlueBed::Part::Foot).ID: return 1098;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, false, LightBlueBed::Part::Head).ID: return 1099;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, false, LightBlueBed::Part::Foot).ID: return 1100;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, true, LightBlueBed::Part::Head).ID: return 1101;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, true, LightBlueBed::Part::Foot).ID: return 1102;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, false, LightBlueBed::Part::Head).ID: return 1103;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, false, LightBlueBed::Part::Foot).ID: return 1104;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, true, LightBlueBed::Part::Head).ID: return 1105;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, true, LightBlueBed::Part::Foot).ID: return 1106;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, false, LightBlueBed::Part::Head).ID: return 1107;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, false, LightBlueBed::Part::Foot).ID: return 1108;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, true, LightBlueBed::Part::Head).ID: return 1109;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, true, LightBlueBed::Part::Foot).ID: return 1110;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, false, LightBlueBed::Part::Head).ID: return 1111;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, false, LightBlueBed::Part::Foot).ID: return 1112;
			case LightBlueCarpet::LightBlueCarpet().ID: return 7869;
			case LightBlueConcrete::LightBlueConcrete().ID: return 9441;
			case LightBlueConcretePowder::LightBlueConcretePowder().ID: return 9457;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9386;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9387;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9388;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9389;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9296;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9297;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9298;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9299;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9300;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9301;
			case LightBlueStainedGlass::LightBlueStainedGlass().ID: return 4098;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, true, true).ID: return 6961;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, true, false).ID: return 6962;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, false, true).ID: return 6965;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, false, false).ID: return 6966;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, true, true).ID: return 6969;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, true, false).ID: return 6970;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, false, true).ID: return 6973;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, false, false).ID: return 6974;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, true, true).ID: return 6977;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, true, false).ID: return 6978;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, false, true).ID: return 6981;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, false, false).ID: return 6982;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, true, true).ID: return 6985;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, true, false).ID: return 6986;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, false, true).ID: return 6989;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, false, false).ID: return 6990;
			case LightBlueTerracotta::LightBlueTerracotta().ID: return 6850;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8165;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8166;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8167;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8168;
			case LightBlueWool::LightBlueWool().ID: return 1387;
			case LightGrayBanner::LightGrayBanner(0).ID: return 8025;
			case LightGrayBanner::LightGrayBanner(1).ID: return 8026;
			case LightGrayBanner::LightGrayBanner(2).ID: return 8027;
			case LightGrayBanner::LightGrayBanner(3).ID: return 8028;
			case LightGrayBanner::LightGrayBanner(4).ID: return 8029;
			case LightGrayBanner::LightGrayBanner(5).ID: return 8030;
			case LightGrayBanner::LightGrayBanner(6).ID: return 8031;
			case LightGrayBanner::LightGrayBanner(7).ID: return 8032;
			case LightGrayBanner::LightGrayBanner(8).ID: return 8033;
			case LightGrayBanner::LightGrayBanner(9).ID: return 8034;
			case LightGrayBanner::LightGrayBanner(10).ID: return 8035;
			case LightGrayBanner::LightGrayBanner(11).ID: return 8036;
			case LightGrayBanner::LightGrayBanner(12).ID: return 8037;
			case LightGrayBanner::LightGrayBanner(13).ID: return 8038;
			case LightGrayBanner::LightGrayBanner(14).ID: return 8039;
			case LightGrayBanner::LightGrayBanner(15).ID: return 8040;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, true, LightGrayBed::Part::Head).ID: return 1177;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, true, LightGrayBed::Part::Foot).ID: return 1178;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, false, LightGrayBed::Part::Head).ID: return 1179;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, false, LightGrayBed::Part::Foot).ID: return 1180;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, true, LightGrayBed::Part::Head).ID: return 1181;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, true, LightGrayBed::Part::Foot).ID: return 1182;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, false, LightGrayBed::Part::Head).ID: return 1183;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, false, LightGrayBed::Part::Foot).ID: return 1184;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, true, LightGrayBed::Part::Head).ID: return 1185;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, true, LightGrayBed::Part::Foot).ID: return 1186;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, false, LightGrayBed::Part::Head).ID: return 1187;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, false, LightGrayBed::Part::Foot).ID: return 1188;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, true, LightGrayBed::Part::Head).ID: return 1189;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, true, LightGrayBed::Part::Foot).ID: return 1190;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, false, LightGrayBed::Part::Head).ID: return 1191;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, false, LightGrayBed::Part::Foot).ID: return 1192;
			case LightGrayCarpet::LightGrayCarpet().ID: return 7874;
			case LightGrayConcrete::LightGrayConcrete().ID: return 9446;
			case LightGrayConcretePowder::LightGrayConcretePowder().ID: return 9462;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9406;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9407;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9408;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9409;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9326;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9327;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9328;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9329;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9330;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9331;
			case LightGrayStainedGlass::LightGrayStainedGlass().ID: return 4103;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, true, true).ID: return 7121;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, true, false).ID: return 7122;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, false, true).ID: return 7125;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, false, false).ID: return 7126;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, true, true).ID: return 7129;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, true, false).ID: return 7130;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, false, true).ID: return 7133;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, false, false).ID: return 7134;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, true, true).ID: return 7137;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, true, false).ID: return 7138;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, false, true).ID: return 7141;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, false, false).ID: return 7142;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, true, true).ID: return 7145;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, true, false).ID: return 7146;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, false, true).ID: return 7149;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, false, false).ID: return 7150;
			case LightGrayTerracotta::LightGrayTerracotta().ID: return 6855;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8185;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8186;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8187;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8188;
			case LightGrayWool::LightGrayWool().ID: return 1392;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(0).ID: return 6646;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(1).ID: return 6647;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(2).ID: return 6648;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(3).ID: return 6649;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(4).ID: return 6650;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(5).ID: return 6651;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(6).ID: return 6652;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(7).ID: return 6653;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(8).ID: return 6654;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(9).ID: return 6655;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(10).ID: return 6656;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(11).ID: return 6657;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(12).ID: return 6658;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(13).ID: return 6659;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(14).ID: return 6660;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(15).ID: return 6661;
			case Lilac::Lilac(Lilac::Half::Upper).ID: return 7887;
			case Lilac::Lilac(Lilac::Half::Lower).ID: return 7888;
			case LilyOfTheValley::LilyOfTheValley().ID: return 1424;
			case LilyPad::LilyPad().ID: return 5014;
			case LimeBanner::LimeBanner(0).ID: return 7977;
			case LimeBanner::LimeBanner(1).ID: return 7978;
			case LimeBanner::LimeBanner(2).ID: return 7979;
			case LimeBanner::LimeBanner(3).ID: return 7980;
			case LimeBanner::LimeBanner(4).ID: return 7981;
			case LimeBanner::LimeBanner(5).ID: return 7982;
			case LimeBanner::LimeBanner(6).ID: return 7983;
			case LimeBanner::LimeBanner(7).ID: return 7984;
			case LimeBanner::LimeBanner(8).ID: return 7985;
			case LimeBanner::LimeBanner(9).ID: return 7986;
			case LimeBanner::LimeBanner(10).ID: return 7987;
			case LimeBanner::LimeBanner(11).ID: return 7988;
			case LimeBanner::LimeBanner(12).ID: return 7989;
			case LimeBanner::LimeBanner(13).ID: return 7990;
			case LimeBanner::LimeBanner(14).ID: return 7991;
			case LimeBanner::LimeBanner(15).ID: return 7992;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, true, LimeBed::Part::Head).ID: return 1129;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, true, LimeBed::Part::Foot).ID: return 1130;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, false, LimeBed::Part::Head).ID: return 1131;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, false, LimeBed::Part::Foot).ID: return 1132;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, true, LimeBed::Part::Head).ID: return 1133;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, true, LimeBed::Part::Foot).ID: return 1134;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, false, LimeBed::Part::Head).ID: return 1135;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, false, LimeBed::Part::Foot).ID: return 1136;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, true, LimeBed::Part::Head).ID: return 1137;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, true, LimeBed::Part::Foot).ID: return 1138;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, false, LimeBed::Part::Head).ID: return 1139;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, false, LimeBed::Part::Foot).ID: return 1140;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, true, LimeBed::Part::Head).ID: return 1141;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, true, LimeBed::Part::Foot).ID: return 1142;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, false, LimeBed::Part::Head).ID: return 1143;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, false, LimeBed::Part::Foot).ID: return 1144;
			case LimeCarpet::LimeCarpet().ID: return 7871;
			case LimeConcrete::LimeConcrete().ID: return 9443;
			case LimeConcretePowder::LimeConcretePowder().ID: return 9459;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9394;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9395;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9396;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9397;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9308;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9309;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9310;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9311;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9312;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9313;
			case LimeStainedGlass::LimeStainedGlass().ID: return 4100;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, true, true).ID: return 7025;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, true, false).ID: return 7026;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, false, true).ID: return 7029;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, false, false).ID: return 7030;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, true, true).ID: return 7033;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, true, false).ID: return 7034;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, false, true).ID: return 7037;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, false, false).ID: return 7038;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, true, true).ID: return 7041;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, true, false).ID: return 7042;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, false, true).ID: return 7045;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, false, false).ID: return 7046;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, true, true).ID: return 7049;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, true, false).ID: return 7050;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, false, true).ID: return 7053;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, false, false).ID: return 7054;
			case LimeTerracotta::LimeTerracotta().ID: return 6852;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8173;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8174;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8175;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8176;
			case LimeWool::LimeWool().ID: return 1389;
			case Lodestone::Lodestone().ID: return 15838;
			case Loom::Loom(eBlockFace::BLOCK_FACE_ZM).ID: return 14787;
			case Loom::Loom(eBlockFace::BLOCK_FACE_ZP).ID: return 14788;
			case Loom::Loom(eBlockFace::BLOCK_FACE_XM).ID: return 14789;
			case Loom::Loom(eBlockFace::BLOCK_FACE_XP).ID: return 14790;
			case MagentaBanner::MagentaBanner(0).ID: return 7929;
			case MagentaBanner::MagentaBanner(1).ID: return 7930;
			case MagentaBanner::MagentaBanner(2).ID: return 7931;
			case MagentaBanner::MagentaBanner(3).ID: return 7932;
			case MagentaBanner::MagentaBanner(4).ID: return 7933;
			case MagentaBanner::MagentaBanner(5).ID: return 7934;
			case MagentaBanner::MagentaBanner(6).ID: return 7935;
			case MagentaBanner::MagentaBanner(7).ID: return 7936;
			case MagentaBanner::MagentaBanner(8).ID: return 7937;
			case MagentaBanner::MagentaBanner(9).ID: return 7938;
			case MagentaBanner::MagentaBanner(10).ID: return 7939;
			case MagentaBanner::MagentaBanner(11).ID: return 7940;
			case MagentaBanner::MagentaBanner(12).ID: return 7941;
			case MagentaBanner::MagentaBanner(13).ID: return 7942;
			case MagentaBanner::MagentaBanner(14).ID: return 7943;
			case MagentaBanner::MagentaBanner(15).ID: return 7944;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, true, MagentaBed::Part::Head).ID: return 1081;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, true, MagentaBed::Part::Foot).ID: return 1082;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, false, MagentaBed::Part::Head).ID: return 1083;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, false, MagentaBed::Part::Foot).ID: return 1084;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, true, MagentaBed::Part::Head).ID: return 1085;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, true, MagentaBed::Part::Foot).ID: return 1086;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, false, MagentaBed::Part::Head).ID: return 1087;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, false, MagentaBed::Part::Foot).ID: return 1088;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, true, MagentaBed::Part::Head).ID: return 1089;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, true, MagentaBed::Part::Foot).ID: return 1090;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, false, MagentaBed::Part::Head).ID: return 1091;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, false, MagentaBed::Part::Foot).ID: return 1092;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, true, MagentaBed::Part::Head).ID: return 1093;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, true, MagentaBed::Part::Foot).ID: return 1094;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, false, MagentaBed::Part::Head).ID: return 1095;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, false, MagentaBed::Part::Foot).ID: return 1096;
			case MagentaCarpet::MagentaCarpet().ID: return 7868;
			case MagentaConcrete::MagentaConcrete().ID: return 9440;
			case MagentaConcretePowder::MagentaConcretePowder().ID: return 9456;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9382;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9383;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9384;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9385;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9290;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9291;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9292;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9293;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9294;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9295;
			case MagentaStainedGlass::MagentaStainedGlass().ID: return 4097;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, true, true).ID: return 6929;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, true, false).ID: return 6930;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, false, true).ID: return 6933;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, false, false).ID: return 6934;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, true, true).ID: return 6937;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, true, false).ID: return 6938;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, false, true).ID: return 6941;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, false, false).ID: return 6942;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, true, true).ID: return 6945;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, true, false).ID: return 6946;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, false, true).ID: return 6949;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, false, false).ID: return 6950;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, true, true).ID: return 6953;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, true, false).ID: return 6954;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, false, true).ID: return 6957;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, false, false).ID: return 6958;
			case MagentaTerracotta::MagentaTerracotta().ID: return 6849;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8161;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8162;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8163;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8164;
			case MagentaWool::MagentaWool().ID: return 1386;
			case MagmaBlock::MagmaBlock().ID: return 9253;
			case Melon::Melon().ID: return 4763;
			case MelonStem::MelonStem(0).ID: return 4780;
			case MelonStem::MelonStem(1).ID: return 4781;
			case MelonStem::MelonStem(2).ID: return 4782;
			case MelonStem::MelonStem(3).ID: return 4783;
			case MelonStem::MelonStem(4).ID: return 4784;
			case MelonStem::MelonStem(5).ID: return 4785;
			case MelonStem::MelonStem(6).ID: return 4786;
			case MelonStem::MelonStem(7).ID: return 4787;
			case MossyCobblestone::MossyCobblestone().ID: return 1433;
			case MossyCobblestoneSlab::MossyCobblestoneSlab(MossyCobblestoneSlab::Type::Top).ID: return 10814;
			case MossyCobblestoneSlab::MossyCobblestoneSlab(MossyCobblestoneSlab::Type::Bottom).ID: return 10816;
			case MossyCobblestoneSlab::MossyCobblestoneSlab(MossyCobblestoneSlab::Type::Double).ID: return 10818;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 9990;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9992;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9994;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9996;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9998;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 10000;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10002;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10004;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10006;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10008;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 10010;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10012;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10014;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10016;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10018;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 10020;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10022;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10024;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10026;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10028;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 10030;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10032;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10034;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10036;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10038;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 10040;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10042;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10044;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10046;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10048;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 10050;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10052;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10054;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10056;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10058;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 10060;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 10062;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 10064;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 10066;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 10068;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 5984;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 5985;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 5986;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 5990;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 5991;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 5992;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 5996;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 5997;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 5998;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6002;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6003;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6004;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6008;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6009;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6010;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6014;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6015;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6016;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6020;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6021;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6022;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6026;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6027;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6028;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6032;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6033;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6034;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6038;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6039;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6040;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6044;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6045;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6046;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6050;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6051;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6052;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6056;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6057;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6058;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6062;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6063;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6064;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6068;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6069;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6070;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6074;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6075;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6076;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6080;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6081;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6082;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6086;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6087;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6088;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6092;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6093;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6094;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6098;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6099;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6100;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6104;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6105;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6106;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6110;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6111;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6112;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6116;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6117;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6118;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6122;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6123;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6124;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6128;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6129;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6130;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6134;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6135;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6136;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6140;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6141;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6142;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6146;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6147;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6148;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6152;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6153;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6154;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6158;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6159;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6160;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6164;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6165;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6166;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6170;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6171;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6172;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6176;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6177;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6178;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6182;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6183;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6184;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6188;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6189;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6190;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6194;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6195;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6196;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6200;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6201;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6202;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6206;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6207;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6208;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6212;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6213;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6214;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6218;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6219;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6220;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6224;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6225;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6226;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6230;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6231;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6232;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6236;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6237;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6238;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6242;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6243;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6244;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6248;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6249;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6250;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6254;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6255;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6256;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6260;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6261;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6262;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6266;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6267;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6268;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 6272;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 6273;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Tall).ID: return 6274;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 6278;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 6279;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Tall).ID: return 6280;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 6284;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 6285;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Tall).ID: return 6286;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 6290;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 6291;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Tall).ID: return 6292;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::None).ID: return 6296;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Low).ID: return 6297;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, true, MossyCobblestoneWall::West::Tall).ID: return 6298;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::None).ID: return 6302;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Low).ID: return 6303;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Tall, MossyCobblestoneWall::North::Tall, MossyCobblestoneWall::South::Tall, false, MossyCobblestoneWall::West::Tall).ID: return 6304;
			case MossyStoneBrickSlab::MossyStoneBrickSlab(MossyStoneBrickSlab::Type::Top).ID: return 10802;
			case MossyStoneBrickSlab::MossyStoneBrickSlab(MossyStoneBrickSlab::Type::Bottom).ID: return 10804;
			case MossyStoneBrickSlab::MossyStoneBrickSlab(MossyStoneBrickSlab::Type::Double).ID: return 10806;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9830;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9832;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9834;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9836;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9838;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9840;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9842;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9844;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9846;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9848;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9850;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9852;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9854;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9856;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9858;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9860;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9862;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9864;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9866;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9868;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9870;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9872;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9874;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9876;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9878;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9880;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9882;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9884;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9886;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9888;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9890;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9892;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9894;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9896;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9898;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9900;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9902;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9904;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9906;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9908;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 11842;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 11843;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 11844;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 11848;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 11849;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 11850;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 11854;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 11855;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 11856;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 11860;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 11861;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 11862;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 11866;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 11867;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 11868;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 11872;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 11873;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 11874;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 11878;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 11879;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 11880;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 11884;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 11885;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 11886;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 11890;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 11891;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 11892;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 11896;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 11897;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 11898;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 11902;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 11903;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 11904;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 11908;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 11909;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 11910;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 11914;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 11915;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 11916;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 11920;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 11921;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 11922;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 11926;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 11927;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 11928;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 11932;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 11933;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 11934;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 11938;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 11939;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 11940;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 11944;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 11945;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 11946;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 11950;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 11951;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 11952;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 11956;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 11957;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 11958;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 11962;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 11963;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 11964;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 11968;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 11969;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 11970;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 11974;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 11975;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 11976;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 11980;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 11981;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 11982;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 11986;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 11987;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 11988;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 11992;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 11993;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 11994;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 11998;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 11999;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 12000;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 12004;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 12005;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 12006;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 12010;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 12011;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 12012;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 12016;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 12017;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 12018;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 12022;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 12023;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 12024;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 12028;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 12029;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 12030;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 12034;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 12035;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 12036;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 12040;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 12041;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 12042;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 12046;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 12047;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 12048;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 12052;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 12053;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 12054;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 12058;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 12059;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 12060;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 12064;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 12065;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 12066;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 12070;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 12071;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 12072;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 12076;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 12077;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 12078;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 12082;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 12083;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 12084;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 12088;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 12089;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 12090;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 12094;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 12095;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 12096;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 12100;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 12101;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 12102;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 12106;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 12107;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 12108;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 12112;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 12113;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 12114;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 12118;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 12119;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 12120;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 12124;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 12125;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 12126;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 12130;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 12131;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Tall).ID: return 12132;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 12136;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 12137;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Tall).ID: return 12138;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 12142;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 12143;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Tall).ID: return 12144;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 12148;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 12149;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Tall).ID: return 12150;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::None).ID: return 12154;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Low).ID: return 12155;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, true, MossyStoneBrickWall::West::Tall).ID: return 12156;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::None).ID: return 12160;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Low).ID: return 12161;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Tall, MossyStoneBrickWall::North::Tall, MossyStoneBrickWall::South::Tall, false, MossyStoneBrickWall::West::Tall).ID: return 12162;
			case MossyStoneBricks::MossyStoneBricks().ID: return 4496;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZM, MovingPiston::Type::Normal).ID: return 1400;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZM, MovingPiston::Type::Sticky).ID: return 1401;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XP, MovingPiston::Type::Normal).ID: return 1402;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XP, MovingPiston::Type::Sticky).ID: return 1403;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZP, MovingPiston::Type::Normal).ID: return 1404;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZP, MovingPiston::Type::Sticky).ID: return 1405;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XM, MovingPiston::Type::Normal).ID: return 1406;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XM, MovingPiston::Type::Sticky).ID: return 1407;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YP, MovingPiston::Type::Normal).ID: return 1408;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YP, MovingPiston::Type::Sticky).ID: return 1409;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YM, MovingPiston::Type::Normal).ID: return 1410;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YM, MovingPiston::Type::Sticky).ID: return 1411;
			case MushroomStem::MushroomStem(true, true, true, true, true, true).ID: return 4633;
			case MushroomStem::MushroomStem(true, true, true, true, true, false).ID: return 4634;
			case MushroomStem::MushroomStem(true, true, true, true, false, true).ID: return 4635;
			case MushroomStem::MushroomStem(true, true, true, true, false, false).ID: return 4636;
			case MushroomStem::MushroomStem(true, true, true, false, true, true).ID: return 4637;
			case MushroomStem::MushroomStem(true, true, true, false, true, false).ID: return 4638;
			case MushroomStem::MushroomStem(true, true, true, false, false, true).ID: return 4639;
			case MushroomStem::MushroomStem(true, true, true, false, false, false).ID: return 4640;
			case MushroomStem::MushroomStem(true, true, false, true, true, true).ID: return 4641;
			case MushroomStem::MushroomStem(true, true, false, true, true, false).ID: return 4642;
			case MushroomStem::MushroomStem(true, true, false, true, false, true).ID: return 4643;
			case MushroomStem::MushroomStem(true, true, false, true, false, false).ID: return 4644;
			case MushroomStem::MushroomStem(true, true, false, false, true, true).ID: return 4645;
			case MushroomStem::MushroomStem(true, true, false, false, true, false).ID: return 4646;
			case MushroomStem::MushroomStem(true, true, false, false, false, true).ID: return 4647;
			case MushroomStem::MushroomStem(true, true, false, false, false, false).ID: return 4648;
			case MushroomStem::MushroomStem(true, false, true, true, true, true).ID: return 4649;
			case MushroomStem::MushroomStem(true, false, true, true, true, false).ID: return 4650;
			case MushroomStem::MushroomStem(true, false, true, true, false, true).ID: return 4651;
			case MushroomStem::MushroomStem(true, false, true, true, false, false).ID: return 4652;
			case MushroomStem::MushroomStem(true, false, true, false, true, true).ID: return 4653;
			case MushroomStem::MushroomStem(true, false, true, false, true, false).ID: return 4654;
			case MushroomStem::MushroomStem(true, false, true, false, false, true).ID: return 4655;
			case MushroomStem::MushroomStem(true, false, true, false, false, false).ID: return 4656;
			case MushroomStem::MushroomStem(true, false, false, true, true, true).ID: return 4657;
			case MushroomStem::MushroomStem(true, false, false, true, true, false).ID: return 4658;
			case MushroomStem::MushroomStem(true, false, false, true, false, true).ID: return 4659;
			case MushroomStem::MushroomStem(true, false, false, true, false, false).ID: return 4660;
			case MushroomStem::MushroomStem(true, false, false, false, true, true).ID: return 4661;
			case MushroomStem::MushroomStem(true, false, false, false, true, false).ID: return 4662;
			case MushroomStem::MushroomStem(true, false, false, false, false, true).ID: return 4663;
			case MushroomStem::MushroomStem(true, false, false, false, false, false).ID: return 4664;
			case MushroomStem::MushroomStem(false, true, true, true, true, true).ID: return 4665;
			case MushroomStem::MushroomStem(false, true, true, true, true, false).ID: return 4666;
			case MushroomStem::MushroomStem(false, true, true, true, false, true).ID: return 4667;
			case MushroomStem::MushroomStem(false, true, true, true, false, false).ID: return 4668;
			case MushroomStem::MushroomStem(false, true, true, false, true, true).ID: return 4669;
			case MushroomStem::MushroomStem(false, true, true, false, true, false).ID: return 4670;
			case MushroomStem::MushroomStem(false, true, true, false, false, true).ID: return 4671;
			case MushroomStem::MushroomStem(false, true, true, false, false, false).ID: return 4672;
			case MushroomStem::MushroomStem(false, true, false, true, true, true).ID: return 4673;
			case MushroomStem::MushroomStem(false, true, false, true, true, false).ID: return 4674;
			case MushroomStem::MushroomStem(false, true, false, true, false, true).ID: return 4675;
			case MushroomStem::MushroomStem(false, true, false, true, false, false).ID: return 4676;
			case MushroomStem::MushroomStem(false, true, false, false, true, true).ID: return 4677;
			case MushroomStem::MushroomStem(false, true, false, false, true, false).ID: return 4678;
			case MushroomStem::MushroomStem(false, true, false, false, false, true).ID: return 4679;
			case MushroomStem::MushroomStem(false, true, false, false, false, false).ID: return 4680;
			case MushroomStem::MushroomStem(false, false, true, true, true, true).ID: return 4681;
			case MushroomStem::MushroomStem(false, false, true, true, true, false).ID: return 4682;
			case MushroomStem::MushroomStem(false, false, true, true, false, true).ID: return 4683;
			case MushroomStem::MushroomStem(false, false, true, true, false, false).ID: return 4684;
			case MushroomStem::MushroomStem(false, false, true, false, true, true).ID: return 4685;
			case MushroomStem::MushroomStem(false, false, true, false, true, false).ID: return 4686;
			case MushroomStem::MushroomStem(false, false, true, false, false, true).ID: return 4687;
			case MushroomStem::MushroomStem(false, false, true, false, false, false).ID: return 4688;
			case MushroomStem::MushroomStem(false, false, false, true, true, true).ID: return 4689;
			case MushroomStem::MushroomStem(false, false, false, true, true, false).ID: return 4690;
			case MushroomStem::MushroomStem(false, false, false, true, false, true).ID: return 4691;
			case MushroomStem::MushroomStem(false, false, false, true, false, false).ID: return 4692;
			case MushroomStem::MushroomStem(false, false, false, false, true, true).ID: return 4693;
			case MushroomStem::MushroomStem(false, false, false, false, true, false).ID: return 4694;
			case MushroomStem::MushroomStem(false, false, false, false, false, true).ID: return 4695;
			case MushroomStem::MushroomStem(false, false, false, false, false, false).ID: return 4696;
			case Mycelium::Mycelium(true).ID: return 5012;
			case Mycelium::Mycelium(false).ID: return 5013;
			case NetherBrickFence::NetherBrickFence(true, true, true, true).ID: return 5018;
			case NetherBrickFence::NetherBrickFence(true, true, true, false).ID: return 5019;
			case NetherBrickFence::NetherBrickFence(true, true, false, true).ID: return 5022;
			case NetherBrickFence::NetherBrickFence(true, true, false, false).ID: return 5023;
			case NetherBrickFence::NetherBrickFence(true, false, true, true).ID: return 5026;
			case NetherBrickFence::NetherBrickFence(true, false, true, false).ID: return 5027;
			case NetherBrickFence::NetherBrickFence(true, false, false, true).ID: return 5030;
			case NetherBrickFence::NetherBrickFence(true, false, false, false).ID: return 5031;
			case NetherBrickFence::NetherBrickFence(false, true, true, true).ID: return 5034;
			case NetherBrickFence::NetherBrickFence(false, true, true, false).ID: return 5035;
			case NetherBrickFence::NetherBrickFence(false, true, false, true).ID: return 5038;
			case NetherBrickFence::NetherBrickFence(false, true, false, false).ID: return 5039;
			case NetherBrickFence::NetherBrickFence(false, false, true, true).ID: return 5042;
			case NetherBrickFence::NetherBrickFence(false, false, true, false).ID: return 5043;
			case NetherBrickFence::NetherBrickFence(false, false, false, true).ID: return 5046;
			case NetherBrickFence::NetherBrickFence(false, false, false, false).ID: return 5047;
			case NetherBrickSlab::NetherBrickSlab(NetherBrickSlab::Type::Top).ID: return 8385;
			case NetherBrickSlab::NetherBrickSlab(NetherBrickSlab::Type::Bottom).ID: return 8387;
			case NetherBrickSlab::NetherBrickSlab(NetherBrickSlab::Type::Double).ID: return 8389;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5049;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5051;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5053;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5055;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5057;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5059;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5061;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5063;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5065;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5067;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5069;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5071;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5073;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5075;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5077;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5079;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5081;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5083;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5085;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5087;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5089;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5091;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5093;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5095;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5097;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5099;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5101;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5103;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5105;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5107;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5109;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5111;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5113;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5115;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5117;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5119;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5121;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5123;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5125;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5127;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 12814;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 12815;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 12816;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 12820;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 12821;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 12822;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 12826;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 12827;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 12828;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 12832;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 12833;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 12834;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 12838;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 12839;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 12840;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 12844;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 12845;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 12846;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 12850;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 12851;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 12852;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 12856;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 12857;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 12858;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 12862;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 12863;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 12864;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 12868;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 12869;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 12870;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 12874;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 12875;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 12876;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 12880;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 12881;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 12882;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 12886;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 12887;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 12888;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 12892;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 12893;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 12894;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 12898;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 12899;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 12900;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 12904;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 12905;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 12906;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 12910;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 12911;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 12912;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 12916;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 12917;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 12918;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 12922;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 12923;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 12924;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 12928;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 12929;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 12930;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 12934;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 12935;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 12936;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 12940;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 12941;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 12942;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 12946;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 12947;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 12948;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 12952;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 12953;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 12954;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 12958;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 12959;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 12960;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 12964;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 12965;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 12966;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 12970;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 12971;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 12972;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 12976;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 12977;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 12978;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 12982;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 12983;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 12984;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 12988;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 12989;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 12990;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 12994;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 12995;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 12996;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 13000;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 13001;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 13002;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 13006;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 13007;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 13008;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 13012;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 13013;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 13014;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 13018;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 13019;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 13020;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 13024;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 13025;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 13026;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 13030;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 13031;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 13032;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 13036;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 13037;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 13038;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 13042;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 13043;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 13044;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 13048;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 13049;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 13050;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 13054;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 13055;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 13056;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 13060;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 13061;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::None, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 13062;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 13066;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 13067;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 13068;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 13072;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 13073;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 13074;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 13078;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 13079;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 13080;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 13084;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 13085;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 13086;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 13090;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 13091;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 13092;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 13096;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 13097;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Low, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 13098;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 13102;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 13103;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::None, true, NetherBrickWall::West::Tall).ID: return 13104;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 13108;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 13109;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::None, false, NetherBrickWall::West::Tall).ID: return 13110;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 13114;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 13115;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, true, NetherBrickWall::West::Tall).ID: return 13116;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 13120;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 13121;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Low, false, NetherBrickWall::West::Tall).ID: return 13122;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::None).ID: return 13126;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Low).ID: return 13127;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, true, NetherBrickWall::West::Tall).ID: return 13128;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::None).ID: return 13132;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Low).ID: return 13133;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Tall, NetherBrickWall::North::Tall, NetherBrickWall::South::Tall, false, NetherBrickWall::West::Tall).ID: return 13134;
			case NetherBricks::NetherBricks().ID: return 5015;
			case NetherGoldOre::NetherGoldOre().ID: return 72;
			case NetherPortal::NetherPortal(NetherPortal::Axis::X).ID: return 4014;
			case NetherPortal::NetherPortal(NetherPortal::Axis::Z).ID: return 4015;
			case NetherQuartzOre::NetherQuartzOre().ID: return 6727;
			case NetherSprouts::NetherSprouts().ID: return 14974;
			case NetherWart::NetherWart(0).ID: return 5128;
			case NetherWart::NetherWart(1).ID: return 5129;
			case NetherWart::NetherWart(2).ID: return 5130;
			case NetherWart::NetherWart(3).ID: return 5131;
			case NetherWartBlock::NetherWartBlock().ID: return 9254;
			case NetheriteBlock::NetheriteBlock().ID: return 15826;
			case Netherrack::Netherrack().ID: return 3999;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 0, true).ID: return 249;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 0, false).ID: return 250;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 1, true).ID: return 251;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 1, false).ID: return 252;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 2, true).ID: return 253;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 2, false).ID: return 254;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 3, true).ID: return 255;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 3, false).ID: return 256;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 4, true).ID: return 257;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 4, false).ID: return 258;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 5, true).ID: return 259;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 5, false).ID: return 260;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 6, true).ID: return 261;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 6, false).ID: return 262;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 7, true).ID: return 263;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 7, false).ID: return 264;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 8, true).ID: return 265;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 8, false).ID: return 266;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 9, true).ID: return 267;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 9, false).ID: return 268;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 10, true).ID: return 269;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 10, false).ID: return 270;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 11, true).ID: return 271;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 11, false).ID: return 272;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 12, true).ID: return 273;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 12, false).ID: return 274;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 13, true).ID: return 275;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 13, false).ID: return 276;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 14, true).ID: return 277;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 14, false).ID: return 278;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 15, true).ID: return 279;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 15, false).ID: return 280;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 16, true).ID: return 281;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 16, false).ID: return 282;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 17, true).ID: return 283;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 17, false).ID: return 284;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 18, true).ID: return 285;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 18, false).ID: return 286;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 19, true).ID: return 287;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 19, false).ID: return 288;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 20, true).ID: return 289;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 20, false).ID: return 290;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 21, true).ID: return 291;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 21, false).ID: return 292;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 22, true).ID: return 293;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 22, false).ID: return 294;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 23, true).ID: return 295;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 23, false).ID: return 296;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 24, true).ID: return 297;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 24, false).ID: return 298;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 0, true).ID: return 299;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 0, false).ID: return 300;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 1, true).ID: return 301;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 1, false).ID: return 302;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 2, true).ID: return 303;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 2, false).ID: return 304;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 3, true).ID: return 305;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 3, false).ID: return 306;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 4, true).ID: return 307;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 4, false).ID: return 308;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 5, true).ID: return 309;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 5, false).ID: return 310;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 6, true).ID: return 311;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 6, false).ID: return 312;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 7, true).ID: return 313;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 7, false).ID: return 314;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 8, true).ID: return 315;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 8, false).ID: return 316;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 9, true).ID: return 317;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 9, false).ID: return 318;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 10, true).ID: return 319;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 10, false).ID: return 320;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 11, true).ID: return 321;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 11, false).ID: return 322;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 12, true).ID: return 323;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 12, false).ID: return 324;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 13, true).ID: return 325;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 13, false).ID: return 326;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 14, true).ID: return 327;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 14, false).ID: return 328;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 15, true).ID: return 329;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 15, false).ID: return 330;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 16, true).ID: return 331;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 16, false).ID: return 332;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 17, true).ID: return 333;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 17, false).ID: return 334;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 18, true).ID: return 335;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 18, false).ID: return 336;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 19, true).ID: return 337;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 19, false).ID: return 338;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 20, true).ID: return 339;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 20, false).ID: return 340;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 21, true).ID: return 341;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 21, false).ID: return 342;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 22, true).ID: return 343;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 22, false).ID: return 344;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 23, true).ID: return 345;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 23, false).ID: return 346;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 24, true).ID: return 347;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 24, false).ID: return 348;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 0, true).ID: return 349;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 0, false).ID: return 350;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 1, true).ID: return 351;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 1, false).ID: return 352;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 2, true).ID: return 353;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 2, false).ID: return 354;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 3, true).ID: return 355;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 3, false).ID: return 356;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 4, true).ID: return 357;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 4, false).ID: return 358;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 5, true).ID: return 359;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 5, false).ID: return 360;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 6, true).ID: return 361;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 6, false).ID: return 362;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 7, true).ID: return 363;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 7, false).ID: return 364;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 8, true).ID: return 365;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 8, false).ID: return 366;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 9, true).ID: return 367;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 9, false).ID: return 368;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 10, true).ID: return 369;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 10, false).ID: return 370;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 11, true).ID: return 371;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 11, false).ID: return 372;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 12, true).ID: return 373;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 12, false).ID: return 374;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 13, true).ID: return 375;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 13, false).ID: return 376;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 14, true).ID: return 377;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 14, false).ID: return 378;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 15, true).ID: return 379;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 15, false).ID: return 380;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 16, true).ID: return 381;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 16, false).ID: return 382;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 17, true).ID: return 383;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 17, false).ID: return 384;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 18, true).ID: return 385;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 18, false).ID: return 386;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 19, true).ID: return 387;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 19, false).ID: return 388;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 20, true).ID: return 389;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 20, false).ID: return 390;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 21, true).ID: return 391;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 21, false).ID: return 392;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 22, true).ID: return 393;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 22, false).ID: return 394;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 23, true).ID: return 395;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 23, false).ID: return 396;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 24, true).ID: return 397;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 24, false).ID: return 398;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 0, true).ID: return 399;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 0, false).ID: return 400;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 1, true).ID: return 401;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 1, false).ID: return 402;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 2, true).ID: return 403;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 2, false).ID: return 404;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 3, true).ID: return 405;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 3, false).ID: return 406;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 4, true).ID: return 407;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 4, false).ID: return 408;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 5, true).ID: return 409;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 5, false).ID: return 410;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 6, true).ID: return 411;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 6, false).ID: return 412;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 7, true).ID: return 413;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 7, false).ID: return 414;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 8, true).ID: return 415;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 8, false).ID: return 416;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 9, true).ID: return 417;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 9, false).ID: return 418;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 10, true).ID: return 419;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 10, false).ID: return 420;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 11, true).ID: return 421;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 11, false).ID: return 422;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 12, true).ID: return 423;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 12, false).ID: return 424;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 13, true).ID: return 425;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 13, false).ID: return 426;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 14, true).ID: return 427;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 14, false).ID: return 428;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 15, true).ID: return 429;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 15, false).ID: return 430;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 16, true).ID: return 431;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 16, false).ID: return 432;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 17, true).ID: return 433;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 17, false).ID: return 434;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 18, true).ID: return 435;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 18, false).ID: return 436;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 19, true).ID: return 437;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 19, false).ID: return 438;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 20, true).ID: return 439;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 20, false).ID: return 440;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 21, true).ID: return 441;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 21, false).ID: return 442;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 22, true).ID: return 443;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 22, false).ID: return 444;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 23, true).ID: return 445;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 23, false).ID: return 446;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 24, true).ID: return 447;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 24, false).ID: return 448;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 0, true).ID: return 449;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 0, false).ID: return 450;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 1, true).ID: return 451;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 1, false).ID: return 452;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 2, true).ID: return 453;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 2, false).ID: return 454;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 3, true).ID: return 455;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 3, false).ID: return 456;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 4, true).ID: return 457;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 4, false).ID: return 458;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 5, true).ID: return 459;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 5, false).ID: return 460;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 6, true).ID: return 461;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 6, false).ID: return 462;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 7, true).ID: return 463;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 7, false).ID: return 464;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 8, true).ID: return 465;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 8, false).ID: return 466;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 9, true).ID: return 467;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 9, false).ID: return 468;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 10, true).ID: return 469;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 10, false).ID: return 470;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 11, true).ID: return 471;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 11, false).ID: return 472;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 12, true).ID: return 473;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 12, false).ID: return 474;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 13, true).ID: return 475;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 13, false).ID: return 476;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 14, true).ID: return 477;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 14, false).ID: return 478;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 15, true).ID: return 479;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 15, false).ID: return 480;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 16, true).ID: return 481;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 16, false).ID: return 482;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 17, true).ID: return 483;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 17, false).ID: return 484;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 18, true).ID: return 485;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 18, false).ID: return 486;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 19, true).ID: return 487;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 19, false).ID: return 488;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 20, true).ID: return 489;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 20, false).ID: return 490;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 21, true).ID: return 491;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 21, false).ID: return 492;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 22, true).ID: return 493;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 22, false).ID: return 494;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 23, true).ID: return 495;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 23, false).ID: return 496;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 24, true).ID: return 497;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 24, false).ID: return 498;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 0, true).ID: return 499;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 0, false).ID: return 500;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 1, true).ID: return 501;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 1, false).ID: return 502;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 2, true).ID: return 503;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 2, false).ID: return 504;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 3, true).ID: return 505;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 3, false).ID: return 506;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 4, true).ID: return 507;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 4, false).ID: return 508;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 5, true).ID: return 509;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 5, false).ID: return 510;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 6, true).ID: return 511;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 6, false).ID: return 512;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 7, true).ID: return 513;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 7, false).ID: return 514;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 8, true).ID: return 515;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 8, false).ID: return 516;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 9, true).ID: return 517;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 9, false).ID: return 518;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 10, true).ID: return 519;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 10, false).ID: return 520;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 11, true).ID: return 521;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 11, false).ID: return 522;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 12, true).ID: return 523;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 12, false).ID: return 524;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 13, true).ID: return 525;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 13, false).ID: return 526;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 14, true).ID: return 527;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 14, false).ID: return 528;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 15, true).ID: return 529;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 15, false).ID: return 530;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 16, true).ID: return 531;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 16, false).ID: return 532;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 17, true).ID: return 533;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 17, false).ID: return 534;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 18, true).ID: return 535;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 18, false).ID: return 536;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 19, true).ID: return 537;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 19, false).ID: return 538;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 20, true).ID: return 539;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 20, false).ID: return 540;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 21, true).ID: return 541;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 21, false).ID: return 542;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 22, true).ID: return 543;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 22, false).ID: return 544;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 23, true).ID: return 545;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 23, false).ID: return 546;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 24, true).ID: return 547;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 24, false).ID: return 548;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 0, true).ID: return 549;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 0, false).ID: return 550;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 1, true).ID: return 551;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 1, false).ID: return 552;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 2, true).ID: return 553;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 2, false).ID: return 554;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 3, true).ID: return 555;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 3, false).ID: return 556;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 4, true).ID: return 557;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 4, false).ID: return 558;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 5, true).ID: return 559;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 5, false).ID: return 560;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 6, true).ID: return 561;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 6, false).ID: return 562;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 7, true).ID: return 563;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 7, false).ID: return 564;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 8, true).ID: return 565;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 8, false).ID: return 566;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 9, true).ID: return 567;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 9, false).ID: return 568;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 10, true).ID: return 569;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 10, false).ID: return 570;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 11, true).ID: return 571;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 11, false).ID: return 572;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 12, true).ID: return 573;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 12, false).ID: return 574;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 13, true).ID: return 575;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 13, false).ID: return 576;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 14, true).ID: return 577;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 14, false).ID: return 578;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 15, true).ID: return 579;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 15, false).ID: return 580;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 16, true).ID: return 581;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 16, false).ID: return 582;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 17, true).ID: return 583;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 17, false).ID: return 584;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 18, true).ID: return 585;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 18, false).ID: return 586;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 19, true).ID: return 587;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 19, false).ID: return 588;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 20, true).ID: return 589;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 20, false).ID: return 590;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 21, true).ID: return 591;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 21, false).ID: return 592;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 22, true).ID: return 593;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 22, false).ID: return 594;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 23, true).ID: return 595;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 23, false).ID: return 596;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 24, true).ID: return 597;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 24, false).ID: return 598;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 0, true).ID: return 599;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 0, false).ID: return 600;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 1, true).ID: return 601;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 1, false).ID: return 602;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 2, true).ID: return 603;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 2, false).ID: return 604;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 3, true).ID: return 605;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 3, false).ID: return 606;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 4, true).ID: return 607;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 4, false).ID: return 608;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 5, true).ID: return 609;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 5, false).ID: return 610;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 6, true).ID: return 611;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 6, false).ID: return 612;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 7, true).ID: return 613;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 7, false).ID: return 614;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 8, true).ID: return 615;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 8, false).ID: return 616;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 9, true).ID: return 617;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 9, false).ID: return 618;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 10, true).ID: return 619;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 10, false).ID: return 620;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 11, true).ID: return 621;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 11, false).ID: return 622;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 12, true).ID: return 623;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 12, false).ID: return 624;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 13, true).ID: return 625;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 13, false).ID: return 626;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 14, true).ID: return 627;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 14, false).ID: return 628;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 15, true).ID: return 629;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 15, false).ID: return 630;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 16, true).ID: return 631;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 16, false).ID: return 632;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 17, true).ID: return 633;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 17, false).ID: return 634;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 18, true).ID: return 635;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 18, false).ID: return 636;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 19, true).ID: return 637;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 19, false).ID: return 638;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 20, true).ID: return 639;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 20, false).ID: return 640;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 21, true).ID: return 641;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 21, false).ID: return 642;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 22, true).ID: return 643;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 22, false).ID: return 644;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 23, true).ID: return 645;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 23, false).ID: return 646;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 24, true).ID: return 647;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 24, false).ID: return 648;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 0, true).ID: return 649;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 0, false).ID: return 650;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 1, true).ID: return 651;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 1, false).ID: return 652;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 2, true).ID: return 653;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 2, false).ID: return 654;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 3, true).ID: return 655;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 3, false).ID: return 656;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 4, true).ID: return 657;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 4, false).ID: return 658;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 5, true).ID: return 659;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 5, false).ID: return 660;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 6, true).ID: return 661;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 6, false).ID: return 662;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 7, true).ID: return 663;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 7, false).ID: return 664;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 8, true).ID: return 665;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 8, false).ID: return 666;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 9, true).ID: return 667;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 9, false).ID: return 668;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 10, true).ID: return 669;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 10, false).ID: return 670;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 11, true).ID: return 671;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 11, false).ID: return 672;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 12, true).ID: return 673;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 12, false).ID: return 674;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 13, true).ID: return 675;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 13, false).ID: return 676;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 14, true).ID: return 677;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 14, false).ID: return 678;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 15, true).ID: return 679;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 15, false).ID: return 680;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 16, true).ID: return 681;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 16, false).ID: return 682;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 17, true).ID: return 683;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 17, false).ID: return 684;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 18, true).ID: return 685;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 18, false).ID: return 686;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 19, true).ID: return 687;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 19, false).ID: return 688;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 20, true).ID: return 689;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 20, false).ID: return 690;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 21, true).ID: return 691;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 21, false).ID: return 692;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 22, true).ID: return 693;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 22, false).ID: return 694;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 23, true).ID: return 695;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 23, false).ID: return 696;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 24, true).ID: return 697;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 24, false).ID: return 698;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 0, true).ID: return 699;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 0, false).ID: return 700;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 1, true).ID: return 701;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 1, false).ID: return 702;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 2, true).ID: return 703;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 2, false).ID: return 704;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 3, true).ID: return 705;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 3, false).ID: return 706;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 4, true).ID: return 707;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 4, false).ID: return 708;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 5, true).ID: return 709;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 5, false).ID: return 710;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 6, true).ID: return 711;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 6, false).ID: return 712;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 7, true).ID: return 713;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 7, false).ID: return 714;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 8, true).ID: return 715;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 8, false).ID: return 716;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 9, true).ID: return 717;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 9, false).ID: return 718;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 10, true).ID: return 719;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 10, false).ID: return 720;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 11, true).ID: return 721;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 11, false).ID: return 722;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 12, true).ID: return 723;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 12, false).ID: return 724;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 13, true).ID: return 725;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 13, false).ID: return 726;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 14, true).ID: return 727;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 14, false).ID: return 728;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 15, true).ID: return 729;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 15, false).ID: return 730;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 16, true).ID: return 731;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 16, false).ID: return 732;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 17, true).ID: return 733;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 17, false).ID: return 734;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 18, true).ID: return 735;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 18, false).ID: return 736;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 19, true).ID: return 737;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 19, false).ID: return 738;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 20, true).ID: return 739;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 20, false).ID: return 740;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 21, true).ID: return 741;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 21, false).ID: return 742;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 22, true).ID: return 743;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 22, false).ID: return 744;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 23, true).ID: return 745;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 23, false).ID: return 746;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 24, true).ID: return 747;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 24, false).ID: return 748;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 0, true).ID: return 749;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 0, false).ID: return 750;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 1, true).ID: return 751;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 1, false).ID: return 752;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 2, true).ID: return 753;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 2, false).ID: return 754;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 3, true).ID: return 755;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 3, false).ID: return 756;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 4, true).ID: return 757;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 4, false).ID: return 758;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 5, true).ID: return 759;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 5, false).ID: return 760;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 6, true).ID: return 761;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 6, false).ID: return 762;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 7, true).ID: return 763;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 7, false).ID: return 764;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 8, true).ID: return 765;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 8, false).ID: return 766;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 9, true).ID: return 767;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 9, false).ID: return 768;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 10, true).ID: return 769;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 10, false).ID: return 770;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 11, true).ID: return 771;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 11, false).ID: return 772;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 12, true).ID: return 773;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 12, false).ID: return 774;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 13, true).ID: return 775;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 13, false).ID: return 776;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 14, true).ID: return 777;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 14, false).ID: return 778;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 15, true).ID: return 779;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 15, false).ID: return 780;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 16, true).ID: return 781;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 16, false).ID: return 782;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 17, true).ID: return 783;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 17, false).ID: return 784;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 18, true).ID: return 785;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 18, false).ID: return 786;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 19, true).ID: return 787;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 19, false).ID: return 788;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 20, true).ID: return 789;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 20, false).ID: return 790;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 21, true).ID: return 791;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 21, false).ID: return 792;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 22, true).ID: return 793;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 22, false).ID: return 794;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 23, true).ID: return 795;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 23, false).ID: return 796;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 24, true).ID: return 797;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 24, false).ID: return 798;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 0, true).ID: return 799;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 0, false).ID: return 800;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 1, true).ID: return 801;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 1, false).ID: return 802;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 2, true).ID: return 803;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 2, false).ID: return 804;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 3, true).ID: return 805;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 3, false).ID: return 806;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 4, true).ID: return 807;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 4, false).ID: return 808;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 5, true).ID: return 809;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 5, false).ID: return 810;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 6, true).ID: return 811;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 6, false).ID: return 812;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 7, true).ID: return 813;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 7, false).ID: return 814;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 8, true).ID: return 815;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 8, false).ID: return 816;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 9, true).ID: return 817;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 9, false).ID: return 818;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 10, true).ID: return 819;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 10, false).ID: return 820;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 11, true).ID: return 821;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 11, false).ID: return 822;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 12, true).ID: return 823;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 12, false).ID: return 824;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 13, true).ID: return 825;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 13, false).ID: return 826;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 14, true).ID: return 827;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 14, false).ID: return 828;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 15, true).ID: return 829;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 15, false).ID: return 830;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 16, true).ID: return 831;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 16, false).ID: return 832;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 17, true).ID: return 833;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 17, false).ID: return 834;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 18, true).ID: return 835;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 18, false).ID: return 836;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 19, true).ID: return 837;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 19, false).ID: return 838;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 20, true).ID: return 839;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 20, false).ID: return 840;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 21, true).ID: return 841;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 21, false).ID: return 842;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 22, true).ID: return 843;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 22, false).ID: return 844;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 23, true).ID: return 845;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 23, false).ID: return 846;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 24, true).ID: return 847;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 24, false).ID: return 848;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 0, true).ID: return 849;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 0, false).ID: return 850;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 1, true).ID: return 851;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 1, false).ID: return 852;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 2, true).ID: return 853;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 2, false).ID: return 854;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 3, true).ID: return 855;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 3, false).ID: return 856;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 4, true).ID: return 857;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 4, false).ID: return 858;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 5, true).ID: return 859;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 5, false).ID: return 860;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 6, true).ID: return 861;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 6, false).ID: return 862;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 7, true).ID: return 863;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 7, false).ID: return 864;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 8, true).ID: return 865;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 8, false).ID: return 866;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 9, true).ID: return 867;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 9, false).ID: return 868;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 10, true).ID: return 869;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 10, false).ID: return 870;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 11, true).ID: return 871;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 11, false).ID: return 872;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 12, true).ID: return 873;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 12, false).ID: return 874;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 13, true).ID: return 875;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 13, false).ID: return 876;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 14, true).ID: return 877;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 14, false).ID: return 878;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 15, true).ID: return 879;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 15, false).ID: return 880;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 16, true).ID: return 881;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 16, false).ID: return 882;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 17, true).ID: return 883;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 17, false).ID: return 884;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 18, true).ID: return 885;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 18, false).ID: return 886;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 19, true).ID: return 887;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 19, false).ID: return 888;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 20, true).ID: return 889;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 20, false).ID: return 890;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 21, true).ID: return 891;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 21, false).ID: return 892;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 22, true).ID: return 893;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 22, false).ID: return 894;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 23, true).ID: return 895;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 23, false).ID: return 896;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 24, true).ID: return 897;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 24, false).ID: return 898;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 0, true).ID: return 899;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 0, false).ID: return 900;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 1, true).ID: return 901;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 1, false).ID: return 902;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 2, true).ID: return 903;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 2, false).ID: return 904;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 3, true).ID: return 905;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 3, false).ID: return 906;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 4, true).ID: return 907;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 4, false).ID: return 908;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 5, true).ID: return 909;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 5, false).ID: return 910;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 6, true).ID: return 911;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 6, false).ID: return 912;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 7, true).ID: return 913;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 7, false).ID: return 914;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 8, true).ID: return 915;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 8, false).ID: return 916;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 9, true).ID: return 917;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 9, false).ID: return 918;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 10, true).ID: return 919;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 10, false).ID: return 920;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 11, true).ID: return 921;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 11, false).ID: return 922;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 12, true).ID: return 923;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 12, false).ID: return 924;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 13, true).ID: return 925;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 13, false).ID: return 926;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 14, true).ID: return 927;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 14, false).ID: return 928;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 15, true).ID: return 929;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 15, false).ID: return 930;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 16, true).ID: return 931;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 16, false).ID: return 932;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 17, true).ID: return 933;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 17, false).ID: return 934;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 18, true).ID: return 935;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 18, false).ID: return 936;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 19, true).ID: return 937;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 19, false).ID: return 938;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 20, true).ID: return 939;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 20, false).ID: return 940;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 21, true).ID: return 941;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 21, false).ID: return 942;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 22, true).ID: return 943;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 22, false).ID: return 944;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 23, true).ID: return 945;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 23, false).ID: return 946;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 24, true).ID: return 947;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 24, false).ID: return 948;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 0, true).ID: return 949;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 0, false).ID: return 950;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 1, true).ID: return 951;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 1, false).ID: return 952;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 2, true).ID: return 953;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 2, false).ID: return 954;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 3, true).ID: return 955;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 3, false).ID: return 956;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 4, true).ID: return 957;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 4, false).ID: return 958;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 5, true).ID: return 959;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 5, false).ID: return 960;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 6, true).ID: return 961;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 6, false).ID: return 962;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 7, true).ID: return 963;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 7, false).ID: return 964;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 8, true).ID: return 965;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 8, false).ID: return 966;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 9, true).ID: return 967;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 9, false).ID: return 968;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 10, true).ID: return 969;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 10, false).ID: return 970;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 11, true).ID: return 971;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 11, false).ID: return 972;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 12, true).ID: return 973;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 12, false).ID: return 974;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 13, true).ID: return 975;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 13, false).ID: return 976;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 14, true).ID: return 977;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 14, false).ID: return 978;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 15, true).ID: return 979;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 15, false).ID: return 980;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 16, true).ID: return 981;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 16, false).ID: return 982;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 17, true).ID: return 983;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 17, false).ID: return 984;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 18, true).ID: return 985;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 18, false).ID: return 986;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 19, true).ID: return 987;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 19, false).ID: return 988;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 20, true).ID: return 989;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 20, false).ID: return 990;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 21, true).ID: return 991;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 21, false).ID: return 992;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 22, true).ID: return 993;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 22, false).ID: return 994;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 23, true).ID: return 995;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 23, false).ID: return 996;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 24, true).ID: return 997;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 24, false).ID: return 998;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 0, true).ID: return 999;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 0, false).ID: return 1000;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 1, true).ID: return 1001;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 1, false).ID: return 1002;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 2, true).ID: return 1003;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 2, false).ID: return 1004;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 3, true).ID: return 1005;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 3, false).ID: return 1006;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 4, true).ID: return 1007;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 4, false).ID: return 1008;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 5, true).ID: return 1009;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 5, false).ID: return 1010;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 6, true).ID: return 1011;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 6, false).ID: return 1012;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 7, true).ID: return 1013;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 7, false).ID: return 1014;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 8, true).ID: return 1015;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 8, false).ID: return 1016;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 9, true).ID: return 1017;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 9, false).ID: return 1018;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 10, true).ID: return 1019;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 10, false).ID: return 1020;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 11, true).ID: return 1021;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 11, false).ID: return 1022;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 12, true).ID: return 1023;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 12, false).ID: return 1024;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 13, true).ID: return 1025;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 13, false).ID: return 1026;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 14, true).ID: return 1027;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 14, false).ID: return 1028;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 15, true).ID: return 1029;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 15, false).ID: return 1030;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 16, true).ID: return 1031;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 16, false).ID: return 1032;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 17, true).ID: return 1033;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 17, false).ID: return 1034;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 18, true).ID: return 1035;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 18, false).ID: return 1036;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 19, true).ID: return 1037;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 19, false).ID: return 1038;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 20, true).ID: return 1039;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 20, false).ID: return 1040;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 21, true).ID: return 1041;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 21, false).ID: return 1042;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 22, true).ID: return 1043;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 22, false).ID: return 1044;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 23, true).ID: return 1045;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 23, false).ID: return 1046;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 24, true).ID: return 1047;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 24, false).ID: return 1048;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6346;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6347;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6348;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6349;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 6350;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 6351;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 6352;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 6353;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6354;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6355;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6356;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6357;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 6358;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 6359;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 6360;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 6361;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 6362;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 6363;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 6364;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 6365;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 6366;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 6367;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 6368;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 6369;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3573;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3574;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3575;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3576;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3577;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3578;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3579;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3580;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3581;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3582;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3583;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3584;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3585;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3586;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3587;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3588;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3589;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3590;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3591;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3592;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3593;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3594;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3595;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3596;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3597;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3598;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3599;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3600;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3601;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3602;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3603;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3604;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3605;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3606;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3607;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3608;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3609;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3610;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3611;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3612;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3613;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3614;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3615;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3616;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3617;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3618;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3619;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3620;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3621;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3622;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3623;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3624;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3625;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3626;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3627;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3628;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3629;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3630;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3631;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3632;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3633;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3634;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3635;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3636;
			case OakFence::OakFence(true, true, true, true).ID: return 3968;
			case OakFence::OakFence(true, true, true, false).ID: return 3969;
			case OakFence::OakFence(true, true, false, true).ID: return 3972;
			case OakFence::OakFence(true, true, false, false).ID: return 3973;
			case OakFence::OakFence(true, false, true, true).ID: return 3976;
			case OakFence::OakFence(true, false, true, false).ID: return 3977;
			case OakFence::OakFence(true, false, false, true).ID: return 3980;
			case OakFence::OakFence(true, false, false, false).ID: return 3981;
			case OakFence::OakFence(false, true, true, true).ID: return 3984;
			case OakFence::OakFence(false, true, true, false).ID: return 3985;
			case OakFence::OakFence(false, true, false, true).ID: return 3988;
			case OakFence::OakFence(false, true, false, false).ID: return 3989;
			case OakFence::OakFence(false, false, true, true).ID: return 3992;
			case OakFence::OakFence(false, false, true, false).ID: return 3993;
			case OakFence::OakFence(false, false, false, true).ID: return 3996;
			case OakFence::OakFence(false, false, false, false).ID: return 3997;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 4820;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 4821;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 4822;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 4823;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 4824;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 4825;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 4826;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 4827;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 4828;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 4829;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 4830;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 4831;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 4832;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 4833;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 4834;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 4835;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 4836;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 4837;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 4838;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 4839;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 4840;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 4841;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 4842;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 4843;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 4844;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 4845;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 4846;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 4847;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 4848;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 4849;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 4850;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 4851;
			case OakLeaves::OakLeaves(1, true).ID: return 145;
			case OakLeaves::OakLeaves(1, false).ID: return 146;
			case OakLeaves::OakLeaves(2, true).ID: return 147;
			case OakLeaves::OakLeaves(2, false).ID: return 148;
			case OakLeaves::OakLeaves(3, true).ID: return 149;
			case OakLeaves::OakLeaves(3, false).ID: return 150;
			case OakLeaves::OakLeaves(4, true).ID: return 151;
			case OakLeaves::OakLeaves(4, false).ID: return 152;
			case OakLeaves::OakLeaves(5, true).ID: return 153;
			case OakLeaves::OakLeaves(5, false).ID: return 154;
			case OakLeaves::OakLeaves(6, true).ID: return 155;
			case OakLeaves::OakLeaves(6, false).ID: return 156;
			case OakLeaves::OakLeaves(7, true).ID: return 157;
			case OakLeaves::OakLeaves(7, false).ID: return 158;
			case OakLog::OakLog(OakLog::Axis::X).ID: return 73;
			case OakLog::OakLog(OakLog::Axis::Y).ID: return 74;
			case OakLog::OakLog(OakLog::Axis::Z).ID: return 75;
			case OakPlanks::OakPlanks().ID: return 15;
			case OakPressurePlate::OakPressurePlate(true).ID: return 3873;
			case OakPressurePlate::OakPressurePlate(false).ID: return 3874;
			case OakSapling::OakSapling(0).ID: return 21;
			case OakSapling::OakSapling(1).ID: return 22;
			case OakSign::OakSign(0).ID: return 3382;
			case OakSign::OakSign(1).ID: return 3384;
			case OakSign::OakSign(2).ID: return 3386;
			case OakSign::OakSign(3).ID: return 3388;
			case OakSign::OakSign(4).ID: return 3390;
			case OakSign::OakSign(5).ID: return 3392;
			case OakSign::OakSign(6).ID: return 3394;
			case OakSign::OakSign(7).ID: return 3396;
			case OakSign::OakSign(8).ID: return 3398;
			case OakSign::OakSign(9).ID: return 3400;
			case OakSign::OakSign(10).ID: return 3402;
			case OakSign::OakSign(11).ID: return 3404;
			case OakSign::OakSign(12).ID: return 3406;
			case OakSign::OakSign(13).ID: return 3408;
			case OakSign::OakSign(14).ID: return 3410;
			case OakSign::OakSign(15).ID: return 3412;
			case OakSlab::OakSlab(OakSlab::Type::Top).ID: return 8301;
			case OakSlab::OakSlab(OakSlab::Type::Bottom).ID: return 8303;
			case OakSlab::OakSlab(OakSlab::Type::Double).ID: return 8305;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 1955;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 1957;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 1959;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 1961;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 1963;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 1965;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 1967;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 1969;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 1971;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 1973;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 1975;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 1977;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 1979;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 1981;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 1983;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 1985;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 1987;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 1989;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 1991;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 1993;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 1995;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 1997;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 1999;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 2001;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 2003;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 2005;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 2007;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 2009;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 2011;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 2013;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 2015;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 2017;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 2019;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 2021;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 2023;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 2025;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 2027;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 2029;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 2031;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 2033;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, true, true).ID: return 4112;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, true, false).ID: return 4114;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, false, true).ID: return 4116;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, false, false).ID: return 4118;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, true, true).ID: return 4120;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, true, false).ID: return 4122;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, false, true).ID: return 4124;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, false, false).ID: return 4126;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, true, true).ID: return 4128;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, true, false).ID: return 4130;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, false, true).ID: return 4132;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, false, false).ID: return 4134;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, true, true).ID: return 4136;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, true, false).ID: return 4138;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, false, true).ID: return 4140;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, false, false).ID: return 4142;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, true, true).ID: return 4144;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, true, false).ID: return 4146;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, false, true).ID: return 4148;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, false, false).ID: return 4150;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, true, true).ID: return 4152;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, true, false).ID: return 4154;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, false, true).ID: return 4156;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, false, false).ID: return 4158;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, true, true).ID: return 4160;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, true, false).ID: return 4162;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, false, true).ID: return 4164;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, false, false).ID: return 4166;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, true, true).ID: return 4168;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, true, false).ID: return 4170;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, false, true).ID: return 4172;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, false, false).ID: return 4174;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3736;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3738;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3740;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3742;
			case OakWood::OakWood(OakWood::Axis::X).ID: return 109;
			case OakWood::OakWood(OakWood::Axis::Y).ID: return 110;
			case OakWood::OakWood(OakWood::Axis::Z).ID: return 111;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZM, true).ID: return 9260;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZM, false).ID: return 9261;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XP, true).ID: return 9262;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XP, false).ID: return 9263;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZP, true).ID: return 9264;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZP, false).ID: return 9265;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XM, true).ID: return 9266;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XM, false).ID: return 9267;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YP, true).ID: return 9268;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YP, false).ID: return 9269;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YM, true).ID: return 9270;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YM, false).ID: return 9271;
			case Obsidian::Obsidian().ID: return 1434;
			case OrangeBanner::OrangeBanner(0).ID: return 7913;
			case OrangeBanner::OrangeBanner(1).ID: return 7914;
			case OrangeBanner::OrangeBanner(2).ID: return 7915;
			case OrangeBanner::OrangeBanner(3).ID: return 7916;
			case OrangeBanner::OrangeBanner(4).ID: return 7917;
			case OrangeBanner::OrangeBanner(5).ID: return 7918;
			case OrangeBanner::OrangeBanner(6).ID: return 7919;
			case OrangeBanner::OrangeBanner(7).ID: return 7920;
			case OrangeBanner::OrangeBanner(8).ID: return 7921;
			case OrangeBanner::OrangeBanner(9).ID: return 7922;
			case OrangeBanner::OrangeBanner(10).ID: return 7923;
			case OrangeBanner::OrangeBanner(11).ID: return 7924;
			case OrangeBanner::OrangeBanner(12).ID: return 7925;
			case OrangeBanner::OrangeBanner(13).ID: return 7926;
			case OrangeBanner::OrangeBanner(14).ID: return 7927;
			case OrangeBanner::OrangeBanner(15).ID: return 7928;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, true, OrangeBed::Part::Head).ID: return 1065;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, true, OrangeBed::Part::Foot).ID: return 1066;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, false, OrangeBed::Part::Head).ID: return 1067;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, false, OrangeBed::Part::Foot).ID: return 1068;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, true, OrangeBed::Part::Head).ID: return 1069;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, true, OrangeBed::Part::Foot).ID: return 1070;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, false, OrangeBed::Part::Head).ID: return 1071;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, false, OrangeBed::Part::Foot).ID: return 1072;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, true, OrangeBed::Part::Head).ID: return 1073;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, true, OrangeBed::Part::Foot).ID: return 1074;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, false, OrangeBed::Part::Head).ID: return 1075;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, false, OrangeBed::Part::Foot).ID: return 1076;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, true, OrangeBed::Part::Head).ID: return 1077;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, true, OrangeBed::Part::Foot).ID: return 1078;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, false, OrangeBed::Part::Head).ID: return 1079;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, false, OrangeBed::Part::Foot).ID: return 1080;
			case OrangeCarpet::OrangeCarpet().ID: return 7867;
			case OrangeConcrete::OrangeConcrete().ID: return 9439;
			case OrangeConcretePowder::OrangeConcretePowder().ID: return 9455;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9378;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9379;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9380;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9381;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9284;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9285;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9286;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9287;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9288;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9289;
			case OrangeStainedGlass::OrangeStainedGlass().ID: return 4096;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, true, true).ID: return 6897;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, true, false).ID: return 6898;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, false, true).ID: return 6901;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, false, false).ID: return 6902;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, true, true).ID: return 6905;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, true, false).ID: return 6906;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, false, true).ID: return 6909;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, false, false).ID: return 6910;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, true, true).ID: return 6913;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, true, false).ID: return 6914;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, false, true).ID: return 6917;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, false, false).ID: return 6918;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, true, true).ID: return 6921;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, true, false).ID: return 6922;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, false, true).ID: return 6925;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, false, false).ID: return 6926;
			case OrangeTerracotta::OrangeTerracotta().ID: return 6848;
			case OrangeTulip::OrangeTulip().ID: return 1418;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8157;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8158;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8159;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8160;
			case OrangeWool::OrangeWool().ID: return 1385;
			case OxeyeDaisy::OxeyeDaisy().ID: return 1421;
			case PackedIce::PackedIce().ID: return 7884;
			case Peony::Peony(Peony::Half::Upper).ID: return 7891;
			case Peony::Peony(Peony::Half::Lower).ID: return 7892;
			case PetrifiedOakSlab::PetrifiedOakSlab(PetrifiedOakSlab::Type::Top).ID: return 8361;
			case PetrifiedOakSlab::PetrifiedOakSlab(PetrifiedOakSlab::Type::Bottom).ID: return 8363;
			case PetrifiedOakSlab::PetrifiedOakSlab(PetrifiedOakSlab::Type::Double).ID: return 8365;
			case PinkBanner::PinkBanner(0).ID: return 7993;
			case PinkBanner::PinkBanner(1).ID: return 7994;
			case PinkBanner::PinkBanner(2).ID: return 7995;
			case PinkBanner::PinkBanner(3).ID: return 7996;
			case PinkBanner::PinkBanner(4).ID: return 7997;
			case PinkBanner::PinkBanner(5).ID: return 7998;
			case PinkBanner::PinkBanner(6).ID: return 7999;
			case PinkBanner::PinkBanner(7).ID: return 8000;
			case PinkBanner::PinkBanner(8).ID: return 8001;
			case PinkBanner::PinkBanner(9).ID: return 8002;
			case PinkBanner::PinkBanner(10).ID: return 8003;
			case PinkBanner::PinkBanner(11).ID: return 8004;
			case PinkBanner::PinkBanner(12).ID: return 8005;
			case PinkBanner::PinkBanner(13).ID: return 8006;
			case PinkBanner::PinkBanner(14).ID: return 8007;
			case PinkBanner::PinkBanner(15).ID: return 8008;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, true, PinkBed::Part::Head).ID: return 1145;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, true, PinkBed::Part::Foot).ID: return 1146;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, false, PinkBed::Part::Head).ID: return 1147;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, false, PinkBed::Part::Foot).ID: return 1148;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, true, PinkBed::Part::Head).ID: return 1149;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, true, PinkBed::Part::Foot).ID: return 1150;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, false, PinkBed::Part::Head).ID: return 1151;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, false, PinkBed::Part::Foot).ID: return 1152;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, true, PinkBed::Part::Head).ID: return 1153;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, true, PinkBed::Part::Foot).ID: return 1154;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, false, PinkBed::Part::Head).ID: return 1155;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, false, PinkBed::Part::Foot).ID: return 1156;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, true, PinkBed::Part::Head).ID: return 1157;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, true, PinkBed::Part::Foot).ID: return 1158;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, false, PinkBed::Part::Head).ID: return 1159;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, false, PinkBed::Part::Foot).ID: return 1160;
			case PinkCarpet::PinkCarpet().ID: return 7872;
			case PinkConcrete::PinkConcrete().ID: return 9444;
			case PinkConcretePowder::PinkConcretePowder().ID: return 9460;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9398;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9399;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9400;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9401;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9314;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9315;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9316;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9317;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9318;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9319;
			case PinkStainedGlass::PinkStainedGlass().ID: return 4101;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, true, true).ID: return 7057;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, true, false).ID: return 7058;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, false, true).ID: return 7061;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, false, false).ID: return 7062;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, true, true).ID: return 7065;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, true, false).ID: return 7066;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, false, true).ID: return 7069;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, false, false).ID: return 7070;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, true, true).ID: return 7073;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, true, false).ID: return 7074;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, false, true).ID: return 7077;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, false, false).ID: return 7078;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, true, true).ID: return 7081;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, true, false).ID: return 7082;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, false, true).ID: return 7085;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, false, false).ID: return 7086;
			case PinkTerracotta::PinkTerracotta().ID: return 6853;
			case PinkTulip::PinkTulip().ID: return 1420;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8177;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8178;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8179;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8180;
			case PinkWool::PinkWool().ID: return 1390;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_ZM).ID: return 1348;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_XP).ID: return 1349;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_ZP).ID: return 1350;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_XM).ID: return 1351;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_YP).ID: return 1352;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_YM).ID: return 1353;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_ZM).ID: return 1354;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_XP).ID: return 1355;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_ZP).ID: return 1356;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_XM).ID: return 1357;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_YP).ID: return 1358;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_YM).ID: return 1359;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, true, PistonHead::Type::Normal).ID: return 1360;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, true, PistonHead::Type::Sticky).ID: return 1361;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, false, PistonHead::Type::Normal).ID: return 1362;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, false, PistonHead::Type::Sticky).ID: return 1363;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, true, PistonHead::Type::Normal).ID: return 1364;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, true, PistonHead::Type::Sticky).ID: return 1365;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, false, PistonHead::Type::Normal).ID: return 1366;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, false, PistonHead::Type::Sticky).ID: return 1367;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, true, PistonHead::Type::Normal).ID: return 1368;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, true, PistonHead::Type::Sticky).ID: return 1369;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, false, PistonHead::Type::Normal).ID: return 1370;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, false, PistonHead::Type::Sticky).ID: return 1371;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, true, PistonHead::Type::Normal).ID: return 1372;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, true, PistonHead::Type::Sticky).ID: return 1373;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, false, PistonHead::Type::Normal).ID: return 1374;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, false, PistonHead::Type::Sticky).ID: return 1375;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, true, PistonHead::Type::Normal).ID: return 1376;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, true, PistonHead::Type::Sticky).ID: return 1377;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, false, PistonHead::Type::Normal).ID: return 1378;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, false, PistonHead::Type::Sticky).ID: return 1379;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, true, PistonHead::Type::Normal).ID: return 1380;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, true, PistonHead::Type::Sticky).ID: return 1381;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, false, PistonHead::Type::Normal).ID: return 1382;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, false, PistonHead::Type::Sticky).ID: return 1383;
			case PlayerHead::PlayerHead(0).ID: return 6550;
			case PlayerHead::PlayerHead(1).ID: return 6551;
			case PlayerHead::PlayerHead(2).ID: return 6552;
			case PlayerHead::PlayerHead(3).ID: return 6553;
			case PlayerHead::PlayerHead(4).ID: return 6554;
			case PlayerHead::PlayerHead(5).ID: return 6555;
			case PlayerHead::PlayerHead(6).ID: return 6556;
			case PlayerHead::PlayerHead(7).ID: return 6557;
			case PlayerHead::PlayerHead(8).ID: return 6558;
			case PlayerHead::PlayerHead(9).ID: return 6559;
			case PlayerHead::PlayerHead(10).ID: return 6560;
			case PlayerHead::PlayerHead(11).ID: return 6561;
			case PlayerHead::PlayerHead(12).ID: return 6562;
			case PlayerHead::PlayerHead(13).ID: return 6563;
			case PlayerHead::PlayerHead(14).ID: return 6564;
			case PlayerHead::PlayerHead(15).ID: return 6565;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6566;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6567;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6568;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6569;
			case Podzol::Podzol(true).ID: return 12;
			case Podzol::Podzol(false).ID: return 13;
			case PolishedAndesite::PolishedAndesite().ID: return 7;
			case PolishedAndesiteSlab::PolishedAndesiteSlab(PolishedAndesiteSlab::Type::Top).ID: return 10856;
			case PolishedAndesiteSlab::PolishedAndesiteSlab(PolishedAndesiteSlab::Type::Bottom).ID: return 10858;
			case PolishedAndesiteSlab::PolishedAndesiteSlab(PolishedAndesiteSlab::Type::Double).ID: return 10860;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10630;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10632;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10634;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10636;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10638;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10640;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10642;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10644;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10646;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10648;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10650;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10652;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10654;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10656;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10658;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10660;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10662;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10664;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10666;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10668;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10670;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10672;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10674;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10676;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10678;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10680;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10682;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10684;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10686;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10688;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10690;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10692;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10694;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10696;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10698;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10700;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10702;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10704;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10706;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10708;
			case PolishedBasalt::PolishedBasalt(PolishedBasalt::Axis::X).ID: return 4005;
			case PolishedBasalt::PolishedBasalt(PolishedBasalt::Axis::Y).ID: return 4006;
			case PolishedBasalt::PolishedBasalt(PolishedBasalt::Axis::Z).ID: return 4007;
			case PolishedBlackstone::PolishedBlackstone().ID: return 16250;
			case PolishedBlackstoneBrickSlab::PolishedBlackstoneBrickSlab(PolishedBlackstoneBrickSlab::Type::Top).ID: return 16255;
			case PolishedBlackstoneBrickSlab::PolishedBlackstoneBrickSlab(PolishedBlackstoneBrickSlab::Type::Bottom).ID: return 16257;
			case PolishedBlackstoneBrickSlab::PolishedBlackstoneBrickSlab(PolishedBlackstoneBrickSlab::Type::Double).ID: return 16259;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16261;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16263;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16265;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16267;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16269;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16271;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16273;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16275;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16277;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16279;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16281;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16283;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16285;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16287;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16289;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16291;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16293;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16295;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16297;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16299;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16301;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16303;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16305;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16307;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16309;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16311;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16313;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16315;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16317;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16319;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16321;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16323;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16325;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16327;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Top, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16329;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::Straight).ID: return 16331;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerLeft).ID: return 16333;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::InnerRight).ID: return 16335;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterLeft).ID: return 16337;
			case PolishedBlackstoneBrickStairs::PolishedBlackstoneBrickStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneBrickStairs::Half::Bottom, PolishedBlackstoneBrickStairs::Shape::OuterRight).ID: return 16339;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16343;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16344;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16345;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16349;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16350;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16351;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16355;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16356;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16357;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16361;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16362;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16363;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16367;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16368;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16369;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16373;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16374;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16375;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16379;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16380;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16381;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16385;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16386;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16387;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16391;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16392;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16393;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16397;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16398;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16399;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16403;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16404;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16405;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16409;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16410;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16411;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16415;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16416;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16417;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16421;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16422;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16423;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16427;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16428;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16429;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16433;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16434;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16435;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16439;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16440;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16441;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16445;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16446;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::None, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16447;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16451;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16452;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16453;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16457;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16458;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16459;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16463;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16464;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16465;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16469;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16470;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16471;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16475;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16476;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16477;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16481;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16482;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16483;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16487;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16488;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16489;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16493;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16494;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16495;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16499;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16500;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16501;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16505;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16506;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16507;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16511;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16512;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16513;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16517;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16518;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16519;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16523;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16524;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16525;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16529;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16530;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16531;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16535;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16536;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16537;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16541;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16542;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16543;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16547;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16548;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16549;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16553;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16554;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Low, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16555;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16559;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16560;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16561;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16565;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16566;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16567;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16571;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16572;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16573;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16577;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16578;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16579;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16583;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16584;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16585;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16589;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16590;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::None, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16591;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16595;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16596;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16597;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16601;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16602;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16603;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16607;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16608;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16609;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16613;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16614;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16615;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16619;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16620;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16621;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16625;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16626;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Low, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16627;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::None).ID: return 16631;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16632;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16633;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::None).ID: return 16637;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16638;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::None, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16639;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::None).ID: return 16643;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16644;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16645;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::None).ID: return 16649;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16650;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Low, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16651;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::None).ID: return 16655;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Low).ID: return 16656;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, true, PolishedBlackstoneBrickWall::West::Tall).ID: return 16657;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::None).ID: return 16661;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Low).ID: return 16662;
			case PolishedBlackstoneBrickWall::PolishedBlackstoneBrickWall(PolishedBlackstoneBrickWall::East::Tall, PolishedBlackstoneBrickWall::North::Tall, PolishedBlackstoneBrickWall::South::Tall, false, PolishedBlackstoneBrickWall::West::Tall).ID: return 16663;
			case PolishedBlackstoneBricks::PolishedBlackstoneBricks().ID: return 16251;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 16753;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 16754;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 16755;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 16756;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 16757;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 16758;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 16759;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 16760;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 16761;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 16762;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 16763;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 16764;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 16765;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 16766;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 16767;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 16768;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 16769;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 16770;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 16771;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 16772;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 16773;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 16774;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 16775;
			case PolishedBlackstoneButton::PolishedBlackstoneButton(PolishedBlackstoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 16776;
			case PolishedBlackstonePressurePlate::PolishedBlackstonePressurePlate(true).ID: return 16751;
			case PolishedBlackstonePressurePlate::PolishedBlackstonePressurePlate(false).ID: return 16752;
			case PolishedBlackstoneSlab::PolishedBlackstoneSlab(PolishedBlackstoneSlab::Type::Top).ID: return 16746;
			case PolishedBlackstoneSlab::PolishedBlackstoneSlab(PolishedBlackstoneSlab::Type::Bottom).ID: return 16748;
			case PolishedBlackstoneSlab::PolishedBlackstoneSlab(PolishedBlackstoneSlab::Type::Double).ID: return 16750;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::Straight).ID: return 16666;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16668;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16670;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16672;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16674;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::Straight).ID: return 16676;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16678;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16680;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16682;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16684;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::Straight).ID: return 16686;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16688;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16690;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16692;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16694;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::Straight).ID: return 16696;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16698;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16700;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16702;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_ZP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16704;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::Straight).ID: return 16706;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16708;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16710;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16712;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16714;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::Straight).ID: return 16716;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16718;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16720;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16722;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XM, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16724;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::Straight).ID: return 16726;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16728;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16730;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16732;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Top, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16734;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::Straight).ID: return 16736;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerLeft).ID: return 16738;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::InnerRight).ID: return 16740;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterLeft).ID: return 16742;
			case PolishedBlackstoneStairs::PolishedBlackstoneStairs(eBlockFace::BLOCK_FACE_XP, PolishedBlackstoneStairs::Half::Bottom, PolishedBlackstoneStairs::Shape::OuterRight).ID: return 16744;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16780;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16781;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16782;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 16786;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 16787;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 16788;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 16792;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 16793;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 16794;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 16798;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 16799;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 16800;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 16804;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 16805;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 16806;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 16810;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 16811;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 16812;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16816;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16817;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16818;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 16822;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 16823;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 16824;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 16828;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 16829;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 16830;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 16834;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 16835;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 16836;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 16840;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 16841;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 16842;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 16846;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 16847;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 16848;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16852;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16853;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16854;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 16858;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 16859;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 16860;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 16864;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 16865;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 16866;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 16870;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 16871;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 16872;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 16876;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 16877;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 16878;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 16882;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 16883;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::None, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 16884;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16888;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16889;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16890;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 16894;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 16895;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 16896;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 16900;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 16901;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 16902;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 16906;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 16907;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 16908;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 16912;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 16913;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 16914;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 16918;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 16919;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 16920;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16924;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16925;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16926;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 16930;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 16931;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 16932;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 16936;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 16937;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 16938;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 16942;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 16943;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 16944;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 16948;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 16949;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 16950;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 16954;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 16955;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 16956;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16960;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16961;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16962;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 16966;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 16967;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 16968;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 16972;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 16973;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 16974;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 16978;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 16979;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 16980;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 16984;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 16985;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 16986;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 16990;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 16991;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Low, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 16992;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 16996;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 16997;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 16998;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 17002;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 17003;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 17004;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 17008;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 17009;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 17010;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 17014;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 17015;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 17016;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 17020;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 17021;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 17022;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 17026;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 17027;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::None, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 17028;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 17032;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 17033;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 17034;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 17038;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 17039;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 17040;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 17044;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 17045;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 17046;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 17050;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 17051;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 17052;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 17056;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 17057;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 17058;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 17062;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 17063;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Low, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 17064;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::None).ID: return 17068;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Low).ID: return 17069;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, true, PolishedBlackstoneWall::West::Tall).ID: return 17070;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::None).ID: return 17074;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Low).ID: return 17075;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::None, false, PolishedBlackstoneWall::West::Tall).ID: return 17076;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::None).ID: return 17080;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Low).ID: return 17081;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, true, PolishedBlackstoneWall::West::Tall).ID: return 17082;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::None).ID: return 17086;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Low).ID: return 17087;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Low, false, PolishedBlackstoneWall::West::Tall).ID: return 17088;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::None).ID: return 17092;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Low).ID: return 17093;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, true, PolishedBlackstoneWall::West::Tall).ID: return 17094;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::None).ID: return 17098;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Low).ID: return 17099;
			case PolishedBlackstoneWall::PolishedBlackstoneWall(PolishedBlackstoneWall::East::Tall, PolishedBlackstoneWall::North::Tall, PolishedBlackstoneWall::South::Tall, false, PolishedBlackstoneWall::West::Tall).ID: return 17100;
			case PolishedDiorite::PolishedDiorite().ID: return 5;
			case PolishedDioriteSlab::PolishedDioriteSlab(PolishedDioriteSlab::Type::Top).ID: return 10808;
			case PolishedDioriteSlab::PolishedDioriteSlab(PolishedDioriteSlab::Type::Bottom).ID: return 10810;
			case PolishedDioriteSlab::PolishedDioriteSlab(PolishedDioriteSlab::Type::Double).ID: return 10812;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9910;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9912;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9914;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9916;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9918;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9920;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9922;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9924;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9926;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9928;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9930;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9932;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9934;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9936;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9938;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9940;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9942;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9944;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9946;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9948;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9950;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9952;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9954;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9956;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9958;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9960;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9962;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9964;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9966;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9968;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9970;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9972;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9974;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9976;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9978;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9980;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9982;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9984;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9986;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9988;
			case PolishedGranite::PolishedGranite().ID: return 3;
			case PolishedGraniteSlab::PolishedGraniteSlab(PolishedGraniteSlab::Type::Top).ID: return 10790;
			case PolishedGraniteSlab::PolishedGraniteSlab(PolishedGraniteSlab::Type::Bottom).ID: return 10792;
			case PolishedGraniteSlab::PolishedGraniteSlab(PolishedGraniteSlab::Type::Double).ID: return 10794;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9670;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9672;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9674;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9676;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9678;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9680;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9682;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9684;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9686;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9688;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9690;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9692;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9694;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9696;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9698;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9700;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9702;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9704;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9706;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9708;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9710;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9712;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9714;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9716;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9718;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9720;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9722;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9724;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9726;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9728;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9730;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9732;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9734;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9736;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9738;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9740;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9742;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9744;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9746;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9748;
			case Poppy::Poppy().ID: return 1413;
			case Potatoes::Potatoes(0).ID: return 6338;
			case Potatoes::Potatoes(1).ID: return 6339;
			case Potatoes::Potatoes(2).ID: return 6340;
			case Potatoes::Potatoes(3).ID: return 6341;
			case Potatoes::Potatoes(4).ID: return 6342;
			case Potatoes::Potatoes(5).ID: return 6343;
			case Potatoes::Potatoes(6).ID: return 6344;
			case Potatoes::Potatoes(7).ID: return 6345;
			case PottedAcaciaSapling::PottedAcaciaSapling().ID: return 6310;
			case PottedAllium::PottedAllium().ID: return 6316;
			case PottedAzureBluet::PottedAzureBluet().ID: return 6317;
			case PottedBamboo::PottedBamboo().ID: return 9664;
			case PottedBirchSapling::PottedBirchSapling().ID: return 6308;
			case PottedBlueOrchid::PottedBlueOrchid().ID: return 6315;
			case PottedBrownMushroom::PottedBrownMushroom().ID: return 6327;
			case PottedCactus::PottedCactus().ID: return 6329;
			case PottedCornflower::PottedCornflower().ID: return 6323;
			case PottedCrimsonFungus::PottedCrimsonFungus().ID: return 15834;
			case PottedCrimsonRoots::PottedCrimsonRoots().ID: return 15836;
			case PottedDandelion::PottedDandelion().ID: return 6313;
			case PottedDarkOakSapling::PottedDarkOakSapling().ID: return 6311;
			case PottedDeadBush::PottedDeadBush().ID: return 6328;
			case PottedFern::PottedFern().ID: return 6312;
			case PottedJungleSapling::PottedJungleSapling().ID: return 6309;
			case PottedLilyOfTheValley::PottedLilyOfTheValley().ID: return 6324;
			case PottedOakSapling::PottedOakSapling().ID: return 6306;
			case PottedOrangeTulip::PottedOrangeTulip().ID: return 6319;
			case PottedOxeyeDaisy::PottedOxeyeDaisy().ID: return 6322;
			case PottedPinkTulip::PottedPinkTulip().ID: return 6321;
			case PottedPoppy::PottedPoppy().ID: return 6314;
			case PottedRedMushroom::PottedRedMushroom().ID: return 6326;
			case PottedRedTulip::PottedRedTulip().ID: return 6318;
			case PottedSpruceSapling::PottedSpruceSapling().ID: return 6307;
			case PottedWarpedFungus::PottedWarpedFungus().ID: return 15835;
			case PottedWarpedRoots::PottedWarpedRoots().ID: return 15837;
			case PottedWhiteTulip::PottedWhiteTulip().ID: return 6320;
			case PottedWitherRose::PottedWitherRose().ID: return 6325;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::NorthSouth).ID: return 1305;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::EastWest).ID: return 1306;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingEast).ID: return 1307;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingWest).ID: return 1308;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingNorth).ID: return 1309;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingSouth).ID: return 1310;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::NorthSouth).ID: return 1311;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::EastWest).ID: return 1312;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingEast).ID: return 1313;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingWest).ID: return 1314;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingNorth).ID: return 1315;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingSouth).ID: return 1316;
			case Prismarine::Prismarine().ID: return 7601;
			case PrismarineBrickSlab::PrismarineBrickSlab(PrismarineBrickSlab::Type::Top).ID: return 7851;
			case PrismarineBrickSlab::PrismarineBrickSlab(PrismarineBrickSlab::Type::Bottom).ID: return 7853;
			case PrismarineBrickSlab::PrismarineBrickSlab(PrismarineBrickSlab::Type::Double).ID: return 7855;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7685;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7687;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7689;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7691;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7693;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7695;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7697;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7699;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7701;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7703;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7705;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7707;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7709;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7711;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7713;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7715;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7717;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7719;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7721;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7723;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7725;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7727;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7729;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7731;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7733;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7735;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7737;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7739;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7741;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7743;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7745;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7747;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7749;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7751;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7753;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7755;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7757;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7759;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7761;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7763;
			case PrismarineBricks::PrismarineBricks().ID: return 7602;
			case PrismarineSlab::PrismarineSlab(PrismarineSlab::Type::Top).ID: return 7845;
			case PrismarineSlab::PrismarineSlab(PrismarineSlab::Type::Bottom).ID: return 7847;
			case PrismarineSlab::PrismarineSlab(PrismarineSlab::Type::Double).ID: return 7849;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7605;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7607;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7609;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7611;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7613;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7615;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7617;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7619;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7621;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7623;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7625;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7627;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7629;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7631;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7633;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7635;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7637;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7639;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7641;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7643;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7645;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7647;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7649;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7651;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7653;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7655;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7657;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7659;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7661;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7663;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7665;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7667;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7669;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7671;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7673;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7675;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7677;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7679;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7681;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7683;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11194;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11195;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11196;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11200;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11201;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11202;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11206;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11207;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11208;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11212;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11213;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11214;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11218;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11219;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11220;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11224;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11225;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11226;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11230;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11231;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11232;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11236;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11237;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11238;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11242;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11243;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11244;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11248;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11249;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11250;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11254;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11255;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11256;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11260;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11261;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11262;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11266;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11267;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11268;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11272;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11273;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11274;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11278;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11279;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11280;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11284;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11285;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11286;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11290;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11291;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11292;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11296;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11297;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11298;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11302;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11303;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11304;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11308;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11309;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11310;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11314;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11315;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11316;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11320;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11321;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11322;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11326;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11327;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11328;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11332;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11333;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11334;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11338;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11339;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11340;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11344;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11345;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11346;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11350;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11351;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11352;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11356;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11357;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11358;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11362;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11363;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11364;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11368;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11369;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11370;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11374;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11375;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11376;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11380;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11381;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11382;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11386;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11387;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11388;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11392;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11393;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11394;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11398;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11399;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11400;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11404;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11405;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11406;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11410;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11411;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11412;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11416;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11417;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11418;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11422;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11423;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11424;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11428;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11429;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11430;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11434;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11435;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11436;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11440;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11441;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::None, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11442;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11446;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11447;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11448;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11452;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11453;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11454;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11458;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11459;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11460;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11464;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11465;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11466;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11470;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11471;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11472;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11476;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11477;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Low, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11478;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 11482;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 11483;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::None, true, PrismarineWall::West::Tall).ID: return 11484;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 11488;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 11489;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::None, false, PrismarineWall::West::Tall).ID: return 11490;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 11494;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 11495;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Low, true, PrismarineWall::West::Tall).ID: return 11496;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 11500;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 11501;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Low, false, PrismarineWall::West::Tall).ID: return 11502;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::None).ID: return 11506;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::Low).ID: return 11507;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Tall, true, PrismarineWall::West::Tall).ID: return 11508;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::None).ID: return 11512;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::Low).ID: return 11513;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Tall, PrismarineWall::North::Tall, PrismarineWall::South::Tall, false, PrismarineWall::West::Tall).ID: return 11514;
			case Pumpkin::Pumpkin().ID: return 3998;
			case PumpkinStem::PumpkinStem(0).ID: return 4772;
			case PumpkinStem::PumpkinStem(1).ID: return 4773;
			case PumpkinStem::PumpkinStem(2).ID: return 4774;
			case PumpkinStem::PumpkinStem(3).ID: return 4775;
			case PumpkinStem::PumpkinStem(4).ID: return 4776;
			case PumpkinStem::PumpkinStem(5).ID: return 4777;
			case PumpkinStem::PumpkinStem(6).ID: return 4778;
			case PumpkinStem::PumpkinStem(7).ID: return 4779;
			case PurpleBanner::PurpleBanner(0).ID: return 8057;
			case PurpleBanner::PurpleBanner(1).ID: return 8058;
			case PurpleBanner::PurpleBanner(2).ID: return 8059;
			case PurpleBanner::PurpleBanner(3).ID: return 8060;
			case PurpleBanner::PurpleBanner(4).ID: return 8061;
			case PurpleBanner::PurpleBanner(5).ID: return 8062;
			case PurpleBanner::PurpleBanner(6).ID: return 8063;
			case PurpleBanner::PurpleBanner(7).ID: return 8064;
			case PurpleBanner::PurpleBanner(8).ID: return 8065;
			case PurpleBanner::PurpleBanner(9).ID: return 8066;
			case PurpleBanner::PurpleBanner(10).ID: return 8067;
			case PurpleBanner::PurpleBanner(11).ID: return 8068;
			case PurpleBanner::PurpleBanner(12).ID: return 8069;
			case PurpleBanner::PurpleBanner(13).ID: return 8070;
			case PurpleBanner::PurpleBanner(14).ID: return 8071;
			case PurpleBanner::PurpleBanner(15).ID: return 8072;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, true, PurpleBed::Part::Head).ID: return 1209;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, true, PurpleBed::Part::Foot).ID: return 1210;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, false, PurpleBed::Part::Head).ID: return 1211;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, false, PurpleBed::Part::Foot).ID: return 1212;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, true, PurpleBed::Part::Head).ID: return 1213;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, true, PurpleBed::Part::Foot).ID: return 1214;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, false, PurpleBed::Part::Head).ID: return 1215;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, false, PurpleBed::Part::Foot).ID: return 1216;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, true, PurpleBed::Part::Head).ID: return 1217;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, true, PurpleBed::Part::Foot).ID: return 1218;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, false, PurpleBed::Part::Head).ID: return 1219;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, false, PurpleBed::Part::Foot).ID: return 1220;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, true, PurpleBed::Part::Head).ID: return 1221;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, true, PurpleBed::Part::Foot).ID: return 1222;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, false, PurpleBed::Part::Head).ID: return 1223;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, false, PurpleBed::Part::Foot).ID: return 1224;
			case PurpleCarpet::PurpleCarpet().ID: return 7876;
			case PurpleConcrete::PurpleConcrete().ID: return 9448;
			case PurpleConcretePowder::PurpleConcretePowder().ID: return 9464;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9414;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9415;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9416;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9417;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 9338;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 9339;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 9340;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 9341;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 9342;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 9343;
			case PurpleStainedGlass::PurpleStainedGlass().ID: return 4105;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, true, true).ID: return 7185;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, true, false).ID: return 7186;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, false, true).ID: return 7189;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, false, false).ID: return 7190;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, true, true).ID: return 7193;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, true, false).ID: return 7194;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, false, true).ID: return 7197;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, false, false).ID: return 7198;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, true, true).ID: return 7201;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, true, false).ID: return 7202;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, false, true).ID: return 7205;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, false, false).ID: return 7206;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, true, true).ID: return 7209;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, true, false).ID: return 7210;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, false, true).ID: return 7213;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, false, false).ID: return 7214;
			case PurpleTerracotta::PurpleTerracotta().ID: return 6857;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 8193;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 8194;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 8195;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 8196;
			case PurpleWool::PurpleWool().ID: return 1394;
			case PurpurBlock::PurpurBlock().ID: return 9134;
			case PurpurPillar::PurpurPillar(PurpurPillar::Axis::X).ID: return 9135;
			case PurpurPillar::PurpurPillar(PurpurPillar::Axis::Y).ID: return 9136;
			case PurpurPillar::PurpurPillar(PurpurPillar::Axis::Z).ID: return 9137;
			case PurpurSlab::PurpurSlab(PurpurSlab::Type::Top).ID: return 8409;
			case PurpurSlab::PurpurSlab(PurpurSlab::Type::Bottom).ID: return 8411;
			case PurpurSlab::PurpurSlab(PurpurSlab::Type::Double).ID: return 8413;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 9139;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 9141;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 9143;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 9145;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 9147;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 9149;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 9151;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 9153;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 9155;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 9157;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 9159;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 9161;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 9163;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 9165;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 9167;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 9169;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 9171;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 9173;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 9175;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 9177;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 9179;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 9181;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 9183;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 9185;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 9187;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 9189;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 9191;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 9193;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 9195;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 9197;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 9199;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 9201;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 9203;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 9205;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 9207;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 9209;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 9211;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 9213;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 9215;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 9217;
			case QuartzBlock::QuartzBlock().ID: return 6738;
			case QuartzBricks::QuartzBricks().ID: return 17103;
			case QuartzPillar::QuartzPillar(QuartzPillar::Axis::X).ID: return 6740;
			case QuartzPillar::QuartzPillar(QuartzPillar::Axis::Y).ID: return 6741;
			case QuartzPillar::QuartzPillar(QuartzPillar::Axis::Z).ID: return 6742;
			case QuartzSlab::QuartzSlab(QuartzSlab::Type::Top).ID: return 8391;
			case QuartzSlab::QuartzSlab(QuartzSlab::Type::Bottom).ID: return 8393;
			case QuartzSlab::QuartzSlab(QuartzSlab::Type::Double).ID: return 8395;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6744;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6746;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6748;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6750;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6752;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6754;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6756;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6758;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6760;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6762;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6764;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6766;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6768;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6770;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6772;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6774;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6776;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6778;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6780;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6782;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6784;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6786;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6788;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6790;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6792;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6794;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6796;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6798;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6800;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6802;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6804;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6806;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6808;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6810;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6812;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6814;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6816;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6818;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6820;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6822;
			case Rail::Rail(Rail::Shape::NorthSouth).ID: return 3645;
			case Rail::Rail(Rail::Shape::EastWest).ID: return 3646;
			case Rail::Rail(Rail::Shape::AscendingEast).ID: return 3647;
			case Rail::Rail(Rail::Shape::AscendingWest).ID: return 3648;
			case Rail::Rail(Rail::Shape::AscendingNorth).ID: return 3649;
			case Rail::Rail(Rail::Shape::AscendingSouth).ID: return 3650;
			case Rail::Rail(Rail::Shape::SouthEast).ID: return 3651;
			case Rail::Rail(Rail::Shape::SouthWest).ID: return 3652;
			case Rail::Rail(Rail::Shape::NorthWest).ID: return 3653;
			case Rail::Rail(Rail::Shape::NorthEast).ID: return 3654;
			case RedBanner::RedBanner(0).ID: return 8121;
			case RedBanner::RedBanner(1).ID: return 8122;
			case RedBanner::RedBanner(2).ID: return 8123;
			case RedBanner::RedBanner(3).ID: return 8124;
			case RedBanner::RedBanner(4).ID: return 8125;
			case RedBanner::RedBanner(5).ID: return 8126;
			case RedBanner::RedBanner(6).ID: return 8127;
			case RedBanner::RedBanner(7).ID: return 8128;
			case RedBanner::RedBanner(8).ID: return 8129;
			case RedBanner::RedBanner(9).ID: return 8130;
			case RedBanner::RedBanner(10).ID: return 8131;
			case RedBanner::RedBanner(11).ID: return 8132;
			case RedBanner::RedBanner(12).ID: return 8133;
			case RedBanner::RedBanner(13).ID: return 8134;
			case RedBanner::RedBanner(14).ID: return 8135;
			case RedBanner::RedBanner(15).ID: return 8136;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, true, RedBed::Part::Head).ID: return 1273;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, true, RedBed::Part::Foot).ID: return 1274;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, false, RedBed::Part::Head).ID: return 1275;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, false, RedBed::Part::Foot).ID: return 1276;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, true, RedBed::Part::Head).ID: return 1277;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, true, RedBed::Part::Foot).ID: return 1278;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, false, RedBed::Part::Head).ID: return 1279;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, false, RedBed::Part::Foot).ID: return 1280;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, true, RedBed::Part::Head).ID: return 1281;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, true, RedBed::Part::Foot).ID: return 1282;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, false, RedBed::Part::Head).ID: return 1283;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, false, RedBed::Part::Foot).ID: return 1284;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, true, RedBed::Part::Head).ID: return 1285;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, true, RedBed::Part::Foot).ID: return 1286;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, false, RedBed::Part::Head).ID: return 1287;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, false, RedBed::Part::Foot).ID: return 1288;
			case RedCarpet::RedCarpet().ID: return 7880;
			case RedConcrete::RedConcrete().ID: return 9452;
			case RedConcretePowder::RedConcretePowder().ID: return 9468;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 9430;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 9431;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 9432;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 9433;
			case RedMushroom::RedMushroom().ID: return 1426;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, true, true).ID: return 4569;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, true, false).ID: return 4570;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, false, true).ID: return 4571;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, false, false).ID: return 4572;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, true, true).ID: return 4573;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, true, false).ID: return 4574;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, false, true).ID: return 4575;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, false, false).ID: return 4576;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, true, true).ID: return 4577;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, true, false).ID: return 4578;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, false, true).ID: return 4579;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, false, false).ID: return 4580;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, true, true).ID: return 4581;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, true, false).ID: return 4582;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, false, true).ID: return 4583;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, false, false).ID: return 4584;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, true, true).ID: return 4585;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, true, false).ID: return 4586;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, false, true).ID: return 4587;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, false, false).ID: return 4588;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, true, true).ID: return 4589;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, true, false).ID: return 4590;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, false, true).ID: return 4591;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, false, false).ID: return 4592;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, true, true).ID: return 4593;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, true, false).ID: return 4594;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, false, true).ID: return 4595;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, false, false).ID: return 4596;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, true, true).ID: return 4597;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, true, false).ID: return 4598;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, false, true).ID: return 4599;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, false, false).ID: return 4600;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, true, true).ID: return 4601;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, true, false).ID: return 4602;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, false, true).ID: return 4603;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, false, false).ID: return 4604;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, true, true).ID: return 4605;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, true, false).ID: return 4606;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, false, true).ID: return 4607;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, false, false).ID: return 4608;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, true, true).ID: return 4609;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, true, false).ID: return 4610;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, false, true).ID: return 4611;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, false, false).ID: return 4612;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, true, true).ID: return 4613;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, true, false).ID: return 4614;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, false, true).ID: return 4615;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, false, false).ID: return 4616;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, true, true).ID: return 4617;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, true, false).ID: return 4618;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, false, true).ID: return 4619;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, false, false).ID: return 4620;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, true, true).ID: return 4621;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, true, false).ID: return 4622;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, false, true).ID: return 4623;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, false, false).ID: return 4624;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, true, true).ID: return 4625;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, true, false).ID: return 4626;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, false, true).ID: return 4627;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, false, false).ID: return 4628;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, true, true).ID: return 4629;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, true, false).ID: return 4630;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, false, true).ID: return 4631;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, false, false).ID: return 4632;
			case RedNetherBrickSlab::RedNetherBrickSlab(RedNetherBrickSlab::Type::Top).ID: return 10850;
			case RedNetherBrickSlab::RedNetherBrickSlab(RedNetherBrickSlab::Type::Bottom).ID: return 10852;
			case RedNetherBrickSlab::RedNetherBrickSlab(RedNetherBrickSlab::Type::Double).ID: return 10854;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10550;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10552;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10554;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10556;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10558;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10560;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10562;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10564;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10566;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterRight).ID: return 10568;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10570;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10572;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10574;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10576;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10578;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10580;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10582;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10584;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10586;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterRight).ID: return 10588;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10590;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10592;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10594;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10596;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10598;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10600;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10602;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10604;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10606;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bott