#include "Globals.h"

#include "Palette_1_14.h"
#include "Registries/BlockStates.h"

namespace Palette_1_14
{
	UInt32 From(const BlockState Block)
	{
		using namespace Block;

		switch (Block.ID)
		{
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5906;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5907;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5908;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5909;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 5910;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 5911;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 5912;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 5913;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5914;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5915;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5916;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5917;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 5918;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 5919;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 5920;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 5921;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5922;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5923;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5924;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5925;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 5926;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 5927;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 5928;
			case AcaciaButton::AcaciaButton(AcaciaButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 5929;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8394;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8395;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8396;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8397;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8398;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8399;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8400;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8401;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8402;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8403;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8404;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8405;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8406;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8407;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8408;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8409;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8410;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8411;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8412;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8413;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8414;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8415;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8416;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8417;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8418;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8419;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8420;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8421;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8422;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8423;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8424;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_ZP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8425;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8426;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8427;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8428;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8429;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8430;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8431;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8432;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8433;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8434;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8435;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8436;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8437;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8438;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8439;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8440;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XM, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8441;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, true).ID: return 8442;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, true, false).ID: return 8443;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, true).ID: return 8444;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Left, false, false).ID: return 8445;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, true).ID: return 8446;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, true, false).ID: return 8447;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, true).ID: return 8448;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Upper, AcaciaDoor::Hinge::Right, false, false).ID: return 8449;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, true).ID: return 8450;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, true, false).ID: return 8451;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, true).ID: return 8452;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Left, false, false).ID: return 8453;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, true).ID: return 8454;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, true, false).ID: return 8455;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, true).ID: return 8456;
			case AcaciaDoor::AcaciaDoor(eBlockFace::BLOCK_FACE_XP, AcaciaDoor::Half::Lower, AcaciaDoor::Hinge::Right, false, false).ID: return 8457;
			case AcaciaFence::AcaciaFence(true, true, true, true).ID: return 8140;
			case AcaciaFence::AcaciaFence(true, true, true, false).ID: return 8141;
			case AcaciaFence::AcaciaFence(true, true, false, true).ID: return 8144;
			case AcaciaFence::AcaciaFence(true, true, false, false).ID: return 8145;
			case AcaciaFence::AcaciaFence(true, false, true, true).ID: return 8148;
			case AcaciaFence::AcaciaFence(true, false, true, false).ID: return 8149;
			case AcaciaFence::AcaciaFence(true, false, false, true).ID: return 8152;
			case AcaciaFence::AcaciaFence(true, false, false, false).ID: return 8153;
			case AcaciaFence::AcaciaFence(false, true, true, true).ID: return 8156;
			case AcaciaFence::AcaciaFence(false, true, true, false).ID: return 8157;
			case AcaciaFence::AcaciaFence(false, true, false, true).ID: return 8160;
			case AcaciaFence::AcaciaFence(false, true, false, false).ID: return 8161;
			case AcaciaFence::AcaciaFence(false, false, true, true).ID: return 8164;
			case AcaciaFence::AcaciaFence(false, false, true, false).ID: return 8165;
			case AcaciaFence::AcaciaFence(false, false, false, true).ID: return 8168;
			case AcaciaFence::AcaciaFence(false, false, false, false).ID: return 8169;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 7978;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 7979;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 7980;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 7981;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 7982;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 7983;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 7984;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 7985;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 7986;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 7987;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 7988;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 7989;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 7990;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 7991;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 7992;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 7993;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 7994;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 7995;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 7996;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 7997;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 7998;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 7999;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 8000;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 8001;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 8002;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 8003;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 8004;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 8005;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 8006;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 8007;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 8008;
			case AcaciaFenceGate::AcaciaFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 8009;
			case AcaciaLeaves::AcaciaLeaves(1, true).ID: return 200;
			case AcaciaLeaves::AcaciaLeaves(1, false).ID: return 201;
			case AcaciaLeaves::AcaciaLeaves(2, true).ID: return 202;
			case AcaciaLeaves::AcaciaLeaves(2, false).ID: return 203;
			case AcaciaLeaves::AcaciaLeaves(3, true).ID: return 204;
			case AcaciaLeaves::AcaciaLeaves(3, false).ID: return 205;
			case AcaciaLeaves::AcaciaLeaves(4, true).ID: return 206;
			case AcaciaLeaves::AcaciaLeaves(4, false).ID: return 207;
			case AcaciaLeaves::AcaciaLeaves(5, true).ID: return 208;
			case AcaciaLeaves::AcaciaLeaves(5, false).ID: return 209;
			case AcaciaLeaves::AcaciaLeaves(6, true).ID: return 210;
			case AcaciaLeaves::AcaciaLeaves(6, false).ID: return 211;
			case AcaciaLeaves::AcaciaLeaves(7, true).ID: return 212;
			case AcaciaLeaves::AcaciaLeaves(7, false).ID: return 213;
			case AcaciaLog::AcaciaLog(AcaciaLog::Axis::X).ID: return 84;
			case AcaciaLog::AcaciaLog(AcaciaLog::Axis::Y).ID: return 85;
			case AcaciaLog::AcaciaLog(AcaciaLog::Axis::Z).ID: return 86;
			case AcaciaPlanks::AcaciaPlanks().ID: return 19;
			case AcaciaPressurePlate::AcaciaPressurePlate(true).ID: return 3879;
			case AcaciaPressurePlate::AcaciaPressurePlate(false).ID: return 3880;
			case AcaciaSapling::AcaciaSapling(0).ID: return 29;
			case AcaciaSapling::AcaciaSapling(1).ID: return 30;
			case AcaciaSign::AcaciaSign(0).ID: return 3476;
			case AcaciaSign::AcaciaSign(1).ID: return 3478;
			case AcaciaSign::AcaciaSign(2).ID: return 3480;
			case AcaciaSign::AcaciaSign(3).ID: return 3482;
			case AcaciaSign::AcaciaSign(4).ID: return 3484;
			case AcaciaSign::AcaciaSign(5).ID: return 3486;
			case AcaciaSign::AcaciaSign(6).ID: return 3488;
			case AcaciaSign::AcaciaSign(7).ID: return 3490;
			case AcaciaSign::AcaciaSign(8).ID: return 3492;
			case AcaciaSign::AcaciaSign(9).ID: return 3494;
			case AcaciaSign::AcaciaSign(10).ID: return 3496;
			case AcaciaSign::AcaciaSign(11).ID: return 3498;
			case AcaciaSign::AcaciaSign(12).ID: return 3500;
			case AcaciaSign::AcaciaSign(13).ID: return 3502;
			case AcaciaSign::AcaciaSign(14).ID: return 3504;
			case AcaciaSign::AcaciaSign(15).ID: return 3506;
			case AcaciaSlab::AcaciaSlab(AcaciaSlab::Type::Top).ID: return 7789;
			case AcaciaSlab::AcaciaSlab(AcaciaSlab::Type::Bottom).ID: return 7791;
			case AcaciaSlab::AcaciaSlab(AcaciaSlab::Type::Double).ID: return 7793;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 6840;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 6842;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 6844;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 6846;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 6848;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 6850;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 6852;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 6854;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 6856;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 6858;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 6860;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 6862;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 6864;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 6866;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 6868;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 6870;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 6872;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 6874;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 6876;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_ZP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 6878;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 6880;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 6882;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 6884;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 6886;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 6888;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 6890;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 6892;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 6894;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 6896;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XM, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 6898;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::Straight).ID: return 6900;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerLeft).ID: return 6902;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::InnerRight).ID: return 6904;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterLeft).ID: return 6906;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Top, AcaciaStairs::Shape::OuterRight).ID: return 6908;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::Straight).ID: return 6910;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerLeft).ID: return 6912;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::InnerRight).ID: return 6914;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterLeft).ID: return 6916;
			case AcaciaStairs::AcaciaStairs(eBlockFace::BLOCK_FACE_XP, AcaciaStairs::Half::Bottom, AcaciaStairs::Shape::OuterRight).ID: return 6918;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, true, true).ID: return 4354;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, true, false).ID: return 4356;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, false, true).ID: return 4358;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Top, false, false).ID: return 4360;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4362;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4364;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4366;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZM, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4368;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, true, true).ID: return 4370;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, true, false).ID: return 4372;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, false, true).ID: return 4374;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Top, false, false).ID: return 4376;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4378;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4380;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4382;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_ZP, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4384;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, true, true).ID: return 4386;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, true, false).ID: return 4388;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, false, true).ID: return 4390;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Top, false, false).ID: return 4392;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4394;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4396;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4398;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XM, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4400;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, true, true).ID: return 4402;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, true, false).ID: return 4404;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, false, true).ID: return 4406;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Top, false, false).ID: return 4408;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, true, true).ID: return 4410;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, true, false).ID: return 4412;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, false, true).ID: return 4414;
			case AcaciaTrapdoor::AcaciaTrapdoor(eBlockFace::BLOCK_FACE_XP, AcaciaTrapdoor::Half::Bottom, false, false).ID: return 4416;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3758;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3760;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3762;
			case AcaciaWallSign::AcaciaWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3764;
			case AcaciaWood::AcaciaWood(AcaciaWood::Axis::X).ID: return 120;
			case AcaciaWood::AcaciaWood(AcaciaWood::Axis::Y).ID: return 121;
			case AcaciaWood::AcaciaWood(AcaciaWood::Axis::Z).ID: return 122;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::NorthSouth).ID: return 6287;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::EastWest).ID: return 6288;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingEast).ID: return 6289;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingWest).ID: return 6290;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingNorth).ID: return 6291;
			case ActivatorRail::ActivatorRail(true, ActivatorRail::Shape::AscendingSouth).ID: return 6292;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::NorthSouth).ID: return 6293;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::EastWest).ID: return 6294;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingEast).ID: return 6295;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingWest).ID: return 6296;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingNorth).ID: return 6297;
			case ActivatorRail::ActivatorRail(false, ActivatorRail::Shape::AscendingSouth).ID: return 6298;
			case Air::Air().ID: return -0;
			case Allium::Allium().ID: return 1414;
			case Andesite::Andesite().ID: return 6;
			case AndesiteSlab::AndesiteSlab(AndesiteSlab::Type::Top).ID: return 10308;
			case AndesiteSlab::AndesiteSlab(AndesiteSlab::Type::Bottom).ID: return 10310;
			case AndesiteSlab::AndesiteSlab(AndesiteSlab::Type::Double).ID: return 10312;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 9934;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 9936;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 9938;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 9940;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 9942;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 9944;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 9946;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 9948;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 9950;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 9952;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 9954;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 9956;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 9958;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 9960;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 9962;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 9964;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 9966;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 9968;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 9970;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_ZP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 9972;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 9974;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 9976;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 9978;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 9980;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 9982;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 9984;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 9986;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 9988;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 9990;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XM, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 9992;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::Straight).ID: return 9994;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerLeft).ID: return 9996;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::InnerRight).ID: return 9998;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterLeft).ID: return 10000;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Top, AndesiteStairs::Shape::OuterRight).ID: return 10002;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::Straight).ID: return 10004;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerLeft).ID: return 10006;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::InnerRight).ID: return 10008;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterLeft).ID: return 10010;
			case AndesiteStairs::AndesiteStairs(eBlockFace::BLOCK_FACE_XP, AndesiteStairs::Half::Bottom, AndesiteStairs::Shape::OuterRight).ID: return 10012;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 10781;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 10782;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 10785;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 10786;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 10789;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 10790;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 10793;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 10794;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 10797;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 10798;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 10801;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 10802;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 10805;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 10806;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 10809;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::Low, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 10810;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 10813;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 10814;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 10817;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 10818;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 10821;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 10822;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 10825;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::Low, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 10826;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::Low).ID: return 10829;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, true, AndesiteWall::West::None).ID: return 10830;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::Low).ID: return 10833;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::Low, false, AndesiteWall::West::None).ID: return 10834;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::Low).ID: return 10837;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, true, AndesiteWall::West::None).ID: return 10838;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::Low).ID: return 10841;
			case AndesiteWall::AndesiteWall(AndesiteWall::East::None, AndesiteWall::North::None, AndesiteWall::South::None, false, AndesiteWall::West::None).ID: return 10842;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_ZM).ID: return 6074;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_ZP).ID: return 6075;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_XM).ID: return 6076;
			case Anvil::Anvil(eBlockFace::BLOCK_FACE_XP).ID: return 6077;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_ZM).ID: return 4752;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_ZP).ID: return 4753;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_XM).ID: return 4754;
			case AttachedMelonStem::AttachedMelonStem(eBlockFace::BLOCK_FACE_XP).ID: return 4755;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_ZM).ID: return 4748;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_ZP).ID: return 4749;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_XM).ID: return 4750;
			case AttachedPumpkinStem::AttachedPumpkinStem(eBlockFace::BLOCK_FACE_XP).ID: return 4751;
			case AzureBluet::AzureBluet().ID: return 1415;
			case Bamboo::Bamboo(0, Bamboo::Leaves::None, 0).ID: return 9116;
			case Bamboo::Bamboo(0, Bamboo::Leaves::None, 1).ID: return 9117;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Small, 0).ID: return 9118;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Small, 1).ID: return 9119;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Large, 0).ID: return 9120;
			case Bamboo::Bamboo(0, Bamboo::Leaves::Large, 1).ID: return 9121;
			case Bamboo::Bamboo(1, Bamboo::Leaves::None, 0).ID: return 9122;
			case Bamboo::Bamboo(1, Bamboo::Leaves::None, 1).ID: return 9123;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Small, 0).ID: return 9124;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Small, 1).ID: return 9125;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Large, 0).ID: return 9126;
			case Bamboo::Bamboo(1, Bamboo::Leaves::Large, 1).ID: return 9127;
			case BambooSapling::BambooSapling().ID: return 9115;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZM, true).ID: return 11135;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZM, false).ID: return 11136;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XP, true).ID: return 11137;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XP, false).ID: return 11138;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZP, true).ID: return 11139;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_ZP, false).ID: return 11140;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XM, true).ID: return 11141;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_XM, false).ID: return 11142;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YP, true).ID: return 11143;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YP, false).ID: return 11144;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YM, true).ID: return 11145;
			case Barrel::Barrel(eBlockFace::BLOCK_FACE_YM, false).ID: return 11146;
			case Barrier::Barrier().ID: return 7000;
			case Beacon::Beacon().ID: return 5640;
			case Bedrock::Bedrock().ID: return 33;
			case Beetroots::Beetroots(0).ID: return 8683;
			case Beetroots::Beetroots(1).ID: return 8684;
			case Beetroots::Beetroots(2).ID: return 8685;
			case Beetroots::Beetroots(3).ID: return 8686;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 11198;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 11199;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 11200;
			case Bell::Bell(Bell::Attachment::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 11201;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 11202;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 11203;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 11204;
			case Bell::Bell(Bell::Attachment::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 11205;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 11206;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 11207;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_XM, false).ID: return 11208;
			case Bell::Bell(Bell::Attachment::SingleWall, eBlockFace::BLOCK_FACE_XP, false).ID: return 11209;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 11210;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 11211;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_XM, false).ID: return 11212;
			case Bell::Bell(Bell::Attachment::DoubleWall, eBlockFace::BLOCK_FACE_XP, false).ID: return 11213;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5858;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5859;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5860;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5861;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 5862;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 5863;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 5864;
			case BirchButton::BirchButton(BirchButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 5865;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5866;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5867;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5868;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5869;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 5870;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 5871;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 5872;
			case BirchButton::BirchButton(BirchButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 5873;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5874;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5875;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5876;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5877;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 5878;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 5879;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 5880;
			case BirchButton::BirchButton(BirchButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 5881;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8266;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8267;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8268;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8269;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8270;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8271;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8272;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8273;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8274;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8275;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8276;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8277;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8278;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8279;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8280;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8281;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8282;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8283;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8284;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8285;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8286;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8287;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8288;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8289;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8290;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8291;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8292;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8293;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8294;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8295;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8296;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_ZP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8297;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8298;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8299;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8300;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8301;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8302;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8303;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8304;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8305;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8306;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8307;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8308;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8309;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8310;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8311;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8312;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XM, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8313;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, true).ID: return 8314;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, true, false).ID: return 8315;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, true).ID: return 8316;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Left, false, false).ID: return 8317;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, true).ID: return 8318;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, true, false).ID: return 8319;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, true).ID: return 8320;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Upper, BirchDoor::Hinge::Right, false, false).ID: return 8321;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, true).ID: return 8322;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, true, false).ID: return 8323;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, true).ID: return 8324;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Left, false, false).ID: return 8325;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, true).ID: return 8326;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, true, false).ID: return 8327;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, true).ID: return 8328;
			case BirchDoor::BirchDoor(eBlockFace::BLOCK_FACE_XP, BirchDoor::Half::Lower, BirchDoor::Hinge::Right, false, false).ID: return 8329;
			case BirchFence::BirchFence(true, true, true, true).ID: return 8076;
			case BirchFence::BirchFence(true, true, true, false).ID: return 8077;
			case BirchFence::BirchFence(true, true, false, true).ID: return 8080;
			case BirchFence::BirchFence(true, true, false, false).ID: return 8081;
			case BirchFence::BirchFence(true, false, true, true).ID: return 8084;
			case BirchFence::BirchFence(true, false, true, false).ID: return 8085;
			case BirchFence::BirchFence(true, false, false, true).ID: return 8088;
			case BirchFence::BirchFence(true, false, false, false).ID: return 8089;
			case BirchFence::BirchFence(false, true, true, true).ID: return 8092;
			case BirchFence::BirchFence(false, true, true, false).ID: return 8093;
			case BirchFence::BirchFence(false, true, false, true).ID: return 8096;
			case BirchFence::BirchFence(false, true, false, false).ID: return 8097;
			case BirchFence::BirchFence(false, false, true, true).ID: return 8100;
			case BirchFence::BirchFence(false, false, true, false).ID: return 8101;
			case BirchFence::BirchFence(false, false, false, true).ID: return 8104;
			case BirchFence::BirchFence(false, false, false, false).ID: return 8105;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 7914;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 7915;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 7916;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 7917;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 7918;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 7919;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 7920;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 7921;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 7922;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 7923;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 7924;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 7925;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 7926;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 7927;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 7928;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 7929;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 7930;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 7931;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 7932;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 7933;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 7934;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 7935;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 7936;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 7937;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 7938;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 7939;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 7940;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 7941;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 7942;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 7943;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 7944;
			case BirchFenceGate::BirchFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 7945;
			case BirchLeaves::BirchLeaves(1, true).ID: return 172;
			case BirchLeaves::BirchLeaves(1, false).ID: return 173;
			case BirchLeaves::BirchLeaves(2, true).ID: return 174;
			case BirchLeaves::BirchLeaves(2, false).ID: return 175;
			case BirchLeaves::BirchLeaves(3, true).ID: return 176;
			case BirchLeaves::BirchLeaves(3, false).ID: return 177;
			case BirchLeaves::BirchLeaves(4, true).ID: return 178;
			case BirchLeaves::BirchLeaves(4, false).ID: return 179;
			case BirchLeaves::BirchLeaves(5, true).ID: return 180;
			case BirchLeaves::BirchLeaves(5, false).ID: return 181;
			case BirchLeaves::BirchLeaves(6, true).ID: return 182;
			case BirchLeaves::BirchLeaves(6, false).ID: return 183;
			case BirchLeaves::BirchLeaves(7, true).ID: return 184;
			case BirchLeaves::BirchLeaves(7, false).ID: return 185;
			case BirchLog::BirchLog(BirchLog::Axis::X).ID: return 78;
			case BirchLog::BirchLog(BirchLog::Axis::Y).ID: return 79;
			case BirchLog::BirchLog(BirchLog::Axis::Z).ID: return 80;
			case BirchPlanks::BirchPlanks().ID: return 17;
			case BirchPressurePlate::BirchPressurePlate(true).ID: return 3875;
			case BirchPressurePlate::BirchPressurePlate(false).ID: return 3876;
			case BirchSapling::BirchSapling(0).ID: return 25;
			case BirchSapling::BirchSapling(1).ID: return 26;
			case BirchSign::BirchSign(0).ID: return 3444;
			case BirchSign::BirchSign(1).ID: return 3446;
			case BirchSign::BirchSign(2).ID: return 3448;
			case BirchSign::BirchSign(3).ID: return 3450;
			case BirchSign::BirchSign(4).ID: return 3452;
			case BirchSign::BirchSign(5).ID: return 3454;
			case BirchSign::BirchSign(6).ID: return 3456;
			case BirchSign::BirchSign(7).ID: return 3458;
			case BirchSign::BirchSign(8).ID: return 3460;
			case BirchSign::BirchSign(9).ID: return 3462;
			case BirchSign::BirchSign(10).ID: return 3464;
			case BirchSign::BirchSign(11).ID: return 3466;
			case BirchSign::BirchSign(12).ID: return 3468;
			case BirchSign::BirchSign(13).ID: return 3470;
			case BirchSign::BirchSign(14).ID: return 3472;
			case BirchSign::BirchSign(15).ID: return 3474;
			case BirchSlab::BirchSlab(BirchSlab::Type::Top).ID: return 7777;
			case BirchSlab::BirchSlab(BirchSlab::Type::Bottom).ID: return 7779;
			case BirchSlab::BirchSlab(BirchSlab::Type::Double).ID: return 7781;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5469;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5471;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5473;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5475;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5477;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5479;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5481;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5483;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5485;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5487;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5489;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5491;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5493;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5495;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5497;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5499;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5501;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5503;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5505;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_ZP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5507;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5509;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5511;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5513;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5515;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5517;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5519;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5521;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5523;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5525;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XM, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5527;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::Straight).ID: return 5529;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::InnerLeft).ID: return 5531;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::InnerRight).ID: return 5533;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::OuterLeft).ID: return 5535;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Top, BirchStairs::Shape::OuterRight).ID: return 5537;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::Straight).ID: return 5539;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerLeft).ID: return 5541;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::InnerRight).ID: return 5543;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterLeft).ID: return 5545;
			case BirchStairs::BirchStairs(eBlockFace::BLOCK_FACE_XP, BirchStairs::Half::Bottom, BirchStairs::Shape::OuterRight).ID: return 5547;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, true, true).ID: return 4226;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, true, false).ID: return 4228;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, false, true).ID: return 4230;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Top, false, false).ID: return 4232;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, true, true).ID: return 4234;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, true, false).ID: return 4236;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, false, true).ID: return 4238;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZM, BirchTrapdoor::Half::Bottom, false, false).ID: return 4240;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, true, true).ID: return 4242;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, true, false).ID: return 4244;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, false, true).ID: return 4246;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Top, false, false).ID: return 4248;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, true, true).ID: return 4250;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, true, false).ID: return 4252;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, false, true).ID: return 4254;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_ZP, BirchTrapdoor::Half::Bottom, false, false).ID: return 4256;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, true, true).ID: return 4258;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, true, false).ID: return 4260;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, false, true).ID: return 4262;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Top, false, false).ID: return 4264;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, true, true).ID: return 4266;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, true, false).ID: return 4268;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, false, true).ID: return 4270;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XM, BirchTrapdoor::Half::Bottom, false, false).ID: return 4272;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, true, true).ID: return 4274;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, true, false).ID: return 4276;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, false, true).ID: return 4278;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Top, false, false).ID: return 4280;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, true, true).ID: return 4282;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, true, false).ID: return 4284;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, false, true).ID: return 4286;
			case BirchTrapdoor::BirchTrapdoor(eBlockFace::BLOCK_FACE_XP, BirchTrapdoor::Half::Bottom, false, false).ID: return 4288;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3750;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3752;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3754;
			case BirchWallSign::BirchWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3756;
			case BirchWood::BirchWood(BirchWood::Axis::X).ID: return 114;
			case BirchWood::BirchWood(BirchWood::Axis::Y).ID: return 115;
			case BirchWood::BirchWood(BirchWood::Axis::Z).ID: return 116;
			case BlackBanner::BlackBanner(0).ID: return 7601;
			case BlackBanner::BlackBanner(1).ID: return 7602;
			case BlackBanner::BlackBanner(2).ID: return 7603;
			case BlackBanner::BlackBanner(3).ID: return 7604;
			case BlackBanner::BlackBanner(4).ID: return 7605;
			case BlackBanner::BlackBanner(5).ID: return 7606;
			case BlackBanner::BlackBanner(6).ID: return 7607;
			case BlackBanner::BlackBanner(7).ID: return 7608;
			case BlackBanner::BlackBanner(8).ID: return 7609;
			case BlackBanner::BlackBanner(9).ID: return 7610;
			case BlackBanner::BlackBanner(10).ID: return 7611;
			case BlackBanner::BlackBanner(11).ID: return 7612;
			case BlackBanner::BlackBanner(12).ID: return 7613;
			case BlackBanner::BlackBanner(13).ID: return 7614;
			case BlackBanner::BlackBanner(14).ID: return 7615;
			case BlackBanner::BlackBanner(15).ID: return 7616;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, true, BlackBed::Part::Head).ID: return 1288;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, true, BlackBed::Part::Foot).ID: return 1289;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, false, BlackBed::Part::Head).ID: return 1290;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZM, false, BlackBed::Part::Foot).ID: return 1291;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, true, BlackBed::Part::Head).ID: return 1292;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, true, BlackBed::Part::Foot).ID: return 1293;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, false, BlackBed::Part::Head).ID: return 1294;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_ZP, false, BlackBed::Part::Foot).ID: return 1295;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, true, BlackBed::Part::Head).ID: return 1296;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, true, BlackBed::Part::Foot).ID: return 1297;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, false, BlackBed::Part::Head).ID: return 1298;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XM, false, BlackBed::Part::Foot).ID: return 1299;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, true, BlackBed::Part::Head).ID: return 1300;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, true, BlackBed::Part::Foot).ID: return 1301;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, false, BlackBed::Part::Head).ID: return 1302;
			case BlackBed::BlackBed(eBlockFace::BLOCK_FACE_XP, false, BlackBed::Part::Foot).ID: return 1303;
			case BlackCarpet::BlackCarpet().ID: return 7345;
			case BlackConcrete::BlackConcrete().ID: return 8917;
			case BlackConcretePowder::BlackConcretePowder().ID: return 8933;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8898;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8899;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8900;
			case BlackGlazedTerracotta::BlackGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8901;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8832;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8833;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8834;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8835;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8836;
			case BlackShulkerBox::BlackShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8837;
			case BlackStainedGlass::BlackStainedGlass().ID: return 4096;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, true, true).ID: return 6809;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, true, false).ID: return 6810;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, false, true).ID: return 6813;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, true, false, false).ID: return 6814;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, true, true).ID: return 6817;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, true, false).ID: return 6818;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, false, true).ID: return 6821;
			case BlackStainedGlassPane::BlackStainedGlassPane(true, false, false, false).ID: return 6822;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, true, true).ID: return 6825;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, true, false).ID: return 6826;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, false, true).ID: return 6829;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, true, false, false).ID: return 6830;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, true, true).ID: return 6833;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, true, false).ID: return 6834;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, false, true).ID: return 6837;
			case BlackStainedGlassPane::BlackStainedGlassPane(false, false, false, false).ID: return 6838;
			case BlackTerracotta::BlackTerracotta().ID: return 6326;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7677;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7678;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7679;
			case BlackWallBanner::BlackWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7680;
			case BlackWool::BlackWool().ID: return 1398;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZM, true).ID: return 11155;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZM, false).ID: return 11156;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZP, true).ID: return 11157;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_ZP, false).ID: return 11158;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XM, true).ID: return 11159;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XM, false).ID: return 11160;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XP, true).ID: return 11161;
			case BlastFurnace::BlastFurnace(eBlockFace::BLOCK_FACE_XP, false).ID: return 11162;
			case BlueBanner::BlueBanner(0).ID: return 7537;
			case BlueBanner::BlueBanner(1).ID: return 7538;
			case BlueBanner::BlueBanner(2).ID: return 7539;
			case BlueBanner::BlueBanner(3).ID: return 7540;
			case BlueBanner::BlueBanner(4).ID: return 7541;
			case BlueBanner::BlueBanner(5).ID: return 7542;
			case BlueBanner::BlueBanner(6).ID: return 7543;
			case BlueBanner::BlueBanner(7).ID: return 7544;
			case BlueBanner::BlueBanner(8).ID: return 7545;
			case BlueBanner::BlueBanner(9).ID: return 7546;
			case BlueBanner::BlueBanner(10).ID: return 7547;
			case BlueBanner::BlueBanner(11).ID: return 7548;
			case BlueBanner::BlueBanner(12).ID: return 7549;
			case BlueBanner::BlueBanner(13).ID: return 7550;
			case BlueBanner::BlueBanner(14).ID: return 7551;
			case BlueBanner::BlueBanner(15).ID: return 7552;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, true, BlueBed::Part::Head).ID: return 1224;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, true, BlueBed::Part::Foot).ID: return 1225;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, false, BlueBed::Part::Head).ID: return 1226;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZM, false, BlueBed::Part::Foot).ID: return 1227;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, true, BlueBed::Part::Head).ID: return 1228;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, true, BlueBed::Part::Foot).ID: return 1229;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, false, BlueBed::Part::Head).ID: return 1230;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_ZP, false, BlueBed::Part::Foot).ID: return 1231;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, true, BlueBed::Part::Head).ID: return 1232;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, true, BlueBed::Part::Foot).ID: return 1233;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, false, BlueBed::Part::Head).ID: return 1234;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XM, false, BlueBed::Part::Foot).ID: return 1235;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, true, BlueBed::Part::Head).ID: return 1236;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, true, BlueBed::Part::Foot).ID: return 1237;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, false, BlueBed::Part::Head).ID: return 1238;
			case BlueBed::BlueBed(eBlockFace::BLOCK_FACE_XP, false, BlueBed::Part::Foot).ID: return 1239;
			case BlueCarpet::BlueCarpet().ID: return 7341;
			case BlueConcrete::BlueConcrete().ID: return 8913;
			case BlueConcretePowder::BlueConcretePowder().ID: return 8929;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8882;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8883;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8884;
			case BlueGlazedTerracotta::BlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8885;
			case BlueIce::BlueIce().ID: return 9112;
			case BlueOrchid::BlueOrchid().ID: return 1413;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8808;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8809;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8810;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8811;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8812;
			case BlueShulkerBox::BlueShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8813;
			case BlueStainedGlass::BlueStainedGlass().ID: return 4092;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, true, true).ID: return 6681;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, true, false).ID: return 6682;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, false, true).ID: return 6685;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, true, false, false).ID: return 6686;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, true, true).ID: return 6689;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, true, false).ID: return 6690;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, false, true).ID: return 6693;
			case BlueStainedGlassPane::BlueStainedGlassPane(true, false, false, false).ID: return 6694;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, true, true).ID: return 6697;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, true, false).ID: return 6698;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, false, true).ID: return 6701;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, true, false, false).ID: return 6702;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, true, true).ID: return 6705;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, true, false).ID: return 6706;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, false, true).ID: return 6709;
			case BlueStainedGlassPane::BlueStainedGlassPane(false, false, false, false).ID: return 6710;
			case BlueTerracotta::BlueTerracotta().ID: return 6322;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7661;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7662;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7663;
			case BlueWallBanner::BlueWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7664;
			case BlueWool::BlueWool().ID: return 1394;
			case BoneBlock::BoneBlock(BoneBlock::Axis::X).ID: return 8720;
			case BoneBlock::BoneBlock(BoneBlock::Axis::Y).ID: return 8721;
			case BoneBlock::BoneBlock(BoneBlock::Axis::Z).ID: return 8722;
			case Bookshelf::Bookshelf().ID: return 1431;
			case BrainCoral::BrainCoral().ID: return 8997;
			case BrainCoralBlock::BrainCoralBlock().ID: return 8980;
			case BrainCoralFan::BrainCoralFan().ID: return 9017;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9073;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9075;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9077;
			case BrainCoralWallFan::BrainCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9079;
			case BrewingStand::BrewingStand(true, true, true).ID: return 5117;
			case BrewingStand::BrewingStand(true, true, false).ID: return 5118;
			case BrewingStand::BrewingStand(true, false, true).ID: return 5119;
			case BrewingStand::BrewingStand(true, false, false).ID: return 5120;
			case BrewingStand::BrewingStand(false, true, true).ID: return 5121;
			case BrewingStand::BrewingStand(false, true, false).ID: return 5122;
			case BrewingStand::BrewingStand(false, false, true).ID: return 5123;
			case BrewingStand::BrewingStand(false, false, false).ID: return 5124;
			case BrickSlab::BrickSlab(BrickSlab::Type::Top).ID: return 7837;
			case BrickSlab::BrickSlab(BrickSlab::Type::Bottom).ID: return 7839;
			case BrickSlab::BrickSlab(BrickSlab::Type::Double).ID: return 7841;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4837;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4839;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4841;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4843;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4845;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4847;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4849;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4851;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4853;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4855;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4857;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4859;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4861;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4863;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4865;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4867;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4869;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4871;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4873;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_ZP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4875;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4877;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4879;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4881;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4883;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4885;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4887;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4889;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4891;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4893;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XM, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4895;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::Straight).ID: return 4897;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::InnerLeft).ID: return 4899;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::InnerRight).ID: return 4901;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::OuterLeft).ID: return 4903;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Top, BrickStairs::Shape::OuterRight).ID: return 4905;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::Straight).ID: return 4907;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerLeft).ID: return 4909;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::InnerRight).ID: return 4911;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterLeft).ID: return 4913;
			case BrickStairs::BrickStairs(eBlockFace::BLOCK_FACE_XP, BrickStairs::Half::Bottom, BrickStairs::Shape::OuterRight).ID: return 4915;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10333;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10334;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10337;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10338;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10341;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::None).ID: return 10342;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10345;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::None).ID: return 10346;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10349;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10350;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10353;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10354;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10357;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::None).ID: return 10358;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10361;
			case BrickWall::BrickWall(BrickWall::East::Low, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::None).ID: return 10362;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10365;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10366;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10369;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10370;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10373;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, true, BrickWall::West::None).ID: return 10374;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10377;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::Low, BrickWall::South::None, false, BrickWall::West::None).ID: return 10378;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::Low).ID: return 10381;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, true, BrickWall::West::None).ID: return 10382;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::Low).ID: return 10385;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::Low, false, BrickWall::West::None).ID: return 10386;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::Low).ID: return 10389;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, true, BrickWall::West::None).ID: return 10390;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::Low).ID: return 10393;
			case BrickWall::BrickWall(BrickWall::East::None, BrickWall::North::None, BrickWall::South::None, false, BrickWall::West::None).ID: return 10394;
			case Bricks::Bricks().ID: return 1428;
			case BrownBanner::BrownBanner(0).ID: return 7553;
			case BrownBanner::BrownBanner(1).ID: return 7554;
			case BrownBanner::BrownBanner(2).ID: return 7555;
			case BrownBanner::BrownBanner(3).ID: return 7556;
			case BrownBanner::BrownBanner(4).ID: return 7557;
			case BrownBanner::BrownBanner(5).ID: return 7558;
			case BrownBanner::BrownBanner(6).ID: return 7559;
			case BrownBanner::BrownBanner(7).ID: return 7560;
			case BrownBanner::BrownBanner(8).ID: return 7561;
			case BrownBanner::BrownBanner(9).ID: return 7562;
			case BrownBanner::BrownBanner(10).ID: return 7563;
			case BrownBanner::BrownBanner(11).ID: return 7564;
			case BrownBanner::BrownBanner(12).ID: return 7565;
			case BrownBanner::BrownBanner(13).ID: return 7566;
			case BrownBanner::BrownBanner(14).ID: return 7567;
			case BrownBanner::BrownBanner(15).ID: return 7568;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, true, BrownBed::Part::Head).ID: return 1240;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, true, BrownBed::Part::Foot).ID: return 1241;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, false, BrownBed::Part::Head).ID: return 1242;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZM, false, BrownBed::Part::Foot).ID: return 1243;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, true, BrownBed::Part::Head).ID: return 1244;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, true, BrownBed::Part::Foot).ID: return 1245;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, false, BrownBed::Part::Head).ID: return 1246;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_ZP, false, BrownBed::Part::Foot).ID: return 1247;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, true, BrownBed::Part::Head).ID: return 1248;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, true, BrownBed::Part::Foot).ID: return 1249;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, false, BrownBed::Part::Head).ID: return 1250;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XM, false, BrownBed::Part::Foot).ID: return 1251;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, true, BrownBed::Part::Head).ID: return 1252;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, true, BrownBed::Part::Foot).ID: return 1253;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, false, BrownBed::Part::Head).ID: return 1254;
			case BrownBed::BrownBed(eBlockFace::BLOCK_FACE_XP, false, BrownBed::Part::Foot).ID: return 1255;
			case BrownCarpet::BrownCarpet().ID: return 7342;
			case BrownConcrete::BrownConcrete().ID: return 8914;
			case BrownConcretePowder::BrownConcretePowder().ID: return 8930;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8886;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8887;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8888;
			case BrownGlazedTerracotta::BrownGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8889;
			case BrownMushroom::BrownMushroom().ID: return 1424;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, true, true).ID: return 4491;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, true, false).ID: return 4492;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, false, true).ID: return 4493;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, true, false, false).ID: return 4494;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, true, true).ID: return 4495;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, true, false).ID: return 4496;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, false, true).ID: return 4497;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, true, false, false, false).ID: return 4498;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, true, true).ID: return 4499;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, true, false).ID: return 4500;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, false, true).ID: return 4501;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, true, false, false).ID: return 4502;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, true, true).ID: return 4503;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, true, false).ID: return 4504;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, false, true).ID: return 4505;
			case BrownMushroomBlock::BrownMushroomBlock(true, true, false, false, false, false).ID: return 4506;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, true, true).ID: return 4507;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, true, false).ID: return 4508;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, false, true).ID: return 4509;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, true, false, false).ID: return 4510;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, true, true).ID: return 4511;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, true, false).ID: return 4512;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, false, true).ID: return 4513;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, true, false, false, false).ID: return 4514;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, true, true).ID: return 4515;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, true, false).ID: return 4516;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, false, true).ID: return 4517;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, true, false, false).ID: return 4518;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, true, true).ID: return 4519;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, true, false).ID: return 4520;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, false, true).ID: return 4521;
			case BrownMushroomBlock::BrownMushroomBlock(true, false, false, false, false, false).ID: return 4522;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, true, true).ID: return 4523;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, true, false).ID: return 4524;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, false, true).ID: return 4525;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, true, false, false).ID: return 4526;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, true, true).ID: return 4527;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, true, false).ID: return 4528;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, false, true).ID: return 4529;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, true, false, false, false).ID: return 4530;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, true, true).ID: return 4531;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, true, false).ID: return 4532;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, false, true).ID: return 4533;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, true, false, false).ID: return 4534;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, true, true).ID: return 4535;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, true, false).ID: return 4536;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, false, true).ID: return 4537;
			case BrownMushroomBlock::BrownMushroomBlock(false, true, false, false, false, false).ID: return 4538;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, true, true).ID: return 4539;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, true, false).ID: return 4540;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, false, true).ID: return 4541;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, true, false, false).ID: return 4542;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, true, true).ID: return 4543;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, true, false).ID: return 4544;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, false, true).ID: return 4545;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, true, false, false, false).ID: return 4546;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, true, true).ID: return 4547;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, true, false).ID: return 4548;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, false, true).ID: return 4549;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, true, false, false).ID: return 4550;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, true, true).ID: return 4551;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, true, false).ID: return 4552;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, false, true).ID: return 4553;
			case BrownMushroomBlock::BrownMushroomBlock(false, false, false, false, false, false).ID: return 4554;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8814;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8815;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8816;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8817;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8818;
			case BrownShulkerBox::BrownShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8819;
			case BrownStainedGlass::BrownStainedGlass().ID: return 4093;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, true, true).ID: return 6713;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, true, false).ID: return 6714;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, false, true).ID: return 6717;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, true, false, false).ID: return 6718;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, true, true).ID: return 6721;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, true, false).ID: return 6722;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, false, true).ID: return 6725;
			case BrownStainedGlassPane::BrownStainedGlassPane(true, false, false, false).ID: return 6726;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, true, true).ID: return 6729;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, true, false).ID: return 6730;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, false, true).ID: return 6733;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, true, false, false).ID: return 6734;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, true, true).ID: return 6737;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, true, false).ID: return 6738;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, false, true).ID: return 6741;
			case BrownStainedGlassPane::BrownStainedGlassPane(false, false, false, false).ID: return 6742;
			case BrownTerracotta::BrownTerracotta().ID: return 6323;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7665;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7666;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7667;
			case BrownWallBanner::BrownWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7668;
			case BrownWool::BrownWool().ID: return 1395;
			case BubbleColumn::BubbleColumn(true).ID: return 9131;
			case BubbleColumn::BubbleColumn(false).ID: return 9132;
			case BubbleCoral::BubbleCoral().ID: return 8999;
			case BubbleCoralBlock::BubbleCoralBlock().ID: return 8981;
			case BubbleCoralFan::BubbleCoralFan().ID: return 9019;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9081;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9083;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9085;
			case BubbleCoralWallFan::BubbleCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9087;
			case Cactus::Cactus(0).ID: return 3929;
			case Cactus::Cactus(1).ID: return 3930;
			case Cactus::Cactus(2).ID: return 3931;
			case Cactus::Cactus(3).ID: return 3932;
			case Cactus::Cactus(4).ID: return 3933;
			case Cactus::Cactus(5).ID: return 3934;
			case Cactus::Cactus(6).ID: return 3935;
			case Cactus::Cactus(7).ID: return 3936;
			case Cactus::Cactus(8).ID: return 3937;
			case Cactus::Cactus(9).ID: return 3938;
			case Cactus::Cactus(10).ID: return 3939;
			case Cactus::Cactus(11).ID: return 3940;
			case Cactus::Cactus(12).ID: return 3941;
			case Cactus::Cactus(13).ID: return 3942;
			case Cactus::Cactus(14).ID: return 3943;
			case Cactus::Cactus(15).ID: return 3944;
			case Cake::Cake(0).ID: return 4010;
			case Cake::Cake(1).ID: return 4011;
			case Cake::Cake(2).ID: return 4012;
			case Cake::Cake(3).ID: return 4013;
			case Cake::Cake(4).ID: return 4014;
			case Cake::Cake(5).ID: return 4015;
			case Cake::Cake(6).ID: return 4016;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 11217;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 11219;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 11221;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 11223;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 11225;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 11227;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 11229;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 11231;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, true, true).ID: return 11233;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, true, false).ID: return 11235;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, false, true).ID: return 11237;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XM, false, false).ID: return 11239;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, true, true).ID: return 11241;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, true, false).ID: return 11243;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, false, true).ID: return 11245;
			case Campfire::Campfire(eBlockFace::BLOCK_FACE_XP, false, false).ID: return 11247;
			case Carrots::Carrots(0).ID: return 5794;
			case Carrots::Carrots(1).ID: return 5795;
			case Carrots::Carrots(2).ID: return 5796;
			case Carrots::Carrots(3).ID: return 5797;
			case Carrots::Carrots(4).ID: return 5798;
			case Carrots::Carrots(5).ID: return 5799;
			case Carrots::Carrots(6).ID: return 5800;
			case Carrots::Carrots(7).ID: return 5801;
			case CartographyTable::CartographyTable().ID: return 11163;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_ZM).ID: return 4002;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_ZP).ID: return 4003;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_XM).ID: return 4004;
			case CarvedPumpkin::CarvedPumpkin(eBlockFace::BLOCK_FACE_XP).ID: return 4005;
			case Cauldron::Cauldron(0).ID: return 5125;
			case Cauldron::Cauldron(1).ID: return 5126;
			case Cauldron::Cauldron(2).ID: return 5127;
			case Cauldron::Cauldron(3).ID: return 5128;
			case CaveAir::CaveAir().ID: return 9130;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_ZM).ID: return 8701;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_XP).ID: return 8702;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_ZP).ID: return 8703;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_XM).ID: return 8704;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_YP).ID: return 8705;
			case ChainCommandBlock::ChainCommandBlock(true, eBlockFace::BLOCK_FACE_YM).ID: return 8706;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_ZM).ID: return 8707;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_XP).ID: return 8708;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_ZP).ID: return 8709;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_XM).ID: return 8710;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_YP).ID: return 8711;
			case ChainCommandBlock::ChainCommandBlock(false, eBlockFace::BLOCK_FACE_YM).ID: return 8712;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZM, Chest::Type::Single).ID: return 2033;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZM, Chest::Type::Left).ID: return 2035;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZM, Chest::Type::Right).ID: return 2037;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZP, Chest::Type::Single).ID: return 2039;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZP, Chest::Type::Left).ID: return 2041;
			case Chest::Chest(eBlockFace::BLOCK_FACE_ZP, Chest::Type::Right).ID: return 2043;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XM, Chest::Type::Single).ID: return 2045;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XM, Chest::Type::Left).ID: return 2047;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XM, Chest::Type::Right).ID: return 2049;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XP, Chest::Type::Single).ID: return 2051;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XP, Chest::Type::Left).ID: return 2053;
			case Chest::Chest(eBlockFace::BLOCK_FACE_XP, Chest::Type::Right).ID: return 2055;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_ZM).ID: return 6078;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_ZP).ID: return 6079;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_XM).ID: return 6080;
			case ChippedAnvil::ChippedAnvil(eBlockFace::BLOCK_FACE_XP).ID: return 6081;
			case ChiseledQuartzBlock::ChiseledQuartzBlock().ID: return 6203;
			case ChiseledRedSandstone::ChiseledRedSandstone().ID: return 7682;
			case ChiseledSandstone::ChiseledSandstone().ID: return 246;
			case ChiseledStoneBricks::ChiseledStoneBricks().ID: return 4484;
			case ChorusFlower::ChorusFlower(0).ID: return 8592;
			case ChorusFlower::ChorusFlower(1).ID: return 8593;
			case ChorusFlower::ChorusFlower(2).ID: return 8594;
			case ChorusFlower::ChorusFlower(3).ID: return 8595;
			case ChorusFlower::ChorusFlower(4).ID: return 8596;
			case ChorusFlower::ChorusFlower(5).ID: return 8597;
			case ChorusPlant::ChorusPlant(true, true, true, true, true, true).ID: return 8528;
			case ChorusPlant::ChorusPlant(true, true, true, true, true, false).ID: return 8529;
			case ChorusPlant::ChorusPlant(true, true, true, true, false, true).ID: return 8530;
			case ChorusPlant::ChorusPlant(true, true, true, true, false, false).ID: return 8531;
			case ChorusPlant::ChorusPlant(true, true, true, false, true, true).ID: return 8532;
			case ChorusPlant::ChorusPlant(true, true, true, false, true, false).ID: return 8533;
			case ChorusPlant::ChorusPlant(true, true, true, false, false, true).ID: return 8534;
			case ChorusPlant::ChorusPlant(true, true, true, false, false, false).ID: return 8535;
			case ChorusPlant::ChorusPlant(true, true, false, true, true, true).ID: return 8536;
			case ChorusPlant::ChorusPlant(true, true, false, true, true, false).ID: return 8537;
			case ChorusPlant::ChorusPlant(true, true, false, true, false, true).ID: return 8538;
			case ChorusPlant::ChorusPlant(true, true, false, true, false, false).ID: return 8539;
			case ChorusPlant::ChorusPlant(true, true, false, false, true, true).ID: return 8540;
			case ChorusPlant::ChorusPlant(true, true, false, false, true, false).ID: return 8541;
			case ChorusPlant::ChorusPlant(true, true, false, false, false, true).ID: return 8542;
			case ChorusPlant::ChorusPlant(true, true, false, false, false, false).ID: return 8543;
			case ChorusPlant::ChorusPlant(true, false, true, true, true, true).ID: return 8544;
			case ChorusPlant::ChorusPlant(true, false, true, true, true, false).ID: return 8545;
			case ChorusPlant::ChorusPlant(true, false, true, true, false, true).ID: return 8546;
			case ChorusPlant::ChorusPlant(true, false, true, true, false, false).ID: return 8547;
			case ChorusPlant::ChorusPlant(true, false, true, false, true, true).ID: return 8548;
			case ChorusPlant::ChorusPlant(true, false, true, false, true, false).ID: return 8549;
			case ChorusPlant::ChorusPlant(true, false, true, false, false, true).ID: return 8550;
			case ChorusPlant::ChorusPlant(true, false, true, false, false, false).ID: return 8551;
			case ChorusPlant::ChorusPlant(true, false, false, true, true, true).ID: return 8552;
			case ChorusPlant::ChorusPlant(true, false, false, true, true, false).ID: return 8553;
			case ChorusPlant::ChorusPlant(true, false, false, true, false, true).ID: return 8554;
			case ChorusPlant::ChorusPlant(true, false, false, true, false, false).ID: return 8555;
			case ChorusPlant::ChorusPlant(true, false, false, false, true, true).ID: return 8556;
			case ChorusPlant::ChorusPlant(true, false, false, false, true, false).ID: return 8557;
			case ChorusPlant::ChorusPlant(true, false, false, false, false, true).ID: return 8558;
			case ChorusPlant::ChorusPlant(true, false, false, false, false, false).ID: return 8559;
			case ChorusPlant::ChorusPlant(false, true, true, true, true, true).ID: return 8560;
			case ChorusPlant::ChorusPlant(false, true, true, true, true, false).ID: return 8561;
			case ChorusPlant::ChorusPlant(false, true, true, true, false, true).ID: return 8562;
			case ChorusPlant::ChorusPlant(false, true, true, true, false, false).ID: return 8563;
			case ChorusPlant::ChorusPlant(false, true, true, false, true, true).ID: return 8564;
			case ChorusPlant::ChorusPlant(false, true, true, false, true, false).ID: return 8565;
			case ChorusPlant::ChorusPlant(false, true, true, false, false, true).ID: return 8566;
			case ChorusPlant::ChorusPlant(false, true, true, false, false, false).ID: return 8567;
			case ChorusPlant::ChorusPlant(false, true, false, true, true, true).ID: return 8568;
			case ChorusPlant::ChorusPlant(false, true, false, true, true, false).ID: return 8569;
			case ChorusPlant::ChorusPlant(false, true, false, true, false, true).ID: return 8570;
			case ChorusPlant::ChorusPlant(false, true, false, true, false, false).ID: return 8571;
			case ChorusPlant::ChorusPlant(false, true, false, false, true, true).ID: return 8572;
			case ChorusPlant::ChorusPlant(false, true, false, false, true, false).ID: return 8573;
			case ChorusPlant::ChorusPlant(false, true, false, false, false, true).ID: return 8574;
			case ChorusPlant::ChorusPlant(false, true, false, false, false, false).ID: return 8575;
			case ChorusPlant::ChorusPlant(false, false, true, true, true, true).ID: return 8576;
			case ChorusPlant::ChorusPlant(false, false, true, true, true, false).ID: return 8577;
			case ChorusPlant::ChorusPlant(false, false, true, true, false, true).ID: return 8578;
			case ChorusPlant::ChorusPlant(false, false, true, true, false, false).ID: return 8579;
			case ChorusPlant::ChorusPlant(false, false, true, false, true, true).ID: return 8580;
			case ChorusPlant::ChorusPlant(false, false, true, false, true, false).ID: return 8581;
			case ChorusPlant::ChorusPlant(false, false, true, false, false, true).ID: return 8582;
			case ChorusPlant::ChorusPlant(false, false, true, false, false, false).ID: return 8583;
			case ChorusPlant::ChorusPlant(false, false, false, true, true, true).ID: return 8584;
			case ChorusPlant::ChorusPlant(false, false, false, true, true, false).ID: return 8585;
			case ChorusPlant::ChorusPlant(false, false, false, true, false, true).ID: return 8586;
			case ChorusPlant::ChorusPlant(false, false, false, true, false, false).ID: return 8587;
			case ChorusPlant::ChorusPlant(false, false, false, false, true, true).ID: return 8588;
			case ChorusPlant::ChorusPlant(false, false, false, false, true, false).ID: return 8589;
			case ChorusPlant::ChorusPlant(false, false, false, false, false, true).ID: return 8590;
			case ChorusPlant::ChorusPlant(false, false, false, false, false, false).ID: return 8591;
			case Clay::Clay().ID: return 3945;
			case CoalBlock::CoalBlock().ID: return 7347;
			case CoalOre::CoalOre().ID: return 71;
			case CoarseDirt::CoarseDirt().ID: return 11;
			case Cobblestone::Cobblestone().ID: return 14;
			case CobblestoneSlab::CobblestoneSlab(CobblestoneSlab::Type::Top).ID: return 7831;
			case CobblestoneSlab::CobblestoneSlab(CobblestoneSlab::Type::Bottom).ID: return 7833;
			case CobblestoneSlab::CobblestoneSlab(CobblestoneSlab::Type::Double).ID: return 7835;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3654;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3656;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3658;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3660;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3662;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3664;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3666;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3668;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3670;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3672;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3674;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3676;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3678;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3680;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3682;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3684;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3686;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3688;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3690;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3692;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3694;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3696;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3698;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3700;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3702;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3704;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3706;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3708;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3710;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XM, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3712;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::Straight).ID: return 3714;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerLeft).ID: return 3716;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::InnerRight).ID: return 3718;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterLeft).ID: return 3720;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Top, CobblestoneStairs::Shape::OuterRight).ID: return 3722;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::Straight).ID: return 3724;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerLeft).ID: return 3726;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::InnerRight).ID: return 3728;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterLeft).ID: return 3730;
			case CobblestoneStairs::CobblestoneStairs(eBlockFace::BLOCK_FACE_XP, CobblestoneStairs::Half::Bottom, CobblestoneStairs::Shape::OuterRight).ID: return 3732;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5643;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5644;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5647;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5648;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5651;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5652;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5655;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5656;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5659;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5660;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5663;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5664;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5667;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5668;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5671;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::Low, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5672;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5675;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5676;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5679;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5680;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5683;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5684;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5687;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::Low, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5688;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::Low).ID: return 5691;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, true, CobblestoneWall::West::None).ID: return 5692;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::Low).ID: return 5695;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::Low, false, CobblestoneWall::West::None).ID: return 5696;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::Low).ID: return 5699;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, true, CobblestoneWall::West::None).ID: return 5700;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::Low).ID: return 5703;
			case CobblestoneWall::CobblestoneWall(CobblestoneWall::East::None, CobblestoneWall::North::None, CobblestoneWall::South::None, false, CobblestoneWall::West::None).ID: return 5704;
			case Cobweb::Cobweb().ID: return 1340;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_ZM).ID: return 5142;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_ZP).ID: return 5143;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_XM).ID: return 5144;
			case Cocoa::Cocoa(0, eBlockFace::BLOCK_FACE_XP).ID: return 5145;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_ZM).ID: return 5146;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_ZP).ID: return 5147;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_XM).ID: return 5148;
			case Cocoa::Cocoa(1, eBlockFace::BLOCK_FACE_XP).ID: return 5149;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_ZM).ID: return 5150;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_ZP).ID: return 5151;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_XM).ID: return 5152;
			case Cocoa::Cocoa(2, eBlockFace::BLOCK_FACE_XP).ID: return 5153;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_ZM).ID: return 5628;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_XP).ID: return 5629;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_ZP).ID: return 5630;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_XM).ID: return 5631;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_YP).ID: return 5632;
			case CommandBlock::CommandBlock(true, eBlockFace::BLOCK_FACE_YM).ID: return 5633;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_ZM).ID: return 5634;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_XP).ID: return 5635;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_ZP).ID: return 5636;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_XM).ID: return 5637;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_YP).ID: return 5638;
			case CommandBlock::CommandBlock(false, eBlockFace::BLOCK_FACE_YM).ID: return 5639;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Compare, true).ID: return 6142;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Compare, false).ID: return 6143;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Subtract, true).ID: return 6144;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZM, Comparator::Mode::Subtract, false).ID: return 6145;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Compare, true).ID: return 6146;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Compare, false).ID: return 6147;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Subtract, true).ID: return 6148;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_ZP, Comparator::Mode::Subtract, false).ID: return 6149;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Compare, true).ID: return 6150;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Compare, false).ID: return 6151;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Subtract, true).ID: return 6152;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XM, Comparator::Mode::Subtract, false).ID: return 6153;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Compare, true).ID: return 6154;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Compare, false).ID: return 6155;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Subtract, true).ID: return 6156;
			case Comparator::Comparator(eBlockFace::BLOCK_FACE_XP, Comparator::Mode::Subtract, false).ID: return 6157;
			case Composter::Composter(0).ID: return 11262;
			case Composter::Composter(1).ID: return 11263;
			case Composter::Composter(2).ID: return 11264;
			case Composter::Composter(3).ID: return 11265;
			case Composter::Composter(4).ID: return 11266;
			case Composter::Composter(5).ID: return 11267;
			case Composter::Composter(6).ID: return 11268;
			case Composter::Composter(7).ID: return 11269;
			case Composter::Composter(8).ID: return 11270;
			case Conduit::Conduit().ID: return 9114;
			case Cornflower::Cornflower().ID: return 1421;
			case CrackedStoneBricks::CrackedStoneBricks().ID: return 4483;
			case CraftingTable::CraftingTable().ID: return 3354;
			case CreeperHead::CreeperHead(0).ID: return 6034;
			case CreeperHead::CreeperHead(1).ID: return 6035;
			case CreeperHead::CreeperHead(2).ID: return 6036;
			case CreeperHead::CreeperHead(3).ID: return 6037;
			case CreeperHead::CreeperHead(4).ID: return 6038;
			case CreeperHead::CreeperHead(5).ID: return 6039;
			case CreeperHead::CreeperHead(6).ID: return 6040;
			case CreeperHead::CreeperHead(7).ID: return 6041;
			case CreeperHead::CreeperHead(8).ID: return 6042;
			case CreeperHead::CreeperHead(9).ID: return 6043;
			case CreeperHead::CreeperHead(10).ID: return 6044;
			case CreeperHead::CreeperHead(11).ID: return 6045;
			case CreeperHead::CreeperHead(12).ID: return 6046;
			case CreeperHead::CreeperHead(13).ID: return 6047;
			case CreeperHead::CreeperHead(14).ID: return 6048;
			case CreeperHead::CreeperHead(15).ID: return 6049;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6050;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6051;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6052;
			case CreeperWallHead::CreeperWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6053;
			case CutRedSandstone::CutRedSandstone().ID: return 7683;
			case CutRedSandstoneSlab::CutRedSandstoneSlab(CutRedSandstoneSlab::Type::Top).ID: return 7867;
			case CutRedSandstoneSlab::CutRedSandstoneSlab(CutRedSandstoneSlab::Type::Bottom).ID: return 7869;
			case CutRedSandstoneSlab::CutRedSandstoneSlab(CutRedSandstoneSlab::Type::Double).ID: return 7871;
			case CutSandstone::CutSandstone().ID: return 247;
			case CutSandstoneSlab::CutSandstoneSlab(CutSandstoneSlab::Type::Top).ID: return 7819;
			case CutSandstoneSlab::CutSandstoneSlab(CutSandstoneSlab::Type::Bottom).ID: return 7821;
			case CutSandstoneSlab::CutSandstoneSlab(CutSandstoneSlab::Type::Double).ID: return 7823;
			case CyanBanner::CyanBanner(0).ID: return 7505;
			case CyanBanner::CyanBanner(1).ID: return 7506;
			case CyanBanner::CyanBanner(2).ID: return 7507;
			case CyanBanner::CyanBanner(3).ID: return 7508;
			case CyanBanner::CyanBanner(4).ID: return 7509;
			case CyanBanner::CyanBanner(5).ID: return 7510;
			case CyanBanner::CyanBanner(6).ID: return 7511;
			case CyanBanner::CyanBanner(7).ID: return 7512;
			case CyanBanner::CyanBanner(8).ID: return 7513;
			case CyanBanner::CyanBanner(9).ID: return 7514;
			case CyanBanner::CyanBanner(10).ID: return 7515;
			case CyanBanner::CyanBanner(11).ID: return 7516;
			case CyanBanner::CyanBanner(12).ID: return 7517;
			case CyanBanner::CyanBanner(13).ID: return 7518;
			case CyanBanner::CyanBanner(14).ID: return 7519;
			case CyanBanner::CyanBanner(15).ID: return 7520;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, true, CyanBed::Part::Head).ID: return 1192;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, true, CyanBed::Part::Foot).ID: return 1193;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, false, CyanBed::Part::Head).ID: return 1194;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZM, false, CyanBed::Part::Foot).ID: return 1195;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, true, CyanBed::Part::Head).ID: return 1196;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, true, CyanBed::Part::Foot).ID: return 1197;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, false, CyanBed::Part::Head).ID: return 1198;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_ZP, false, CyanBed::Part::Foot).ID: return 1199;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, true, CyanBed::Part::Head).ID: return 1200;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, true, CyanBed::Part::Foot).ID: return 1201;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, false, CyanBed::Part::Head).ID: return 1202;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XM, false, CyanBed::Part::Foot).ID: return 1203;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, true, CyanBed::Part::Head).ID: return 1204;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, true, CyanBed::Part::Foot).ID: return 1205;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, false, CyanBed::Part::Head).ID: return 1206;
			case CyanBed::CyanBed(eBlockFace::BLOCK_FACE_XP, false, CyanBed::Part::Foot).ID: return 1207;
			case CyanCarpet::CyanCarpet().ID: return 7339;
			case CyanConcrete::CyanConcrete().ID: return 8911;
			case CyanConcretePowder::CyanConcretePowder().ID: return 8927;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8874;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8875;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8876;
			case CyanGlazedTerracotta::CyanGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8877;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8796;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8797;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8798;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8799;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8800;
			case CyanShulkerBox::CyanShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8801;
			case CyanStainedGlass::CyanStainedGlass().ID: return 4090;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, true, true).ID: return 6617;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, true, false).ID: return 6618;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, false, true).ID: return 6621;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, true, false, false).ID: return 6622;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, true, true).ID: return 6625;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, true, false).ID: return 6626;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, false, true).ID: return 6629;
			case CyanStainedGlassPane::CyanStainedGlassPane(true, false, false, false).ID: return 6630;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, true, true).ID: return 6633;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, true, false).ID: return 6634;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, false, true).ID: return 6637;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, true, false, false).ID: return 6638;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, true, true).ID: return 6641;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, true, false).ID: return 6642;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, false, true).ID: return 6645;
			case CyanStainedGlassPane::CyanStainedGlassPane(false, false, false, false).ID: return 6646;
			case CyanTerracotta::CyanTerracotta().ID: return 6320;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7653;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7654;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7655;
			case CyanWallBanner::CyanWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7656;
			case CyanWool::CyanWool().ID: return 1392;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_ZM).ID: return 6082;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_ZP).ID: return 6083;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_XM).ID: return 6084;
			case DamagedAnvil::DamagedAnvil(eBlockFace::BLOCK_FACE_XP).ID: return 6085;
			case Dandelion::Dandelion().ID: return 1411;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5930;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5931;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5932;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5933;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 5934;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 5935;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 5936;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 5937;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5938;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5939;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5940;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5941;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 5942;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 5943;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 5944;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 5945;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5946;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5947;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5948;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5949;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 5950;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 5951;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 5952;
			case DarkOakButton::DarkOakButton(DarkOakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 5953;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 8458;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 8459;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 8460;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 8461;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 8462;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 8463;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 8464;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 8465;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 8466;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 8467;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 8468;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 8469;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 8470;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 8471;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 8472;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 8473;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 8474;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 8475;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 8476;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 8477;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 8478;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 8479;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 8480;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 8481;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 8482;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 8483;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 8484;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 8485;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 8486;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 8487;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 8488;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_ZP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 8489;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 8490;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 8491;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 8492;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 8493;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 8494;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 8495;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 8496;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 8497;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 8498;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 8499;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 8500;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 8501;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 8502;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 8503;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 8504;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XM, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 8505;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, true).ID: return 8506;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, true, false).ID: return 8507;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, true).ID: return 8508;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Left, false, false).ID: return 8509;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, true).ID: return 8510;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, true, false).ID: return 8511;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, true).ID: return 8512;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Upper, DarkOakDoor::Hinge::Right, false, false).ID: return 8513;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, true).ID: return 8514;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, true, false).ID: return 8515;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, true).ID: return 8516;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Left, false, false).ID: return 8517;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, true).ID: return 8518;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, true, false).ID: return 8519;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, true).ID: return 8520;
			case DarkOakDoor::DarkOakDoor(eBlockFace::BLOCK_FACE_XP, DarkOakDoor::Half::Lower, DarkOakDoor::Hinge::Right, false, false).ID: return 8521;
			case DarkOakFence::DarkOakFence(true, true, true, true).ID: return 8172;
			case DarkOakFence::DarkOakFence(true, true, true, false).ID: return 8173;
			case DarkOakFence::DarkOakFence(true, true, false, true).ID: return 8176;
			case DarkOakFence::DarkOakFence(true, true, false, false).ID: return 8177;
			case DarkOakFence::DarkOakFence(true, false, true, true).ID: return 8180;
			case DarkOakFence::DarkOakFence(true, false, true, false).ID: return 8181;
			case DarkOakFence::DarkOakFence(true, false, false, true).ID: return 8184;
			case DarkOakFence::DarkOakFence(true, false, false, false).ID: return 8185;
			case DarkOakFence::DarkOakFence(false, true, true, true).ID: return 8188;
			case DarkOakFence::DarkOakFence(false, true, true, false).ID: return 8189;
			case DarkOakFence::DarkOakFence(false, true, false, true).ID: return 8192;
			case DarkOakFence::DarkOakFence(false, true, false, false).ID: return 8193;
			case DarkOakFence::DarkOakFence(false, false, true, true).ID: return 8196;
			case DarkOakFence::DarkOakFence(false, false, true, false).ID: return 8197;
			case DarkOakFence::DarkOakFence(false, false, false, true).ID: return 8200;
			case DarkOakFence::DarkOakFence(false, false, false, false).ID: return 8201;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 8010;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 8011;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 8012;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 8013;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 8014;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 8015;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 8016;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 8017;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 8018;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 8019;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 8020;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 8021;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 8022;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 8023;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 8024;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 8025;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 8026;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 8027;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 8028;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 8029;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 8030;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 8031;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 8032;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 8033;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 8034;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 8035;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 8036;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 8037;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 8038;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 8039;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 8040;
			case DarkOakFenceGate::DarkOakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 8041;
			case DarkOakLeaves::DarkOakLeaves(1, true).ID: return 214;
			case DarkOakLeaves::DarkOakLeaves(1, false).ID: return 215;
			case DarkOakLeaves::DarkOakLeaves(2, true).ID: return 216;
			case DarkOakLeaves::DarkOakLeaves(2, false).ID: return 217;
			case DarkOakLeaves::DarkOakLeaves(3, true).ID: return 218;
			case DarkOakLeaves::DarkOakLeaves(3, false).ID: return 219;
			case DarkOakLeaves::DarkOakLeaves(4, true).ID: return 220;
			case DarkOakLeaves::DarkOakLeaves(4, false).ID: return 221;
			case DarkOakLeaves::DarkOakLeaves(5, true).ID: return 222;
			case DarkOakLeaves::DarkOakLeaves(5, false).ID: return 223;
			case DarkOakLeaves::DarkOakLeaves(6, true).ID: return 224;
			case DarkOakLeaves::DarkOakLeaves(6, false).ID: return 225;
			case DarkOakLeaves::DarkOakLeaves(7, true).ID: return 226;
			case DarkOakLeaves::DarkOakLeaves(7, false).ID: return 227;
			case DarkOakLog::DarkOakLog(DarkOakLog::Axis::X).ID: return 87;
			case DarkOakLog::DarkOakLog(DarkOakLog::Axis::Y).ID: return 88;
			case DarkOakLog::DarkOakLog(DarkOakLog::Axis::Z).ID: return 89;
			case DarkOakPlanks::DarkOakPlanks().ID: return 20;
			case DarkOakPressurePlate::DarkOakPressurePlate(true).ID: return 3881;
			case DarkOakPressurePlate::DarkOakPressurePlate(false).ID: return 3882;
			case DarkOakSapling::DarkOakSapling(0).ID: return 31;
			case DarkOakSapling::DarkOakSapling(1).ID: return 32;
			case DarkOakSign::DarkOakSign(0).ID: return 3540;
			case DarkOakSign::DarkOakSign(1).ID: return 3542;
			case DarkOakSign::DarkOakSign(2).ID: return 3544;
			case DarkOakSign::DarkOakSign(3).ID: return 3546;
			case DarkOakSign::DarkOakSign(4).ID: return 3548;
			case DarkOakSign::DarkOakSign(5).ID: return 3550;
			case DarkOakSign::DarkOakSign(6).ID: return 3552;
			case DarkOakSign::DarkOakSign(7).ID: return 3554;
			case DarkOakSign::DarkOakSign(8).ID: return 3556;
			case DarkOakSign::DarkOakSign(9).ID: return 3558;
			case DarkOakSign::DarkOakSign(10).ID: return 3560;
			case DarkOakSign::DarkOakSign(11).ID: return 3562;
			case DarkOakSign::DarkOakSign(12).ID: return 3564;
			case DarkOakSign::DarkOakSign(13).ID: return 3566;
			case DarkOakSign::DarkOakSign(14).ID: return 3568;
			case DarkOakSign::DarkOakSign(15).ID: return 3570;
			case DarkOakSlab::DarkOakSlab(DarkOakSlab::Type::Top).ID: return 7795;
			case DarkOakSlab::DarkOakSlab(DarkOakSlab::Type::Bottom).ID: return 7797;
			case DarkOakSlab::DarkOakSlab(DarkOakSlab::Type::Double).ID: return 7799;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 6920;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 6922;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 6924;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 6926;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 6928;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 6930;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 6932;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 6934;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 6936;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 6938;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 6940;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 6942;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 6944;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 6946;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 6948;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 6950;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 6952;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 6954;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 6956;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_ZP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 6958;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 6960;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 6962;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 6964;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 6966;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 6968;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 6970;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 6972;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 6974;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 6976;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XM, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 6978;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::Straight).ID: return 6980;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerLeft).ID: return 6982;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::InnerRight).ID: return 6984;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterLeft).ID: return 6986;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Top, DarkOakStairs::Shape::OuterRight).ID: return 6988;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::Straight).ID: return 6990;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerLeft).ID: return 6992;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::InnerRight).ID: return 6994;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterLeft).ID: return 6996;
			case DarkOakStairs::DarkOakStairs(eBlockFace::BLOCK_FACE_XP, DarkOakStairs::Half::Bottom, DarkOakStairs::Shape::OuterRight).ID: return 6998;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, true, true).ID: return 4418;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, true, false).ID: return 4420;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, false, true).ID: return 4422;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Top, false, false).ID: return 4424;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4426;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4428;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4430;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZM, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4432;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, true, true).ID: return 4434;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, true, false).ID: return 4436;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, false, true).ID: return 4438;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Top, false, false).ID: return 4440;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4442;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4444;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4446;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_ZP, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4448;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, true, true).ID: return 4450;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, true, false).ID: return 4452;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, false, true).ID: return 4454;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Top, false, false).ID: return 4456;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4458;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4460;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4462;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XM, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4464;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, true, true).ID: return 4466;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, true, false).ID: return 4468;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, false, true).ID: return 4470;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Top, false, false).ID: return 4472;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, true, true).ID: return 4474;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, true, false).ID: return 4476;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, false, true).ID: return 4478;
			case DarkOakTrapdoor::DarkOakTrapdoor(eBlockFace::BLOCK_FACE_XP, DarkOakTrapdoor::Half::Bottom, false, false).ID: return 4480;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3774;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3776;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3778;
			case DarkOakWallSign::DarkOakWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3780;
			case DarkOakWood::DarkOakWood(DarkOakWood::Axis::X).ID: return 123;
			case DarkOakWood::DarkOakWood(DarkOakWood::Axis::Y).ID: return 124;
			case DarkOakWood::DarkOakWood(DarkOakWood::Axis::Z).ID: return 125;
			case DarkPrismarine::DarkPrismarine().ID: return 7067;
			case DarkPrismarineSlab::DarkPrismarineSlab(DarkPrismarineSlab::Type::Top).ID: return 7321;
			case DarkPrismarineSlab::DarkPrismarineSlab(DarkPrismarineSlab::Type::Bottom).ID: return 7323;
			case DarkPrismarineSlab::DarkPrismarineSlab(DarkPrismarineSlab::Type::Double).ID: return 7325;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7229;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7231;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7233;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7235;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7237;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7239;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7241;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7243;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7245;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7247;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7249;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7251;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7253;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7255;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7257;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7259;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7261;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7263;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7265;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_ZP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7267;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7269;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7271;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7273;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7275;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7277;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7279;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7281;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7283;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7285;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XM, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7287;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::Straight).ID: return 7289;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7291;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::InnerRight).ID: return 7293;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7295;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Top, DarkPrismarineStairs::Shape::OuterRight).ID: return 7297;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::Straight).ID: return 7299;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerLeft).ID: return 7301;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::InnerRight).ID: return 7303;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterLeft).ID: return 7305;
			case DarkPrismarineStairs::DarkPrismarineStairs(eBlockFace::BLOCK_FACE_XP, DarkPrismarineStairs::Half::Bottom, DarkPrismarineStairs::Shape::OuterRight).ID: return 7307;
			case DaylightDetector::DaylightDetector(true, 0).ID: return 6158;
			case DaylightDetector::DaylightDetector(true, 1).ID: return 6159;
			case DaylightDetector::DaylightDetector(true, 2).ID: return 6160;
			case DaylightDetector::DaylightDetector(true, 3).ID: return 6161;
			case DaylightDetector::DaylightDetector(true, 4).ID: return 6162;
			case DaylightDetector::DaylightDetector(true, 5).ID: return 6163;
			case DaylightDetector::DaylightDetector(true, 6).ID: return 6164;
			case DaylightDetector::DaylightDetector(true, 7).ID: return 6165;
			case DaylightDetector::DaylightDetector(true, 8).ID: return 6166;
			case DaylightDetector::DaylightDetector(true, 9).ID: return 6167;
			case DaylightDetector::DaylightDetector(true, 10).ID: return 6168;
			case DaylightDetector::DaylightDetector(true, 11).ID: return 6169;
			case DaylightDetector::DaylightDetector(true, 12).ID: return 6170;
			case DaylightDetector::DaylightDetector(true, 13).ID: return 6171;
			case DaylightDetector::DaylightDetector(true, 14).ID: return 6172;
			case DaylightDetector::DaylightDetector(true, 15).ID: return 6173;
			case DaylightDetector::DaylightDetector(false, 0).ID: return 6174;
			case DaylightDetector::DaylightDetector(false, 1).ID: return 6175;
			case DaylightDetector::DaylightDetector(false, 2).ID: return 6176;
			case DaylightDetector::DaylightDetector(false, 3).ID: return 6177;
			case DaylightDetector::DaylightDetector(false, 4).ID: return 6178;
			case DaylightDetector::DaylightDetector(false, 5).ID: return 6179;
			case DaylightDetector::DaylightDetector(false, 6).ID: return 6180;
			case DaylightDetector::DaylightDetector(false, 7).ID: return 6181;
			case DaylightDetector::DaylightDetector(false, 8).ID: return 6182;
			case DaylightDetector::DaylightDetector(false, 9).ID: return 6183;
			case DaylightDetector::DaylightDetector(false, 10).ID: return 6184;
			case DaylightDetector::DaylightDetector(false, 11).ID: return 6185;
			case DaylightDetector::DaylightDetector(false, 12).ID: return 6186;
			case DaylightDetector::DaylightDetector(false, 13).ID: return 6187;
			case DaylightDetector::DaylightDetector(false, 14).ID: return 6188;
			case DaylightDetector::DaylightDetector(false, 15).ID: return 6189;
			case DeadBrainCoral::DeadBrainCoral().ID: return 8987;
			case DeadBrainCoralBlock::DeadBrainCoralBlock().ID: return 8975;
			case DeadBrainCoralFan::DeadBrainCoralFan().ID: return 9007;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9033;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9035;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9037;
			case DeadBrainCoralWallFan::DeadBrainCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9039;
			case DeadBubbleCoral::DeadBubbleCoral().ID: return 8989;
			case DeadBubbleCoralBlock::DeadBubbleCoralBlock().ID: return 8976;
			case DeadBubbleCoralFan::DeadBubbleCoralFan().ID: return 9009;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9041;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9043;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9045;
			case DeadBubbleCoralWallFan::DeadBubbleCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9047;
			case DeadBush::DeadBush().ID: return 1343;
			case DeadFireCoral::DeadFireCoral().ID: return 8991;
			case DeadFireCoralBlock::DeadFireCoralBlock().ID: return 8977;
			case DeadFireCoralFan::DeadFireCoralFan().ID: return 9011;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9049;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9051;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9053;
			case DeadFireCoralWallFan::DeadFireCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9055;
			case DeadHornCoral::DeadHornCoral().ID: return 8993;
			case DeadHornCoralBlock::DeadHornCoralBlock().ID: return 8978;
			case DeadHornCoralFan::DeadHornCoralFan().ID: return 9013;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9057;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9059;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9061;
			case DeadHornCoralWallFan::DeadHornCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9063;
			case DeadTubeCoral::DeadTubeCoral().ID: return 8985;
			case DeadTubeCoralBlock::DeadTubeCoralBlock().ID: return 8974;
			case DeadTubeCoralFan::DeadTubeCoralFan().ID: return 9005;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9025;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9027;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9029;
			case DeadTubeCoralWallFan::DeadTubeCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9031;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::NorthSouth).ID: return 1316;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::EastWest).ID: return 1317;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingEast).ID: return 1318;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingWest).ID: return 1319;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingNorth).ID: return 1320;
			case DetectorRail::DetectorRail(true, DetectorRail::Shape::AscendingSouth).ID: return 1321;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::NorthSouth).ID: return 1322;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::EastWest).ID: return 1323;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingEast).ID: return 1324;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingWest).ID: return 1325;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingNorth).ID: return 1326;
			case DetectorRail::DetectorRail(false, DetectorRail::Shape::AscendingSouth).ID: return 1327;
			case DiamondBlock::DiamondBlock().ID: return 3353;
			case DiamondOre::DiamondOre().ID: return 3352;
			case Diorite::Diorite().ID: return 4;
			case DioriteSlab::DioriteSlab(DioriteSlab::Type::Top).ID: return 10326;
			case DioriteSlab::DioriteSlab(DioriteSlab::Type::Bottom).ID: return 10328;
			case DioriteSlab::DioriteSlab(DioriteSlab::Type::Double).ID: return 10330;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10174;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10176;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10178;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10180;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10182;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10184;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10186;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10188;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10190;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10192;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10194;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10196;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10198;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10200;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10202;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10204;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10206;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10208;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10210;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_ZP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10212;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10214;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10216;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10218;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10220;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10222;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10224;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10226;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10228;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10230;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XM, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10232;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::Straight).ID: return 10234;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerLeft).ID: return 10236;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::InnerRight).ID: return 10238;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterLeft).ID: return 10240;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Top, DioriteStairs::Shape::OuterRight).ID: return 10242;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::Straight).ID: return 10244;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerLeft).ID: return 10246;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::InnerRight).ID: return 10248;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterLeft).ID: return 10250;
			case DioriteStairs::DioriteStairs(eBlockFace::BLOCK_FACE_XP, DioriteStairs::Half::Bottom, DioriteStairs::Shape::OuterRight).ID: return 10252;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 11037;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 11038;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 11041;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 11042;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 11045;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 11046;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 11049;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 11050;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 11053;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 11054;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 11057;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 11058;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 11061;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 11062;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 11065;
			case DioriteWall::DioriteWall(DioriteWall::East::Low, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 11066;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 11069;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 11070;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 11073;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 11074;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 11077;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 11078;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 11081;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::Low, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 11082;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::Low).ID: return 11085;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, true, DioriteWall::West::None).ID: return 11086;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::Low).ID: return 11089;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::Low, false, DioriteWall::West::None).ID: return 11090;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::Low).ID: return 11093;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, true, DioriteWall::West::None).ID: return 11094;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::Low).ID: return 11097;
			case DioriteWall::DioriteWall(DioriteWall::East::None, DioriteWall::North::None, DioriteWall::South::None, false, DioriteWall::West::None).ID: return 11098;
			case Dirt::Dirt().ID: return 10;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZM, true).ID: return 233;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZM, false).ID: return 234;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XP, true).ID: return 235;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XP, false).ID: return 236;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZP, true).ID: return 237;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_ZP, false).ID: return 238;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XM, true).ID: return 239;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_XM, false).ID: return 240;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YP, true).ID: return 241;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YP, false).ID: return 242;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YM, true).ID: return 243;
			case Dispenser::Dispenser(eBlockFace::BLOCK_FACE_YM, false).ID: return 244;
			case DragonEgg::DragonEgg().ID: return 5139;
			case DragonHead::DragonHead(0).ID: return 6054;
			case DragonHead::DragonHead(1).ID: return 6055;
			case DragonHead::DragonHead(2).ID: return 6056;
			case DragonHead::DragonHead(3).ID: return 6057;
			case DragonHead::DragonHead(4).ID: return 6058;
			case DragonHead::DragonHead(5).ID: return 6059;
			case DragonHead::DragonHead(6).ID: return 6060;
			case DragonHead::DragonHead(7).ID: return 6061;
			case DragonHead::DragonHead(8).ID: return 6062;
			case DragonHead::DragonHead(9).ID: return 6063;
			case DragonHead::DragonHead(10).ID: return 6064;
			case DragonHead::DragonHead(11).ID: return 6065;
			case DragonHead::DragonHead(12).ID: return 6066;
			case DragonHead::DragonHead(13).ID: return 6067;
			case DragonHead::DragonHead(14).ID: return 6068;
			case DragonHead::DragonHead(15).ID: return 6069;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6070;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6071;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6072;
			case DragonWallHead::DragonWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6073;
			case DriedKelpBlock::DriedKelpBlock().ID: return 8961;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZM, true).ID: return 6299;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZM, false).ID: return 6300;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XP, true).ID: return 6301;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XP, false).ID: return 6302;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZP, true).ID: return 6303;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_ZP, false).ID: return 6304;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XM, true).ID: return 6305;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_XM, false).ID: return 6306;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YP, true).ID: return 6307;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YP, false).ID: return 6308;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YM, true).ID: return 6309;
			case Dropper::Dropper(eBlockFace::BLOCK_FACE_YM, false).ID: return 6310;
			case EmeraldBlock::EmeraldBlock().ID: return 5387;
			case EmeraldOre::EmeraldOre().ID: return 5234;
			case EnchantingTable::EnchantingTable().ID: return 5116;
			case EndGateway::EndGateway().ID: return 8688;
			case EndPortal::EndPortal().ID: return 5129;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_ZM).ID: return 5130;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_ZP).ID: return 5131;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_XM).ID: return 5132;
			case EndPortalFrame::EndPortalFrame(true, eBlockFace::BLOCK_FACE_XP).ID: return 5133;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_ZM).ID: return 5134;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_ZP).ID: return 5135;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_XM).ID: return 5136;
			case EndPortalFrame::EndPortalFrame(false, eBlockFace::BLOCK_FACE_XP).ID: return 5137;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_ZM).ID: return 8522;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_XP).ID: return 8523;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_ZP).ID: return 8524;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_XM).ID: return 8525;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_YP).ID: return 8526;
			case EndRod::EndRod(eBlockFace::BLOCK_FACE_YM).ID: return 8527;
			case EndStone::EndStone().ID: return 5138;
			case EndStoneBrickSlab::EndStoneBrickSlab(EndStoneBrickSlab::Type::Top).ID: return 10284;
			case EndStoneBrickSlab::EndStoneBrickSlab(EndStoneBrickSlab::Type::Bottom).ID: return 10286;
			case EndStoneBrickSlab::EndStoneBrickSlab(EndStoneBrickSlab::Type::Double).ID: return 10288;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 9534;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9536;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 9538;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9540;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 9542;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 9544;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9546;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 9548;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9550;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 9552;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 9554;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9556;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 9558;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9560;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 9562;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 9564;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9566;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 9568;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9570;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 9572;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 9574;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9576;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 9578;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9580;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 9582;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 9584;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9586;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 9588;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9590;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 9592;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::Straight).ID: return 9594;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9596;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::InnerRight).ID: return 9598;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9600;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Top, EndStoneBrickStairs::Shape::OuterRight).ID: return 9602;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::Straight).ID: return 9604;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerLeft).ID: return 9606;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::InnerRight).ID: return 9608;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterLeft).ID: return 9610;
			case EndStoneBrickStairs::EndStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, EndStoneBrickStairs::Half::Bottom, EndStoneBrickStairs::Shape::OuterRight).ID: return 9612;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 10973;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 10974;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 10977;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 10978;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 10981;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 10982;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 10985;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 10986;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 10989;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 10990;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 10993;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 10994;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 10997;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 10998;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 11001;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::Low, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 11002;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 11005;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 11006;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 11009;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 11010;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 11013;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 11014;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 11017;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::Low, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 11018;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::Low).ID: return 11021;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, true, EndStoneBrickWall::West::None).ID: return 11022;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::Low).ID: return 11025;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::Low, false, EndStoneBrickWall::West::None).ID: return 11026;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::Low).ID: return 11029;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, true, EndStoneBrickWall::West::None).ID: return 11030;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::Low).ID: return 11033;
			case EndStoneBrickWall::EndStoneBrickWall(EndStoneBrickWall::East::None, EndStoneBrickWall::North::None, EndStoneBrickWall::South::None, false, EndStoneBrickWall::West::None).ID: return 11034;
			case EndStoneBricks::EndStoneBricks().ID: return 8682;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_ZM).ID: return 5236;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_ZP).ID: return 5238;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_XM).ID: return 5240;
			case EnderChest::EnderChest(eBlockFace::BLOCK_FACE_XP).ID: return 5242;
			case Farmland::Farmland(0).ID: return 3363;
			case Farmland::Farmland(1).ID: return 3364;
			case Farmland::Farmland(2).ID: return 3365;
			case Farmland::Farmland(3).ID: return 3366;
			case Farmland::Farmland(4).ID: return 3367;
			case Farmland::Farmland(5).ID: return 3368;
			case Farmland::Farmland(6).ID: return 3369;
			case Farmland::Farmland(7).ID: return 3370;
			case Fern::Fern().ID: return 1342;
			case Fire::Fire(0, true, true, true, true, true).ID: return 1439;
			case Fire::Fire(0, true, true, true, true, false).ID: return 1440;
			case Fire::Fire(0, true, true, true, false, true).ID: return 1441;
			case Fire::Fire(0, true, true, true, false, false).ID: return 1442;
			case Fire::Fire(0, true, true, false, true, true).ID: return 1443;
			case Fire::Fire(0, true, true, false, true, false).ID: return 1444;
			case Fire::Fire(0, true, true, false, false, true).ID: return 1445;
			case Fire::Fire(0, true, true, false, false, false).ID: return 1446;
			case Fire::Fire(0, true, false, true, true, true).ID: return 1447;
			case Fire::Fire(0, true, false, true, true, false).ID: return 1448;
			case Fire::Fire(0, true, false, true, false, true).ID: return 1449;
			case Fire::Fire(0, true, false, true, false, false).ID: return 1450;
			case Fire::Fire(0, true, false, false, true, true).ID: return 1451;
			case Fire::Fire(0, true, false, false, true, false).ID: return 1452;
			case Fire::Fire(0, true, false, false, false, true).ID: return 1453;
			case Fire::Fire(0, true, false, false, false, false).ID: return 1454;
			case Fire::Fire(0, false, true, true, true, true).ID: return 1455;
			case Fire::Fire(0, false, true, true, true, false).ID: return 1456;
			case Fire::Fire(0, false, true, true, false, true).ID: return 1457;
			case Fire::Fire(0, false, true, true, false, false).ID: return 1458;
			case Fire::Fire(0, false, true, false, true, true).ID: return 1459;
			case Fire::Fire(0, false, true, false, true, false).ID: return 1460;
			case Fire::Fire(0, false, true, false, false, true).ID: return 1461;
			case Fire::Fire(0, false, true, false, false, false).ID: return 1462;
			case Fire::Fire(0, false, false, true, true, true).ID: return 1463;
			case Fire::Fire(0, false, false, true, true, false).ID: return 1464;
			case Fire::Fire(0, false, false, true, false, true).ID: return 1465;
			case Fire::Fire(0, false, false, true, false, false).ID: return 1466;
			case Fire::Fire(0, false, false, false, true, true).ID: return 1467;
			case Fire::Fire(0, false, false, false, true, false).ID: return 1468;
			case Fire::Fire(0, false, false, false, false, true).ID: return 1469;
			case Fire::Fire(0, false, false, false, false, false).ID: return 1470;
			case Fire::Fire(1, true, true, true, true, true).ID: return 1471;
			case Fire::Fire(1, true, true, true, true, false).ID: return 1472;
			case Fire::Fire(1, true, true, true, false, true).ID: return 1473;
			case Fire::Fire(1, true, true, true, false, false).ID: return 1474;
			case Fire::Fire(1, true, true, false, true, true).ID: return 1475;
			case Fire::Fire(1, true, true, false, true, false).ID: return 1476;
			case Fire::Fire(1, true, true, false, false, true).ID: return 1477;
			case Fire::Fire(1, true, true, false, false, false).ID: return 1478;
			case Fire::Fire(1, true, false, true, true, true).ID: return 1479;
			case Fire::Fire(1, true, false, true, true, false).ID: return 1480;
			case Fire::Fire(1, true, false, true, false, true).ID: return 1481;
			case Fire::Fire(1, true, false, true, false, false).ID: return 1482;
			case Fire::Fire(1, true, false, false, true, true).ID: return 1483;
			case Fire::Fire(1, true, false, false, true, false).ID: return 1484;
			case Fire::Fire(1, true, false, false, false, true).ID: return 1485;
			case Fire::Fire(1, true, false, false, false, false).ID: return 1486;
			case Fire::Fire(1, false, true, true, true, true).ID: return 1487;
			case Fire::Fire(1, false, true, true, true, false).ID: return 1488;
			case Fire::Fire(1, false, true, true, false, true).ID: return 1489;
			case Fire::Fire(1, false, true, true, false, false).ID: return 1490;
			case Fire::Fire(1, false, true, false, true, true).ID: return 1491;
			case Fire::Fire(1, false, true, false, true, false).ID: return 1492;
			case Fire::Fire(1, false, true, false, false, true).ID: return 1493;
			case Fire::Fire(1, false, true, false, false, false).ID: return 1494;
			case Fire::Fire(1, false, false, true, true, true).ID: return 1495;
			case Fire::Fire(1, false, false, true, true, false).ID: return 1496;
			case Fire::Fire(1, false, false, true, false, true).ID: return 1497;
			case Fire::Fire(1, false, false, true, false, false).ID: return 1498;
			case Fire::Fire(1, false, false, false, true, true).ID: return 1499;
			case Fire::Fire(1, false, false, false, true, false).ID: return 1500;
			case Fire::Fire(1, false, false, false, false, true).ID: return 1501;
			case Fire::Fire(1, false, false, false, false, false).ID: return 1502;
			case Fire::Fire(2, true, true, true, true, true).ID: return 1503;
			case Fire::Fire(2, true, true, true, true, false).ID: return 1504;
			case Fire::Fire(2, true, true, true, false, true).ID: return 1505;
			case Fire::Fire(2, true, true, true, false, false).ID: return 1506;
			case Fire::Fire(2, true, true, false, true, true).ID: return 1507;
			case Fire::Fire(2, true, true, false, true, false).ID: return 1508;
			case Fire::Fire(2, true, true, false, false, true).ID: return 1509;
			case Fire::Fire(2, true, true, false, false, false).ID: return 1510;
			case Fire::Fire(2, true, false, true, true, true).ID: return 1511;
			case Fire::Fire(2, true, false, true, true, false).ID: return 1512;
			case Fire::Fire(2, true, false, true, false, true).ID: return 1513;
			case Fire::Fire(2, true, false, true, false, false).ID: return 1514;
			case Fire::Fire(2, true, false, false, true, true).ID: return 1515;
			case Fire::Fire(2, true, false, false, true, false).ID: return 1516;
			case Fire::Fire(2, true, false, false, false, true).ID: return 1517;
			case Fire::Fire(2, true, false, false, false, false).ID: return 1518;
			case Fire::Fire(2, false, true, true, true, true).ID: return 1519;
			case Fire::Fire(2, false, true, true, true, false).ID: return 1520;
			case Fire::Fire(2, false, true, true, false, true).ID: return 1521;
			case Fire::Fire(2, false, true, true, false, false).ID: return 1522;
			case Fire::Fire(2, false, true, false, true, true).ID: return 1523;
			case Fire::Fire(2, false, true, false, true, false).ID: return 1524;
			case Fire::Fire(2, false, true, false, false, true).ID: return 1525;
			case Fire::Fire(2, false, true, false, false, false).ID: return 1526;
			case Fire::Fire(2, false, false, true, true, true).ID: return 1527;
			case Fire::Fire(2, false, false, true, true, false).ID: return 1528;
			case Fire::Fire(2, false, false, true, false, true).ID: return 1529;
			case Fire::Fire(2, false, false, true, false, false).ID: return 1530;
			case Fire::Fire(2, false, false, false, true, true).ID: return 1531;
			case Fire::Fire(2, false, false, false, true, false).ID: return 1532;
			case Fire::Fire(2, false, false, false, false, true).ID: return 1533;
			case Fire::Fire(2, false, false, false, false, false).ID: return 1534;
			case Fire::Fire(3, true, true, true, true, true).ID: return 1535;
			case Fire::Fire(3, true, true, true, true, false).ID: return 1536;
			case Fire::Fire(3, true, true, true, false, true).ID: return 1537;
			case Fire::Fire(3, true, true, true, false, false).ID: return 1538;
			case Fire::Fire(3, true, true, false, true, true).ID: return 1539;
			case Fire::Fire(3, true, true, false, true, false).ID: return 1540;
			case Fire::Fire(3, true, true, false, false, true).ID: return 1541;
			case Fire::Fire(3, true, true, false, false, false).ID: return 1542;
			case Fire::Fire(3, true, false, true, true, true).ID: return 1543;
			case Fire::Fire(3, true, false, true, true, false).ID: return 1544;
			case Fire::Fire(3, true, false, true, false, true).ID: return 1545;
			case Fire::Fire(3, true, false, true, false, false).ID: return 1546;
			case Fire::Fire(3, true, false, false, true, true).ID: return 1547;
			case Fire::Fire(3, true, false, false, true, false).ID: return 1548;
			case Fire::Fire(3, true, false, false, false, true).ID: return 1549;
			case Fire::Fire(3, true, false, false, false, false).ID: return 1550;
			case Fire::Fire(3, false, true, true, true, true).ID: return 1551;
			case Fire::Fire(3, false, true, true, true, false).ID: return 1552;
			case Fire::Fire(3, false, true, true, false, true).ID: return 1553;
			case Fire::Fire(3, false, true, true, false, false).ID: return 1554;
			case Fire::Fire(3, false, true, false, true, true).ID: return 1555;
			case Fire::Fire(3, false, true, false, true, false).ID: return 1556;
			case Fire::Fire(3, false, true, false, false, true).ID: return 1557;
			case Fire::Fire(3, false, true, false, false, false).ID: return 1558;
			case Fire::Fire(3, false, false, true, true, true).ID: return 1559;
			case Fire::Fire(3, false, false, true, true, false).ID: return 1560;
			case Fire::Fire(3, false, false, true, false, true).ID: return 1561;
			case Fire::Fire(3, false, false, true, false, false).ID: return 1562;
			case Fire::Fire(3, false, false, false, true, true).ID: return 1563;
			case Fire::Fire(3, false, false, false, true, false).ID: return 1564;
			case Fire::Fire(3, false, false, false, false, true).ID: return 1565;
			case Fire::Fire(3, false, false, false, false, false).ID: return 1566;
			case Fire::Fire(4, true, true, true, true, true).ID: return 1567;
			case Fire::Fire(4, true, true, true, true, false).ID: return 1568;
			case Fire::Fire(4, true, true, true, false, true).ID: return 1569;
			case Fire::Fire(4, true, true, true, false, false).ID: return 1570;
			case Fire::Fire(4, true, true, false, true, true).ID: return 1571;
			case Fire::Fire(4, true, true, false, true, false).ID: return 1572;
			case Fire::Fire(4, true, true, false, false, true).ID: return 1573;
			case Fire::Fire(4, true, true, false, false, false).ID: return 1574;
			case Fire::Fire(4, true, false, true, true, true).ID: return 1575;
			case Fire::Fire(4, true, false, true, true, false).ID: return 1576;
			case Fire::Fire(4, true, false, true, false, true).ID: return 1577;
			case Fire::Fire(4, true, false, true, false, false).ID: return 1578;
			case Fire::Fire(4, true, false, false, true, true).ID: return 1579;
			case Fire::Fire(4, true, false, false, true, false).ID: return 1580;
			case Fire::Fire(4, true, false, false, false, true).ID: return 1581;
			case Fire::Fire(4, true, false, false, false, false).ID: return 1582;
			case Fire::Fire(4, false, true, true, true, true).ID: return 1583;
			case Fire::Fire(4, false, true, true, true, false).ID: return 1584;
			case Fire::Fire(4, false, true, true, false, true).ID: return 1585;
			case Fire::Fire(4, false, true, true, false, false).ID: return 1586;
			case Fire::Fire(4, false, true, false, true, true).ID: return 1587;
			case Fire::Fire(4, false, true, false, true, false).ID: return 1588;
			case Fire::Fire(4, false, true, false, false, true).ID: return 1589;
			case Fire::Fire(4, false, true, false, false, false).ID: return 1590;
			case Fire::Fire(4, false, false, true, true, true).ID: return 1591;
			case Fire::Fire(4, false, false, true, true, false).ID: return 1592;
			case Fire::Fire(4, false, false, true, false, true).ID: return 1593;
			case Fire::Fire(4, false, false, true, false, false).ID: return 1594;
			case Fire::Fire(4, false, false, false, true, true).ID: return 1595;
			case Fire::Fire(4, false, false, false, true, false).ID: return 1596;
			case Fire::Fire(4, false, false, false, false, true).ID: return 1597;
			case Fire::Fire(4, false, false, false, false, false).ID: return 1598;
			case Fire::Fire(5, true, true, true, true, true).ID: return 1599;
			case Fire::Fire(5, true, true, true, true, false).ID: return 1600;
			case Fire::Fire(5, true, true, true, false, true).ID: return 1601;
			case Fire::Fire(5, true, true, true, false, false).ID: return 1602;
			case Fire::Fire(5, true, true, false, true, true).ID: return 1603;
			case Fire::Fire(5, true, true, false, true, false).ID: return 1604;
			case Fire::Fire(5, true, true, false, false, true).ID: return 1605;
			case Fire::Fire(5, true, true, false, false, false).ID: return 1606;
			case Fire::Fire(5, true, false, true, true, true).ID: return 1607;
			case Fire::Fire(5, true, false, true, true, false).ID: return 1608;
			case Fire::Fire(5, true, false, true, false, true).ID: return 1609;
			case Fire::Fire(5, true, false, true, false, false).ID: return 1610;
			case Fire::Fire(5, true, false, false, true, true).ID: return 1611;
			case Fire::Fire(5, true, false, false, true, false).ID: return 1612;
			case Fire::Fire(5, true, false, false, false, true).ID: return 1613;
			case Fire::Fire(5, true, false, false, false, false).ID: return 1614;
			case Fire::Fire(5, false, true, true, true, true).ID: return 1615;
			case Fire::Fire(5, false, true, true, true, false).ID: return 1616;
			case Fire::Fire(5, false, true, true, false, true).ID: return 1617;
			case Fire::Fire(5, false, true, true, false, false).ID: return 1618;
			case Fire::Fire(5, false, true, false, true, true).ID: return 1619;
			case Fire::Fire(5, false, true, false, true, false).ID: return 1620;
			case Fire::Fire(5, false, true, false, false, true).ID: return 1621;
			case Fire::Fire(5, false, true, false, false, false).ID: return 1622;
			case Fire::Fire(5, false, false, true, true, true).ID: return 1623;
			case Fire::Fire(5, false, false, true, true, false).ID: return 1624;
			case Fire::Fire(5, false, false, true, false, true).ID: return 1625;
			case Fire::Fire(5, false, false, true, false, false).ID: return 1626;
			case Fire::Fire(5, false, false, false, true, true).ID: return 1627;
			case Fire::Fire(5, false, false, false, true, false).ID: return 1628;
			case Fire::Fire(5, false, false, false, false, true).ID: return 1629;
			case Fire::Fire(5, false, false, false, false, false).ID: return 1630;
			case Fire::Fire(6, true, true, true, true, true).ID: return 1631;
			case Fire::Fire(6, true, true, true, true, false).ID: return 1632;
			case Fire::Fire(6, true, true, true, false, true).ID: return 1633;
			case Fire::Fire(6, true, true, true, false, false).ID: return 1634;
			case Fire::Fire(6, true, true, false, true, true).ID: return 1635;
			case Fire::Fire(6, true, true, false, true, false).ID: return 1636;
			case Fire::Fire(6, true, true, false, false, true).ID: return 1637;
			case Fire::Fire(6, true, true, false, false, false).ID: return 1638;
			case Fire::Fire(6, true, false, true, true, true).ID: return 1639;
			case Fire::Fire(6, true, false, true, true, false).ID: return 1640;
			case Fire::Fire(6, true, false, true, false, true).ID: return 1641;
			case Fire::Fire(6, true, false, true, false, false).ID: return 1642;
			case Fire::Fire(6, true, false, false, true, true).ID: return 1643;
			case Fire::Fire(6, true, false, false, true, false).ID: return 1644;
			case Fire::Fire(6, true, false, false, false, true).ID: return 1645;
			case Fire::Fire(6, true, false, false, false, false).ID: return 1646;
			case Fire::Fire(6, false, true, true, true, true).ID: return 1647;
			case Fire::Fire(6, false, true, true, true, false).ID: return 1648;
			case Fire::Fire(6, false, true, true, false, true).ID: return 1649;
			case Fire::Fire(6, false, true, true, false, false).ID: return 1650;
			case Fire::Fire(6, false, true, false, true, true).ID: return 1651;
			case Fire::Fire(6, false, true, false, true, false).ID: return 1652;
			case Fire::Fire(6, false, true, false, false, true).ID: return 1653;
			case Fire::Fire(6, false, true, false, false, false).ID: return 1654;
			case Fire::Fire(6, false, false, true, true, true).ID: return 1655;
			case Fire::Fire(6, false, false, true, true, false).ID: return 1656;
			case Fire::Fire(6, false, false, true, false, true).ID: return 1657;
			case Fire::Fire(6, false, false, true, false, false).ID: return 1658;
			case Fire::Fire(6, false, false, false, true, true).ID: return 1659;
			case Fire::Fire(6, false, false, false, true, false).ID: return 1660;
			case Fire::Fire(6, false, false, false, false, true).ID: return 1661;
			case Fire::Fire(6, false, false, false, false, false).ID: return 1662;
			case Fire::Fire(7, true, true, true, true, true).ID: return 1663;
			case Fire::Fire(7, true, true, true, true, false).ID: return 1664;
			case Fire::Fire(7, true, true, true, false, true).ID: return 1665;
			case Fire::Fire(7, true, true, true, false, false).ID: return 1666;
			case Fire::Fire(7, true, true, false, true, true).ID: return 1667;
			case Fire::Fire(7, true, true, false, true, false).ID: return 1668;
			case Fire::Fire(7, true, true, false, false, true).ID: return 1669;
			case Fire::Fire(7, true, true, false, false, false).ID: return 1670;
			case Fire::Fire(7, true, false, true, true, true).ID: return 1671;
			case Fire::Fire(7, true, false, true, true, false).ID: return 1672;
			case Fire::Fire(7, true, false, true, false, true).ID: return 1673;
			case Fire::Fire(7, true, false, true, false, false).ID: return 1674;
			case Fire::Fire(7, true, false, false, true, true).ID: return 1675;
			case Fire::Fire(7, true, false, false, true, false).ID: return 1676;
			case Fire::Fire(7, true, false, false, false, true).ID: return 1677;
			case Fire::Fire(7, true, false, false, false, false).ID: return 1678;
			case Fire::Fire(7, false, true, true, true, true).ID: return 1679;
			case Fire::Fire(7, false, true, true, true, false).ID: return 1680;
			case Fire::Fire(7, false, true, true, false, true).ID: return 1681;
			case Fire::Fire(7, false, true, true, false, false).ID: return 1682;
			case Fire::Fire(7, false, true, false, true, true).ID: return 1683;
			case Fire::Fire(7, false, true, false, true, false).ID: return 1684;
			case Fire::Fire(7, false, true, false, false, true).ID: return 1685;
			case Fire::Fire(7, false, true, false, false, false).ID: return 1686;
			case Fire::Fire(7, false, false, true, true, true).ID: return 1687;
			case Fire::Fire(7, false, false, true, true, false).ID: return 1688;
			case Fire::Fire(7, false, false, true, false, true).ID: return 1689;
			case Fire::Fire(7, false, false, true, false, false).ID: return 1690;
			case Fire::Fire(7, false, false, false, true, true).ID: return 1691;
			case Fire::Fire(7, false, false, false, true, false).ID: return 1692;
			case Fire::Fire(7, false, false, false, false, true).ID: return 1693;
			case Fire::Fire(7, false, false, false, false, false).ID: return 1694;
			case Fire::Fire(8, true, true, true, true, true).ID: return 1695;
			case Fire::Fire(8, true, true, true, true, false).ID: return 1696;
			case Fire::Fire(8, true, true, true, false, true).ID: return 1697;
			case Fire::Fire(8, true, true, true, false, false).ID: return 1698;
			case Fire::Fire(8, true, true, false, true, true).ID: return 1699;
			case Fire::Fire(8, true, true, false, true, false).ID: return 1700;
			case Fire::Fire(8, true, true, false, false, true).ID: return 1701;
			case Fire::Fire(8, true, true, false, false, false).ID: return 1702;
			case Fire::Fire(8, true, false, true, true, true).ID: return 1703;
			case Fire::Fire(8, true, false, true, true, false).ID: return 1704;
			case Fire::Fire(8, true, false, true, false, true).ID: return 1705;
			case Fire::Fire(8, true, false, true, false, false).ID: return 1706;
			case Fire::Fire(8, true, false, false, true, true).ID: return 1707;
			case Fire::Fire(8, true, false, false, true, false).ID: return 1708;
			case Fire::Fire(8, true, false, false, false, true).ID: return 1709;
			case Fire::Fire(8, true, false, false, false, false).ID: return 1710;
			case Fire::Fire(8, false, true, true, true, true).ID: return 1711;
			case Fire::Fire(8, false, true, true, true, false).ID: return 1712;
			case Fire::Fire(8, false, true, true, false, true).ID: return 1713;
			case Fire::Fire(8, false, true, true, false, false).ID: return 1714;
			case Fire::Fire(8, false, true, false, true, true).ID: return 1715;
			case Fire::Fire(8, false, true, false, true, false).ID: return 1716;
			case Fire::Fire(8, false, true, false, false, true).ID: return 1717;
			case Fire::Fire(8, false, true, false, false, false).ID: return 1718;
			case Fire::Fire(8, false, false, true, true, true).ID: return 1719;
			case Fire::Fire(8, false, false, true, true, false).ID: return 1720;
			case Fire::Fire(8, false, false, true, false, true).ID: return 1721;
			case Fire::Fire(8, false, false, true, false, false).ID: return 1722;
			case Fire::Fire(8, false, false, false, true, true).ID: return 1723;
			case Fire::Fire(8, false, false, false, true, false).ID: return 1724;
			case Fire::Fire(8, false, false, false, false, true).ID: return 1725;
			case Fire::Fire(8, false, false, false, false, false).ID: return 1726;
			case Fire::Fire(9, true, true, true, true, true).ID: return 1727;
			case Fire::Fire(9, true, true, true, true, false).ID: return 1728;
			case Fire::Fire(9, true, true, true, false, true).ID: return 1729;
			case Fire::Fire(9, true, true, true, false, false).ID: return 1730;
			case Fire::Fire(9, true, true, false, true, true).ID: return 1731;
			case Fire::Fire(9, true, true, false, true, false).ID: return 1732;
			case Fire::Fire(9, true, true, false, false, true).ID: return 1733;
			case Fire::Fire(9, true, true, false, false, false).ID: return 1734;
			case Fire::Fire(9, true, false, true, true, true).ID: return 1735;
			case Fire::Fire(9, true, false, true, true, false).ID: return 1736;
			case Fire::Fire(9, true, false, true, false, true).ID: return 1737;
			case Fire::Fire(9, true, false, true, false, false).ID: return 1738;
			case Fire::Fire(9, true, false, false, true, true).ID: return 1739;
			case Fire::Fire(9, true, false, false, true, false).ID: return 1740;
			case Fire::Fire(9, true, false, false, false, true).ID: return 1741;
			case Fire::Fire(9, true, false, false, false, false).ID: return 1742;
			case Fire::Fire(9, false, true, true, true, true).ID: return 1743;
			case Fire::Fire(9, false, true, true, true, false).ID: return 1744;
			case Fire::Fire(9, false, true, true, false, true).ID: return 1745;
			case Fire::Fire(9, false, true, true, false, false).ID: return 1746;
			case Fire::Fire(9, false, true, false, true, true).ID: return 1747;
			case Fire::Fire(9, false, true, false, true, false).ID: return 1748;
			case Fire::Fire(9, false, true, false, false, true).ID: return 1749;
			case Fire::Fire(9, false, true, false, false, false).ID: return 1750;
			case Fire::Fire(9, false, false, true, true, true).ID: return 1751;
			case Fire::Fire(9, false, false, true, true, false).ID: return 1752;
			case Fire::Fire(9, false, false, true, false, true).ID: return 1753;
			case Fire::Fire(9, false, false, true, false, false).ID: return 1754;
			case Fire::Fire(9, false, false, false, true, true).ID: return 1755;
			case Fire::Fire(9, false, false, false, true, false).ID: return 1756;
			case Fire::Fire(9, false, false, false, false, true).ID: return 1757;
			case Fire::Fire(9, false, false, false, false, false).ID: return 1758;
			case Fire::Fire(10, true, true, true, true, true).ID: return 1759;
			case Fire::Fire(10, true, true, true, true, false).ID: return 1760;
			case Fire::Fire(10, true, true, true, false, true).ID: return 1761;
			case Fire::Fire(10, true, true, true, false, false).ID: return 1762;
			case Fire::Fire(10, true, true, false, true, true).ID: return 1763;
			case Fire::Fire(10, true, true, false, true, false).ID: return 1764;
			case Fire::Fire(10, true, true, false, false, true).ID: return 1765;
			case Fire::Fire(10, true, true, false, false, false).ID: return 1766;
			case Fire::Fire(10, true, false, true, true, true).ID: return 1767;
			case Fire::Fire(10, true, false, true, true, false).ID: return 1768;
			case Fire::Fire(10, true, false, true, false, true).ID: return 1769;
			case Fire::Fire(10, true, false, true, false, false).ID: return 1770;
			case Fire::Fire(10, true, false, false, true, true).ID: return 1771;
			case Fire::Fire(10, true, false, false, true, false).ID: return 1772;
			case Fire::Fire(10, true, false, false, false, true).ID: return 1773;
			case Fire::Fire(10, true, false, false, false, false).ID: return 1774;
			case Fire::Fire(10, false, true, true, true, true).ID: return 1775;
			case Fire::Fire(10, false, true, true, true, false).ID: return 1776;
			case Fire::Fire(10, false, true, true, false, true).ID: return 1777;
			case Fire::Fire(10, false, true, true, false, false).ID: return 1778;
			case Fire::Fire(10, false, true, false, true, true).ID: return 1779;
			case Fire::Fire(10, false, true, false, true, false).ID: return 1780;
			case Fire::Fire(10, false, true, false, false, true).ID: return 1781;
			case Fire::Fire(10, false, true, false, false, false).ID: return 1782;
			case Fire::Fire(10, false, false, true, true, true).ID: return 1783;
			case Fire::Fire(10, false, false, true, true, false).ID: return 1784;
			case Fire::Fire(10, false, false, true, false, true).ID: return 1785;
			case Fire::Fire(10, false, false, true, false, false).ID: return 1786;
			case Fire::Fire(10, false, false, false, true, true).ID: return 1787;
			case Fire::Fire(10, false, false, false, true, false).ID: return 1788;
			case Fire::Fire(10, false, false, false, false, true).ID: return 1789;
			case Fire::Fire(10, false, false, false, false, false).ID: return 1790;
			case Fire::Fire(11, true, true, true, true, true).ID: return 1791;
			case Fire::Fire(11, true, true, true, true, false).ID: return 1792;
			case Fire::Fire(11, true, true, true, false, true).ID: return 1793;
			case Fire::Fire(11, true, true, true, false, false).ID: return 1794;
			case Fire::Fire(11, true, true, false, true, true).ID: return 1795;
			case Fire::Fire(11, true, true, false, true, false).ID: return 1796;
			case Fire::Fire(11, true, true, false, false, true).ID: return 1797;
			case Fire::Fire(11, true, true, false, false, false).ID: return 1798;
			case Fire::Fire(11, true, false, true, true, true).ID: return 1799;
			case Fire::Fire(11, true, false, true, true, false).ID: return 1800;
			case Fire::Fire(11, true, false, true, false, true).ID: return 1801;
			case Fire::Fire(11, true, false, true, false, false).ID: return 1802;
			case Fire::Fire(11, true, false, false, true, true).ID: return 1803;
			case Fire::Fire(11, true, false, false, true, false).ID: return 1804;
			case Fire::Fire(11, true, false, false, false, true).ID: return 1805;
			case Fire::Fire(11, true, false, false, false, false).ID: return 1806;
			case Fire::Fire(11, false, true, true, true, true).ID: return 1807;
			case Fire::Fire(11, false, true, true, true, false).ID: return 1808;
			case Fire::Fire(11, false, true, true, false, true).ID: return 1809;
			case Fire::Fire(11, false, true, true, false, false).ID: return 1810;
			case Fire::Fire(11, false, true, false, true, true).ID: return 1811;
			case Fire::Fire(11, false, true, false, true, false).ID: return 1812;
			case Fire::Fire(11, false, true, false, false, true).ID: return 1813;
			case Fire::Fire(11, false, true, false, false, false).ID: return 1814;
			case Fire::Fire(11, false, false, true, true, true).ID: return 1815;
			case Fire::Fire(11, false, false, true, true, false).ID: return 1816;
			case Fire::Fire(11, false, false, true, false, true).ID: return 1817;
			case Fire::Fire(11, false, false, true, false, false).ID: return 1818;
			case Fire::Fire(11, false, false, false, true, true).ID: return 1819;
			case Fire::Fire(11, false, false, false, true, false).ID: return 1820;
			case Fire::Fire(11, false, false, false, false, true).ID: return 1821;
			case Fire::Fire(11, false, false, false, false, false).ID: return 1822;
			case Fire::Fire(12, true, true, true, true, true).ID: return 1823;
			case Fire::Fire(12, true, true, true, true, false).ID: return 1824;
			case Fire::Fire(12, true, true, true, false, true).ID: return 1825;
			case Fire::Fire(12, true, true, true, false, false).ID: return 1826;
			case Fire::Fire(12, true, true, false, true, true).ID: return 1827;
			case Fire::Fire(12, true, true, false, true, false).ID: return 1828;
			case Fire::Fire(12, true, true, false, false, true).ID: return 1829;
			case Fire::Fire(12, true, true, false, false, false).ID: return 1830;
			case Fire::Fire(12, true, false, true, true, true).ID: return 1831;
			case Fire::Fire(12, true, false, true, true, false).ID: return 1832;
			case Fire::Fire(12, true, false, true, false, true).ID: return 1833;
			case Fire::Fire(12, true, false, true, false, false).ID: return 1834;
			case Fire::Fire(12, true, false, false, true, true).ID: return 1835;
			case Fire::Fire(12, true, false, false, true, false).ID: return 1836;
			case Fire::Fire(12, true, false, false, false, true).ID: return 1837;
			case Fire::Fire(12, true, false, false, false, false).ID: return 1838;
			case Fire::Fire(12, false, true, true, true, true).ID: return 1839;
			case Fire::Fire(12, false, true, true, true, false).ID: return 1840;
			case Fire::Fire(12, false, true, true, false, true).ID: return 1841;
			case Fire::Fire(12, false, true, true, false, false).ID: return 1842;
			case Fire::Fire(12, false, true, false, true, true).ID: return 1843;
			case Fire::Fire(12, false, true, false, true, false).ID: return 1844;
			case Fire::Fire(12, false, true, false, false, true).ID: return 1845;
			case Fire::Fire(12, false, true, false, false, false).ID: return 1846;
			case Fire::Fire(12, false, false, true, true, true).ID: return 1847;
			case Fire::Fire(12, false, false, true, true, false).ID: return 1848;
			case Fire::Fire(12, false, false, true, false, true).ID: return 1849;
			case Fire::Fire(12, false, false, true, false, false).ID: return 1850;
			case Fire::Fire(12, false, false, false, true, true).ID: return 1851;
			case Fire::Fire(12, false, false, false, true, false).ID: return 1852;
			case Fire::Fire(12, false, false, false, false, true).ID: return 1853;
			case Fire::Fire(12, false, false, false, false, false).ID: return 1854;
			case Fire::Fire(13, true, true, true, true, true).ID: return 1855;
			case Fire::Fire(13, true, true, true, true, false).ID: return 1856;
			case Fire::Fire(13, true, true, true, false, true).ID: return 1857;
			case Fire::Fire(13, true, true, true, false, false).ID: return 1858;
			case Fire::Fire(13, true, true, false, true, true).ID: return 1859;
			case Fire::Fire(13, true, true, false, true, false).ID: return 1860;
			case Fire::Fire(13, true, true, false, false, true).ID: return 1861;
			case Fire::Fire(13, true, true, false, false, false).ID: return 1862;
			case Fire::Fire(13, true, false, true, true, true).ID: return 1863;
			case Fire::Fire(13, true, false, true, true, false).ID: return 1864;
			case Fire::Fire(13, true, false, true, false, true).ID: return 1865;
			case Fire::Fire(13, true, false, true, false, false).ID: return 1866;
			case Fire::Fire(13, true, false, false, true, true).ID: return 1867;
			case Fire::Fire(13, true, false, false, true, false).ID: return 1868;
			case Fire::Fire(13, true, false, false, false, true).ID: return 1869;
			case Fire::Fire(13, true, false, false, false, false).ID: return 1870;
			case Fire::Fire(13, false, true, true, true, true).ID: return 1871;
			case Fire::Fire(13, false, true, true, true, false).ID: return 1872;
			case Fire::Fire(13, false, true, true, false, true).ID: return 1873;
			case Fire::Fire(13, false, true, true, false, false).ID: return 1874;
			case Fire::Fire(13, false, true, false, true, true).ID: return 1875;
			case Fire::Fire(13, false, true, false, true, false).ID: return 1876;
			case Fire::Fire(13, false, true, false, false, true).ID: return 1877;
			case Fire::Fire(13, false, true, false, false, false).ID: return 1878;
			case Fire::Fire(13, false, false, true, true, true).ID: return 1879;
			case Fire::Fire(13, false, false, true, true, false).ID: return 1880;
			case Fire::Fire(13, false, false, true, false, true).ID: return 1881;
			case Fire::Fire(13, false, false, true, false, false).ID: return 1882;
			case Fire::Fire(13, false, false, false, true, true).ID: return 1883;
			case Fire::Fire(13, false, false, false, true, false).ID: return 1884;
			case Fire::Fire(13, false, false, false, false, true).ID: return 1885;
			case Fire::Fire(13, false, false, false, false, false).ID: return 1886;
			case Fire::Fire(14, true, true, true, true, true).ID: return 1887;
			case Fire::Fire(14, true, true, true, true, false).ID: return 1888;
			case Fire::Fire(14, true, true, true, false, true).ID: return 1889;
			case Fire::Fire(14, true, true, true, false, false).ID: return 1890;
			case Fire::Fire(14, true, true, false, true, true).ID: return 1891;
			case Fire::Fire(14, true, true, false, true, false).ID: return 1892;
			case Fire::Fire(14, true, true, false, false, true).ID: return 1893;
			case Fire::Fire(14, true, true, false, false, false).ID: return 1894;
			case Fire::Fire(14, true, false, true, true, true).ID: return 1895;
			case Fire::Fire(14, true, false, true, true, false).ID: return 1896;
			case Fire::Fire(14, true, false, true, false, true).ID: return 1897;
			case Fire::Fire(14, true, false, true, false, false).ID: return 1898;
			case Fire::Fire(14, true, false, false, true, true).ID: return 1899;
			case Fire::Fire(14, true, false, false, true, false).ID: return 1900;
			case Fire::Fire(14, true, false, false, false, true).ID: return 1901;
			case Fire::Fire(14, true, false, false, false, false).ID: return 1902;
			case Fire::Fire(14, false, true, true, true, true).ID: return 1903;
			case Fire::Fire(14, false, true, true, true, false).ID: return 1904;
			case Fire::Fire(14, false, true, true, false, true).ID: return 1905;
			case Fire::Fire(14, false, true, true, false, false).ID: return 1906;
			case Fire::Fire(14, false, true, false, true, true).ID: return 1907;
			case Fire::Fire(14, false, true, false, true, false).ID: return 1908;
			case Fire::Fire(14, false, true, false, false, true).ID: return 1909;
			case Fire::Fire(14, false, true, false, false, false).ID: return 1910;
			case Fire::Fire(14, false, false, true, true, true).ID: return 1911;
			case Fire::Fire(14, false, false, true, true, false).ID: return 1912;
			case Fire::Fire(14, false, false, true, false, true).ID: return 1913;
			case Fire::Fire(14, false, false, true, false, false).ID: return 1914;
			case Fire::Fire(14, false, false, false, true, true).ID: return 1915;
			case Fire::Fire(14, false, false, false, true, false).ID: return 1916;
			case Fire::Fire(14, false, false, false, false, true).ID: return 1917;
			case Fire::Fire(14, false, false, false, false, false).ID: return 1918;
			case Fire::Fire(15, true, true, true, true, true).ID: return 1919;
			case Fire::Fire(15, true, true, true, true, false).ID: return 1920;
			case Fire::Fire(15, true, true, true, false, true).ID: return 1921;
			case Fire::Fire(15, true, true, true, false, false).ID: return 1922;
			case Fire::Fire(15, true, true, false, true, true).ID: return 1923;
			case Fire::Fire(15, true, true, false, true, false).ID: return 1924;
			case Fire::Fire(15, true, true, false, false, true).ID: return 1925;
			case Fire::Fire(15, true, true, false, false, false).ID: return 1926;
			case Fire::Fire(15, true, false, true, true, true).ID: return 1927;
			case Fire::Fire(15, true, false, true, true, false).ID: return 1928;
			case Fire::Fire(15, true, false, true, false, true).ID: return 1929;
			case Fire::Fire(15, true, false, true, false, false).ID: return 1930;
			case Fire::Fire(15, true, false, false, true, true).ID: return 1931;
			case Fire::Fire(15, true, false, false, true, false).ID: return 1932;
			case Fire::Fire(15, true, false, false, false, true).ID: return 1933;
			case Fire::Fire(15, true, false, false, false, false).ID: return 1934;
			case Fire::Fire(15, false, true, true, true, true).ID: return 1935;
			case Fire::Fire(15, false, true, true, true, false).ID: return 1936;
			case Fire::Fire(15, false, true, true, false, true).ID: return 1937;
			case Fire::Fire(15, false, true, true, false, false).ID: return 1938;
			case Fire::Fire(15, false, true, false, true, true).ID: return 1939;
			case Fire::Fire(15, false, true, false, true, false).ID: return 1940;
			case Fire::Fire(15, false, true, false, false, true).ID: return 1941;
			case Fire::Fire(15, false, true, false, false, false).ID: return 1942;
			case Fire::Fire(15, false, false, true, true, true).ID: return 1943;
			case Fire::Fire(15, false, false, true, true, false).ID: return 1944;
			case Fire::Fire(15, false, false, true, false, true).ID: return 1945;
			case Fire::Fire(15, false, false, true, false, false).ID: return 1946;
			case Fire::Fire(15, false, false, false, true, true).ID: return 1947;
			case Fire::Fire(15, false, false, false, true, false).ID: return 1948;
			case Fire::Fire(15, false, false, false, false, true).ID: return 1949;
			case Fire::Fire(15, false, false, false, false, false).ID: return 1950;
			case FireCoral::FireCoral().ID: return 9001;
			case FireCoralBlock::FireCoralBlock().ID: return 8982;
			case FireCoralFan::FireCoralFan().ID: return 9021;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9089;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9091;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9093;
			case FireCoralWallFan::FireCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9095;
			case FletchingTable::FletchingTable().ID: return 11164;
			case FlowerPot::FlowerPot().ID: return 5769;
			case FrostedIce::FrostedIce(0).ID: return 8713;
			case FrostedIce::FrostedIce(1).ID: return 8714;
			case FrostedIce::FrostedIce(2).ID: return 8715;
			case FrostedIce::FrostedIce(3).ID: return 8716;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZM, true).ID: return 3371;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZM, false).ID: return 3372;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZP, true).ID: return 3373;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_ZP, false).ID: return 3374;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XM, true).ID: return 3375;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XM, false).ID: return 3376;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XP, true).ID: return 3377;
			case Furnace::Furnace(eBlockFace::BLOCK_FACE_XP, false).ID: return 3378;
			case Glass::Glass().ID: return 230;
			case GlassPane::GlassPane(true, true, true, true).ID: return 4717;
			case GlassPane::GlassPane(true, true, true, false).ID: return 4718;
			case GlassPane::GlassPane(true, true, false, true).ID: return 4721;
			case GlassPane::GlassPane(true, true, false, false).ID: return 4722;
			case GlassPane::GlassPane(true, false, true, true).ID: return 4725;
			case GlassPane::GlassPane(true, false, true, false).ID: return 4726;
			case GlassPane::GlassPane(true, false, false, true).ID: return 4729;
			case GlassPane::GlassPane(true, false, false, false).ID: return 4730;
			case GlassPane::GlassPane(false, true, true, true).ID: return 4733;
			case GlassPane::GlassPane(false, true, true, false).ID: return 4734;
			case GlassPane::GlassPane(false, true, false, true).ID: return 4737;
			case GlassPane::GlassPane(false, true, false, false).ID: return 4738;
			case GlassPane::GlassPane(false, false, true, true).ID: return 4741;
			case GlassPane::GlassPane(false, false, true, false).ID: return 4742;
			case GlassPane::GlassPane(false, false, false, true).ID: return 4745;
			case GlassPane::GlassPane(false, false, false, false).ID: return 4746;
			case Glowstone::Glowstone().ID: return 3999;
			case GoldBlock::GoldBlock().ID: return 1426;
			case GoldOre::GoldOre().ID: return 69;
			case Granite::Granite().ID: return 2;
			case GraniteSlab::GraniteSlab(GraniteSlab::Type::Top).ID: return 10302;
			case GraniteSlab::GraniteSlab(GraniteSlab::Type::Bottom).ID: return 10304;
			case GraniteSlab::GraniteSlab(GraniteSlab::Type::Double).ID: return 10306;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 9854;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 9856;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 9858;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 9860;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 9862;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 9864;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 9866;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 9868;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 9870;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 9872;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 9874;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 9876;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 9878;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 9880;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 9882;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 9884;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 9886;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 9888;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 9890;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_ZP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 9892;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 9894;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 9896;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 9898;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 9900;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 9902;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 9904;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 9906;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 9908;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 9910;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XM, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 9912;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::Straight).ID: return 9914;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerLeft).ID: return 9916;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::InnerRight).ID: return 9918;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterLeft).ID: return 9920;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Top, GraniteStairs::Shape::OuterRight).ID: return 9922;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::Straight).ID: return 9924;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerLeft).ID: return 9926;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::InnerRight).ID: return 9928;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterLeft).ID: return 9930;
			case GraniteStairs::GraniteStairs(eBlockFace::BLOCK_FACE_XP, GraniteStairs::Half::Bottom, GraniteStairs::Shape::OuterRight).ID: return 9932;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 10589;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 10590;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 10593;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 10594;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 10597;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 10598;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 10601;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 10602;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 10605;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 10606;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 10609;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 10610;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 10613;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 10614;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 10617;
			case GraniteWall::GraniteWall(GraniteWall::East::Low, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 10618;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 10621;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 10622;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 10625;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 10626;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 10629;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 10630;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 10633;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::Low, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 10634;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::Low).ID: return 10637;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, true, GraniteWall::West::None).ID: return 10638;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::Low).ID: return 10641;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::Low, false, GraniteWall::West::None).ID: return 10642;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::Low).ID: return 10645;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, true, GraniteWall::West::None).ID: return 10646;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::Low).ID: return 10649;
			case GraniteWall::GraniteWall(GraniteWall::East::None, GraniteWall::North::None, GraniteWall::South::None, false, GraniteWall::West::None).ID: return 10650;
			case Grass::Grass().ID: return 1341;
			case GrassBlock::GrassBlock(true).ID: return 8;
			case GrassBlock::GrassBlock(false).ID: return 9;
			case GrassPath::GrassPath().ID: return 8687;
			case Gravel::Gravel().ID: return 68;
			case GrayBanner::GrayBanner(0).ID: return 7473;
			case GrayBanner::GrayBanner(1).ID: return 7474;
			case GrayBanner::GrayBanner(2).ID: return 7475;
			case GrayBanner::GrayBanner(3).ID: return 7476;
			case GrayBanner::GrayBanner(4).ID: return 7477;
			case GrayBanner::GrayBanner(5).ID: return 7478;
			case GrayBanner::GrayBanner(6).ID: return 7479;
			case GrayBanner::GrayBanner(7).ID: return 7480;
			case GrayBanner::GrayBanner(8).ID: return 7481;
			case GrayBanner::GrayBanner(9).ID: return 7482;
			case GrayBanner::GrayBanner(10).ID: return 7483;
			case GrayBanner::GrayBanner(11).ID: return 7484;
			case GrayBanner::GrayBanner(12).ID: return 7485;
			case GrayBanner::GrayBanner(13).ID: return 7486;
			case GrayBanner::GrayBanner(14).ID: return 7487;
			case GrayBanner::GrayBanner(15).ID: return 7488;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, true, GrayBed::Part::Head).ID: return 1160;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, true, GrayBed::Part::Foot).ID: return 1161;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, false, GrayBed::Part::Head).ID: return 1162;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZM, false, GrayBed::Part::Foot).ID: return 1163;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, true, GrayBed::Part::Head).ID: return 1164;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, true, GrayBed::Part::Foot).ID: return 1165;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, false, GrayBed::Part::Head).ID: return 1166;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_ZP, false, GrayBed::Part::Foot).ID: return 1167;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, true, GrayBed::Part::Head).ID: return 1168;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, true, GrayBed::Part::Foot).ID: return 1169;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, false, GrayBed::Part::Head).ID: return 1170;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XM, false, GrayBed::Part::Foot).ID: return 1171;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, true, GrayBed::Part::Head).ID: return 1172;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, true, GrayBed::Part::Foot).ID: return 1173;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, false, GrayBed::Part::Head).ID: return 1174;
			case GrayBed::GrayBed(eBlockFace::BLOCK_FACE_XP, false, GrayBed::Part::Foot).ID: return 1175;
			case GrayCarpet::GrayCarpet().ID: return 7337;
			case GrayConcrete::GrayConcrete().ID: return 8909;
			case GrayConcretePowder::GrayConcretePowder().ID: return 8925;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8866;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8867;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8868;
			case GrayGlazedTerracotta::GrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8869;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8784;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8785;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8786;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8787;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8788;
			case GrayShulkerBox::GrayShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8789;
			case GrayStainedGlass::GrayStainedGlass().ID: return 4088;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, true, true).ID: return 6553;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, true, false).ID: return 6554;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, false, true).ID: return 6557;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, true, false, false).ID: return 6558;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, true, true).ID: return 6561;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, true, false).ID: return 6562;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, false, true).ID: return 6565;
			case GrayStainedGlassPane::GrayStainedGlassPane(true, false, false, false).ID: return 6566;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, true, true).ID: return 6569;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, true, false).ID: return 6570;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, false, true).ID: return 6573;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, true, false, false).ID: return 6574;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, true, true).ID: return 6577;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, true, false).ID: return 6578;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, false, true).ID: return 6581;
			case GrayStainedGlassPane::GrayStainedGlassPane(false, false, false, false).ID: return 6582;
			case GrayTerracotta::GrayTerracotta().ID: return 6318;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7645;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7646;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7647;
			case GrayWallBanner::GrayWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7648;
			case GrayWool::GrayWool().ID: return 1390;
			case GreenBanner::GreenBanner(0).ID: return 7569;
			case GreenBanner::GreenBanner(1).ID: return 7570;
			case GreenBanner::GreenBanner(2).ID: return 7571;
			case GreenBanner::GreenBanner(3).ID: return 7572;
			case GreenBanner::GreenBanner(4).ID: return 7573;
			case GreenBanner::GreenBanner(5).ID: return 7574;
			case GreenBanner::GreenBanner(6).ID: return 7575;
			case GreenBanner::GreenBanner(7).ID: return 7576;
			case GreenBanner::GreenBanner(8).ID: return 7577;
			case GreenBanner::GreenBanner(9).ID: return 7578;
			case GreenBanner::GreenBanner(10).ID: return 7579;
			case GreenBanner::GreenBanner(11).ID: return 7580;
			case GreenBanner::GreenBanner(12).ID: return 7581;
			case GreenBanner::GreenBanner(13).ID: return 7582;
			case GreenBanner::GreenBanner(14).ID: return 7583;
			case GreenBanner::GreenBanner(15).ID: return 7584;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, true, GreenBed::Part::Head).ID: return 1256;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, true, GreenBed::Part::Foot).ID: return 1257;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, false, GreenBed::Part::Head).ID: return 1258;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZM, false, GreenBed::Part::Foot).ID: return 1259;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, true, GreenBed::Part::Head).ID: return 1260;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, true, GreenBed::Part::Foot).ID: return 1261;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, false, GreenBed::Part::Head).ID: return 1262;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_ZP, false, GreenBed::Part::Foot).ID: return 1263;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, true, GreenBed::Part::Head).ID: return 1264;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, true, GreenBed::Part::Foot).ID: return 1265;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, false, GreenBed::Part::Head).ID: return 1266;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XM, false, GreenBed::Part::Foot).ID: return 1267;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, true, GreenBed::Part::Head).ID: return 1268;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, true, GreenBed::Part::Foot).ID: return 1269;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, false, GreenBed::Part::Head).ID: return 1270;
			case GreenBed::GreenBed(eBlockFace::BLOCK_FACE_XP, false, GreenBed::Part::Foot).ID: return 1271;
			case GreenCarpet::GreenCarpet().ID: return 7343;
			case GreenConcrete::GreenConcrete().ID: return 8915;
			case GreenConcretePowder::GreenConcretePowder().ID: return 8931;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8890;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8891;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8892;
			case GreenGlazedTerracotta::GreenGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8893;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8820;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8821;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8822;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8823;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8824;
			case GreenShulkerBox::GreenShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8825;
			case GreenStainedGlass::GreenStainedGlass().ID: return 4094;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, true, true).ID: return 6745;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, true, false).ID: return 6746;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, false, true).ID: return 6749;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, true, false, false).ID: return 6750;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, true, true).ID: return 6753;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, true, false).ID: return 6754;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, false, true).ID: return 6757;
			case GreenStainedGlassPane::GreenStainedGlassPane(true, false, false, false).ID: return 6758;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, true, true).ID: return 6761;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, true, false).ID: return 6762;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, false, true).ID: return 6765;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, true, false, false).ID: return 6766;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, true, true).ID: return 6769;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, true, false).ID: return 6770;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, false, true).ID: return 6773;
			case GreenStainedGlassPane::GreenStainedGlassPane(false, false, false, false).ID: return 6774;
			case GreenTerracotta::GreenTerracotta().ID: return 6324;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7669;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7670;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7671;
			case GreenWallBanner::GreenWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7672;
			case GreenWool::GreenWool().ID: return 1396;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_ZM).ID: return 11165;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_ZP).ID: return 11166;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_XM).ID: return 11167;
			case Grindstone::Grindstone(Grindstone::Face::Floor, eBlockFace::BLOCK_FACE_XP).ID: return 11168;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_ZM).ID: return 11169;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_ZP).ID: return 11170;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_XM).ID: return 11171;
			case Grindstone::Grindstone(Grindstone::Face::Wall, eBlockFace::BLOCK_FACE_XP).ID: return 11172;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM).ID: return 11173;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP).ID: return 11174;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_XM).ID: return 11175;
			case Grindstone::Grindstone(Grindstone::Face::Ceiling, eBlockFace::BLOCK_FACE_XP).ID: return 11176;
			case HayBale::HayBale(HayBale::Axis::X).ID: return 7327;
			case HayBale::HayBale(HayBale::Axis::Y).ID: return 7328;
			case HayBale::HayBale(HayBale::Axis::Z).ID: return 7329;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(0).ID: return 6126;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(1).ID: return 6127;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(2).ID: return 6128;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(3).ID: return 6129;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(4).ID: return 6130;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(5).ID: return 6131;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(6).ID: return 6132;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(7).ID: return 6133;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(8).ID: return 6134;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(9).ID: return 6135;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(10).ID: return 6136;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(11).ID: return 6137;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(12).ID: return 6138;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(13).ID: return 6139;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(14).ID: return 6140;
			case HeavyWeightedPressurePlate::HeavyWeightedPressurePlate(15).ID: return 6141;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_YM).ID: return 6192;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_ZM).ID: return 6193;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_ZP).ID: return 6194;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_XM).ID: return 6195;
			case Hopper::Hopper(true, eBlockFace::BLOCK_FACE_XP).ID: return 6196;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_YM).ID: return 6197;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_ZM).ID: return 6198;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_ZP).ID: return 6199;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_XM).ID: return 6200;
			case Hopper::Hopper(false, eBlockFace::BLOCK_FACE_XP).ID: return 6201;
			case HornCoral::HornCoral().ID: return 9003;
			case HornCoralBlock::HornCoralBlock().ID: return 8983;
			case HornCoralFan::HornCoralFan().ID: return 9023;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9097;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9099;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9101;
			case HornCoralWallFan::HornCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9103;
			case Ice::Ice().ID: return 3927;
			case InfestedChiseledStoneBricks::InfestedChiseledStoneBricks().ID: return 4490;
			case InfestedCobblestone::InfestedCobblestone().ID: return 4486;
			case InfestedCrackedStoneBricks::InfestedCrackedStoneBricks().ID: return 4489;
			case InfestedMossyStoneBricks::InfestedMossyStoneBricks().ID: return 4488;
			case InfestedStone::InfestedStone().ID: return 4485;
			case InfestedStoneBricks::InfestedStoneBricks().ID: return 4487;
			case IronBars::IronBars(true, true, true, true).ID: return 4685;
			case IronBars::IronBars(true, true, true, false).ID: return 4686;
			case IronBars::IronBars(true, true, false, true).ID: return 4689;
			case IronBars::IronBars(true, true, false, false).ID: return 4690;
			case IronBars::IronBars(true, false, true, true).ID: return 4693;
			case IronBars::IronBars(true, false, true, false).ID: return 4694;
			case IronBars::IronBars(true, false, false, true).ID: return 4697;
			case IronBars::IronBars(true, false, false, false).ID: return 4698;
			case IronBars::IronBars(false, true, true, true).ID: return 4701;
			case IronBars::IronBars(false, true, true, false).ID: return 4702;
			case IronBars::IronBars(false, true, false, true).ID: return 4705;
			case IronBars::IronBars(false, true, false, false).ID: return 4706;
			case IronBars::IronBars(false, false, true, true).ID: return 4709;
			case IronBars::IronBars(false, false, true, false).ID: return 4710;
			case IronBars::IronBars(false, false, false, true).ID: return 4713;
			case IronBars::IronBars(false, false, false, false).ID: return 4714;
			case IronBlock::IronBlock().ID: return 1427;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3807;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3808;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3809;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3810;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3811;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3812;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3813;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3814;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3815;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3816;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3817;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3818;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3819;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3820;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3821;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3822;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3823;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3824;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3825;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3826;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3827;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3828;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3829;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3830;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3831;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3832;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3833;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3834;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3835;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3836;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3837;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_ZP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3838;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3839;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3840;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3841;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3842;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3843;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3844;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3845;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3846;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3847;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3848;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3849;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3850;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3851;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3852;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3853;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XM, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3854;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, true).ID: return 3855;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, true, false).ID: return 3856;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, true).ID: return 3857;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Left, false, false).ID: return 3858;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, true).ID: return 3859;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, true, false).ID: return 3860;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, true).ID: return 3861;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Upper, IronDoor::Hinge::Right, false, false).ID: return 3862;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, true).ID: return 3863;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, true, false).ID: return 3864;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, true).ID: return 3865;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Left, false, false).ID: return 3866;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, true).ID: return 3867;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, true, false).ID: return 3868;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, true).ID: return 3869;
			case IronDoor::IronDoor(eBlockFace::BLOCK_FACE_XP, IronDoor::Half::Lower, IronDoor::Hinge::Right, false, false).ID: return 3870;
			case IronOre::IronOre().ID: return 70;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, true, true).ID: return 7002;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, true, false).ID: return 7004;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, false, true).ID: return 7006;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Top, false, false).ID: return 7008;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, true, true).ID: return 7010;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, true, false).ID: return 7012;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, false, true).ID: return 7014;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZM, IronTrapdoor::Half::Bottom, false, false).ID: return 7016;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, true, true).ID: return 7018;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, true, false).ID: return 7020;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, false, true).ID: return 7022;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Top, false, false).ID: return 7024;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, true, true).ID: return 7026;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, true, false).ID: return 7028;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, false, true).ID: return 7030;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_ZP, IronTrapdoor::Half::Bottom, false, false).ID: return 7032;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, true, true).ID: return 7034;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, true, false).ID: return 7036;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, false, true).ID: return 7038;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Top, false, false).ID: return 7040;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, true, true).ID: return 7042;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, true, false).ID: return 7044;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, false, true).ID: return 7046;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XM, IronTrapdoor::Half::Bottom, false, false).ID: return 7048;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, true, true).ID: return 7050;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, true, false).ID: return 7052;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, false, true).ID: return 7054;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Top, false, false).ID: return 7056;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, true, true).ID: return 7058;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, true, false).ID: return 7060;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, false, true).ID: return 7062;
			case IronTrapdoor::IronTrapdoor(eBlockFace::BLOCK_FACE_XP, IronTrapdoor::Half::Bottom, false, false).ID: return 7064;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_ZM).ID: return 4006;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_ZP).ID: return 4007;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_XM).ID: return 4008;
			case JackOLantern::JackOLantern(eBlockFace::BLOCK_FACE_XP).ID: return 4009;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::NorthUp).ID: return 11256;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::EastUp).ID: return 11257;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::SouthUp).ID: return 11258;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::WestUp).ID: return 11259;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::UpSouth).ID: return 11260;
			case Jigsaw::Jigsaw(Jigsaw::Orientation::DownSouth).ID: return 11261;
			case Jukebox::Jukebox(true).ID: return 3962;
			case Jukebox::Jukebox(false).ID: return 3963;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5882;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5883;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5884;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5885;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 5886;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 5887;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 5888;
			case JungleButton::JungleButton(JungleButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 5889;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5890;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5891;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5892;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5893;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 5894;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 5895;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 5896;
			case JungleButton::JungleButton(JungleButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 5897;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5898;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5899;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5900;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5901;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 5902;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 5903;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 5904;
			case JungleButton::JungleButton(JungleButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 5905;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8330;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8331;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8332;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8333;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8334;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8335;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8336;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8337;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8338;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8339;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8340;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8341;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8342;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8343;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8344;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8345;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8346;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8347;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8348;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8349;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8350;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8351;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8352;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8353;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8354;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8355;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8356;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8357;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8358;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8359;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8360;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_ZP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8361;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8362;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8363;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8364;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8365;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8366;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8367;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8368;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8369;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8370;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8371;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8372;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8373;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8374;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8375;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8376;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XM, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8377;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, true).ID: return 8378;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, true, false).ID: return 8379;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, true).ID: return 8380;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Left, false, false).ID: return 8381;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, true).ID: return 8382;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, true, false).ID: return 8383;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, true).ID: return 8384;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Upper, JungleDoor::Hinge::Right, false, false).ID: return 8385;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, true).ID: return 8386;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, true, false).ID: return 8387;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, true).ID: return 8388;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Left, false, false).ID: return 8389;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, true).ID: return 8390;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, true, false).ID: return 8391;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, true).ID: return 8392;
			case JungleDoor::JungleDoor(eBlockFace::BLOCK_FACE_XP, JungleDoor::Half::Lower, JungleDoor::Hinge::Right, false, false).ID: return 8393;
			case JungleFence::JungleFence(true, true, true, true).ID: return 8108;
			case JungleFence::JungleFence(true, true, true, false).ID: return 8109;
			case JungleFence::JungleFence(true, true, false, true).ID: return 8112;
			case JungleFence::JungleFence(true, true, false, false).ID: return 8113;
			case JungleFence::JungleFence(true, false, true, true).ID: return 8116;
			case JungleFence::JungleFence(true, false, true, false).ID: return 8117;
			case JungleFence::JungleFence(true, false, false, true).ID: return 8120;
			case JungleFence::JungleFence(true, false, false, false).ID: return 8121;
			case JungleFence::JungleFence(false, true, true, true).ID: return 8124;
			case JungleFence::JungleFence(false, true, true, false).ID: return 8125;
			case JungleFence::JungleFence(false, true, false, true).ID: return 8128;
			case JungleFence::JungleFence(false, true, false, false).ID: return 8129;
			case JungleFence::JungleFence(false, false, true, true).ID: return 8132;
			case JungleFence::JungleFence(false, false, true, false).ID: return 8133;
			case JungleFence::JungleFence(false, false, false, true).ID: return 8136;
			case JungleFence::JungleFence(false, false, false, false).ID: return 8137;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 7946;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 7947;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 7948;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 7949;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 7950;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 7951;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 7952;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 7953;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 7954;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 7955;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 7956;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 7957;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 7958;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 7959;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 7960;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 7961;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 7962;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 7963;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 7964;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 7965;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 7966;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 7967;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 7968;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 7969;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 7970;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 7971;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 7972;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 7973;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 7974;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 7975;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 7976;
			case JungleFenceGate::JungleFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 7977;
			case JungleLeaves::JungleLeaves(1, true).ID: return 186;
			case JungleLeaves::JungleLeaves(1, false).ID: return 187;
			case JungleLeaves::JungleLeaves(2, true).ID: return 188;
			case JungleLeaves::JungleLeaves(2, false).ID: return 189;
			case JungleLeaves::JungleLeaves(3, true).ID: return 190;
			case JungleLeaves::JungleLeaves(3, false).ID: return 191;
			case JungleLeaves::JungleLeaves(4, true).ID: return 192;
			case JungleLeaves::JungleLeaves(4, false).ID: return 193;
			case JungleLeaves::JungleLeaves(5, true).ID: return 194;
			case JungleLeaves::JungleLeaves(5, false).ID: return 195;
			case JungleLeaves::JungleLeaves(6, true).ID: return 196;
			case JungleLeaves::JungleLeaves(6, false).ID: return 197;
			case JungleLeaves::JungleLeaves(7, true).ID: return 198;
			case JungleLeaves::JungleLeaves(7, false).ID: return 199;
			case JungleLog::JungleLog(JungleLog::Axis::X).ID: return 81;
			case JungleLog::JungleLog(JungleLog::Axis::Y).ID: return 82;
			case JungleLog::JungleLog(JungleLog::Axis::Z).ID: return 83;
			case JunglePlanks::JunglePlanks().ID: return 18;
			case JunglePressurePlate::JunglePressurePlate(true).ID: return 3877;
			case JunglePressurePlate::JunglePressurePlate(false).ID: return 3878;
			case JungleSapling::JungleSapling(0).ID: return 27;
			case JungleSapling::JungleSapling(1).ID: return 28;
			case JungleSign::JungleSign(0).ID: return 3508;
			case JungleSign::JungleSign(1).ID: return 3510;
			case JungleSign::JungleSign(2).ID: return 3512;
			case JungleSign::JungleSign(3).ID: return 3514;
			case JungleSign::JungleSign(4).ID: return 3516;
			case JungleSign::JungleSign(5).ID: return 3518;
			case JungleSign::JungleSign(6).ID: return 3520;
			case JungleSign::JungleSign(7).ID: return 3522;
			case JungleSign::JungleSign(8).ID: return 3524;
			case JungleSign::JungleSign(9).ID: return 3526;
			case JungleSign::JungleSign(10).ID: return 3528;
			case JungleSign::JungleSign(11).ID: return 3530;
			case JungleSign::JungleSign(12).ID: return 3532;
			case JungleSign::JungleSign(13).ID: return 3534;
			case JungleSign::JungleSign(14).ID: return 3536;
			case JungleSign::JungleSign(15).ID: return 3538;
			case JungleSlab::JungleSlab(JungleSlab::Type::Top).ID: return 7783;
			case JungleSlab::JungleSlab(JungleSlab::Type::Bottom).ID: return 7785;
			case JungleSlab::JungleSlab(JungleSlab::Type::Double).ID: return 7787;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5549;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5551;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5553;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5555;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5557;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5559;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5561;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5563;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5565;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5567;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5569;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5571;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5573;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5575;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5577;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5579;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5581;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5583;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5585;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_ZP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5587;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5589;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5591;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5593;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5595;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5597;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5599;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5601;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5603;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5605;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XM, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5607;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::Straight).ID: return 5609;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::InnerLeft).ID: return 5611;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::InnerRight).ID: return 5613;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::OuterLeft).ID: return 5615;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Top, JungleStairs::Shape::OuterRight).ID: return 5617;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::Straight).ID: return 5619;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerLeft).ID: return 5621;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::InnerRight).ID: return 5623;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterLeft).ID: return 5625;
			case JungleStairs::JungleStairs(eBlockFace::BLOCK_FACE_XP, JungleStairs::Half::Bottom, JungleStairs::Shape::OuterRight).ID: return 5627;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, true, true).ID: return 4290;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, true, false).ID: return 4292;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, false, true).ID: return 4294;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Top, false, false).ID: return 4296;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, true, true).ID: return 4298;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, true, false).ID: return 4300;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, false, true).ID: return 4302;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZM, JungleTrapdoor::Half::Bottom, false, false).ID: return 4304;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, true, true).ID: return 4306;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, true, false).ID: return 4308;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, false, true).ID: return 4310;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Top, false, false).ID: return 4312;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, true, true).ID: return 4314;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, true, false).ID: return 4316;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, false, true).ID: return 4318;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_ZP, JungleTrapdoor::Half::Bottom, false, false).ID: return 4320;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, true, true).ID: return 4322;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, true, false).ID: return 4324;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, false, true).ID: return 4326;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Top, false, false).ID: return 4328;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, true, true).ID: return 4330;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, true, false).ID: return 4332;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, false, true).ID: return 4334;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XM, JungleTrapdoor::Half::Bottom, false, false).ID: return 4336;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, true, true).ID: return 4338;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, true, false).ID: return 4340;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, false, true).ID: return 4342;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Top, false, false).ID: return 4344;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, true, true).ID: return 4346;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, true, false).ID: return 4348;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, false, true).ID: return 4350;
			case JungleTrapdoor::JungleTrapdoor(eBlockFace::BLOCK_FACE_XP, JungleTrapdoor::Half::Bottom, false, false).ID: return 4352;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3766;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3768;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3770;
			case JungleWallSign::JungleWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3772;
			case JungleWood::JungleWood(JungleWood::Axis::X).ID: return 117;
			case JungleWood::JungleWood(JungleWood::Axis::Y).ID: return 118;
			case JungleWood::JungleWood(JungleWood::Axis::Z).ID: return 119;
			case Kelp::Kelp(0).ID: return 8934;
			case Kelp::Kelp(1).ID: return 8935;
			case Kelp::Kelp(2).ID: return 8936;
			case Kelp::Kelp(3).ID: return 8937;
			case Kelp::Kelp(4).ID: return 8938;
			case Kelp::Kelp(5).ID: return 8939;
			case Kelp::Kelp(6).ID: return 8940;
			case Kelp::Kelp(7).ID: return 8941;
			case Kelp::Kelp(8).ID: return 8942;
			case Kelp::Kelp(9).ID: return 8943;
			case Kelp::Kelp(10).ID: return 8944;
			case Kelp::Kelp(11).ID: return 8945;
			case Kelp::Kelp(12).ID: return 8946;
			case Kelp::Kelp(13).ID: return 8947;
			case Kelp::Kelp(14).ID: return 8948;
			case Kelp::Kelp(15).ID: return 8949;
			case Kelp::Kelp(16).ID: return 8950;
			case Kelp::Kelp(17).ID: return 8951;
			case Kelp::Kelp(18).ID: return 8952;
			case Kelp::Kelp(19).ID: return 8953;
			case Kelp::Kelp(20).ID: return 8954;
			case Kelp::Kelp(21).ID: return 8955;
			case Kelp::Kelp(22).ID: return 8956;
			case Kelp::Kelp(23).ID: return 8957;
			case Kelp::Kelp(24).ID: return 8958;
			case Kelp::Kelp(25).ID: return 8959;
			case KelpPlant::KelpPlant().ID: return 8960;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_ZM).ID: return 3636;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_ZP).ID: return 3638;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_XM).ID: return 3640;
			case Ladder::Ladder(eBlockFace::BLOCK_FACE_XP).ID: return 3642;
			case Lantern::Lantern(true).ID: return 11214;
			case Lantern::Lantern(false).ID: return 11215;
			case LapisBlock::LapisBlock().ID: return 232;
			case LapisOre::LapisOre().ID: return 231;
			case LargeFern::LargeFern(LargeFern::Half::Upper).ID: return 7359;
			case LargeFern::LargeFern(LargeFern::Half::Lower).ID: return 7360;
			case Lava::Lava(0).ID: return 50;
			case Lava::Lava(1).ID: return 51;
			case Lava::Lava(2).ID: return 52;
			case Lava::Lava(3).ID: return 53;
			case Lava::Lava(4).ID: return 54;
			case Lava::Lava(5).ID: return 55;
			case Lava::Lava(6).ID: return 56;
			case Lava::Lava(7).ID: return 57;
			case Lava::Lava(8).ID: return 58;
			case Lava::Lava(9).ID: return 59;
			case Lava::Lava(10).ID: return 60;
			case Lava::Lava(11).ID: return 61;
			case Lava::Lava(12).ID: return 62;
			case Lava::Lava(13).ID: return 63;
			case Lava::Lava(14).ID: return 64;
			case Lava::Lava(15).ID: return 65;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 11177;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 11178;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 11179;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 11180;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 11181;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 11182;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 11183;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 11184;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, true, true).ID: return 11185;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, true, false).ID: return 11186;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, false, true).ID: return 11187;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XM, false, false).ID: return 11188;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, true, true).ID: return 11189;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, true, false).ID: return 11190;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, false, true).ID: return 11191;
			case Lectern::Lectern(eBlockFace::BLOCK_FACE_XP, false, false).ID: return 11192;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3781;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3782;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3783;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3784;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 3785;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 3786;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 3787;
			case Lever::Lever(Lever::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 3788;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3789;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3790;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3791;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3792;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 3793;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 3794;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 3795;
			case Lever::Lever(Lever::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 3796;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3797;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3798;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3799;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3800;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 3801;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 3802;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 3803;
			case Lever::Lever(Lever::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 3804;
			case LightBlueBanner::LightBlueBanner(0).ID: return 7409;
			case LightBlueBanner::LightBlueBanner(1).ID: return 7410;
			case LightBlueBanner::LightBlueBanner(2).ID: return 7411;
			case LightBlueBanner::LightBlueBanner(3).ID: return 7412;
			case LightBlueBanner::LightBlueBanner(4).ID: return 7413;
			case LightBlueBanner::LightBlueBanner(5).ID: return 7414;
			case LightBlueBanner::LightBlueBanner(6).ID: return 7415;
			case LightBlueBanner::LightBlueBanner(7).ID: return 7416;
			case LightBlueBanner::LightBlueBanner(8).ID: return 7417;
			case LightBlueBanner::LightBlueBanner(9).ID: return 7418;
			case LightBlueBanner::LightBlueBanner(10).ID: return 7419;
			case LightBlueBanner::LightBlueBanner(11).ID: return 7420;
			case LightBlueBanner::LightBlueBanner(12).ID: return 7421;
			case LightBlueBanner::LightBlueBanner(13).ID: return 7422;
			case LightBlueBanner::LightBlueBanner(14).ID: return 7423;
			case LightBlueBanner::LightBlueBanner(15).ID: return 7424;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, true, LightBlueBed::Part::Head).ID: return 1096;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, true, LightBlueBed::Part::Foot).ID: return 1097;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, false, LightBlueBed::Part::Head).ID: return 1098;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZM, false, LightBlueBed::Part::Foot).ID: return 1099;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, true, LightBlueBed::Part::Head).ID: return 1100;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, true, LightBlueBed::Part::Foot).ID: return 1101;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, false, LightBlueBed::Part::Head).ID: return 1102;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_ZP, false, LightBlueBed::Part::Foot).ID: return 1103;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, true, LightBlueBed::Part::Head).ID: return 1104;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, true, LightBlueBed::Part::Foot).ID: return 1105;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, false, LightBlueBed::Part::Head).ID: return 1106;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XM, false, LightBlueBed::Part::Foot).ID: return 1107;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, true, LightBlueBed::Part::Head).ID: return 1108;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, true, LightBlueBed::Part::Foot).ID: return 1109;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, false, LightBlueBed::Part::Head).ID: return 1110;
			case LightBlueBed::LightBlueBed(eBlockFace::BLOCK_FACE_XP, false, LightBlueBed::Part::Foot).ID: return 1111;
			case LightBlueCarpet::LightBlueCarpet().ID: return 7333;
			case LightBlueConcrete::LightBlueConcrete().ID: return 8905;
			case LightBlueConcretePowder::LightBlueConcretePowder().ID: return 8921;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8850;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8851;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8852;
			case LightBlueGlazedTerracotta::LightBlueGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8853;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8760;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8761;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8762;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8763;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8764;
			case LightBlueShulkerBox::LightBlueShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8765;
			case LightBlueStainedGlass::LightBlueStainedGlass().ID: return 4084;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, true, true).ID: return 6425;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, true, false).ID: return 6426;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, false, true).ID: return 6429;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, true, false, false).ID: return 6430;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, true, true).ID: return 6433;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, true, false).ID: return 6434;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, false, true).ID: return 6437;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(true, false, false, false).ID: return 6438;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, true, true).ID: return 6441;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, true, false).ID: return 6442;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, false, true).ID: return 6445;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, true, false, false).ID: return 6446;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, true, true).ID: return 6449;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, true, false).ID: return 6450;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, false, true).ID: return 6453;
			case LightBlueStainedGlassPane::LightBlueStainedGlassPane(false, false, false, false).ID: return 6454;
			case LightBlueTerracotta::LightBlueTerracotta().ID: return 6314;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7629;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7630;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7631;
			case LightBlueWallBanner::LightBlueWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7632;
			case LightBlueWool::LightBlueWool().ID: return 1386;
			case LightGrayBanner::LightGrayBanner(0).ID: return 7489;
			case LightGrayBanner::LightGrayBanner(1).ID: return 7490;
			case LightGrayBanner::LightGrayBanner(2).ID: return 7491;
			case LightGrayBanner::LightGrayBanner(3).ID: return 7492;
			case LightGrayBanner::LightGrayBanner(4).ID: return 7493;
			case LightGrayBanner::LightGrayBanner(5).ID: return 7494;
			case LightGrayBanner::LightGrayBanner(6).ID: return 7495;
			case LightGrayBanner::LightGrayBanner(7).ID: return 7496;
			case LightGrayBanner::LightGrayBanner(8).ID: return 7497;
			case LightGrayBanner::LightGrayBanner(9).ID: return 7498;
			case LightGrayBanner::LightGrayBanner(10).ID: return 7499;
			case LightGrayBanner::LightGrayBanner(11).ID: return 7500;
			case LightGrayBanner::LightGrayBanner(12).ID: return 7501;
			case LightGrayBanner::LightGrayBanner(13).ID: return 7502;
			case LightGrayBanner::LightGrayBanner(14).ID: return 7503;
			case LightGrayBanner::LightGrayBanner(15).ID: return 7504;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, true, LightGrayBed::Part::Head).ID: return 1176;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, true, LightGrayBed::Part::Foot).ID: return 1177;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, false, LightGrayBed::Part::Head).ID: return 1178;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZM, false, LightGrayBed::Part::Foot).ID: return 1179;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, true, LightGrayBed::Part::Head).ID: return 1180;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, true, LightGrayBed::Part::Foot).ID: return 1181;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, false, LightGrayBed::Part::Head).ID: return 1182;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_ZP, false, LightGrayBed::Part::Foot).ID: return 1183;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, true, LightGrayBed::Part::Head).ID: return 1184;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, true, LightGrayBed::Part::Foot).ID: return 1185;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, false, LightGrayBed::Part::Head).ID: return 1186;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XM, false, LightGrayBed::Part::Foot).ID: return 1187;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, true, LightGrayBed::Part::Head).ID: return 1188;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, true, LightGrayBed::Part::Foot).ID: return 1189;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, false, LightGrayBed::Part::Head).ID: return 1190;
			case LightGrayBed::LightGrayBed(eBlockFace::BLOCK_FACE_XP, false, LightGrayBed::Part::Foot).ID: return 1191;
			case LightGrayCarpet::LightGrayCarpet().ID: return 7338;
			case LightGrayConcrete::LightGrayConcrete().ID: return 8910;
			case LightGrayConcretePowder::LightGrayConcretePowder().ID: return 8926;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8870;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8871;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8872;
			case LightGrayGlazedTerracotta::LightGrayGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8873;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8790;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8791;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8792;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8793;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8794;
			case LightGrayShulkerBox::LightGrayShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8795;
			case LightGrayStainedGlass::LightGrayStainedGlass().ID: return 4089;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, true, true).ID: return 6585;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, true, false).ID: return 6586;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, false, true).ID: return 6589;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, true, false, false).ID: return 6590;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, true, true).ID: return 6593;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, true, false).ID: return 6594;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, false, true).ID: return 6597;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(true, false, false, false).ID: return 6598;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, true, true).ID: return 6601;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, true, false).ID: return 6602;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, false, true).ID: return 6605;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, true, false, false).ID: return 6606;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, true, true).ID: return 6609;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, true, false).ID: return 6610;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, false, true).ID: return 6613;
			case LightGrayStainedGlassPane::LightGrayStainedGlassPane(false, false, false, false).ID: return 6614;
			case LightGrayTerracotta::LightGrayTerracotta().ID: return 6319;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7649;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7650;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7651;
			case LightGrayWallBanner::LightGrayWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7652;
			case LightGrayWool::LightGrayWool().ID: return 1391;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(0).ID: return 6110;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(1).ID: return 6111;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(2).ID: return 6112;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(3).ID: return 6113;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(4).ID: return 6114;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(5).ID: return 6115;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(6).ID: return 6116;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(7).ID: return 6117;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(8).ID: return 6118;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(9).ID: return 6119;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(10).ID: return 6120;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(11).ID: return 6121;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(12).ID: return 6122;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(13).ID: return 6123;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(14).ID: return 6124;
			case LightWeightedPressurePlate::LightWeightedPressurePlate(15).ID: return 6125;
			case Lilac::Lilac(Lilac::Half::Upper).ID: return 7351;
			case Lilac::Lilac(Lilac::Half::Lower).ID: return 7352;
			case LilyOfTheValley::LilyOfTheValley().ID: return 1423;
			case LilyPad::LilyPad().ID: return 4998;
			case LimeBanner::LimeBanner(0).ID: return 7441;
			case LimeBanner::LimeBanner(1).ID: return 7442;
			case LimeBanner::LimeBanner(2).ID: return 7443;
			case LimeBanner::LimeBanner(3).ID: return 7444;
			case LimeBanner::LimeBanner(4).ID: return 7445;
			case LimeBanner::LimeBanner(5).ID: return 7446;
			case LimeBanner::LimeBanner(6).ID: return 7447;
			case LimeBanner::LimeBanner(7).ID: return 7448;
			case LimeBanner::LimeBanner(8).ID: return 7449;
			case LimeBanner::LimeBanner(9).ID: return 7450;
			case LimeBanner::LimeBanner(10).ID: return 7451;
			case LimeBanner::LimeBanner(11).ID: return 7452;
			case LimeBanner::LimeBanner(12).ID: return 7453;
			case LimeBanner::LimeBanner(13).ID: return 7454;
			case LimeBanner::LimeBanner(14).ID: return 7455;
			case LimeBanner::LimeBanner(15).ID: return 7456;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, true, LimeBed::Part::Head).ID: return 1128;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, true, LimeBed::Part::Foot).ID: return 1129;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, false, LimeBed::Part::Head).ID: return 1130;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZM, false, LimeBed::Part::Foot).ID: return 1131;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, true, LimeBed::Part::Head).ID: return 1132;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, true, LimeBed::Part::Foot).ID: return 1133;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, false, LimeBed::Part::Head).ID: return 1134;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_ZP, false, LimeBed::Part::Foot).ID: return 1135;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, true, LimeBed::Part::Head).ID: return 1136;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, true, LimeBed::Part::Foot).ID: return 1137;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, false, LimeBed::Part::Head).ID: return 1138;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XM, false, LimeBed::Part::Foot).ID: return 1139;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, true, LimeBed::Part::Head).ID: return 1140;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, true, LimeBed::Part::Foot).ID: return 1141;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, false, LimeBed::Part::Head).ID: return 1142;
			case LimeBed::LimeBed(eBlockFace::BLOCK_FACE_XP, false, LimeBed::Part::Foot).ID: return 1143;
			case LimeCarpet::LimeCarpet().ID: return 7335;
			case LimeConcrete::LimeConcrete().ID: return 8907;
			case LimeConcretePowder::LimeConcretePowder().ID: return 8923;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8858;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8859;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8860;
			case LimeGlazedTerracotta::LimeGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8861;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8772;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8773;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8774;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8775;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8776;
			case LimeShulkerBox::LimeShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8777;
			case LimeStainedGlass::LimeStainedGlass().ID: return 4086;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, true, true).ID: return 6489;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, true, false).ID: return 6490;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, false, true).ID: return 6493;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, true, false, false).ID: return 6494;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, true, true).ID: return 6497;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, true, false).ID: return 6498;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, false, true).ID: return 6501;
			case LimeStainedGlassPane::LimeStainedGlassPane(true, false, false, false).ID: return 6502;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, true, true).ID: return 6505;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, true, false).ID: return 6506;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, false, true).ID: return 6509;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, true, false, false).ID: return 6510;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, true, true).ID: return 6513;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, true, false).ID: return 6514;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, false, true).ID: return 6517;
			case LimeStainedGlassPane::LimeStainedGlassPane(false, false, false, false).ID: return 6518;
			case LimeTerracotta::LimeTerracotta().ID: return 6316;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7637;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7638;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7639;
			case LimeWallBanner::LimeWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7640;
			case LimeWool::LimeWool().ID: return 1388;
			case Loom::Loom(eBlockFace::BLOCK_FACE_ZM).ID: return 11131;
			case Loom::Loom(eBlockFace::BLOCK_FACE_ZP).ID: return 11132;
			case Loom::Loom(eBlockFace::BLOCK_FACE_XM).ID: return 11133;
			case Loom::Loom(eBlockFace::BLOCK_FACE_XP).ID: return 11134;
			case MagentaBanner::MagentaBanner(0).ID: return 7393;
			case MagentaBanner::MagentaBanner(1).ID: return 7394;
			case MagentaBanner::MagentaBanner(2).ID: return 7395;
			case MagentaBanner::MagentaBanner(3).ID: return 7396;
			case MagentaBanner::MagentaBanner(4).ID: return 7397;
			case MagentaBanner::MagentaBanner(5).ID: return 7398;
			case MagentaBanner::MagentaBanner(6).ID: return 7399;
			case MagentaBanner::MagentaBanner(7).ID: return 7400;
			case MagentaBanner::MagentaBanner(8).ID: return 7401;
			case MagentaBanner::MagentaBanner(9).ID: return 7402;
			case MagentaBanner::MagentaBanner(10).ID: return 7403;
			case MagentaBanner::MagentaBanner(11).ID: return 7404;
			case MagentaBanner::MagentaBanner(12).ID: return 7405;
			case MagentaBanner::MagentaBanner(13).ID: return 7406;
			case MagentaBanner::MagentaBanner(14).ID: return 7407;
			case MagentaBanner::MagentaBanner(15).ID: return 7408;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, true, MagentaBed::Part::Head).ID: return 1080;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, true, MagentaBed::Part::Foot).ID: return 1081;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, false, MagentaBed::Part::Head).ID: return 1082;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZM, false, MagentaBed::Part::Foot).ID: return 1083;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, true, MagentaBed::Part::Head).ID: return 1084;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, true, MagentaBed::Part::Foot).ID: return 1085;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, false, MagentaBed::Part::Head).ID: return 1086;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_ZP, false, MagentaBed::Part::Foot).ID: return 1087;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, true, MagentaBed::Part::Head).ID: return 1088;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, true, MagentaBed::Part::Foot).ID: return 1089;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, false, MagentaBed::Part::Head).ID: return 1090;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XM, false, MagentaBed::Part::Foot).ID: return 1091;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, true, MagentaBed::Part::Head).ID: return 1092;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, true, MagentaBed::Part::Foot).ID: return 1093;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, false, MagentaBed::Part::Head).ID: return 1094;
			case MagentaBed::MagentaBed(eBlockFace::BLOCK_FACE_XP, false, MagentaBed::Part::Foot).ID: return 1095;
			case MagentaCarpet::MagentaCarpet().ID: return 7332;
			case MagentaConcrete::MagentaConcrete().ID: return 8904;
			case MagentaConcretePowder::MagentaConcretePowder().ID: return 8920;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8846;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8847;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8848;
			case MagentaGlazedTerracotta::MagentaGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8849;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8754;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8755;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8756;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8757;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8758;
			case MagentaShulkerBox::MagentaShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8759;
			case MagentaStainedGlass::MagentaStainedGlass().ID: return 4083;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, true, true).ID: return 6393;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, true, false).ID: return 6394;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, false, true).ID: return 6397;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, true, false, false).ID: return 6398;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, true, true).ID: return 6401;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, true, false).ID: return 6402;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, false, true).ID: return 6405;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(true, false, false, false).ID: return 6406;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, true, true).ID: return 6409;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, true, false).ID: return 6410;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, false, true).ID: return 6413;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, true, false, false).ID: return 6414;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, true, true).ID: return 6417;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, true, false).ID: return 6418;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, false, true).ID: return 6421;
			case MagentaStainedGlassPane::MagentaStainedGlassPane(false, false, false, false).ID: return 6422;
			case MagentaTerracotta::MagentaTerracotta().ID: return 6313;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7625;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7626;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7627;
			case MagentaWallBanner::MagentaWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7628;
			case MagentaWool::MagentaWool().ID: return 1385;
			case MagmaBlock::MagmaBlock().ID: return 8717;
			case Melon::Melon().ID: return 4747;
			case MelonStem::MelonStem(0).ID: return 4764;
			case MelonStem::MelonStem(1).ID: return 4765;
			case MelonStem::MelonStem(2).ID: return 4766;
			case MelonStem::MelonStem(3).ID: return 4767;
			case MelonStem::MelonStem(4).ID: return 4768;
			case MelonStem::MelonStem(5).ID: return 4769;
			case MelonStem::MelonStem(6).ID: return 4770;
			case MelonStem::MelonStem(7).ID: return 4771;
			case MossyCobblestone::MossyCobblestone().ID: return 1432;
			case MossyCobblestoneSlab::MossyCobblestoneSlab(MossyCobblestoneSlab::Type::Top).ID: return 10278;
			case MossyCobblestoneSlab::MossyCobblestoneSlab(MossyCobblestoneSlab::Type::Bottom).ID: return 10280;
			case MossyCobblestoneSlab::MossyCobblestoneSlab(MossyCobblestoneSlab::Type::Double).ID: return 10282;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 9454;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9456;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9458;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9460;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9462;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 9464;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9466;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9468;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9470;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9472;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 9474;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9476;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9478;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9480;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9482;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 9484;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9486;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9488;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9490;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_ZP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9492;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 9494;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9496;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9498;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9500;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9502;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 9504;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9506;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9508;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9510;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XM, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9512;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::Straight).ID: return 9514;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9516;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9518;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9520;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Top, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9522;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::Straight).ID: return 9524;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerLeft).ID: return 9526;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::InnerRight).ID: return 9528;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterLeft).ID: return 9530;
			case MossyCobblestoneStairs::MossyCobblestoneStairs(eBlockFace::BLOCK_FACE_XP, MossyCobblestoneStairs::Half::Bottom, MossyCobblestoneStairs::Shape::OuterRight).ID: return 9532;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 5707;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 5708;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 5711;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 5712;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 5715;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 5716;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 5719;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 5720;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 5723;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 5724;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 5727;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 5728;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 5731;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 5732;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 5735;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::Low, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 5736;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 5739;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 5740;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 5743;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 5744;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 5747;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 5748;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 5751;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::Low, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 5752;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::Low).ID: return 5755;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, true, MossyCobblestoneWall::West::None).ID: return 5756;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::Low).ID: return 5759;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::Low, false, MossyCobblestoneWall::West::None).ID: return 5760;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::Low).ID: return 5763;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, true, MossyCobblestoneWall::West::None).ID: return 5764;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::Low).ID: return 5767;
			case MossyCobblestoneWall::MossyCobblestoneWall(MossyCobblestoneWall::East::None, MossyCobblestoneWall::North::None, MossyCobblestoneWall::South::None, false, MossyCobblestoneWall::West::None).ID: return 5768;
			case MossyStoneBrickSlab::MossyStoneBrickSlab(MossyStoneBrickSlab::Type::Top).ID: return 10266;
			case MossyStoneBrickSlab::MossyStoneBrickSlab(MossyStoneBrickSlab::Type::Bottom).ID: return 10268;
			case MossyStoneBrickSlab::MossyStoneBrickSlab(MossyStoneBrickSlab::Type::Double).ID: return 10270;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9294;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9296;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9298;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9300;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9302;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9304;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9306;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9308;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9310;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9312;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9314;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9316;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9318;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9320;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9322;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9324;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9326;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9328;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9330;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9332;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9334;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9336;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9338;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9340;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9342;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9344;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9346;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9348;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9350;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XM, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9352;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::Straight).ID: return 9354;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9356;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9358;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9360;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Top, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9362;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::Straight).ID: return 9364;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerLeft).ID: return 9366;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::InnerRight).ID: return 9368;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterLeft).ID: return 9370;
			case MossyStoneBrickStairs::MossyStoneBrickStairs(eBlockFace::BLOCK_FACE_XP, MossyStoneBrickStairs::Half::Bottom, MossyStoneBrickStairs::Shape::OuterRight).ID: return 9372;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 10525;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 10526;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 10529;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 10530;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 10533;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 10534;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 10537;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 10538;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 10541;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 10542;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 10545;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 10546;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 10549;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 10550;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 10553;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::Low, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 10554;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 10557;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 10558;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 10561;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 10562;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 10565;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 10566;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 10569;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::Low, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 10570;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::Low).ID: return 10573;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, true, MossyStoneBrickWall::West::None).ID: return 10574;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::Low).ID: return 10577;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::Low, false, MossyStoneBrickWall::West::None).ID: return 10578;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::Low).ID: return 10581;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, true, MossyStoneBrickWall::West::None).ID: return 10582;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::Low).ID: return 10585;
			case MossyStoneBrickWall::MossyStoneBrickWall(MossyStoneBrickWall::East::None, MossyStoneBrickWall::North::None, MossyStoneBrickWall::South::None, false, MossyStoneBrickWall::West::None).ID: return 10586;
			case MossyStoneBricks::MossyStoneBricks().ID: return 4482;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZM, MovingPiston::Type::Normal).ID: return 1399;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZM, MovingPiston::Type::Sticky).ID: return 1400;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XP, MovingPiston::Type::Normal).ID: return 1401;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XP, MovingPiston::Type::Sticky).ID: return 1402;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZP, MovingPiston::Type::Normal).ID: return 1403;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_ZP, MovingPiston::Type::Sticky).ID: return 1404;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XM, MovingPiston::Type::Normal).ID: return 1405;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_XM, MovingPiston::Type::Sticky).ID: return 1406;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YP, MovingPiston::Type::Normal).ID: return 1407;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YP, MovingPiston::Type::Sticky).ID: return 1408;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YM, MovingPiston::Type::Normal).ID: return 1409;
			case MovingPiston::MovingPiston(eBlockFace::BLOCK_FACE_YM, MovingPiston::Type::Sticky).ID: return 1410;
			case MushroomStem::MushroomStem(true, true, true, true, true, true).ID: return 4619;
			case MushroomStem::MushroomStem(true, true, true, true, true, false).ID: return 4620;
			case MushroomStem::MushroomStem(true, true, true, true, false, true).ID: return 4621;
			case MushroomStem::MushroomStem(true, true, true, true, false, false).ID: return 4622;
			case MushroomStem::MushroomStem(true, true, true, false, true, true).ID: return 4623;
			case MushroomStem::MushroomStem(true, true, true, false, true, false).ID: return 4624;
			case MushroomStem::MushroomStem(true, true, true, false, false, true).ID: return 4625;
			case MushroomStem::MushroomStem(true, true, true, false, false, false).ID: return 4626;
			case MushroomStem::MushroomStem(true, true, false, true, true, true).ID: return 4627;
			case MushroomStem::MushroomStem(true, true, false, true, true, false).ID: return 4628;
			case MushroomStem::MushroomStem(true, true, false, true, false, true).ID: return 4629;
			case MushroomStem::MushroomStem(true, true, false, true, false, false).ID: return 4630;
			case MushroomStem::MushroomStem(true, true, false, false, true, true).ID: return 4631;
			case MushroomStem::MushroomStem(true, true, false, false, true, false).ID: return 4632;
			case MushroomStem::MushroomStem(true, true, false, false, false, true).ID: return 4633;
			case MushroomStem::MushroomStem(true, true, false, false, false, false).ID: return 4634;
			case MushroomStem::MushroomStem(true, false, true, true, true, true).ID: return 4635;
			case MushroomStem::MushroomStem(true, false, true, true, true, false).ID: return 4636;
			case MushroomStem::MushroomStem(true, false, true, true, false, true).ID: return 4637;
			case MushroomStem::MushroomStem(true, false, true, true, false, false).ID: return 4638;
			case MushroomStem::MushroomStem(true, false, true, false, true, true).ID: return 4639;
			case MushroomStem::MushroomStem(true, false, true, false, true, false).ID: return 4640;
			case MushroomStem::MushroomStem(true, false, true, false, false, true).ID: return 4641;
			case MushroomStem::MushroomStem(true, false, true, false, false, false).ID: return 4642;
			case MushroomStem::MushroomStem(true, false, false, true, true, true).ID: return 4643;
			case MushroomStem::MushroomStem(true, false, false, true, true, false).ID: return 4644;
			case MushroomStem::MushroomStem(true, false, false, true, false, true).ID: return 4645;
			case MushroomStem::MushroomStem(true, false, false, true, false, false).ID: return 4646;
			case MushroomStem::MushroomStem(true, false, false, false, true, true).ID: return 4647;
			case MushroomStem::MushroomStem(true, false, false, false, true, false).ID: return 4648;
			case MushroomStem::MushroomStem(true, false, false, false, false, true).ID: return 4649;
			case MushroomStem::MushroomStem(true, false, false, false, false, false).ID: return 4650;
			case MushroomStem::MushroomStem(false, true, true, true, true, true).ID: return 4651;
			case MushroomStem::MushroomStem(false, true, true, true, true, false).ID: return 4652;
			case MushroomStem::MushroomStem(false, true, true, true, false, true).ID: return 4653;
			case MushroomStem::MushroomStem(false, true, true, true, false, false).ID: return 4654;
			case MushroomStem::MushroomStem(false, true, true, false, true, true).ID: return 4655;
			case MushroomStem::MushroomStem(false, true, true, false, true, false).ID: return 4656;
			case MushroomStem::MushroomStem(false, true, true, false, false, true).ID: return 4657;
			case MushroomStem::MushroomStem(false, true, true, false, false, false).ID: return 4658;
			case MushroomStem::MushroomStem(false, true, false, true, true, true).ID: return 4659;
			case MushroomStem::MushroomStem(false, true, false, true, true, false).ID: return 4660;
			case MushroomStem::MushroomStem(false, true, false, true, false, true).ID: return 4661;
			case MushroomStem::MushroomStem(false, true, false, true, false, false).ID: return 4662;
			case MushroomStem::MushroomStem(false, true, false, false, true, true).ID: return 4663;
			case MushroomStem::MushroomStem(false, true, false, false, true, false).ID: return 4664;
			case MushroomStem::MushroomStem(false, true, false, false, false, true).ID: return 4665;
			case MushroomStem::MushroomStem(false, true, false, false, false, false).ID: return 4666;
			case MushroomStem::MushroomStem(false, false, true, true, true, true).ID: return 4667;
			case MushroomStem::MushroomStem(false, false, true, true, true, false).ID: return 4668;
			case MushroomStem::MushroomStem(false, false, true, true, false, true).ID: return 4669;
			case MushroomStem::MushroomStem(false, false, true, true, false, false).ID: return 4670;
			case MushroomStem::MushroomStem(false, false, true, false, true, true).ID: return 4671;
			case MushroomStem::MushroomStem(false, false, true, false, true, false).ID: return 4672;
			case MushroomStem::MushroomStem(false, false, true, false, false, true).ID: return 4673;
			case MushroomStem::MushroomStem(false, false, true, false, false, false).ID: return 4674;
			case MushroomStem::MushroomStem(false, false, false, true, true, true).ID: return 4675;
			case MushroomStem::MushroomStem(false, false, false, true, true, false).ID: return 4676;
			case MushroomStem::MushroomStem(false, false, false, true, false, true).ID: return 4677;
			case MushroomStem::MushroomStem(false, false, false, true, false, false).ID: return 4678;
			case MushroomStem::MushroomStem(false, false, false, false, true, true).ID: return 4679;
			case MushroomStem::MushroomStem(false, false, false, false, true, false).ID: return 4680;
			case MushroomStem::MushroomStem(false, false, false, false, false, true).ID: return 4681;
			case MushroomStem::MushroomStem(false, false, false, false, false, false).ID: return 4682;
			case Mycelium::Mycelium(true).ID: return 4996;
			case Mycelium::Mycelium(false).ID: return 4997;
			case NetherBrickFence::NetherBrickFence(true, true, true, true).ID: return 5002;
			case NetherBrickFence::NetherBrickFence(true, true, true, false).ID: return 5003;
			case NetherBrickFence::NetherBrickFence(true, true, false, true).ID: return 5006;
			case NetherBrickFence::NetherBrickFence(true, true, false, false).ID: return 5007;
			case NetherBrickFence::NetherBrickFence(true, false, true, true).ID: return 5010;
			case NetherBrickFence::NetherBrickFence(true, false, true, false).ID: return 5011;
			case NetherBrickFence::NetherBrickFence(true, false, false, true).ID: return 5014;
			case NetherBrickFence::NetherBrickFence(true, false, false, false).ID: return 5015;
			case NetherBrickFence::NetherBrickFence(false, true, true, true).ID: return 5018;
			case NetherBrickFence::NetherBrickFence(false, true, true, false).ID: return 5019;
			case NetherBrickFence::NetherBrickFence(false, true, false, true).ID: return 5022;
			case NetherBrickFence::NetherBrickFence(false, true, false, false).ID: return 5023;
			case NetherBrickFence::NetherBrickFence(false, false, true, true).ID: return 5026;
			case NetherBrickFence::NetherBrickFence(false, false, true, false).ID: return 5027;
			case NetherBrickFence::NetherBrickFence(false, false, false, true).ID: return 5030;
			case NetherBrickFence::NetherBrickFence(false, false, false, false).ID: return 5031;
			case NetherBrickSlab::NetherBrickSlab(NetherBrickSlab::Type::Top).ID: return 7849;
			case NetherBrickSlab::NetherBrickSlab(NetherBrickSlab::Type::Bottom).ID: return 7851;
			case NetherBrickSlab::NetherBrickSlab(NetherBrickSlab::Type::Double).ID: return 7853;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5033;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5035;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5037;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5039;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5041;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5043;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5045;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5047;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5049;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5051;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5053;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5055;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5057;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5059;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5061;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5063;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5065;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5067;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5069;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5071;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5073;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5075;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5077;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5079;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5081;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5083;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5085;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5087;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5089;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XM, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5091;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::Straight).ID: return 5093;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerLeft).ID: return 5095;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::InnerRight).ID: return 5097;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterLeft).ID: return 5099;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Top, NetherBrickStairs::Shape::OuterRight).ID: return 5101;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::Straight).ID: return 5103;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerLeft).ID: return 5105;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::InnerRight).ID: return 5107;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterLeft).ID: return 5109;
			case NetherBrickStairs::NetherBrickStairs(eBlockFace::BLOCK_FACE_XP, NetherBrickStairs::Half::Bottom, NetherBrickStairs::Shape::OuterRight).ID: return 5111;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 10717;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 10718;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 10721;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 10722;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 10725;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 10726;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 10729;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 10730;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 10733;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 10734;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 10737;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 10738;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 10741;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 10742;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 10745;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::Low, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 10746;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 10749;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 10750;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 10753;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 10754;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 10757;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 10758;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 10761;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::Low, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 10762;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::Low).ID: return 10765;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, true, NetherBrickWall::West::None).ID: return 10766;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::Low).ID: return 10769;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::Low, false, NetherBrickWall::West::None).ID: return 10770;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::Low).ID: return 10773;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, true, NetherBrickWall::West::None).ID: return 10774;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::Low).ID: return 10777;
			case NetherBrickWall::NetherBrickWall(NetherBrickWall::East::None, NetherBrickWall::North::None, NetherBrickWall::South::None, false, NetherBrickWall::West::None).ID: return 10778;
			case NetherBricks::NetherBricks().ID: return 4999;
			case NetherPortal::NetherPortal(NetherPortal::Axis::X).ID: return 4000;
			case NetherPortal::NetherPortal(NetherPortal::Axis::Z).ID: return 4001;
			case NetherQuartzOre::NetherQuartzOre().ID: return 6191;
			case NetherWart::NetherWart(0).ID: return 5112;
			case NetherWart::NetherWart(1).ID: return 5113;
			case NetherWart::NetherWart(2).ID: return 5114;
			case NetherWart::NetherWart(3).ID: return 5115;
			case NetherWartBlock::NetherWartBlock().ID: return 8718;
			case Netherrack::Netherrack().ID: return 3997;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 0, true).ID: return 248;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 0, false).ID: return 249;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 1, true).ID: return 250;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 1, false).ID: return 251;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 2, true).ID: return 252;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 2, false).ID: return 253;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 3, true).ID: return 254;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 3, false).ID: return 255;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 4, true).ID: return 256;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 4, false).ID: return 257;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 5, true).ID: return 258;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 5, false).ID: return 259;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 6, true).ID: return 260;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 6, false).ID: return 261;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 7, true).ID: return 262;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 7, false).ID: return 263;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 8, true).ID: return 264;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 8, false).ID: return 265;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 9, true).ID: return 266;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 9, false).ID: return 267;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 10, true).ID: return 268;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 10, false).ID: return 269;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 11, true).ID: return 270;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 11, false).ID: return 271;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 12, true).ID: return 272;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 12, false).ID: return 273;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 13, true).ID: return 274;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 13, false).ID: return 275;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 14, true).ID: return 276;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 14, false).ID: return 277;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 15, true).ID: return 278;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 15, false).ID: return 279;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 16, true).ID: return 280;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 16, false).ID: return 281;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 17, true).ID: return 282;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 17, false).ID: return 283;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 18, true).ID: return 284;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 18, false).ID: return 285;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 19, true).ID: return 286;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 19, false).ID: return 287;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 20, true).ID: return 288;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 20, false).ID: return 289;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 21, true).ID: return 290;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 21, false).ID: return 291;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 22, true).ID: return 292;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 22, false).ID: return 293;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 23, true).ID: return 294;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 23, false).ID: return 295;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 24, true).ID: return 296;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Harp, 24, false).ID: return 297;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 0, true).ID: return 298;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 0, false).ID: return 299;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 1, true).ID: return 300;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 1, false).ID: return 301;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 2, true).ID: return 302;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 2, false).ID: return 303;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 3, true).ID: return 304;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 3, false).ID: return 305;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 4, true).ID: return 306;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 4, false).ID: return 307;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 5, true).ID: return 308;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 5, false).ID: return 309;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 6, true).ID: return 310;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 6, false).ID: return 311;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 7, true).ID: return 312;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 7, false).ID: return 313;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 8, true).ID: return 314;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 8, false).ID: return 315;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 9, true).ID: return 316;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 9, false).ID: return 317;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 10, true).ID: return 318;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 10, false).ID: return 319;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 11, true).ID: return 320;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 11, false).ID: return 321;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 12, true).ID: return 322;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 12, false).ID: return 323;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 13, true).ID: return 324;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 13, false).ID: return 325;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 14, true).ID: return 326;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 14, false).ID: return 327;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 15, true).ID: return 328;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 15, false).ID: return 329;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 16, true).ID: return 330;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 16, false).ID: return 331;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 17, true).ID: return 332;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 17, false).ID: return 333;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 18, true).ID: return 334;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 18, false).ID: return 335;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 19, true).ID: return 336;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 19, false).ID: return 337;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 20, true).ID: return 338;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 20, false).ID: return 339;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 21, true).ID: return 340;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 21, false).ID: return 341;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 22, true).ID: return 342;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 22, false).ID: return 343;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 23, true).ID: return 344;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 23, false).ID: return 345;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 24, true).ID: return 346;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Basedrum, 24, false).ID: return 347;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 0, true).ID: return 348;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 0, false).ID: return 349;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 1, true).ID: return 350;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 1, false).ID: return 351;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 2, true).ID: return 352;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 2, false).ID: return 353;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 3, true).ID: return 354;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 3, false).ID: return 355;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 4, true).ID: return 356;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 4, false).ID: return 357;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 5, true).ID: return 358;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 5, false).ID: return 359;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 6, true).ID: return 360;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 6, false).ID: return 361;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 7, true).ID: return 362;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 7, false).ID: return 363;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 8, true).ID: return 364;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 8, false).ID: return 365;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 9, true).ID: return 366;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 9, false).ID: return 367;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 10, true).ID: return 368;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 10, false).ID: return 369;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 11, true).ID: return 370;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 11, false).ID: return 371;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 12, true).ID: return 372;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 12, false).ID: return 373;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 13, true).ID: return 374;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 13, false).ID: return 375;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 14, true).ID: return 376;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 14, false).ID: return 377;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 15, true).ID: return 378;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 15, false).ID: return 379;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 16, true).ID: return 380;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 16, false).ID: return 381;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 17, true).ID: return 382;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 17, false).ID: return 383;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 18, true).ID: return 384;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 18, false).ID: return 385;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 19, true).ID: return 386;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 19, false).ID: return 387;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 20, true).ID: return 388;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 20, false).ID: return 389;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 21, true).ID: return 390;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 21, false).ID: return 391;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 22, true).ID: return 392;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 22, false).ID: return 393;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 23, true).ID: return 394;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 23, false).ID: return 395;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 24, true).ID: return 396;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Snare, 24, false).ID: return 397;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 0, true).ID: return 398;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 0, false).ID: return 399;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 1, true).ID: return 400;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 1, false).ID: return 401;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 2, true).ID: return 402;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 2, false).ID: return 403;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 3, true).ID: return 404;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 3, false).ID: return 405;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 4, true).ID: return 406;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 4, false).ID: return 407;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 5, true).ID: return 408;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 5, false).ID: return 409;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 6, true).ID: return 410;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 6, false).ID: return 411;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 7, true).ID: return 412;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 7, false).ID: return 413;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 8, true).ID: return 414;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 8, false).ID: return 415;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 9, true).ID: return 416;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 9, false).ID: return 417;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 10, true).ID: return 418;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 10, false).ID: return 419;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 11, true).ID: return 420;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 11, false).ID: return 421;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 12, true).ID: return 422;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 12, false).ID: return 423;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 13, true).ID: return 424;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 13, false).ID: return 425;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 14, true).ID: return 426;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 14, false).ID: return 427;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 15, true).ID: return 428;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 15, false).ID: return 429;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 16, true).ID: return 430;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 16, false).ID: return 431;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 17, true).ID: return 432;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 17, false).ID: return 433;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 18, true).ID: return 434;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 18, false).ID: return 435;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 19, true).ID: return 436;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 19, false).ID: return 437;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 20, true).ID: return 438;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 20, false).ID: return 439;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 21, true).ID: return 440;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 21, false).ID: return 441;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 22, true).ID: return 442;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 22, false).ID: return 443;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 23, true).ID: return 444;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 23, false).ID: return 445;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 24, true).ID: return 446;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Hat, 24, false).ID: return 447;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 0, true).ID: return 448;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 0, false).ID: return 449;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 1, true).ID: return 450;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 1, false).ID: return 451;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 2, true).ID: return 452;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 2, false).ID: return 453;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 3, true).ID: return 454;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 3, false).ID: return 455;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 4, true).ID: return 456;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 4, false).ID: return 457;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 5, true).ID: return 458;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 5, false).ID: return 459;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 6, true).ID: return 460;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 6, false).ID: return 461;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 7, true).ID: return 462;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 7, false).ID: return 463;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 8, true).ID: return 464;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 8, false).ID: return 465;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 9, true).ID: return 466;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 9, false).ID: return 467;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 10, true).ID: return 468;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 10, false).ID: return 469;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 11, true).ID: return 470;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 11, false).ID: return 471;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 12, true).ID: return 472;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 12, false).ID: return 473;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 13, true).ID: return 474;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 13, false).ID: return 475;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 14, true).ID: return 476;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 14, false).ID: return 477;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 15, true).ID: return 478;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 15, false).ID: return 479;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 16, true).ID: return 480;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 16, false).ID: return 481;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 17, true).ID: return 482;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 17, false).ID: return 483;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 18, true).ID: return 484;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 18, false).ID: return 485;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 19, true).ID: return 486;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 19, false).ID: return 487;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 20, true).ID: return 488;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 20, false).ID: return 489;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 21, true).ID: return 490;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 21, false).ID: return 491;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 22, true).ID: return 492;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 22, false).ID: return 493;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 23, true).ID: return 494;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 23, false).ID: return 495;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 24, true).ID: return 496;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bass, 24, false).ID: return 497;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 0, true).ID: return 498;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 0, false).ID: return 499;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 1, true).ID: return 500;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 1, false).ID: return 501;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 2, true).ID: return 502;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 2, false).ID: return 503;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 3, true).ID: return 504;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 3, false).ID: return 505;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 4, true).ID: return 506;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 4, false).ID: return 507;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 5, true).ID: return 508;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 5, false).ID: return 509;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 6, true).ID: return 510;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 6, false).ID: return 511;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 7, true).ID: return 512;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 7, false).ID: return 513;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 8, true).ID: return 514;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 8, false).ID: return 515;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 9, true).ID: return 516;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 9, false).ID: return 517;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 10, true).ID: return 518;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 10, false).ID: return 519;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 11, true).ID: return 520;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 11, false).ID: return 521;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 12, true).ID: return 522;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 12, false).ID: return 523;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 13, true).ID: return 524;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 13, false).ID: return 525;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 14, true).ID: return 526;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 14, false).ID: return 527;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 15, true).ID: return 528;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 15, false).ID: return 529;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 16, true).ID: return 530;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 16, false).ID: return 531;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 17, true).ID: return 532;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 17, false).ID: return 533;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 18, true).ID: return 534;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 18, false).ID: return 535;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 19, true).ID: return 536;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 19, false).ID: return 537;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 20, true).ID: return 538;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 20, false).ID: return 539;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 21, true).ID: return 540;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 21, false).ID: return 541;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 22, true).ID: return 542;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 22, false).ID: return 543;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 23, true).ID: return 544;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 23, false).ID: return 545;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 24, true).ID: return 546;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Flute, 24, false).ID: return 547;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 0, true).ID: return 548;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 0, false).ID: return 549;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 1, true).ID: return 550;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 1, false).ID: return 551;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 2, true).ID: return 552;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 2, false).ID: return 553;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 3, true).ID: return 554;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 3, false).ID: return 555;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 4, true).ID: return 556;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 4, false).ID: return 557;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 5, true).ID: return 558;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 5, false).ID: return 559;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 6, true).ID: return 560;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 6, false).ID: return 561;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 7, true).ID: return 562;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 7, false).ID: return 563;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 8, true).ID: return 564;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 8, false).ID: return 565;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 9, true).ID: return 566;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 9, false).ID: return 567;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 10, true).ID: return 568;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 10, false).ID: return 569;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 11, true).ID: return 570;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 11, false).ID: return 571;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 12, true).ID: return 572;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 12, false).ID: return 573;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 13, true).ID: return 574;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 13, false).ID: return 575;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 14, true).ID: return 576;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 14, false).ID: return 577;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 15, true).ID: return 578;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 15, false).ID: return 579;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 16, true).ID: return 580;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 16, false).ID: return 581;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 17, true).ID: return 582;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 17, false).ID: return 583;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 18, true).ID: return 584;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 18, false).ID: return 585;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 19, true).ID: return 586;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 19, false).ID: return 587;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 20, true).ID: return 588;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 20, false).ID: return 589;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 21, true).ID: return 590;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 21, false).ID: return 591;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 22, true).ID: return 592;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 22, false).ID: return 593;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 23, true).ID: return 594;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 23, false).ID: return 595;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 24, true).ID: return 596;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bell, 24, false).ID: return 597;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 0, true).ID: return 598;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 0, false).ID: return 599;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 1, true).ID: return 600;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 1, false).ID: return 601;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 2, true).ID: return 602;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 2, false).ID: return 603;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 3, true).ID: return 604;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 3, false).ID: return 605;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 4, true).ID: return 606;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 4, false).ID: return 607;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 5, true).ID: return 608;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 5, false).ID: return 609;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 6, true).ID: return 610;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 6, false).ID: return 611;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 7, true).ID: return 612;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 7, false).ID: return 613;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 8, true).ID: return 614;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 8, false).ID: return 615;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 9, true).ID: return 616;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 9, false).ID: return 617;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 10, true).ID: return 618;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 10, false).ID: return 619;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 11, true).ID: return 620;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 11, false).ID: return 621;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 12, true).ID: return 622;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 12, false).ID: return 623;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 13, true).ID: return 624;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 13, false).ID: return 625;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 14, true).ID: return 626;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 14, false).ID: return 627;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 15, true).ID: return 628;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 15, false).ID: return 629;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 16, true).ID: return 630;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 16, false).ID: return 631;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 17, true).ID: return 632;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 17, false).ID: return 633;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 18, true).ID: return 634;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 18, false).ID: return 635;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 19, true).ID: return 636;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 19, false).ID: return 637;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 20, true).ID: return 638;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 20, false).ID: return 639;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 21, true).ID: return 640;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 21, false).ID: return 641;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 22, true).ID: return 642;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 22, false).ID: return 643;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 23, true).ID: return 644;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 23, false).ID: return 645;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 24, true).ID: return 646;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Guitar, 24, false).ID: return 647;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 0, true).ID: return 648;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 0, false).ID: return 649;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 1, true).ID: return 650;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 1, false).ID: return 651;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 2, true).ID: return 652;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 2, false).ID: return 653;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 3, true).ID: return 654;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 3, false).ID: return 655;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 4, true).ID: return 656;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 4, false).ID: return 657;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 5, true).ID: return 658;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 5, false).ID: return 659;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 6, true).ID: return 660;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 6, false).ID: return 661;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 7, true).ID: return 662;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 7, false).ID: return 663;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 8, true).ID: return 664;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 8, false).ID: return 665;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 9, true).ID: return 666;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 9, false).ID: return 667;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 10, true).ID: return 668;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 10, false).ID: return 669;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 11, true).ID: return 670;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 11, false).ID: return 671;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 12, true).ID: return 672;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 12, false).ID: return 673;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 13, true).ID: return 674;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 13, false).ID: return 675;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 14, true).ID: return 676;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 14, false).ID: return 677;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 15, true).ID: return 678;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 15, false).ID: return 679;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 16, true).ID: return 680;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 16, false).ID: return 681;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 17, true).ID: return 682;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 17, false).ID: return 683;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 18, true).ID: return 684;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 18, false).ID: return 685;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 19, true).ID: return 686;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 19, false).ID: return 687;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 20, true).ID: return 688;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 20, false).ID: return 689;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 21, true).ID: return 690;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 21, false).ID: return 691;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 22, true).ID: return 692;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 22, false).ID: return 693;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 23, true).ID: return 694;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 23, false).ID: return 695;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 24, true).ID: return 696;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Chime, 24, false).ID: return 697;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 0, true).ID: return 698;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 0, false).ID: return 699;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 1, true).ID: return 700;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 1, false).ID: return 701;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 2, true).ID: return 702;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 2, false).ID: return 703;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 3, true).ID: return 704;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 3, false).ID: return 705;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 4, true).ID: return 706;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 4, false).ID: return 707;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 5, true).ID: return 708;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 5, false).ID: return 709;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 6, true).ID: return 710;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 6, false).ID: return 711;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 7, true).ID: return 712;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 7, false).ID: return 713;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 8, true).ID: return 714;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 8, false).ID: return 715;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 9, true).ID: return 716;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 9, false).ID: return 717;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 10, true).ID: return 718;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 10, false).ID: return 719;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 11, true).ID: return 720;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 11, false).ID: return 721;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 12, true).ID: return 722;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 12, false).ID: return 723;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 13, true).ID: return 724;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 13, false).ID: return 725;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 14, true).ID: return 726;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 14, false).ID: return 727;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 15, true).ID: return 728;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 15, false).ID: return 729;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 16, true).ID: return 730;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 16, false).ID: return 731;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 17, true).ID: return 732;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 17, false).ID: return 733;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 18, true).ID: return 734;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 18, false).ID: return 735;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 19, true).ID: return 736;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 19, false).ID: return 737;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 20, true).ID: return 738;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 20, false).ID: return 739;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 21, true).ID: return 740;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 21, false).ID: return 741;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 22, true).ID: return 742;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 22, false).ID: return 743;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 23, true).ID: return 744;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 23, false).ID: return 745;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 24, true).ID: return 746;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Xylophone, 24, false).ID: return 747;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 0, true).ID: return 748;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 0, false).ID: return 749;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 1, true).ID: return 750;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 1, false).ID: return 751;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 2, true).ID: return 752;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 2, false).ID: return 753;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 3, true).ID: return 754;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 3, false).ID: return 755;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 4, true).ID: return 756;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 4, false).ID: return 757;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 5, true).ID: return 758;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 5, false).ID: return 759;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 6, true).ID: return 760;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 6, false).ID: return 761;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 7, true).ID: return 762;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 7, false).ID: return 763;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 8, true).ID: return 764;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 8, false).ID: return 765;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 9, true).ID: return 766;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 9, false).ID: return 767;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 10, true).ID: return 768;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 10, false).ID: return 769;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 11, true).ID: return 770;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 11, false).ID: return 771;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 12, true).ID: return 772;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 12, false).ID: return 773;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 13, true).ID: return 774;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 13, false).ID: return 775;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 14, true).ID: return 776;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 14, false).ID: return 777;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 15, true).ID: return 778;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 15, false).ID: return 779;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 16, true).ID: return 780;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 16, false).ID: return 781;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 17, true).ID: return 782;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 17, false).ID: return 783;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 18, true).ID: return 784;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 18, false).ID: return 785;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 19, true).ID: return 786;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 19, false).ID: return 787;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 20, true).ID: return 788;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 20, false).ID: return 789;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 21, true).ID: return 790;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 21, false).ID: return 791;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 22, true).ID: return 792;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 22, false).ID: return 793;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 23, true).ID: return 794;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 23, false).ID: return 795;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 24, true).ID: return 796;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::IronXylophone, 24, false).ID: return 797;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 0, true).ID: return 798;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 0, false).ID: return 799;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 1, true).ID: return 800;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 1, false).ID: return 801;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 2, true).ID: return 802;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 2, false).ID: return 803;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 3, true).ID: return 804;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 3, false).ID: return 805;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 4, true).ID: return 806;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 4, false).ID: return 807;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 5, true).ID: return 808;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 5, false).ID: return 809;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 6, true).ID: return 810;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 6, false).ID: return 811;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 7, true).ID: return 812;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 7, false).ID: return 813;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 8, true).ID: return 814;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 8, false).ID: return 815;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 9, true).ID: return 816;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 9, false).ID: return 817;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 10, true).ID: return 818;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 10, false).ID: return 819;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 11, true).ID: return 820;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 11, false).ID: return 821;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 12, true).ID: return 822;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 12, false).ID: return 823;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 13, true).ID: return 824;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 13, false).ID: return 825;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 14, true).ID: return 826;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 14, false).ID: return 827;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 15, true).ID: return 828;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 15, false).ID: return 829;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 16, true).ID: return 830;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 16, false).ID: return 831;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 17, true).ID: return 832;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 17, false).ID: return 833;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 18, true).ID: return 834;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 18, false).ID: return 835;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 19, true).ID: return 836;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 19, false).ID: return 837;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 20, true).ID: return 838;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 20, false).ID: return 839;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 21, true).ID: return 840;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 21, false).ID: return 841;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 22, true).ID: return 842;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 22, false).ID: return 843;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 23, true).ID: return 844;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 23, false).ID: return 845;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 24, true).ID: return 846;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::CowBell, 24, false).ID: return 847;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 0, true).ID: return 848;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 0, false).ID: return 849;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 1, true).ID: return 850;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 1, false).ID: return 851;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 2, true).ID: return 852;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 2, false).ID: return 853;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 3, true).ID: return 854;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 3, false).ID: return 855;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 4, true).ID: return 856;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 4, false).ID: return 857;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 5, true).ID: return 858;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 5, false).ID: return 859;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 6, true).ID: return 860;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 6, false).ID: return 861;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 7, true).ID: return 862;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 7, false).ID: return 863;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 8, true).ID: return 864;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 8, false).ID: return 865;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 9, true).ID: return 866;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 9, false).ID: return 867;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 10, true).ID: return 868;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 10, false).ID: return 869;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 11, true).ID: return 870;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 11, false).ID: return 871;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 12, true).ID: return 872;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 12, false).ID: return 873;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 13, true).ID: return 874;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 13, false).ID: return 875;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 14, true).ID: return 876;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 14, false).ID: return 877;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 15, true).ID: return 878;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 15, false).ID: return 879;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 16, true).ID: return 880;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 16, false).ID: return 881;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 17, true).ID: return 882;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 17, false).ID: return 883;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 18, true).ID: return 884;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 18, false).ID: return 885;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 19, true).ID: return 886;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 19, false).ID: return 887;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 20, true).ID: return 888;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 20, false).ID: return 889;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 21, true).ID: return 890;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 21, false).ID: return 891;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 22, true).ID: return 892;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 22, false).ID: return 893;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 23, true).ID: return 894;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 23, false).ID: return 895;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 24, true).ID: return 896;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Didgeridoo, 24, false).ID: return 897;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 0, true).ID: return 898;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 0, false).ID: return 899;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 1, true).ID: return 900;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 1, false).ID: return 901;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 2, true).ID: return 902;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 2, false).ID: return 903;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 3, true).ID: return 904;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 3, false).ID: return 905;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 4, true).ID: return 906;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 4, false).ID: return 907;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 5, true).ID: return 908;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 5, false).ID: return 909;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 6, true).ID: return 910;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 6, false).ID: return 911;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 7, true).ID: return 912;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 7, false).ID: return 913;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 8, true).ID: return 914;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 8, false).ID: return 915;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 9, true).ID: return 916;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 9, false).ID: return 917;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 10, true).ID: return 918;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 10, false).ID: return 919;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 11, true).ID: return 920;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 11, false).ID: return 921;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 12, true).ID: return 922;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 12, false).ID: return 923;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 13, true).ID: return 924;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 13, false).ID: return 925;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 14, true).ID: return 926;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 14, false).ID: return 927;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 15, true).ID: return 928;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 15, false).ID: return 929;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 16, true).ID: return 930;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 16, false).ID: return 931;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 17, true).ID: return 932;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 17, false).ID: return 933;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 18, true).ID: return 934;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 18, false).ID: return 935;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 19, true).ID: return 936;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 19, false).ID: return 937;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 20, true).ID: return 938;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 20, false).ID: return 939;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 21, true).ID: return 940;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 21, false).ID: return 941;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 22, true).ID: return 942;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 22, false).ID: return 943;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 23, true).ID: return 944;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 23, false).ID: return 945;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 24, true).ID: return 946;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Bit, 24, false).ID: return 947;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 0, true).ID: return 948;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 0, false).ID: return 949;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 1, true).ID: return 950;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 1, false).ID: return 951;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 2, true).ID: return 952;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 2, false).ID: return 953;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 3, true).ID: return 954;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 3, false).ID: return 955;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 4, true).ID: return 956;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 4, false).ID: return 957;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 5, true).ID: return 958;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 5, false).ID: return 959;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 6, true).ID: return 960;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 6, false).ID: return 961;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 7, true).ID: return 962;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 7, false).ID: return 963;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 8, true).ID: return 964;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 8, false).ID: return 965;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 9, true).ID: return 966;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 9, false).ID: return 967;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 10, true).ID: return 968;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 10, false).ID: return 969;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 11, true).ID: return 970;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 11, false).ID: return 971;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 12, true).ID: return 972;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 12, false).ID: return 973;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 13, true).ID: return 974;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 13, false).ID: return 975;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 14, true).ID: return 976;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 14, false).ID: return 977;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 15, true).ID: return 978;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 15, false).ID: return 979;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 16, true).ID: return 980;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 16, false).ID: return 981;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 17, true).ID: return 982;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 17, false).ID: return 983;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 18, true).ID: return 984;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 18, false).ID: return 985;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 19, true).ID: return 986;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 19, false).ID: return 987;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 20, true).ID: return 988;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 20, false).ID: return 989;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 21, true).ID: return 990;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 21, false).ID: return 991;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 22, true).ID: return 992;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 22, false).ID: return 993;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 23, true).ID: return 994;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 23, false).ID: return 995;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 24, true).ID: return 996;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Banjo, 24, false).ID: return 997;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 0, true).ID: return 998;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 0, false).ID: return 999;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 1, true).ID: return 1000;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 1, false).ID: return 1001;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 2, true).ID: return 1002;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 2, false).ID: return 1003;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 3, true).ID: return 1004;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 3, false).ID: return 1005;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 4, true).ID: return 1006;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 4, false).ID: return 1007;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 5, true).ID: return 1008;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 5, false).ID: return 1009;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 6, true).ID: return 1010;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 6, false).ID: return 1011;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 7, true).ID: return 1012;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 7, false).ID: return 1013;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 8, true).ID: return 1014;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 8, false).ID: return 1015;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 9, true).ID: return 1016;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 9, false).ID: return 1017;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 10, true).ID: return 1018;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 10, false).ID: return 1019;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 11, true).ID: return 1020;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 11, false).ID: return 1021;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 12, true).ID: return 1022;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 12, false).ID: return 1023;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 13, true).ID: return 1024;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 13, false).ID: return 1025;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 14, true).ID: return 1026;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 14, false).ID: return 1027;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 15, true).ID: return 1028;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 15, false).ID: return 1029;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 16, true).ID: return 1030;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 16, false).ID: return 1031;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 17, true).ID: return 1032;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 17, false).ID: return 1033;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 18, true).ID: return 1034;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 18, false).ID: return 1035;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 19, true).ID: return 1036;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 19, false).ID: return 1037;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 20, true).ID: return 1038;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 20, false).ID: return 1039;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 21, true).ID: return 1040;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 21, false).ID: return 1041;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 22, true).ID: return 1042;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 22, false).ID: return 1043;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 23, true).ID: return 1044;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 23, false).ID: return 1045;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 24, true).ID: return 1046;
			case NoteBlock::NoteBlock(NoteBlock::Instrument::Pling, 24, false).ID: return 1047;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5810;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5811;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5812;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5813;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 5814;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 5815;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 5816;
			case OakButton::OakButton(OakButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 5817;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5818;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5819;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5820;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5821;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 5822;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 5823;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 5824;
			case OakButton::OakButton(OakButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 5825;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5826;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5827;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5828;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5829;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 5830;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 5831;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 5832;
			case OakButton::OakButton(OakButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 5833;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3571;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3572;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3573;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3574;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3575;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3576;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3577;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3578;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3579;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3580;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3581;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3582;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3583;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3584;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3585;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3586;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3587;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3588;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3589;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3590;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3591;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3592;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3593;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3594;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3595;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3596;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3597;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3598;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3599;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3600;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3601;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_ZP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3602;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3603;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3604;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3605;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3606;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3607;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3608;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3609;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3610;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3611;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3612;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3613;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3614;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3615;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3616;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3617;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XM, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3618;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, true).ID: return 3619;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, true, false).ID: return 3620;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, true).ID: return 3621;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Left, false, false).ID: return 3622;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, true).ID: return 3623;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, true, false).ID: return 3624;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, true).ID: return 3625;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Upper, OakDoor::Hinge::Right, false, false).ID: return 3626;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, true).ID: return 3627;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, true, false).ID: return 3628;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, true).ID: return 3629;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Left, false, false).ID: return 3630;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, true).ID: return 3631;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, true, false).ID: return 3632;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, true).ID: return 3633;
			case OakDoor::OakDoor(eBlockFace::BLOCK_FACE_XP, OakDoor::Half::Lower, OakDoor::Hinge::Right, false, false).ID: return 3634;
			case OakFence::OakFence(true, true, true, true).ID: return 3966;
			case OakFence::OakFence(true, true, true, false).ID: return 3967;
			case OakFence::OakFence(true, true, false, true).ID: return 3970;
			case OakFence::OakFence(true, true, false, false).ID: return 3971;
			case OakFence::OakFence(true, false, true, true).ID: return 3974;
			case OakFence::OakFence(true, false, true, false).ID: return 3975;
			case OakFence::OakFence(true, false, false, true).ID: return 3978;
			case OakFence::OakFence(true, false, false, false).ID: return 3979;
			case OakFence::OakFence(false, true, true, true).ID: return 3982;
			case OakFence::OakFence(false, true, true, false).ID: return 3983;
			case OakFence::OakFence(false, true, false, true).ID: return 3986;
			case OakFence::OakFence(false, true, false, false).ID: return 3987;
			case OakFence::OakFence(false, false, true, true).ID: return 3990;
			case OakFence::OakFence(false, false, true, false).ID: return 3991;
			case OakFence::OakFence(false, false, false, true).ID: return 3994;
			case OakFence::OakFence(false, false, false, false).ID: return 3995;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 4804;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 4805;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 4806;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 4807;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 4808;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 4809;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 4810;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 4811;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 4812;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 4813;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 4814;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 4815;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 4816;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 4817;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 4818;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 4819;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 4820;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 4821;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 4822;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 4823;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 4824;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 4825;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 4826;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 4827;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 4828;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 4829;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 4830;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 4831;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 4832;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 4833;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 4834;
			case OakFenceGate::OakFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 4835;
			case OakLeaves::OakLeaves(1, true).ID: return 144;
			case OakLeaves::OakLeaves(1, false).ID: return 145;
			case OakLeaves::OakLeaves(2, true).ID: return 146;
			case OakLeaves::OakLeaves(2, false).ID: return 147;
			case OakLeaves::OakLeaves(3, true).ID: return 148;
			case OakLeaves::OakLeaves(3, false).ID: return 149;
			case OakLeaves::OakLeaves(4, true).ID: return 150;
			case OakLeaves::OakLeaves(4, false).ID: return 151;
			case OakLeaves::OakLeaves(5, true).ID: return 152;
			case OakLeaves::OakLeaves(5, false).ID: return 153;
			case OakLeaves::OakLeaves(6, true).ID: return 154;
			case OakLeaves::OakLeaves(6, false).ID: return 155;
			case OakLeaves::OakLeaves(7, true).ID: return 156;
			case OakLeaves::OakLeaves(7, false).ID: return 157;
			case OakLog::OakLog(OakLog::Axis::X).ID: return 72;
			case OakLog::OakLog(OakLog::Axis::Y).ID: return 73;
			case OakLog::OakLog(OakLog::Axis::Z).ID: return 74;
			case OakPlanks::OakPlanks().ID: return 15;
			case OakPressurePlate::OakPressurePlate(true).ID: return 3871;
			case OakPressurePlate::OakPressurePlate(false).ID: return 3872;
			case OakSapling::OakSapling(0).ID: return 21;
			case OakSapling::OakSapling(1).ID: return 22;
			case OakSign::OakSign(0).ID: return 3380;
			case OakSign::OakSign(1).ID: return 3382;
			case OakSign::OakSign(2).ID: return 3384;
			case OakSign::OakSign(3).ID: return 3386;
			case OakSign::OakSign(4).ID: return 3388;
			case OakSign::OakSign(5).ID: return 3390;
			case OakSign::OakSign(6).ID: return 3392;
			case OakSign::OakSign(7).ID: return 3394;
			case OakSign::OakSign(8).ID: return 3396;
			case OakSign::OakSign(9).ID: return 3398;
			case OakSign::OakSign(10).ID: return 3400;
			case OakSign::OakSign(11).ID: return 3402;
			case OakSign::OakSign(12).ID: return 3404;
			case OakSign::OakSign(13).ID: return 3406;
			case OakSign::OakSign(14).ID: return 3408;
			case OakSign::OakSign(15).ID: return 3410;
			case OakSlab::OakSlab(OakSlab::Type::Top).ID: return 7765;
			case OakSlab::OakSlab(OakSlab::Type::Bottom).ID: return 7767;
			case OakSlab::OakSlab(OakSlab::Type::Double).ID: return 7769;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 1953;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 1955;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 1957;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 1959;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 1961;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 1963;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 1965;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 1967;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 1969;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZM, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 1971;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 1973;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 1975;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 1977;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 1979;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 1981;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 1983;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 1985;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 1987;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 1989;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_ZP, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 1991;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 1993;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 1995;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 1997;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 1999;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 2001;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 2003;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 2005;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 2007;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 2009;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XM, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 2011;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::Straight).ID: return 2013;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::InnerLeft).ID: return 2015;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::InnerRight).ID: return 2017;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::OuterLeft).ID: return 2019;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Top, OakStairs::Shape::OuterRight).ID: return 2021;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::Straight).ID: return 2023;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::InnerLeft).ID: return 2025;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::InnerRight).ID: return 2027;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::OuterLeft).ID: return 2029;
			case OakStairs::OakStairs(eBlockFace::BLOCK_FACE_XP, OakStairs::Half::Bottom, OakStairs::Shape::OuterRight).ID: return 2031;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, true, true).ID: return 4098;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, true, false).ID: return 4100;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, false, true).ID: return 4102;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Top, false, false).ID: return 4104;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, true, true).ID: return 4106;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, true, false).ID: return 4108;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, false, true).ID: return 4110;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZM, OakTrapdoor::Half::Bottom, false, false).ID: return 4112;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, true, true).ID: return 4114;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, true, false).ID: return 4116;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, false, true).ID: return 4118;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Top, false, false).ID: return 4120;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, true, true).ID: return 4122;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, true, false).ID: return 4124;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, false, true).ID: return 4126;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_ZP, OakTrapdoor::Half::Bottom, false, false).ID: return 4128;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, true, true).ID: return 4130;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, true, false).ID: return 4132;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, false, true).ID: return 4134;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Top, false, false).ID: return 4136;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, true, true).ID: return 4138;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, true, false).ID: return 4140;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, false, true).ID: return 4142;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XM, OakTrapdoor::Half::Bottom, false, false).ID: return 4144;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, true, true).ID: return 4146;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, true, false).ID: return 4148;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, false, true).ID: return 4150;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Top, false, false).ID: return 4152;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, true, true).ID: return 4154;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, true, false).ID: return 4156;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, false, true).ID: return 4158;
			case OakTrapdoor::OakTrapdoor(eBlockFace::BLOCK_FACE_XP, OakTrapdoor::Half::Bottom, false, false).ID: return 4160;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3734;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3736;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3738;
			case OakWallSign::OakWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3740;
			case OakWood::OakWood(OakWood::Axis::X).ID: return 108;
			case OakWood::OakWood(OakWood::Axis::Y).ID: return 109;
			case OakWood::OakWood(OakWood::Axis::Z).ID: return 110;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZM, true).ID: return 8724;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZM, false).ID: return 8725;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XP, true).ID: return 8726;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XP, false).ID: return 8727;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZP, true).ID: return 8728;
			case Observer::Observer(eBlockFace::BLOCK_FACE_ZP, false).ID: return 8729;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XM, true).ID: return 8730;
			case Observer::Observer(eBlockFace::BLOCK_FACE_XM, false).ID: return 8731;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YP, true).ID: return 8732;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YP, false).ID: return 8733;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YM, true).ID: return 8734;
			case Observer::Observer(eBlockFace::BLOCK_FACE_YM, false).ID: return 8735;
			case Obsidian::Obsidian().ID: return 1433;
			case OrangeBanner::OrangeBanner(0).ID: return 7377;
			case OrangeBanner::OrangeBanner(1).ID: return 7378;
			case OrangeBanner::OrangeBanner(2).ID: return 7379;
			case OrangeBanner::OrangeBanner(3).ID: return 7380;
			case OrangeBanner::OrangeBanner(4).ID: return 7381;
			case OrangeBanner::OrangeBanner(5).ID: return 7382;
			case OrangeBanner::OrangeBanner(6).ID: return 7383;
			case OrangeBanner::OrangeBanner(7).ID: return 7384;
			case OrangeBanner::OrangeBanner(8).ID: return 7385;
			case OrangeBanner::OrangeBanner(9).ID: return 7386;
			case OrangeBanner::OrangeBanner(10).ID: return 7387;
			case OrangeBanner::OrangeBanner(11).ID: return 7388;
			case OrangeBanner::OrangeBanner(12).ID: return 7389;
			case OrangeBanner::OrangeBanner(13).ID: return 7390;
			case OrangeBanner::OrangeBanner(14).ID: return 7391;
			case OrangeBanner::OrangeBanner(15).ID: return 7392;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, true, OrangeBed::Part::Head).ID: return 1064;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, true, OrangeBed::Part::Foot).ID: return 1065;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, false, OrangeBed::Part::Head).ID: return 1066;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZM, false, OrangeBed::Part::Foot).ID: return 1067;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, true, OrangeBed::Part::Head).ID: return 1068;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, true, OrangeBed::Part::Foot).ID: return 1069;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, false, OrangeBed::Part::Head).ID: return 1070;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_ZP, false, OrangeBed::Part::Foot).ID: return 1071;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, true, OrangeBed::Part::Head).ID: return 1072;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, true, OrangeBed::Part::Foot).ID: return 1073;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, false, OrangeBed::Part::Head).ID: return 1074;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XM, false, OrangeBed::Part::Foot).ID: return 1075;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, true, OrangeBed::Part::Head).ID: return 1076;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, true, OrangeBed::Part::Foot).ID: return 1077;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, false, OrangeBed::Part::Head).ID: return 1078;
			case OrangeBed::OrangeBed(eBlockFace::BLOCK_FACE_XP, false, OrangeBed::Part::Foot).ID: return 1079;
			case OrangeCarpet::OrangeCarpet().ID: return 7331;
			case OrangeConcrete::OrangeConcrete().ID: return 8903;
			case OrangeConcretePowder::OrangeConcretePowder().ID: return 8919;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8842;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8843;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8844;
			case OrangeGlazedTerracotta::OrangeGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8845;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8748;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8749;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8750;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8751;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8752;
			case OrangeShulkerBox::OrangeShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8753;
			case OrangeStainedGlass::OrangeStainedGlass().ID: return 4082;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, true, true).ID: return 6361;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, true, false).ID: return 6362;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, false, true).ID: return 6365;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, true, false, false).ID: return 6366;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, true, true).ID: return 6369;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, true, false).ID: return 6370;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, false, true).ID: return 6373;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(true, false, false, false).ID: return 6374;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, true, true).ID: return 6377;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, true, false).ID: return 6378;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, false, true).ID: return 6381;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, true, false, false).ID: return 6382;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, true, true).ID: return 6385;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, true, false).ID: return 6386;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, false, true).ID: return 6389;
			case OrangeStainedGlassPane::OrangeStainedGlassPane(false, false, false, false).ID: return 6390;
			case OrangeTerracotta::OrangeTerracotta().ID: return 6312;
			case OrangeTulip::OrangeTulip().ID: return 1417;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7621;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7622;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7623;
			case OrangeWallBanner::OrangeWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7624;
			case OrangeWool::OrangeWool().ID: return 1384;
			case OxeyeDaisy::OxeyeDaisy().ID: return 1420;
			case PackedIce::PackedIce().ID: return 7348;
			case Peony::Peony(Peony::Half::Upper).ID: return 7355;
			case Peony::Peony(Peony::Half::Lower).ID: return 7356;
			case PetrifiedOakSlab::PetrifiedOakSlab(PetrifiedOakSlab::Type::Top).ID: return 7825;
			case PetrifiedOakSlab::PetrifiedOakSlab(PetrifiedOakSlab::Type::Bottom).ID: return 7827;
			case PetrifiedOakSlab::PetrifiedOakSlab(PetrifiedOakSlab::Type::Double).ID: return 7829;
			case PinkBanner::PinkBanner(0).ID: return 7457;
			case PinkBanner::PinkBanner(1).ID: return 7458;
			case PinkBanner::PinkBanner(2).ID: return 7459;
			case PinkBanner::PinkBanner(3).ID: return 7460;
			case PinkBanner::PinkBanner(4).ID: return 7461;
			case PinkBanner::PinkBanner(5).ID: return 7462;
			case PinkBanner::PinkBanner(6).ID: return 7463;
			case PinkBanner::PinkBanner(7).ID: return 7464;
			case PinkBanner::PinkBanner(8).ID: return 7465;
			case PinkBanner::PinkBanner(9).ID: return 7466;
			case PinkBanner::PinkBanner(10).ID: return 7467;
			case PinkBanner::PinkBanner(11).ID: return 7468;
			case PinkBanner::PinkBanner(12).ID: return 7469;
			case PinkBanner::PinkBanner(13).ID: return 7470;
			case PinkBanner::PinkBanner(14).ID: return 7471;
			case PinkBanner::PinkBanner(15).ID: return 7472;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, true, PinkBed::Part::Head).ID: return 1144;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, true, PinkBed::Part::Foot).ID: return 1145;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, false, PinkBed::Part::Head).ID: return 1146;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZM, false, PinkBed::Part::Foot).ID: return 1147;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, true, PinkBed::Part::Head).ID: return 1148;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, true, PinkBed::Part::Foot).ID: return 1149;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, false, PinkBed::Part::Head).ID: return 1150;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_ZP, false, PinkBed::Part::Foot).ID: return 1151;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, true, PinkBed::Part::Head).ID: return 1152;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, true, PinkBed::Part::Foot).ID: return 1153;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, false, PinkBed::Part::Head).ID: return 1154;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XM, false, PinkBed::Part::Foot).ID: return 1155;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, true, PinkBed::Part::Head).ID: return 1156;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, true, PinkBed::Part::Foot).ID: return 1157;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, false, PinkBed::Part::Head).ID: return 1158;
			case PinkBed::PinkBed(eBlockFace::BLOCK_FACE_XP, false, PinkBed::Part::Foot).ID: return 1159;
			case PinkCarpet::PinkCarpet().ID: return 7336;
			case PinkConcrete::PinkConcrete().ID: return 8908;
			case PinkConcretePowder::PinkConcretePowder().ID: return 8924;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8862;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8863;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8864;
			case PinkGlazedTerracotta::PinkGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8865;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8778;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8779;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8780;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8781;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8782;
			case PinkShulkerBox::PinkShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8783;
			case PinkStainedGlass::PinkStainedGlass().ID: return 4087;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, true, true).ID: return 6521;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, true, false).ID: return 6522;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, false, true).ID: return 6525;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, true, false, false).ID: return 6526;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, true, true).ID: return 6529;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, true, false).ID: return 6530;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, false, true).ID: return 6533;
			case PinkStainedGlassPane::PinkStainedGlassPane(true, false, false, false).ID: return 6534;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, true, true).ID: return 6537;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, true, false).ID: return 6538;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, false, true).ID: return 6541;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, true, false, false).ID: return 6542;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, true, true).ID: return 6545;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, true, false).ID: return 6546;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, false, true).ID: return 6549;
			case PinkStainedGlassPane::PinkStainedGlassPane(false, false, false, false).ID: return 6550;
			case PinkTerracotta::PinkTerracotta().ID: return 6317;
			case PinkTulip::PinkTulip().ID: return 1419;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7641;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7642;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7643;
			case PinkWallBanner::PinkWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7644;
			case PinkWool::PinkWool().ID: return 1389;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_ZM).ID: return 1347;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_XP).ID: return 1348;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_ZP).ID: return 1349;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_XM).ID: return 1350;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_YP).ID: return 1351;
			case Piston::Piston(true, eBlockFace::BLOCK_FACE_YM).ID: return 1352;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_ZM).ID: return 1353;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_XP).ID: return 1354;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_ZP).ID: return 1355;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_XM).ID: return 1356;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_YP).ID: return 1357;
			case Piston::Piston(false, eBlockFace::BLOCK_FACE_YM).ID: return 1358;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, true, PistonHead::Type::Normal).ID: return 1359;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, true, PistonHead::Type::Sticky).ID: return 1360;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, false, PistonHead::Type::Normal).ID: return 1361;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZM, false, PistonHead::Type::Sticky).ID: return 1362;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, true, PistonHead::Type::Normal).ID: return 1363;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, true, PistonHead::Type::Sticky).ID: return 1364;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, false, PistonHead::Type::Normal).ID: return 1365;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XP, false, PistonHead::Type::Sticky).ID: return 1366;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, true, PistonHead::Type::Normal).ID: return 1367;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, true, PistonHead::Type::Sticky).ID: return 1368;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, false, PistonHead::Type::Normal).ID: return 1369;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_ZP, false, PistonHead::Type::Sticky).ID: return 1370;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, true, PistonHead::Type::Normal).ID: return 1371;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, true, PistonHead::Type::Sticky).ID: return 1372;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, false, PistonHead::Type::Normal).ID: return 1373;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_XM, false, PistonHead::Type::Sticky).ID: return 1374;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, true, PistonHead::Type::Normal).ID: return 1375;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, true, PistonHead::Type::Sticky).ID: return 1376;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, false, PistonHead::Type::Normal).ID: return 1377;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YP, false, PistonHead::Type::Sticky).ID: return 1378;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, true, PistonHead::Type::Normal).ID: return 1379;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, true, PistonHead::Type::Sticky).ID: return 1380;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, false, PistonHead::Type::Normal).ID: return 1381;
			case PistonHead::PistonHead(eBlockFace::BLOCK_FACE_YM, false, PistonHead::Type::Sticky).ID: return 1382;
			case PlayerHead::PlayerHead(0).ID: return 6014;
			case PlayerHead::PlayerHead(1).ID: return 6015;
			case PlayerHead::PlayerHead(2).ID: return 6016;
			case PlayerHead::PlayerHead(3).ID: return 6017;
			case PlayerHead::PlayerHead(4).ID: return 6018;
			case PlayerHead::PlayerHead(5).ID: return 6019;
			case PlayerHead::PlayerHead(6).ID: return 6020;
			case PlayerHead::PlayerHead(7).ID: return 6021;
			case PlayerHead::PlayerHead(8).ID: return 6022;
			case PlayerHead::PlayerHead(9).ID: return 6023;
			case PlayerHead::PlayerHead(10).ID: return 6024;
			case PlayerHead::PlayerHead(11).ID: return 6025;
			case PlayerHead::PlayerHead(12).ID: return 6026;
			case PlayerHead::PlayerHead(13).ID: return 6027;
			case PlayerHead::PlayerHead(14).ID: return 6028;
			case PlayerHead::PlayerHead(15).ID: return 6029;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6030;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6031;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6032;
			case PlayerWallHead::PlayerWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6033;
			case Podzol::Podzol(true).ID: return 12;
			case Podzol::Podzol(false).ID: return 13;
			case PolishedAndesite::PolishedAndesite().ID: return 7;
			case PolishedAndesiteSlab::PolishedAndesiteSlab(PolishedAndesiteSlab::Type::Top).ID: return 10320;
			case PolishedAndesiteSlab::PolishedAndesiteSlab(PolishedAndesiteSlab::Type::Bottom).ID: return 10322;
			case PolishedAndesiteSlab::PolishedAndesiteSlab(PolishedAndesiteSlab::Type::Double).ID: return 10324;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10094;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10096;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10098;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10100;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10102;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10104;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10106;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10108;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10110;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10112;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10114;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10116;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10118;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10120;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10122;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10124;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10126;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10128;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10130;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10132;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10134;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10136;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10138;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10140;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10142;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10144;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10146;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10148;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10150;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XM, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10152;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::Straight).ID: return 10154;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10156;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10158;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10160;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Top, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10162;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::Straight).ID: return 10164;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerLeft).ID: return 10166;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::InnerRight).ID: return 10168;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterLeft).ID: return 10170;
			case PolishedAndesiteStairs::PolishedAndesiteStairs(eBlockFace::BLOCK_FACE_XP, PolishedAndesiteStairs::Half::Bottom, PolishedAndesiteStairs::Shape::OuterRight).ID: return 10172;
			case PolishedDiorite::PolishedDiorite().ID: return 5;
			case PolishedDioriteSlab::PolishedDioriteSlab(PolishedDioriteSlab::Type::Top).ID: return 10272;
			case PolishedDioriteSlab::PolishedDioriteSlab(PolishedDioriteSlab::Type::Bottom).ID: return 10274;
			case PolishedDioriteSlab::PolishedDioriteSlab(PolishedDioriteSlab::Type::Double).ID: return 10276;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9374;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9376;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9378;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9380;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9382;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9384;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9386;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9388;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9390;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9392;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9394;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9396;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9398;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9400;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9402;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9404;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9406;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9408;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9410;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9412;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9414;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9416;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9418;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9420;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9422;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9424;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9426;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9428;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9430;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XM, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9432;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::Straight).ID: return 9434;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9436;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::InnerRight).ID: return 9438;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9440;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Top, PolishedDioriteStairs::Shape::OuterRight).ID: return 9442;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::Straight).ID: return 9444;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerLeft).ID: return 9446;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::InnerRight).ID: return 9448;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterLeft).ID: return 9450;
			case PolishedDioriteStairs::PolishedDioriteStairs(eBlockFace::BLOCK_FACE_XP, PolishedDioriteStairs::Half::Bottom, PolishedDioriteStairs::Shape::OuterRight).ID: return 9452;
			case PolishedGranite::PolishedGranite().ID: return 3;
			case PolishedGraniteSlab::PolishedGraniteSlab(PolishedGraniteSlab::Type::Top).ID: return 10254;
			case PolishedGraniteSlab::PolishedGraniteSlab(PolishedGraniteSlab::Type::Bottom).ID: return 10256;
			case PolishedGraniteSlab::PolishedGraniteSlab(PolishedGraniteSlab::Type::Double).ID: return 10258;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9134;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9136;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9138;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9140;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9142;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9144;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9146;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9148;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9150;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9152;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9154;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9156;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9158;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9160;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9162;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9164;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9166;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9168;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9170;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_ZP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9172;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9174;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9176;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9178;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9180;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9182;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9184;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9186;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9188;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9190;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XM, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9192;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::Straight).ID: return 9194;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9196;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::InnerRight).ID: return 9198;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9200;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Top, PolishedGraniteStairs::Shape::OuterRight).ID: return 9202;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::Straight).ID: return 9204;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerLeft).ID: return 9206;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::InnerRight).ID: return 9208;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterLeft).ID: return 9210;
			case PolishedGraniteStairs::PolishedGraniteStairs(eBlockFace::BLOCK_FACE_XP, PolishedGraniteStairs::Half::Bottom, PolishedGraniteStairs::Shape::OuterRight).ID: return 9212;
			case Poppy::Poppy().ID: return 1412;
			case Potatoes::Potatoes(0).ID: return 5802;
			case Potatoes::Potatoes(1).ID: return 5803;
			case Potatoes::Potatoes(2).ID: return 5804;
			case Potatoes::Potatoes(3).ID: return 5805;
			case Potatoes::Potatoes(4).ID: return 5806;
			case Potatoes::Potatoes(5).ID: return 5807;
			case Potatoes::Potatoes(6).ID: return 5808;
			case Potatoes::Potatoes(7).ID: return 5809;
			case PottedAcaciaSapling::PottedAcaciaSapling().ID: return 5774;
			case PottedAllium::PottedAllium().ID: return 5780;
			case PottedAzureBluet::PottedAzureBluet().ID: return 5781;
			case PottedBamboo::PottedBamboo().ID: return 9128;
			case PottedBirchSapling::PottedBirchSapling().ID: return 5772;
			case PottedBlueOrchid::PottedBlueOrchid().ID: return 5779;
			case PottedBrownMushroom::PottedBrownMushroom().ID: return 5791;
			case PottedCactus::PottedCactus().ID: return 5793;
			case PottedCornflower::PottedCornflower().ID: return 5787;
			case PottedDandelion::PottedDandelion().ID: return 5777;
			case PottedDarkOakSapling::PottedDarkOakSapling().ID: return 5775;
			case PottedDeadBush::PottedDeadBush().ID: return 5792;
			case PottedFern::PottedFern().ID: return 5776;
			case PottedJungleSapling::PottedJungleSapling().ID: return 5773;
			case PottedLilyOfTheValley::PottedLilyOfTheValley().ID: return 5788;
			case PottedOakSapling::PottedOakSapling().ID: return 5770;
			case PottedOrangeTulip::PottedOrangeTulip().ID: return 5783;
			case PottedOxeyeDaisy::PottedOxeyeDaisy().ID: return 5786;
			case PottedPinkTulip::PottedPinkTulip().ID: return 5785;
			case PottedPoppy::PottedPoppy().ID: return 5778;
			case PottedRedMushroom::PottedRedMushroom().ID: return 5790;
			case PottedRedTulip::PottedRedTulip().ID: return 5782;
			case PottedSpruceSapling::PottedSpruceSapling().ID: return 5771;
			case PottedWhiteTulip::PottedWhiteTulip().ID: return 5784;
			case PottedWitherRose::PottedWitherRose().ID: return 5789;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::NorthSouth).ID: return 1304;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::EastWest).ID: return 1305;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingEast).ID: return 1306;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingWest).ID: return 1307;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingNorth).ID: return 1308;
			case PoweredRail::PoweredRail(true, PoweredRail::Shape::AscendingSouth).ID: return 1309;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::NorthSouth).ID: return 1310;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::EastWest).ID: return 1311;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingEast).ID: return 1312;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingWest).ID: return 1313;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingNorth).ID: return 1314;
			case PoweredRail::PoweredRail(false, PoweredRail::Shape::AscendingSouth).ID: return 1315;
			case Prismarine::Prismarine().ID: return 7065;
			case PrismarineBrickSlab::PrismarineBrickSlab(PrismarineBrickSlab::Type::Top).ID: return 7315;
			case PrismarineBrickSlab::PrismarineBrickSlab(PrismarineBrickSlab::Type::Bottom).ID: return 7317;
			case PrismarineBrickSlab::PrismarineBrickSlab(PrismarineBrickSlab::Type::Double).ID: return 7319;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7149;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7151;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7153;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7155;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7157;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7159;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7161;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7163;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7165;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7167;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7169;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7171;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7173;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7175;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7177;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7179;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7181;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7183;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7185;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7187;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7189;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7191;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7193;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7195;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7197;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7199;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7201;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7203;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7205;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XM, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7207;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::Straight).ID: return 7209;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7211;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::InnerRight).ID: return 7213;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7215;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Top, PrismarineBrickStairs::Shape::OuterRight).ID: return 7217;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::Straight).ID: return 7219;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerLeft).ID: return 7221;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::InnerRight).ID: return 7223;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterLeft).ID: return 7225;
			case PrismarineBrickStairs::PrismarineBrickStairs(eBlockFace::BLOCK_FACE_XP, PrismarineBrickStairs::Half::Bottom, PrismarineBrickStairs::Shape::OuterRight).ID: return 7227;
			case PrismarineBricks::PrismarineBricks().ID: return 7066;
			case PrismarineSlab::PrismarineSlab(PrismarineSlab::Type::Top).ID: return 7309;
			case PrismarineSlab::PrismarineSlab(PrismarineSlab::Type::Bottom).ID: return 7311;
			case PrismarineSlab::PrismarineSlab(PrismarineSlab::Type::Double).ID: return 7313;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7069;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7071;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7073;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7075;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7077;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7079;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7081;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7083;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7085;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7087;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7089;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7091;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7093;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7095;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7097;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7099;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7101;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7103;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7105;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_ZP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7107;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7109;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7111;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7113;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7115;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7117;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7119;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7121;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7123;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7125;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XM, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7127;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::Straight).ID: return 7129;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerLeft).ID: return 7131;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::InnerRight).ID: return 7133;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterLeft).ID: return 7135;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Top, PrismarineStairs::Shape::OuterRight).ID: return 7137;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::Straight).ID: return 7139;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerLeft).ID: return 7141;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::InnerRight).ID: return 7143;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterLeft).ID: return 7145;
			case PrismarineStairs::PrismarineStairs(eBlockFace::BLOCK_FACE_XP, PrismarineStairs::Half::Bottom, PrismarineStairs::Shape::OuterRight).ID: return 7147;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 10397;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 10398;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 10401;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 10402;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 10405;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 10406;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 10409;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 10410;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 10413;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 10414;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 10417;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 10418;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 10421;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 10422;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 10425;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::Low, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 10426;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 10429;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 10430;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 10433;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 10434;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 10437;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 10438;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 10441;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::Low, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 10442;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::Low).ID: return 10445;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, true, PrismarineWall::West::None).ID: return 10446;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::Low).ID: return 10449;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::Low, false, PrismarineWall::West::None).ID: return 10450;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::Low).ID: return 10453;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, true, PrismarineWall::West::None).ID: return 10454;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::Low).ID: return 10457;
			case PrismarineWall::PrismarineWall(PrismarineWall::East::None, PrismarineWall::North::None, PrismarineWall::South::None, false, PrismarineWall::West::None).ID: return 10458;
			case Pumpkin::Pumpkin().ID: return 3996;
			case PumpkinStem::PumpkinStem(0).ID: return 4756;
			case PumpkinStem::PumpkinStem(1).ID: return 4757;
			case PumpkinStem::PumpkinStem(2).ID: return 4758;
			case PumpkinStem::PumpkinStem(3).ID: return 4759;
			case PumpkinStem::PumpkinStem(4).ID: return 4760;
			case PumpkinStem::PumpkinStem(5).ID: return 4761;
			case PumpkinStem::PumpkinStem(6).ID: return 4762;
			case PumpkinStem::PumpkinStem(7).ID: return 4763;
			case PurpleBanner::PurpleBanner(0).ID: return 7521;
			case PurpleBanner::PurpleBanner(1).ID: return 7522;
			case PurpleBanner::PurpleBanner(2).ID: return 7523;
			case PurpleBanner::PurpleBanner(3).ID: return 7524;
			case PurpleBanner::PurpleBanner(4).ID: return 7525;
			case PurpleBanner::PurpleBanner(5).ID: return 7526;
			case PurpleBanner::PurpleBanner(6).ID: return 7527;
			case PurpleBanner::PurpleBanner(7).ID: return 7528;
			case PurpleBanner::PurpleBanner(8).ID: return 7529;
			case PurpleBanner::PurpleBanner(9).ID: return 7530;
			case PurpleBanner::PurpleBanner(10).ID: return 7531;
			case PurpleBanner::PurpleBanner(11).ID: return 7532;
			case PurpleBanner::PurpleBanner(12).ID: return 7533;
			case PurpleBanner::PurpleBanner(13).ID: return 7534;
			case PurpleBanner::PurpleBanner(14).ID: return 7535;
			case PurpleBanner::PurpleBanner(15).ID: return 7536;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, true, PurpleBed::Part::Head).ID: return 1208;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, true, PurpleBed::Part::Foot).ID: return 1209;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, false, PurpleBed::Part::Head).ID: return 1210;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZM, false, PurpleBed::Part::Foot).ID: return 1211;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, true, PurpleBed::Part::Head).ID: return 1212;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, true, PurpleBed::Part::Foot).ID: return 1213;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, false, PurpleBed::Part::Head).ID: return 1214;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_ZP, false, PurpleBed::Part::Foot).ID: return 1215;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, true, PurpleBed::Part::Head).ID: return 1216;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, true, PurpleBed::Part::Foot).ID: return 1217;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, false, PurpleBed::Part::Head).ID: return 1218;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XM, false, PurpleBed::Part::Foot).ID: return 1219;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, true, PurpleBed::Part::Head).ID: return 1220;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, true, PurpleBed::Part::Foot).ID: return 1221;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, false, PurpleBed::Part::Head).ID: return 1222;
			case PurpleBed::PurpleBed(eBlockFace::BLOCK_FACE_XP, false, PurpleBed::Part::Foot).ID: return 1223;
			case PurpleCarpet::PurpleCarpet().ID: return 7340;
			case PurpleConcrete::PurpleConcrete().ID: return 8912;
			case PurpleConcretePowder::PurpleConcretePowder().ID: return 8928;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8878;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8879;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8880;
			case PurpleGlazedTerracotta::PurpleGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8881;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8802;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8803;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8804;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8805;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8806;
			case PurpleShulkerBox::PurpleShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8807;
			case PurpleStainedGlass::PurpleStainedGlass().ID: return 4091;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, true, true).ID: return 6649;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, true, false).ID: return 6650;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, false, true).ID: return 6653;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, true, false, false).ID: return 6654;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, true, true).ID: return 6657;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, true, false).ID: return 6658;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, false, true).ID: return 6661;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(true, false, false, false).ID: return 6662;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, true, true).ID: return 6665;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, true, false).ID: return 6666;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, false, true).ID: return 6669;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, true, false, false).ID: return 6670;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, true, true).ID: return 6673;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, true, false).ID: return 6674;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, false, true).ID: return 6677;
			case PurpleStainedGlassPane::PurpleStainedGlassPane(false, false, false, false).ID: return 6678;
			case PurpleTerracotta::PurpleTerracotta().ID: return 6321;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7657;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7658;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7659;
			case PurpleWallBanner::PurpleWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7660;
			case PurpleWool::PurpleWool().ID: return 1393;
			case PurpurBlock::PurpurBlock().ID: return 8598;
			case PurpurPillar::PurpurPillar(PurpurPillar::Axis::X).ID: return 8599;
			case PurpurPillar::PurpurPillar(PurpurPillar::Axis::Y).ID: return 8600;
			case PurpurPillar::PurpurPillar(PurpurPillar::Axis::Z).ID: return 8601;
			case PurpurSlab::PurpurSlab(PurpurSlab::Type::Top).ID: return 7873;
			case PurpurSlab::PurpurSlab(PurpurSlab::Type::Bottom).ID: return 7875;
			case PurpurSlab::PurpurSlab(PurpurSlab::Type::Double).ID: return 7877;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 8603;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 8605;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 8607;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 8609;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 8611;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 8613;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 8615;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 8617;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 8619;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 8621;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 8623;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 8625;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 8627;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 8629;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 8631;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 8633;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 8635;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 8637;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 8639;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_ZP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 8641;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 8643;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 8645;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 8647;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 8649;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 8651;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 8653;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 8655;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 8657;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 8659;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XM, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 8661;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::Straight).ID: return 8663;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerLeft).ID: return 8665;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::InnerRight).ID: return 8667;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterLeft).ID: return 8669;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Top, PurpurStairs::Shape::OuterRight).ID: return 8671;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::Straight).ID: return 8673;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerLeft).ID: return 8675;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::InnerRight).ID: return 8677;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterLeft).ID: return 8679;
			case PurpurStairs::PurpurStairs(eBlockFace::BLOCK_FACE_XP, PurpurStairs::Half::Bottom, PurpurStairs::Shape::OuterRight).ID: return 8681;
			case QuartzBlock::QuartzBlock().ID: return 6202;
			case QuartzPillar::QuartzPillar(QuartzPillar::Axis::X).ID: return 6204;
			case QuartzPillar::QuartzPillar(QuartzPillar::Axis::Y).ID: return 6205;
			case QuartzPillar::QuartzPillar(QuartzPillar::Axis::Z).ID: return 6206;
			case QuartzSlab::QuartzSlab(QuartzSlab::Type::Top).ID: return 7855;
			case QuartzSlab::QuartzSlab(QuartzSlab::Type::Bottom).ID: return 7857;
			case QuartzSlab::QuartzSlab(QuartzSlab::Type::Double).ID: return 7859;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6208;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6210;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6212;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6214;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6216;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6218;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6220;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6222;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6224;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6226;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6228;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6230;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6232;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6234;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6236;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6238;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6240;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6242;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6244;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_ZP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6246;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6248;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6250;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6252;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6254;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6256;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6258;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6260;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6262;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6264;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XM, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6266;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::Straight).ID: return 6268;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerLeft).ID: return 6270;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::InnerRight).ID: return 6272;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterLeft).ID: return 6274;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Top, QuartzStairs::Shape::OuterRight).ID: return 6276;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::Straight).ID: return 6278;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerLeft).ID: return 6280;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::InnerRight).ID: return 6282;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterLeft).ID: return 6284;
			case QuartzStairs::QuartzStairs(eBlockFace::BLOCK_FACE_XP, QuartzStairs::Half::Bottom, QuartzStairs::Shape::OuterRight).ID: return 6286;
			case Rail::Rail(Rail::Shape::NorthSouth).ID: return 3643;
			case Rail::Rail(Rail::Shape::EastWest).ID: return 3644;
			case Rail::Rail(Rail::Shape::AscendingEast).ID: return 3645;
			case Rail::Rail(Rail::Shape::AscendingWest).ID: return 3646;
			case Rail::Rail(Rail::Shape::AscendingNorth).ID: return 3647;
			case Rail::Rail(Rail::Shape::AscendingSouth).ID: return 3648;
			case Rail::Rail(Rail::Shape::SouthEast).ID: return 3649;
			case Rail::Rail(Rail::Shape::SouthWest).ID: return 3650;
			case Rail::Rail(Rail::Shape::NorthWest).ID: return 3651;
			case Rail::Rail(Rail::Shape::NorthEast).ID: return 3652;
			case RedBanner::RedBanner(0).ID: return 7585;
			case RedBanner::RedBanner(1).ID: return 7586;
			case RedBanner::RedBanner(2).ID: return 7587;
			case RedBanner::RedBanner(3).ID: return 7588;
			case RedBanner::RedBanner(4).ID: return 7589;
			case RedBanner::RedBanner(5).ID: return 7590;
			case RedBanner::RedBanner(6).ID: return 7591;
			case RedBanner::RedBanner(7).ID: return 7592;
			case RedBanner::RedBanner(8).ID: return 7593;
			case RedBanner::RedBanner(9).ID: return 7594;
			case RedBanner::RedBanner(10).ID: return 7595;
			case RedBanner::RedBanner(11).ID: return 7596;
			case RedBanner::RedBanner(12).ID: return 7597;
			case RedBanner::RedBanner(13).ID: return 7598;
			case RedBanner::RedBanner(14).ID: return 7599;
			case RedBanner::RedBanner(15).ID: return 7600;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, true, RedBed::Part::Head).ID: return 1272;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, true, RedBed::Part::Foot).ID: return 1273;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, false, RedBed::Part::Head).ID: return 1274;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZM, false, RedBed::Part::Foot).ID: return 1275;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, true, RedBed::Part::Head).ID: return 1276;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, true, RedBed::Part::Foot).ID: return 1277;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, false, RedBed::Part::Head).ID: return 1278;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_ZP, false, RedBed::Part::Foot).ID: return 1279;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, true, RedBed::Part::Head).ID: return 1280;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, true, RedBed::Part::Foot).ID: return 1281;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, false, RedBed::Part::Head).ID: return 1282;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XM, false, RedBed::Part::Foot).ID: return 1283;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, true, RedBed::Part::Head).ID: return 1284;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, true, RedBed::Part::Foot).ID: return 1285;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, false, RedBed::Part::Head).ID: return 1286;
			case RedBed::RedBed(eBlockFace::BLOCK_FACE_XP, false, RedBed::Part::Foot).ID: return 1287;
			case RedCarpet::RedCarpet().ID: return 7344;
			case RedConcrete::RedConcrete().ID: return 8916;
			case RedConcretePowder::RedConcretePowder().ID: return 8932;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8894;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8895;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8896;
			case RedGlazedTerracotta::RedGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8897;
			case RedMushroom::RedMushroom().ID: return 1425;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, true, true).ID: return 4555;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, true, false).ID: return 4556;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, false, true).ID: return 4557;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, true, false, false).ID: return 4558;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, true, true).ID: return 4559;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, true, false).ID: return 4560;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, false, true).ID: return 4561;
			case RedMushroomBlock::RedMushroomBlock(true, true, true, false, false, false).ID: return 4562;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, true, true).ID: return 4563;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, true, false).ID: return 4564;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, false, true).ID: return 4565;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, true, false, false).ID: return 4566;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, true, true).ID: return 4567;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, true, false).ID: return 4568;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, false, true).ID: return 4569;
			case RedMushroomBlock::RedMushroomBlock(true, true, false, false, false, false).ID: return 4570;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, true, true).ID: return 4571;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, true, false).ID: return 4572;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, false, true).ID: return 4573;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, true, false, false).ID: return 4574;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, true, true).ID: return 4575;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, true, false).ID: return 4576;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, false, true).ID: return 4577;
			case RedMushroomBlock::RedMushroomBlock(true, false, true, false, false, false).ID: return 4578;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, true, true).ID: return 4579;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, true, false).ID: return 4580;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, false, true).ID: return 4581;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, true, false, false).ID: return 4582;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, true, true).ID: return 4583;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, true, false).ID: return 4584;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, false, true).ID: return 4585;
			case RedMushroomBlock::RedMushroomBlock(true, false, false, false, false, false).ID: return 4586;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, true, true).ID: return 4587;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, true, false).ID: return 4588;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, false, true).ID: return 4589;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, true, false, false).ID: return 4590;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, true, true).ID: return 4591;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, true, false).ID: return 4592;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, false, true).ID: return 4593;
			case RedMushroomBlock::RedMushroomBlock(false, true, true, false, false, false).ID: return 4594;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, true, true).ID: return 4595;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, true, false).ID: return 4596;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, false, true).ID: return 4597;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, true, false, false).ID: return 4598;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, true, true).ID: return 4599;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, true, false).ID: return 4600;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, false, true).ID: return 4601;
			case RedMushroomBlock::RedMushroomBlock(false, true, false, false, false, false).ID: return 4602;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, true, true).ID: return 4603;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, true, false).ID: return 4604;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, false, true).ID: return 4605;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, true, false, false).ID: return 4606;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, true, true).ID: return 4607;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, true, false).ID: return 4608;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, false, true).ID: return 4609;
			case RedMushroomBlock::RedMushroomBlock(false, false, true, false, false, false).ID: return 4610;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, true, true).ID: return 4611;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, true, false).ID: return 4612;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, false, true).ID: return 4613;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, true, false, false).ID: return 4614;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, true, true).ID: return 4615;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, true, false).ID: return 4616;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, false, true).ID: return 4617;
			case RedMushroomBlock::RedMushroomBlock(false, false, false, false, false, false).ID: return 4618;
			case RedNetherBrickSlab::RedNetherBrickSlab(RedNetherBrickSlab::Type::Top).ID: return 10314;
			case RedNetherBrickSlab::RedNetherBrickSlab(RedNetherBrickSlab::Type::Bottom).ID: return 10316;
			case RedNetherBrickSlab::RedNetherBrickSlab(RedNetherBrickSlab::Type::Double).ID: return 10318;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10014;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10016;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10018;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10020;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10022;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10024;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10026;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10028;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10030;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterRight).ID: return 10032;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10034;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10036;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10038;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10040;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10042;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10044;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10046;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10048;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10050;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_ZP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterRight).ID: return 10052;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10054;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10056;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10058;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10060;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10062;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10064;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10066;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10068;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10070;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XM, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterRight).ID: return 10072;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::Straight).ID: return 10074;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10076;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::InnerRight).ID: return 10078;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10080;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Top, RedNetherBrickStairs::Shape::OuterRight).ID: return 10082;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::Straight).ID: return 10084;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerLeft).ID: return 10086;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::InnerRight).ID: return 10088;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterLeft).ID: return 10090;
			case RedNetherBrickStairs::RedNetherBrickStairs(eBlockFace::BLOCK_FACE_XP, RedNetherBrickStairs::Half::Bottom, RedNetherBrickStairs::Shape::OuterRight).ID: return 10092;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::Low).ID: return 10845;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::None).ID: return 10846;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::Low).ID: return 10849;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::None).ID: return 10850;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::Low).ID: return 10853;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::None).ID: return 10854;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::Low).ID: return 10857;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::None).ID: return 10858;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::Low).ID: return 10861;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::None).ID: return 10862;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::Low).ID: return 10865;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::None).ID: return 10866;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::Low).ID: return 10869;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::None).ID: return 10870;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::Low).ID: return 10873;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::Low, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::None).ID: return 10874;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::Low).ID: return 10877;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::None).ID: return 10878;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::Low).ID: return 10881;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::None).ID: return 10882;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::Low).ID: return 10885;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::None).ID: return 10886;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::Low).ID: return 10889;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::Low, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::None).ID: return 10890;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::Low).ID: return 10893;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, true, RedNetherBrickWall::West::None).ID: return 10894;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::Low).ID: return 10897;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::Low, false, RedNetherBrickWall::West::None).ID: return 10898;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::Low).ID: return 10901;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, true, RedNetherBrickWall::West::None).ID: return 10902;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::Low).ID: return 10905;
			case RedNetherBrickWall::RedNetherBrickWall(RedNetherBrickWall::East::None, RedNetherBrickWall::North::None, RedNetherBrickWall::South::None, false, RedNetherBrickWall::West::None).ID: return 10906;
			case RedNetherBricks::RedNetherBricks().ID: return 8719;
			case RedSand::RedSand().ID: return 67;
			case RedSandstone::RedSandstone().ID: return 7681;
			case RedSandstoneSlab::RedSandstoneSlab(RedSandstoneSlab::Type::Top).ID: return 7861;
			case RedSandstoneSlab::RedSandstoneSlab(RedSandstoneSlab::Type::Bottom).ID: return 7863;
			case RedSandstoneSlab::RedSandstoneSlab(RedSandstoneSlab::Type::Double).ID: return 7865;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::Straight).ID: return 7685;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerLeft).ID: return 7687;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerRight).ID: return 7689;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterLeft).ID: return 7691;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterRight).ID: return 7693;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::Straight).ID: return 7695;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerLeft).ID: return 7697;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerRight).ID: return 7699;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterLeft).ID: return 7701;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterRight).ID: return 7703;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::Straight).ID: return 7705;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerLeft).ID: return 7707;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerRight).ID: return 7709;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterLeft).ID: return 7711;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterRight).ID: return 7713;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::Straight).ID: return 7715;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerLeft).ID: return 7717;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerRight).ID: return 7719;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterLeft).ID: return 7721;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterRight).ID: return 7723;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::Straight).ID: return 7725;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerLeft).ID: return 7727;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerRight).ID: return 7729;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterLeft).ID: return 7731;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterRight).ID: return 7733;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::Straight).ID: return 7735;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerLeft).ID: return 7737;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerRight).ID: return 7739;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterLeft).ID: return 7741;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterRight).ID: return 7743;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::Straight).ID: return 7745;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerLeft).ID: return 7747;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::InnerRight).ID: return 7749;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterLeft).ID: return 7751;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Top, RedSandstoneStairs::Shape::OuterRight).ID: return 7753;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::Straight).ID: return 7755;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerLeft).ID: return 7757;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::InnerRight).ID: return 7759;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterLeft).ID: return 7761;
			case RedSandstoneStairs::RedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, RedSandstoneStairs::Half::Bottom, RedSandstoneStairs::Shape::OuterRight).ID: return 7763;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::Low).ID: return 10461;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::None).ID: return 10462;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::Low).ID: return 10465;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::None).ID: return 10466;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, true, RedSandstoneWall::West::Low).ID: return 10469;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, true, RedSandstoneWall::West::None).ID: return 10470;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, false, RedSandstoneWall::West::Low).ID: return 10473;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, false, RedSandstoneWall::West::None).ID: return 10474;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::Low).ID: return 10477;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::None).ID: return 10478;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::Low).ID: return 10481;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::None).ID: return 10482;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::None, true, RedSandstoneWall::West::Low).ID: return 10485;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::None, true, RedSandstoneWall::West::None).ID: return 10486;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::None, false, RedSandstoneWall::West::Low).ID: return 10489;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::Low, RedSandstoneWall::North::None, RedSandstoneWall::South::None, false, RedSandstoneWall::West::None).ID: return 10490;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::Low).ID: return 10493;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::None).ID: return 10494;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::Low).ID: return 10497;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::None).ID: return 10498;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, true, RedSandstoneWall::West::Low).ID: return 10501;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, true, RedSandstoneWall::West::None).ID: return 10502;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, false, RedSandstoneWall::West::Low).ID: return 10505;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::Low, RedSandstoneWall::South::None, false, RedSandstoneWall::West::None).ID: return 10506;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::Low).ID: return 10509;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, true, RedSandstoneWall::West::None).ID: return 10510;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::Low).ID: return 10513;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::Low, false, RedSandstoneWall::West::None).ID: return 10514;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::None, true, RedSandstoneWall::West::Low).ID: return 10517;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::None, true, RedSandstoneWall::West::None).ID: return 10518;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::None, false, RedSandstoneWall::West::Low).ID: return 10521;
			case RedSandstoneWall::RedSandstoneWall(RedSandstoneWall::East::None, RedSandstoneWall::North::None, RedSandstoneWall::South::None, false, RedSandstoneWall::West::None).ID: return 10522;
			case RedShulkerBox::RedShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8826;
			case RedShulkerBox::RedShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8827;
			case RedShulkerBox::RedShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8828;
			case RedShulkerBox::RedShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8829;
			case RedShulkerBox::RedShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8830;
			case RedShulkerBox::RedShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8831;
			case RedStainedGlass::RedStainedGlass().ID: return 4095;
			case RedStainedGlassPane::RedStainedGlassPane(true, true, true, true).ID: return 6777;
			case RedStainedGlassPane::RedStainedGlassPane(true, true, true, false).ID: return 6778;
			case RedStainedGlassPane::RedStainedGlassPane(true, true, false, true).ID: return 6781;
			case RedStainedGlassPane::RedStainedGlassPane(true, true, false, false).ID: return 6782;
			case RedStainedGlassPane::RedStainedGlassPane(true, false, true, true).ID: return 6785;
			case RedStainedGlassPane::RedStainedGlassPane(true, false, true, false).ID: return 6786;
			case RedStainedGlassPane::RedStainedGlassPane(true, false, false, true).ID: return 6789;
			case RedStainedGlassPane::RedStainedGlassPane(true, false, false, false).ID: return 6790;
			case RedStainedGlassPane::RedStainedGlassPane(false, true, true, true).ID: return 6793;
			case RedStainedGlassPane::RedStainedGlassPane(false, true, true, false).ID: return 6794;
			case RedStainedGlassPane::RedStainedGlassPane(false, true, false, true).ID: return 6797;
			case RedStainedGlassPane::RedStainedGlassPane(false, true, false, false).ID: return 6798;
			case RedStainedGlassPane::RedStainedGlassPane(false, false, true, true).ID: return 6801;
			case RedStainedGlassPane::RedStainedGlassPane(false, false, true, false).ID: return 6802;
			case RedStainedGlassPane::RedStainedGlassPane(false, false, false, true).ID: return 6805;
			case RedStainedGlassPane::RedStainedGlassPane(false, false, false, false).ID: return 6806;
			case RedTerracotta::RedTerracotta().ID: return 6325;
			case RedTulip::RedTulip().ID: return 1416;
			case RedWallBanner::RedWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7673;
			case RedWallBanner::RedWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7674;
			case RedWallBanner::RedWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7675;
			case RedWallBanner::RedWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7676;
			case RedWool::RedWool().ID: return 1397;
			case RedstoneBlock::RedstoneBlock().ID: return 6190;
			case RedstoneLamp::RedstoneLamp(true).ID: return 5140;
			case RedstoneLamp::RedstoneLamp(false).ID: return 5141;
			case RedstoneOre::RedstoneOre(true).ID: return 3883;
			case RedstoneOre::RedstoneOre(false).ID: return 3884;
			case RedstoneTorch::RedstoneTorch(true).ID: return 3885;
			case RedstoneTorch::RedstoneTorch(false).ID: return 3886;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_ZM, true).ID: return 3887;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_ZM, false).ID: return 3888;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_ZP, true).ID: return 3889;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_ZP, false).ID: return 3890;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_XM, true).ID: return 3891;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_XM, false).ID: return 3892;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_XP, true).ID: return 3893;
			case RedstoneWallTorch::RedstoneWallTorch(eBlockFace::BLOCK_FACE_XP, false).ID: return 3894;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2056;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2057;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2058;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2059;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2060;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2061;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2062;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2063;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2064;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2065;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2066;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2067;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2068;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2069;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2070;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2071;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2072;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2073;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2074;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2075;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2076;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2077;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2078;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2079;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2080;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2081;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2082;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2083;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2084;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2085;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2086;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2087;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2088;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2089;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2090;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2091;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2092;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2093;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2094;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2095;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2096;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2097;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2098;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2099;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2100;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2101;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2102;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2103;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2104;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2105;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2106;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2107;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2108;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2109;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2110;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2111;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2112;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2113;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2114;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2115;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2116;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2117;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2118;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2119;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2120;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2121;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2122;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2123;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2124;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2125;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2126;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2127;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2128;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2129;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2130;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2131;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2132;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2133;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2134;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2135;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2136;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2137;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2138;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2139;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2140;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2141;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2142;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2143;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2144;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2145;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2146;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2147;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2148;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2149;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2150;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2151;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2152;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2153;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2154;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2155;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2156;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2157;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2158;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2159;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2160;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2161;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2162;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2163;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2164;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2165;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2166;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2167;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2168;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2169;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2170;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2171;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2172;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2173;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2174;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2175;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2176;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2177;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2178;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2179;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2180;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2181;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2182;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2183;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2184;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2185;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2186;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2187;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2188;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2189;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2190;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2191;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2192;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2193;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2194;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2195;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2196;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2197;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2198;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2199;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2200;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2201;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2202;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2203;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2204;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2205;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2206;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2207;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2208;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2209;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2210;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2211;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2212;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2213;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2214;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2215;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2216;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2217;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2218;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2219;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2220;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2221;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2222;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2223;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2224;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2225;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2226;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2227;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2228;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2229;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2230;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2231;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2232;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2233;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2234;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2235;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2236;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2237;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2238;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2239;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2240;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2241;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2242;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2243;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2244;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2245;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2246;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2247;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2248;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2249;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2250;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2251;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2252;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2253;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2254;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2255;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2256;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2257;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2258;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2259;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2260;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2261;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2262;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2263;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2264;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2265;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2266;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2267;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2268;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2269;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2270;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2271;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2272;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2273;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2274;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2275;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2276;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2277;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2278;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2279;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2280;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2281;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2282;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2283;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2284;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2285;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2286;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2287;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2288;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2289;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2290;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2291;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2292;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2293;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2294;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2295;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2296;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2297;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2298;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2299;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2300;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2301;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2302;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2303;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2304;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2305;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2306;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2307;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2308;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2309;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2310;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2311;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2312;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2313;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2314;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2315;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2316;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2317;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2318;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2319;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2320;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2321;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2322;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2323;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2324;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2325;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2326;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2327;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2328;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2329;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2330;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2331;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2332;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2333;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2334;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2335;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2336;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2337;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2338;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2339;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2340;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2341;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2342;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2343;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2344;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2345;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2346;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2347;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2348;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2349;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2350;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2351;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2352;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2353;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2354;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2355;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2356;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2357;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2358;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2359;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2360;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2361;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2362;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2363;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2364;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2365;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2366;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2367;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2368;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2369;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2370;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2371;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2372;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2373;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2374;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2375;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2376;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2377;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2378;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2379;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2380;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2381;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2382;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2383;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2384;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2385;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2386;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2387;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2388;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2389;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2390;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2391;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2392;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2393;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2394;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2395;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2396;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2397;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2398;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2399;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2400;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2401;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2402;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2403;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2404;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2405;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2406;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2407;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2408;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2409;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2410;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2411;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2412;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2413;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2414;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2415;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2416;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2417;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2418;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2419;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2420;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2421;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2422;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2423;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2424;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2425;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2426;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2427;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2428;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2429;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2430;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2431;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2432;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2433;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2434;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2435;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2436;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2437;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2438;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2439;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2440;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2441;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2442;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2443;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2444;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2445;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2446;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2447;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2448;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2449;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2450;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2451;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2452;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2453;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2454;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2455;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2456;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2457;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2458;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2459;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2460;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2461;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2462;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2463;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2464;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2465;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2466;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2467;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2468;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2469;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2470;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2471;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2472;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2473;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2474;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2475;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2476;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2477;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2478;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2479;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2480;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2481;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2482;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2483;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2484;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2485;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2486;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Up, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2487;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2488;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2489;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2490;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2491;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2492;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2493;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2494;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2495;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2496;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2497;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2498;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2499;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2500;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2501;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2502;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2503;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2504;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2505;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2506;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2507;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2508;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2509;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2510;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2511;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2512;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2513;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2514;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2515;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2516;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2517;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2518;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2519;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2520;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2521;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2522;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2523;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2524;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2525;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2526;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2527;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2528;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2529;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2530;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2531;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2532;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2533;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2534;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2535;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2536;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2537;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2538;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2539;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2540;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2541;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2542;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2543;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2544;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2545;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2546;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2547;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2548;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2549;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2550;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2551;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2552;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2553;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2554;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2555;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2556;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2557;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2558;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2559;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2560;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2561;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2562;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2563;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2564;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2565;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2566;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2567;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2568;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2569;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2570;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2571;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2572;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2573;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2574;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2575;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2576;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2577;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2578;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2579;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2580;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2581;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2582;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2583;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2584;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2585;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2586;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2587;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2588;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2589;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2590;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2591;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2592;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2593;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2594;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2595;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2596;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2597;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2598;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2599;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2600;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2601;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2602;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2603;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2604;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2605;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2606;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2607;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2608;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2609;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2610;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2611;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2612;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2613;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2614;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2615;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2616;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2617;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2618;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2619;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2620;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2621;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2622;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2623;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2624;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2625;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2626;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2627;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2628;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2629;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2630;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2631;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2632;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2633;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2634;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2635;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2636;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2637;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2638;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2639;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2640;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2641;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2642;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2643;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2644;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2645;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2646;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2647;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2648;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2649;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2650;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2651;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2652;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2653;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2654;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2655;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2656;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2657;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2658;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2659;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2660;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2661;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2662;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2663;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2664;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2665;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2666;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2667;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2668;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2669;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2670;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2671;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2672;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2673;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2674;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2675;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2676;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2677;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2678;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2679;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2680;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2681;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2682;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2683;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2684;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2685;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2686;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2687;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2688;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2689;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2690;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2691;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2692;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2693;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2694;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2695;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2696;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2697;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2698;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2699;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2700;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2701;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2702;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2703;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2704;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2705;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2706;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2707;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2708;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2709;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2710;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2711;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2712;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2713;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2714;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2715;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2716;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2717;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2718;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2719;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2720;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2721;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2722;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2723;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2724;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2725;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2726;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2727;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2728;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2729;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2730;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2731;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2732;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2733;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2734;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2735;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2736;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2737;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2738;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2739;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2740;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2741;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2742;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2743;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2744;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2745;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2746;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2747;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2748;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2749;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2750;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2751;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2752;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2753;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2754;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2755;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2756;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2757;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2758;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2759;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2760;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2761;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2762;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2763;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2764;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2765;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2766;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2767;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2768;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2769;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2770;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2771;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2772;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2773;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2774;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2775;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2776;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2777;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2778;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2779;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2780;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2781;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2782;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2783;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2784;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2785;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2786;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2787;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2788;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2789;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2790;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2791;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2792;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2793;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2794;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2795;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2796;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2797;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2798;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2799;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2800;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2801;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2802;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2803;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2804;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2805;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2806;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2807;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2808;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2809;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2810;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2811;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2812;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2813;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2814;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2815;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2816;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2817;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2818;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2819;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2820;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2821;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2822;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2823;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2824;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2825;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2826;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2827;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2828;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2829;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2830;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2831;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2832;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2833;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2834;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2835;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2836;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2837;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2838;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2839;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2840;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2841;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2842;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2843;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2844;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2845;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2846;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2847;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2848;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2849;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2850;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2851;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2852;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2853;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2854;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2855;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2856;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2857;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2858;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2859;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2860;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2861;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2862;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2863;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2864;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2865;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2866;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2867;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2868;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2869;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2870;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2871;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2872;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2873;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2874;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2875;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2876;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2877;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2878;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2879;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2880;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2881;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2882;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2883;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2884;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2885;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2886;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2887;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2888;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2889;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2890;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2891;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2892;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2893;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2894;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2895;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2896;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2897;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2898;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2899;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2900;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2901;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2902;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2903;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2904;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2905;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2906;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2907;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2908;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2909;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2910;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2911;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2912;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2913;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2914;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2915;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2916;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2917;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2918;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::Side, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2919;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2920;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2921;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2922;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2923;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2924;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2925;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2926;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2927;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2928;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2929;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2930;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2931;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2932;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2933;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2934;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2935;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2936;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2937;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2938;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2939;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2940;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2941;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2942;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2943;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2944;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2945;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2946;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2947;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2948;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2949;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2950;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2951;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2952;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2953;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2954;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2955;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2956;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2957;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2958;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2959;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2960;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2961;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2962;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2963;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2964;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2965;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2966;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2967;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2968;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2969;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2970;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2971;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2972;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2973;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2974;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2975;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2976;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2977;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2978;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2979;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2980;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2981;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2982;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2983;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2984;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2985;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2986;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2987;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2988;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2989;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2990;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 2991;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 2992;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 2993;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 2994;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 2995;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 2996;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 2997;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 2998;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 2999;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3000;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3001;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3002;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3003;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3004;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3005;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3006;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3007;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3008;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3009;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3010;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3011;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3012;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3013;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3014;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3015;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3016;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3017;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3018;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3019;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3020;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3021;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3022;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3023;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3024;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3025;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3026;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3027;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3028;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3029;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3030;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3031;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3032;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3033;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3034;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3035;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3036;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3037;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3038;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3039;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3040;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3041;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3042;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3043;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3044;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3045;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3046;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3047;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3048;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3049;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3050;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3051;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3052;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3053;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3054;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3055;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3056;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3057;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3058;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3059;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3060;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3061;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3062;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Up, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3063;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3064;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3065;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3066;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3067;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3068;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3069;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3070;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3071;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3072;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3073;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3074;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3075;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3076;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3077;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3078;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3079;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3080;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3081;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3082;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3083;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3084;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3085;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3086;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3087;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3088;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3089;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3090;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3091;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3092;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3093;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3094;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3095;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3096;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3097;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3098;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3099;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3100;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3101;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3102;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3103;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3104;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3105;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3106;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3107;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3108;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3109;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3110;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3111;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3112;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3113;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3114;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3115;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3116;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3117;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3118;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3119;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3120;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3121;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3122;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3123;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3124;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3125;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3126;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3127;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3128;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3129;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3130;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3131;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3132;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3133;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3134;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3135;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3136;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3137;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3138;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3139;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3140;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3141;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3142;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3143;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3144;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3145;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3146;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3147;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3148;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3149;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3150;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3151;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3152;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3153;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3154;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3155;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3156;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3157;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3158;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3159;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3160;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3161;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3162;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3163;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3164;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3165;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3166;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3167;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3168;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3169;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3170;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3171;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3172;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3173;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3174;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3175;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3176;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3177;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3178;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3179;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3180;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3181;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3182;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3183;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3184;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3185;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3186;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3187;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3188;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3189;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3190;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3191;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3192;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3193;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3194;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3195;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3196;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3197;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3198;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3199;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3200;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3201;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3202;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3203;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3204;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3205;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3206;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::Side, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3207;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3208;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3209;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3210;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3211;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3212;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3213;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3214;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3215;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 0, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3216;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3217;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3218;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3219;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3220;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3221;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3222;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3223;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3224;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 1, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3225;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3226;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3227;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3228;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3229;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3230;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3231;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3232;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3233;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 2, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3234;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3235;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3236;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3237;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3238;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3239;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3240;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3241;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3242;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 3, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3243;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3244;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3245;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3246;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3247;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3248;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3249;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3250;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3251;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 4, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3252;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3253;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3254;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3255;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3256;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3257;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3258;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3259;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3260;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 5, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3261;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3262;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3263;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3264;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3265;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3266;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3267;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3268;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3269;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 6, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3270;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3271;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3272;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3273;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3274;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3275;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3276;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3277;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3278;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 7, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3279;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3280;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3281;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3282;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3283;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3284;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3285;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3286;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3287;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 8, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3288;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3289;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3290;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3291;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3292;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3293;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3294;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3295;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3296;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 9, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3297;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3298;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3299;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3300;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3301;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3302;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3303;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3304;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3305;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 10, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3306;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3307;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3308;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3309;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3310;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3311;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3312;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3313;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3314;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 11, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3315;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3316;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3317;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3318;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3319;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3320;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3321;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3322;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3323;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 12, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3324;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3325;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3326;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3327;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3328;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3329;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3330;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3331;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3332;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 13, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3333;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3334;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3335;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3336;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3337;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3338;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3339;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3340;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3341;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 14, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3342;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::Up).ID: return 3343;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::Side).ID: return 3344;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::Up, RedstoneWire::West::None).ID: return 3345;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::Up).ID: return 3346;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::Side).ID: return 3347;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::Side, RedstoneWire::West::None).ID: return 3348;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::Up).ID: return 3349;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::Side).ID: return 3350;
			case RedstoneWire::RedstoneWire(RedstoneWire::East::None, RedstoneWire::North::None, 15, RedstoneWire::South::None, RedstoneWire::West::None).ID: return 3351;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 4017;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 4018;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 4019;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 4020;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 4021;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 4022;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 4023;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 4024;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XM, true, true).ID: return 4025;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XM, true, false).ID: return 4026;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XM, false, true).ID: return 4027;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XM, false, false).ID: return 4028;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XP, true, true).ID: return 4029;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XP, true, false).ID: return 4030;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XP, false, true).ID: return 4031;
			case Repeater::Repeater(1, eBlockFace::BLOCK_FACE_XP, false, false).ID: return 4032;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 4033;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 4034;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 4035;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 4036;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 4037;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 4038;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 4039;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 4040;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XM, true, true).ID: return 4041;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XM, true, false).ID: return 4042;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XM, false, true).ID: return 4043;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XM, false, false).ID: return 4044;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XP, true, true).ID: return 4045;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XP, true, false).ID: return 4046;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XP, false, true).ID: return 4047;
			case Repeater::Repeater(2, eBlockFace::BLOCK_FACE_XP, false, false).ID: return 4048;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 4049;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 4050;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 4051;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 4052;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 4053;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 4054;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 4055;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 4056;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XM, true, true).ID: return 4057;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XM, true, false).ID: return 4058;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XM, false, true).ID: return 4059;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XM, false, false).ID: return 4060;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XP, true, true).ID: return 4061;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XP, true, false).ID: return 4062;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XP, false, true).ID: return 4063;
			case Repeater::Repeater(3, eBlockFace::BLOCK_FACE_XP, false, false).ID: return 4064;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZM, true, true).ID: return 4065;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZM, true, false).ID: return 4066;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZM, false, true).ID: return 4067;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZM, false, false).ID: return 4068;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZP, true, true).ID: return 4069;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZP, true, false).ID: return 4070;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZP, false, true).ID: return 4071;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_ZP, false, false).ID: return 4072;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XM, true, true).ID: return 4073;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XM, true, false).ID: return 4074;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XM, false, true).ID: return 4075;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XM, false, false).ID: return 4076;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XP, true, true).ID: return 4077;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XP, true, false).ID: return 4078;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XP, false, true).ID: return 4079;
			case Repeater::Repeater(4, eBlockFace::BLOCK_FACE_XP, false, false).ID: return 4080;
			case RepeatingCommandBlock::RepeatingCommandBlock(true, eBlockFace::BLOCK_FACE_ZM).ID: return 8689;
			case RepeatingCommandBlock::RepeatingCommandBlock(true, eBlockFace::BLOCK_FACE_XP).ID: return 8690;
			case RepeatingCommandBlock::RepeatingCommandBlock(true, eBlockFace::BLOCK_FACE_ZP).ID: return 8691;
			case RepeatingCommandBlock::RepeatingCommandBlock(true, eBlockFace::BLOCK_FACE_XM).ID: return 8692;
			case RepeatingCommandBlock::RepeatingCommandBlock(true, eBlockFace::BLOCK_FACE_YP).ID: return 8693;
			case RepeatingCommandBlock::RepeatingCommandBlock(true, eBlockFace::BLOCK_FACE_YM).ID: return 8694;
			case RepeatingCommandBlock::RepeatingCommandBlock(false, eBlockFace::BLOCK_FACE_ZM).ID: return 8695;
			case RepeatingCommandBlock::RepeatingCommandBlock(false, eBlockFace::BLOCK_FACE_XP).ID: return 8696;
			case RepeatingCommandBlock::RepeatingCommandBlock(false, eBlockFace::BLOCK_FACE_ZP).ID: return 8697;
			case RepeatingCommandBlock::RepeatingCommandBlock(false, eBlockFace::BLOCK_FACE_XM).ID: return 8698;
			case RepeatingCommandBlock::RepeatingCommandBlock(false, eBlockFace::BLOCK_FACE_YP).ID: return 8699;
			case RepeatingCommandBlock::RepeatingCommandBlock(false, eBlockFace::BLOCK_FACE_YM).ID: return 8700;
			case RoseBush::RoseBush(RoseBush::Half::Upper).ID: return 7353;
			case RoseBush::RoseBush(RoseBush::Half::Lower).ID: return 7354;
			case Sand::Sand().ID: return 66;
			case Sandstone::Sandstone().ID: return 245;
			case SandstoneSlab::SandstoneSlab(SandstoneSlab::Type::Top).ID: return 7813;
			case SandstoneSlab::SandstoneSlab(SandstoneSlab::Type::Bottom).ID: return 7815;
			case SandstoneSlab::SandstoneSlab(SandstoneSlab::Type::Double).ID: return 7817;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::Straight).ID: return 5155;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerLeft).ID: return 5157;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerRight).ID: return 5159;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterLeft).ID: return 5161;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterRight).ID: return 5163;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::Straight).ID: return 5165;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerLeft).ID: return 5167;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerRight).ID: return 5169;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterLeft).ID: return 5171;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterRight).ID: return 5173;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::Straight).ID: return 5175;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerLeft).ID: return 5177;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerRight).ID: return 5179;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterLeft).ID: return 5181;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterRight).ID: return 5183;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::Straight).ID: return 5185;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerLeft).ID: return 5187;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerRight).ID: return 5189;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterLeft).ID: return 5191;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterRight).ID: return 5193;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::Straight).ID: return 5195;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerLeft).ID: return 5197;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerRight).ID: return 5199;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterLeft).ID: return 5201;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterRight).ID: return 5203;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::Straight).ID: return 5205;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerLeft).ID: return 5207;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerRight).ID: return 5209;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterLeft).ID: return 5211;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XM, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterRight).ID: return 5213;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::Straight).ID: return 5215;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerLeft).ID: return 5217;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::InnerRight).ID: return 5219;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterLeft).ID: return 5221;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Top, SandstoneStairs::Shape::OuterRight).ID: return 5223;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::Straight).ID: return 5225;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerLeft).ID: return 5227;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::InnerRight).ID: return 5229;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterLeft).ID: return 5231;
			case SandstoneStairs::SandstoneStairs(eBlockFace::BLOCK_FACE_XP, SandstoneStairs::Half::Bottom, SandstoneStairs::Shape::OuterRight).ID: return 5233;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::Low, true, SandstoneWall::West::Low).ID: return 10909;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::Low, true, SandstoneWall::West::None).ID: return 10910;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::Low, false, SandstoneWall::West::Low).ID: return 10913;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::Low, false, SandstoneWall::West::None).ID: return 10914;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::None, true, SandstoneWall::West::Low).ID: return 10917;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::None, true, SandstoneWall::West::None).ID: return 10918;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::None, false, SandstoneWall::West::Low).ID: return 10921;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::Low, SandstoneWall::South::None, false, SandstoneWall::West::None).ID: return 10922;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::Low, true, SandstoneWall::West::Low).ID: return 10925;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::Low, true, SandstoneWall::West::None).ID: return 10926;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::Low, false, SandstoneWall::West::Low).ID: return 10929;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::Low, false, SandstoneWall::West::None).ID: return 10930;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::None, true, SandstoneWall::West::Low).ID: return 10933;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::None, true, SandstoneWall::West::None).ID: return 10934;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::None, false, SandstoneWall::West::Low).ID: return 10937;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::Low, SandstoneWall::North::None, SandstoneWall::South::None, false, SandstoneWall::West::None).ID: return 10938;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::Low, true, SandstoneWall::West::Low).ID: return 10941;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::Low, true, SandstoneWall::West::None).ID: return 10942;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::Low, false, SandstoneWall::West::Low).ID: return 10945;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::Low, false, SandstoneWall::West::None).ID: return 10946;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::None, true, SandstoneWall::West::Low).ID: return 10949;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::None, true, SandstoneWall::West::None).ID: return 10950;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::None, false, SandstoneWall::West::Low).ID: return 10953;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::Low, SandstoneWall::South::None, false, SandstoneWall::West::None).ID: return 10954;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::Low, true, SandstoneWall::West::Low).ID: return 10957;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::Low, true, SandstoneWall::West::None).ID: return 10958;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::Low, false, SandstoneWall::West::Low).ID: return 10961;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::Low, false, SandstoneWall::West::None).ID: return 10962;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::None, true, SandstoneWall::West::Low).ID: return 10965;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::None, true, SandstoneWall::West::None).ID: return 10966;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::None, false, SandstoneWall::West::Low).ID: return 10969;
			case SandstoneWall::SandstoneWall(SandstoneWall::East::None, SandstoneWall::North::None, SandstoneWall::South::None, false, SandstoneWall::West::None).ID: return 10970;
			case Scaffolding::Scaffolding(true, 0).ID: return 11100;
			case Scaffolding::Scaffolding(true, 1).ID: return 11102;
			case Scaffolding::Scaffolding(true, 2).ID: return 11104;
			case Scaffolding::Scaffolding(true, 3).ID: return 11106;
			case Scaffolding::Scaffolding(true, 4).ID: return 11108;
			case Scaffolding::Scaffolding(true, 5).ID: return 11110;
			case Scaffolding::Scaffolding(true, 6).ID: return 11112;
			case Scaffolding::Scaffolding(true, 7).ID: return 11114;
			case Scaffolding::Scaffolding(false, 0).ID: return 11116;
			case Scaffolding::Scaffolding(false, 1).ID: return 11118;
			case Scaffolding::Scaffolding(false, 2).ID: return 11120;
			case Scaffolding::Scaffolding(false, 3).ID: return 11122;
			case Scaffolding::Scaffolding(false, 4).ID: return 11124;
			case Scaffolding::Scaffolding(false, 5).ID: return 11126;
			case Scaffolding::Scaffolding(false, 6).ID: return 11128;
			case Scaffolding::Scaffolding(false, 7).ID: return 11130;
			case SeaLantern::SeaLantern().ID: return 7326;
			case SeaPickle::SeaPickle(1).ID: return 9105;
			case SeaPickle::SeaPickle(2).ID: return 9107;
			case SeaPickle::SeaPickle(3).ID: return 9109;
			case SeaPickle::SeaPickle(4).ID: return 9111;
			case Seagrass::Seagrass().ID: return 1344;
			case ShulkerBox::ShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8736;
			case ShulkerBox::ShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8737;
			case ShulkerBox::ShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8738;
			case ShulkerBox::ShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8739;
			case ShulkerBox::ShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8740;
			case ShulkerBox::ShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8741;
			case SkeletonSkull::SkeletonSkull(0).ID: return 5954;
			case SkeletonSkull::SkeletonSkull(1).ID: return 5955;
			case SkeletonSkull::SkeletonSkull(2).ID: return 5956;
			case SkeletonSkull::SkeletonSkull(3).ID: return 5957;
			case SkeletonSkull::SkeletonSkull(4).ID: return 5958;
			case SkeletonSkull::SkeletonSkull(5).ID: return 5959;
			case SkeletonSkull::SkeletonSkull(6).ID: return 5960;
			case SkeletonSkull::SkeletonSkull(7).ID: return 5961;
			case SkeletonSkull::SkeletonSkull(8).ID: return 5962;
			case SkeletonSkull::SkeletonSkull(9).ID: return 5963;
			case SkeletonSkull::SkeletonSkull(10).ID: return 5964;
			case SkeletonSkull::SkeletonSkull(11).ID: return 5965;
			case SkeletonSkull::SkeletonSkull(12).ID: return 5966;
			case SkeletonSkull::SkeletonSkull(13).ID: return 5967;
			case SkeletonSkull::SkeletonSkull(14).ID: return 5968;
			case SkeletonSkull::SkeletonSkull(15).ID: return 5969;
			case SkeletonWallSkull::SkeletonWallSkull(eBlockFace::BLOCK_FACE_ZM).ID: return 5970;
			case SkeletonWallSkull::SkeletonWallSkull(eBlockFace::BLOCK_FACE_ZP).ID: return 5971;
			case SkeletonWallSkull::SkeletonWallSkull(eBlockFace::BLOCK_FACE_XM).ID: return 5972;
			case SkeletonWallSkull::SkeletonWallSkull(eBlockFace::BLOCK_FACE_XP).ID: return 5973;
			case SlimeBlock::SlimeBlock().ID: return 6999;
			case SmithingTable::SmithingTable().ID: return 11193;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_ZM, true).ID: return 11147;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_ZM, false).ID: return 11148;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_ZP, true).ID: return 11149;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_ZP, false).ID: return 11150;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_XM, true).ID: return 11151;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_XM, false).ID: return 11152;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_XP, true).ID: return 11153;
			case Smoker::Smoker(eBlockFace::BLOCK_FACE_XP, false).ID: return 11154;
			case SmoothQuartz::SmoothQuartz().ID: return 7880;
			case SmoothQuartzSlab::SmoothQuartzSlab(SmoothQuartzSlab::Type::Top).ID: return 10296;
			case SmoothQuartzSlab::SmoothQuartzSlab(SmoothQuartzSlab::Type::Bottom).ID: return 10298;
			case SmoothQuartzSlab::SmoothQuartzSlab(SmoothQuartzSlab::Type::Double).ID: return 10300;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::Straight).ID: return 9774;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9776;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerRight).ID: return 9778;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9780;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterRight).ID: return 9782;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::Straight).ID: return 9784;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9786;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerRight).ID: return 9788;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9790;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterRight).ID: return 9792;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::Straight).ID: return 9794;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9796;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerRight).ID: return 9798;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9800;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterRight).ID: return 9802;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::Straight).ID: return 9804;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9806;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerRight).ID: return 9808;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9810;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_ZP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterRight).ID: return 9812;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::Straight).ID: return 9814;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9816;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerRight).ID: return 9818;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9820;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterRight).ID: return 9822;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::Straight).ID: return 9824;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9826;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerRight).ID: return 9828;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9830;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XM, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterRight).ID: return 9832;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::Straight).ID: return 9834;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9836;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::InnerRight).ID: return 9838;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9840;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Top, SmoothQuartzStairs::Shape::OuterRight).ID: return 9842;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::Straight).ID: return 9844;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerLeft).ID: return 9846;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::InnerRight).ID: return 9848;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterLeft).ID: return 9850;
			case SmoothQuartzStairs::SmoothQuartzStairs(eBlockFace::BLOCK_FACE_XP, SmoothQuartzStairs::Half::Bottom, SmoothQuartzStairs::Shape::OuterRight).ID: return 9852;
			case SmoothRedSandstone::SmoothRedSandstone().ID: return 7881;
			case SmoothRedSandstoneSlab::SmoothRedSandstoneSlab(SmoothRedSandstoneSlab::Type::Top).ID: return 10260;
			case SmoothRedSandstoneSlab::SmoothRedSandstoneSlab(SmoothRedSandstoneSlab::Type::Bottom).ID: return 10262;
			case SmoothRedSandstoneSlab::SmoothRedSandstoneSlab(SmoothRedSandstoneSlab::Type::Double).ID: return 10264;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9214;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9216;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9218;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9220;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9222;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9224;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9226;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9228;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9230;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9232;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9234;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9236;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9238;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9240;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9242;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9244;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9246;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9248;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9250;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9252;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9254;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9256;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9258;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9260;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9262;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9264;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9266;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9268;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9270;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9272;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9274;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9276;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9278;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9280;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Top, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9282;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::Straight).ID: return 9284;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerLeft).ID: return 9286;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::InnerRight).ID: return 9288;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterLeft).ID: return 9290;
			case SmoothRedSandstoneStairs::SmoothRedSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothRedSandstoneStairs::Half::Bottom, SmoothRedSandstoneStairs::Shape::OuterRight).ID: return 9292;
			case SmoothSandstone::SmoothSandstone().ID: return 7879;
			case SmoothSandstoneSlab::SmoothSandstoneSlab(SmoothSandstoneSlab::Type::Top).ID: return 10290;
			case SmoothSandstoneSlab::SmoothSandstoneSlab(SmoothSandstoneSlab::Type::Bottom).ID: return 10292;
			case SmoothSandstoneSlab::SmoothSandstoneSlab(SmoothSandstoneSlab::Type::Double).ID: return 10294;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::Straight).ID: return 9694;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9696;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9698;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9700;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9702;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::Straight).ID: return 9704;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9706;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9708;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9710;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9712;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::Straight).ID: return 9714;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9716;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9718;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9720;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9722;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::Straight).ID: return 9724;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9726;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9728;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9730;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_ZP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9732;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::Straight).ID: return 9734;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9736;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9738;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9740;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9742;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::Straight).ID: return 9744;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9746;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9748;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9750;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XM, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9752;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::Straight).ID: return 9754;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9756;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9758;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9760;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Top, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9762;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::Straight).ID: return 9764;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerLeft).ID: return 9766;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::InnerRight).ID: return 9768;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterLeft).ID: return 9770;
			case SmoothSandstoneStairs::SmoothSandstoneStairs(eBlockFace::BLOCK_FACE_XP, SmoothSandstoneStairs::Half::Bottom, SmoothSandstoneStairs::Shape::OuterRight).ID: return 9772;
			case SmoothStone::SmoothStone().ID: return 7878;
			case SmoothStoneSlab::SmoothStoneSlab(SmoothStoneSlab::Type::Top).ID: return 7807;
			case SmoothStoneSlab::SmoothStoneSlab(SmoothStoneSlab::Type::Bottom).ID: return 7809;
			case SmoothStoneSlab::SmoothStoneSlab(SmoothStoneSlab::Type::Double).ID: return 7811;
			case Snow::Snow(1).ID: return 3919;
			case Snow::Snow(2).ID: return 3920;
			case Snow::Snow(3).ID: return 3921;
			case Snow::Snow(4).ID: return 3922;
			case Snow::Snow(5).ID: return 3923;
			case Snow::Snow(6).ID: return 3924;
			case Snow::Snow(7).ID: return 3925;
			case Snow::Snow(8).ID: return 3926;
			case SnowBlock::SnowBlock().ID: return 3928;
			case SoulSand::SoulSand().ID: return 3998;
			case Spawner::Spawner().ID: return 1951;
			case Sponge::Sponge().ID: return 228;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5834;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5835;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5836;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5837;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 5838;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 5839;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 5840;
			case SpruceButton::SpruceButton(SpruceButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 5841;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5842;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5843;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5844;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5845;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 5846;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 5847;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 5848;
			case SpruceButton::SpruceButton(SpruceButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 5849;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5850;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5851;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5852;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5853;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 5854;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 5855;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 5856;
			case SpruceButton::SpruceButton(SpruceButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 5857;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, true).ID: return 8202;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, false).ID: return 8203;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, true).ID: return 8204;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, false).ID: return 8205;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, true).ID: return 8206;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, false).ID: return 8207;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, true).ID: return 8208;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, false).ID: return 8209;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, true).ID: return 8210;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, false).ID: return 8211;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, true).ID: return 8212;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, false).ID: return 8213;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, true).ID: return 8214;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, false).ID: return 8215;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, true).ID: return 8216;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, false).ID: return 8217;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, true).ID: return 8218;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, false).ID: return 8219;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, true).ID: return 8220;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, false).ID: return 8221;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, true).ID: return 8222;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, false).ID: return 8223;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, true).ID: return 8224;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, false).ID: return 8225;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, true).ID: return 8226;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, false).ID: return 8227;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, true).ID: return 8228;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, false).ID: return 8229;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, true).ID: return 8230;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, false).ID: return 8231;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, true).ID: return 8232;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_ZP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, false).ID: return 8233;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, true).ID: return 8234;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, false).ID: return 8235;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, true).ID: return 8236;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, false).ID: return 8237;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, true).ID: return 8238;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, false).ID: return 8239;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, true).ID: return 8240;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, false).ID: return 8241;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, true).ID: return 8242;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, false).ID: return 8243;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, true).ID: return 8244;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, false).ID: return 8245;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, true).ID: return 8246;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, false).ID: return 8247;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, true).ID: return 8248;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XM, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, false).ID: return 8249;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, true).ID: return 8250;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, true, false).ID: return 8251;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, true).ID: return 8252;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Left, false, false).ID: return 8253;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, true).ID: return 8254;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, true, false).ID: return 8255;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, true).ID: return 8256;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Upper, SpruceDoor::Hinge::Right, false, false).ID: return 8257;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, true).ID: return 8258;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, true, false).ID: return 8259;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, true).ID: return 8260;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Left, false, false).ID: return 8261;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, true).ID: return 8262;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, true, false).ID: return 8263;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, true).ID: return 8264;
			case SpruceDoor::SpruceDoor(eBlockFace::BLOCK_FACE_XP, SpruceDoor::Half::Lower, SpruceDoor::Hinge::Right, false, false).ID: return 8265;
			case SpruceFence::SpruceFence(true, true, true, true).ID: return 8044;
			case SpruceFence::SpruceFence(true, true, true, false).ID: return 8045;
			case SpruceFence::SpruceFence(true, true, false, true).ID: return 8048;
			case SpruceFence::SpruceFence(true, true, false, false).ID: return 8049;
			case SpruceFence::SpruceFence(true, false, true, true).ID: return 8052;
			case SpruceFence::SpruceFence(true, false, true, false).ID: return 8053;
			case SpruceFence::SpruceFence(true, false, false, true).ID: return 8056;
			case SpruceFence::SpruceFence(true, false, false, false).ID: return 8057;
			case SpruceFence::SpruceFence(false, true, true, true).ID: return 8060;
			case SpruceFence::SpruceFence(false, true, true, false).ID: return 8061;
			case SpruceFence::SpruceFence(false, true, false, true).ID: return 8064;
			case SpruceFence::SpruceFence(false, true, false, false).ID: return 8065;
			case SpruceFence::SpruceFence(false, false, true, true).ID: return 8068;
			case SpruceFence::SpruceFence(false, false, true, false).ID: return 8069;
			case SpruceFence::SpruceFence(false, false, false, true).ID: return 8072;
			case SpruceFence::SpruceFence(false, false, false, false).ID: return 8073;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, true).ID: return 7882;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, true, true, false).ID: return 7883;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, true).ID: return 7884;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, true, false, false).ID: return 7885;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, true).ID: return 7886;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, false, true, false).ID: return 7887;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, true).ID: return 7888;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZM, false, false, false).ID: return 7889;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, true).ID: return 7890;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, true, true, false).ID: return 7891;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, true).ID: return 7892;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, true, false, false).ID: return 7893;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, true).ID: return 7894;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, false, true, false).ID: return 7895;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, true).ID: return 7896;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_ZP, false, false, false).ID: return 7897;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, true).ID: return 7898;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, true, true, false).ID: return 7899;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, true).ID: return 7900;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, true, false, false).ID: return 7901;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, true).ID: return 7902;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, false, true, false).ID: return 7903;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, true).ID: return 7904;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XM, false, false, false).ID: return 7905;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, true).ID: return 7906;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, true, true, false).ID: return 7907;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, true).ID: return 7908;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, true, false, false).ID: return 7909;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, true).ID: return 7910;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, false, true, false).ID: return 7911;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, true).ID: return 7912;
			case SpruceFenceGate::SpruceFenceGate(eBlockFace::BLOCK_FACE_XP, false, false, false).ID: return 7913;
			case SpruceLeaves::SpruceLeaves(1, true).ID: return 158;
			case SpruceLeaves::SpruceLeaves(1, false).ID: return 159;
			case SpruceLeaves::SpruceLeaves(2, true).ID: return 160;
			case SpruceLeaves::SpruceLeaves(2, false).ID: return 161;
			case SpruceLeaves::SpruceLeaves(3, true).ID: return 162;
			case SpruceLeaves::SpruceLeaves(3, false).ID: return 163;
			case SpruceLeaves::SpruceLeaves(4, true).ID: return 164;
			case SpruceLeaves::SpruceLeaves(4, false).ID: return 165;
			case SpruceLeaves::SpruceLeaves(5, true).ID: return 166;
			case SpruceLeaves::SpruceLeaves(5, false).ID: return 167;
			case SpruceLeaves::SpruceLeaves(6, true).ID: return 168;
			case SpruceLeaves::SpruceLeaves(6, false).ID: return 169;
			case SpruceLeaves::SpruceLeaves(7, true).ID: return 170;
			case SpruceLeaves::SpruceLeaves(7, false).ID: return 171;
			case SpruceLog::SpruceLog(SpruceLog::Axis::X).ID: return 75;
			case SpruceLog::SpruceLog(SpruceLog::Axis::Y).ID: return 76;
			case SpruceLog::SpruceLog(SpruceLog::Axis::Z).ID: return 77;
			case SprucePlanks::SprucePlanks().ID: return 16;
			case SprucePressurePlate::SprucePressurePlate(true).ID: return 3873;
			case SprucePressurePlate::SprucePressurePlate(false).ID: return 3874;
			case SpruceSapling::SpruceSapling(0).ID: return 23;
			case SpruceSapling::SpruceSapling(1).ID: return 24;
			case SpruceSign::SpruceSign(0).ID: return 3412;
			case SpruceSign::SpruceSign(1).ID: return 3414;
			case SpruceSign::SpruceSign(2).ID: return 3416;
			case SpruceSign::SpruceSign(3).ID: return 3418;
			case SpruceSign::SpruceSign(4).ID: return 3420;
			case SpruceSign::SpruceSign(5).ID: return 3422;
			case SpruceSign::SpruceSign(6).ID: return 3424;
			case SpruceSign::SpruceSign(7).ID: return 3426;
			case SpruceSign::SpruceSign(8).ID: return 3428;
			case SpruceSign::SpruceSign(9).ID: return 3430;
			case SpruceSign::SpruceSign(10).ID: return 3432;
			case SpruceSign::SpruceSign(11).ID: return 3434;
			case SpruceSign::SpruceSign(12).ID: return 3436;
			case SpruceSign::SpruceSign(13).ID: return 3438;
			case SpruceSign::SpruceSign(14).ID: return 3440;
			case SpruceSign::SpruceSign(15).ID: return 3442;
			case SpruceSlab::SpruceSlab(SpruceSlab::Type::Top).ID: return 7771;
			case SpruceSlab::SpruceSlab(SpruceSlab::Type::Bottom).ID: return 7773;
			case SpruceSlab::SpruceSlab(SpruceSlab::Type::Double).ID: return 7775;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Top, SpruceStairs::Shape::Straight).ID: return 5389;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerLeft).ID: return 5391;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerRight).ID: return 5393;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterLeft).ID: return 5395;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterRight).ID: return 5397;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::Straight).ID: return 5399;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerLeft).ID: return 5401;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerRight).ID: return 5403;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterLeft).ID: return 5405;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterRight).ID: return 5407;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Top, SpruceStairs::Shape::Straight).ID: return 5409;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerLeft).ID: return 5411;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerRight).ID: return 5413;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterLeft).ID: return 5415;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterRight).ID: return 5417;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::Straight).ID: return 5419;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerLeft).ID: return 5421;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerRight).ID: return 5423;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterLeft).ID: return 5425;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_ZP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterRight).ID: return 5427;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Top, SpruceStairs::Shape::Straight).ID: return 5429;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerLeft).ID: return 5431;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerRight).ID: return 5433;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterLeft).ID: return 5435;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterRight).ID: return 5437;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::Straight).ID: return 5439;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerLeft).ID: return 5441;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerRight).ID: return 5443;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterLeft).ID: return 5445;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XM, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterRight).ID: return 5447;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Top, SpruceStairs::Shape::Straight).ID: return 5449;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerLeft).ID: return 5451;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Top, SpruceStairs::Shape::InnerRight).ID: return 5453;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterLeft).ID: return 5455;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Top, SpruceStairs::Shape::OuterRight).ID: return 5457;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::Straight).ID: return 5459;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerLeft).ID: return 5461;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::InnerRight).ID: return 5463;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterLeft).ID: return 5465;
			case SpruceStairs::SpruceStairs(eBlockFace::BLOCK_FACE_XP, SpruceStairs::Half::Bottom, SpruceStairs::Shape::OuterRight).ID: return 5467;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Top, true, true).ID: return 4162;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Top, true, false).ID: return 4164;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Top, false, true).ID: return 4166;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Top, false, false).ID: return 4168;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Bottom, true, true).ID: return 4170;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Bottom, true, false).ID: return 4172;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Bottom, false, true).ID: return 4174;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZM, SpruceTrapdoor::Half::Bottom, false, false).ID: return 4176;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Top, true, true).ID: return 4178;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Top, true, false).ID: return 4180;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Top, false, true).ID: return 4182;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Top, false, false).ID: return 4184;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Bottom, true, true).ID: return 4186;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Bottom, true, false).ID: return 4188;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Bottom, false, true).ID: return 4190;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_ZP, SpruceTrapdoor::Half::Bottom, false, false).ID: return 4192;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Top, true, true).ID: return 4194;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Top, true, false).ID: return 4196;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Top, false, true).ID: return 4198;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Top, false, false).ID: return 4200;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Bottom, true, true).ID: return 4202;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Bottom, true, false).ID: return 4204;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Bottom, false, true).ID: return 4206;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XM, SpruceTrapdoor::Half::Bottom, false, false).ID: return 4208;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Top, true, true).ID: return 4210;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Top, true, false).ID: return 4212;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Top, false, true).ID: return 4214;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Top, false, false).ID: return 4216;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Bottom, true, true).ID: return 4218;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Bottom, true, false).ID: return 4220;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Bottom, false, true).ID: return 4222;
			case SpruceTrapdoor::SpruceTrapdoor(eBlockFace::BLOCK_FACE_XP, SpruceTrapdoor::Half::Bottom, false, false).ID: return 4224;
			case SpruceWallSign::SpruceWallSign(eBlockFace::BLOCK_FACE_ZM).ID: return 3742;
			case SpruceWallSign::SpruceWallSign(eBlockFace::BLOCK_FACE_ZP).ID: return 3744;
			case SpruceWallSign::SpruceWallSign(eBlockFace::BLOCK_FACE_XM).ID: return 3746;
			case SpruceWallSign::SpruceWallSign(eBlockFace::BLOCK_FACE_XP).ID: return 3748;
			case SpruceWood::SpruceWood(SpruceWood::Axis::X).ID: return 111;
			case SpruceWood::SpruceWood(SpruceWood::Axis::Y).ID: return 112;
			case SpruceWood::SpruceWood(SpruceWood::Axis::Z).ID: return 113;
			case StickyPiston::StickyPiston(true, eBlockFace::BLOCK_FACE_ZM).ID: return 1328;
			case StickyPiston::StickyPiston(true, eBlockFace::BLOCK_FACE_XP).ID: return 1329;
			case StickyPiston::StickyPiston(true, eBlockFace::BLOCK_FACE_ZP).ID: return 1330;
			case StickyPiston::StickyPiston(true, eBlockFace::BLOCK_FACE_XM).ID: return 1331;
			case StickyPiston::StickyPiston(true, eBlockFace::BLOCK_FACE_YP).ID: return 1332;
			case StickyPiston::StickyPiston(true, eBlockFace::BLOCK_FACE_YM).ID: return 1333;
			case StickyPiston::StickyPiston(false, eBlockFace::BLOCK_FACE_ZM).ID: return 1334;
			case StickyPiston::StickyPiston(false, eBlockFace::BLOCK_FACE_XP).ID: return 1335;
			case StickyPiston::StickyPiston(false, eBlockFace::BLOCK_FACE_ZP).ID: return 1336;
			case StickyPiston::StickyPiston(false, eBlockFace::BLOCK_FACE_XM).ID: return 1337;
			case StickyPiston::StickyPiston(false, eBlockFace::BLOCK_FACE_YP).ID: return 1338;
			case StickyPiston::StickyPiston(false, eBlockFace::BLOCK_FACE_YM).ID: return 1339;
			case Stone::Stone().ID: return 1;
			case StoneBrickSlab::StoneBrickSlab(StoneBrickSlab::Type::Top).ID: return 7843;
			case StoneBrickSlab::StoneBrickSlab(StoneBrickSlab::Type::Bottom).ID: return 7845;
			case StoneBrickSlab::StoneBrickSlab(StoneBrickSlab::Type::Double).ID: return 7847;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::Straight).ID: return 4917;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerLeft).ID: return 4919;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerRight).ID: return 4921;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterLeft).ID: return 4923;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterRight).ID: return 4925;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::Straight).ID: return 4927;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerLeft).ID: return 4929;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerRight).ID: return 4931;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterLeft).ID: return 4933;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterRight).ID: return 4935;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::Straight).ID: return 4937;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerLeft).ID: return 4939;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerRight).ID: return 4941;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterLeft).ID: return 4943;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterRight).ID: return 4945;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::Straight).ID: return 4947;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerLeft).ID: return 4949;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerRight).ID: return 4951;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterLeft).ID: return 4953;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_ZP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterRight).ID: return 4955;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::Straight).ID: return 4957;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerLeft).ID: return 4959;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerRight).ID: return 4961;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterLeft).ID: return 4963;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterRight).ID: return 4965;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::Straight).ID: return 4967;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerLeft).ID: return 4969;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerRight).ID: return 4971;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterLeft).ID: return 4973;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XM, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterRight).ID: return 4975;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::Straight).ID: return 4977;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerLeft).ID: return 4979;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::InnerRight).ID: return 4981;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterLeft).ID: return 4983;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Top, StoneBrickStairs::Shape::OuterRight).ID: return 4985;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::Straight).ID: return 4987;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerLeft).ID: return 4989;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::InnerRight).ID: return 4991;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterLeft).ID: return 4993;
			case StoneBrickStairs::StoneBrickStairs(eBlockFace::BLOCK_FACE_XP, StoneBrickStairs::Half::Bottom, StoneBrickStairs::Shape::OuterRight).ID: return 4995;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::Low, true, StoneBrickWall::West::Low).ID: return 10653;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::Low, true, StoneBrickWall::West::None).ID: return 10654;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::Low, false, StoneBrickWall::West::Low).ID: return 10657;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::Low, false, StoneBrickWall::West::None).ID: return 10658;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::None, true, StoneBrickWall::West::Low).ID: return 10661;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::None, true, StoneBrickWall::West::None).ID: return 10662;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::None, false, StoneBrickWall::West::Low).ID: return 10665;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::Low, StoneBrickWall::South::None, false, StoneBrickWall::West::None).ID: return 10666;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::Low, true, StoneBrickWall::West::Low).ID: return 10669;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::Low, true, StoneBrickWall::West::None).ID: return 10670;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::Low, false, StoneBrickWall::West::Low).ID: return 10673;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::Low, false, StoneBrickWall::West::None).ID: return 10674;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::None, true, StoneBrickWall::West::Low).ID: return 10677;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::None, true, StoneBrickWall::West::None).ID: return 10678;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::None, false, StoneBrickWall::West::Low).ID: return 10681;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::Low, StoneBrickWall::North::None, StoneBrickWall::South::None, false, StoneBrickWall::West::None).ID: return 10682;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::Low, true, StoneBrickWall::West::Low).ID: return 10685;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::Low, true, StoneBrickWall::West::None).ID: return 10686;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::Low, false, StoneBrickWall::West::Low).ID: return 10689;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::Low, false, StoneBrickWall::West::None).ID: return 10690;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::None, true, StoneBrickWall::West::Low).ID: return 10693;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::None, true, StoneBrickWall::West::None).ID: return 10694;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::None, false, StoneBrickWall::West::Low).ID: return 10697;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::Low, StoneBrickWall::South::None, false, StoneBrickWall::West::None).ID: return 10698;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::Low, true, StoneBrickWall::West::Low).ID: return 10701;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::Low, true, StoneBrickWall::West::None).ID: return 10702;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::Low, false, StoneBrickWall::West::Low).ID: return 10705;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::Low, false, StoneBrickWall::West::None).ID: return 10706;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::None, true, StoneBrickWall::West::Low).ID: return 10709;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::None, true, StoneBrickWall::West::None).ID: return 10710;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::None, false, StoneBrickWall::West::Low).ID: return 10713;
			case StoneBrickWall::StoneBrickWall(StoneBrickWall::East::None, StoneBrickWall::North::None, StoneBrickWall::South::None, false, StoneBrickWall::West::None).ID: return 10714;
			case StoneBricks::StoneBricks().ID: return 4481;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3895;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3896;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3897;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3898;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, true).ID: return 3899;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XM, false).ID: return 3900;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, true).ID: return 3901;
			case StoneButton::StoneButton(StoneButton::Face::Floor, eBlockFace::BLOCK_FACE_XP, false).ID: return 3902;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3903;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3904;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3905;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3906;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, true).ID: return 3907;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XM, false).ID: return 3908;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, true).ID: return 3909;
			case StoneButton::StoneButton(StoneButton::Face::Wall, eBlockFace::BLOCK_FACE_XP, false).ID: return 3910;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, true).ID: return 3911;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZM, false).ID: return 3912;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, true).ID: return 3913;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_ZP, false).ID: return 3914;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, true).ID: return 3915;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XM, false).ID: return 3916;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, true).ID: return 3917;
			case StoneButton::StoneButton(StoneButton::Face::Ceiling, eBlockFace::BLOCK_FACE_XP, false).ID: return 3918;
			case StonePressurePlate::StonePressurePlate(true).ID: return 3805;
			case StonePressurePlate::StonePressurePlate(false).ID: return 3806;
			case StoneSlab::StoneSlab(StoneSlab::Type::Top).ID: return 7801;
			case StoneSlab::StoneSlab(StoneSlab::Type::Bottom).ID: return 7803;
			case StoneSlab::StoneSlab(StoneSlab::Type::Double).ID: return 7805;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Top, StoneStairs::Shape::Straight).ID: return 9614;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Top, StoneStairs::Shape::InnerLeft).ID: return 9616;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Top, StoneStairs::Shape::InnerRight).ID: return 9618;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Top, StoneStairs::Shape::OuterLeft).ID: return 9620;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Top, StoneStairs::Shape::OuterRight).ID: return 9622;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Bottom, StoneStairs::Shape::Straight).ID: return 9624;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerLeft).ID: return 9626;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerRight).ID: return 9628;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterLeft).ID: return 9630;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZM, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterRight).ID: return 9632;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Top, StoneStairs::Shape::Straight).ID: return 9634;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Top, StoneStairs::Shape::InnerLeft).ID: return 9636;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Top, StoneStairs::Shape::InnerRight).ID: return 9638;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Top, StoneStairs::Shape::OuterLeft).ID: return 9640;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Top, StoneStairs::Shape::OuterRight).ID: return 9642;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Bottom, StoneStairs::Shape::Straight).ID: return 9644;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerLeft).ID: return 9646;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerRight).ID: return 9648;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterLeft).ID: return 9650;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_ZP, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterRight).ID: return 9652;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Top, StoneStairs::Shape::Straight).ID: return 9654;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Top, StoneStairs::Shape::InnerLeft).ID: return 9656;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Top, StoneStairs::Shape::InnerRight).ID: return 9658;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Top, StoneStairs::Shape::OuterLeft).ID: return 9660;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Top, StoneStairs::Shape::OuterRight).ID: return 9662;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Bottom, StoneStairs::Shape::Straight).ID: return 9664;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerLeft).ID: return 9666;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerRight).ID: return 9668;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterLeft).ID: return 9670;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XM, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterRight).ID: return 9672;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Top, StoneStairs::Shape::Straight).ID: return 9674;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Top, StoneStairs::Shape::InnerLeft).ID: return 9676;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Top, StoneStairs::Shape::InnerRight).ID: return 9678;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Top, StoneStairs::Shape::OuterLeft).ID: return 9680;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Top, StoneStairs::Shape::OuterRight).ID: return 9682;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Bottom, StoneStairs::Shape::Straight).ID: return 9684;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerLeft).ID: return 9686;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Bottom, StoneStairs::Shape::InnerRight).ID: return 9688;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterLeft).ID: return 9690;
			case StoneStairs::StoneStairs(eBlockFace::BLOCK_FACE_XP, StoneStairs::Half::Bottom, StoneStairs::Shape::OuterRight).ID: return 9692;
			case Stonecutter::Stonecutter(eBlockFace::BLOCK_FACE_ZM).ID: return 11194;
			case Stonecutter::Stonecutter(eBlockFace::BLOCK_FACE_ZP).ID: return 11195;
			case Stonecutter::Stonecutter(eBlockFace::BLOCK_FACE_XM).ID: return 11196;
			case Stonecutter::Stonecutter(eBlockFace::BLOCK_FACE_XP).ID: return 11197;
			case StrippedAcaciaLog::StrippedAcaciaLog(StrippedAcaciaLog::Axis::X).ID: return 99;
			case StrippedAcaciaLog::StrippedAcaciaLog(StrippedAcaciaLog::Axis::Y).ID: return 100;
			case StrippedAcaciaLog::StrippedAcaciaLog(StrippedAcaciaLog::Axis::Z).ID: return 101;
			case StrippedAcaciaWood::StrippedAcaciaWood(StrippedAcaciaWood::Axis::X).ID: return 138;
			case StrippedAcaciaWood::StrippedAcaciaWood(StrippedAcaciaWood::Axis::Y).ID: return 139;
			case StrippedAcaciaWood::StrippedAcaciaWood(StrippedAcaciaWood::Axis::Z).ID: return 140;
			case StrippedBirchLog::StrippedBirchLog(StrippedBirchLog::Axis::X).ID: return 93;
			case StrippedBirchLog::StrippedBirchLog(StrippedBirchLog::Axis::Y).ID: return 94;
			case StrippedBirchLog::StrippedBirchLog(StrippedBirchLog::Axis::Z).ID: return 95;
			case StrippedBirchWood::StrippedBirchWood(StrippedBirchWood::Axis::X).ID: return 132;
			case StrippedBirchWood::StrippedBirchWood(StrippedBirchWood::Axis::Y).ID: return 133;
			case StrippedBirchWood::StrippedBirchWood(StrippedBirchWood::Axis::Z).ID: return 134;
			case StrippedDarkOakLog::StrippedDarkOakLog(StrippedDarkOakLog::Axis::X).ID: return 102;
			case StrippedDarkOakLog::StrippedDarkOakLog(StrippedDarkOakLog::Axis::Y).ID: return 103;
			case StrippedDarkOakLog::StrippedDarkOakLog(StrippedDarkOakLog::Axis::Z).ID: return 104;
			case StrippedDarkOakWood::StrippedDarkOakWood(StrippedDarkOakWood::Axis::X).ID: return 141;
			case StrippedDarkOakWood::StrippedDarkOakWood(StrippedDarkOakWood::Axis::Y).ID: return 142;
			case StrippedDarkOakWood::StrippedDarkOakWood(StrippedDarkOakWood::Axis::Z).ID: return 143;
			case StrippedJungleLog::StrippedJungleLog(StrippedJungleLog::Axis::X).ID: return 96;
			case StrippedJungleLog::StrippedJungleLog(StrippedJungleLog::Axis::Y).ID: return 97;
			case StrippedJungleLog::StrippedJungleLog(StrippedJungleLog::Axis::Z).ID: return 98;
			case StrippedJungleWood::StrippedJungleWood(StrippedJungleWood::Axis::X).ID: return 135;
			case StrippedJungleWood::StrippedJungleWood(StrippedJungleWood::Axis::Y).ID: return 136;
			case StrippedJungleWood::StrippedJungleWood(StrippedJungleWood::Axis::Z).ID: return 137;
			case StrippedOakLog::StrippedOakLog(StrippedOakLog::Axis::X).ID: return 105;
			case StrippedOakLog::StrippedOakLog(StrippedOakLog::Axis::Y).ID: return 106;
			case StrippedOakLog::StrippedOakLog(StrippedOakLog::Axis::Z).ID: return 107;
			case StrippedOakWood::StrippedOakWood(StrippedOakWood::Axis::X).ID: return 126;
			case StrippedOakWood::StrippedOakWood(StrippedOakWood::Axis::Y).ID: return 127;
			case StrippedOakWood::StrippedOakWood(StrippedOakWood::Axis::Z).ID: return 128;
			case StrippedSpruceLog::StrippedSpruceLog(StrippedSpruceLog::Axis::X).ID: return 90;
			case StrippedSpruceLog::StrippedSpruceLog(StrippedSpruceLog::Axis::Y).ID: return 91;
			case StrippedSpruceLog::StrippedSpruceLog(StrippedSpruceLog::Axis::Z).ID: return 92;
			case StrippedSpruceWood::StrippedSpruceWood(StrippedSpruceWood::Axis::X).ID: return 129;
			case StrippedSpruceWood::StrippedSpruceWood(StrippedSpruceWood::Axis::Y).ID: return 130;
			case StrippedSpruceWood::StrippedSpruceWood(StrippedSpruceWood::Axis::Z).ID: return 131;
			case StructureBlock::StructureBlock(StructureBlock::Mode::Save).ID: return 11252;
			case StructureBlock::StructureBlock(StructureBlock::Mode::Load).ID: return 11253;
			case StructureBlock::StructureBlock(StructureBlock::Mode::Corner).ID: return 11254;
			case StructureBlock::StructureBlock(StructureBlock::Mode::Data).ID: return 11255;
			case StructureVoid::StructureVoid().ID: return 8723;
			case SugarCane::SugarCane(0).ID: return 3946;
			case SugarCane::SugarCane(1).ID: return 3947;
			case SugarCane::SugarCane(2).ID: return 3948;
			case SugarCane::SugarCane(3).ID: return 3949;
			case SugarCane::SugarCane(4).ID: return 3950;
			case SugarCane::SugarCane(5).ID: return 3951;
			case SugarCane::SugarCane(6).ID: return 3952;
			case SugarCane::SugarCane(7).ID: return 3953;
			case SugarCane::SugarCane(8).ID: return 3954;
			case SugarCane::SugarCane(9).ID: return 3955;
			case SugarCane::SugarCane(10).ID: return 3956;
			case SugarCane::SugarCane(11).ID: return 3957;
			case SugarCane::SugarCane(12).ID: return 3958;
			case SugarCane::SugarCane(13).ID: return 3959;
			case SugarCane::SugarCane(14).ID: return 3960;
			case SugarCane::SugarCane(15).ID: return 3961;
			case Sunflower::Sunflower(Sunflower::Half::Upper).ID: return 7349;
			case Sunflower::Sunflower(Sunflower::Half::Lower).ID: return 7350;
			case SweetBerryBush::SweetBerryBush(0).ID: return 11248;
			case SweetBerryBush::SweetBerryBush(1).ID: return 11249;
			case SweetBerryBush::SweetBerryBush(2).ID: return 11250;
			case SweetBerryBush::SweetBerryBush(3).ID: return 11251;
			case TNT::TNT(true).ID: return 1429;
			case TNT::TNT(false).ID: return 1430;
			case TallGrass::TallGrass(TallGrass::Half::Upper).ID: return 7357;
			case TallGrass::TallGrass(TallGrass::Half::Lower).ID: return 7358;
			case TallSeagrass::TallSeagrass(TallSeagrass::Half::Upper).ID: return 1345;
			case TallSeagrass::TallSeagrass(TallSeagrass::Half::Lower).ID: return 1346;
			case Terracotta::Terracotta().ID: return 7346;
			case Torch::Torch().ID: return 1434;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_ZM, TrappedChest::Type::Single).ID: return 6087;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_ZM, TrappedChest::Type::Left).ID: return 6089;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_ZM, TrappedChest::Type::Right).ID: return 6091;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_ZP, TrappedChest::Type::Single).ID: return 6093;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_ZP, TrappedChest::Type::Left).ID: return 6095;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_ZP, TrappedChest::Type::Right).ID: return 6097;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_XM, TrappedChest::Type::Single).ID: return 6099;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_XM, TrappedChest::Type::Left).ID: return 6101;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_XM, TrappedChest::Type::Right).ID: return 6103;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_XP, TrappedChest::Type::Single).ID: return 6105;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_XP, TrappedChest::Type::Left).ID: return 6107;
			case TrappedChest::TrappedChest(eBlockFace::BLOCK_FACE_XP, TrappedChest::Type::Right).ID: return 6109;
			case Tripwire::Tripwire(true, true, true, true, true, true, true).ID: return 5259;
			case Tripwire::Tripwire(true, true, true, true, true, true, false).ID: return 5260;
			case Tripwire::Tripwire(true, true, true, true, true, false, true).ID: return 5261;
			case Tripwire::Tripwire(true, true, true, true, true, false, false).ID: return 5262;
			case Tripwire::Tripwire(true, true, true, true, false, true, true).ID: return 5263;
			case Tripwire::Tripwire(true, true, true, true, false, true, false).ID: return 5264;
			case Tripwire::Tripwire(true, true, true, true, false, false, true).ID: return 5265;
			case Tripwire::Tripwire(true, true, true, true, false, false, false).ID: return 5266;
			case Tripwire::Tripwire(true, true, true, false, true, true, true).ID: return 5267;
			case Tripwire::Tripwire(true, true, true, false, true, true, false).ID: return 5268;
			case Tripwire::Tripwire(true, true, true, false, true, false, true).ID: return 5269;
			case Tripwire::Tripwire(true, true, true, false, true, false, false).ID: return 5270;
			case Tripwire::Tripwire(true, true, true, false, false, true, true).ID: return 5271;
			case Tripwire::Tripwire(true, true, true, false, false, true, false).ID: return 5272;
			case Tripwire::Tripwire(true, true, true, false, false, false, true).ID: return 5273;
			case Tripwire::Tripwire(true, true, true, false, false, false, false).ID: return 5274;
			case Tripwire::Tripwire(true, true, false, true, true, true, true).ID: return 5275;
			case Tripwire::Tripwire(true, true, false, true, true, true, false).ID: return 5276;
			case Tripwire::Tripwire(true, true, false, true, true, false, true).ID: return 5277;
			case Tripwire::Tripwire(true, true, false, true, true, false, false).ID: return 5278;
			case Tripwire::Tripwire(true, true, false, true, false, true, true).ID: return 5279;
			case Tripwire::Tripwire(true, true, false, true, false, true, false).ID: return 5280;
			case Tripwire::Tripwire(true, true, false, true, false, false, true).ID: return 5281;
			case Tripwire::Tripwire(true, true, false, true, false, false, false).ID: return 5282;
			case Tripwire::Tripwire(true, true, false, false, true, true, true).ID: return 5283;
			case Tripwire::Tripwire(true, true, false, false, true, true, false).ID: return 5284;
			case Tripwire::Tripwire(true, true, false, false, true, false, true).ID: return 5285;
			case Tripwire::Tripwire(true, true, false, false, true, false, false).ID: return 5286;
			case Tripwire::Tripwire(true, true, false, false, false, true, true).ID: return 5287;
			case Tripwire::Tripwire(true, true, false, false, false, true, false).ID: return 5288;
			case Tripwire::Tripwire(true, true, false, false, false, false, true).ID: return 5289;
			case Tripwire::Tripwire(true, true, false, false, false, false, false).ID: return 5290;
			case Tripwire::Tripwire(true, false, true, true, true, true, true).ID: return 5291;
			case Tripwire::Tripwire(true, false, true, true, true, true, false).ID: return 5292;
			case Tripwire::Tripwire(true, false, true, true, true, false, true).ID: return 5293;
			case Tripwire::Tripwire(true, false, true, true, true, false, false).ID: return 5294;
			case Tripwire::Tripwire(true, false, true, true, false, true, true).ID: return 5295;
			case Tripwire::Tripwire(true, false, true, true, false, true, false).ID: return 5296;
			case Tripwire::Tripwire(true, false, true, true, false, false, true).ID: return 5297;
			case Tripwire::Tripwire(true, false, true, true, false, false, false).ID: return 5298;
			case Tripwire::Tripwire(true, false, true, false, true, true, true).ID: return 5299;
			case Tripwire::Tripwire(true, false, true, false, true, true, false).ID: return 5300;
			case Tripwire::Tripwire(true, false, true, false, true, false, true).ID: return 5301;
			case Tripwire::Tripwire(true, false, true, false, true, false, false).ID: return 5302;
			case Tripwire::Tripwire(true, false, true, false, false, true, true).ID: return 5303;
			case Tripwire::Tripwire(true, false, true, false, false, true, false).ID: return 5304;
			case Tripwire::Tripwire(true, false, true, false, false, false, true).ID: return 5305;
			case Tripwire::Tripwire(true, false, true, false, false, false, false).ID: return 5306;
			case Tripwire::Tripwire(true, false, false, true, true, true, true).ID: return 5307;
			case Tripwire::Tripwire(true, false, false, true, true, true, false).ID: return 5308;
			case Tripwire::Tripwire(true, false, false, true, true, false, true).ID: return 5309;
			case Tripwire::Tripwire(true, false, false, true, true, false, false).ID: return 5310;
			case Tripwire::Tripwire(true, false, false, true, false, true, true).ID: return 5311;
			case Tripwire::Tripwire(true, false, false, true, false, true, false).ID: return 5312;
			case Tripwire::Tripwire(true, false, false, true, false, false, true).ID: return 5313;
			case Tripwire::Tripwire(true, false, false, true, false, false, false).ID: return 5314;
			case Tripwire::Tripwire(true, false, false, false, true, true, true).ID: return 5315;
			case Tripwire::Tripwire(true, false, false, false, true, true, false).ID: return 5316;
			case Tripwire::Tripwire(true, false, false, false, true, false, true).ID: return 5317;
			case Tripwire::Tripwire(true, false, false, false, true, false, false).ID: return 5318;
			case Tripwire::Tripwire(true, false, false, false, false, true, true).ID: return 5319;
			case Tripwire::Tripwire(true, false, false, false, false, true, false).ID: return 5320;
			case Tripwire::Tripwire(true, false, false, false, false, false, true).ID: return 5321;
			case Tripwire::Tripwire(true, false, false, false, false, false, false).ID: return 5322;
			case Tripwire::Tripwire(false, true, true, true, true, true, true).ID: return 5323;
			case Tripwire::Tripwire(false, true, true, true, true, true, false).ID: return 5324;
			case Tripwire::Tripwire(false, true, true, true, true, false, true).ID: return 5325;
			case Tripwire::Tripwire(false, true, true, true, true, false, false).ID: return 5326;
			case Tripwire::Tripwire(false, true, true, true, false, true, true).ID: return 5327;
			case Tripwire::Tripwire(false, true, true, true, false, true, false).ID: return 5328;
			case Tripwire::Tripwire(false, true, true, true, false, false, true).ID: return 5329;
			case Tripwire::Tripwire(false, true, true, true, false, false, false).ID: return 5330;
			case Tripwire::Tripwire(false, true, true, false, true, true, true).ID: return 5331;
			case Tripwire::Tripwire(false, true, true, false, true, true, false).ID: return 5332;
			case Tripwire::Tripwire(false, true, true, false, true, false, true).ID: return 5333;
			case Tripwire::Tripwire(false, true, true, false, true, false, false).ID: return 5334;
			case Tripwire::Tripwire(false, true, true, false, false, true, true).ID: return 5335;
			case Tripwire::Tripwire(false, true, true, false, false, true, false).ID: return 5336;
			case Tripwire::Tripwire(false, true, true, false, false, false, true).ID: return 5337;
			case Tripwire::Tripwire(false, true, true, false, false, false, false).ID: return 5338;
			case Tripwire::Tripwire(false, true, false, true, true, true, true).ID: return 5339;
			case Tripwire::Tripwire(false, true, false, true, true, true, false).ID: return 5340;
			case Tripwire::Tripwire(false, true, false, true, true, false, true).ID: return 5341;
			case Tripwire::Tripwire(false, true, false, true, true, false, false).ID: return 5342;
			case Tripwire::Tripwire(false, true, false, true, false, true, true).ID: return 5343;
			case Tripwire::Tripwire(false, true, false, true, false, true, false).ID: return 5344;
			case Tripwire::Tripwire(false, true, false, true, false, false, true).ID: return 5345;
			case Tripwire::Tripwire(false, true, false, true, false, false, false).ID: return 5346;
			case Tripwire::Tripwire(false, true, false, false, true, true, true).ID: return 5347;
			case Tripwire::Tripwire(false, true, false, false, true, true, false).ID: return 5348;
			case Tripwire::Tripwire(false, true, false, false, true, false, true).ID: return 5349;
			case Tripwire::Tripwire(false, true, false, false, true, false, false).ID: return 5350;
			case Tripwire::Tripwire(false, true, false, false, false, true, true).ID: return 5351;
			case Tripwire::Tripwire(false, true, false, false, false, true, false).ID: return 5352;
			case Tripwire::Tripwire(false, true, false, false, false, false, true).ID: return 5353;
			case Tripwire::Tripwire(false, true, false, false, false, false, false).ID: return 5354;
			case Tripwire::Tripwire(false, false, true, true, true, true, true).ID: return 5355;
			case Tripwire::Tripwire(false, false, true, true, true, true, false).ID: return 5356;
			case Tripwire::Tripwire(false, false, true, true, true, false, true).ID: return 5357;
			case Tripwire::Tripwire(false, false, true, true, true, false, false).ID: return 5358;
			case Tripwire::Tripwire(false, false, true, true, false, true, true).ID: return 5359;
			case Tripwire::Tripwire(false, false, true, true, false, true, false).ID: return 5360;
			case Tripwire::Tripwire(false, false, true, true, false, false, true).ID: return 5361;
			case Tripwire::Tripwire(false, false, true, true, false, false, false).ID: return 5362;
			case Tripwire::Tripwire(false, false, true, false, true, true, true).ID: return 5363;
			case Tripwire::Tripwire(false, false, true, false, true, true, false).ID: return 5364;
			case Tripwire::Tripwire(false, false, true, false, true, false, true).ID: return 5365;
			case Tripwire::Tripwire(false, false, true, false, true, false, false).ID: return 5366;
			case Tripwire::Tripwire(false, false, true, false, false, true, true).ID: return 5367;
			case Tripwire::Tripwire(false, false, true, false, false, true, false).ID: return 5368;
			case Tripwire::Tripwire(false, false, true, false, false, false, true).ID: return 5369;
			case Tripwire::Tripwire(false, false, true, false, false, false, false).ID: return 5370;
			case Tripwire::Tripwire(false, false, false, true, true, true, true).ID: return 5371;
			case Tripwire::Tripwire(false, false, false, true, true, true, false).ID: return 5372;
			case Tripwire::Tripwire(false, false, false, true, true, false, true).ID: return 5373;
			case Tripwire::Tripwire(false, false, false, true, true, false, false).ID: return 5374;
			case Tripwire::Tripwire(false, false, false, true, false, true, true).ID: return 5375;
			case Tripwire::Tripwire(false, false, false, true, false, true, false).ID: return 5376;
			case Tripwire::Tripwire(false, false, false, true, false, false, true).ID: return 5377;
			case Tripwire::Tripwire(false, false, false, true, false, false, false).ID: return 5378;
			case Tripwire::Tripwire(false, false, false, false, true, true, true).ID: return 5379;
			case Tripwire::Tripwire(false, false, false, false, true, true, false).ID: return 5380;
			case Tripwire::Tripwire(false, false, false, false, true, false, true).ID: return 5381;
			case Tripwire::Tripwire(false, false, false, false, true, false, false).ID: return 5382;
			case Tripwire::Tripwire(false, false, false, false, false, true, true).ID: return 5383;
			case Tripwire::Tripwire(false, false, false, false, false, true, false).ID: return 5384;
			case Tripwire::Tripwire(false, false, false, false, false, false, true).ID: return 5385;
			case Tripwire::Tripwire(false, false, false, false, false, false, false).ID: return 5386;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5243;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5244;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5245;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5246;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_XM, true).ID: return 5247;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_XM, false).ID: return 5248;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_XP, true).ID: return 5249;
			case TripwireHook::TripwireHook(true, eBlockFace::BLOCK_FACE_XP, false).ID: return 5250;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_ZM, true).ID: return 5251;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_ZM, false).ID: return 5252;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_ZP, true).ID: return 5253;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_ZP, false).ID: return 5254;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_XM, true).ID: return 5255;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_XM, false).ID: return 5256;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_XP, true).ID: return 5257;
			case TripwireHook::TripwireHook(false, eBlockFace::BLOCK_FACE_XP, false).ID: return 5258;
			case TubeCoral::TubeCoral().ID: return 8995;
			case TubeCoralBlock::TubeCoralBlock().ID: return 8979;
			case TubeCoralFan::TubeCoralFan().ID: return 9015;
			case TubeCoralWallFan::TubeCoralWallFan(eBlockFace::BLOCK_FACE_ZM).ID: return 9065;
			case TubeCoralWallFan::TubeCoralWallFan(eBlockFace::BLOCK_FACE_ZP).ID: return 9067;
			case TubeCoralWallFan::TubeCoralWallFan(eBlockFace::BLOCK_FACE_XM).ID: return 9069;
			case TubeCoralWallFan::TubeCoralWallFan(eBlockFace::BLOCK_FACE_XP).ID: return 9071;
			case TurtleEgg::TurtleEgg(1, 0).ID: return 8962;
			case TurtleEgg::TurtleEgg(1, 1).ID: return 8963;
			case TurtleEgg::TurtleEgg(1, 2).ID: return 8964;
			case TurtleEgg::TurtleEgg(2, 0).ID: return 8965;
			case TurtleEgg::TurtleEgg(2, 1).ID: return 8966;
			case TurtleEgg::TurtleEgg(2, 2).ID: return 8967;
			case TurtleEgg::TurtleEgg(3, 0).ID: return 8968;
			case TurtleEgg::TurtleEgg(3, 1).ID: return 8969;
			case TurtleEgg::TurtleEgg(3, 2).ID: return 8970;
			case TurtleEgg::TurtleEgg(4, 0).ID: return 8971;
			case TurtleEgg::TurtleEgg(4, 1).ID: return 8972;
			case TurtleEgg::TurtleEgg(4, 2).ID: return 8973;
			case Vine::Vine(true, true, true, true, true).ID: return 4772;
			case Vine::Vine(true, true, true, true, false).ID: return 4773;
			case Vine::Vine(true, true, true, false, true).ID: return 4774;
			case Vine::Vine(true, true, true, false, false).ID: return 4775;
			case Vine::Vine(true, true, false, true, true).ID: return 4776;
			case Vine::Vine(true, true, false, true, false).ID: return 4777;
			case Vine::Vine(true, true, false, false, true).ID: return 4778;
			case Vine::Vine(true, true, false, false, false).ID: return 4779;
			case Vine::Vine(true, false, true, true, true).ID: return 4780;
			case Vine::Vine(true, false, true, true, false).ID: return 4781;
			case Vine::Vine(true, false, true, false, true).ID: return 4782;
			case Vine::Vine(true, false, true, false, false).ID: return 4783;
			case Vine::Vine(true, false, false, true, true).ID: return 4784;
			case Vine::Vine(true, false, false, true, false).ID: return 4785;
			case Vine::Vine(true, false, false, false, true).ID: return 4786;
			case Vine::Vine(true, false, false, false, false).ID: return 4787;
			case Vine::Vine(false, true, true, true, true).ID: return 4788;
			case Vine::Vine(false, true, true, true, false).ID: return 4789;
			case Vine::Vine(false, true, true, false, true).ID: return 4790;
			case Vine::Vine(false, true, true, false, false).ID: return 4791;
			case Vine::Vine(false, true, false, true, true).ID: return 4792;
			case Vine::Vine(false, true, false, true, false).ID: return 4793;
			case Vine::Vine(false, true, false, false, true).ID: return 4794;
			case Vine::Vine(false, true, false, false, false).ID: return 4795;
			case Vine::Vine(false, false, true, true, true).ID: return 4796;
			case Vine::Vine(false, false, true, true, false).ID: return 4797;
			case Vine::Vine(false, false, true, false, true).ID: return 4798;
			case Vine::Vine(false, false, true, false, false).ID: return 4799;
			case Vine::Vine(false, false, false, true, true).ID: return 4800;
			case Vine::Vine(false, false, false, true, false).ID: return 4801;
			case Vine::Vine(false, false, false, false, true).ID: return 4802;
			case Vine::Vine(false, false, false, false, false).ID: return 4803;
			case VoidAir::VoidAir().ID: return 9129;
			case WallTorch::WallTorch(eBlockFace::BLOCK_FACE_ZM).ID: return 1435;
			case WallTorch::WallTorch(eBlockFace::BLOCK_FACE_ZP).ID: return 1436;
			case WallTorch::WallTorch(eBlockFace::BLOCK_FACE_XM).ID: return 1437;
			case WallTorch::WallTorch(eBlockFace::BLOCK_FACE_XP).ID: return 1438;
			case Water::Water(0).ID: return 34;
			case Water::Water(1).ID: return 35;
			case Water::Water(2).ID: return 36;
			case Water::Water(3).ID: return 37;
			case Water::Water(4).ID: return 38;
			case Water::Water(5).ID: return 39;
			case Water::Water(6).ID: return 40;
			case Water::Water(7).ID: return 41;
			case Water::Water(8).ID: return 42;
			case Water::Water(9).ID: return 43;
			case Water::Water(10).ID: return 44;
			case Water::Water(11).ID: return 45;
			case Water::Water(12).ID: return 46;
			case Water::Water(13).ID: return 47;
			case Water::Water(14).ID: return 48;
			case Water::Water(15).ID: return 49;
			case WetSponge::WetSponge().ID: return 229;
			case Wheat::Wheat(0).ID: return 3355;
			case Wheat::Wheat(1).ID: return 3356;
			case Wheat::Wheat(2).ID: return 3357;
			case Wheat::Wheat(3).ID: return 3358;
			case Wheat::Wheat(4).ID: return 3359;
			case Wheat::Wheat(5).ID: return 3360;
			case Wheat::Wheat(6).ID: return 3361;
			case Wheat::Wheat(7).ID: return 3362;
			case WhiteBanner::WhiteBanner(0).ID: return 7361;
			case WhiteBanner::WhiteBanner(1).ID: return 7362;
			case WhiteBanner::WhiteBanner(2).ID: return 7363;
			case WhiteBanner::WhiteBanner(3).ID: return 7364;
			case WhiteBanner::WhiteBanner(4).ID: return 7365;
			case WhiteBanner::WhiteBanner(5).ID: return 7366;
			case WhiteBanner::WhiteBanner(6).ID: return 7367;
			case WhiteBanner::WhiteBanner(7).ID: return 7368;
			case WhiteBanner::WhiteBanner(8).ID: return 7369;
			case WhiteBanner::WhiteBanner(9).ID: return 7370;
			case WhiteBanner::WhiteBanner(10).ID: return 7371;
			case WhiteBanner::WhiteBanner(11).ID: return 7372;
			case WhiteBanner::WhiteBanner(12).ID: return 7373;
			case WhiteBanner::WhiteBanner(13).ID: return 7374;
			case WhiteBanner::WhiteBanner(14).ID: return 7375;
			case WhiteBanner::WhiteBanner(15).ID: return 7376;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZM, true, WhiteBed::Part::Head).ID: return 1048;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZM, true, WhiteBed::Part::Foot).ID: return 1049;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZM, false, WhiteBed::Part::Head).ID: return 1050;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZM, false, WhiteBed::Part::Foot).ID: return 1051;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZP, true, WhiteBed::Part::Head).ID: return 1052;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZP, true, WhiteBed::Part::Foot).ID: return 1053;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZP, false, WhiteBed::Part::Head).ID: return 1054;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_ZP, false, WhiteBed::Part::Foot).ID: return 1055;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XM, true, WhiteBed::Part::Head).ID: return 1056;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XM, true, WhiteBed::Part::Foot).ID: return 1057;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XM, false, WhiteBed::Part::Head).ID: return 1058;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XM, false, WhiteBed::Part::Foot).ID: return 1059;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XP, true, WhiteBed::Part::Head).ID: return 1060;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XP, true, WhiteBed::Part::Foot).ID: return 1061;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XP, false, WhiteBed::Part::Head).ID: return 1062;
			case WhiteBed::WhiteBed(eBlockFace::BLOCK_FACE_XP, false, WhiteBed::Part::Foot).ID: return 1063;
			case WhiteCarpet::WhiteCarpet().ID: return 7330;
			case WhiteConcrete::WhiteConcrete().ID: return 8902;
			case WhiteConcretePowder::WhiteConcretePowder().ID: return 8918;
			case WhiteGlazedTerracotta::WhiteGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8838;
			case WhiteGlazedTerracotta::WhiteGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8839;
			case WhiteGlazedTerracotta::WhiteGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8840;
			case WhiteGlazedTerracotta::WhiteGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8841;
			case WhiteShulkerBox::WhiteShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8742;
			case WhiteShulkerBox::WhiteShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8743;
			case WhiteShulkerBox::WhiteShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8744;
			case WhiteShulkerBox::WhiteShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8745;
			case WhiteShulkerBox::WhiteShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8746;
			case WhiteShulkerBox::WhiteShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8747;
			case WhiteStainedGlass::WhiteStainedGlass().ID: return 4081;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, true, true, true).ID: return 6329;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, true, true, false).ID: return 6330;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, true, false, true).ID: return 6333;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, true, false, false).ID: return 6334;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, false, true, true).ID: return 6337;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, false, true, false).ID: return 6338;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, false, false, true).ID: return 6341;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(true, false, false, false).ID: return 6342;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, true, true, true).ID: return 6345;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, true, true, false).ID: return 6346;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, true, false, true).ID: return 6349;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, true, false, false).ID: return 6350;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, false, true, true).ID: return 6353;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, false, true, false).ID: return 6354;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, false, false, true).ID: return 6357;
			case WhiteStainedGlassPane::WhiteStainedGlassPane(false, false, false, false).ID: return 6358;
			case WhiteTerracotta::WhiteTerracotta().ID: return 6311;
			case WhiteTulip::WhiteTulip().ID: return 1418;
			case WhiteWallBanner::WhiteWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7617;
			case WhiteWallBanner::WhiteWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7618;
			case WhiteWallBanner::WhiteWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7619;
			case WhiteWallBanner::WhiteWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7620;
			case WhiteWool::WhiteWool().ID: return 1383;
			case WitherRose::WitherRose().ID: return 1422;
			case WitherSkeletonSkull::WitherSkeletonSkull(0).ID: return 5974;
			case WitherSkeletonSkull::WitherSkeletonSkull(1).ID: return 5975;
			case WitherSkeletonSkull::WitherSkeletonSkull(2).ID: return 5976;
			case WitherSkeletonSkull::WitherSkeletonSkull(3).ID: return 5977;
			case WitherSkeletonSkull::WitherSkeletonSkull(4).ID: return 5978;
			case WitherSkeletonSkull::WitherSkeletonSkull(5).ID: return 5979;
			case WitherSkeletonSkull::WitherSkeletonSkull(6).ID: return 5980;
			case WitherSkeletonSkull::WitherSkeletonSkull(7).ID: return 5981;
			case WitherSkeletonSkull::WitherSkeletonSkull(8).ID: return 5982;
			case WitherSkeletonSkull::WitherSkeletonSkull(9).ID: return 5983;
			case WitherSkeletonSkull::WitherSkeletonSkull(10).ID: return 5984;
			case WitherSkeletonSkull::WitherSkeletonSkull(11).ID: return 5985;
			case WitherSkeletonSkull::WitherSkeletonSkull(12).ID: return 5986;
			case WitherSkeletonSkull::WitherSkeletonSkull(13).ID: return 5987;
			case WitherSkeletonSkull::WitherSkeletonSkull(14).ID: return 5988;
			case WitherSkeletonSkull::WitherSkeletonSkull(15).ID: return 5989;
			case WitherSkeletonWallSkull::WitherSkeletonWallSkull(eBlockFace::BLOCK_FACE_ZM).ID: return 5990;
			case WitherSkeletonWallSkull::WitherSkeletonWallSkull(eBlockFace::BLOCK_FACE_ZP).ID: return 5991;
			case WitherSkeletonWallSkull::WitherSkeletonWallSkull(eBlockFace::BLOCK_FACE_XM).ID: return 5992;
			case WitherSkeletonWallSkull::WitherSkeletonWallSkull(eBlockFace::BLOCK_FACE_XP).ID: return 5993;
			case YellowBanner::YellowBanner(0).ID: return 7425;
			case YellowBanner::YellowBanner(1).ID: return 7426;
			case YellowBanner::YellowBanner(2).ID: return 7427;
			case YellowBanner::YellowBanner(3).ID: return 7428;
			case YellowBanner::YellowBanner(4).ID: return 7429;
			case YellowBanner::YellowBanner(5).ID: return 7430;
			case YellowBanner::YellowBanner(6).ID: return 7431;
			case YellowBanner::YellowBanner(7).ID: return 7432;
			case YellowBanner::YellowBanner(8).ID: return 7433;
			case YellowBanner::YellowBanner(9).ID: return 7434;
			case YellowBanner::YellowBanner(10).ID: return 7435;
			case YellowBanner::YellowBanner(11).ID: return 7436;
			case YellowBanner::YellowBanner(12).ID: return 7437;
			case YellowBanner::YellowBanner(13).ID: return 7438;
			case YellowBanner::YellowBanner(14).ID: return 7439;
			case YellowBanner::YellowBanner(15).ID: return 7440;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZM, true, YellowBed::Part::Head).ID: return 1112;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZM, true, YellowBed::Part::Foot).ID: return 1113;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZM, false, YellowBed::Part::Head).ID: return 1114;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZM, false, YellowBed::Part::Foot).ID: return 1115;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZP, true, YellowBed::Part::Head).ID: return 1116;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZP, true, YellowBed::Part::Foot).ID: return 1117;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZP, false, YellowBed::Part::Head).ID: return 1118;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_ZP, false, YellowBed::Part::Foot).ID: return 1119;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XM, true, YellowBed::Part::Head).ID: return 1120;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XM, true, YellowBed::Part::Foot).ID: return 1121;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XM, false, YellowBed::Part::Head).ID: return 1122;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XM, false, YellowBed::Part::Foot).ID: return 1123;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XP, true, YellowBed::Part::Head).ID: return 1124;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XP, true, YellowBed::Part::Foot).ID: return 1125;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XP, false, YellowBed::Part::Head).ID: return 1126;
			case YellowBed::YellowBed(eBlockFace::BLOCK_FACE_XP, false, YellowBed::Part::Foot).ID: return 1127;
			case YellowCarpet::YellowCarpet().ID: return 7334;
			case YellowConcrete::YellowConcrete().ID: return 8906;
			case YellowConcretePowder::YellowConcretePowder().ID: return 8922;
			case YellowGlazedTerracotta::YellowGlazedTerracotta(eBlockFace::BLOCK_FACE_ZM).ID: return 8854;
			case YellowGlazedTerracotta::YellowGlazedTerracotta(eBlockFace::BLOCK_FACE_ZP).ID: return 8855;
			case YellowGlazedTerracotta::YellowGlazedTerracotta(eBlockFace::BLOCK_FACE_XM).ID: return 8856;
			case YellowGlazedTerracotta::YellowGlazedTerracotta(eBlockFace::BLOCK_FACE_XP).ID: return 8857;
			case YellowShulkerBox::YellowShulkerBox(eBlockFace::BLOCK_FACE_ZM).ID: return 8766;
			case YellowShulkerBox::YellowShulkerBox(eBlockFace::BLOCK_FACE_XP).ID: return 8767;
			case YellowShulkerBox::YellowShulkerBox(eBlockFace::BLOCK_FACE_ZP).ID: return 8768;
			case YellowShulkerBox::YellowShulkerBox(eBlockFace::BLOCK_FACE_XM).ID: return 8769;
			case YellowShulkerBox::YellowShulkerBox(eBlockFace::BLOCK_FACE_YP).ID: return 8770;
			case YellowShulkerBox::YellowShulkerBox(eBlockFace::BLOCK_FACE_YM).ID: return 8771;
			case YellowStainedGlass::YellowStainedGlass().ID: return 4085;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, true, true, true).ID: return 6457;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, true, true, false).ID: return 6458;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, true, false, true).ID: return 6461;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, true, false, false).ID: return 6462;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, false, true, true).ID: return 6465;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, false, true, false).ID: return 6466;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, false, false, true).ID: return 6469;
			case YellowStainedGlassPane::YellowStainedGlassPane(true, false, false, false).ID: return 6470;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, true, true, true).ID: return 6473;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, true, true, false).ID: return 6474;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, true, false, true).ID: return 6477;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, true, false, false).ID: return 6478;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, false, true, true).ID: return 6481;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, false, true, false).ID: return 6482;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, false, false, true).ID: return 6485;
			case YellowStainedGlassPane::YellowStainedGlassPane(false, false, false, false).ID: return 6486;
			case YellowTerracotta::YellowTerracotta().ID: return 6315;
			case YellowWallBanner::YellowWallBanner(eBlockFace::BLOCK_FACE_ZM).ID: return 7633;
			case YellowWallBanner::YellowWallBanner(eBlockFace::BLOCK_FACE_ZP).ID: return 7634;
			case YellowWallBanner::YellowWallBanner(eBlockFace::BLOCK_FACE_XM).ID: return 7635;
			case YellowWallBanner::YellowWallBanner(eBlockFace::BLOCK_FACE_XP).ID: return 7636;
			case YellowWool::YellowWool().ID: return 1387;
			case ZombieHead::ZombieHead(0).ID: return 5994;
			case ZombieHead::ZombieHead(1).ID: return 5995;
			case ZombieHead::ZombieHead(2).ID: return 5996;
			case ZombieHead::ZombieHead(3).ID: return 5997;
			case ZombieHead::ZombieHead(4).ID: return 5998;
			case ZombieHead::ZombieHead(5).ID: return 5999;
			case ZombieHead::ZombieHead(6).ID: return 6000;
			case ZombieHead::ZombieHead(7).ID: return 6001;
			case ZombieHead::ZombieHead(8).ID: return 6002;
			case ZombieHead::ZombieHead(9).ID: return 6003;
			case ZombieHead::ZombieHead(10).ID: return 6004;
			case ZombieHead::ZombieHead(11).ID: return 6005;
			case ZombieHead::ZombieHead(12).ID: return 6006;
			case ZombieHead::ZombieHead(13).ID: return 6007;
			case ZombieHead::ZombieHead(14).ID: return 6008;
			case ZombieHead::ZombieHead(15).ID: return 6009;
			case ZombieWallHead::ZombieWallHead(eBlockFace::BLOCK_FACE_ZM).ID: return 6010;
			case ZombieWallHead::ZombieWallHead(eBlockFace::BLOCK_FACE_ZP).ID: return 6011;
			case ZombieWallHead::ZombieWallHead(eBlockFace::BLOCK_FACE_XM).ID: return 6012;
			case ZombieWallHead::ZombieWallHead(eBlockFace::BLOCK_FACE_XP).ID: return 6013;
			default: return 0;
		}
	}

	UInt32 From(const Item ID)
	{
		switch (ID)
		{
			case Item::AcaciaBoat: return 833;
			case Item::AcaciaButton: return 263;
			case Item::AcaciaDoor: return 511;
			case Item::AcaciaFence: return 185;
			case Item::AcaciaFenceGate: return 220;
			case Item::AcaciaLeaves: return 60;
			case Item::AcaciaLog: return 36;
			case Item::AcaciaPlanks: return 17;
			case Item::AcaciaPressurePlate: return 170;
			case Item::AcaciaSapling: return 23;
			case Item::AcaciaSign: return 593;
			case Item::AcaciaSlab: return 119;
			case Item::AcaciaStairs: return 319;
			case Item::AcaciaTrapdoor: return 197;
			case Item::AcaciaWood: return 54;
			case Item::ActivatorRail: return 279;
			case Item::Air: return -0;
			case Item::Allium: return 101;
			case Item::Andesite: return 6;
			case Item::AndesiteSlab: return 501;
			case Item::AndesiteStairs: return 488;
			case Item::AndesiteWall: return 254;
			case Item::Anvil: return 265;
			case Item::Apple: return 524;
			case Item::ArmorStand: return 791;
			case Item::Arrow: return 526;
			case Item::AzureBluet: return 102;
			case Item::BakedPotato: return 764;
			case Item::Bamboo: return 614;
			case Item::Barrel: return 864;
			case Item::Barrier: return 297;
			case Item::BatSpawnEgg: return 697;
			case Item::Beacon: return 244;
			case Item::Bedrock: return 25;
			case Item::Beef: return 677;
			case Item::Beetroot: return 820;
			case Item::BeetrootSeeds: return 821;
			case Item::BeetrootSoup: return 822;
			case Item::Bell: return 873;
			case Item::BirchBoat: return 831;
			case Item::BirchButton: return 261;
			case Item::BirchDoor: return 509;
			case Item::BirchFence: return 183;
			case Item::BirchFenceGate: return 218;
			case Item::BirchLeaves: return 58;
			case Item::BirchLog: return 34;
			case Item::BirchPlanks: return 15;
			case Item::BirchPressurePlate: return 168;
			case Item::BirchSapling: return 21;
			case Item::BirchSign: return 591;
			case Item::BirchSlab: return 117;
			case Item::BirchStairs: return 241;
			case Item::BirchTrapdoor: return 195;
			case Item::BirchWood: return 52;
			case Item::BlackBanner: return 816;
			case Item::BlackBed: return 669;
			case Item::BlackCarpet: return 315;
			case Item::BlackConcrete: return 428;
			case Item::BlackConcretePowder: return 444;
			case Item::BlackDye: return 649;
			case Item::BlackGlazedTerracotta: return 412;
			case Item::BlackShulkerBox: return 396;
			case Item::BlackStainedGlass: return 344;
			case Item::BlackStainedGlassPane: return 360;
			case Item::BlackTerracotta: return 296;
			case Item::BlackWool: return 97;
			case Item::BlastFurnace: return 866;
			case Item::BlazePowder: return 691;
			case Item::BlazeRod: return 683;
			case Item::BlazeSpawnEgg: return 698;
			case Item::BlueBanner: return 812;
			case Item::BlueBed: return 665;
			case Item::BlueCarpet: return 311;
			case Item::BlueConcrete: return 424;
			case Item::BlueConcretePowder: return 440;
			case Item::BlueDye: return 647;
			case Item::BlueGlazedTerracotta: return 408;
			case Item::BlueIce: return 476;
			case Item::BlueOrchid: return 100;
			case Item::BlueShulkerBox: return 392;
			case Item::BlueStainedGlass: return 340;
			case Item::BlueStainedGlassPane: return 356;
			case Item::BlueTerracotta: return 292;
			case Item::BlueWool: return 93;
			case Item::Bone: return 651;
			case Item::BoneBlock: return 377;
			case Item::BoneMeal: return 646;
			case Item::Book: return 616;
			case Item::Bookshelf: return 143;
			case Item::Bow: return 525;
			case Item::Bowl: return 546;
			case Item::BrainCoral: return 457;
			case Item::BrainCoralBlock: return 452;
			case Item::BrainCoralFan: return 467;
			case Item::Bread: return 562;
			case Item::BrewingStand: return 693;
			case Item::Brick: return 609;
			case Item::BrickSlab: return 127;
			case Item::BrickStairs: return 222;
			case Item::BrickWall: return 247;
			case Item::Bricks: return 141;
			case Item::BrownBanner: return 813;
			case Item::BrownBed: return 666;
			case Item::BrownCarpet: return 312;
			case Item::BrownConcrete: return 425;
			case Item::BrownConcretePowder: return 441;
			case Item::BrownDye: return 648;
			case Item::BrownGlazedTerracotta: return 409;
			case Item::BrownMushroom: return 111;
			case Item::BrownMushroomBlock: return 209;
			case Item::BrownShulkerBox: return 393;
			case Item::BrownStainedGlass: return 341;
			case Item::BrownStainedGlassPane: return 357;
			case Item::BrownTerracotta: return 293;
			case Item::BrownWool: return 94;
			case Item::BubbleCoral: return 458;
			case Item::BubbleCoralBlock: return 453;
			case Item::BubbleCoralFan: return 468;
			case Item::Bucket: return 595;
			case Item::Cactus: return 178;
			case Item::Cake: return 653;
			case Item::Campfire: return 876;
			case Item::Carrot: return 762;
			case Item::CarrotOnAStick: return 774;
			case Item::CartographyTable: return 867;
			case Item::CarvedPumpkin: return 188;
			case Item::CatSpawnEgg: return 699;
			case Item::Cauldron: return 694;
			case Item::CaveSpiderSpawnEgg: return 700;
			case Item::ChainCommandBlock: return 373;
			case Item::ChainmailBoots: return 570;
			case Item::ChainmailChestplate: return 568;
			case Item::ChainmailHelmet: return 567;
			case Item::ChainmailLeggings: return 569;
			case Item::Charcoal: return 528;
			case Item::Chest: return 155;
			case Item::ChestMinecart: return 618;
			case Item::Chicken: return 679;
			case Item::ChickenSpawnEgg: return 701;
			case Item::ChippedAnvil: return 266;
			case Item::ChiseledQuartzBlock: return 275;
			case Item::ChiseledRedSandstone: return 369;
			case Item::ChiseledSandstone: return 69;
			case Item::ChiseledStoneBricks: return 208;
			case Item::ChorusFlower: return 149;
			case Item::ChorusFruit: return 818;
			case Item::ChorusPlant: return 148;
			case Item::Clay: return 179;
			case Item::ClayBall: return 610;
			case Item::Clock: return 623;
			case Item::Coal: return 527;
			case Item::CoalBlock: return 317;
			case Item::CoalOre: return 31;
			case Item::CoarseDirt: return 10;
			case Item::Cobblestone: return 12;
			case Item::CobblestoneSlab: return 126;
			case Item::CobblestoneStairs: return 163;
			case Item::CobblestoneWall: return 245;
			case Item::Cobweb: return 75;
			case Item::CocoaBeans: return 634;
			case Item::Cod: return 625;
			case Item::CodBucket: return 607;
			case Item::CodSpawnEgg: return 702;
			case Item::CommandBlock: return 243;
			case Item::CommandBlockMinecart: return 798;
			case Item::Comparator: return 514;
			case Item::Compass: return 621;
			case Item::Composter: return 517;
			case Item::Conduit: return 477;
			case Item::CookedBeef: return 678;
			case Item::CookedChicken: return 680;
			case Item::CookedCod: return 629;
			case Item::CookedMutton: return 800;
			case Item::CookedPorkchop: return 585;
			case Item::CookedRabbit: return 787;
			case Item::CookedSalmon: return 630;
			case Item::Cookie: return 670;
			case Item::Cornflower: return 108;
			case Item::CowSpawnEgg: return 703;
			case Item::CrackedStoneBricks: return 207;
			case Item::CraftingTable: return 158;
			case Item::CreeperBannerPattern: return 860;
			case Item::CreeperHead: return 772;
			case Item::CreeperSpawnEgg: return 704;
			case Item::Crossbow: return 856;
			case Item::CutRedSandstone: return 370;
			case Item::CutRedSandstoneSlab: return 132;
			case Item::CutSandstone: return 70;
			case Item::CutSandstoneSlab: return 124;
			case Item::CyanBanner: return 810;
			case Item::CyanBed: return 663;
			case Item::CyanCarpet: return 309;
			case Item::CyanConcrete: return 422;
			case Item::CyanConcretePowder: return 438;
			case Item::CyanDye: return 637;
			case Item::CyanGlazedTerracotta: return 406;
			case Item::CyanShulkerBox: return 390;
			case Item::CyanStainedGlass: return 338;
			case Item::CyanStainedGlassPane: return 354;
			case Item::CyanTerracotta: return 290;
			case Item::CyanWool: return 91;
			case Item::DamagedAnvil: return 267;
			case Item::Dandelion: return 98;
			case Item::DarkOakBoat: return 834;
			case Item::DarkOakButton: return 264;
			case Item::DarkOakDoor: return 512;
			case Item::DarkOakFence: return 186;
			case Item::DarkOakFenceGate: return 221;
			case Item::DarkOakLeaves: return 61;
			case Item::DarkOakLog: return 37;
			case Item::DarkOakPlanks: return 18;
			case Item::DarkOakPressurePlate: return 171;
			case Item::DarkOakSapling: return 24;
			case Item::DarkOakSign: return 594;
			case Item::DarkOakSlab: return 120;
			case Item::DarkOakStairs: return 320;
			case Item::DarkOakTrapdoor: return 198;
			case Item::DarkOakWood: return 55;
			case Item::DarkPrismarine: return 363;
			case Item::DarkPrismarineSlab: return 136;
			case Item::DarkPrismarineStairs: return 366;
			case Item::DaylightDetector: return 271;
			case Item::DeadBrainCoral: return 461;
			case Item::DeadBrainCoralBlock: return 447;
			case Item::DeadBrainCoralFan: return 472;
			case Item::DeadBubbleCoral: return 462;
			case Item::DeadBubbleCoralBlock: return 448;
			case Item::DeadBubbleCoralFan: return 473;
			case Item::DeadBush: return 78;
			case Item::DeadFireCoral: return 463;
			case Item::DeadFireCoralBlock: return 449;
			case Item::DeadFireCoralFan: return 474;
			case Item::DeadHornCoral: return 464;
			case Item::DeadHornCoralBlock: return 450;
			case Item::DeadHornCoralFan: return 475;
			case Item::DeadTubeCoral: return 465;
			case Item::DeadTubeCoralBlock: return 446;
			case Item::DeadTubeCoralFan: return 471;
			case Item::DebugStick: return 839;
			case Item::DetectorRail: return 73;
			case Item::Diamond: return 529;
			case Item::DiamondAxe: return 544;
			case Item::DiamondBlock: return 157;
			case Item::DiamondBoots: return 578;
			case Item::DiamondChestplate: return 576;
			case Item::DiamondHelmet: return 575;
			case Item::DiamondHoe: return 558;
			case Item::DiamondHorseArmor: return 794;
			case Item::DiamondLeggings: return 577;
			case Item::DiamondOre: return 156;
			case Item::DiamondPickaxe: return 543;
			case Item::DiamondShovel: return 542;
			case Item::DiamondSword: return 541;
			case Item::Diorite: return 4;
			case Item::DioriteSlab: return 504;
			case Item::DioriteStairs: return 491;
			case Item::DioriteWall: return 258;
			case Item::Dirt: return 9;
			case Item::Dispenser: return 67;
			case Item::DolphinSpawnEgg: return 705;
			case Item::DonkeySpawnEgg: return 706;
			case Item::DragonBreath: return 823;
			case Item::DragonEgg: return 233;
			case Item::DragonHead: return 773;
			case Item::DriedKelp: return 674;
			case Item::DriedKelpBlock: return 613;
			case Item::Dropper: return 280;
			case Item::DrownedSpawnEgg: return 707;
			case Item::Egg: return 620;
			case Item::ElderGuardianSpawnEgg: return 708;
			case Item::Elytra: return 829;
			case Item::Emerald: return 759;
			case Item::EmeraldBlock: return 239;
			case Item::EmeraldOre: return 236;
			case Item::EnchantedBook: return 779;
			case Item::EnchantedGoldenApple: return 588;
			case Item::EnchantingTable: return 229;
			case Item::EndCrystal: return 817;
			case Item::EndPortalFrame: return 230;
			case Item::EndRod: return 147;
			case Item::EndStone: return 231;
			case Item::EndStoneBrickSlab: return 497;
			case Item::EndStoneBrickStairs: return 483;
			case Item::EndStoneBrickWall: return 257;
			case Item::EndStoneBricks: return 232;
			case Item::EnderChest: return 237;
			case Item::EnderEye: return 695;
			case Item::EnderPearl: return 682;
			case Item::EndermanSpawnEgg: return 709;
			case Item::EndermiteSpawnEgg: return 710;
			case Item::EvokerSpawnEgg: return 711;
			case Item::ExperienceBottle: return 755;
			case Item::Farmland: return 159;
			case Item::Feather: return 553;
			case Item::FermentedSpiderEye: return 690;
			case Item::Fern: return 77;
			case Item::FilledMap: return 671;
			case Item::FireCharge: return 756;
			case Item::FireCoral: return 459;
			case Item::FireCoralBlock: return 454;
			case Item::FireCoralFan: return 469;
			case Item::FireworkRocket: return 777;
			case Item::FireworkStar: return 778;
			case Item::FishingRod: return 622;
			case Item::FletchingTable: return 868;
			case Item::Flint: return 583;
			case Item::FlintAndSteel: return 523;
			case Item::FlowerBannerPattern: return 859;
			case Item::FlowerPot: return 761;
			case Item::FoxSpawnEgg: return 712;
			case Item::Furnace: return 160;
			case Item::FurnaceMinecart: return 619;
			case Item::GhastSpawnEgg: return 713;
			case Item::GhastTear: return 684;
			case Item::Glass: return 64;
			case Item::GlassBottle: return 688;
			case Item::GlassPane: return 213;
			case Item::GlisteringMelonSlice: return 696;
			case Item::GlobeBannerPattern: return 863;
			case Item::Glowstone: return 191;
			case Item::GlowstoneDust: return 624;
			case Item::GoldBlock: return 113;
			case Item::GoldIngot: return 531;
			case Item::GoldNugget: return 685;
			case Item::GoldOre: return 29;
			case Item::GoldenApple: return 587;
			case Item::GoldenAxe: return 551;
			case Item::GoldenBoots: return 582;
			case Item::GoldenCarrot: return 767;
			case Item::GoldenChestplate: return 580;
			case Item::GoldenHelmet: return 579;
			case Item::GoldenHoe: return 559;
			case Item::GoldenHorseArmor: return 793;
			case Item::GoldenLeggings: return 581;
			case Item::GoldenPickaxe: return 550;
			case Item::GoldenShovel: return 549;
			case Item::GoldenSword: return 548;
			case Item::Granite: return 2;
			case Item::GraniteSlab: return 500;
			case Item::GraniteStairs: return 487;
			case Item::GraniteWall: return 251;
			case Item::Grass: return 76;
			case Item::GrassBlock: return 8;
			case Item::GrassPath: return 322;
			case Item::Gravel: return 28;
			case Item::GrayBanner: return 808;
			case Item::GrayBed: return 661;
			case Item::GrayCarpet: return 307;
			case Item::GrayConcrete: return 420;
			case Item::GrayConcretePowder: return 436;
			case Item::GrayDye: return 639;
			case Item::GrayGlazedTerracotta: return 404;
			case Item::GrayShulkerBox: return 388;
			case Item::GrayStainedGlass: return 336;
			case Item::GrayStainedGlassPane: return 352;
			case Item::GrayTerracotta: return 288;
			case Item::GrayWool: return 89;
			case Item::GreenBanner: return 814;
			case Item::GreenBed: return 667;
			case Item::GreenCarpet: return 313;
			case Item::GreenConcrete: return 426;
			case Item::GreenConcretePowder: return 442;
			case Item::GreenDye: return 633;
			case Item::GreenGlazedTerracotta: return 410;
			case Item::GreenShulkerBox: return 394;
			case Item::GreenStainedGlass: return 342;
			case Item::GreenStainedGlassPane: return 358;
			case Item::GreenTerracotta: return 294;
			case Item::GreenWool: return 95;
			case Item::Grindstone: return 869;
			case Item::GuardianSpawnEgg: return 714;
			case Item::Gunpowder: return 554;
			case Item::HayBale: return 299;
			case Item::HeartOfTheSea: return 855;
			case Item::HeavyWeightedPressurePlate: return 270;
			case Item::Hopper: return 274;
			case Item::HopperMinecart: return 783;
			case Item::HornCoral: return 460;
			case Item::HornCoralBlock: return 455;
			case Item::HornCoralFan: return 470;
			case Item::HorseSpawnEgg: return 715;
			case Item::HuskSpawnEgg: return 716;
			case Item::Ice: return 176;
			case Item::InfestedChiseledStoneBricks: return 204;
			case Item::InfestedCobblestone: return 200;
			case Item::InfestedCrackedStoneBricks: return 203;
			case Item::InfestedMossyStoneBricks: return 202;
			case Item::InfestedStone: return 199;
			case Item::InfestedStoneBricks: return 201;
			case Item::InkSac: return 631;
			case Item::IronAxe: return 522;
			case Item::IronBars: return 212;
			case Item::IronBlock: return 114;
			case Item::IronBoots: return 574;
			case Item::IronChestplate: return 572;
			case Item::IronDoor: return 506;
			case Item::IronHelmet: return 571;
			case Item::IronHoe: return 557;
			case Item::IronHorseArmor: return 792;
			case Item::IronIngot: return 530;
			case Item::IronLeggings: return 573;
			case Item::IronNugget: return 837;
			case Item::IronOre: return 30;
			case Item::IronPickaxe: return 521;
			case Item::IronShovel: return 520;
			case Item::IronSword: return 532;
			case Item::IronTrapdoor: return 298;
			case Item::ItemFrame: return 760;
			case Item::JackOLantern: return 192;
			case Item::Jigsaw: return 516;
			case Item::Jukebox: return 180;
			case Item::JungleBoat: return 832;
			case Item::JungleButton: return 262;
			case Item::JungleDoor: return 510;
			case Item::JungleFence: return 184;
			case Item::JungleFenceGate: return 219;
			case Item::JungleLeaves: return 59;
			case Item::JungleLog: return 35;
			case Item::JunglePlanks: return 16;
			case Item::JunglePressurePlate: return 169;
			case Item::JungleSapling: return 22;
			case Item::JungleSign: return 592;
			case Item::JungleSlab: return 118;
			case Item::JungleStairs: return 242;
			case Item::JungleTrapdoor: return 196;
			case Item::JungleWood: return 53;
			case Item::Kelp: return 612;
			case Item::KnowledgeBook: return 838;
			case Item::Ladder: return 161;
			case Item::Lantern: return 874;
			case Item::LapisBlock: return 66;
			case Item::LapisLazuli: return 635;
			case Item::LapisOre: return 65;
			case Item::LargeFern: return 328;
			case Item::LavaBucket: return 597;
			case Item::Lead: return 796;
			case Item::Leather: return 603;
			case Item::LeatherBoots: return 566;
			case Item::LeatherChestplate: return 564;
			case Item::LeatherHelmet: return 563;
			case Item::LeatherHorseArmor: return 795;
			case Item::LeatherLeggings: return 565;
			case Item::Lectern: return 870;
			case Item::Lever: return 164;
			case Item::LightBlueBanner: return 804;
			case Item::LightBlueBed: return 657;
			case Item::LightBlueCarpet: return 303;
			case Item::LightBlueConcrete: return 416;
			case Item::LightBlueConcretePowder: return 432;
			case Item::LightBlueDye: return 643;
			case Item::LightBlueGlazedTerracotta: return 400;
			case Item::LightBlueShulkerBox: return 384;
			case Item::LightBlueStainedGlass: return 332;
			case Item::LightBlueStainedGlassPane: return 348;
			case Item::LightBlueTerracotta: return 284;
			case Item::LightBlueWool: return 85;
			case Item::LightGrayBanner: return 809;
			case Item::LightGrayBed: return 662;
			case Item::LightGrayCarpet: return 308;
			case Item::LightGrayConcrete: return 421;
			case Item::LightGrayConcretePowder: return 437;
			case Item::LightGrayDye: return 638;
			case Item::LightGrayGlazedTerracotta: return 405;
			case Item::LightGrayShulkerBox: return 389;
			case Item::LightGrayStainedGlass: return 337;
			case Item::LightGrayStainedGlassPane: return 353;
			case Item::LightGrayTerracotta: return 289;
			case Item::LightGrayWool: return 90;
			case Item::LightWeightedPressurePlate: return 269;
			case Item::Lilac: return 324;
			case Item::LilyOfTheValley: return 109;
			case Item::LilyPad: return 225;
			case Item::LimeBanner: return 806;
			case Item::LimeBed: return 659;
			case Item::LimeCarpet: return 305;
			case Item::LimeConcrete: return 418;
			case Item::LimeConcretePowder: return 434;
			case Item::LimeDye: return 641;
			case Item::LimeGlazedTerracotta: return 402;
			case Item::LimeShulkerBox: return 386;
			case Item::LimeStainedGlass: return 334;
			case Item::LimeStainedGlassPane: return 350;
			case Item::LimeTerracotta: return 286;
			case Item::LimeWool: return 87;
			case Item::LingeringPotion: return 827;
			case Item::LlamaSpawnEgg: return 717;
			case Item::Loom: return 858;
			case Item::MagentaBanner: return 803;
			case Item::MagentaBed: return 656;
			case Item::MagentaCarpet: return 302;
			case Item::MagentaConcrete: return 415;
			case Item::MagentaConcretePowder: return 431;
			case Item::MagentaDye: return 644;
			case Item::MagentaGlazedTerracotta: return 399;
			case Item::MagentaShulkerBox: return 383;
			case Item::MagentaStainedGlass: return 331;
			case Item::MagentaStainedGlassPane: return 347;
			case Item::MagentaTerracotta: return 283;
			case Item::MagentaWool: return 84;
			case Item::MagmaBlock: return 374;
			case Item::MagmaCream: return 692;
			case Item::MagmaCubeSpawnEgg: return 718;
			case Item::Map: return 766;
			case Item::Melon: return 214;
			case Item::MelonSeeds: return 676;
			case Item::MelonSlice: return 673;
			case Item::MilkBucket: return 604;
			case Item::Minecart: return 598;
			case Item::MojangBannerPattern: return 862;
			case Item::MooshroomSpawnEgg: return 719;
			case Item::MossyCobblestone: return 144;
			case Item::MossyCobblestoneSlab: return 496;
			case Item::MossyCobblestoneStairs: return 482;
			case Item::MossyCobblestoneWall: return 246;
			case Item::MossyStoneBrickSlab: return 494;
			case Item::MossyStoneBrickStairs: return 480;
			case Item::MossyStoneBrickWall: return 250;
			case Item::MossyStoneBricks: return 206;
			case Item::MuleSpawnEgg: return 720;
			case Item::MushroomStem: return 211;
			case Item::MushroomStew: return 547;
			case Item::MusicDisc11: return 850;
			case Item::MusicDisc13: return 840;
			case Item::MusicDiscBlocks: return 842;
			case Item::MusicDiscCat: return 841;
			case Item::MusicDiscChirp: return 843;
			case Item::MusicDiscFar: return 844;
			case Item::MusicDiscMall: return 845;
			case Item::MusicDiscMellohi: return 846;
			case Item::MusicDiscStal: return 847;
			case Item::MusicDiscStrad: return 848;
			case Item::MusicDiscWait: return 851;
			case Item::MusicDiscWard: return 849;
			case Item::Mutton: return 799;
			case Item::Mycelium: return 224;
			case Item::NameTag: return 797;
			case Item::NautilusShell: return 854;
			case Item::NetherBrick: return 780;
			case Item::NetherBrickFence: return 227;
			case Item::NetherBrickSlab: return 129;
			case Item::NetherBrickStairs: return 228;
			case Item::NetherBrickWall: return 253;
			case Item::NetherBricks: return 226;
			case Item::NetherQuartzOre: return 273;
			case Item::NetherStar: return 775;
			case Item::NetherWart: return 686;
			case Item::NetherWartBlock: return 375;
			case Item::Netherrack: return 189;
			case Item::NoteBlock: return 71;
			case Item::OakBoat: return 602;
			case Item::OakButton: return 259;
			case Item::OakDoor: return 507;
			case Item::OakFence: return 181;
			case Item::OakFenceGate: return 216;
			case Item::OakLeaves: return 56;
			case Item::OakLog: return 32;
			case Item::OakPlanks: return 13;
			case Item::OakPressurePlate: return 166;
			case Item::OakSapling: return 19;
			case Item::OakSign: return 589;
			case Item::OakSlab: return 115;
			case Item::OakStairs: return 154;
			case Item::OakTrapdoor: return 193;
			case Item::OakWood: return 50;
			case Item::Observer: return 379;
			case Item::Obsidian: return 145;
			case Item::OcelotSpawnEgg: return 721;
			case Item::OrangeBanner: return 802;
			case Item::OrangeBed: return 655;
			case Item::OrangeCarpet: return 301;
			case Item::OrangeConcrete: return 414;
			case Item::OrangeConcretePowder: return 430;
			case Item::OrangeDye: return 645;
			case Item::OrangeGlazedTerracotta: return 398;
			case Item::OrangeShulkerBox: return 382;
			case Item::OrangeStainedGlass: return 330;
			case Item::OrangeStainedGlassPane: return 346;
			case Item::OrangeTerracotta: return 282;
			case Item::OrangeTulip: return 104;
			case Item::OrangeWool: return 83;
			case Item::OxeyeDaisy: return 107;
			case Item::PackedIce: return 318;
			case Item::Painting: return 586;
			case Item::PandaSpawnEgg: return 722;
			case Item::Paper: return 615;
			case Item::ParrotSpawnEgg: return 723;
			case Item::Peony: return 326;
			case Item::PetrifiedOakSlab: return 125;
			case Item::PhantomMembrane: return 853;
			case Item::PhantomSpawnEgg: return 724;
			case Item::PigSpawnEgg: return 725;
			case Item::PillagerSpawnEgg: return 726;
			case Item::PinkBanner: return 807;
			case Item::PinkBed: return 660;
			case Item::PinkCarpet: return 306;
			case Item::PinkConcrete: return 419;
			case Item::PinkConcretePowder: return 435;
			case Item::PinkDye: return 640;
			case Item::PinkGlazedTerracotta: return 403;
			case Item::PinkShulkerBox: return 387;
			case Item::PinkStainedGlass: return 335;
			case Item::PinkStainedGlassPane: return 351;
			case Item::PinkTerracotta: return 287;
			case Item::PinkTulip: return 106;
			case Item::PinkWool: return 88;
			case Item::Piston: return 81;
			case Item::PlayerHead: return 770;
			case Item::Podzol: return 11;
			case Item::PoisonousPotato: return 765;
			case Item::PolarBearSpawnEgg: return 727;
			case Item::PolishedAndesite: return 7;
			case Item::PolishedAndesiteSlab: return 503;
			case Item::PolishedAndesiteStairs: return 490;
			case Item::PolishedDiorite: return 5;
			case Item::PolishedDioriteSlab: return 495;
			case Item::PolishedDioriteStairs: return 481;
			case Item::PolishedGranite: return 3;
			case Item::PolishedGraniteSlab: return 492;
			case Item::PolishedGraniteStairs: return 478;
			case Item::PoppedChorusFruit: return 819;
			case Item::Poppy: return 99;
			case Item::Porkchop: return 584;
			case Item::Potato: return 763;
			case Item::Potion: return 687;
			case Item::PoweredRail: return 72;
			case Item::Prismarine: return 361;
			case Item::PrismarineBrickSlab: return 135;
			case Item::PrismarineBrickStairs: return 365;
			case Item::PrismarineBricks: return 362;
			case Item::PrismarineCrystals: return 785;
			case Item::PrismarineShard: return 784;
			case Item::PrismarineSlab: return 134;
			case Item::PrismarineStairs: return 364;
			case Item::PrismarineWall: return 248;
			case Item::Pufferfish: return 628;
			case Item::PufferfishBucket: return 605;
			case Item::PufferfishSpawnEgg: return 728;
			case Item::Pumpkin: return 187;
			case Item::PumpkinPie: return 776;
			case Item::PumpkinSeeds: return 675;
			case Item::PurpleBanner: return 811;
			case Item::PurpleBed: return 664;
			case Item::PurpleCarpet: return 310;
			case Item::PurpleConcrete: return 423;
			case Item::PurpleConcretePowder: return 439;
			case Item::PurpleDye: return 636;
			case Item::PurpleGlazedTerracotta: return 407;
			case Item::PurpleShulkerBox: return 391;
			case Item::PurpleStainedGlass: return 339;
			case Item::PurpleStainedGlassPane: return 355;
			case Item::PurpleTerracotta: return 291;
			case Item::PurpleWool: return 92;
			case Item::PurpurBlock: return 150;
			case Item::PurpurPillar: return 151;
			case Item::PurpurSlab: return 133;
			case Item::PurpurStairs: return 152;
			case Item::Quartz: return 781;
			case Item::QuartzBlock: return 276;
			case Item::QuartzPillar: return 277;
			case Item::QuartzSlab: return 130;
			case Item::QuartzStairs: return 278;
			case Item::Rabbit: return 786;
			case Item::RabbitFoot: return 789;
			case Item::RabbitHide: return 790;
			case Item::RabbitSpawnEgg: return 729;
			case Item::RabbitStew: return 788;
			case Item::Rail: return 162;
			case Item::RavagerSpawnEgg: return 730;
			case Item::RedBanner: return 815;
			case Item::RedBed: return 668;
			case Item::RedCarpet: return 314;
			case Item::RedConcrete: return 427;
			case Item::RedConcretePowder: return 443;
			case Item::RedDye: return 632;
			case Item::RedGlazedTerracotta: return 411;
			case Item::RedMushroom: return 112;
			case Item::RedMushroomBlock: return 210;
			case Item::RedNetherBrickSlab: return 502;
			case Item::RedNetherBrickStairs: return 489;
			case Item::RedNetherBrickWall: return 255;
			case Item::RedNetherBricks: return 376;
			case Item::RedSand: return 27;
			case Item::RedSandstone: return 368;
			case Item::RedSandstoneSlab: return 131;
			case Item::RedSandstoneStairs: return 371;
			case Item::RedSandstoneWall: return 249;
			case Item::RedShulkerBox: return 395;
			case Item::RedStainedGlass: return 343;
			case Item::RedStainedGlassPane: return 359;
			case Item::RedTerracotta: return 295;
			case Item::RedTulip: return 103;
			case Item::RedWool: return 96;
			case Item::Redstone: return 600;
			case Item::RedstoneBlock: return 272;
			case Item::RedstoneLamp: return 234;
			case Item::RedstoneOre: return 172;
			case Item::RedstoneTorch: return 173;
			case Item::Repeater: return 513;
			case Item::RepeatingCommandBlock: return 372;
			case Item::RoseBush: return 325;
			case Item::RottenFlesh: return 681;
			case Item::Saddle: return 599;
			case Item::Salmon: return 626;
			case Item::SalmonBucket: return 606;
			case Item::SalmonSpawnEgg: return 731;
			case Item::Sand: return 26;
			case Item::Sandstone: return 68;
			case Item::SandstoneSlab: return 123;
			case Item::SandstoneStairs: return 235;
			case Item::SandstoneWall: return 256;
			case Item::Scaffolding: return 505;
			case Item::Scute: return 519;
			case Item::SeaLantern: return 367;
			case Item::SeaPickle: return 80;
			case Item::Seagrass: return 79;
			case Item::Shears: return 672;
			case Item::SheepSpawnEgg: return 732;
			case Item::Shield: return 828;
			case Item::ShulkerBox: return 380;
			case Item::ShulkerShell: return 836;
			case Item::ShulkerSpawnEgg: return 733;
			case Item::SilverfishSpawnEgg: return 734;
			case Item::SkeletonHorseSpawnEgg: return 736;
			case Item::SkeletonSkull: return 768;
			case Item::SkeletonSpawnEgg: return 735;
			case Item::SkullBannerPattern: return 861;
			case Item::SlimeBall: return 617;
			case Item::SlimeBlock: return 321;
			case Item::SlimeSpawnEgg: return 737;
			case Item::SmithingTable: return 871;
			case Item::Smoker: return 865;
			case Item::SmoothQuartz: return 137;
			case Item::SmoothQuartzSlab: return 499;
			case Item::SmoothQuartzStairs: return 486;
			case Item::SmoothRedSandstone: return 138;
			case Item::SmoothRedSandstoneSlab: return 493;
			case Item::SmoothRedSandstoneStairs: return 479;
			case Item::SmoothSandstone: return 139;
			case Item::SmoothSandstoneSlab: return 498;
			case Item::SmoothSandstoneStairs: return 485;
			case Item::SmoothStone: return 140;
			case Item::SmoothStoneSlab: return 122;
			case Item::Snow: return 175;
			case Item::SnowBlock: return 177;
			case Item::Snowball: return 601;
			case Item::SoulSand: return 190;
			case Item::Spawner: return 153;
			case Item::SpectralArrow: return 825;
			case Item::SpiderEye: return 689;
			case Item::SpiderSpawnEgg: return 738;
			case Item::SplashPotion: return 824;
			case Item::Sponge: return 62;
			case Item::SpruceBoat: return 830;
			case Item::SpruceButton: return 260;
			case Item::SpruceDoor: return 508;
			case Item::SpruceFence: return 182;
			case Item::SpruceFenceGate: return 217;
			case Item::SpruceLeaves: return 57;
			case Item::SpruceLog: return 33;
			case Item::SprucePlanks: return 14;
			case Item::SprucePressurePlate: return 167;
			case Item::SpruceSapling: return 20;
			case Item::SpruceSign: return 590;
			case Item::SpruceSlab: return 116;
			case Item::SpruceStairs: return 240;
			case Item::SpruceTrapdoor: return 194;
			case Item::SpruceWood: return 51;
			case Item::SquidSpawnEgg: return 739;
			case Item::Stick: return 545;
			case Item::StickyPiston: return 74;
			case Item::Stone: return 1;
			case Item::StoneAxe: return 540;
			case Item::StoneBrickSlab: return 128;
			case Item::StoneBrickStairs: return 223;
			case Item::StoneBrickWall: return 252;
			case Item::StoneBricks: return 205;
			case Item::StoneButton: return 174;
			case Item::StoneHoe: return 556;
			case Item::StonePickaxe: return 539;
			case Item::StonePressurePlate: return 165;
			case Item::StoneShovel: return 538;
			case Item::StoneSlab: return 121;
			case Item::StoneStairs: return 484;
			case Item::StoneSword: return 537;
			case Item::Stonecutter: return 872;
			case Item::StraySpawnEgg: return 740;
			case Item::String: return 552;
			case Item::StrippedAcaciaLog: return 42;
			case Item::StrippedAcaciaWood: return 48;
			case Item::StrippedBirchLog: return 40;
			case Item::StrippedBirchWood: return 46;
			case Item::StrippedDarkOakLog: return 43;
			case Item::StrippedDarkOakWood: return 49;
			case Item::StrippedJungleLog: return 41;
			case Item::StrippedJungleWood: return 47;
			case Item::StrippedOakLog: return 38;
			case Item::StrippedOakWood: return 44;
			case Item::StrippedSpruceLog: return 39;
			case Item::StrippedSpruceWood: return 45;
			case Item::StructureBlock: return 515;
			case Item::StructureVoid: return 378;
			case Item::Sugar: return 652;
			case Item::SugarCane: return 611;
			case Item::Sunflower: return 323;
			case Item::SuspiciousStew: return 857;
			case Item::SweetBerries: return 875;
			case Item::TallGrass: return 327;
			case Item::Terracotta: return 316;
			case Item::TippedArrow: return 826;
			case Item::TNT: return 142;
			case Item::TNTMinecart: return 782;
			case Item::Torch: return 146;
			case Item::TotemOfUndying: return 835;
			case Item::TraderLlamaSpawnEgg: return 741;
			case Item::TrappedChest: return 268;
			case Item::Trident: return 852;
			case Item::TripwireHook: return 238;
			case Item::TropicalFish: return 627;
			case Item::TropicalFishBucket: return 608;
			case Item::TropicalFishSpawnEgg: return 742;
			case Item::TubeCoral: return 456;
			case Item::TubeCoralBlock: return 451;
			case Item::TubeCoralFan: return 466;
			case Item::TurtleEgg: return 445;
			case Item::TurtleHelmet: return 518;
			case Item::TurtleSpawnEgg: return 743;
			case Item::VexSpawnEgg: return 744;
			case Item::VillagerSpawnEgg: return 745;
			case Item::VindicatorSpawnEgg: return 746;
			case Item::Vine: return 215;
			case Item::WanderingTraderSpawnEgg: return 747;
			case Item::WaterBucket: return 596;
			case Item::WetSponge: return 63;
			case Item::Wheat: return 561;
			case Item::WheatSeeds: return 560;
			case Item::WhiteBanner: return 801;
			case Item::WhiteBed: return 654;
			case Item::WhiteCarpet: return 300;
			case Item::WhiteConcrete: return 413;
			case Item::WhiteConcretePowder: return 429;
			case Item::WhiteDye: return 650;
			case Item::WhiteGlazedTerracotta: return 397;
			case Item::WhiteShulkerBox: return 381;
			case Item::WhiteStainedGlass: return 329;
			case Item::WhiteStainedGlassPane: return 345;
			case Item::WhiteTerracotta: return 281;
			case Item::WhiteTulip: return 105;
			case Item::WhiteWool: return 82;
			case Item::WitchSpawnEgg: return 748;
			case Item::WitherRose: return 110;
			case Item::WitherSkeletonSkull: return 769;
			case Item::WitherSkeletonSpawnEgg: return 749;
			case Item::WolfSpawnEgg: return 750;
			case Item::WoodenAxe: return 536;
			case Item::WoodenHoe: return 555;
			case Item::WoodenPickaxe: return 535;
			case Item::WoodenShovel: return 534;
			case Item::WoodenSword: return 533;
			case Item::WritableBook: return 757;
			case Item::WrittenBook: return 758;
			case Item::YellowBanner: return 805;
			case Item::YellowBed: return 658;
			case Item::YellowCarpet: return 304;
			case Item::YellowConcrete: return 417;
			case Item::YellowConcretePowder: return 433;
			case Item::YellowDye: return 642;
			case Item::YellowGlazedTerracotta: return 401;
			case Item::YellowShulkerBox: return 385;
			case Item::YellowStainedGlass: return 333;
			case Item::YellowStainedGlassPane: return 349;
			case Item::YellowTerracotta: return 285;
			case Item::YellowWool: return 86;
			case Item::ZombieHead: return 771;
			case Item::ZombieHorseSpawnEgg: return 752;
			case Item::ZombiePigmanSpawnEgg: return 753;
			case Item::ZombieSpawnEgg: return 751;
			case Item::ZombieVillagerSpawnEgg: return 754;
			default: return 0;
		}
	}

	UInt32 From(const CustomStatistic ID)
	{
		switch (ID)
		{
			case CustomStatistic::AnimalsBred: return 30;
			case CustomStatistic::AviateOneCm: return 17;
			case CustomStatistic::BellRing: return 66;
			case CustomStatistic::BoatOneCm: return 14;
			case CustomStatistic::CleanArmor: return 38;
			case CustomStatistic::CleanBanner: return 39;
			case CustomStatistic::CleanShulkerBox: return 40;
			case CustomStatistic::ClimbOneCm: return 10;
			case CustomStatistic::CrouchOneCm: return 6;
			case CustomStatistic::DamageAbsorbed: return 26;
			case CustomStatistic::DamageBlockedByShield: return 25;
			case CustomStatistic::DamageDealt: return 21;
			case CustomStatistic::DamageDealtAbsorbed: return 22;
			case CustomStatistic::DamageDealtResisted: return 23;
			case CustomStatistic::DamageResisted: return 27;
	