Getting Started
===============

Hello! Thanks for wanting to work on this project :smile:, and I hope that this file will help you somewhat in getting all set up and running. I'll go through the basics of getting the project environment set up, the code organization and style, and general development practices. I'll also show you some good issues to start off working on to get yourself familiarised with the code.

Note that this document is about contributing code for Cuberite.

 - If you are looking for usage instructions, see the [User's Manual][1] instead.
 - If you would like to help but you are not a programmer, you can still help with testing! Please see the [TESTING.md][2] file.

Minecraft Basics
----------------

If you don't play Minecraft or don't have a great knowledge of the basic systems, you should get to know them. The [Minecraft Wiki][3] is quite useful for this task, although some youtubers are also fairly good at teaching the basics and just playing is quite good too. It is possible to contribute without knowing minecraft in detail though, or even owning a license.

I'd say that the important topics are:

 - Different types of blocks and how they act.
 - Mobs, what they do and how.
 - Redstone, pistons, and automation.
 - Farming.
 - Fighting, health and the hunger system.

Useful Resources
----------------

 - [Minecraft Wiki](https://minecraft.wiki/w/Minecraft_Wiki)
 - [Minecraft Protocol Wiki](http://wiki.vg/Main_Page)
 - [Lua API Documentation](https://api.cuberite.org/)
 - [Visual Studio Community Edition Download](https://www.visualstudio.com/downloads/)

Setting up a Dev Environment
============================

Requirements
------------

### Linux/BSD/Solaris/macOS

You'll need the basic C++ build tools:

 - gcc (or clang or another C compiler)
 - g++ (or clang++ or another C++ compiler)
 - make

You'll also need CMake to generate the makefile to build from.

### Windows

If you use Windows, your best bet is the Microsoft Visual Studio, available as a free download in the Community edition from Microsoft. You'll also need CMake to generate the project files.

Setting up the Repo
-------------------

Next, you'll need to set up the repo. You should make a fork and work on that, then create a Pull Request so that we can review and merge your code. After you've "earned" an honorable status, we'll give you write access to the repository, so that you can work on branches in the main repo here (still use PRs though, they're great tools for review and discussion).

Once you've cloned, you need to pull down the submodules:

    git submodule init
    git submodule update

After that they should come down automatically when you pull but it's not bad to refresh every once in a while.

Repo Arrangement
----------------

The Cuberite repo has recently been rearranged for better code separation and other things, but basically it's split into a few areas:

 - `src`  
   This holds all of the Cuberite source code, and is where most development takes place.  
   It's split into logical areas for blocks, the protocol handling and other things.
 - `lib`  
   This holds all the 3rd party libraries for Cuberite. You basically don't need to touch these, just make sure they are present (git submodules)
 - `Server`  
   This contains the default plugins and environment to actually run the server. This folder's contents are linked into the executable output folder for each build flavor. In the `Plugins` folder there are the default plugins. The config files are also stored here. Config files with `.example.ini` on the end are generated by the server or source control and should be left alone, instead you should copy them to a file without the `example` in the name which will be prioritised over the generated ones.

Code Style
----------

You should follow the code style guidelines in [CONTRIBUTING.md][4], as well as other C++ best practices.

Note that there is a script file, $/src/CheckBasicStyle.lua, that can check some common violations of the coding style. You should run this file to check your code regularly. This script is run during the integration builds and if it fails, the build will fail. Note that you need Lua installed in order to run this script. It is recommended to set this up as a pre-commit hook and doing so is covered in CONTRIBUTING.md.

How to Build
------------

### Linux/BSD/Solaris/macOS

Follow the instructions in [COMPILING.md][5]. You probably want to build in debug mode (when you're developing) for console alerts and debugging capability, even though it's much slower for everyday use.

Basically, the process is:

    cmake . -DCMAKE_BUILD_TYPE=DEBUG && make

### Windows

You need to first generate a solution file by executing CMake. At the top-level folder of the repository:
```
mkdir VS2017-x64
cd VS2017-x64
cmake -DBUILD_TOOLS=1 -DSELF_TEST=1 ..
```
Then just open the solution file in MSVC and build. Note that the first time after generating the solution, you will need to do extra setup in order to be able to fully debug in MSVC:

 - Set the startup project to Cuberite: right-click the Cuberite project in the Solution Explorer and choose "Set as Startup Project".
 - Set the debugging folder: right-click the Cuberite project in the Solution Explorer, choose "Properties". In the dialog, browse to "Configuration Properties" -> "Debugging" and set "Working Directory" to "../Server".

How to Run
----------

The server can be run (on *nix) by a simple `./Cuberite` in the `Server` directory. On first run it will generate the world and start a server on the default port (configurable in `settings.ini`) so you can connect in Minecraft via `localhost`.

Where to Get Started
--------------------

Issues that should be easy to get started with are tagged as [easy][6] in GitHub issues.

Other good places to get started are:

 - Cleaning up some of the compiler warnings. Check [our CI][7] for a list of them.
 - Writing some plugins: They are written in lua, with excellent API documentation available via [APIDump][8]. The [Core plugin][9] should also help quite a bit here.

Special Things
--------------
 - Make yourself familiar with the community. Visit the forums: https://forum.cuberite.org/
 - Ask questions as much as you like, we're here to help :smiley:

[1]: https://book.cuberite.org/
[2]: https://github.com/cuberite/cuberite/blob/master/TESTING.md
[3]: https://minecraft.wiki/w/Minecraft_Wiki
[4]: https://github.com/cuberite/cuberite/blob/master/CONTRIBUTING.md
[5]: https://github.com/cuberite/cuberite/blob/master/COMPILING.md
[6]: https://github.com/cuberite/cuberite/issues?q=is%3Aopen+is%3Aissue+label%3Aeffort%2Feasy
[7]: https://builds.cuberite.org/job/cuberite/job/master/lastSuccessfulBuild/console
[8]: https://api.cuberite.org/
[9]: https://github.com/cuberite/Core
