# Contribution Guidelines

This resource was made by the Rust community and wouldn't be possible without you! We appreciate and recognize [all contributors](https://github.com/ctjhoa/rust-learning/graphs/contributors).

In order to contribute to this repository you need to **fork** it, then you can create a pull request.

## Pull requests

- **To add, remove, or change things on the list:** Submit a pull request

To set this list apart from and complement the excellent [Rust docs](https://www.rust-lang.org/en-US/documentation.html), rust-learning is a specially curated list for high-quality resources.

- List items should be sorted *alphabetically*.
- Each item should be limited to one link.
- The link should have an author if known
- At least 3 items are needed to create a new category.
- Linters checks should be successful

Please contribute links to resources you have used or are familiar with. This will help ensure high-quality entries.

If you removed our PR template you can find it [here](https://github.com/ctjhoa/rust-learning/blob/master/.github/PULL_REQUEST_TEMPLATE.md).

## Maintainers

To make sure every PR is checked, we have [team maintainers](MAINTAINERS). Every PR should be reviewed by at least two maintainers before it can get merged if the team is not outnumbered.

The maintainers will review your PR and notify you and tag it in case any information is still missing.
You can also apply to become a maintainer by submitting a PR.

## Reporting issues

Please open an issue if you would like to discuss anything that could be improved or have suggestions for making the list a more valuable resource. We realize sometimes resources fall into abandonment or have broken links for extended periods of time, so if you see that, feel free to change its listing or let us know. We also realize that sometimes resources are just going through transitions. Removal changes will not be applied until they have been pending for a minimum of 1 week (7 days). This grace window benefits projects that may be going through a temporary transition but are otherwise worthy of being on the list.

Thank you for your suggestions!
