---
title: Crystal 1.13.0 is released!
version: 1.13.0
date: 2024-07-09
author: straight-shoota
---
We are announcing a new Crystal release with several new features and bug fixes.

Pre-built packages are available on [GitHub Releases](https://github.com/crystal-lang/crystal/releases/tag/1.13.0)
and our official distribution channels.
See [crystal-lang.org/install](https://crystal-lang.org/install/) for
installation instructions.

## Stats

This release includes [180 changes since 1.12.2](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.13.0)
by 25 contributors. We thank all the contributors for all the effort put into
improving the language! ❤️

## Advances in multi-threading support

As part of the [project to improve multi-threading support](/2024/02/09/84codes-manas-mt) with the help of [84codes],
this release includes several improvements and refactors related to concurrency and the event loop. So far, these have been mostly internal changes with minor relevance from a user's point of view. We expect more significant changes in the next release.

A preview of the upcoming execution context ([RFC](https://github.com/crystal-lang/rfcs/pull/2)) is available as a standalone shard: [`ysbaddaden/execution_context`](https://github.com/ysbaddaden/execution_context). It's available for testing by eager developers. This library is expected to be part of the compiler once we are certain it's ready.  We're still ironing it, so bugs are expected, and reports very much welcomed!

## Changes

Below we list the most remarkable changes in the language, compiler and stdlib.
For more details, visit the [full changelog](https://github.com/crystal-lang/crystal/releases/tag/1.13.0).

### Breaking

- Never raise `IndexError` in `#[]?(Range)` ([#14444](https://github.com/crystal-lang/crystal/pull/14444)).

  _Thanks [@HertzDevil]_

- Fixed `Set#to_a(&)` ([#14519](https://github.com/crystal-lang/crystal/pull/14519)).

  _Thanks [@meatball133]_

- Restore leading zero in exponent for `printf("%e")` and `printf("%g")` ([#14695](https://github.com/crystal-lang/crystal/issues/14682)). This fixes a regression introduced in Crystal 1.11.0.

  _Thanks [@straight-shoota]_

- Implicit execution of batch files (`.bat`, `.com`) in `Process.run` on Windows was disabled as a safety measure ([#14557](https://github.com/crystal-lang/crystal/pull/14557)).

  _Thanks [@straight-shoota]_

- The module `IO::Evented` was removed from the public API docs  ([#14749]). It is an internal implementation detail and was erroneously exposed in the docs.

  _Thanks [@straight-shoota]_

- The `CRYSTAL_LIBRARY_RPATH` compiler config and delay-load helper have been removed ([#14598](https://github.com/crystal-lang/crystal/pull/14598)). They were an only partially functional attempt for dynamic linking on Windows, now superseded by a more robust solution to actually [install DLLs via `@[Link]` annotation](https://github.com/crystal-lang/crystal/issues/13858).

  _Thanks [@HertzDevil]_

#### OpenSSL Default Configuration

The `OpenSSL` bindings previously included some explicit overrides for the default settings of the SSL library. This can be useful to improve the security level when working with older library versions. But it has the opposite effect with newer library versions and hinders the application of more restrictive default configurations.
We removed overrides for cipher suites ([#14655](https://github.com/crystal-lang/crystal/pull/14655)) and ECDH curve ([#14656](https://github.com/crystal-lang/crystal/pull/14656)). The TLS Server compatibility level recommendations from Mozilla are deprecated as well. They didn't even work correctly before ([#14657](https://github.com/crystal-lang/crystal/pull/14657)).
`OpenSSL` now uses the default configuration of the SSL library. Explicit overrides in user code are still possible of course.

_Thanks [@ysbaddaden]_

### Rescue module types

Exception matching in `rescue` now supports module types in the type restriction.

```crystal
module ErrorModule; end

class SomeError < Exception
  include ErrorModule
end

begin
  raise SomeError.new
rescue ex : ErrorModule
end
```

 This gives more flexibility for exception hierarchies allowing multiple ancestors instead of only a single super class. For example, you can have a common module for all exceptions of a specific part of a library, while they can still inherit from different external exception types.
 More details in [#14552](https://github.com/crystal-lang/crystal/pull/14552)

_Thanks [@Blacksmoke16]_

### Macros

- New methods in the macro language for AST nodes for macro-related nodes ([#14492](https://github.com/crystal-lang/crystal/pull/14492)) and `Select` ([#14600](https://github.com/crystal-lang/crystal/pull/14600))

  _Thanks [@HertzDevil]_
- New methods expose a type node's visibility: `TypeNode#private?`, `#public?` and `#visibility` ([#11696](https://github.com/crystal-lang/crystal/pull/11696))

  _Thanks [@Hadeweka]_
- New macro method `StringLiteral#to_utf16` ([#14676](https://github.com/crystal-lang/crystal/pull/14676))

  _Thanks [@ysbaddaden]_

### Runtime Tracing

The Crystal runtime has a new tracing feature for low level functionality. It currently covers garbage collector and scheduler activity ([#14659](https://github.com/crystal-lang/crystal/pull/14659)).
A program built with `-Dtracing` prints diagnostic info when enabled via environment variable `CRYSTAL_TRACE=all` (or `CRYSTAL_TRACE=gc`, `CRYSTAL_TRACE=sched`). Output goes to `STDERR` by default, but can be configured via `CRYSTAL_TRACE_FILE=tracing.log`.

```console
$ crystal build -Dtracing hello-world.cr
$ CRYSTAL_TRACE=sched ./hello-world
sched.spawn 70569399740240 thread=0x7f48d7dc9740:? fiber=0x7f48d7cd0f00:main fiber=0x7f48d7cd0dc0:Signal Loop
sched.enqueue 70569399831716 thread=0x7f48d7dc9740:? fiber=0x7f48d7cd0f00:main fiber=0x7f48d7cd0dc0:Signal Loop duration=163
Hello World
```

_Thanks [@ysbaddaden] and [84codes]_

### `WaitGroup`

A [`WaitGroup`](https://crystal-lang.org/api/1.13.0/WaitGroup.html) is a declarative counter of concurrent fibers. Each such fiber is expected to call `#done` when it has finished. Whenever the counter reaches zero the waiters are resumed.
This is a simpler and more efficient alternative to `Channel(Nil)`.
Read more in [#14167](https://github.com/crystal-lang/crystal/pull/14167).

```crystal
require "wait_group"

wg = WaitGroup.new

5.times do
  wg.add
  spawn do
    puts "waiting..."
    sleep rand.seconds
  ensure
    wg.done
  end
end

# suspend the current fiber until the 5 fibers are done
wg.wait
```

_Thanks [@ysbaddaden] and [84codes](https://www.84codes.com/)_

### Compiler

- New compiler flags `-Os` and `-Oz` to optimize binary size ([#14463](https://github.com/crystal-lang/crystal/pull/14463)).

  _Thanks [@ysbaddaden]_

- Basic compiler support for AVR architecture (Arduino) ([#14393](https://github.com/crystal-lang/crystal/pull/14393)).

  _Thanks [@ysbaddaden]_

- Do not strip the macOS target triple ([#14466](https://github.com/crystal-lang/crystal/pull/14466)).

  _Thanks [@hovsater]_

### Misc

- Add UUID v7 implementation ([#14732](https://github.com/crystal-lang/crystal/pull/14732))

  _Thanks [@jgaskins]_

- New method: `Array#insert_all` ([#14486](https://github.com/crystal-lang/crystal/pull/14486))

  _Thanks [@summer-alice]_

## Deprecations

- `File.readable?`, `.writable?`, `.executable?` are moved to `File::Info`. They are low-level methods and removing them from the prominent `File` namespace reduces potential for confusion. ([#14484](https://github.com/crystal-lang/crystal/pull/14484))

  _Thanks [@straight-shoota]_

---

> **THANKS:**
> We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/) and every other [sponsor](/sponsors).
> To maintain and increase the development pace, donations and sponsorships are
> essential. [OpenCollective](https://opencollective.com/crystal-lang) is
> available for that.
>
> Reach out to [crystal@manas.tech](mailto:crystal@manas.tech)
> if you’d like to become a direct sponsor or find other ways to support Crystal.
> We thank you in advance!

[@ysbaddaden]: https://github.com/ysbaddaden
[@jgaskins]: https://github.com/jgaskins
[@HertzDevil]: https://github.com/HertzDevil
[@straight-shoota]: https://github.com/straight-shoota
[@Blacksmoke16]: https://github.com/Blacksmoke16
[@hovsater]: https://github.com/hovsater
[@summer-alice]: https://github.com/summer-alice
[@meatball133]: https://github.com/meatball133
[@Hadeweka]: https://github.com/@Hadeweka
[84codes]: https://www.84codes.com/
