---
title: Crystal 1.10.0 is released!
version: 1.10.0
summary:
thumbnail: +
author: straight-shoota
comment_href: https://disqus.com/home/discussion/crystal-lang/crystal_1100_is_released/
---

We are delivering a new Crystal release with several bugfixes and improvements.

Pre-built packages are available on [GitHub Releases](https://github.com/crystal-lang/crystal/releases/tag/1.10.0)
and our official distribution channels.
See [crystal-lang.org/install](https://crystal-lang.org/install/) for
installation instructions.

## Stats

This release includes [82 changes since 1.9.2](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.10.0)
by 21 contributors. We thank all the contributors for all the effort put into
improving the language! ❤️

## Changes

Below we list the most remarkable changes in the language, compiler and stdlib.
For more details, visit the [changelog](https://github.com/crystal-lang/crystal/releases/tag/1.10.0).

This release does not bring any big impact changes, but smaller enhancements and
bug fixes, stabilizing the compiler and standard library.

### Unlimited block unpacking

The most notable language change is the introduction of unlimited block
unpacking ([#11597](https://github.com/crystal-lang/crystal/pull/11597)).

Block parameter unpacking can now be nested.

```crystal
ary = [
  {1, {2, {3, 4}}},
]

ary.each do |(w, (x, (y, z)))|
  w # => 1
  x # => 2
  y # => 3
  z # => 4
end
```

Splat parameters are also supported.

```crystal
ary = [
  [1, 2, 3, 4, 5],
]

ary.each do |(x, *y, z)|
  x # => 1
  y # => [2, 3, 4]
  z # => 5
end
```

### Breaking: `crystal spec` exits with failure when focused

If the spec suite has any examples with `focus: true`, the spec process will
always exit with a failure code. Even if all executed specs succeed.
This is to prevent CI success when a `focus: true` is accidentally commited. ([#13653](https://github.com/crystal-lang/crystal/pull/13653))

### Compiler tools: `dependencies` and `unreachable`

Two new compiler tools are available for analyzing the program source.

* [`crystal tool dependencies`](https://crystal-lang.org/reference/1.10/man/crystal#crystal-tool-dependencies)
  prints a tree of required source files. This can be useful for separating
  source trees or debugging issues with require order.

  For instance, if we have a file `two_features.cr` requiring `feature1.cr` and
  `feature2.cr`, and each of these in turn require `common.cr`:

  ```console
  $ crystal tool dependencies two_features.cr
  feature1.cr
    common.cr
  feature2.cr
  ```

* [`crystal tool unreachable`](https://crystal-lang.org/reference/1.10/man/crystal#crystal-tool-unreachable)
  prints methods that are defined but never called. This can help cleaning up
  unused code.

  For instance, if we have a file defing the following methods which are never
  called anywhere:

  ```crystal
  def top_not_used
  end

  class Foo
    def not_used
    end
  end
  ```

  ```console
  $ crystal tool unreachable source.cr
  source.cr:3:1 top-level top_not_used 2 lines
  source.cr:7:3 Foo#not_used 2 lines
  ```

### Deprecations

* `HTTP::StaticFileHandler.new` parameters `fallthrough` and `directory_listing`
   other type than `Bool`.
