---
title: Crystal 1.8.0 is released!
version: 1.8.0
summary:
thumbnail: +
author:
comment_href: https://disqus.com/home/discussion/crystal-lang/crystal_180_is_released_85/
---

We are delivering a new release with several bugfixes and improvements. Below we list the most important or interesting changes, without mentioning several bugfixes and smaller enhancements. For more details, visit the [changelog](https://github.com/crystal-lang/crystal/releases/tag/1.8.0). Breaking changes are marked with ⚠️.

Pre-built packages are available on [GitHub Releases](https://github.com/crystal-lang/crystal/releases/tag/1.8.0) and our official distribution channels.
See [crystal-lang.org/install](https://crystal-lang.org/install/) for installation instructions.

## Stats

This release includes [181 changes since 1.7.3](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.8.0) by 23 contributors. We thank all the contributors for all the effort put into improving the language! ❤️

Below we list the most remarkable changes in the language, compiler and stdlib.

## Regex: PCRE2

⚠️ A big and [necessary change](/2023/03/02/crystal-is-upgrading-its-regex-engine) in this release is that PCRE2 becomes the default engine for `Regex` ([#12978](https://github.com/crystal-lang/crystal/pull/12978)).
Support for PCRE2 was added in 1.7 and stabilized in 1.7.3. We feel it's safe to use it by default.
A fallback to PCRE is still possible, either automatically if PCRE2 is unavailable at compile time, or via the compiler flag `-Duse_pcre`.

> **NOTE:** Package maintainers
> From 1.8 onwards the Crystal compiler should be built with PCRE2 to ensure consistency.

⚠️ As a measure to ease migration to PCRE2, `Regex::Options` gained more named members which work in both engine versions. To accommodate the additional values, the enum base type changes from `Int32` to `UInt64` ([#13223](https://github.com/crystal-lang/crystal/pull/13223)).
⚠️ Additionally, a new enum `Regex::MatchOptions` was added to hold options specific to match operations and `Regex::Options` is now aliased as `Regex::CompileOptions` ([#13248](https://github.com/crystal-lang/crystal/pull/13248)). The `Regex::Options` overloads for match methods are deprecated.

## Regex: Invalid UTF

⚠️ Unrelated to the upgrade this release includes a bugfix that affects both engine versions.
Crystal's `String` class is intended to be valid UTF-8 but this is not enforced and it's perfectly accepted to contain invalid UTF-8.
When passing a string to PCRE or PCRE2 it's necessary to ensure its contents are valid.
This was not done before and subsequently the library could crash.
Now `Regex.new` and all match methods validate the strings and raise an exception if they contain invalid UTF-8.

If a string is known to be valid UTF-8, the options `Regex::CompileOptions::NO_CHECK_UTF`
and `Regex::MatchOptions::NO_CHECK_UTF` skip validation for increased performance.

The option `Regex::CompileOptions::MATCH_INVALID_UTF` can be used to explicitly match against subject strings with invalid UTF-8.
This feature is available in PCRE2 from version 10.34 onward, and a serious bug was fixed in 10.36. So it's not recommended to use an earlier version.

## Language

The only explicit language change is that namespaced `Path`s are allowed as type names for `lib` ([#12903](https://github.com/crystal-lang/crystal/pull/12903)).

```crystal
lib Foo::LibBar
end
```

As a consequence of upgrading the regex library, compilers starting with 1.8
perform syntax checks of regex literals with PCRE2. Hence the syntax of regex literals
changes from PCRE-compatible to PCRE2-compatible (which is pretty much the same for most use cases).
Read more in the [PCRE2 announcement post](/2023/03/02/crystal-is-upgrading-its-regex-engine/#validation-of-regex-literals).

## LLVM Updates

This release adds support for LLVM 15 ([#13173](https://github.com/crystal-lang/crystal/pull/13173) which includes
a migration to [LLVM's opaque pointers](https://crystal-lang.org/2023/03/23/llvm-opaque-pointers/). This has shown to offer a substantial improvement to compilation speed.

> **NOTE:** Package maintainers
> We recommend building Crystal with LLVM 15 for improved compile performance.

⚠️ On a related note, this release drops support for older LLVM versions. Crystal now requires LLVM 8 or higher ([#12906](https://github.com/crystal-lang/crystal/pull/12906)).

LLVM 16 support is in the works ([#13181](https://github.com/crystal-lang/crystal/pull/13181)).

## Platform support

This version comes with support for Android, and significant advances in Windows, all listed below.
The `x86_64-linux-musl` target moved up into *Tier 1*.

Additionally, we revamped the list of [supported platforms](https://crystal-lang.org/reference/1.8/syntax_and_semantics/platform_support.html)
to include more specific information about the current level of support.

### AArch64 Android

It is now possible to target Android with the Bionic C runtime (`aarch64-linux-android`). The details of how to get this working are in the relevant PR ([#13065](https://github.com/crystal-lang/crystal/pull/13065)).

### Windows

We're making progress on reaching full stdlib feature coverage for Windows.

This release includes a couple of improvements relating to symbolic links ([#13141](https://github.com/crystal-lang/crystal/pull/13141), [#13195](https://github.com/crystal-lang/crystal/pull/13195))
⚠️ An important change to align behaviour with POSIX platforms is that `File.delete` (instead of `Dir.delete`) removes *any* symlink, even when it points to a directory ([#13224](https://github.com/crystal-lang/crystal/pull/13224)).

OpenSSL now uses Windows' system root certificate store ([#13187](https://github.com/crystal-lang/crystal/pull/13187)).

⚠️ This release also adds a full stub for Windows signals ([#13131](https://github.com/crystal-lang/crystal/pull/13131)). More on that in the next section.

While Windows 7 has reached EOL, we understand that support is still necessary for some use cases. Therefore, we accepted a patch to lower the supported Windows version ([#11505](https://github.com/crystal-lang/crystal/pull/11505)).

## Signal

In Unix systems, inter-process communication such as terminating processes and responding to interrupts is based on signals and subsequently the `Signal` API in Crystal was used for this.
To support operating systems that use different mechanisms for that (such as Windows), it's necessary to have portable APIs which abstract the intention from the implementation.

* [`Process.on_interrupt`](https://crystal-lang.org/api/1.8/Process.html#on_interrupt%28%26handler%3A-%3E%29%3ANil-class-method) handles interrupts: `SIGINT` (Unix) and `Ctrl+C` or `Ctrl+Break` (Windows) ([#13034](https://github.com/crystal-lang/crystal/pull/13034)).
* [`Process#terminate`](https://crystal-lang.org/api/1.8/Process.html#terminate%28%2A%2Cgraceful%3ABool%3Dtrue%29%3ANil-instance-method) gained a `graceful` parameter. On Unix it selects between `SIGTERM` and `SIGKILL` while it has no effect on Windows and the behaviour is similar to `taskkill /f` regardless ([#13070](https://github.com/crystal-lang/crystal/pull/13070)).
* [`Process::Status#exit_reason`](https://crystal-lang.org/api/1.8/Process/Status.html#exit_reason%3AExitReason-instance-method) and [`Process::ExitReason`](https://crystal-lang.org/api/1.8/Process/ExitReason.html) provide information about a program's exit status in a portable way ([#13052](https://github.com/crystal-lang/crystal/pull/13052)).

## Stdlib

We fixed some function definitions for `LibC` that used the wrong types (e.g. `Int` instead of `SizeT`) in [#13242](https://github.com/crystal-lang/crystal/pull/13242) and [#13249](https://github.com/crystal-lang/crystal/pull/13249). This affects a bug with sending huge network packets on `*-linux-gnu` targets.

### HTTP

`HTTP::StaticFileHandler` now supports `Range` requests ([#12886](https://github.com/crystal-lang/crystal/pull/12886)).

### Spec

`spec` results are formatted with [`pretty_inspect`](https://crystal-lang.org/api/1.8.0/PrettyPrint.html) ([#11635](https://github.com/crystal-lang/crystal/pull/11635))
and the spec runner supports a `--color` option ([#12932](https://github.com/crystal-lang/crystal/pull/12932)).

### Enum

⚠️ `Enum#includes?` now requires all bits to be set ([#13229](https://github.com/crystal-lang/crystal/pull/13229)).

⚠️ `Enum.[]` is a new convenience constructor, especially useful for flag enums. It replaces `Enum.flags` which is now deprecated ([#12900](https://github.com/crystal-lang/crystal/pull/12900)).
`Enum#inspect` uses the concise syntax of `Enum.[]` ([#13004](https://github.com/crystal-lang/crystal/pull/13004)).

### Range

⚠️ `Range#size`, `#each`, `#sample` no longer error at compile time when a generic argument is `Nil`. For instance, `(..4).each { }` now raises at runtime instead of failing to compile ([#13278](https://github.com/crystal-lang/crystal/pull/13278)).

### Indexable

⚠️ This is just a documentation update, but it makes sense to mention it here. Implementations of `Indexable` are expected to be stable, i.e. do not change behaviour unless explicitly mutated ([#13061](https://github.com/crystal-lang/crystal/pull/13061)).

## Shards 0.17.3

This Crystal release comes with a new release of `shards`: [version 0.17.3](https://github.com/crystal-lang/shards/releases/tag/v0.17.3).
It brings two small improvements to show contextful error messages if a `git` command failed.
