---
title: Crystal 1.7.0 is released!
version: 1.7.0
summary:
thumbnail: +
author:
comment_href: https://disqus.com/home/discussion/crystal-lang/crystal_170_is_released/
---

We are starting the year with a new release with several bugfixes and improvements. Below we list the most important or interesting changes, without mentioning several bugfixes and smaller enhancements. For more details, visit the [changelog](https://github.com/crystal-lang/crystal/releases/tag/1.7.0). Breaking changes are marked with ⚠️.

Pre-built packages are available on [GitHub Releases](https://github.com/crystal-lang/crystal/releases/tag/1.7.0) and our official distribution channels.
See [crystal-lang.org/install](https://crystal-lang.org/install/) for installation instructions.

## Stats

In this release we included [152 changes since the 1.6.2 release](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.7.0) by 38 contributors. We thank all the effort put into improving the language! ❤️

Below we list the most remarkable changes in the language, compiler and stdlib.

# Interpreter REPL

The REPL interface of the interpreter has received a major usability improvement.
The command prompt now supports multiline input, command history, and several key bindings.

![asciicast](/assets/blog/2023-01-09-interpreter-repl-asciicast.gif)

This great feature set is provided by the shard [REPLy](https://github.com/I3oris/reply) ([#12738](https://github.com/crystal-lang/crystal/pull/12738)).

For technical reasons, the interpreter currently only ships by default in `brew`. For other platforms you need to compile it from the [sources](https://crystal-lang.org/install/from_sources/) with `interpreter=1` in the `make` options.

# `Regex` with PCRE2

Crystal relies on `libpcre` as engine for executing regular expressions in [`Regex`](https://crystal-lang.org/api/1.7.0/Regex.html).
In 1.7.0 we're adding support for its successor, `libpcre2`, but for now it's opt-in with the compiler flag `-Duse_pcre2`.

There are no major differences in usage and PCRE2 is mostly backwards compatible.
So we don't expect many issues. But we still encourage testing out the new
engine to see if something breaks.

PCRE2 is going to be enabled implicitly in one of the next releases, likely
becoming the default engine. PCRE will continue to serve as a fallback when the newer library is not available.
See [#12790](https://github.com/crystal-lang/crystal/issues/12790) for the tracking issue.

The regex engine is also used in the compiler for validating regex literals. Updating the compiler to PCRE2 might cause
some friction due to minor syntactical differences. Using different regex engines in the compiler and the compiled program
may lead to the compiler rejecting a regex literal for syntax errors, even if it's valid for the runtime engine.
Read more about the implications on the language syntax in [#12857](https://github.com/crystal-lang/crystal/issues/12857).

# Misc

## Language

* Lib functions are now visible in top-level macros ([#12848](https://github.com/crystal-lang/crystal/pull/12848)).
* Added [`ArrayLiteral#-(other)`](https://crystal-lang.org/api/1.7.0/Crystal/Macros/ArrayLiteral.html#-(other:ArrayLiteral):ArrayLiteral-instance-method) and [`TupleLiteral#-(other)`](https://crystal-lang.org/api/1.7.0/Crystal/Macros/TupleLiteral.html#-(other:TupleLiteral):TupleLiteral-instance-method) ([#12646](https://github.com/crystal-lang/crystal/pull/12646)).
* `annotation` supports the [`@[Deprecated]`](https://crystal-lang.org/api/1.7.0/Deprecated.html) annotation now ([#12557](https://github.com/crystal-lang/crystal/pull/12557)).
* Removed oct/bin floating point literals. This number syntax had been broken and isn't very useful anyway... ([#12687](https://github.com/crystal-lang/crystal/pull/12687)).

## Compiler


⚠️ Obsolete FreeBSD 11 compatibility was dropped ([#12612](https://github.com/crystal-lang/crystal/pull/12612)).

## stdlib

⚠️ [`File.real_path`](https://crystal-lang.org/api/1.7.0/File.html#real_path%28path%3APath%7CString%29%3AString-class-method) was renamed to [`File.realpath`](https://crystal-lang.org/api/1.7.0/File.html#realpath%28path%3APath%7CString%29%3AString-class-method). This spelling just makes more sense as it's used everywhere else. The old version is deprecated, but keeps working until the next major release ([#12552](https://github.com/crystal-lang/crystal/pull/12552)).

⚠️ Error handling for `libXML2` does no longer leak errors outside the current context. [`XML.errors`](https://crystal-lang.org/api/1.7.0/XML/Error.html#errors%3AArray(XML%3A%3AError)%3F-class-method) has been deprecated, but should continue to work. We highly recommend to access errors directly in the respective context via [`XML::Reader#errors`](https://crystal-lang.org/api/1.7.0/XML/Reader.html#errors%28Array%28XML%3A%3AError%29-instance-method) and [`XML::Node#errors`](https://crystal-lang.org/api/1.7.0/XML/Node.html#errors%3AArray%28XML%3A%3AError%29%7CNil-instance-method) ([#12663](https://github.com/crystal-lang/crystal/pull/12663), [#12795](https://github.com/crystal-lang/crystal/pull/12795)).

[`File#flock_shared`](https://crystal-lang.org/api/1.7.0/IO/FileDescriptor.html#flock_shared%28blocking%3Dtrue%29%3ANil-instance-method) and [`File#flock_exclusive`](https://crystal-lang.org/api/1.7.0/IO/FileDescriptor.html#flock_exclusive%28blocking%3Dtrue%29%3ANil-instance-method) are now fiber-aware and when they block, they're no longer blocking the thread ([#12861](https://github.com/crystal-lang/crystal/pull/12861)).
They're now also supported on Windows ([#12766](https://github.com/crystal-lang/crystal/pull/12766)).

[`BigDecimal#to_s`](https://crystal-lang.org/api/1.7.0/BigDecimal.html#to_s(io:IO):Nil-instance-method) supports scientific notation ([#10805](https://github.com/crystal-lang/crystal/pull/10805)).

```crystal
BigDecimal.new(Float32::MAX) # => 3.4028235e+38
```

Further additions:

* Automatically cast from `Int` to `Float` for [`JSON::Any#as_f`](https://crystal-lang.org/api/1.7.0/JSON/Any.html#as_f:Float64-instance-method) and [`YAML::Any#as_f`](https://crystal-lang.org/api/1.7.0/YAML/Any.html#as_f:Float64-instance-method) ([#12835](https://github.com/crystal-lang/crystal/pull/12835)).
* Several missing `#index!`/`#rindex!` methods on [`String`](https://crystal-lang.org/api/1.7.0/String.html) and [`Indexable`](https://crystal-lang.org/api/1.7.0/Indexable.html) ([#12730](https://github.com/crystal-lang/crystal/pull/12730), [#12759](https://github.com/crystal-lang/crystal/pull/12759)).
* Methods to manipulate [`SemanticVersion`](https://crystal-lang.org/api/1.7.0/SemanticVersion.html) ([#12834](https://github.com/crystal-lang/crystal/pull/12834)).
* [`HTTP::Server::Response#redirect`](https://crystal-lang.org/api/1.7.0/HTTP/Server/Response.html#redirect%28location%3AString%7CURI%2Cstatus%3AHTTP%3A%3AStatus%3D%3Afound%29-instance-method) ([#12526](https://github.com/crystal-lang/crystal/pull/12526)).

# Code quality

There were a couple of changes to improve code quality in the entire repository.
Most of them are based on suggestions by the static code analyzer tool [ameba](https://github.com/crystal-ameba/ameba).
Nothing is automated yet, so we can't ensure this for code additions. But that would one of the next steps.

A nice feature supported by many code highlighters is context-specific heredoc deliminators. We implemented that accross the code base in [#12816](https://github.com/crystal-lang/crystal/pull/12816).

<div class="language-crystal highlighter-rouge"><div class="highlight"><pre class="code_section"><code><span class="n">html_string</span> <span class="o">=</span> <span class="o">&lt;&lt;-</span><span class="no">HTML</span><span class="sh">
  <span class="nt">&lt;p&gt;</span>This uses HTML code highlighting!<span class="nt">&lt;/p&gt;</span>
</span><span class="no">  HTML</span>
</code></pre></div></div>

# Shards 0.17.2

This Crystal release comes with a new release of `shards`: [version 0.17.2](https://github.com/crystal-lang/shards/releases/tag/v0.17.2).
It brings two small improvements:

* Better error message when creating a symlink fails on Windows (with a recommendation to enable developer mode).
* A program executed with `shards run` now inherits stdin (as `crystal run` does).
