---
title: Crystal 1.6.0 is released!
version: 1.6.0
summary:
thumbnail: +
author:
comment_href: https://disqus.com/home/discussion/crystal-lang/crystal_160_is_released/
---

We are delivering a new release with several bugfixes and improvements. Below we list the most important or interesting changes, without mentioning several bugfixes and smaller enhancements. For more details, visit the [changelog](https://github.com/crystal-lang/crystal/releases/tag/1.6.0). Breaking changes are marked with ⚠️.

Pre-built packages are available on [GitHub Releases](https://github.com/crystal-lang/crystal/releases/tag/1.6.0) and our official distribution channels.
See [crystal-lang.org/install](https://crystal-lang.org/install/) for installation instructions.

## Stats

In this release we included [183 changes since the 1.5.1 release](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.6.0) by 26 contributors. We thank all the effort put into improving the language! ❤️

Below we list the most remarkable changes in the language and stdlib.

## ⚠️ Improvements in overload ordering

[Union types may now be considered before a wider variety of types](https://github.com/crystal-lang/crystal/pull/12335) when searching for a suitable overload. Consider the following code:

```crystal
module Foo(T)
end

class Bar1
  include Foo(Int32)
end

class Bar2
  include Foo(Int32)
end

def foo(x : Foo(Int32))
  'a'
end

def foo(x : Bar1 | Bar2)
  true
end

foo(Bar1.new)
```

Before 1.6.0 it would print `'a'`, meaning the generic case was considered first. Now it correctly prints `true`. If this affects your code, here is a quick guide to better understand and fix it:

* This happens whenever a parameter has a union type restriction in one overload, and the **same parameter** in another overload has a restriction that isn't a path (the name of a type) or an underscore (`_`).

* To preserve the old ordering, remove the union overload. Note that it was not being used.

* To ensure the new ordering applies to older releases, move the union overload above the generic one. (This is because previous Crystal versions consider the two overloads unordered.)

Several other [improvements](https://github.com/crystal-lang/crystal/pull/10711) where added to the overloading search algorithm, but only under a special flag `-Dpreview_overload_order`.

## ⚠️ Refactor in console methods

By making some console methods available in Windows, a significant [refactor](https://github.com/crystal-lang/crystal/pull/12352) lead to deprecating three macro methods in `FileDescriptor`: `cooked_from_tc_mode!`, `noecho_from_tc_mode!`, and `raw_from_tc_mode!`. Additionally, methods `#noecho!` and `#raw!` now return `nil`.

## ⚠️ Refactors in `File::Info`

[Another refactor](https://github.com/crystal-lang/crystal/pull/12385) lead to an improvement in the `File` API, which was breaking the abstraction by returning an object intended to be internal. In practice, if for some reason you ended up with an object of type `Crystal::System::FileInfo`, it should now be `File::Info`.

## Improvements in the interpreter

In this release [a number of interpreter bugs](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+sort%3Aupdated-desc+milestone%3A1.6.0+label%3Atopic%3Acompiler%3Ainterpreter) got fixed. We are still working towards incorporating it in the major platforms; in the meantime you can build the compiler with interpreter support locally with `make interpreter=1`, see the [interpreter introduction post for more info](https://crystal-lang.org/2021/12/29/crystal-i.html).

## Performance improvements

[Many performance improvements](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+sort%3Aupdated-desc+milestone%3A1.6.0+label%3Aperformance) in the compiler and the stdlib went into this release. We don't have a benchmark for you, but users reported non-negligible improvements in compilation speed and memory consumption.

## Improvements in the compiler for Windows

[Several improvements](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+sort%3Aupdated-desc+milestone%3A1.6.0+label%3Aplatform%3Awindows) landed in this release regarding Windows support, most notably [experimental support for building the interpreter](https://github.com/crystal-lang/crystal/pull/12397), and [`Mutex` support](https://github.com/crystal-lang/crystal/pull/12213).

## Other improvements

* `Dir.pwd` now respects `$PWD` ([ref](https://github.com/crystal-lang/crystal/pull/12471)).
* Support for Unicode 15.0 ([ref](https://github.com/crystal-lang/crystal/pull/12479)).
* Support for unicode normalization ([ref](https://github.com/crystal-lang/crystal/pull/11226)). Relevant information can be found in the [API docs](https://crystal-lang.org/api/1.6.0/String.html#unicode_normalize%28form%3AUnicode%3A%3ANormalizationForm%3D%3Anfc%29%3AString-instance-method).

> **THANKS:**
> We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/), [Nikola Motor Company](https://nikolamotor.com/) and every other [sponsor](/sponsors). To maintain and increase the development pace, donations and sponsorships are essential. [OpenCollective](https://opencollective.com/crystal-lang) is available for that.
>
> Reach out to [crystal@manas.tech](mailto:crystal@manas.tech) if you’d like to become a direct sponsor or find other ways to support Crystal. We thank you in advance!
