---
title: Crystal 1.4.1 is released!
version: 1.4.1
summary:
thumbnail: +
author:
---

We are releasing the first patch release of the [1.4](https://crystal-lang.org/2022/04/06/1.4.0-released.html) series.

Pre-built packages are available on [GitHub Releases](https://github.com/crystal-lang/crystal/releases/tag/1.4.1) and our official distribution channels.
See [crystal-lang.org/install](https://crystal-lang.org/install/) for installation instructions.

## Stats

In this patch release we included [5 PRs since the 1.4.0 release](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.4.1) by 4 contributors. We thank all the effort put into improving the language! ❤️

## Remarkable changes

Prior to 1.4.0, the following code will raise at runtime an illegal access error:

```crystal
module M
  @a = 'a'
end

class A
  @a = 'b'
end

class B < A
  include M

  @c = true
end
```

As a quick workaround, in 1.4.0 we disabled the possibility to define an instance variable in a class and an included module. The same code will then throw an error at compile time: `Error: instance variable '@a' of B is already defined in A`.

However, as it turned out, in some cases it was possible to define the same instance variable in a class and in an including module: if `B` above weren't defining its own instance variable (`@c`), then that code runs fine in Crystal 1.3.2. In [#11995](https://github.com/crystal-lang/crystal/pull/11995) this was fixed for good, and now instance variables having compatible types are allowed to be defined in a class and an including module.

For more details of this and other bug fixes included in this release, please visit the [changelog](https://github.com/crystal-lang/crystal/releases/tag/1.4.1).

> **THANKS:**
> We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/), [Nikola Motor Company](https://nikolamotor.com/) and every other [sponsor](/sponsors). To maintain and increase the development pace, donations and sponsorships are essential. [OpenCollective](https://opencollective.com/crystal-lang) is available for that.
>
> Reach out to [crystal@manas.tech](mailto:crystal@manas.tech) if you’d like to become a direct sponsor or find other ways to support Crystal. We thank you in advance!
