---
title: Crystal 1.2.0 is released!
version: 1.2.0
summary: Improving platform support
thumbnail: +
author: beta-ziliani
comment_href: https://disqus.com/home/discussion/crystal-lang/crystal_120_is_released_32/
---

We are delivering a new release with several bugfixes and improvements. Below we list the most important or interesting changes, without mentioning the several bugfixes. For details visit the [release's notes](https://github.com/crystal-lang/crystal/releases/tag/1.2.0). Breaking changes are marked with ⚠️.

## Stats

In this release we included [181 PRs since the 1.1.1 release](https://github.com/crystal-lang/crystal/pulls?q=is%3Apr+milestone%3A1.2.0) by 32 contributors. We thank all the effort put into improving the language and its stdlib! ❤️

## Platform support

As mentioned in the preparatory [blog post](https://crystal-lang.org/2021/09/30/preparing-1.2.html) for 1.2, we decided to lower the support for 32-bit x86 architecture. This is a direct consequence of focusing our efforts in more popular platforms: we do have some good news to share!

We are making progress in achieving full native Windows support, in this release including most notably a sockets implementation ([#11205](https://github.com/crystal-lang/crystal/pull/11205), [#11137](https://github.com/crystal-lang/crystal/pull/11137), [#10605](https://github.com/crystal-lang/crystal/pull/10784), [#10605](https://github.com/crystal-lang/crystal/pull/10605)).

Related to Windows, and also relevant for ARM64 architectures, we fixed an important [codegen bug](https://github.com/crystal-lang/crystal/pull/11189). We are now in conditions to promote aarch64 platforms to Tier 1, expecting to include packages for them soon. This is also relevant for macOS with the M1 chipset: starting from this release we include a [universal macOS package](https://github.com/crystal-lang/crystal/releases/download/1.2.0/crystal-1.2.0-1.universal.pkg) that works for x86 and M1 macs.

We discovered that two bugs appearing on [Windows](https://github.com/crystal-lang/crystal/issues/11047) and [M1's macs](https://github.com/crystal-lang/crystal/issues/11021) are coming from LLVM 11 and 12. We expect the fix will come with the recently released LLVM 13. Crystal 1.2.0 is compatible with [LLVM 12](https://github.com/crystal-lang/crystal/pull/10873), although we advice against using LLVM 11 and 12.

## Language changes

It is now possible to assign a subclass of a generic class to an element of [the parent class](https://github.com/crystal-lang/crystal/pull/11250):

```crystal
class A; end
class B(T) < A; end

x = A
x = B(String)
```

Also pertain to generic classes, there were situations in which the compiler was not properly substituting the generic argument ([#11166](https://github.com/crystal-lang/crystal/pull/11166), [#11067](https://github.com/crystal-lang/crystal/pull/11067).

The support for [ThinLTO](https://clang.llvm.org/docs/ThinLTO.html) compilation was [dropped](https://github.com/crystal-lang/crystal/pull/11194), since it wasn't working already since Crystal 0.25.

## Macros

It is possible to add an underscore in [for loops](https://github.com/crystal-lang/crystal/pull/11141) to ignore a value. For instance, in the following code the keys of the map are ignored:
```crystal
{% raw %}{% for _, v, i in {1 => 2, 3 => 4, 5 => 6} %}{% endraw %}
  p {% raw %}{{v + i}}{% endraw %}
{% raw %}{% end %}{% endraw %}
```

Additionally, there is a new [`file_exists?` macro method](https://crystal-lang.org/api/1.2.0/Crystal/Macros.html#file_exists?(filename):BoolLiteral-instance-method) to check the existence of a file ([#10540](https://github.com/crystal-lang/crystal/pull/10540)), and [`#is_a?`](https://crystal-lang.org/api/1.2.0/Crystal/Macros/ASTNode.html#is_a?(type:TypeNode):BoolLiteral-instance-method) now recognizes the AST node hierarchy ([#11062](https://github.com/crystal-lang/crystal/pull/11062)).

## Stdlib

⚠️ We are continuing the trend started in the 1.1.0 version to help get better error messages and documentation: several methods were annotated with expected types. Adding typing annotations might break existing code in specific scenarios so, if this happens to you, please let us now.

### Numeric

The major improvement in the numeric area is the steps taken to support 128 bits integers ([#11206](https://github.com/crystal-lang/crystal/pull/11206/) and [#11245](https://github.com/crystal-lang/crystal/pull/11245)).

As minor improvements, it is now possible to adjust the precision in the output of [Int#to_s](https://github.com/crystal-lang/crystal/pull/10926); to iterate the set of representable floats through new methods [`#next_float` and `#prev_float`](https://github.com/crystal-lang/crystal/pull/10908);
to use a negative exponential to a [BigDecimal](https://github.com/crystal-lang/crystal/pull/10892); and to calculate the [integer square root](https://github.com/crystal-lang/crystal/pull/10549) of a number.

### Collections

Mutable collections now include a [`Indexable::Mutable(T)` module](https://github.com/crystal-lang/crystal/pull/11059), which greatly expand the set of operations on certain collections such as `BitArray` and `Deque`. The following now works:

```crystal
ba = BitArray.new(10) # ba is BitArray[0000000000]
ba[0] = true          # ba is BitArray[1000000000]
ba.rotate!(-1)        # ba is BitArray[0100000000]
```

Additionally, `Indexable::Mutable(T)` was expanded to include stable and unstable sorting methods ([#11254](https://github.com/crystal-lang/crystal/pull/11254), [#11029](https://github.com/crystal-lang/crystal/pull/11029), [#10163](https://github.com/crystal-lang/crystal/pull/10163)). The default `sort` operation now calls a stable algorithm.

⚠️ As a breaking change, `Array#product` was deprecated in favor of the new generic and better named [`Indexable#cartesian_product`](https://github.com/crystal-lang/crystal/pull/10013).

Another two contributions worth of mention: enumerables are equipped with method to tally them with a given predicate ([Enumerable#tally_by](https://github.com/crystal-lang/crystal/pull/10922)); and the methods `Array#transpose`, `Enumerable#reject`, and `Enumerable#to_h` now work with [tuples](https://github.com/crystal-lang/crystal/pull/10445).

### Files

⚠️ The method `IO#write_utf8` was deprecated in favor of the more descriptive name [`IO#write_string`](https://github.com/crystal-lang/crystal/pull/11051), because you can use it to write strings in all kinds of encodings, depending on the IO's configuration.
We also fixed a number of bugs related to using `IO#write` instead of `IO#write_string` to append text to an IO.

### Networking

⚠️ In order to improve the security of the stdlib, `URI.encode` was [deprecated](https://github.com/crystal-lang/crystal/pull/11248) in favor of `URI.encode_path` and `URI.encode_path_segment` whith safer semantics and names better fitting to the purpose.

There is now support for basic authentication taken from an URI in websockets ([#10854](https://github.com/crystal-lang/crystal/pull/10854)), and
proper handling of max-age and expires for cookies ([#10564](https://github.com/crystal-lang/crystal/pull/10564)).

### Text

⚠️ `String#unsafe_byte_at` was [deprecated](https://github.com/crystal-lang/crystal/pull/10559) since `String` has already a `#to_unsafe` method.

Crystal now supports [Unicode 14.0.0](https://github.com/crystal-lang/crystal/pull/11215).

### Serialization

There is a new method [`XML::Node#namespace_definition`](https://github.com/crystal-lang/crystal/pull/11072) to obtain explicitly-defined XML namespaces of a node, and `URI`s can now be [serialized](https://github.com/crystal-lang/crystal/pull/10404) to JSON and YAML.

## Tools: new docs generator

The API docs now use [markd](https://github.com/icyleaf/markd/) to render Markdown ([#11040](https://github.com/crystal-lang/crystal/pull/11040)). This puts an end to the shortcomings caused by the internal renderer implementation.

## Infrastructure

It is now possible to [`make install`](https://github.com/crystal-lang/crystal/pull/10878) Crystal.

> **THANKS:**
> We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/), [Nikola Motor Company](https://nikolamotor.com/) and every other [sponsor](/sponsors). To maintain and increase the development pace, donations and sponsorships are essential. [OpenCollective](https://opencollective.com/crystal-lang) is available for that.
>
> Reach out to [crystal@manas.tech](mailto:crystal@manas.tech) if you’d like to become a direct sponsor or find other ways to support Crystal. We thank you in advance!
