---
title: Crystal 0.36.1 released!
version: 0.36.1
summary: Crystal has a new development release.
thumbnail: +
author: bcardiff
comment_href: https://disqus.com/home/discussion/crystal-lang/crystal_0361_released/
---


[Crystal 0.36.1](https://github.com/crystal-lang/crystal/releases/tag/0.36.1) has been released!

This release comes with all the goodies of 0.36.0 together with some fixes and changes that improve compile-time and runtime performance. So, don’t miss the [0.36.0 release announcement](/2021/01/26/crystal-0.36.0-released/).

Note that this release will be available in [the new apt and rpm repositories post](/2020/08/24/announcing-new-apt-and-rpm-repositories/), as well as GitHub release artifacts. You might need to update your package repositories.

This patch release is needed to iterate on some recent additions and fix a couple of regressions. We are thankful for all the early adopters that helped to identify unwanted regressions and performance issues in 0.36.0.

There were [14 commits since 0.36.0](https://github.com/crystal-lang/crystal/compare/0.36.0...0.36.1) by 5 contributors.

Let’s get right into some highlights in this release. Don't miss out on the rest of the [release changelog](https://github.com/crystal-lang/crystal/releases/tag/0.36.1).

## Standard library

We reverted the changes introduced in [#9871](https://github.com/crystal-lang/crystal/pull/9871). Now `Hash#dup` and `Hash#clone` will always return `Hash`. Even if you are calling them on a subclass of `Hash`. We don’t encourage inheriting `Hash`, and with 0.36.0 we notice that some subclasses in the wild were not dup-clone-friendly. Read more at [#10331](https://github.com/crystal-lang/crystal/pull/10331).

### Runtime

The eager load of DWARF information was too slow on some use cases. Therefore, we changed it to be opt-in rather than opt-out (See [#10326](https://github.com/crystal-lang/crystal/pull/10326)). Depending on the `CRYSTAL_LOAD_DWARF` environment variable the DWARF information will be loaded on startup (leading to better backtraces on some crashes), or it will be loaded only on demand when building backtraces, or it will not be loaded at all.

- `CRYSTAL_LOAD_DWARF=0` will never use dwarf information
- `CRYSTAL_LOAD_DWARF=1` will load dwarf on startup
- Other values or unset will load dwarf on demand

## Compiler

Codegen bugs can sometimes go unnoticed, LLVM 11 helped us find one. There were some invalid pointer operations that were fixed in [#10333](https://github.com/crystal-lang/crystal/pull/10333). With this change Crystal is now compatible with LLVM 11. This in turn helps Apple Silicon M1 support (See [#10348](https://github.com/crystal-lang/crystal/pull/10348)).

Constants initialization has been tweaked again to avoid generating code that was a bit too hard to optimize in [#10334](https://github.com/crystal-lang/crystal/pull/10334).

We allow macros named as operators or setters-like. Read more at [#10338](https://github.com/crystal-lang/crystal/pull/10338).

## Next steps

Please update your Crystal and report any issues. We will keep moving forward and focusing on releasing 1.0.0-pre1 which should be a more stabilized version of 0.36 without many new additions.

> **THANKS:**
> We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/), [Nikola Motor Company](https://nikolamotor.com/) and every other [sponsor](/sponsors). It is extremely important for us to sustain the support through donations, so that we can maintain this development pace. [OpenCollective](https://opencollective.com/crystal-lang) is available for that.
>
> Reach out to [crystal@manas.tech](mailto:crystal@manas.tech) if you’d like to become a direct sponsor or find other ways to support Crystal. We thank you in advance!
