---
title: Crystal 0.31.1 released!
version: 0.31.1
summary: Crystal has a new development release.
thumbnail: +
author: bcardiff
---

[Crystal 0.31.1](https://github.com/crystal-lang/crystal/releases/tag/0.31.1) has been released!

This release comes after a week of stabilizing the 0.31.0 with feedback from the community mainly. There were fixes, workaround, and improvements that should unlock migrating to 0.31 in some contexts.

There are [9 commits since 0.31.0](https://github.com/crystal-lang/crystal/compare/0.31.0...0.31.1) by 4 contributors.

Let’s review some highlights in this release. But don't miss the rest of the [release changelog](https://github.com/crystal-lang/crystal/releases/tag/0.31.0).

The main updates for 0.31 can be found in the [release post of 0.31.0](/2019/09/23/crystal-0.31.0-released/).

## Compiler

The `var = uninitialized T` expression is now typed in a way that allows subtypes of `T` to be stored in `var`. This bug was preventing the usage of `Channel` with subtypes as reported in [#8261](https://github.com/crystal-lang/crystal/issues/8216) and fixed in [#8221](https://github.com/crystal-lang/crystal/pull/8221).

## Standard library

### Multithreading

The patch that gives bdw-gc support to green threads was updated. We were using our initial proposal from [ivmai/bdwgc#277](https://github.com/ivmai/bdwgc/pull/277) but we updated it to its final state [ivmai/bdwgc:5668de](https://github.com/ivmai/bdwgc/commit/5668de71107022a316ee967162bc16c10754b9ce). This was needed to allow some distros to use the upcoming features of bdw-gc. And is also a preparation step for the next release of the GC. Read more at [#8225](https://github.com/crystal-lang/crystal/pull/8225).

## Spec

Define blocks to be run before and after the whole suite with `Spec.before_suite` `Spec.after_suite`. You can declare as many as you want. Read more at [#8238](https://github.com/crystal-lang/crystal/pull/8238).

## Next steps

Please update your Crystal and report any issues. We will keep moving forward and start the development focusing on 0.32.

It will also be helpful if your shards are run against Crystal nightly releases. Either Docker or Snap are the current channels to get them easily. This will help reduce the friction of a release while checking if the ecosystem is in good shape.

> **THANKS:**
> We have been able to do all of this thanks to the continued support of [84codes](https://www.84codes.com/), and every other [sponsor](/sponsors). It is extremely important for us to sustain the support through donations, so that we can maintain this development pace. [OpenCollective](https://opencollective.com/crystal-lang) and ~~[Bountysource](https://salt.bountysource.com/teams/crystal-lang)~~ are two available channels for that.
>
> Reach out to [crystal@manas.tech](mailto:crystal@manas.tech) if you’d like to become a direct sponsor or find other ways to support Crystal. We thank you in advance!
