---
title: Crystal 0.30.1 released!
version: 0.30.1
summary: Crystal has a new development release.
thumbnail: +
author: bcardiff
---

[Crystal 0.30.1](https://github.com/crystal-lang/crystal/releases/tag/0.30.1) has been released!

This release comes with some regression fixes and support for recent version of dependencies that were causing some headaches. No new features were added.

There are [12 commits since 0.30.0](https://github.com/crystal-lang/crystal/compare/0.30.0...0.30.1) by 6 contributors.

Let’s review some highlights in this release. But don't miss the rest of the [release changelog](https://github.com/crystal-lang/crystal/releases/tag/0.30.1).

## Compiler

### LLVM

For Crystal 0.30.0 we tried to upgrade to LLVM 6.0.1 for our official darwin packages. Those packages use a custom build of LLVM. On those builds we include assertions via `LLVM_ENABLE_ASSERTIONS=ON`, as a way to double-check we are using LLVM properly.

In this case, instead of finding a wrong use of LLVM, we found a bug/unhandled case in LLVM.  After [we reported it](https://bugs.llvm.org/show_bug.cgi?id=42932) a fix was proposed but either way we needed to take some actions before that fix landed.

A repackaging of 0.30.0-2 for darwin was done using LLVM 3.9.1. A workaround to avoid the LLVM bug was done in [#8063](https://github.com/crystal-lang/crystal/pull/8063).

The 0.30.1 darwin package is using LLVM 6.0.1.

There are other outstanding issues regarding debug metadata in release mode that have been unsolved for a long time, but since almost nobody runs LLVM with assertions, those are unnoticed. Assertions are good sometimes (take 1).

### Abstract method check

The abstract method check introduced in 0.30.0 got some improvements to consider the methods defined across the whole hierarchy of types. Read more at [#8035](https://github.com/crystal-lang/crystal/pull/8035).

## Standard library

### Concurrency

libevent 2.1.11 was released shortly after Crystal 0.30.0. There is a new constraint enforced by it that got in conflict with how fibers were resumed by our runtime. Read more at [#8058](https://github.com/crystal-lang/crystal/pull/8058). Bonus point: it seems that we have a slight performance improvement with that change. Assertions are good sometimes (take 2).

### Networking

One of the [recent optimizations](https://github.com/crystal-lang/crystal/pull/8002) caused headers to arrive with an unexpected case for some use-cases. This was fixed in [#8061](https://github.com/crystal-lang/crystal/pull/8061).

Meanwhile, a socket leaking after failed SSL connect was fixed in [#8025](https://github.com/crystal-lang/crystal/pull/8025).

## Next steps

Please update your Crystal and report any issues. We will keep moving forward regarding 0.31.

Once again, check your code with `--warnings=all`. This will help in the migration of your codebase and will probably push some feedback about that tool.

Stay tuned!
