---
title: Crystal 0.26.1 released!
version: 0.26.1
summary: Crystal has a new development release.
thumbnail: +
author: bcardiff
---

[Crystal 0.26.1](https://github.com/crystal-lang/crystal/releases/tag/0.26.1) has been released!

This release is mainly focused on regression bugs discovered on 0.26.0. There were [39 commits since 0.26.0](https://github.com/crystal-lang/crystal/compare/0.26.0...0.26.1) by 15 contributors.

Although we try to test as much as possible before each release. During 0.26.0 it was more difficult than usual because of some limitation to override nested dependencies. Luckily for this release dependencies are already updated and at the same time there was bit of work in `test-ecosystem` to improve what is covered.

Let’s review some of the most relevant changes in this release. But don't miss the rest of the [release changelog](https://github.com/crystal-lang/crystal/releases/tag/0.26.1) with lots of valuable information.

# Language changes

##  Make `self` to be eager evaluated when including modules.

When referencing the current type as `self`, for example when including a module, `self` will now means the current lexical type. Before, and sine 0.22, the `self` was resolved to the lowest type in the hierarchy.

Thanks to some other fixes included in 0.26.0, and the amount of metaprogramming in [lucky_record](https://github.com/luckyframework/lucky_record) we noticed that the change introduced in 0.22 broke the [substitution principle](https://en.wikipedia.org/wiki/Liskov_substitution_principle). Luckily now it is fixed!

To understand this change let’s suppose we have a the following type hierarchy: `Human < Mammal`, `Cat < Mammal`. And we have a `TalkTo` module defined as follows:

```crystal
module TalkTo(T)
  def talk_to(t : T)
    puts "#{self} is talking to #{t}"
  end
end
```

If we want to make all mammals be able to talk to each other then the following snippet will do:

```crystal
abstract class Mammal
  include TalkTo(self)
end

class Human < Mammal
end

class Cat < Mammal
end

sabrina = Human.new
salem = Cat.new
hilda = Human.new
```

Any instance instance of mammal will have a `#talk_to(t : Mammal)` method. Hence `sabrina.talk_to(salem)` would compile.

But if we need a less magical world we would need to `include TalkTo(self)` in each of the classes that inherit Mammal. In order to add some programmer’s happiness, if we want to state that each concrete class should have a method `talk_to` accepting only instance of the same class, then we need some metaprogramming.

```crystal
abstract class Mammal
  macro inherited
    include TalkTo({% raw %}{{@type}}{% endraw %})
  end
end
```

With the last snippet `sabrina.talk_to(salem)` would not compile. But `sabrina.talk_to(hilda)` would.

Before this release the `include TalkTo(self)` was the same as `macro inherited; include TalkTo({% raw %}{{@type}}{% endraw %}); end`. Read more at [#6557](https://github.com/crystal-lang/crystal/pull/6557).

## Add `accepts_block?` macro method to Def.

In macros you can iterate the methods defined in a type with `@type.methods`. Sometimes you might need to know if the method can be called with a block in order to get the job done. From this release, inside macros, you can use `#accepts_block?` to know that information. Read more at [#6604](https://github.com/crystal-lang/crystal/pull/6604)

# HTTP and Networking related changes

With the recent changes in the `HTTP::Server` there was a security issue introduced that allows servers with self-signed certificates to crash if the client send wrong certificate information. Now the code is more resilient to issues related to establish the connection between peers. Read more at [#6590](https://github.com/crystal-lang/crystal/pull/6590).

In `0.26.0` a method `#bind_ssl` and calls `#bind` with a `ssl://` scheme were added. This should have been `#bind_tls` and `tls://`. So in this release the `ssl` are marked as deprecated and `tls` were added. Web frameworks should not need updates regarding this changes until 0.27. Read more at [#6533](https://github.com/crystal-lang/crystal/pull/6533) and [#6551](https://github.com/crystal-lang/crystal/pull/6551).

# Windows support progress

The spec framework of the std lib can now be used in Windows. Read more at [#6497](https://github.com/crystal-lang/crystal/pull/6497). In case you want to read even more about the ongoing efforts related to Windows, please read [the wiki](https://github.com/crystal-lang/crystal/wiki/Porting-to-Windows).

# Other changes

There was some improvements regarding how `STDIN`/`STDOUT`/`STDERR` are handled. The introduced changes should avoid breaking other programs that uses them at the same time. For example, when using pipe operator in bash. Read more at [#6518](https://github.com/crystal-lang/crystal/pull/6518).

Applying transformations in keys and values of a hash became even easier with `Hash#transform_keys` and `Hash#transform_values`. Read more at [#4385](https://github.com/crystal-lang/crystal/pull/4385).

# Next step

Please update your Crystal and report any issues. If there are regression or blocking issues with 0.26.1, a 0.26.2 could be released earlier. But most likely we will be moving forward with 0.27.0 as next release.

> **THANKS:**
> The development is possible thanks to the community's effort, [84codes](https://www.84codes.com/)' support, and every [BountySource supporter](https://crystal-lang.org/sponsors).
