---
title: Crystal 0.26.0 released!
version: 0.26.0
summary: Crystal has a new development release.
thumbnail: +
author: bcardiff
---

[Crystal 0.26.0](https://github.com/crystal-lang/crystal/releases/tag/0.26.0) has been released!

This release is focused on polishing APIs, bug fixing the compiler, keep working on windows support and some intermediate language changes for future releases. There were [119 commits since 0.25.1](https://github.com/crystal-lang/crystal/compare/0.25.1...0.26.0) by 24 contributors.

# Language changes

## Revert: Do not collapse unions for sibling types

In [0.25.0](/2018/06/15/crystal-0.25.0-released/#do-not-collapse-unions-for-sibling-types) we tried to improve the inferred type of unions of sibling types. Although it worked well for the compiler itself, some codebases out there exhibited some combinatorial explosion of unions due to this change. In 0.26.0, the change introduced in 0.25.0 is reverted. Read more at [#6351](https://github.com/crystal-lang/crystal/pull/6351).

## Restrict instance variables initializer

When declaring instance variables it is sometimes handy to define an initial value:

```ruby
class Counter
  @value = 0
end
```

When the expression is a constant or it does not depend on other instance variables the semantic is clear. Before 0.26.0, instance variables were allowed, but there were some corner issues regarding typing, semantics, and dependencies. So, from 0.26.0 instance variables are not allowed in the expression that determines the initial values of them. Class variables are still allowed. Inside `initialize` you are still allowed to assign instance variables between each other.

To illustrate why the semantics are not clear, there are rules that could allow the following code to evaluate to: 1, 2 or 3.

```ruby
class Foo
  @bar = 0
  @baz = @bar + 1

  def initialize(@bar = 1)
    @bar = 2
  end

  def baz
    @baz
  end
end

Foo.new.baz # => ???
```

Read more at [#6414](https://github.com/crystal-lang/crystal/pull/6414).

## Wrapping and integer division operators

There are a new bunch of operators arriving in this version but, since crystal is written in crystal, in this version the only thing that is added are the parsing rules. In future versions semantics will be given, and later breaking changes will be introduced.

All this process is to allow, in a couple of versions, integer overflowing exceptions in arithmetics operations and integer division operators. This will empower safer and cleaner code.

Read more at [#6329](https://github.com/crystal-lang/crystal/pull/6329) and [#6470](https://github.com/crystal-lang/crystal/pull/6470).

# HTTP and Networking related changes

There is a performance regression fixed in this release related to `IO` by [#6304](https://github.com/crystal-lang/crystal/pull/6304). Now, when buffered `IO` is used, the user can control independently if writes and reads are buffered or not.

You will find some great changes in `HTTP::Server` API for binding to different address.

A more fine grained method to support ssl is introduced in [#5960](https://github.com/crystal-lang/crystal/pull/5960). SSL can be toggled per binding instead of per server. So `HTTP::Server#tls` was dropped in favor of `HTTP::Server#bind_ssl`.

Another handy change introduced in [#6500](https://github.com/crystal-lang/crystal/pull/6500) is the addition of  `HTTP::Server#bind(URI|String)` that infers protocol from scheme of the uri. This means that creating a server that in uses different kind of bindings is a piece of cake.

```ruby
require "http/server"

server = HTTP::Server.new do |context|
  ...
end

server.bind "tcp://127.0.0.1:80"
server.bind "unix:///tmp/server.sock"
server.bind "ssl://127.0.0.1:443?key=private.key&cert=certificate.cert&ca=ca.crt"
server.listen
```

# Windows support progress

The compiler and the stdlib is moving forward to support Windows.

Some of the cornerstones of the stdlib were ported:

* Accessing environment information was added in [#6333](https://github.com/crystal-lang/crystal/pull/6333) and [#6499](https://github.com/crystal-lang/crystal/pull/6499).
* `File` and `Dir` support has landed with [#5623](https://github.com/crystal-lang/crystal/pull/5623).
* And supporting UTF-16 string messages in errors implemented in [#6442](https://github.com/crystal-lang/crystal/pull/6442)

But definitely one of the most exciting additions in this version is the support of Windows structured exception handling (SEH). This was added in [#6419](https://github.com/crystal-lang/crystal/pull/6419) and collected work from many contributors and accomplish the extra mile to make things happen. To offer a bit of context information, although LLVM abstracts the target machine and architecture, there is a substantial difference on how to code exception handling in Windows vs. any other platform, if you are willing to dig intro LLVM you can read more about exception handling [here](https://llvm.org/docs/ExceptionHandling.html#wineh).

# Changelog format

This is the second release in which we are trying to improve the format of the changelog. It should be easier to read and depict changes in areas of interest. So, don't miss the rest of the [release changelog](https://github.com/crystal-lang/crystal/releases/tag/0.26.0) information with lots of valuable information.

# Next step

Please update your Crystal and report any issues. If there are regression or blocking issues with 0.26.0, a 0.26.1 could be released earlier.

> **THANKS:**
> The development is possible thanks to the community's effort, [84codes](https://www.84codes.com/)' support, and every [BountySource supporter](https://crystal-lang.org/sponsors).
