---
title: Crystal 0.25.1 released!
version: 0.25.1
summary: Crystal has a new development release.
thumbnail: +
author: bcardiff
---

[Crystal 0.25.1](https://github.com/crystal-lang/crystal/releases/tag/0.25.1) has been released!

Although there are a couple of new features, this release is focused on polishing and fixing some regressions introduced by 0.25.0. There were [40 commits since 0.25.0](https://github.com/crystal-lang/crystal/compare/0.25.0...0.25.1) by 18 contributors.

# Shards is updated to 0.8.1

The global cache introduced in 0.8.0 had some regressions, so an updated version was required.
Did you know that shards can be checked out, hacked around, compiled and used like any other console application? Don't forget to check [it's repo](https://github.com/crystal-lang/shards) to see other code bases that help Crystal move forward.

Read more [here](https://github.com/crystal-lang/shards/releases/tag/v0.8.1).

# Breaking changes

None! (we hope)

# Standard library

There were a couple of edge cases fixed, documentation improvements and some features added.

## For the `record`

The `record` macro now generates a `#copy_with` method that would simplify creating a copy of the struct with some changed values.

```ruby
record Point, x = 0, y = 0

p = Point.new y: 2 # => #<Point(@x=0, @y=2)>
p.copy_with x: 3   # => #<Point(@x=3, @y=2)>
p                  # => #<Point(@x=0, @y=2)>
```

Read more [here](https://github.com/crystal-lang/crystal/pull/5736).

## Refinements in `JSON::Any` and `YAML::Any`

These wrapper structures are very handy but sometimes they cause a bit of confusion.

For example, with the inherited default `#dup`, the result and the receiver would share a reference to the same inner value. Wrapper's identity is rarely more important than the inner value's identity. So having `#dup` (and `#clone`) on the wrapper to actually perform the operation on the inner value makes a bit more sense.

Read more [here](https://github.com/crystal-lang/crystal/pull/6266).

## Improve `HTTP::StaticFileHandler` with ETag

In case you didn't know, there are headers that help `HTTP` communications to avoid sending too much data if the client already has it. The `HTTP::StaticFileHandler` keeps and will keep learning about them.

Read more [here](https://github.com/crystal-lang/crystal/pull/6145).

# Next step

Please update your Crystal and report any issues. If there are regression or blocking issues with 0.25.1, a 0.25.2 could be released earlier.

Don't miss the rest of the [release changelog](https://github.com/crystal-lang/crystal/releases/tag/0.25.1), it’s packed with information about lots of other fixes.

We made progress towards allowing safer arithmetic operations with overflow. On the following releases that should start to land in the compiler. If you are interested in the topic, check this [PR](https://github.com/crystal-lang/crystal/pull/6223).

> **THANKS:**
> The development is possible thanks to the community's effort, [84codes](https://www.84codes.com/)' support, and every [BountySource supporter](https://crystal-lang.org/sponsors).
