---
title: Crystal 0.24.1 released!
version: 0.24.1
summary: Crystal has a new development release.
thumbnail: +
author: straight-shoota
---

[Crystal 0.24.1](https://github.com/crystal-lang/crystal/releases/tag/0.24.1) has been released!

As any release it includes numerous bugfixes, cool features and performance improvements - in [387 commits since 0.23.1](https://github.com/crystal-lang/crystal/compare/0.23.1...0.24.1).

0.24.0 was a preview release so this is the canonical realease following 0.23.1.

# Exciting Changes

* Added `ThinLTO` support for LLVM 4.0 and above, which speeds up release builds. It can be activated using the compiler option `--lto=thin`.
* **(breaking-change)** `SecureRandom` is renamed to `Random::Secure` and `SecureRandom.uuid` is replaced by a new `UUID` type, created using `UUID.random`.
* `BigDecimal` was added, it offers arbitrary precision, exact decimal numbers. Supplementing `BigInt` and `BigFloat` with all three being included using `require "big"`.
* `Set` instances can now be used as condition for `case`, matching when the case variable is included in the set.
* **(breaking-change)** `Time::Format` more robustly supports parsing sub-second precision.
* `Tempfile` now supports custom extensions.
* The docs generator outputs documentation as JSON which can be easily parsed and used for external applications. The output directory of the docs generator can be configured using `--output` flag.
* Garbage collection can be disabled using compiler flag `-Dgc_none`.
* The default hash function uses an algorithm based on FunnyHash which is resiliant against DoS attacks.
* **(breaking-change)** `HTML.escape` only escapes HTML special characters `&<>"'`. `HTML.escape` recognizes all HTML5 named entities.
* **(breaking-change)** Multiple assignment can no longer be used to create an array (`a = 1, 2, 3`).
* **(breaking-change)** `skip` macro method was renamed to `skip_file`.
* `rescue`, `ensure` and `else` blocks can be used directly in `do ...end` blocks.

```ruby
%w(foo bar).each do |x|
  raise x
rescue e
  p e
end
```

* `fun` names and lib function calls can now start with uppercase.
* YAML 1.1 core schema is now fully supported.
* `Time` and `Time::Span` have nanosecond precision.
* `Time.monotonic` and `Time.measure { ... }` allow reading and measuring time using a monotonic clock not influences by time zones, leap seconds and time corrections.
* `Crystal.main` was added to allow more easily redefining the `main` of a program.
* Named tuples can be merged using `NamedTuple#merge(other : NamedTuple)`.
* `YAML` and `JSON` mappings support `presence: true` option.
* `Dir` has two new class methods: `children` and `each_child { ... }` which include all entries except `.` and `..`.

# Other Breaking Changes

* **(breaking-change)** `HTTP::Client#post_form` is now `HTTP::Client.post(form: ...)`
* **(breaking-change)** `Array#reject!`, `Array#compact!` and `Array#select!` now return `self`
* **(breaking-change)** Remove the possibility to require `big_int`, `big_float` or `big_rational` individually: use `require \"big\"` instead
* **(breaking-change)** Spec: remove `expect_raises` without type argument
* **(breaking-change)** `IO` is now a class, no longer a module
* **(breaking-change)** Time constructors now have `nanosecond` and `kind` as named argument
* **(breaking-change)** Removed `XML.escape`. Use `HTML.escape` instead
* **(breaking-change)** Removed `macro def`
* **(breaking-change)** To define a custom `hash` method you must now define `hash(hasher)`
* **(breaking-change)** `Flate::Reader.new(&block)` and `Flate::Writer.new(&block)` now use the name `open`
* **(breaking-change)** Use an Enum for Process stdio redirections
* **(breaking-change)** Remove '$0' special syntax
* **(breaking-change)** `StaticArray#map` and `Slice#map` now return their same type instead of `Array`
* **(breaking-change)** `Tuple#map_with_index` now returns a Tuple.

Thanks to everyone who supported this release through contributions, reviews and suggestions.

* [CHANGELOG](https://github.com/crystal-lang/crystal/releases/tag/0.24.1)
* [API Docs](https://crystal-lang.org/api/0.24.1)
* [Milestone 0.24.1](https://github.com/crystal-lang/crystal/issues?q=milestone%3A0.24.1)
