---
title: Crystal 0.20.4 released!
version: 0.20.4
summary: Crystal has a new development release.
thumbnail: +
author: straight-shoota
---

[Crystal 0.20.4](https://github.com/crystal-lang/crystal/releases/tag/0.20.4) has been released!

As any release it includes numerous bugfixes, cool features and performance improvements - in [87 commits since 0.20.3](https://github.com/crystal-lang/crystal/compare/0.20.3...0.20.4).

# Exciting Changes

* **(breaking change)** `YAML::Emitter` was renamed to `YAML::Builder`, and some of its methods were also renamed. It can now used for any YAML serialization using `YAML.build`.
* **(breaking change)** `to_json` methods now receives a `JSON::Builder` instead of an `IO`. It can now used for any YAML serialization using `JSON.build`. If you are using `JSON.mapping` then your code will continue to work without changes.
* `XML::Builder` allows to serialize XML format using `XML.build`.
* **(breaking change)**`MemoryIO` was removed in favour of `IO::Memory`.
* `with ... yield` now works well with `method_missing`.
* Class variables can now be used in generic types (all generic instances share the same variable, and subclasses get their own copy, as usual).
* Added support for LLVM 4.

# Other Breaking Changes

* **(breaking change)** Defining a `finalize` method on a struct now gives a compile error
* **(breaking change)** Default argument types now must match their restriction, if any (for example `def foo(x : Int32 = nil)` will now fail to compile if `foo` is invoked without arguments) (thanks @MakeNowJust)
* **(breaking change)** `each` methods now return `Nil`
* **(breaking change)** `IO#skip(bytes)` will now raise if there aren't at least the given amount of bytes in the `IO` (previously it would work well if there were less bytes, and it would hang if there were more)
* **(breaking change)** `Number#step` now requires named arguments, `to` and `by`, to avoid argument order confusion
* **(breaking change)** `XML::Node#[]` now always returns a `String` (previously it could also return `Nil`, which was incorrect)
* **(breaking change)** `XML::Node#content` now returns an empty `String` when no content is available

Thanks to everyone who supported this release through contributions, reviews and suggestions.

* [CHANGELOG](https://github.com/crystal-lang/crystal/releases/tag/0.20.4)
* [API Docs](https://crystal-lang.org/api/0.20.4)
* [Milestone 0.20.4](https://github.com/crystal-lang/crystal/issues?q=milestone%3A0.20.4)
