---
title: Crystal 0.20.1 released!
version: 0.20.1
summary: Crystal has a new development release.
thumbnail: +
author: straight-shoota
---

[Crystal 0.20.1](https://github.com/crystal-lang/crystal/releases/tag/0.20.1) has been released!

As any release it includes numerous bugfixes, cool features and performance improvements - in [75 commits since 0.20.0](https://github.com/crystal-lang/crystal/compare/0.20.0...0.20.1).

# Exciting Changes

* `p` and `pp` now use pretty printing.
* `finished` macro hook was added. It places it's contents at the end of the program when all other types and methods are known.

```ruby
class MyModel
  MAPPING = {
    id: Int32
  }

  macro extra_attributes(**values)
    {{- "{%" }} for key, value in values %}
      {{- "{%" }} MAPPING[key] = value %}
    {{- "{%" }} end %}
  end

  macro finished
    JSON.mapping({{ "{{" }}MAPPING}})
  end
end

class MyModel
  extra_attributes name: String, foo: Bool
end

# JSON mapping will have attribute id, name and foo.
```

* Local variables can now have type restrictions.
* `method_missing` hook can now define a method, this allows it to control whether it captures a block (see [PR #3610](https://github.com/crystal-lang/crystal/pull/3610))

```ruby
class Foo
  def add(method, &block : -> U) forall U
    puts "added #{method} #{block}"
  end

  macro method_missing(call)
    def {{ "{{" }}call.name}}(&block : -> U) forall U
      add({{ "{{" }}call.name.stringify}}, &block)
    end
  end
end

Foo.new.foo { 1 } # => added foo #<Proc(Int32):0x1063173a0>
Foo.new.bar { 2 } # => added bar #<Proc(Int32):0x1063173b0>
```

# Other Breaking Changes
* **(breaking change)** `Set#merge` as renamed to `Set#merge!`
* **(breaking change)** `Slice.new(size)` no longer works with non primitive integers and floats
* **(breaking change)** The macro method `argify` was renamed to `splat`

Thanks to everyone who supported this release through contributions, reviews and suggestions.

* [CHANGELOG](https://github.com/crystal-lang/crystal/releases/tag/0.20.1)
* [API Docs](https://crystal-lang.org/api/0.20.1)
* [Milestone 0.20.1](https://github.com/crystal-lang/crystal/issues?q=milestone%3A0.20.1)
