---
title: Crystal 0.14.1 released!
version: 0.14.1
summary: Playground!
thumbnail: +
author: asterite
---

[Crystal 0.14.1](https://github.com/crystal-lang/crystal/releases/tag/0.14.1) has been released!

The major feature is a built-in playground made by [@bcardiff](http://github.com/bcardiff).

## The Playground

The new playground is an excellent way to try ideas, test code, understand its execution,
and teach Crystal to others.

You start the playground like this:

<pre class="code">
$ crystal play
Listening on http://localhost:8080
</pre>

You then open your browser at `http://localhost:8080/` and you will be presented with a screen like this:

![](/assets/playground/main.png)

You write code on the left pane, and after you stop typing it will compile and execute it.

Every expression's value will be shown on the right pane, and if the program has output it is
shown in a bottom pane you can show by clicking the icon below the right pane.

![](/assets/playground/output.png)

If an expression is executed multiple times, the right pane will show how many times it was
executed, and clicking on that it will open a table with all values.

![](/assets/playground/times.png)

![](/assets/playground/times_table.png)

If you use a tuple as an expression, the table will show a column for each of this values.
In this way you can quickly see the relationship between multiple values in every iteration.

![](/assets/playground/tuple.png)

![](/assets/playground/tuple_table.png)

The right pane reacts "live" to code execution. For example if you use `sleep 1.second` inside
a loop you will see values appearing every second.

The playground has access to the whole standard library, so you can use things like http clients
and servers in it. You can also `require` files that are provided by `shards` you mention in
your `shards.yml` file, so you can play with that code too.

You can find more examples and use cases in the About section at the top right corner. You can also
adjust a couple of settings, like whether to automatically compile code or not, and easily share it as a gist.

### Implementation

When you execute `crystal play` an http server is started. When you use the playground,
it connects to that http server via a websocket, and code you type is sent through it.

You can see what the server does with your code if you start the playground with `crystal play --verbose`.

For example, if you type this code:

```ruby
a = 1
b = a + 2
```

The console will show this output:

<pre class="code">
I, [2016-03-21 14:55:17 -0300 #2379]  INFO -- : /client WebSocket connected as session=1
I, [2016-03-21 14:55:17 -0300 #2379]  INFO -- : Request to run code (session=1, tag=1).
a = 1
b = a + 2
I, [2016-03-21 14:55:17 -0300 #2379]  INFO -- : Code instrumentation (session=1, tag=1).
a = $p.i(1, 1)
b = $p.i(a + 2, 2)

I, [2016-03-21 14:55:17 -0300 #2379]  INFO -- : Instrumented code compilation started ...
I, [2016-03-21 14:55:18 -0300 #2379]  INFO -- : Code execution started (session=1, tag=1, ...
I, [2016-03-21 14:55:18 -0300 #2379]  INFO -- : /agent/1/1 WebSocket connected (session=1, ...
I, [2016-03-21 14:55:18 -0300 #2379]  INFO -- : Code execution ended (session=1, tag=1, ...
</pre>

Some lines in your code are transformed to doing `$p.i(...)`. `$p` is initialized
to a class that will send that data over the websocket, together with line number
information, and will finally appear on the right pane.

Thanks to the fact the the compiler is written in Crystal and it provides APIs to transform
AST nodes, and the standard library provides http server and websockets implementation, the resulting
playground implementation is about 600 lines of Crystal code. The other half is made with javascript
and HTML.

As the screenshots say: Happy Crystalling ♥
