---
title: Crystal 0.12.0 released!
version: 0.12.0
summary: Encoding support
thumbnail: +
author: asterite
---

[Crystal 0.12.0](https://github.com/crystal-lang/crystal/releases/tag/0.12.0) has been released!

The major feature of this release is IO encoding support.

Strings in Crystal always denote UTF-8 encoded characters. Before this release, if you
read a file whose encoding wasn't UTF-8 the String ended with invalid byte sequences,
and there was no way to specify the encoding.

Now you can do it, both for writing and reading. For example, to read a file encoded in,
say, GB2312, you do:

```ruby
File.read("file.txt", encoding: "GB2312")
```

The encoding can be set on all IOs (files, sockets, pipes, memory):

```ruby
# Write a string encoded in GB2312 in memory
io = MemoryIO.new
io.set_encoding "GB2312"
io.print "你好"

# See the resulting bytes
io.rewind
puts io.to_slice # => [196, 227, 186, 195]
```

Additionally, HTTP::Client will use the charset specified in the Content-Type header so you
can now fetch non-UTF-8 web sites.
