---
title: Crystal 0.7.0 released!
version: 0.7.0
summary: Non-blocking IO
thumbnail: +
author: asterite
---

[Crystal 0.7.0](https://github.com/crystal-lang/crystal/releases/tag/0.7.0) has been released!

This is a huge, non-backwards compatible release that introduces two big features:

<ul class="goals" style="padding-bottom:20px">
  <li>Non-blocking IO, coupled with lightweight processes and channels</li>
  <li>Iterators</li>
</ul>

This release also contains numerous bug fixes, performance improvements and enhacements.

Please note that this is an experimental release: the change to non-blocking IO probably breaks
some programs out there. We need your help to continue building this API, fix what's not working
and add what's missing. But we strongly believe this is the direction we want to follow, as programming
with `spawn` and channels is very easy, intuitive and efficient.

An explanation of these two features will come soon, together with documentation. But, basically,
non-blocking IO, lightweight processes and channels work in a very similar way to how Go works. And
Iterators work in a similar way to Ruby's Enumerator, at least semantically (internally they are
implemented in a different way).

Right now we are busy preparing a great talk for [Curry On](http://curry-on.org/), we are thrilled
to have been selected! You can see the detailed abstract of the talk
[here](http://2015.ecoop.org/event/curryon-crystal-a-programming-language-for-humans-and-computers).

We would love to see you there!
