---
title: Crystal 0.6.0 released!
version: 0.6.0
summary: Thread-safe magic
thumbnail: +
author: asterite
---

[Crystal 0.6.0](https://github.com/crystal-lang/crystal/releases/tag/0.6.0) has been released!

This release contains several fixes to the language as a whole.

### Renames, and class/struct distinction

`Function` was renamed to `Proc`, to match Ruby's name, but also because it's not just a
function: it can have an associated closure context, so the new name reflects that better.
It's also shorter to write.

`Pointer` and `Tuple` are now considered structs by the compiler, so to reopen them you
must do `struct Pointer; ...; end`. This doesn't change anything, really, but makes everything
be consistent: structs are passed by value, classes are passed by reference. Both `Pointer`
and `Tuple` are passed by value, so it makes sense for them to be structs.

### Thread-safe magic variabels

Crystal retains a few magic variables from Ruby: `$~` (and the associated `$1`, `$2`, ... variables) and `$?`.
Although they are magical and might look cryptic at first, once you learn them they become a valuable tool
for writing short, readable code.

Before this release these variables were global, meaning that they were also not thread-safe. Starting
from this release they are method-local, defined by, for example, `String#=~` and `Regex#===`. You
can read the details of the implementation [here](https://github.com/crystal-lang/crystal/issues/323#issuecomment-74005729).

Happy hacking! :-)
