---
title: Crystal 0.5.9 released!
version: 0.5.9
summary: The community grows
thumbnail: +
author: asterite
---

[Crystal 0.5.9](https://github.com/crystal-lang/crystal/releases/tag/0.5.9) has been released!

This release has seen unprecedented contributions, both to the standard library and to the language itself.

For starters, [ysbaddaden](https://github.com/ysbaddaden) rewrote the entire `Socket` hierarchy,
also adding classes like `UDPSocket` and `UNIXSocket`, by having a very similar API to that of Ruby.
His contributions came from a working project he has, [prax.cr](https://github.com/ysbaddaden/prax.cr), which is
a port of [prax](https://github.com/ysbaddaden/prax), which is a pure Ruby alternative to [Pow](http://pow.cx/).

He has also added a `Logger` class, again with an API similar to that of Ruby.

Then [jhass](https://github.com/jhass) sent lots of contributions to the standard libraries, with methods
like `IO.select`, `Enumerable#max_of`, `String#[Regex]`, `String#count`, `String#delete` and `String#squeeze`.
His contributions came from a working project he has [DeBot](https://github.com/jhass/DeBot), which is an
IRC bot written in pure Crystal, ported from a Ruby version he also wrote. This bot is now being used
in our IRC channel: you send ">> 1 + 2" and DeBot replies with "3".

He's also always testing Crystal's limits and sends lots of bug reports and improvements suggestions, which
continue making the language more solid, stable and consistent.

Then [zamith](https://github.com/zamith) has enhanced array literals of strings:

```ruby
%w(one two three) #=> ["one", "two", "three"]

# But these ones didn't work before 0.5.9
%w<one two three>
%w{one two three}
%w[one two three]
```

He also wrote a website [in pure Crystal](https://github.com/zamith/crystalshards),
named ~~[crystal shards](https://crystalshards.herokuapp.com/)~~, hosted on [Heroku](https://github.com/zamith/heroku-buildpack-crystal),
that lists Crystal projects on GitHub. We didn't settle on this name yet for Crystal packages,
but it's a possibility.

Then [naps62](https://github.com/naps62) added the "path" option to include dependencies:

```ruby
deps do
  path "../some_project"
end
```

We are overwhelmed by this amount of contributions and amazing projects that are starting to appear. Most of these
projects are something that we didn't think was even possible to do at this moment, given how young the language is.
Again, a big thank you to all of you!

Another notable feature added is the ability to invoke `to_s` on a C struct or union, making debugging
C bindings much more easier.

Happy hacking! :-)
